/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.account.IAccountRefContrast;
import com.kingdee.eas.basedata.master.account.RefTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.DirectionEnum;
import com.kingdee.eas.fi.cas.ICashManagement;
import com.kingdee.eas.fi.cas.IInnerCashFacade;
import com.kingdee.eas.fi.cas.InnerCashFacadeFactory;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.utils.BankJournalWebUtil;
import com.kingdee.eas.fi.cas.utils.JournalWebUtil;
import com.kingdee.eas.fi.cas.web.param.CasWorkPlatfromBCJournalParam;
import com.kingdee.eas.fi.cas.web.param.FetchAccTableParam;
import com.kingdee.eas.fi.cas.web.param.QueryTable;
import com.kingdee.eas.fi.cas.web.param.QueryTableRow;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class CasWorkPlatfromCashJournalUtil {
    private static final Logger logger = Logger.getLogger(CasWorkPlatfromCashJournalUtil.class);
    private static final Map periodCache = new ConcurrentHashMap();
    protected static final String COL_SETTNUMBER = "settlementNumber";
    protected static final String COL_SETTTYPE = "settlementType";
    protected static final String COL_DC = "dc";
    protected static final String COL_PERIOD = "period";
    protected static final String COL_YEAR = "year";
    protected static final String COL_SOURCE = "source";
    protected static final String COL_CASHIER = "cashier_name";
    protected static final String COL_BALANCE = "balance";
    protected static final String COL_CREDIT = "creditAmount";
    protected static final String COL_DEBIT = "debitAmount";
    protected static final String COL_DESCRIPTION = "description";
    protected static final String COL_BILLNUMBER = "billNumber";
    protected static final String COL_BILLTYPE = "billType";
    protected static final String COL_OPPACCOUNTNUMBER = "oppAccountNumber";
    protected static final String COL_VOUCHERNUMBER = "voucherNumber";
    protected static final String COL_VOUCHERTYPE = "voucherType";
    protected static final String COL_BIZDATE = "bizDate";
    protected static final String COL_ID = "id";
    protected static final String COL_COMPANY = "company_name";
    protected static final String COL_COMPANY_ID = "company_id";
    protected static final String CREDIT_AMOUNT = "creditAmount";
    protected static final String DEBIT_AMOUNT = "debitAmount";
    protected static final String PERIOD_NUMBER = "periodnumber";
    protected static final String PERIOD_YEAR = "periodyear";
    protected static final String COL_CREATE_DATE = "createDate";
    protected static final String COL_LOCAL_BALANCE = "localBalance";
    protected static final String COL_LOCAL_CREDIT = "localCredit";
    protected static final String COL_LOCAL_DEBIT = "localDebit";
    protected static final String COL_EXCHANGE = "exchange";
    private static final String resourcePath = "com.kingdee.eas.fi.cas.JournalResource";

    public static PeriodInfo getCurrentPeriod(Context ctx, SystemEnum SystemName, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemName, (CompanyOrgUnitInfo)company);
    }

    public static PeriodInfo getCurrentPeriod(Context ctx, SystemEnum SystemName, String companyId) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemName, (IObjectPK)new ObjectUuidPK(companyId));
    }

    public static String getActualAcctTable(Context ctx, String companyId, Date beginDate, Date endDate) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = null;
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        AccountRefContrastCollection coll = CasWorkPlatfromCashJournalUtil.getStrideAcctRefContrastColl(ctx, companyId, beginDate, endDate);
        if (coll == null || coll.isEmpty()) {
            PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)endDate, (CompanyOrgUnitInfo)company);
            if (period == null) {
                throw new BOSException(EASCommonResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"26_FMClientHelper", (Locale)ctx.getLocale()));
            }
            int yearNumber = period.getPeriodYear();
            int monthNumber = period.getPeriodNumber();
            AccountTableInfo tbl = company.getAccountTable();
            String currTableId = AccountTools.getCurrentAcctTable((Context)ctx, (String)companyId, (String)tbl.getId().toString(), (int)yearNumber, (int)monthNumber);
            return currTableId;
        }
        if (null != coll && coll.get(0).getRefType() == RefTypeEnum.BOOKS) {
            return coll.get(0).getEnabledAcctTable().getId().toString();
        }
        return null;
    }

    public static String getPeriodCollSQL(String periodTypeId, int beginYear, int beginMonth, int endYear, int endMonth) {
        StringBuffer sb = new StringBuffer();
        sb.append("select fid from t_bd_period A ");
        sb.append(" where A.FPERIODYEAR*100 + A.FPERIODNUMBER >=");
        sb.append(beginYear * 100 + beginMonth);
        sb.append(" and A.FPERIODYEAR*100 + A.FPERIODNUMBER  <=");
        sb.append(endYear * 100 + endMonth);
        sb.append(" and A.FTypeID='");
        sb.append(periodTypeId);
        sb.append("'");
        return sb.toString();
    }

    public static String getActualAcctTable(Context ctx, String companyId, int beginYear, int beginMonth, int endYear, int endMonth) throws EASBizException, BOSException {
        PeriodInfo beginPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (int)beginYear, (int)beginMonth, (IObjectPK)new ObjectUuidPK(companyId));
        PeriodInfo endPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (int)endYear, (int)endMonth, (IObjectPK)new ObjectUuidPK(companyId));
        return CasWorkPlatfromCashJournalUtil.getActualAcctTable(ctx, companyId, beginPeriod.getBeginDate(), endPeriod.getEndDate());
    }

    public static String getAcctTableID(Context ctx, CasWorkPlatfromBCJournalParam param) throws EASBizException, BOSException {
        String acctTableId = null;
        if (param.isByDay()) {
            Date beginDate = param.getFromDate();
            Date endDate = param.getToDate();
            acctTableId = CasWorkPlatfromCashJournalUtil.getActualAcctTable(ctx, param.getCompanyId(), beginDate, endDate);
        } else {
            int beginYear = param.getBeginYear();
            int beginMonth = param.getBeginMonth();
            int endYear = param.getEndYear();
            int endMonth = param.getEndMonth();
            acctTableId = CasWorkPlatfromCashJournalUtil.getActualAcctTable(ctx, param.getCompanyId(), beginYear, beginMonth, endYear, endMonth);
        }
        return acctTableId;
    }

    public static PeriodInfo getStartPeriod(Context ctx, SystemEnum SystemName, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
    }

    public static PeriodCollection getPeriodc(Context ctx, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        evi.getSorter().add(new SorterItemInfo("periodYear"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc == null || periodc.size() == 0) {
            return null;
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)companyInfo)) {
            return periodc;
        }
        PeriodInfo startPeriod = CasWorkPlatfromCashJournalUtil.getStartPeriodInfo(ctx, companyInfo);
        PeriodCollection rsltCols = new PeriodCollection();
        int n = periodc.size();
        for (int i = 0; i < n; ++i) {
            PeriodInfo periodInfo = periodc.get(i);
            if (!CasWorkPlatfromCashJournalUtil.isAfterStartPeriod(startPeriod, periodInfo)) continue;
            rsltCols.add(periodInfo);
        }
        return rsltCols;
    }

    public static boolean isAfterStartPeriod(PeriodInfo startPeriod, PeriodInfo periodInfo) {
        if (startPeriod == null || periodInfo == null) {
            return false;
        }
        if (startPeriod.getPeriodYear() < periodInfo.getPeriodYear()) {
            return true;
        }
        return startPeriod.getPeriodYear() == periodInfo.getPeriodYear() && startPeriod.getPeriodNumber() <= periodInfo.getPeriodNumber();
    }

    public static PeriodInfo getStartPeriodInfo(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        PeriodInfo startPeriod = null;
        startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        return startPeriod;
    }

    public static TreeMap getYearPeriod(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        TreeMap<Integer, PeriodCollection> result = new TreeMap<Integer, PeriodCollection>();
        PeriodCollection pc = CasWorkPlatfromCashJournalUtil.getPeriodc(ctx, companyInfo);
        for (PeriodInfo pi : pc) {
            PeriodCollection tmpPc;
            Integer year = new Integer(pi.getPeriodYear());
            if (!result.containsKey(year)) {
                tmpPc = new PeriodCollection();
                tmpPc.add(pi);
                result.put(year, tmpPc);
                continue;
            }
            tmpPc = (PeriodCollection)result.get(year);
            tmpPc.add(pi);
        }
        return result;
    }

    public static PeriodInfo getPeriodInfo(Context ctx, Date date, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        TreeMap yearMap;
        PeriodCollection pc;
        Calendar cal = Calendar.getInstance();
        Date sourceDate = DateTimeUtils.truncateDate((Date)date);
        cal.setTime(date);
        int year = cal.get(1);
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (periodCache == null || !periodCache.containsKey(companyPK)) {
            CasWorkPlatfromCashJournalUtil.cachePeriod(ctx, companyInfo);
        }
        if ((pc = (PeriodCollection)(yearMap = (TreeMap)periodCache.get(companyPK)).get(new Integer(year))) == null) {
            return null;
        }
        PeriodInfo periodInfo = null;
        for (int i = 0; i < pc.size(); ++i) {
            periodInfo = pc.get(i);
            Date beginDate = periodInfo.getBeginDate();
            Date endDate = DateTimeUtils.truncateDate((Date)periodInfo.getEndDate());
            if ((!beginDate.before(sourceDate) || !endDate.after(sourceDate)) && !beginDate.equals(sourceDate) && !endDate.equals(sourceDate)) continue;
            return periodInfo;
        }
        return null;
    }

    public static PeriodInfo getLastPeriodInfo(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        int end;
        TreeMap yearMap;
        PeriodCollection pc;
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (periodCache == null || !periodCache.containsKey(companyPK)) {
            CasWorkPlatfromCashJournalUtil.cachePeriod(ctx, companyInfo);
        }
        if ((pc = (PeriodCollection)(yearMap = (TreeMap)periodCache.get(companyPK)).get(new Integer(end = ((Integer)yearMap.lastKey()).intValue()))) == null) {
            return null;
        }
        return pc.get(pc.size() - 1);
    }

    public static BigDecimal getCashMonthStartAmt(Context ctx, String acctTableNum, String companyId, String accountNum, String currencyNum, String periodId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FMonthStartAmt SubResult from T_CAS_JournalBalance where ");
        sql.append("FIsInit =0  and ");
        sql.append("FCompanyId='").append(companyId).append("' and FCurrencyId in(").append("select fid from t_bd_currency where FNumber = '").append(currencyNum).append("') and FPeriodId='").append(periodId).append("'");
        sql.append(" and FType= 1");
        if (accountNum != null && accountNum.length() > 0) {
            sql.append(" and FAccountViewId in (").append("select fid from t_bd_accountview where FIsLeaf = 1 and FIsCash = 1 and FCompanyID='").append(companyId).append("' and FNumber = '").append(accountNum.trim()).append("' and FAccountTableID in(select fid from t_bd_accountTable where FNumber = '").append(acctTableNum).append("'))");
        }
        ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString());
        IRowSet rs = null;
        rs = exec.executeSQL();
        try {
            if (rs != null && rs.next()) {
                return rs.getBigDecimal("SubResult");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return Constants.ZERO;
    }

    public static BigDecimal getBankMonthStartAmt(Context ctx, String acctTableNum, String companyId, String accountBankNum, String accountNum, String currencyNum, String periodId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FMonthStartAmt SubResult from T_CAS_JournalBalance where ");
        sql.append("FIsInit =0  and ");
        sql.append("FCompanyId='").append(companyId).append("' and FCurrencyId in(").append("select fid from t_bd_currency where FNumber = '").append(currencyNum).append("') and FPeriodId='").append(periodId).append("'");
        sql.append(" and FAccountBankId in(").append("select fid from t_bd_accountbanks where fnumber='").append(accountBankNum).append("'").append(" and fcompanyid='").append(companyId).append("')");
        sql.append(" and FType= 2");
        if (accountNum != null && accountNum.length() > 0) {
            sql.append(" and FAccountViewId in (").append("select fid from t_bd_accountview where FIsLeaf = 1 and FIsBank = 1 and FCompanyID='").append(companyId).append("' and FNumber = '").append(accountNum.trim()).append("' and FAccountTableID in(select fid from t_bd_accountTable where FNumber = '").append(acctTableNum).append("'))");
        }
        ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString());
        IRowSet rs = null;
        boolean result = false;
        try {
            rs = exec.executeSQL();
            if (rs != null && rs.next()) {
                return rs.getBigDecimal("SubResult");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return FMConstants.ZERO;
    }

    public static BigDecimal getBeginBalance(Context ctx, CompanyOrgUnitInfo companyInfo, String accountTableNumber, String currencyNumber, String accountNumber, String accountBankNumber, Date beginDate, CashDataSourceEnum dateType, boolean isAdjustPeriod) throws EASBizException, BOSException {
        String lastDayAcctTableNumber;
        Date previousDate = beginDate;
        PeriodInfo previousPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)previousDate, (CompanyOrgUnitInfo)companyInfo);
        if (!isAdjustPeriod) {
            previousDate = DateHelper.getBeforeDay((Date)previousDate);
            previousPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)previousDate, (CompanyOrgUnitInfo)companyInfo);
        }
        if (previousPeriod == null) {
            PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)beginDate, (CompanyOrgUnitInfo)companyInfo);
            if (accountBankNumber == null) {
                return CasWorkPlatfromCashJournalUtil.getCashMonthStartAmt(ctx, accountTableNumber, companyInfo.getId().toString(), accountNumber, currencyNumber, period.getId().toString());
            }
            return CasWorkPlatfromCashJournalUtil.getBankMonthStartAmt(ctx, accountTableNumber, companyInfo.getId().toString(), accountBankNumber, accountNumber, currencyNumber, period.getId().toString());
        }
        IInnerCashFacade innerCashFacade = InnerCashFacadeFactory.getLocalInstance(ctx);
        String lastDayAcctTableid = innerCashFacade.getActualAcctTableID(companyInfo.getId().toString(), previousDate, previousDate);
        if (lastDayAcctTableid != null && !(lastDayAcctTableNumber = AccountTableFactory.getLocalInstance((Context)ctx).getAccountTableInfo((IObjectPK)new ObjectUuidPK(lastDayAcctTableid)).getNumber()).equals(accountTableNumber)) {
            PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)beginDate, (CompanyOrgUnitInfo)companyInfo);
            if (accountBankNumber == null) {
                return CasWorkPlatfromCashJournalUtil.getCashMonthStartAmt(ctx, accountTableNumber, companyInfo.getId().toString(), accountNumber, currencyNumber, period.getId().toString());
            }
            return CasWorkPlatfromCashJournalUtil.getBankMonthStartAmt(ctx, accountTableNumber, companyInfo.getId().toString(), accountBankNumber, accountNumber, currencyNumber, period.getId().toString());
        }
        ICashManagement cashInacct = CashManagementFactory.getLocalInstance(ctx);
        BigDecimal balance = null;
        balance = cashInacct.cash(companyInfo.getNumber(), dateType, accountTableNumber, accountNumber, accountBankNumber, currencyNumber, beginDate, beginDate, CashDataTypeEnum.C, false, isAdjustPeriod, false);
        return balance;
    }

    public static BigDecimal getBeginBalance(Context ctx, CompanyOrgUnitInfo companyInfo, String accountTableNumber, String currencyNumber, String accountNumber, String accountBankNumber, PeriodInfo period, CashDataSourceEnum dateType) throws EASBizException, BOSException {
        if (period.isIsAdjustPeriod()) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId()));
            filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.id", (Object)period.getId()));
            filter.getFilterItems().add(new FilterItemInfo("enabledAcctTable.number", (Object)accountTableNumber));
            IAccountRefContrast acctContrast = AccountRefContrastFactory.getLocalInstance((Context)ctx);
            if (acctContrast.exists(filter)) {
                return new BigDecimal("0");
            }
        }
        return CasWorkPlatfromCashJournalUtil.getBeginBalance(ctx, companyInfo, accountTableNumber, currencyNumber, accountNumber, accountBankNumber, period.getBeginDate(), dateType, period.isIsAdjustPeriod());
    }

    public static void cachePeriod(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        TreeMap<Integer, PeriodCollection> result = new TreeMap<Integer, PeriodCollection>();
        PeriodCollection pc = CasWorkPlatfromCashJournalUtil.getPeriodc(ctx, companyInfo);
        for (PeriodInfo pi : pc) {
            PeriodCollection tmpPc;
            Integer year = new Integer(pi.getPeriodYear());
            if (!result.containsKey(year)) {
                tmpPc = new PeriodCollection();
                tmpPc.add(pi);
                result.put(year, tmpPc);
                continue;
            }
            tmpPc = (PeriodCollection)result.get(year);
            tmpPc.add(pi);
        }
        periodCache.put(new ObjectUuidPK(companyInfo.getId()), result);
    }

    public static PeriodInfo getPrePeriodInfo(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo period) throws EASBizException, BOSException {
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (periodCache == null || !periodCache.containsKey(companyPK)) {
            CasWorkPlatfromCashJournalUtil.cachePeriod(ctx, companyInfo);
        }
        TreeMap yearMap = (TreeMap)periodCache.get(companyPK);
        PeriodCollection pc = null;
        if (period.getPeriodNumber() == 1) {
            pc = (PeriodCollection)yearMap.get(new Integer(period.getPeriodYear() - 1));
            if (pc != null && pc.size() > 0) {
                return pc.get(pc.size() - 1);
            }
        } else {
            pc = (PeriodCollection)yearMap.get(new Integer(period.getPeriodYear()));
        }
        if (pc == null) {
            return null;
        }
        PeriodInfo periodInfo = null;
        for (int i = 0; i < pc.size(); ++i) {
            periodInfo = pc.get(i);
            if (periodInfo.getPeriodYear() != period.getPeriodYear() || periodInfo.getPeriodNumber() != period.getPeriodNumber()) continue;
            if (i == 0) {
                return null;
            }
            return pc.get(i - 1);
        }
        return null;
    }

    public static BigDecimal getYearTotal(Context ctx, CompanyOrgUnitInfo companyInfo, String accountTableNumber, String currencyNumber, String accountNumber, String accountBankNumber, int year, int periodNumber, CashDataSourceEnum dateType, CashDataTypeEnum type) throws EASBizException, BOSException {
        ICashManagement cashInacct = CashManagementFactory.getLocalInstance(ctx);
        BigDecimal result = null;
        GregorianCalendar begincal = new GregorianCalendar(year, 0, 1);
        PeriodInfo endPeriod = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, year, periodNumber, companyInfo);
        if (endPeriod == null) {
            return CasConstants.ZERO;
        }
        if (endPeriod.isIsAdjustPeriod()) {
            AccountRefContrastInfo info;
            if (companyInfo.getAccountTable() == null) {
                companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
            }
            if ((info = AccountRefContrastFactory.getLocalInstance((Context)ctx).getLastAcctInfo(companyInfo.getId().toString(), companyInfo.getAccountTable().getId().toString(), year, periodNumber)).getEnabledPeriod() != null && info.getEnabledPeriod().getId().equals((Object)endPeriod.getId()) && accountTableNumber.equals(info.getEnabledAcctTable().getNumber())) {
                return CasConstants.ZERO;
            }
        }
        if ((endPeriod = CasWorkPlatfromCashJournalUtil.getPrePeriodInfo(ctx, companyInfo, endPeriod)) == null || endPeriod.getPeriodYear() != year) {
            return CasConstants.ZERO;
        }
        result = cashInacct.cash(companyInfo.getNumber(), dateType, accountTableNumber, accountNumber, accountBankNumber, currencyNumber, begincal.getTime(), endPeriod.getEndDate(), type, false);
        return result;
    }

    public static void fillBalance(Context ctx, QueryTableRow row, BigDecimal exchange, BigDecimal balance, boolean isCurEqualsBasecur, String description, Date beginDate, ConvertModeEnum convertMode, BalanceDirectionEnum dc, boolean GL_005) {
        BigDecimal localBalance = isCurEqualsBasecur ? balance : (convertMode.equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE) ? balance.multiply(exchange) : balance.divide(exchange, 4));
        DirectionEnum direction = balance.compareTo(CasConstants.ZERO) == 0 ? DirectionEnum.Balance : (balance.compareTo(CasConstants.ZERO) > 0 ? DirectionEnum.Debit : DirectionEnum.Credit);
        row.addCell(COL_DC, (Object)direction);
        row.addCell(COL_DESCRIPTION, description);
        if (!GL_005) {
            row.addCell(COL_LOCAL_BALANCE, localBalance.abs());
            row.addCell(COL_BALANCE, balance.abs());
        } else {
            if (dc != null && !dc.getAlias().equals(direction.getAlias()) && !direction.equals((Object)DirectionEnum.Balance)) {
                row.addCell(COL_DC).setValue((Object)DirectionEnum.getEnum(dc.getValue()));
            }
            row.addCell(COL_LOCAL_BALANCE).setValue(localBalance);
            row.addCell(COL_BALANCE).setValue(balance);
        }
        row.addCell(COL_CREATE_DATE).setValue(Constants.FORMAT_DAY.format(beginDate));
    }

    public static void fillBalance(Context ctx, CompanyOrgUnitInfo companyInfo, int year, int periodNumber, QueryTableRow tableRow, BigDecimal exchange, BigDecimal balance, boolean isCurEqualsBasecur, String description, ConvertModeEnum convertMode, BalanceDirectionEnum dc, boolean GL_005) throws EASBizException, BOSException {
        PeriodInfo period = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, year, periodNumber, companyInfo);
        Date beginDate = null;
        if (period != null) {
            beginDate = period.getBeginDate();
        }
        CasWorkPlatfromCashJournalUtil.fillBalance(ctx, tableRow, exchange, balance, isCurEqualsBasecur, description, beginDate, convertMode, dc, GL_005);
    }

    public static void fillAdjustRow_NewDay(Context ctx, BigDecimal monthDebitAmt, BigDecimal monthCreditAmt, BigDecimal yearDebitAmt, BigDecimal yearCreditAmt, QueryTable queryTable, boolean isShowBeginBalance, boolean isShowPeriodTotal, boolean isShowYearTotal, CompanyOrgUnitInfo companyInfo, boolean isCurEqualsBasecur, BigDecimal balance, PeriodInfo beginPeriodInfo, PeriodInfo endPeriodInfo, ConvertModeEnum convertMode, Date beginDay, Date endDay, CurrencyInfo sourceCurrency, BalanceDirectionEnum dc, boolean GL_005) throws BOSException, EASBizException {
        PeriodInfo temPeriodInfo = beginPeriodInfo;
        String DAY_BALANCE = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_DayStart", (Locale)ctx.getLocale());
        String PERIOD_TOTAL = EASCommonResource.getString((String)resourcePath, (String)"MonthTotal", (Locale)ctx.getLocale());
        String YEAR_TOTAL = EASCommonResource.getString((String)resourcePath, (String)"YearTotal", (Locale)ctx.getLocale());
        String YEAR_BALANCE = EASCommonResource.getString((String)resourcePath, (String)"YearBalance", (Locale)ctx.getLocale());
        if (beginPeriodInfo == null || endPeriodInfo == null) {
            return;
        }
        boolean first = true;
        while (temPeriodInfo.getPeriodYear() < endPeriodInfo.getPeriodYear() || temPeriodInfo.getPeriodYear() == endPeriodInfo.getPeriodYear() && endPeriodInfo.getPeriodNumber() >= temPeriodInfo.getPeriodNumber()) {
            PeriodInfo temNextPeriodInfo;
            BigDecimal exchange;
            Date tempDate;
            QueryTableRow tableRow;
            if (isShowBeginBalance) {
                tableRow = queryTable.addRow();
                PeriodInfo period = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), companyInfo);
                Timestamp tempDate2 = period.getEndDate();
                BigDecimal exchange2 = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, tempDate2);
                if (first) {
                    CasWorkPlatfromCashJournalUtil.fillBalance(ctx, tableRow, exchange2, balance, isCurEqualsBasecur, DAY_BALANCE, beginDay, convertMode, dc, GL_005);
                } else {
                    CasWorkPlatfromCashJournalUtil.fillBalance(ctx, companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), tableRow, exchange2, balance, isCurEqualsBasecur, DAY_BALANCE, convertMode, dc, GL_005);
                }
                first = false;
            }
            if (isShowPeriodTotal) {
                tableRow = queryTable.addRow();
                tempDate = temPeriodInfo.getEndDate();
                exchange = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, tempDate);
                if (temPeriodInfo.getEndDate().compareTo(new Timestamp(endDay.getTime())) < 0) {
                    CasWorkPlatfromCashJournalUtil.fillTotal(ctx, companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), temPeriodInfo.getEndDate(), tableRow, exchange, monthDebitAmt, monthCreditAmt, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc, GL_005);
                } else {
                    CasWorkPlatfromCashJournalUtil.fillTotal(ctx, companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), endDay, tableRow, exchange, monthDebitAmt, monthCreditAmt, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc, GL_005);
                }
                monthDebitAmt = Constants.ZERO;
                monthCreditAmt = Constants.ZERO;
            }
            if (isShowYearTotal) {
                tableRow = queryTable.addRow();
                tempDate = temPeriodInfo.getEndDate();
                exchange = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, tempDate);
                if (temPeriodInfo.getEndDate().compareTo(new Timestamp(endDay.getTime())) < 0) {
                    CasWorkPlatfromCashJournalUtil.fillTotal(ctx, companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), temPeriodInfo.getEndDate(), tableRow, exchange, yearDebitAmt, yearCreditAmt, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc, GL_005);
                } else {
                    CasWorkPlatfromCashJournalUtil.fillTotal(ctx, companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), endDay, tableRow, exchange, yearDebitAmt, yearCreditAmt, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc, GL_005);
                }
            }
            if ((temNextPeriodInfo = CasWorkPlatfromCashJournalUtil.getNextPeriodInfo(ctx, companyInfo, temPeriodInfo)) == null) {
                return;
            }
            if ((temNextPeriodInfo.getPeriodYear() < endPeriodInfo.getPeriodYear() || temNextPeriodInfo.getPeriodYear() == endPeriodInfo.getPeriodYear() && endPeriodInfo.getPeriodNumber() >= temNextPeriodInfo.getPeriodNumber()) && temPeriodInfo.getPeriodYear() < temNextPeriodInfo.getPeriodYear()) {
                tableRow = queryTable.addRow();
                tempDate = temNextPeriodInfo.getBeginDate();
                exchange = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((Date)tempDate));
                CasWorkPlatfromCashJournalUtil.fillBalance(ctx, companyInfo, temNextPeriodInfo.getPeriodYear(), temNextPeriodInfo.getPeriodNumber(), tableRow, exchange, balance, isCurEqualsBasecur, YEAR_BALANCE, convertMode, dc, GL_005);
                yearDebitAmt = CasConstants.ZERO;
                yearCreditAmt = CasConstants.ZERO;
            }
            temPeriodInfo = temNextPeriodInfo;
        }
    }

    public static CompanyOrgUnitInfo getCompanyInfo(Context ctx, BOSUuid bosuuid) throws BOSException, EASBizException {
        ObjectUuidPK compk = new ObjectUuidPK(bosuuid);
        ICompanyOrgUnit comorg = null;
        CompanyOrgUnitInfo comorgInfo = null;
        comorg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseExchangeTable"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        comorgInfo = comorg.getCompanyOrgUnitInfo((IObjectPK)compk, sic);
        return comorgInfo;
    }

    public static void fillAdjustRow_New(Context ctx, BigDecimal monthDebitAmt, BigDecimal monthCreditAmt, BigDecimal yearDebitAmt, BigDecimal yearCreditAmt, QueryTable queryTable, boolean isShowBeginBalance, boolean isShowPeriodTotal, boolean isShowYearTotal, CompanyOrgUnitInfo companyInfo, boolean isCurEqualsBasecur, BigDecimal balance, PeriodInfo beginPeriodInfo, PeriodInfo endPeriodInfo, ConvertModeEnum convertMode, CurrencyInfo sourceCurrency, BalanceDirectionEnum dc, boolean GL_005) throws BOSException, EASBizException {
        PeriodInfo temPeriodInfo = beginPeriodInfo;
        String BEGIN_BALANCE = EASCommonResource.getString((String)resourcePath, (String)"BeginBalance", (Locale)ctx.getLocale());
        String YEAR_TOTAL = EASCommonResource.getString((String)resourcePath, (String)"YearTotal", (Locale)ctx.getLocale());
        String PERIOD_TOTAL = EASCommonResource.getString((String)resourcePath, (String)"MonthTotal", (Locale)ctx.getLocale());
        String YEAR_BALANCE = EASCommonResource.getString((String)resourcePath, (String)"YearBalance", (Locale)ctx.getLocale());
        if (beginPeriodInfo == null || endPeriodInfo == null) {
            return;
        }
        while (temPeriodInfo.getPeriodYear() < endPeriodInfo.getPeriodYear() || temPeriodInfo.getPeriodYear() == endPeriodInfo.getPeriodYear() && endPeriodInfo.getPeriodNumber() >= temPeriodInfo.getPeriodNumber()) {
            PeriodInfo temNextPeriodInfo;
            BigDecimal exchange;
            Timestamp tempDate;
            BigDecimal exchange2;
            Timestamp tempDate2;
            PeriodInfo period;
            QueryTableRow tableRow;
            if (isShowBeginBalance) {
                tableRow = queryTable.addRow();
                period = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), companyInfo);
                tempDate2 = period.getEndDate();
                exchange2 = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((Date)tempDate2));
                CasWorkPlatfromCashJournalUtil.fillBalance(ctx, companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), tableRow, exchange2, balance, isCurEqualsBasecur, BEGIN_BALANCE, convertMode, dc, GL_005);
            }
            if (isShowPeriodTotal) {
                tableRow = queryTable.addRow();
                tempDate = temPeriodInfo.getEndDate();
                exchange = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, tempDate);
                CasWorkPlatfromCashJournalUtil.fillTotal(ctx, companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), temPeriodInfo.getEndDate(), tableRow, exchange, monthDebitAmt, monthCreditAmt, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc, GL_005);
                monthDebitAmt = Constants.ZERO;
                monthCreditAmt = Constants.ZERO;
            }
            if (isShowYearTotal) {
                tableRow = queryTable.addRow();
                tempDate = temPeriodInfo.getEndDate();
                exchange = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, tempDate);
                CasWorkPlatfromCashJournalUtil.fillTotal(ctx, companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), temPeriodInfo.getEndDate(), tableRow, exchange, yearDebitAmt, yearCreditAmt, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc, GL_005);
            }
            if ((temNextPeriodInfo = CasWorkPlatfromCashJournalUtil.getNextPeriodInfo(ctx, companyInfo, temPeriodInfo)) == null) {
                return;
            }
            if ((temNextPeriodInfo.getPeriodYear() < endPeriodInfo.getPeriodYear() || temNextPeriodInfo.getPeriodYear() == endPeriodInfo.getPeriodYear() && endPeriodInfo.getPeriodNumber() >= temNextPeriodInfo.getPeriodNumber()) && temPeriodInfo.getPeriodYear() < temNextPeriodInfo.getPeriodYear()) {
                tableRow = queryTable.addRow();
                period = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, temNextPeriodInfo.getPeriodYear(), temNextPeriodInfo.getPeriodNumber(), companyInfo);
                tempDate2 = period.getEndDate();
                exchange2 = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((Date)tempDate2));
                CasWorkPlatfromCashJournalUtil.fillBalance(ctx, companyInfo, temNextPeriodInfo.getPeriodYear(), temNextPeriodInfo.getPeriodNumber(), tableRow, exchange2, balance, isCurEqualsBasecur, YEAR_BALANCE, convertMode, dc, GL_005);
                yearDebitAmt = CasConstants.ZERO;
                yearCreditAmt = CasConstants.ZERO;
            }
            temPeriodInfo = temNextPeriodInfo;
        }
    }

    public static void fillLocalCurrencyDataForTotal(Context ctx, QueryTableRow tableRow, BigDecimal exchange, BigDecimal debitAmt, BigDecimal creditAmt, BigDecimal balance, boolean isCurEqualsBasecur, ConvertModeEnum convertMode, BalanceDirectionEnum dc, boolean GL_005) {
        BigDecimal localBalance;
        BigDecimal localCreditAmt;
        BigDecimal localDebitAmt;
        if (isCurEqualsBasecur) {
            localDebitAmt = debitAmt;
            localCreditAmt = creditAmt;
            localBalance = balance;
        } else if (convertMode.equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
            localDebitAmt = debitAmt.multiply(exchange);
            localCreditAmt = creditAmt.multiply(exchange);
            localBalance = balance.multiply(exchange);
        } else {
            localDebitAmt = debitAmt.divide(exchange, 20, 4);
            localCreditAmt = creditAmt.divide(exchange, 20, 4);
            localBalance = balance.divide(exchange, 20, 4);
        }
        DirectionEnum direction = balance.compareTo(CasConstants.ZERO) == 0 ? DirectionEnum.Balance : (balance.compareTo(CasConstants.ZERO) > 0 ? DirectionEnum.Debit : DirectionEnum.Credit);
        tableRow.addCell(COL_DC).setValue((Object)direction);
        tableRow.addCell(COL_LOCAL_DEBIT).setValue(localDebitAmt);
        tableRow.addCell(COL_LOCAL_CREDIT).setValue(localCreditAmt);
        if (!GL_005) {
            tableRow.addCell(COL_LOCAL_BALANCE).setValue(localBalance.abs());
            tableRow.addCell(COL_BALANCE).setValue(balance.abs());
        } else {
            if (dc != null && !dc.getAlias().equals(direction.getAlias()) && !direction.equals((Object)DirectionEnum.Balance)) {
                tableRow.addCell(COL_DC).setValue((Object)DirectionEnum.getEnum(dc.getValue()));
            }
            tableRow.addCell(COL_LOCAL_BALANCE).setValue(localBalance);
            tableRow.addCell(COL_BALANCE).setValue(balance);
        }
    }

    public static void fillTotal(Context ctx, CompanyOrgUnitInfo companyInfo, int year, int periodNumber, Date date, QueryTableRow tableRow, BigDecimal exchange, BigDecimal debitAmt, BigDecimal creditAmt, BigDecimal balance, boolean isCurEqualsBasecur, String description, ConvertModeEnum convertMode, BalanceDirectionEnum dc, boolean GL_005) throws EASBizException, BOSException {
        tableRow.addCell(COL_DESCRIPTION).setValue(description);
        tableRow.addCell("debitAmount").setValue(debitAmt);
        tableRow.addCell("creditAmount").setValue(creditAmt);
        if (date == null) {
            PeriodInfo endPeriod = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, year, periodNumber, companyInfo);
            tableRow.addCell(COL_CREATE_DATE).setValue(Constants.FORMAT_DAY.format(endPeriod.getEndDate()));
        } else {
            tableRow.addCell(COL_CREATE_DATE).setValue(Constants.FORMAT_DAY.format(date));
        }
        CasWorkPlatfromCashJournalUtil.fillLocalCurrencyDataForTotal(ctx, tableRow, exchange, debitAmt, creditAmt, balance, isCurEqualsBasecur, convertMode, dc, GL_005);
    }

    public static IRowSet getRowset(Context ctx, IMetaDataPK mainQueryPK, CasWorkPlatfromBCJournalParam param) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(1), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)param.getCompanyId(), CompareType.EQUALS));
        if (param.isByDay()) {
            if (param.getToDate() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo(COL_CREATE_DATE, (Object)DateTimeUtils.truncateDate((Date)param.getToDate()), CompareType.LESS_EQUALS));
            }
            if (param.getFromDate() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo(COL_CREATE_DATE, (Object)DateTimeUtils.truncateDate((Date)param.getFromDate()), CompareType.GREATER_EQUALS));
            }
        } else {
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(param.getCompanyId()));
            String periodTypeId = companyInfo.getAccountPeriodType().getId().toString();
            String sql = BankJournalWebUtil.getPeriodCollSQL(periodTypeId, param.getBeginYear(), param.getBeginMonth(), param.getEndYear(), param.getEndMonth());
            filterInfo.getFilterItems().add(new FilterItemInfo("period.id", (Object)sql, CompareType.INNER));
        }
        EntityViewInfo mainQuery = new EntityViewInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("currency.id", (Object)param.getCurrencyId()));
        filterInfo.getFilterItems().add(new FilterItemInfo("accountView.id", (Object)param.getAccountViewId()));
        if (param.getCashierIds() != null && param.getCashierIds().length != 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("cashier.id", new HashSet(Arrays.asList((Object[])param.getCashierIds())), CompareType.INCLUDE));
        }
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        mainQuery.setFilter(filterInfo);
        exec.setObjectView(mainQuery);
        IRowSet rs = exec.executeQuery();
        String sql = exec.getSQL();
        logger.info((Object)sql);
        return rs;
    }

    public static PeriodInfo getPeriodInfo(Context ctx, int year, int periodNumber, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        TreeMap yearMap;
        PeriodCollection pc;
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (periodCache == null || !periodCache.containsKey(companyPK)) {
            CasWorkPlatfromCashJournalUtil.cachePeriod(ctx, companyInfo);
        }
        if ((pc = (PeriodCollection)(yearMap = (TreeMap)periodCache.get(companyPK)).get(new Integer(year))) == null) {
            return null;
        }
        if (pc.get(periodNumber - 1) != null && pc.get(periodNumber - 1).getPeriodNumber() == periodNumber) {
            return pc.get(periodNumber - 1);
        }
        PeriodInfo info = null;
        for (int i = 0; i < pc.size(); ++i) {
            info = pc.get(i);
            if (info.getPeriodNumber() != periodNumber) continue;
            return info;
        }
        return null;
    }

    public static PeriodInfo getNextPeriodInfo(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo period) throws EASBizException, BOSException {
        TreeMap yearMap;
        PeriodCollection pc;
        if (period == null) {
            return null;
        }
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (periodCache == null || !periodCache.containsKey(companyPK)) {
            CasWorkPlatfromCashJournalUtil.cachePeriod(ctx, companyInfo);
        }
        if ((pc = (PeriodCollection)(yearMap = (TreeMap)periodCache.get(companyPK)).get(new Integer(period.getPeriodYear()))) == null) {
            return null;
        }
        PeriodInfo periodInfo = null;
        for (int i = 0; i < pc.size(); ++i) {
            periodInfo = pc.get(i);
            if (periodInfo.getPeriodYear() != period.getPeriodYear() || periodInfo.getPeriodNumber() != period.getPeriodNumber()) continue;
            if (i == pc.size() - 1) {
                pc = (PeriodCollection)yearMap.get(new Integer(period.getPeriodYear() + 1));
                if (pc == null) {
                    return null;
                }
                return pc.get(0);
            }
            return pc.get(i + 1);
        }
        return null;
    }

    public static void setLocalColumnHided(QueryTable queryTable, boolean isHide) {
        if (isHide) {
            queryTable.getHidenColumns().add(COL_EXCHANGE);
            queryTable.getHidenColumns().add(COL_LOCAL_DEBIT);
            queryTable.getHidenColumns().add(COL_LOCAL_CREDIT);
            queryTable.getHidenColumns().add(COL_LOCAL_BALANCE);
        }
    }

    public static BigDecimal getYearStartAmount(Context ctx, CashDataSourceEnum dataSource, String companyId, String accountId, String accountBankIds, String currencyId, CashDataTypeEnum dataType) throws EASBizException, BOSException, SQLException {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        if (startPeriod == null) {
            return CasConstants.ZERO;
        }
        StringBuffer sql = new StringBuffer();
        if (dataType.equals((Object)CashDataTypeEnum.JF)) {
            sql.append("select FDebitStartAmt result from T_CAS_JournalBalance where ");
        } else if (dataType.equals((Object)CashDataTypeEnum.DF)) {
            sql.append("select FCreditStartAmt result from T_CAS_JournalBalance where ");
        } else {
            return SysConstant.BIGZERO;
        }
        sql.append("FCompanyId='").append(companyId).append("' and FCurrencyId ='").append(currencyId).append("' and FPeriodId='").append(startPeriod.getId().toString()).append("'");
        if (dataSource.getValue() == 3) {
            sql.append("and FType= 3");
        } else if (dataSource.getValue() == 1) {
            sql.append("and FType= 2");
        } else {
            sql.append("and FType= 1");
        }
        if (!dataSource.equals((Object)CashDataSourceEnum.C) && !dataSource.equals((Object)CashDataSourceEnum.S) && accountBankIds != null && accountBankIds.length() > 0) {
            sql.append(" and FAccountBankID ='").append(accountBankIds + "'");
        }
        if (accountId != null) {
            sql.append(" and FAccountViewId ='").append(accountId).append("'");
        }
        sql.append(" and FIsInit =1");
        ISQLExecutor executor = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString());
        IRowSet rowSet = executor.executeSQL();
        BigDecimal result = SysConstant.BIGZERO;
        if (rowSet.next()) {
            result = rowSet.getBigDecimal("result");
        }
        return result;
    }

    public static void fetchJournalData(Context ctx, CasWorkPlatfromBCJournalParam para, QueryTable queryTable) throws SQLException, EASBizException, BOSException {
        PeriodInfo cperiod;
        PeriodInfo temNextPeriodInfo;
        BigDecimal exchange;
        Timestamp tempDate;
        BigDecimal exchange2;
        PeriodInfo Period;
        QueryTableRow tableRow;
        BigDecimal exchange3;
        Timestamp tempDate2;
        PeriodInfo period;
        int endPeriod;
        int endYear;
        int beginPeriod;
        int beginYear;
        Date beginDate;
        String DAY_TOTAL = EASCommonResource.getString((String)resourcePath, (String)"DayTotal", (Locale)ctx.getLocale());
        String YEAR_TOTAL = EASCommonResource.getString((String)resourcePath, (String)"YearTotal", (Locale)ctx.getLocale());
        String PERIOD_TOTAL = EASCommonResource.getString((String)resourcePath, (String)"MonthTotal", (Locale)ctx.getLocale());
        String YEAR_BALANCE = EASCommonResource.getString((String)resourcePath, (String)"YearBalance", (Locale)ctx.getLocale());
        String BEGIN_BALANCE = EASCommonResource.getString((String)resourcePath, (String)"BeginBalance", (Locale)ctx.getLocale());
        CurrencyInfo sourceCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(para.getCurrencyId()));
        String accountViewNumber = para.getAccountViewNumber();
        CashDataSourceEnum dataSourceType = para.getDataSourceType();
        Set cashierIDSet = FMHelper.Array2Set((String[])para.getCashierIds());
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(para.getCompanyId()));
        boolean GL_005 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("GL_005", (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        String acctTableId = CasWorkPlatfromCashJournalUtil.getAcctTableID(ctx, para);
        para.setAcctTableId(acctTableId);
        BalanceDirectionEnum dc = null;
        if (para.getAccountViewId() != null) {
            AccountViewInfo account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(para.getAccountViewId()));
            dc = account.getDC();
        }
        MetaDataPK mainQueryPk = new MetaDataPK("com.kingdee.eas.fi.cas", "CashJournalWebQuery");
        IRowSet rs = CasWorkPlatfromCashJournalUtil.getRowset(ctx, (IMetaDataPK)mainQueryPk, para);
        boolean isShowBeginBalance = para.isShowBeginBalance();
        boolean isShowDayTotal = para.isShowDayTotal();
        boolean isShowPeriodTotal = para.isShowMonthTotal();
        boolean isShowYearTotal = para.isShowYearTotal();
        PeriodInfo beginPeriodInfo = null;
        PeriodInfo endPeriodInfo = null;
        Date bdate = para.getFromDate();
        Date edate = para.getToDate();
        String currencyNumber = sourceCurrency.getNumber();
        boolean isStart = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        int startPeriodYear = startPeriod.getPeriodYear();
        boolean isByDay = para.isByDay();
        if (isByDay) {
            if (para.getFromDate().before(startPeriod.getBeginDate())) {
                beginPeriodInfo = startPeriod;
                beginDate = beginPeriodInfo.getBeginDate();
            } else {
                beginPeriodInfo = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, para.getFromDate(), companyInfo);
                beginDate = para.getFromDate();
            }
            if (para.getToDate().before(startPeriod.getBeginDate())) {
                return;
            }
            endPeriodInfo = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, para.getToDate(), companyInfo);
            if (endPeriodInfo == null) {
                endPeriodInfo = CasWorkPlatfromCashJournalUtil.getLastPeriodInfo(ctx, companyInfo);
            }
            beginYear = beginPeriodInfo.getPeriodYear();
            beginPeriod = beginPeriodInfo.getPeriodNumber();
            endYear = endPeriodInfo.getPeriodYear();
            endPeriod = endPeriodInfo.getPeriodNumber();
        } else {
            beginYear = para.getBeginYear();
            beginPeriod = para.getBeginMonth();
            endYear = para.getEndYear();
            endPeriod = para.getEndMonth();
            beginPeriodInfo = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, beginYear, beginPeriod, companyInfo);
            endPeriodInfo = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, endYear, endPeriod, companyInfo);
            if (beginPeriodInfo == null) {
                beginPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            }
            beginDate = beginPeriodInfo.getBeginDate();
        }
        AccountTableInfo accountTable = AccountTableFactory.getLocalInstance((Context)ctx).getAccountTableInfo((IObjectPK)new ObjectUuidPK(para.getAcctTableId()));
        String acctTableNumber = accountTable.getNumber();
        ConvertModeEnum convertMode = JournalWebUtil.getExchangeConvertMode(ctx, companyInfo, sourceCurrency, null);
        boolean isCurEqualsBasecur = sourceCurrency.getId().equals((Object)companyInfo.getBaseCurrency().getId());
        boolean isShowLocalCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS003", (IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()));
        BigDecimal exchange1 = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, null);
        boolean isHide = true;
        isHide = isCurEqualsBasecur || !isShowLocalCurrency || !isCurEqualsBasecur && exchange1.compareTo(Constants.ONE) == 0;
        if (!isHide) {
            queryTable.setBaseCurrPrecision(companyInfo.getBaseCurrency().getPrecision());
        }
        queryTable.setSrcCurrPrecision(sourceCurrency.getPrecision());
        CasWorkPlatfromCashJournalUtil.setLocalColumnHided(queryTable, isHide);
        BigDecimal debitAmt = null;
        BigDecimal creditAmt = null;
        BigDecimal balance = null;
        BigDecimal tmpDayDebitTotal = CasConstants.ZERO;
        BigDecimal tmpDayCreditTotal = CasConstants.ZERO;
        BigDecimal tmpMonthDebitTotal = CasConstants.ZERO;
        BigDecimal tmpMonthCreditTotal = CasConstants.ZERO;
        BigDecimal tmpYearDebitTotal = CasConstants.ZERO;
        BigDecimal tmpYearCreditTotal = CasConstants.ZERO;
        BigDecimal yearDebitAmt = CasConstants.ZERO;
        BigDecimal yearCreditAmt = CasConstants.ZERO;
        BigDecimal tempd = CasConstants.ZERO;
        BigDecimal tempc = CasConstants.ZERO;
        if (isStart && beginYear == startPeriodYear) {
            yearDebitAmt = CasWorkPlatfromCashJournalUtil.getYearStartAmount(ctx, dataSourceType, companyInfo.getId().toString(), para.getAccountViewId(), null, sourceCurrency.getId().toString(), CashDataTypeEnum.JF);
            yearCreditAmt = CasWorkPlatfromCashJournalUtil.getYearStartAmount(ctx, dataSourceType, companyInfo.getId().toString(), para.getAccountViewId(), null, sourceCurrency.getId().toString(), CashDataTypeEnum.DF);
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(beginDate);
        balance = isByDay ? CasWorkPlatfromCashJournalUtil.getBeginBalance(ctx, companyInfo, acctTableNumber, currencyNumber, accountViewNumber, null, beginDate, dataSourceType, false) : CasWorkPlatfromCashJournalUtil.getBeginBalance(ctx, companyInfo, acctTableNumber, currencyNumber, accountViewNumber, null, beginPeriodInfo, dataSourceType);
        BigDecimal beginYearDebitTotal = CasWorkPlatfromCashJournalUtil.getYearTotal(ctx, companyInfo, acctTableNumber, currencyNumber, accountViewNumber, null, beginYear, beginPeriod, dataSourceType, CashDataTypeEnum.JF);
        BigDecimal beginYearCreditTotal = CasWorkPlatfromCashJournalUtil.getYearTotal(ctx, companyInfo, acctTableNumber, currencyNumber, accountViewNumber, null, beginYear, beginPeriod, dataSourceType, CashDataTypeEnum.DF);
        ICashManagement cashInacct = CashManagementFactory.getLocalInstance(ctx);
        BigDecimal adebitTotal = Constants.ZERO;
        BigDecimal acreditTotal = Constants.ZERO;
        if (isByDay && para.getFromDate().compareTo(beginPeriodInfo.getBeginDate()) > 0) {
            adebitTotal = cashInacct.cash(companyInfo.getNumber(), CashDataSourceEnum.C, acctTableNumber, accountViewNumber, null, currencyNumber, beginPeriodInfo.getBeginDate(), DateHelper.getBeforeDay((Date)para.getFromDate()), CashDataTypeEnum.JF, false);
            acreditTotal = cashInacct.cash(companyInfo.getNumber(), CashDataSourceEnum.C, acctTableNumber, accountViewNumber, null, currencyNumber, beginPeriodInfo.getBeginDate(), DateHelper.getBeforeDay((Date)para.getFromDate()), CashDataTypeEnum.DF, false);
            tmpMonthDebitTotal = adebitTotal;
            tmpMonthCreditTotal = acreditTotal;
        }
        if (beginYear == startPeriod.getPeriodYear() && beginPeriod == startPeriod.getPeriodNumber()) {
            QueryTableRow tableRow2 = queryTable.addRow();
            BigDecimal yearBeginBalance = null;
            if (!isStart) {
                yearBeginBalance = CasConstants.ZERO;
            } else if (isByDay) {
                BigDecimal b = CasWorkPlatfromCashJournalUtil.getBeginBalance(ctx, companyInfo, acctTableNumber, currencyNumber, accountViewNumber, null, startPeriod.getBeginDate(), dataSourceType, false);
                if (b == null) {
                    b = CasConstants.ZERO;
                }
                yearBeginBalance = b.add(yearCreditAmt).subtract(yearDebitAmt);
            } else {
                yearBeginBalance = balance.add(yearCreditAmt).subtract(yearDebitAmt);
            }
            PeriodInfo period2 = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, beginYear, beginPeriod, companyInfo);
            Timestamp tempDate3 = period2.getEndDate();
            BigDecimal exchange4 = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((Date)tempDate3));
            CasWorkPlatfromCashJournalUtil.fillBalance(ctx, companyInfo, beginYear, beginPeriod, tableRow2, exchange4, yearBeginBalance, isCurEqualsBasecur, YEAR_BALANCE, convertMode, dc, GL_005);
        }
        if (rs == null || rs.size() == 0) {
            if (beginYear == startPeriodYear) {
                tmpYearDebitTotal = beginYearDebitTotal.add(yearDebitAmt);
                tmpYearCreditTotal = beginYearCreditTotal.add(yearCreditAmt);
            } else {
                tmpYearDebitTotal = beginYearDebitTotal;
                tmpYearCreditTotal = beginYearCreditTotal;
            }
            tmpMonthDebitTotal = CasConstants.ZERO;
            tmpMonthCreditTotal = CasConstants.ZERO;
            tmpYearDebitTotal = tmpYearDebitTotal.add(adebitTotal);
            tmpYearCreditTotal = tmpYearCreditTotal.add(acreditTotal);
            if (isByDay) {
                CasWorkPlatfromCashJournalUtil.fillAdjustRow_NewDay(ctx, tmpMonthDebitTotal, tmpMonthCreditTotal, tmpYearDebitTotal, tmpYearCreditTotal, queryTable, isShowBeginBalance, isShowPeriodTotal, isShowYearTotal, companyInfo, isCurEqualsBasecur, balance, beginPeriodInfo, endPeriodInfo, convertMode, para.getFromDate(), para.getToDate(), sourceCurrency, dc, GL_005);
            } else {
                CasWorkPlatfromCashJournalUtil.fillAdjustRow_New(ctx, adebitTotal, acreditTotal, tmpYearDebitTotal, tmpYearCreditTotal, queryTable, isShowBeginBalance, isShowPeriodTotal, isShowYearTotal, companyInfo, isCurEqualsBasecur, balance, beginPeriodInfo, endPeriodInfo, convertMode, sourceCurrency, dc, GL_005);
            }
            return;
        }
        java.sql.Date date = null;
        int year = beginYear;
        int periodNumber = beginPeriod;
        int tmpYear = beginYear;
        int tmpPeriodNumber = beginPeriod;
        Date tmpdate = null;
        if (rs.next()) {
            date = rs.getDate(COL_CREATE_DATE);
            year = rs.getInt(PERIOD_YEAR);
            periodNumber = rs.getInt(PERIOD_NUMBER);
            tmpYear = rs.getInt(PERIOD_YEAR);
            tmpPeriodNumber = rs.getInt(PERIOD_NUMBER);
            tmpdate = rs.getDate(COL_CREATE_DATE);
            rs.beforeFirst();
        }
        if (beginYear < year || beginYear == year && beginPeriod < periodNumber) {
            endPeriodInfo = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, year, periodNumber, companyInfo);
            endPeriodInfo = CasWorkPlatfromCashJournalUtil.getPrePeriodInfo(ctx, companyInfo, endPeriodInfo);
            if (beginYear == startPeriodYear) {
                tmpYearDebitTotal = beginYearDebitTotal.add(yearDebitAmt);
                tmpYearCreditTotal = beginYearCreditTotal.add(yearCreditAmt);
            } else {
                tmpYearDebitTotal = beginYearDebitTotal;
                tmpYearCreditTotal = beginYearCreditTotal;
            }
            CasWorkPlatfromCashJournalUtil.fillAdjustRow_New(ctx, CasConstants.ZERO, CasConstants.ZERO, tmpYearDebitTotal, tmpYearCreditTotal, queryTable, isShowBeginBalance, isShowPeriodTotal, isShowYearTotal, companyInfo, isCurEqualsBasecur, balance, beginPeriodInfo, endPeriodInfo, convertMode, sourceCurrency, dc, GL_005);
        }
        if (isShowBeginBalance) {
            QueryTableRow tableRow3 = queryTable.addRow();
            period = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, year, periodNumber, companyInfo);
            tempDate2 = period.getEndDate();
            exchange3 = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((Date)tempDate2));
            CasWorkPlatfromCashJournalUtil.fillBalance(ctx, companyInfo, year, periodNumber, tableRow3, exchange3, balance, isCurEqualsBasecur, BEGIN_BALANCE, convertMode, dc, GL_005);
        }
        BigDecimal dayBalance = balance;
        if (isByDay && rs != null && rs.size() != 0) {
            dayBalance = balance = CasWorkPlatfromCashJournalUtil.getBeginBalance(ctx, companyInfo, acctTableNumber, currencyNumber, accountViewNumber, null, beginDate, dataSourceType, false);
        }
        if (year == startPeriodYear) {
            tmpYearDebitTotal = beginYearDebitTotal.add(yearDebitAmt);
            tmpYearCreditTotal = beginYearCreditTotal.add(yearCreditAmt);
        } else {
            tmpYearDebitTotal = beginYearDebitTotal;
            tmpYearCreditTotal = beginYearCreditTotal;
        }
        while (rs.next()) {
            QueryTableRow tableRow4;
            year = rs.getInt(PERIOD_YEAR);
            periodNumber = rs.getInt(PERIOD_NUMBER);
            date = rs.getDate(COL_CREATE_DATE);
            debitAmt = rs.getBigDecimal("debitAmount");
            creditAmt = rs.getBigDecimal("creditAmount");
            if (debitAmt == null) {
                debitAmt = CasConstants.ZERO;
            }
            if (creditAmt == null) {
                creditAmt = CasConstants.ZERO;
            }
            if (date.compareTo(tmpdate) == 0) {
                tmpDayDebitTotal = tmpDayDebitTotal.add(debitAmt);
                tmpDayCreditTotal = tmpDayCreditTotal.add(creditAmt);
            }
            if (date.compareTo(tmpdate) != 0) {
                if (isShowDayTotal) {
                    tableRow = queryTable.addRow();
                    if (tmpdate == null) {
                        Period = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, tmpYear, tmpPeriodNumber, companyInfo);
                        tmpdate = Period.getEndDate();
                    }
                    exchange2 = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, tmpdate);
                    CasWorkPlatfromCashJournalUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, tmpdate, tableRow, exchange2, tmpDayDebitTotal, tmpDayCreditTotal, balance, isCurEqualsBasecur, DAY_TOTAL, convertMode, dc, GL_005);
                }
                tmpMonthDebitTotal = tmpMonthDebitTotal.add(tmpDayDebitTotal);
                tmpMonthCreditTotal = tmpMonthCreditTotal.add(tmpDayCreditTotal);
                tmpDayDebitTotal = debitAmt;
                tmpDayCreditTotal = creditAmt;
            }
            tempd = tempd.add(debitAmt);
            tempc = tempc.add(creditAmt);
            if (tmpPeriodNumber != periodNumber) {
                PeriodInfo cPeriod;
                PeriodInfo period3;
                if (isShowPeriodTotal) {
                    tableRow = queryTable.addRow();
                    period3 = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, tmpYear, tmpPeriodNumber, companyInfo);
                    tempDate = period3.getEndDate();
                    exchange = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, tempDate);
                    if (isByDay) {
                        cPeriod = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, tmpYear, tmpPeriodNumber, companyInfo);
                        if (cPeriod.getEndDate().compareTo(new Timestamp(para.getToDate().getTime())) > 0) {
                            CasWorkPlatfromCashJournalUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, para.getToDate(), tableRow, exchange, tmpMonthDebitTotal.subtract(adebitTotal), tmpMonthCreditTotal.subtract(acreditTotal), balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc, GL_005);
                        } else {
                            CasWorkPlatfromCashJournalUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, null, tableRow, exchange, tmpMonthDebitTotal.subtract(adebitTotal), tmpMonthCreditTotal.subtract(acreditTotal), balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc, GL_005);
                        }
                        adebitTotal = CasConstants.ZERO;
                        acreditTotal = CasConstants.ZERO;
                    } else {
                        CasWorkPlatfromCashJournalUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, null, tableRow, exchange, tmpMonthDebitTotal, tmpMonthCreditTotal, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc, GL_005);
                    }
                    tempd = debitAmt;
                    tempc = creditAmt;
                }
                tmpYearDebitTotal = tmpYearDebitTotal.add(tmpMonthDebitTotal);
                tmpYearCreditTotal = tmpYearCreditTotal.add(tmpMonthCreditTotal);
                if (isShowYearTotal) {
                    tableRow = queryTable.addRow();
                    period3 = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, tmpYear, tmpPeriodNumber, companyInfo);
                    tempDate = period3.getEndDate();
                    exchange = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, tempDate);
                    if (isByDay) {
                        cPeriod = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, tmpYear, tmpPeriodNumber, companyInfo);
                        if (cPeriod.getEndDate().compareTo(new Timestamp(para.getToDate().getTime())) > 0) {
                            CasWorkPlatfromCashJournalUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, para.getToDate(), tableRow, exchange, tmpYearDebitTotal, tmpYearCreditTotal, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc, GL_005);
                        } else {
                            CasWorkPlatfromCashJournalUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, null, tableRow, exchange, tmpYearDebitTotal, tmpYearCreditTotal, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc, GL_005);
                        }
                    } else {
                        CasWorkPlatfromCashJournalUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, null, tableRow, exchange, tmpYearDebitTotal, tmpYearCreditTotal, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc, GL_005);
                        if (tmpYear < endYear || tmpYear == endYear && tmpPeriodNumber < endPeriod) {
                            beginPeriodInfo = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, tmpYear, tmpPeriodNumber, companyInfo);
                            temNextPeriodInfo = CasWorkPlatfromCashJournalUtil.getNextPeriodInfo(ctx, companyInfo, beginPeriodInfo);
                            if (temNextPeriodInfo == null) {
                                return;
                            }
                            if ((temNextPeriodInfo.getPeriodYear() < endPeriodInfo.getPeriodYear() || temNextPeriodInfo.getPeriodYear() == endPeriodInfo.getPeriodYear() && endPeriodInfo.getPeriodNumber() >= temNextPeriodInfo.getPeriodNumber()) && beginPeriodInfo.getPeriodYear() < temNextPeriodInfo.getPeriodYear()) {
                                tableRow = queryTable.addRow();
                                PeriodInfo period2 = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, temNextPeriodInfo.getPeriodYear(), temNextPeriodInfo.getPeriodNumber(), companyInfo);
                                Timestamp tempDate22 = period2.getEndDate();
                                BigDecimal exchange22 = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((Date)tempDate22));
                                CasWorkPlatfromCashJournalUtil.fillBalance(ctx, companyInfo, temNextPeriodInfo.getPeriodYear(), temNextPeriodInfo.getPeriodNumber(), tableRow, exchange22, balance, isCurEqualsBasecur, YEAR_BALANCE, convertMode, dc, GL_005);
                                tmpYearDebitTotal = CasConstants.ZERO;
                                tmpYearCreditTotal = CasConstants.ZERO;
                            }
                        }
                    }
                }
                beginPeriodInfo = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, tmpYear, tmpPeriodNumber, companyInfo);
                beginPeriodInfo = CasWorkPlatfromCashJournalUtil.getNextPeriodInfo(ctx, companyInfo, beginPeriodInfo);
                endPeriodInfo = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, year, periodNumber, companyInfo);
                endPeriodInfo = CasWorkPlatfromCashJournalUtil.getPrePeriodInfo(ctx, companyInfo, endPeriodInfo);
                CasWorkPlatfromCashJournalUtil.fillAdjustRow_New(ctx, CasConstants.ZERO, CasConstants.ZERO, tmpYearDebitTotal, tmpYearCreditTotal, queryTable, isShowBeginBalance, isShowPeriodTotal, isShowYearTotal, companyInfo, isCurEqualsBasecur, balance, beginPeriodInfo, endPeriodInfo, convertMode, sourceCurrency, dc, GL_005);
                tmpYear = year;
                tmpMonthDebitTotal = CasConstants.ZERO;
                tmpMonthCreditTotal = CasConstants.ZERO;
            }
            if (tmpYear != year) {
                tmpYearDebitTotal = CasConstants.ZERO;
                tmpYearCreditTotal = CasConstants.ZERO;
            }
            period = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, year, periodNumber, companyInfo);
            tempDate2 = period.getEndDate();
            exchange3 = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((Date)tempDate2));
            if (tmpYear != year) {
                tableRow4 = queryTable.addRow();
                CasWorkPlatfromCashJournalUtil.fillBalance(ctx, companyInfo, year, periodNumber, tableRow4, exchange3, balance, isCurEqualsBasecur, YEAR_BALANCE, convertMode, dc, GL_005);
            }
            if (tmpPeriodNumber != periodNumber && isShowBeginBalance) {
                tableRow4 = queryTable.addRow();
                CasWorkPlatfromCashJournalUtil.fillBalance(ctx, companyInfo, year, periodNumber, tableRow4, exchange3, balance, isCurEqualsBasecur, BEGIN_BALANCE, convertMode, dc, GL_005);
            }
            balance = balance.add(debitAmt).subtract(creditAmt);
            BigDecimal exchange23 = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, new Date(rs.getDate(COL_BIZDATE).getTime()));
            CasWorkPlatfromCashJournalUtil.fillOneJournalRow(ctx, queryTable, rs, exchange23, isCurEqualsBasecur, debitAmt, creditAmt, balance, convertMode, dc, GL_005);
            tmpdate = date;
            tmpYear = year;
            tmpPeriodNumber = periodNumber;
        }
        if (isShowDayTotal) {
            tableRow = queryTable.addRow();
            if (tmpdate == null) {
                Period = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, tmpYear, tmpPeriodNumber, companyInfo);
                tmpdate = Period.getEndDate();
            }
            exchange2 = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, tmpdate);
            CasWorkPlatfromCashJournalUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, date, tableRow, exchange2, tmpDayDebitTotal, tmpDayCreditTotal, balance, isCurEqualsBasecur, DAY_TOTAL, convertMode, dc, GL_005);
        }
        if (isByDay) {
            period = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, year, periodNumber, companyInfo);
            Date endDate = period.getEndDate();
            if ((endDate = new Date(endDate.getTime())).after(para.getToDate())) {
                endDate = para.getToDate();
            }
            if (cashierIDSet != null) {
                balance = cashInacct.cash(companyInfo.getNumber(), dataSourceType, acctTableNumber, accountViewNumber, null, currencyNumber, period.getBeginDate(), endDate, CashDataTypeEnum.Y, false);
                tmpMonthDebitTotal = tempd;
                tmpMonthCreditTotal = tempc;
                tmpYearDebitTotal = tmpYearDebitTotal.add(tmpMonthDebitTotal);
                tmpYearCreditTotal = tmpYearCreditTotal.add(tmpMonthCreditTotal);
            } else if (CashHelper.isTheSameMonth(bdate, edate)) {
                adebitTotal = cashInacct.cash(companyInfo.getNumber(), CashDataSourceEnum.C, acctTableNumber, accountViewNumber, null, currencyNumber, beginPeriodInfo.getBeginDate(), DateHelper.getBeforeDay((Date)para.getFromDate()), CashDataTypeEnum.JF, false);
                acreditTotal = cashInacct.cash(companyInfo.getNumber(), CashDataSourceEnum.C, acctTableNumber, accountViewNumber, null, currencyNumber, beginPeriodInfo.getBeginDate(), DateHelper.getBeforeDay((Date)para.getFromDate()), CashDataTypeEnum.DF, false);
                tmpMonthDebitTotal = tmpMonthDebitTotal.subtract(adebitTotal).add(tmpDayDebitTotal);
                tmpMonthCreditTotal = tmpMonthCreditTotal.subtract(acreditTotal).add(tmpDayCreditTotal);
                tmpYearDebitTotal = tmpYearDebitTotal.add(tmpMonthDebitTotal);
                tmpYearCreditTotal = tmpYearCreditTotal.add(tmpMonthCreditTotal);
            } else {
                balance = cashInacct.cash(companyInfo.getNumber(), dataSourceType, acctTableNumber, accountViewNumber, null, currencyNumber, period.getBeginDate(), endDate, CashDataTypeEnum.Y, false);
                tmpMonthDebitTotal = cashInacct.cash(companyInfo.getNumber(), dataSourceType, acctTableNumber, accountViewNumber, null, currencyNumber, period.getBeginDate(), endDate, CashDataTypeEnum.JF, false);
                tmpMonthCreditTotal = cashInacct.cash(companyInfo.getNumber(), dataSourceType, acctTableNumber, accountViewNumber, null, currencyNumber, period.getBeginDate(), endDate, CashDataTypeEnum.DF, false);
                tmpYearDebitTotal = tmpYearDebitTotal.add(tmpMonthDebitTotal);
                tmpYearCreditTotal = tmpYearCreditTotal.add(tmpMonthCreditTotal);
            }
        } else {
            tmpMonthDebitTotal = tmpMonthDebitTotal.add(tmpDayDebitTotal);
            tmpMonthCreditTotal = tmpMonthCreditTotal.add(tmpDayCreditTotal);
            tmpYearDebitTotal = tmpYearDebitTotal.add(tmpMonthDebitTotal);
            tmpYearCreditTotal = tmpYearCreditTotal.add(tmpMonthCreditTotal);
        }
        if (CashHelper.isTheSameMonth(bdate, edate)) {
            tmpYearDebitTotal = tmpYearDebitTotal.add(adebitTotal);
            tmpYearCreditTotal = tmpYearCreditTotal.add(acreditTotal);
        }
        if (isShowPeriodTotal) {
            tableRow = queryTable.addRow();
            cperiod = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, tmpYear, tmpPeriodNumber, companyInfo);
            tempDate = cperiod.getEndDate();
            exchange = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, tempDate);
            if (isByDay) {
                if (cperiod.getEndDate().compareTo(new Timestamp(para.getToDate().getTime())) > 0) {
                    CasWorkPlatfromCashJournalUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, para.getToDate(), tableRow, exchange, tmpMonthDebitTotal, tmpMonthCreditTotal, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc, GL_005);
                } else {
                    CasWorkPlatfromCashJournalUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, null, tableRow, exchange, tmpMonthDebitTotal, tmpMonthCreditTotal, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc, GL_005);
                }
            } else {
                CasWorkPlatfromCashJournalUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, null, tableRow, exchange, tmpMonthDebitTotal, tmpMonthCreditTotal, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc, GL_005);
            }
        }
        if (isShowYearTotal) {
            tableRow = queryTable.addRow();
            cperiod = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, tmpYear, tmpPeriodNumber, companyInfo);
            tempDate = cperiod.getEndDate();
            exchange = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, tempDate);
            if (isByDay) {
                if (cperiod.getEndDate().compareTo(new Timestamp(para.getToDate().getTime())) > 0) {
                    CasWorkPlatfromCashJournalUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, para.getToDate(), tableRow, exchange, tmpYearDebitTotal, tmpYearCreditTotal, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc, GL_005);
                } else {
                    CasWorkPlatfromCashJournalUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, null, tableRow, exchange, tmpYearDebitTotal, tmpYearCreditTotal, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc, GL_005);
                }
            } else {
                CasWorkPlatfromCashJournalUtil.fillTotal(ctx, companyInfo, tmpYear, tmpPeriodNumber, null, tableRow, exchange, tmpYearDebitTotal, tmpYearCreditTotal, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc, GL_005);
                if (year < endYear || year == endYear && periodNumber < endPeriod) {
                    beginPeriodInfo = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, year, periodNumber, companyInfo);
                    temNextPeriodInfo = CasWorkPlatfromCashJournalUtil.getNextPeriodInfo(ctx, companyInfo, beginPeriodInfo);
                    if (temNextPeriodInfo == null) {
                        return;
                    }
                    if ((temNextPeriodInfo.getPeriodYear() < endPeriodInfo.getPeriodYear() || temNextPeriodInfo.getPeriodYear() == endPeriodInfo.getPeriodYear() && endPeriodInfo.getPeriodNumber() >= temNextPeriodInfo.getPeriodNumber()) && beginPeriodInfo.getPeriodYear() < temNextPeriodInfo.getPeriodYear()) {
                        tableRow = queryTable.addRow();
                        CasWorkPlatfromCashJournalUtil.fillBalance(ctx, companyInfo, temNextPeriodInfo.getPeriodYear(), temNextPeriodInfo.getPeriodNumber(), tableRow, exchange, balance, isCurEqualsBasecur, YEAR_BALANCE, convertMode, dc, GL_005);
                        tmpYearDebitTotal = CasConstants.ZERO;
                        tmpYearCreditTotal = CasConstants.ZERO;
                    }
                }
            }
        }
        if (year < endYear || year == endYear && periodNumber < endPeriod) {
            beginPeriodInfo = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, year, periodNumber, companyInfo);
            beginPeriodInfo = CasWorkPlatfromCashJournalUtil.getNextPeriodInfo(ctx, companyInfo, beginPeriodInfo);
            endPeriodInfo = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, endYear, endPeriod, companyInfo);
            if (isByDay && !para.getToDate().equals(endPeriodInfo.getEndDate())) {
                endPeriodInfo = CasWorkPlatfromCashJournalUtil.getPrePeriodInfo(ctx, companyInfo, endPeriodInfo);
            }
            CasWorkPlatfromCashJournalUtil.fillAdjustRow_New(ctx, CasConstants.ZERO, CasConstants.ZERO, tmpYearDebitTotal, tmpYearCreditTotal, queryTable, isShowBeginBalance, isShowPeriodTotal, isShowYearTotal, companyInfo, isCurEqualsBasecur, balance, beginPeriodInfo, endPeriodInfo, convertMode, sourceCurrency, dc, GL_005);
        }
        BigDecimal exchange5 = JournalWebUtil.getExchange(ctx, companyInfo, sourceCurrency, null, beginDate);
        CasWorkPlatfromCashJournalUtil.setBeginBalanceRowDisc(ctx, queryTable, beginDate, isByDay, exchange5, isCurEqualsBasecur, dayBalance, convertMode, dc, GL_005);
    }

    public static void fillLocalCurrencyData(Context ctx, QueryTableRow tableRow, BigDecimal exchange, BigDecimal debitAmt, BigDecimal creditAmt, BigDecimal balance, boolean isCurEqualsBasecur, ConvertModeEnum convertMode, BalanceDirectionEnum dc, boolean GL_005) {
        BigDecimal localBalance;
        BigDecimal localCreditAmt;
        BigDecimal localDebitAmt;
        if (isCurEqualsBasecur) {
            localDebitAmt = debitAmt;
            localCreditAmt = creditAmt;
            localBalance = balance;
        } else if (convertMode.equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
            localDebitAmt = debitAmt.multiply(exchange);
            localCreditAmt = creditAmt.multiply(exchange);
            localBalance = balance.multiply(exchange);
        } else {
            localDebitAmt = debitAmt.divide(exchange, 20, 4);
            localCreditAmt = creditAmt.divide(exchange, 20, 4);
            localBalance = balance.divide(exchange, 20, 4);
        }
        DirectionEnum direction = balance.compareTo(CasConstants.ZERO) == 0 ? DirectionEnum.Balance : (balance.compareTo(CasConstants.ZERO) > 0 ? DirectionEnum.Debit : DirectionEnum.Credit);
        tableRow.addCell(COL_DC).setValue((Object)direction);
        if (localDebitAmt.compareTo(CasConstants.ZERO) != 0) {
            tableRow.addCell(COL_LOCAL_DEBIT).setValue(localDebitAmt);
        }
        if (localCreditAmt.compareTo(CasConstants.ZERO) != 0) {
            tableRow.addCell(COL_LOCAL_CREDIT).setValue(localCreditAmt);
        }
        if (!GL_005) {
            tableRow.addCell(COL_LOCAL_BALANCE).setValue(localBalance.abs());
            tableRow.addCell(COL_BALANCE).setValue(balance.abs());
        } else {
            if (dc != null && !dc.getAlias().equals(direction.getAlias()) && !direction.equals((Object)DirectionEnum.Balance)) {
                tableRow.addCell(COL_DC).setValue((Object)DirectionEnum.getEnum(dc.getValue()));
            }
            tableRow.addCell(COL_LOCAL_BALANCE).setValue(localBalance);
            tableRow.addCell(COL_BALANCE).setValue(balance);
        }
    }

    public static void fillOneJournalRow(Context ctx, QueryTable queryTable, IRowSet rs, BigDecimal exchange, boolean isCurEqualsBasecur, BigDecimal debitAmt, BigDecimal creditAmt, BigDecimal balance, ConvertModeEnum convertMode, BalanceDirectionEnum dc, boolean GL_005) throws SQLException {
        QueryTableRow tableRow = queryTable.addRow();
        tableRow.addCell(COL_ID).setValue(rs.getString("ID"));
        tableRow.addCell(COL_COMPANY).setValue(rs.getString("company.name"));
        tableRow.addCell(COL_COMPANY_ID).setValue(rs.getString("company.id"));
        tableRow.addCell(COL_BIZDATE).setValue(Constants.FORMAT_DAY.format(rs.getDate(COL_BIZDATE)));
        tableRow.addCell(COL_CREATE_DATE).setValue(Constants.FORMAT_DAY.format(rs.getDate(COL_CREATE_DATE)));
        tableRow.addCell(COL_VOUCHERTYPE).setValue(rs.getString(COL_VOUCHERTYPE));
        tableRow.addCell(COL_VOUCHERNUMBER).setValue(rs.getString(COL_VOUCHERNUMBER));
        String oppAccount = rs.getString("oppAccountViewNumber");
        if (oppAccount != null) {
            oppAccount = oppAccount + " " + rs.getString("oppAccountViewName");
        }
        tableRow.addCell(COL_OPPACCOUNTNUMBER).setValue(oppAccount);
        tableRow.addCell(COL_BILLTYPE).setValue((Object)BillTypeEnum.getEnum(rs.getInt(COL_BILLTYPE)));
        tableRow.addCell(COL_BILLNUMBER).setValue(rs.getString(COL_BILLNUMBER));
        tableRow.addCell(COL_DESCRIPTION).setValue(rs.getString(COL_DESCRIPTION));
        tableRow.addCell(COL_SETTTYPE).setValue(rs.getString(COL_SETTTYPE));
        tableRow.addCell(COL_SETTNUMBER).setValue(rs.getString(COL_SETTNUMBER));
        if (debitAmt.compareTo(CasConstants.ZERO) != 0) {
            tableRow.addCell("debitAmount").setValue(debitAmt);
        }
        if (creditAmt.compareTo(CasConstants.ZERO) != 0) {
            tableRow.addCell("creditAmount").setValue(creditAmt);
        }
        tableRow.addCell(COL_BALANCE).setValue(balance.abs());
        tableRow.addCell(COL_EXCHANGE).setValue(exchange);
        tableRow.addCell(COL_SOURCE).setValue(JournalSourceEnum.getEnum((int)rs.getInt(COL_SOURCE)));
        tableRow.addCell("periodYear").setValue(rs.getObject("periodYear"));
        tableRow.addCell("periodNumber").setValue(rs.getObject("periodNumber"));
        tableRow.addCell(COL_CASHIER).setValue(rs.getString("cashier"));
        tableRow.addCell("oppAcctNumber").setValue(rs.getString("oppAccountViewNumber"));
        VerifyScopeEnum verifyScope = VerifyScopeEnum.getEnum((int)rs.getInt("verifyStatus"));
        if (verifyScope.equals((Object)VerifyScopeEnum.NOVA)) {
            tableRow.addCell("verify").setValue(Boolean.FALSE);
        } else {
            tableRow.addCell("verify").setValue(Boolean.TRUE);
        }
        CasWorkPlatfromCashJournalUtil.fillLocalCurrencyData(ctx, tableRow, exchange, debitAmt, creditAmt, balance, isCurEqualsBasecur, convertMode, dc, GL_005);
    }

    public static void setBeginBalanceRowDisc(Context ctx, QueryTable queryTable, Date beginDate, boolean isByDay, BigDecimal exchange, boolean isCurEqualsBasecur, BigDecimal dayBalance, ConvertModeEnum convertMode, BalanceDirectionEnum dc, boolean GL_005) {
        QueryTableRow tableRow = null;
        String DAY_BALANCE = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_DayStart", (Locale)ctx.getLocale());
        String BEGIN_BALANCE = EASCommonResource.getString((String)resourcePath, (String)"BeginBalance", (Locale)ctx.getLocale());
        if (isByDay) {
            String desc = null;
            int size = queryTable.getRowCount() >= 2 ? 2 : queryTable.getRowCount();
            for (int i = 1; i <= size; ++i) {
                tableRow = queryTable.getRow(i);
                desc = (String)tableRow.addCell(COL_DESCRIPTION).getValue();
                if (desc == null || !desc.equals(BEGIN_BALANCE)) continue;
                desc = DAY_BALANCE;
                CasWorkPlatfromCashJournalUtil.fillBalance(ctx, tableRow, exchange, dayBalance, isCurEqualsBasecur, desc, beginDate, convertMode, dc, GL_005);
                break;
            }
        }
    }

    public static FilterInfo getAcctDataPermission(Context ctx, String userId, String companyId) throws BOSException, EASBizException {
        ObjectUuidPK userPK = new ObjectUuidPK(userId);
        ObjectUuidPK orgPK = new ObjectUuidPK(companyId);
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance((Context)ctx);
        String rule = provider.getPermissionRule((IObjectPK)userPK, (IObjectPK)orgPK, "cas_cashbook_01view");
        EntityViewInfo evi = null;
        try {
            evi = rule == null ? new EntityViewInfo() : new EntityViewInfo(rule);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        FilterInfo filterAccount = new FilterInfo();
        boolean hasOtherAccountFilter = false;
        if (evi.getFilter() != null && evi.getFilter().getFilterItems() != null) {
            FilterItemCollection filterItems = evi.getFilter().getFilterItems();
            for (int i = 0; i < filterItems.size(); ++i) {
                FilterItemInfo item = filterItems.get(i);
                String propertyName = item.getPropertyName();
                if (propertyName.indexOf("accountView") >= 0) {
                    String property = propertyName.substring(12, propertyName.length());
                    FilterItemInfo item2 = new FilterItemInfo(property, item.getCompareValue(), item.getCompareType());
                    filterAccount.getFilterItems().add(item2);
                    continue;
                }
                hasOtherAccountFilter = true;
            }
        }
        if (!hasOtherAccountFilter && filterAccount.getFilterItems().size() > 0) {
            filterAccount.setMaskString(evi.getFilter().getMaskString());
        }
        return filterAccount;
    }

    public static AccountRefContrastCollection getStrideAcctRefContrastColl(Context ctx, String companyId, Date beginDate, Date endDate) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.endDate", (Object)DateTimeUtils.truncateDate((Date)beginDate), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.endDate", (Object)DateTimeUtils.truncateDate((Date)endDate), CompareType.LESS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IAccountRefContrast acctContrast = AccountRefContrastFactory.getLocalInstance((Context)ctx);
        AccountRefContrastCollection coll = acctContrast.getAccountRefContrastCollection(evi);
        return coll;
    }

    public static String getDisplayAcctTable(Context ctx, FetchAccTableParam param) throws EASBizException, BOSException {
        AccountRefContrastInfo info;
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(param.getCompanyId()));
        String accountTableId = companyInfo.getAccountTable().getId().toString();
        PeriodInfo beginPeriod = null;
        PeriodInfo endPeriod = null;
        if (param.isByDay()) {
            beginPeriod = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, new Date(param.getBeginDateLong()), companyInfo);
            endPeriod = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, new Date(param.getEndDateLong()), companyInfo);
        } else {
            beginPeriod = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, param.getBeginYear(), param.getBeginMonth(), companyInfo);
            endPeriod = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, param.getEndYear(), param.getEndMonth(), companyInfo);
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)beginPeriod) || EmptyUtil.isEmpty((CoreBaseInfo)endPeriod)) {
            throw new CasException(CasException.STARTPERIODNULL);
        }
        AccountRefContrastCollection coll = CasWorkPlatfromCashJournalUtil.getStrideAcctRefContrastColl(ctx, param.getCompanyId(), beginPeriod.getBeginDate(), endPeriod.getEndDate());
        if (coll != null && coll.size() > 0) {
            AccountRefContrastInfo info2 = null;
            String acctTable = "";
            for (int i = 0; i < coll.size(); ++i) {
                info2 = coll.get(i);
                if (info2.getRefType() != null && 1 == info2.getRefType().getValue()) {
                    throw new FMException(FMException.HASCOMPANYADJUSTACCT, new Object[]{companyInfo.getName()});
                }
                if (info2.getRefType() == null || 2 == info2.getRefType().getValue()) continue;
                acctTable = info2.getDisabledAcctTable().getId().toString();
            }
            if (EmptyUtil.isEmpty((String)acctTable)) {
                acctTable = coll.get(0).getEnabledAcctTable().getId().toString();
            }
            return acctTable;
        }
        if (endPeriod.isIsAdjustPeriod() && (info = AccountRefContrastFactory.getLocalInstance((Context)ctx).getLastAcctInfo(param.getCompanyId(), accountTableId, endPeriod.getPeriodYear(), endPeriod.getPeriodNumber())).getEnabledPeriod() != null && info.getEnabledPeriod().getId().equals((Object)endPeriod.getId())) {
            return info.getDisabledAcctTable() == null ? null : info.getDisabledAcctTable().getId().toString();
        }
        return AccountTools.getCurrentAcctTable((Context)ctx, (String)param.getCompanyId(), (String)accountTableId, (int)endPeriod.getPeriodYear(), (int)endPeriod.getPeriodNumber());
    }

    public static CurrencyCollection getCurrencyByAccView(Context ctx, String accViewId) throws EASBizException, BOSException {
        CurrencyCollection currencyCol = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1));
        view.setFilter(filter);
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        currencyCol = iCurrency.getCurrencyCollection(view, true);
        return currencyCol;
    }
}

