/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.VOComparator;
import com.kingdee.eas.framework.SystemEnum;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class CashMgtInitFetchParam {
    public static Map fetchParam(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("company", company);
        paramMap.put("isStart", CashMgtInitFetchParam.isStart(ctx, company));
        paramMap.put("isGLStart", CashMgtInitFetchParam.isGLStart(ctx, company));
        paramMap.put("startPeriod", CashMgtInitFetchParam.getStartPeriod(ctx, company));
        paramMap.put("currentPeriod", CashMgtInitFetchParam.getCurrentPeriod(ctx, company));
        paramMap.put("baseCurrency", CashMgtInitFetchParam.getBaseCurrency(ctx, company));
        paramMap.put("currencyCollection", CashMgtInitFetchParam.getCurrencyCollection(ctx));
        return paramMap;
    }

    public static boolean isStart(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        return ictrol.isStart(new Integer(7).intValue(), company.getId().toString());
    }

    public static boolean isGLStart(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        return ictrol.isStart(new Integer(6).intValue(), company.getId().toString());
    }

    public static PeriodInfo getStartPeriod(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        if (startPeriodInfo == null) {
            return null;
        }
        return startPeriodInfo;
    }

    public static PeriodInfo getCurrentPeriod(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
    }

    public static CurrencyInfo getBaseCurrency(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        CurrencyInfo currency = null;
        if (company.getBaseCurrency() != null) {
            currency = company.getBaseCurrency();
            return currency;
        }
        ICompanyOrgUnit corgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("baseCurrency.*");
        CompanyOrgUnitInfo info = corgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selectors);
        currency = info.getBaseCurrency();
        return currency;
    }

    public static CurrencyCollection getCurrencyCollection(Context ctx) throws BOSException, EASBizException {
        CurrencyCollection col = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(true);
        VOComparator comp = new VOComparator(new String[]{"number"}, true);
        Object[] infoArray = col.toArray();
        Arrays.sort(infoArray, comp);
        col.clear();
        for (int i = 0; i < infoArray.length; ++i) {
            col.addObject((IObjectValue)infoArray[i]);
        }
        return col;
    }
}

