/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.AccountTypeEnum;
import com.kingdee.eas.fi.cas.CashMgtInitFacadeFactory;
import com.kingdee.eas.fi.cas.ICashMgtInitFacade;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class FMHelper {
    private static Logger logger = Logger.getLogger((String)FMHelper.class.getName());

    public static CompanyOrgUnitCollection getUserOrgRangesWithRange(Context ctx, String permissionItem) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        UserInfo userInfo = null;
        userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection mainOrgs = permission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, null, permissionItem);
        for (int i = 0; i < mainOrgs.size(); ++i) {
            FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)mainOrgs.getObject(i);
            idSet.add(orgUnit.getId().toString());
        }
        if (idSet.size() == 0) {
            return new CompanyOrgUnitCollection();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter2 = new FilterInfo();
        view.setFilter(filter2);
        filter2.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("baseCurrency.id");
        sic.add("baseCurrency.number");
        sic.add("baseCurrency.name");
        sic.add("accountTable.id");
        sic.add("accountTable.name");
        view.setSelector(sic);
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorterColl.add(new SorterItemInfo("number"));
        view.setSorter(sorterColl);
        return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
    }

    public static AccountViewCollection getAcctViewCollection(Context ctx, String companyId, String acctTableId, String currencyId, AccountTypeEnum acctType) throws BOSException, EASBizException {
        ICashMgtInitFacade iCashFacade = null;
        iCashFacade = CashMgtInitFacadeFactory.getLocalInstance(ctx);
        return iCashFacade.getAcctViewCollection(companyId, acctTableId, currencyId, acctType);
    }

    public static boolean isExistMultiBankAcct(Context ctx, String companyId, String accountId) throws BOSException {
        StringBuffer strBuffer = new StringBuffer("select count(FID) as counts from T_BD_AccountBanks where FCompanyID='");
        strBuffer.append(companyId);
        strBuffer.append("' AND FAccountID ='");
        strBuffer.append(accountId);
        strBuffer.append("'");
        IRowSet rs = null;
        ISQLExecutor sqlExe = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)strBuffer.toString());
        int counts = 0;
        try {
            rs = sqlExe.executeSQL();
            if (rs != null && rs.next()) {
                counts = rs.getInt("counts");
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return counts > 1;
    }

    public static CompanyOrgUnitCollection getUserOrgRangesWithRangeWhereStartPeriod(Context ctx, String permissionItem) throws BOSException, EASBizException, SQLException {
        IPermission permission;
        HashSet<String> idSet = new HashSet<String>();
        UserInfo userInfo = null;
        if (ctx != null) {
            userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            permission = PermissionFactory.getLocalInstance((Context)ctx);
        } else {
            userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
            permission = PermissionFactory.getRemoteInstance();
        }
        FullOrgUnitCollection mainOrgs = permission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, null, permissionItem);
        for (int i = 0; i < mainOrgs.size(); ++i) {
            FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)mainOrgs.getObject(i);
            idSet.add(orgUnit.getId().toString());
        }
        if (idSet.size() == 0) {
            return new CompanyOrgUnitCollection();
        }
        return FMHelper.getStartPeriodOrgRange(ctx, idSet);
    }

    private static CompanyOrgUnitCollection getStartPeriodOrgRange(Context ctx, Set companySet) throws BOSException, SQLException {
        IRowSet rowSet = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select FCompanyID from T_BD_SystemStatusCtrol sysStaCtr,T_BD_SystemStatus sysSta ");
        sql.append(" where sysStaCtr.FSystemStatusID=sysSta.FID ");
        sql.append(" and FStartPeriodID is not null and sysStaCtr.FCompanyID in ");
        sql.append(FMHelper.setTran2String(companySet));
        sql.append(" and sysSta.FName= ");
        sql.append(7);
        rowSet = ctx != null ? SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString()).executeSQL() : SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        HashSet<String> idSet = new HashSet<String>();
        while (rowSet.next()) {
            idSet.add(rowSet.getString("FCompanyID"));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter2 = new FilterInfo();
        view.setFilter(filter2);
        filter2.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("baseCurrency.id");
        sic.add("baseCurrency.number");
        sic.add("baseCurrency.name");
        sic.add("accountTable.id");
        sic.add("accountTable.name");
        view.setSelector(sic);
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorterColl.add(new SorterItemInfo("number"));
        view.setSorter(sorterColl);
        if (ctx != null) {
            return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        }
        return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
    }

    public static String setTran2String(Set idSet) {
        if (idSet == null || idSet.size() < 1) {
            return "('')";
        }
        String ids = null;
        Iterator iter = idSet.iterator();
        int i = 0;
        while (iter.hasNext()) {
            ids = ids == null ? "('" + (String)iter.next() + "'" : ids + ", '" + (String)iter.next() + "'";
            ++i;
        }
        ids = ids + ")";
        return ids;
    }

    public static boolean checkCurrentCompany(Context ctx, CompanyOrgUnitInfo currentCompany, String permissionItem) throws EASBizException, BOSException, SQLException {
        if (currentCompany.isIsBizUnit() && !currentCompany.isIsOUSealUp() && !currentCompany.isIsAssistantOrg()) {
            PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)currentCompany);
            if (null == startPeriod) {
                return false;
            }
            IPermission permission = null;
            permission = ctx != null ? PermissionFactory.getLocalInstance((Context)ctx) : PermissionFactory.getRemoteInstance();
            UserInfo user = null;
            user = ctx != null ? ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser() : SysContext.getSysContext().getCurrentUserInfo();
            boolean hasPermission = permission.hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(currentCompany.getId()), permissionItem);
            return hasPermission;
        }
        return false;
    }

    public static ExchangeRateInfo getExRateInfo(Context ctx, String srcCurrId, String destCurrId, CompanyOrgUnitInfo company, Date date) {
        ExchangeTableInfo baseExchangeTable;
        if (company == null) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        }
        if (destCurrId == null) {
            destCurrId = company.getBaseCurrency().getId().toString();
        }
        if ((baseExchangeTable = company.getBaseExchangeTable()) == null) {
            return null;
        }
        ExchangeRateInfo exRateInfo = null;
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(srcCurrId);
        ObjectUuidPK destCurrpk = new ObjectUuidPK(destCurrId);
        ObjectUuidPK exchangeTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        if (sourceCurrpk.equals((Object)destCurrpk)) {
            exRateInfo = new ExchangeRateInfo();
            exRateInfo.setConvertRate(new BigDecimal(1));
            return exRateInfo;
        }
        try {
            IExchangeRate iExchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
            exRateInfo = iExchangRate.getExchangeRateConvertInfo((IObjectPK)exchangeTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, DateTimeUtils.truncateDate((Date)date));
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        return exRateInfo;
    }

    public static boolean isDirectExchange(Context ctx, CurrencyInfo currencyInfo, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        ExchangeRateInfo exgRateInfo;
        boolean isDirectExchange = true;
        if (currencyInfo != null && (exgRateInfo = FMHelper.getExgRateInfo(ctx, currencyInfo, new Date(), companyInfo)) != null) {
            isDirectExchange = exgRateInfo.getExchangeAux() != null && ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)exgRateInfo.getExchangeAux().getConvertMode());
        }
        return isDirectExchange;
    }

    public static boolean chargeIsDirectExchange(ExchangeRateInfo exgRateInfo) throws EASBizException, BOSException {
        boolean isDirectExchange = true;
        if (exgRateInfo != null) {
            isDirectExchange = exgRateInfo.getExchangeAux() != null && ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)exgRateInfo.getExchangeAux().getConvertMode());
        }
        return isDirectExchange;
    }

    public static ExchangeRateInfo getExgRateInfo(Context ctx, CurrencyInfo currency, Date billDate, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        String currencyId = currency.getId().toString();
        String baseCurrencyId = "";
        CurrencyInfo baseCurrency = companyInfo.getBaseCurrency();
        if (null != baseCurrency) {
            baseCurrencyId = baseCurrency.getId().toString();
        } else {
            String sql = "select FBASECURRENCYID  from T_ORG_Company where fid ='" + companyInfo.getId() + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (rowSet.next()) {
                    baseCurrencyId = rowSet.getString("FBASECURRENCYID");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (!StringUtils.isEmpty((String)baseCurrencyId) && !currencyId.equals(baseCurrencyId)) {
            return FMHelper.getExRateInfo(ctx, currencyId, baseCurrencyId, companyInfo, billDate);
        }
        return null;
    }

    public static BigDecimal calLocAmt(BigDecimal amt, boolean isDirectExchange, BigDecimal exRate, int baseScale) throws EASBizException, BOSException {
        BigDecimal apLocAmt = new BigDecimal("0.00");
        apLocAmt = isDirectExchange ? amt.multiply(exRate).setScale(baseScale, 4) : (SysConstant.BIGZERO.compareTo(exRate) != 0 ? amt.divide(exRate, baseScale, 4) : amt.multiply(exRate).setScale(baseScale, 4));
        return apLocAmt;
    }
}

