/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.util.BOSObjectType;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InvokeUtil {
    private static final Logger logger = Logger.getLogger(InvokeUtil.class);
    private static Map<String, Method> bizCtrlMethodMap = new HashMap<String, Method>();
    private static Map<String, Class> classMap = new HashMap<String, Class>();

    public static Map invoke(Context ctx, String bosType, String methodName, Set params) throws Exception {
        long start = System.currentTimeMillis();
        Map ret = new HashMap();
        IBizCtrl bizCtrl = InvokeUtil.getBizCtrl(ctx, bosType);
        if (bizCtrl == null) {
            return ret;
        }
        long end = System.currentTimeMillis();
        logger.error((Object)("getBizCtrl cost time (ms) = " + (end - start)));
        Method method = bizCtrlMethodMap.get(bosType + "_" + methodName);
        if (method == null) {
            method = bizCtrl.getClass().getDeclaredMethod(methodName, Set.class);
            bizCtrlMethodMap.put(bosType + "_" + methodName, method);
        }
        ret = (Map)method.invoke((Object)bizCtrl, params);
        logger.error((Object)(" method.invoke cost time (ms) = " + (System.currentTimeMillis() - end)));
        return ret;
    }

    public static Map invokeApBalance(Context ctx, String bosType, String methodName, IObjectPK companyPK, IObjectPK customerPK) throws Exception {
        long start = System.currentTimeMillis();
        Map ret = new HashMap();
        IBizCtrl bizCtrl = InvokeUtil.getBizCtrl(ctx, bosType);
        if (bizCtrl == null) {
            return ret;
        }
        long end = System.currentTimeMillis();
        logger.error((Object)("getBizCtrl cost time (ms) = " + (end - start)));
        Method method = bizCtrlMethodMap.get(bosType + "_" + methodName);
        if (method == null) {
            method = bizCtrl.getClass().getDeclaredMethod(methodName, IObjectPK.class, IObjectPK.class);
            bizCtrlMethodMap.put(bosType + "_" + methodName, method);
        }
        ret = (Map)method.invoke((Object)bizCtrl, companyPK, customerPK);
        logger.error((Object)(" method.invoke cost time (ms) = " + (System.currentTimeMillis() - end)));
        return ret;
    }

    public static IBizCtrl getBizCtrl(Context ctx, String bosType) {
        IBizCtrl bizCtrl = null;
        if (bizCtrl == null) {
            try {
                bizCtrl = (IBizCtrl)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)new BOSObjectType(bosType));
            }
            catch (Exception e) {
                logger.error((Object)("bosType:" + bosType + "  bizCtrlNotFound"));
            }
        }
        return bizCtrl;
    }

    public static IBizCtrl getBizCtrl(String className, String bosType) {
        IBizCtrl bizCtrl = null;
        if (bizCtrl == null) {
            try {
                bizCtrl = (IBizCtrl)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)new BOSObjectType(bosType), Class.forName(className));
            }
            catch (Exception e) {
                logger.error((Object)("bosType:" + bosType + "  bizCtrlNotFound"));
            }
        }
        return bizCtrl;
    }

    public static Class getClass(String className) {
        Class<?> clazz = classMap.get(className);
        if (clazz == null) {
            try {
                clazz = Class.forName(className);
                classMap.put(className, clazz);
            }
            catch (Exception e) {
                logger.error((Object)("className:" + className + "  ClassNotFound"));
            }
        }
        return clazz;
    }

    public static Method getMethod(String className, String methodName, Class<?> ... params) {
        Method method = null;
        try {
            Class<?> clazz = Class.forName(className);
            method = clazz.getDeclaredMethod(methodName, params);
        }
        catch (ClassNotFoundException e) {
            return method;
        }
        catch (NoSuchMethodException e) {
            return method;
        }
        return method;
    }
}

