/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountRefContrast;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CashAccountTool;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.IJournalBalance;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.JournalBalanceCollection;
import com.kingdee.eas.fi.cas.JournalBalanceFactory;
import com.kingdee.eas.fi.cas.JournalBalanceInfo;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.utils.BankJournalWebUtil;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.CasBsfExceptionHandler;
import com.kingdee.eas.fi.cas.utils.CashJournalWebUtil;
import com.kingdee.eas.fi.cas.web.param.FetchAccTableParam;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IContextHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.ISettlementBill;
import com.kingdee.eas.fm.fs.SettlementBillCollection;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class JournalWebUtil {
    private static final String resourcePath2 = "com.kingdee.eas.fi.cas.CasResources";
    public static final String STRING_ZERO = "0";
    public static final String STRING_ONE = "1";

    public static ConvertModeEnum getExchangeConvertMode(Context ctx, CompanyOrgUnitInfo company, CurrencyInfo sourceCurrency, CurrencyInfo desCurrency) throws EASBizException, BOSException {
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK sourceCurrpk = null;
        ObjectUuidPK destCurrpk = null;
        if (company.getBaseExchangeTable() == null || company.getBaseCurrency() == null) {
            company = BankJournalWebUtil.getCompanyInfo(ctx, company.getId());
        }
        if (sourceCurrency == null) {
            return ConvertModeEnum.DIRECTEXCHANGERATE;
        }
        if (desCurrency == null) {
            desCurrency = company.getBaseCurrency();
        }
        if (company.getBaseExchangeTable() == null) {
            return ConvertModeEnum.DIRECTEXCHANGERATE;
        }
        excTablepk = new ObjectUuidPK(company.getBaseExchangeTable().getId());
        if (desCurrency == null) {
            return ConvertModeEnum.DIRECTEXCHANGERATE;
        }
        if (desCurrency.getId().equals((Object)sourceCurrency.getId())) {
            return ConvertModeEnum.DIRECTEXCHANGERATE;
        }
        destCurrpk = new ObjectUuidPK(desCurrency.getId());
        iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRateConvertInfo((IObjectPK)excTablepk, (IObjectPK)(sourceCurrpk = new ObjectUuidPK(sourceCurrency.getId())), (IObjectPK)destCurrpk, Calendar.getInstance().getTime());
        if (erInfo == null) {
            return ConvertModeEnum.DIRECTEXCHANGERATE;
        }
        return erInfo.getConvertMode();
    }

    public static CompanyOrgUnitInfo getCompanyInfo(Context ctx, String companyIdStr) throws BOSException, EASBizException {
        ObjectUuidPK compk = new ObjectUuidPK(companyIdStr);
        ICompanyOrgUnit comorg = null;
        CompanyOrgUnitInfo comorgInfo = null;
        comorg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseExchangeTable"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        comorgInfo = comorg.getCompanyOrgUnitInfo((IObjectPK)compk, sic);
        return comorgInfo;
    }

    public static boolean isShowLocalCurrency(String companyId) {
        IContextHelper iCtxHelper = ContextHelperFactory.getRemoteInstance();
        return iCtxHelper.getBooleanParam("CS003", (IObjectPK)new ObjectUuidPK(companyId));
    }

    public static List<String> getAuthorizedOrg(Context ctx, String prmitItems, String UserIdStr) throws BOSException, EASBizException {
        LinkedList<String> idSet = new LinkedList<String>();
        IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection orgColls = permission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(UserIdStr), OrgType.Company, null, prmitItems);
        orgColls.sort("number");
        for (int idx = 0; idx < orgColls.size(); ++idx) {
            FullOrgUnitInfo orgUnit = orgColls.get(idx);
            if (orgUnit == null || orgUnit.getId() == null) continue;
            idSet.add(orgUnit.getId().toString());
        }
        return idSet;
    }

    public static AccountViewCollection getAccountViewList(Context ctx, String companyId, String acctTableId, boolean isShowForbidden) throws BOSException, EASBizException {
        AccountViewCollection accountCol = null;
        if (!EmptyUtil.isEmpty((String)companyId) && !EmptyUtil.isEmpty((String)acctTableId)) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection items = filter.getFilterItems();
            items.add(new FilterItemInfo("isLeaf", (Object)STRING_ONE));
            items.add(new FilterItemInfo("isCash", (Object)STRING_ONE));
            if (!isShowForbidden) {
                items.add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
                items.add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
            }
            FilterInfo filterAccount = CashJournalWebUtil.getAcctDataPermission(ctx, ctx.getCaller().toString(), companyId);
            view.getFilter().mergeFilter(filterAccount, "and");
            accountCol = FMHelper.getAccountViewCollection((Context)ctx, (String)companyId, (String)acctTableId, null, (EntityViewInfo)view);
        }
        return accountCol;
    }

    public static void isReferenced(Context ctx, String idStr) throws BOSException, EASBizException {
        if (ctx != null && idStr != null) {
            try {
                JournalFactory.getLocalInstance(ctx).isReferenced((IObjectPK)new ObjectUuidPK(idStr));
            }
            catch (BOSException e) {
                CasBsfExceptionHandler.handle(ctx, (Exception)((Object)e));
            }
        }
    }

    public static BigDecimal getExchangeRate(Context ctx, String companyIdStr, String srcCurId, String desCurId, Date date) throws EASBizException, BOSException {
        BigDecimal exchangeRate = null;
        if (companyIdStr != null && srcCurId != null && desCurId != null) {
            CompanyOrgUnitInfo company = JournalWebUtil.getCompanyInfo(ctx, companyIdStr);
            CurrencyInfo sourceCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(srcCurId));
            CurrencyInfo desCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(desCurId));
            exchangeRate = JournalWebUtil.getExchange(ctx, company, sourceCurrency, desCurrency, date);
        }
        return exchangeRate;
    }

    public static BigDecimal getSimpleExchangeRate(Context ctx, String companyIdStr, String srcCurId) throws EASBizException, BOSException {
        BigDecimal exchangeRate = null;
        if (companyIdStr != null && srcCurId != null) {
            CompanyOrgUnitInfo company = JournalWebUtil.getCompanyInfo(ctx, companyIdStr);
            CurrencyInfo sourceCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(srcCurId));
            exchangeRate = JournalWebUtil.getExchange(ctx, company, sourceCurrency, null, null);
        }
        return exchangeRate;
    }

    public static BigDecimal getExchange(Context ctx, CompanyOrgUnitInfo company, CurrencyInfo sourceCurrency, CurrencyInfo desCurrency, Date date) throws EASBizException, BOSException {
        if (null == date) {
            date = Calendar.getInstance().getTime();
        }
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK sourceCurrpk = null;
        ObjectUuidPK destCurrpk = null;
        if (sourceCurrency == null) {
            return null;
        }
        if (desCurrency == null) {
            desCurrency = company.getBaseCurrency();
        }
        if (company.getBaseExchangeTable() == null) {
            throw new BOSException(EASCommonResource.getString((String)resourcePath2, (String)"NoExchangeTable", (Locale)ctx.getLocale()));
        }
        excTablepk = new ObjectUuidPK(company.getBaseExchangeTable().getId());
        if (desCurrency == null) {
            return null;
        }
        if (desCurrency.getId().equals((Object)sourceCurrency.getId())) {
            return new BigDecimal(STRING_ONE).setScale(2, 4);
        }
        destCurrpk = new ObjectUuidPK(desCurrency.getId());
        iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRateConvertInfo((IObjectPK)excTablepk, (IObjectPK)(sourceCurrpk = new ObjectUuidPK(sourceCurrency.getId())), (IObjectPK)destCurrpk, date);
        if (erInfo == null) {
            throw new BOSException(EASCommonResource.getString((String)resourcePath2, (String)"NoExchange", (Locale)ctx.getLocale()));
        }
        return erInfo.getConvertRate();
    }

    public static Integer getIsIndirectRate(Context ctx, CompanyOrgUnitInfo company, CurrencyInfo sourceCurrency, CurrencyInfo desCurrency, Date date) throws EASBizException, BOSException {
        if (null == date) {
            date = Calendar.getInstance().getTime();
        }
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK sourceCurrpk = null;
        ObjectUuidPK destCurrpk = null;
        if (sourceCurrency == null) {
            return null;
        }
        if (desCurrency == null) {
            desCurrency = company.getBaseCurrency();
        }
        if (company.getBaseExchangeTable() == null) {
            throw new BOSException(EASCommonResource.getString((String)resourcePath2, (String)"NoExchangeTable", (Locale)ctx.getLocale()));
        }
        excTablepk = new ObjectUuidPK(company.getBaseExchangeTable().getId());
        if (desCurrency == null) {
            return null;
        }
        if (desCurrency.getId().equals((Object)sourceCurrency.getId())) {
            return 0;
        }
        destCurrpk = new ObjectUuidPK(desCurrency.getId());
        iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRateConvertInfo((IObjectPK)excTablepk, (IObjectPK)(sourceCurrpk = new ObjectUuidPK(sourceCurrency.getId())), (IObjectPK)destCurrpk, date);
        if (erInfo == null) {
            throw new BOSException(EASCommonResource.getString((String)resourcePath2, (String)"NoExchange", (Locale)ctx.getLocale()));
        }
        return erInfo.getExchangeAux().getConvertMode().getValue();
    }

    public static void verifyRate(Context ctx, JournalInfo info) throws EASBizException, BOSException {
        BigDecimal rate;
        CompanyOrgUnitInfo company = info.getCompany();
        SelectorItemCollection sict = new SelectorItemCollection();
        sict.add(new SelectorItemInfo("id"));
        sict.add(new SelectorItemInfo("currency.id"));
        sict.add(new SelectorItemInfo("currency.number"));
        sict.add(new SelectorItemInfo("baseExchangeTable.id"));
        sict.add(new SelectorItemInfo("baseCurrency.id"));
        sict.add(new SelectorItemInfo("baseCurrency.number"));
        company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), sict);
        String srcCurrency = info.getCurrency().getId().toString();
        String destCurrency = company.getBaseCurrency().getId().toString();
        if (!srcCurrency.equals(destCurrency) && EmptyUtil.isEmpty((Object)(rate = JournalWebUtil.getExchange(ctx, company, info.getCurrency(), company.getBaseCurrency(), info.getBizDate())))) {
            throw new BOSException(CASWebUtil.getResource(ctx, resourcePath2, "NoExchange"));
        }
    }

    public static VoucherInfo getVoucherInfo(Context ctx, String billId) throws BOSException, EASBizException {
        Iterator iter;
        if (StringUtils.isEmpty((String)billId)) {
            return null;
        }
        VoucherInfo voucherInfo = null;
        BOSUuid uuid = BOSUuid.read((String)billId);
        String billBosType = uuid.getType().toString();
        String voucherBosType = new VoucherInfo().getBOSType().toString();
        IBOTRelation iBotRelation = null;
        IVoucher iVoucher = null;
        iBotRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("srcObjectID", (Object)billId));
        items.add(new FilterItemInfo("srcEntityID", (Object)billBosType));
        items.add(new FilterItemInfo("destEntityID", (Object)voucherBosType));
        BOTRelationCollection relationCollection = iBotRelation.getCollection(view);
        if (relationCollection != null && relationCollection.size() > 0 && (iter = relationCollection.iterator()).hasNext()) {
            BOTRelationInfo relationInfo = (BOTRelationInfo)iter.next();
            String voucherId = relationInfo.getDestObjectID();
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("*"));
            selectors.add(new SelectorItemInfo("entries.*"));
            voucherInfo = (VoucherInfo)iVoucher.getValue((IObjectPK)new ObjectUuidPK(voucherId), selectors);
        }
        return voucherInfo;
    }

    public static void setOppAccount(JournalInfo entryInfo, VoucherInfo voucherInfo) {
        HashMap mapDebit = new HashMap();
        HashMap mapCredit = new HashMap();
        CashHelper.analysisVoucher(voucherInfo, mapDebit, mapCredit);
        VoucherEntryInfo oppVoucherInfo = null;
        if (entryInfo.isIsDebit()) {
            Object[] voucherEntryCol = mapCredit.values().toArray();
            if (voucherEntryCol.length > 0) {
                oppVoucherInfo = (VoucherEntryInfo)voucherEntryCol[0];
            }
        } else {
            Object[] voucherEntryCol = mapDebit.values().toArray();
            if (voucherEntryCol.length > 0) {
                oppVoucherInfo = (VoucherEntryInfo)voucherEntryCol[0];
            }
        }
        if (oppVoucherInfo != null) {
            entryInfo.setOppAccountView(oppVoucherInfo.getAccount());
        }
    }

    public static String getBillIdByBillNumber(Context ctx, String billNum, CompanyOrgUnitInfo companyInfo, int billType) throws EASBizException, BOSException {
        ISettlementBill iSettlementBill;
        SettlementBillCollection settlementBillCollection;
        IReceivingBill iReceivingBill;
        ReceivingBillCollection receivingBillCollection;
        Iterator iter;
        IPaymentBill iPaymentBill;
        PaymentBillCollection paymentBillCollection;
        String billId = null;
        String str = companyInfo.getName();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("number", (Object)billNum));
        items.add(new FilterItemInfo("company.name", (Object)str));
        view.setFilter(filter);
        if (billType == 16 && (paymentBillCollection = (iPaymentBill = PaymentBillFactory.getLocalInstance(ctx)).getPaymentBillCollection(view)) != null && paymentBillCollection.size() > 0 && (iter = paymentBillCollection.iterator()).hasNext()) {
            PaymentBillInfo paymentBillInfo = (PaymentBillInfo)iter.next();
            billId = paymentBillInfo.getId().toString();
        }
        if (billType == 15 && (receivingBillCollection = (iReceivingBill = ReceivingBillFactory.getLocalInstance(ctx)).getReceivingBillCollection(view)) != null && receivingBillCollection.size() > 0 && (iter = receivingBillCollection.iterator()).hasNext()) {
            ReceivingBillInfo receivingBillInfo = (ReceivingBillInfo)iter.next();
            billId = receivingBillInfo.getId().toString();
        }
        if (billType == 17 && (settlementBillCollection = (iSettlementBill = SettlementBillFactory.getLocalInstance((Context)ctx)).getSettlementBillCollection(view)) != null && settlementBillCollection.size() > 0 && (iter = settlementBillCollection.iterator()).hasNext()) {
            SettlementBillInfo settlementBillInfo = (SettlementBillInfo)iter.next();
            billId = settlementBillInfo.getId().toString();
        }
        return billId;
    }

    public static PeriodInfo getCurrentPeriod(Context ctx, String companyId) throws BOSException, EASBizException {
        PeriodInfo periodInfo = null;
        if (companyId != null) {
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        }
        return periodInfo;
    }

    public static String getAccTableIdByPeriod(String companyId, String accountTableId, int beginYear, int beginMonth, int endYear, int endMonth) throws BOSException, EASBizException {
        String accTableId = null;
        accTableId = CashAccountTool.getDisplayAcctTable(companyId, null, beginYear, beginMonth, endYear, endMonth);
        return accTableId;
    }

    public static String getAccTableIdByDate(String companyId, Date beginDate, Date endDate) {
        String accTableId = null;
        accTableId = FMClientHelper.getActualAcctTable((String)companyId, (Date)beginDate, (Date)endDate);
        return accTableId;
    }

    public static AccountRefContrastCollection getStrideAcctRefContrastColl(Context ctx, String companyId, Date beginDate, Date endDate) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.endDate", (Object)DateTimeUtils.truncateDate((Date)beginDate), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.endDate", (Object)DateTimeUtils.truncateDate((Date)endDate), CompareType.LESS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IAccountRefContrast acctContrast = AccountRefContrastFactory.getLocalInstance((Context)ctx);
        AccountRefContrastCollection coll = acctContrast.getAccountRefContrastCollection(evi);
        return coll;
    }

    public static String getDisplayAcctTable(Context ctx, FetchAccTableParam param) throws EASBizException, BOSException {
        AccountRefContrastInfo info;
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(param.getCompanyId()));
        String accountTableId = companyInfo.getAccountTable().getId().toString();
        PeriodInfo beginPeriod = null;
        PeriodInfo endPeriod = null;
        if (param.isByDay()) {
            beginPeriod = CashJournalWebUtil.getPeriodInfo(ctx, new Date(param.getBeginDateLong()), companyInfo);
            endPeriod = CashJournalWebUtil.getPeriodInfo(ctx, new Date(param.getEndDateLong()), companyInfo);
        } else {
            beginPeriod = CashJournalWebUtil.getPeriodInfo(ctx, param.getBeginYear(), param.getBeginMonth(), companyInfo);
            endPeriod = CashJournalWebUtil.getPeriodInfo(ctx, param.getEndYear(), param.getEndMonth(), companyInfo);
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)beginPeriod) || EmptyUtil.isEmpty((CoreBaseInfo)endPeriod)) {
            throw new CasException(CasException.STARTPERIODNULL);
        }
        AccountRefContrastCollection coll = JournalWebUtil.getStrideAcctRefContrastColl(ctx, param.getCompanyId(), beginPeriod.getBeginDate(), endPeriod.getEndDate());
        if (coll != null && coll.size() > 0) {
            AccountRefContrastInfo info2 = null;
            String acctTable = "";
            for (int i = 0; i < coll.size(); ++i) {
                info2 = coll.get(i);
                if (info2.getRefType() != null && 1 == info2.getRefType().getValue()) {
                    throw new FMException(FMException.HASCOMPANYADJUSTACCT, new Object[]{companyInfo.getName()});
                }
                if (info2.getRefType() == null || 2 == info2.getRefType().getValue()) continue;
                acctTable = info2.getDisabledAcctTable().getId().toString();
            }
            if (EmptyUtil.isEmpty((String)acctTable)) {
                acctTable = coll.get(0).getEnabledAcctTable().getId().toString();
            }
            return acctTable;
        }
        if (endPeriod.isIsAdjustPeriod() && (info = AccountRefContrastFactory.getLocalInstance((Context)ctx).getLastAcctInfo(param.getCompanyId(), accountTableId, endPeriod.getPeriodYear(), endPeriod.getPeriodNumber())).getEnabledPeriod() != null && info.getEnabledPeriod().getId().equals((Object)endPeriod.getId())) {
            return info.getDisabledAcctTable() == null ? null : info.getDisabledAcctTable().getId().toString();
        }
        return AccountTools.getCurrentAcctTable((Context)ctx, (String)param.getCompanyId(), (String)accountTableId, (int)endPeriod.getPeriodYear(), (int)endPeriod.getPeriodNumber());
    }

    public static AccountBankInfo getAccBankHasAccView(Context ctx, FetchAccTableParam param, String accBankId) throws EASBizException, BOSException {
        AccountBankInfo accBankInfo = null;
        if (ctx != null && param != null && accBankId != null) {
            EntityViewInfo accountBankEntity = new EntityViewInfo();
            FilterInfo accountBankFilter = new FilterInfo();
            accountBankEntity.setFilter(accountBankFilter);
            SelectorItemCollection accountBankSic = new SelectorItemCollection();
            accountBankSic.add(new SelectorItemInfo("*"));
            accountBankEntity.setSelector(accountBankSic);
            accBankInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accBankId), accountBankSic);
            String accTableId = JournalWebUtil.getDisplayAcctTable(ctx, param);
            accBankInfo = JournalWebUtil.getJouranlBalanceAcctBank(ctx, accBankInfo, null, accTableId);
        }
        return accBankInfo;
    }

    public static AccountBankCollection getJouranlBalanceAcctBank(Context ctx, AccountBankCollection acctBankColl, String periodId, String acctTableId) throws BOSException {
        if (acctBankColl == null || acctBankColl.isEmpty()) {
            return acctBankColl;
        }
        HashSet<String> idSet = new HashSet<String>();
        int size = acctBankColl.size();
        for (int i = 0; i < size; ++i) {
            idSet.add(acctBankColl.get(i).getId().toString());
        }
        Map map = JournalWebUtil.getJBAcctBankAcctViewMap(ctx, idSet, periodId, acctTableId);
        AccountBankInfo acctBankInfo = null;
        int size2 = acctBankColl.size();
        for (int i = 0; i < size2; ++i) {
            acctBankInfo = acctBankColl.get(i);
            if (!map.containsKey(acctBankInfo.getId().toString())) continue;
            acctBankInfo.setAccount((AccountViewInfo)map.get(acctBankInfo.getId().toString()));
        }
        return acctBankColl;
    }

    public static AccountBankInfo getJouranlBalanceAcctBank(Context ctx, AccountBankInfo acctBank, String periodId, String acctTableId) throws BOSException, EASBizException {
        if (acctBank == null) {
            return acctBank;
        }
        if (acctBank.getAccount() != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("account.*"));
            sic.add(new SelectorItemInfo("currency.*"));
            sic.add(new SelectorItemInfo("company.*"));
            sic.add(new SelectorItemInfo("account.*"));
            sic.add(new SelectorItemInfo("bank.id"));
            sic.add(new SelectorItemInfo("bank.name"));
            sic.add(new SelectorItemInfo("bank.number"));
            IAccountBank iAcctBank = null;
            iAcctBank = ctx == null ? AccountBankFactory.getRemoteInstance() : AccountBankFactory.getLocalInstance((Context)ctx);
            acctBank = iAcctBank.getAccountBankInfo((IObjectPK)new ObjectUuidPK(acctBank.getId()), sic);
        }
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(acctBank.getId().toString());
        Map map = JournalWebUtil.getJBAcctBankAcctViewMap(ctx, idSet, periodId, acctTableId);
        if (map.containsKey(acctBank.getId().toString())) {
            acctBank.setAccount((AccountViewInfo)map.get(acctBank.getId().toString()));
        }
        return acctBank;
    }

    public static Map getJBAcctBankAcctViewMap(Context ctx, Set acctBankIdSet, String periodId, String acctTableId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)acctBankIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("accountView.isBank", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("accountView.isCash", (Object)Boolean.FALSE));
        if (!EmptyUtil.isEmpty((String)periodId)) {
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)periodId));
        }
        if (!EmptyUtil.isEmpty((String)acctTableId)) {
            filter.getFilterItems().add(new FilterItemInfo("accountView.accountTableID.id", (Object)acctTableId));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("accountBank.id"));
        evi.getSelector().add(new SelectorItemInfo("accountView.*"));
        IJournalBalance iJournal = null;
        iJournal = ctx == null ? JournalBalanceFactory.getRemoteInstance() : JournalBalanceFactory.getLocalInstance(ctx);
        JournalBalanceCollection balanceColl = iJournal.getJournalBalanceCollection(evi);
        JournalBalanceInfo balanceInfo = null;
        HashMap<String, AccountViewInfo> map = new HashMap<String, AccountViewInfo>();
        int size = balanceColl.size();
        for (int i = 0; i < size; ++i) {
            balanceInfo = balanceColl.get(i);
            map.put(balanceInfo.getAccountBank().getId().toString(), balanceInfo.getAccountView());
        }
        return map;
    }

    public static Map<String, String> getResources(Context ctx, String resPath, String[] items) {
        ConcurrentHashMap<String, String> resItems = null;
        if (ctx != null && resPath != null && items != null && items.length > 0) {
            resItems = new ConcurrentHashMap<String, String>(items.length);
            for (String itemName : items) {
                resItems.put(itemName, EASCommonResource.getString((String)resPath, (String)itemName, (Locale)ctx.getLocale()));
            }
        }
        return resItems;
    }

    public static boolean checkHasRate(Context ctx, String companyId, String srcCurrencyId) throws BOSException, EASBizException {
        boolean isShowLocalCurrency;
        boolean flag = true;
        if (companyId != null && srcCurrencyId != null && (isShowLocalCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS003", (IObjectPK)new ObjectUuidPK(companyId)))) {
            CompanyOrgUnitInfo companyInfo = JournalWebUtil.getCompanyInfo(ctx, companyId);
            CurrencyInfo srcCurrencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(srcCurrencyId));
            if (companyInfo.getBaseCurrency() != null && !companyInfo.getBaseCurrency().getId().toString().equals(srcCurrencyId)) {
                JournalWebUtil.getExchange(ctx, companyInfo, srcCurrencyInfo, companyInfo.getBaseCurrency(), null);
            }
        }
        return flag;
    }
}

