/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils.common.tdprint;

import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.fi.cas.utils.common.tdprint.WebCellData;
import com.kingdee.eas.fi.cas.utils.common.tdprint.WebInfoSnapShot;
import com.kingdee.eas.fi.cas.utils.common.tdprint.WebSingleRow;
import com.kingdee.eas.fm.common.util.UserDefineColumnCollection;
import com.kingdee.eas.fm.common.util.UserDefineColumnInfo;
import com.kingdee.eas.util.client.EASResource;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;

public class WebMultiInfoCollSnapShot
implements WebInfoSnapShot {
    private String[] titleKeys;
    private WebSingleRow[] rowList;
    private Map infoCollsMap;
    private String[] headTitles;
    private UserDefineColumnCollection udcc;

    public WebMultiInfoCollSnapShot(Map infoColls, UserDefineColumnCollection udcc) {
        this.infoCollsMap = infoColls;
        this.udcc = udcc;
    }

    public void init() {
        this.initArraySize();
        this.initIitleKeysValue();
        this.initRowList();
    }

    private void initRowList() {
        if (this.rowList.length == 0) {
            this.genBlackRecord();
        } else {
            this.genRecordAccordingTable();
        }
    }

    private void genRecordAccordingTable() {
        for (int i = 0; i < this.rowList.length; ++i) {
            Iterator it = this.infoCollsMap.keySet().iterator();
            int position = 0;
            WebCellData[] cells = new WebCellData[this.titleKeys.length];
            while (it.hasNext()) {
                String key = it.next().toString();
                AbstractObjectCollection infoCollTmp = (AbstractObjectCollection)this.infoCollsMap.get(key);
                int tableRowCount = this._getRowsCount(infoCollTmp);
                if (tableRowCount <= i) {
                    this.fillBlank(infoCollTmp, position, cells);
                } else {
                    this.fillValue(infoCollTmp, infoCollTmp.getObject(i), position, cells);
                }
                position += this._getColumnsCount(infoCollTmp);
            }
            this.assembleUserDefineColumnValue(position, cells);
            this.rowList[i] = new WebSingleRow(cells);
        }
    }

    private void genBlackRecord() {
        Iterator it = this.infoCollsMap.keySet().iterator();
        int position = 0;
        WebCellData[] cells = new WebCellData[this.titleKeys.length];
        while (it.hasNext()) {
            String key = it.next().toString();
            AbstractObjectCollection infoCollTmp = (AbstractObjectCollection)this.infoCollsMap.get(key);
            this.fillBlank(infoCollTmp, position, cells);
            position += this._getColumnsCount(infoCollTmp);
        }
        this.assembleUserDefineColumnValue(position, cells);
        this.rowList[0] = new WebSingleRow(cells);
    }

    private void assembleUserDefineColumnValue(int position, WebCellData[] cells) {
        int userDefineColumnCount = this.udcc.size();
        for (int n = 0; n < userDefineColumnCount; ++n) {
            WebCellData cd;
            UserDefineColumnInfo uudi = this.udcc.getIndex(n);
            cells[n + position] = cd = new WebCellData(uudi.getColumnValue(), String.class, null, uudi.getName(), uudi.getName());
        }
    }

    private void fillValue(AbstractObjectCollection infoCollTmp, IObjectValue rowData, int position, WebCellData[] cells) {
        Class cls = null;
        int colunmCount = this._getColumnsCount(infoCollTmp);
        for (int m = 0; m < colunmCount; ++m) {
            WebCellData cd;
            String columnKey = this.titleKeys[m + position].substring(this.titleKeys[m + position].indexOf(".") + 1);
            Object cellValue = rowData.get(columnKey);
            if (cellValue != null && cellValue instanceof Boolean) {
                Boolean b = (Boolean)cellValue;
                cellValue = b != false ? EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"112_KDTableSnapShot") : EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"113_KDTableSnapShot");
            }
            cells[m + position] = cd = new WebCellData(cellValue, cls, null, this.titleKeys[m + position], this.titleKeys[m + position]);
        }
    }

    private void fillBlank(AbstractObjectCollection infoCollTmp, int position, WebCellData[] cells) {
        Class cls = null;
        int colunmCount = this._getColumnsCount(infoCollTmp);
        for (int m = 0; m < colunmCount; ++m) {
            WebCellData cd;
            cells[m + position] = cd = new WebCellData("", cls, null, this.titleKeys[m + position], this.titleKeys[m + position]);
        }
    }

    private void initIitleKeysValue() {
        Iterator it = this.infoCollsMap.keySet().iterator();
        int position = 0;
        while (it.hasNext()) {
            String key = it.next().toString();
            AbstractObjectCollection infoCollTmp = (AbstractObjectCollection)this.infoCollsMap.get(key);
            this.assembleTableColumn(key, infoCollTmp, position);
            position += this._getColumnsCount(infoCollTmp);
        }
        this.assembleUserDefineColumn(position);
    }

    private void assembleUserDefineColumn(int position) {
        for (int i = 0; i < this.udcc.size(); ++i) {
            UserDefineColumnInfo uudi = this.udcc.getIndex(i);
            this.titleKeys[i + position] = uudi.getName();
            this.headTitles[position + i] = uudi.getAlias();
        }
    }

    private void assembleTableColumn(String tableAlias, AbstractObjectCollection infoCollTmp, int position) {
        if (infoCollTmp.size() <= 0) {
            return;
        }
        IObjectValue info = infoCollTmp.getObject(0);
        Enumeration keysEumeration = info.keys();
        int i = 0;
        while (keysEumeration.hasMoreElements()) {
            Object propertyObj = keysEumeration.nextElement();
            String keyStr = propertyObj.toString();
            this.titleKeys[position + i] = tableAlias + "." + keyStr;
            this.headTitles[position + i] = tableAlias + "." + keyStr;
            ++i;
        }
    }

    private void initArraySize() {
        Iterator it = this.infoCollsMap.keySet().iterator();
        int rowCount = 0;
        int columnCount = 0;
        while (it.hasNext()) {
            String key = it.next().toString();
            AbstractObjectCollection infoCollTmp = (AbstractObjectCollection)this.infoCollsMap.get(key);
            int tblRowCount = this._getRowsCount(infoCollTmp);
            columnCount += this._getColumnsCount(infoCollTmp);
            if (tblRowCount < rowCount) continue;
            rowCount = tblRowCount;
        }
        this.rowList = new WebSingleRow[rowCount];
        this.titleKeys = new String[columnCount + this.udcc.size()];
        this.headTitles = new String[columnCount + this.udcc.size()];
        if (rowCount == 0) {
            this.rowList = new WebSingleRow[1];
        }
    }

    private int _getRowsCount(AbstractObjectCollection infoCollTmp) {
        return infoCollTmp.size();
    }

    private int _getColumnsCount(AbstractObjectCollection infoCollTmp) {
        return infoCollTmp.size() <= 0 ? 0 : infoCollTmp.getObject(0).size();
    }

    @Override
    public String[] getTitleKeys() {
        return this.titleKeys;
    }

    @Override
    public WebSingleRow[] getRowList() {
        return this.rowList;
    }

    @Override
    public String[] getHeadTitles() {
        return this.headTitles;
    }
}

