/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils.kdtable;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;

public abstract class CASAbstractKDTableAdapter {
    private KDTable table;
    private int precision;

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public KDTable getTable() {
        return this.table;
    }

    public void setTable(KDTable table) {
        this.table = table;
    }

    private CASAbstractKDTableAdapter() {
    }

    public CASAbstractKDTableAdapter(KDTable table) {
        this.table = table;
    }

    public CASAbstractKDTableAdapter(KDTable table, int precision) {
        this.table = table;
        this.precision = precision;
    }

    public abstract void fillTable(IObjectCollection var1);

    protected void setLineFields(KDTable table, IRow row, IObjectValue obj) {
        row.setUserObject((Object)obj);
        Object val = null;
        int n = table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String bindField = table.getColumn(i).getKey();
            if (StringUtils.isEmpty((String)bindField) || obj.get(bindField) == null) continue;
            if (obj.get(bindField) instanceof Timestamp) {
                row.getCell(i).setValue((Object)obj.getDate(bindField));
                continue;
            }
            if (obj.get(bindField) instanceof BigDecimal) {
                BigDecimal amt = (BigDecimal)obj.get(bindField);
                if (amt.compareTo(Constants.ZERO) == 0) continue;
                if (this.getPrecision() != 0) {
                    row.getCell(i).setValue((Object)amt.setScale(this.getPrecision(), 4));
                    StringBuffer s = new StringBuffer(25);
                    s.append("###,###,###,###,##0.");
                    for (int j = 0; j < this.getPrecision(); ++j) {
                        s.append("0");
                    }
                    row.getCell(i).getStyleAttributes().setNumberFormat(s.toString());
                } else {
                    row.getCell(i).setValue((Object)amt);
                }
                row.getCell(i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                continue;
            }
            val = obj.get(bindField);
            if (val == null || String.valueOf(val) == null) continue;
            row.getCell(i).setValue(val);
        }
    }
}

