/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.validate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryFactory;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.validator.IVoucherBaseValidator;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.IContextHelper;

public class CheckVoucherValidator
implements IVoucherBaseValidator {
    public void validate(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        IContextHelper ctxHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        boolean canCheckVoucher = ctxHelper.getBooleanParam("CS115", (IObjectPK)new ObjectUuidPK(voucherInfo.getCompany().getId()));
        if (!canCheckVoucher) {
            CompanyOrgUnitInfo companyInfo = voucherInfo.getCompany();
            VoucherEntryCollection coll = this.getEntry(ctx, voucherInfo.getId().toString());
            for (int i = 0; i < coll.size(); ++i) {
                boolean isHasAccountBank;
                VoucherEntryInfo entryInfo = coll.get(i);
                String accountId = entryInfo.getAccount().getId().toString();
                AccountViewInfo accountInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountId));
                if (!accountInfo.isIsBank()) continue;
                VoucherAssistRecordCollection voucherAssistRecordCollection = entryInfo.getAssistRecords();
                AccountBankCollection accountBankCollection = this.getAccountBankCollection(ctx, companyInfo, accountInfo);
                boolean isHasAssistRecord = voucherAssistRecordCollection == null || voucherAssistRecordCollection.size() == 0;
                boolean bl = isHasAccountBank = accountBankCollection == null || accountBankCollection.size() == 0;
                if (!isHasAssistRecord || !isHasAccountBank) continue;
                throw new BookNotifyException(BookNotifyException.NO_ACCOUNT, new Object[]{accountInfo});
            }
        }
    }

    private AccountBankCollection getAccountBankCollection(Context ctx, CompanyOrgUnitInfo companyInfo, AccountViewInfo accountInfo) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId()));
        fi.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountInfo.getId().toString()));
        evi.setFilter(fi);
        evi.getSelector().add("*");
        evi.getSelector().add("account.*");
        AccountBankCollection coll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(evi);
        return coll;
    }

    private VoucherEntryCollection getEntry(Context ctx, String voucherId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("bill.id", (Object)voucherId));
        evi.setFilter(fi);
        evi.getSelector().add("*");
        VoucherEntryCollection coll = VoucherEntryFactory.getLocalInstance((Context)ctx).getVoucherEntryCollection(evi);
        return coll;
    }
}

