/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.validate.currency;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.fi.cas.ArApRecPayException;
import com.kingdee.eas.fi.cas.validate.currency.SourceBillCurrencyCheck;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.List;

public abstract class AbstractSourceBillCurrencyCheck
implements SourceBillCurrencyCheck {
    private Context ctx;
    private List<String> sourceBillIds;
    private String destBillName;

    public AbstractSourceBillCurrencyCheck(Context ctx, List<String> sourceBillIds, String destBillName) {
        this.ctx = ctx;
        this.sourceBillIds = sourceBillIds;
        this.destBillName = destBillName;
    }

    @Override
    public final void check(String currencyId) throws BOSException, EASBizException {
        if (this.sourceBillIds.isEmpty()) {
            return;
        }
        String sourceCurrencyId = this.getCurrencyId();
        if (null == sourceCurrencyId) {
            return;
        }
        if (!sourceCurrencyId.equals(currencyId)) {
            this.triggerException();
        }
    }

    protected void triggerException() throws EASBizException {
        throw new ArApRecPayException(ArApRecPayException.CURRENCY_NOT_CONSISTENT_WITH_SOURCE_BILL, new Object[]{this.destBillName});
    }

    protected abstract String getCurrencyFieldName();

    protected abstract String getTableName();

    private String getCurrencyId() throws BOSException, EASBizException {
        String currencyFieldName = this.getCurrencyFieldName();
        String query = "select DISTINCT " + currencyFieldName + " from " + this.getTableName() + " where FID IN " + AbstractSourceBillCurrencyCheck.transList2String(this.sourceBillIds);
        IRowSet rs = DBUtil.executeQuery((Context)this.ctx, (String)query);
        if (rs.size() > 1) {
            throw new ArApRecPayException(ArApRecPayException.CURRENCY_NOT_CONSISTENT_WITH_SOURCE_BILL);
        }
        try {
            if (rs.next()) {
                return rs.getString(currencyFieldName);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static String transList2String(List<String> list) {
        String ids = "";
        for (String idStr : list) {
            if (idStr == null || !BOSUuid.isValid((String)idStr.toString(), (boolean)true)) continue;
            ids = ids + "'" + idStr + "',";
        }
        if (ids.length() > 0) {
            ids = ids.substring(0, ids.length() - 1);
        }
        return "(" + ids + ")";
    }
}

