/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.validate.currency;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.fi.cas.validate.currency.AbstractSourceBillCurrencyCheck;
import com.kingdee.eas.fi.cas.validate.currency.DefaultSourceBillCurrencyCheck;
import com.kingdee.eas.fi.cas.validate.currency.GeneralCurrencyCheckBuilder;
import com.kingdee.eas.fi.cas.validate.currency.SourceBillCurrencyCheck;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ArApCurrencyCheckBuilder
implements SourceBillCurrencyCheck {
    private final SourceBillCurrencyCheck checker;

    public ArApCurrencyCheckBuilder(Context ctx, List<String> sourceBillEntryIds, List<String> sourceBillIds, List<String> coreBillIds, String destBillName) throws BOSException {
        GeneralCurrencyCheckBuilder tempBuilder = new GeneralCurrencyCheckBuilder(ctx, sourceBillIds, coreBillIds, destBillName);
        ArrayList<String> sourceIds = new ArrayList<String>();
        if ("CC3E933B".equals(tempBuilder.getBosType())) {
            String query = "select DISTINCT FParentID parentId from T_IM_SaleIssueEntry where FID IN " + AbstractSourceBillCurrencyCheck.transList2String(sourceBillEntryIds) + "AND FIsCenterBalance = 0";
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)query);
            try {
                if (rs.next()) {
                    sourceIds.add(rs.getString("parentId"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            this.checker = sourceIds.isEmpty() ? DefaultSourceBillCurrencyCheck.defaultChecker : new GeneralCurrencyCheckBuilder(ctx, sourceIds, coreBillIds, destBillName);
        } else if ("783061E3".equals(tempBuilder.getBosType())) {
            String query = "select DISTINCT FID id from T_IM_PurInWarehsBill where FID IN " + AbstractSourceBillCurrencyCheck.transList2String(sourceBillIds) + "AND FIsCentralBalance = 0";
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)query);
            try {
                if (rs.next()) {
                    sourceIds.add(rs.getString("id"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            this.checker = sourceIds.isEmpty() ? DefaultSourceBillCurrencyCheck.defaultChecker : new GeneralCurrencyCheckBuilder(ctx, sourceIds, coreBillIds, destBillName);
        } else {
            this.checker = tempBuilder;
        }
    }

    @Override
    public void check(String currencyId) throws BOSException, EASBizException {
        this.checker.check(currencyId);
    }
}

