/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.validate.currency;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.fi.cas.validate.currency.AbstractSourceBillCurrencyCheck;
import com.kingdee.eas.fi.cas.validate.currency.DefaultSourceBillCurrencyCheck;
import com.kingdee.eas.fi.cas.validate.currency.DefaultSourceBillCurrencyCheckConfig;
import com.kingdee.eas.fi.cas.validate.currency.SourceBillCurrencyCheck;
import com.kingdee.eas.fi.cas.validate.currency.SourceBillCurrencyCheckConfig;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GeneralCurrencyCheckBuilder
implements SourceBillCurrencyCheck {
    private List<String> sourceBillIds = Collections.emptyList();
    private final String destBillName;
    private String bosType;
    private final Context ctx;
    private final SourceBillCurrencyCheck defaultChecker = DefaultSourceBillCurrencyCheck.defaultChecker;
    private static final SourceBillCurrencyCheckConfig defaultConfig = new DefaultSourceBillCurrencyCheckConfig();
    private static final List<String> specialBosType = Arrays.asList("8B07BBDB");
    private static final Map<String, SourceBillCurrencyCheckConfig> configMap = new HashMap<String, SourceBillCurrencyCheckConfig>();

    public GeneralCurrencyCheckBuilder(Context ctx, List<String> sourceBillIds, String destBillName) {
        if (null != sourceBillIds) {
            this.sourceBillIds = sourceBillIds;
            this.bosType = BOSUuid.read((String)sourceBillIds.get(0)).getType().toString();
        }
        this.destBillName = destBillName;
        this.ctx = ctx;
    }

    public GeneralCurrencyCheckBuilder(Context ctx, List<String> sourceBillIds, List<String> coreBillIds, String destBillName) {
        this(ctx, sourceBillIds, destBillName);
        if (specialBosType.contains(this.bosType) && null != coreBillIds && !coreBillIds.isEmpty()) {
            this.sourceBillIds = coreBillIds;
            this.bosType = BOSUuid.read((String)coreBillIds.get(0)).getType().toString();
        }
    }

    private SourceBillCurrencyCheck build() {
        if (StringUtils.isEmpty((String)this.bosType) || this.sourceBillIds.isEmpty()) {
            return this.defaultChecker;
        }
        return this.getCheckerConfigFromDb();
    }

    private SourceBillCurrencyCheck getCheckerConfigFromDb() {
        try {
            SourceBillCurrencyCheckConfig config = configMap.get(this.bosType);
            if (config instanceof DefaultSourceBillCurrencyCheckConfig) {
                return this.defaultChecker;
            }
            if (null != config) {
                String currencyFieldName = config.getCurrencyFieldName();
                String tableName = config.getTableName();
                return this.constructChecker(currencyFieldName, tableName);
            }
            IRowSet rowSet = DBUtil.executeQuery((Context)this.ctx, (String)("select FCURRENCYFIELD,FTABLENAME FROM T_AR_CURRENCY_CHECK_CONFIG WHERE FENABLE = 1 AND FBOSTYPE = '" + this.bosType + "'"));
            if (rowSet.next()) {
                String currencyFieldName = rowSet.getString("FCURRENCYFIELD");
                String tableName = rowSet.getString("FTABLENAME");
                configMap.put(this.bosType, this.constructConfig(this.bosType, currencyFieldName, tableName));
                return this.constructChecker(currencyFieldName, tableName);
            }
            configMap.put(this.bosType, defaultConfig);
            return this.defaultChecker;
        }
        catch (Exception e) {
            return this.defaultChecker;
        }
    }

    private SourceBillCurrencyCheckConfig constructConfig(final String bosType, final String currencyFieldName, final String tableName) {
        return new SourceBillCurrencyCheckConfig(){

            @Override
            public String getBosType() {
                return bosType;
            }

            @Override
            public String getCurrencyFieldName() {
                return currencyFieldName;
            }

            @Override
            public String getTableName() {
                return tableName;
            }
        };
    }

    private SourceBillCurrencyCheck constructChecker(final String currencyFieldName, final String tableName) {
        AbstractSourceBillCurrencyCheck checker = new AbstractSourceBillCurrencyCheck(this.ctx, this.sourceBillIds, this.destBillName){

            @Override
            protected String getCurrencyFieldName() {
                return currencyFieldName;
            }

            @Override
            protected String getTableName() {
                return tableName;
            }
        };
        return checker;
    }

    public static void clearCache() {
        configMap.clear();
    }

    @Override
    public void check(String currencyId) throws BOSException, EASBizException {
        this.build().check(currencyId);
    }

    public String getBosType() {
        return this.bosType;
    }
}

