/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.web.param;

import com.kingdee.eas.fi.cas.web.param.QueryTableRowCell;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class QueryTableRow {
    private List<QueryTableRowCell> cells = new LinkedList<QueryTableRowCell>();

    public String toString() {
        return this.cells.toString();
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> values = null;
        if (this.cells != null && this.cells.size() > 0) {
            values = new HashMap<String, Object>(this.cells.size());
            for (QueryTableRowCell aCell : this.cells) {
                values.put(aCell.getName(), aCell.getValue());
            }
        }
        return values;
    }

    public QueryTableRowCell addCell(String name, Object value) {
        QueryTableRowCell cell = new QueryTableRowCell(name, value);
        this.doSortOfCells();
        int index = Collections.binarySearch(this.cells, cell, new Comparator<QueryTableRowCell>(){

            @Override
            public int compare(QueryTableRowCell o1, QueryTableRowCell o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        if (index > -1) {
            cell = this.cells.get(index);
            cell.setValue(value);
        } else {
            this.cells.add(cell);
        }
        return cell;
    }

    public QueryTableRowCell addCell(String name) {
        QueryTableRowCell cell = new QueryTableRowCell(name);
        this.doSortOfCells();
        int index = Collections.binarySearch(this.cells, cell, new Comparator<QueryTableRowCell>(){

            @Override
            public int compare(QueryTableRowCell o1, QueryTableRowCell o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        if (index > -1) {
            cell = this.cells.get(index);
        } else {
            this.cells.add(cell);
        }
        return cell;
    }

    private void doSortOfCells() {
        Collections.sort(this.cells, new Comparator<QueryTableRowCell>(){

            @Override
            public int compare(QueryTableRowCell o1, QueryTableRowCell o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    public QueryTableRowCell getCell(String name) {
        QueryTableRowCell cell = new QueryTableRowCell(name);
        this.doSortOfCells();
        int index = Collections.binarySearch(this.cells, cell, new Comparator<QueryTableRowCell>(){

            @Override
            public int compare(QueryTableRowCell o1, QueryTableRowCell o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        if (index > -1) {
            return this.cells.get(index);
        }
        return null;
    }

    public List<QueryTableRowCell> getCells() {
        return this.cells;
    }
}

