/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.def.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ep.client.editor.editui.designer.util.CustomSchemeUtil;
import com.kingdee.eas.fi.fa.def.FaDefPropertyCollection;
import com.kingdee.eas.fi.fa.def.FaDefPropertyFactory;
import com.kingdee.eas.fi.fa.def.FaDefPropertyInfo;
import com.kingdee.eas.fi.fa.def.FaDefPropertyTypeEnum;
import com.kingdee.eas.fi.fa.def.FaDefResource;
import com.kingdee.eas.fi.fa.def.IFaDefProperty;
import com.kingdee.eas.fi.fa.def.client.AbstractFaDefPropertyEditUI;
import com.kingdee.eas.fi.fa.def.client.SeqProperty;
import com.kingdee.eas.fi.fa.def.meta.FaDefPropertyValueManager;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FaDefPropertyEditUI
extends AbstractFaDefPropertyEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FaDefPropertyEditUI.class);
    Object seq = FaDefPropertyTypeEnum.SEQ;
    Object str = FaDefPropertyTypeEnum.STRING;
    Object asst = FaDefPropertyTypeEnum.ASSTACTITEM;
    Object dates = FaDefPropertyTypeEnum.DATE;
    Object num = FaDefPropertyTypeEnum.NUM;
    private volatile boolean loading = true;
    String message = null;

    @Override
    public void storeFields() {
        this.clearZero();
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.onComboTypeChanged();
        String currentCompanyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        if (this.editData.getId() != null) {
            if (!currentCompanyID.equalsIgnoreCase(this.editData.getCompany().getId().toString())) {
                this.actionSubmit.setEnabled(false);
                this.actionRemove.setEnabled(false);
                this.actionEdit.setEnabled(false);
            } else {
                this.actionSubmit.setEnabled(this.actionSubmit.isEnabled());
                this.actionRemove.setEnabled(true);
                this.actionEdit.setEnabled(this.actionEdit.isEnabled());
            }
        } else {
            this.actionSubmit.setEnabled(true);
            this.actionEdit.setEnabled(false);
        }
        this.initDataStatus();
    }

    protected void unLockUI() {
        super.unLockUI();
        this.onComboTypeChanged();
        this.clearZero();
        if (this.editData.isIsUsed()) {
            this.comboType.setEditable(false);
            this.txtNumber.setEditable(false);
            this.txtName.setEditable(false);
            this.btnSeqEdit.setEnabled(false);
            this.prmtAsstActType.setEnabled(false);
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if (this.editData != null && this.editData.isIsUsed()) {
            this.comboType.setEnabled(false);
            this.txtNumber.setEditable(false);
            this.txtName.setEditable(false);
            this.btnSeqEdit.setEnabled(false);
            this.prmtAsstActType.setEnabled(false);
        } else if (this.getOprtState().equals("ADDNEW")) {
            this.comboType.setEnabled(true);
            this.txtNumber.setEditable(true);
            this.txtName.setEditable(true);
        }
    }

    public void onLoad() throws Exception {
        this.attachListeners();
        super.onLoad();
        this.initStyle();
        this.clearZero();
        this.txtNumber.setRequired(true);
        this.txtName.setRequired(true);
        this.txtStrLength.setRequired(true);
        this.txtDecimalQty.setDataType(0);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.menuBar.setVisible(false);
        if (this.chkIsAttendFilter.isSelected() || this.chkIsAttendSort.isSelected()) {
            this.chkIsQuerySee.setSelected(true);
            this.chkIsQuerySee.setEnabled(false);
        } else {
            this.chkIsQuerySee.setEnabled(true);
        }
    }

    public void clearZero() {
        if (this.txtStrLength.getText().trim().equals("0")) {
            this.txtStrLength.setText("");
        }
    }

    private void initStyle() {
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionSave.setVisible(false);
        this.chkIsUsed.setEnabled(false);
        this.txtNumber.setMaxLength(25);
        this.txtName.setMaxLength(80);
        this.txtDescription.setMaxLength(255);
    }

    @Override
    public void actionSeqEdit_actionPerformed(ActionEvent e) throws Exception {
        try {
            new SeqProperty((Component)((Object)this), this.editData).show();
        }
        catch (Exception e2) {
            this.handleException(e2);
        }
        super.actionSeqEdit_actionPerformed(e);
    }

    private void attachListeners() {
        this.comboType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FaDefPropertyEditUI.this.onComboTypeChanged();
                }
            }
        });
        this.chkIsAttendFilter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (FaDefPropertyEditUI.this.chkIsAttendFilter.isSelected() || FaDefPropertyEditUI.this.chkIsAttendSort.isSelected()) {
                    FaDefPropertyEditUI.this.chkIsQuerySee.setSelected(true);
                    FaDefPropertyEditUI.this.chkIsQuerySee.setEnabled(false);
                } else {
                    FaDefPropertyEditUI.this.chkIsQuerySee.setEnabled(true);
                }
            }
        });
        this.chkIsAttendSort.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (FaDefPropertyEditUI.this.chkIsAttendFilter.isSelected() || FaDefPropertyEditUI.this.chkIsAttendSort.isSelected()) {
                    FaDefPropertyEditUI.this.chkIsQuerySee.setSelected(true);
                    FaDefPropertyEditUI.this.chkIsQuerySee.setEnabled(false);
                } else {
                    FaDefPropertyEditUI.this.chkIsQuerySee.setEnabled(true);
                }
            }
        });
    }

    private void onComboTypeChanged() {
        if (this.getOprtState().equals("ADDNEW")) {
            this.chkIsAttendFilter.setSelected(false);
        }
        this.prmtAsstActType.setEnabled(true);
        this.txtDecimalQty.setEnabled(true);
        this.txtStrLength.setEnabled(true);
        this.btnSeqEdit.setEnabled(true);
        this.chkIsAttendCollect.setEnabled(true);
        this.chkIsAttendRepColl.setEnabled(true);
        this.chkIsSplitBill.setEnabled(true);
        Object obj = this.comboType.getSelectedItem();
        if (this.seq.equals(obj)) {
            this.prmtAsstActType.setEnabled(false);
            this.txtDecimalQty.setEnabled(false);
            this.txtStrLength.setEnabled(false);
            this.chkIsAttendCollect.setEnabled(false);
            this.chkIsAttendRepColl.setEnabled(false);
            this.chkIsSplitBill.setEnabled(false);
            this.chkIsSplitBill.setSelected(false);
            this.chkIsAttendCollect.setSelected(false);
            this.chkIsAttendRepColl.setSelected(false);
            this.prmtAsstActType.setValue(null);
            this.txtDecimalQty.setValue((Object)new Integer(0));
            this.txtStrLength.setValue((Object)new Integer(0));
            this.txtDecimalQty.setText("");
            this.txtStrLength.setText("");
        } else if (this.str.equals(obj)) {
            this.prmtAsstActType.setEnabled(false);
            this.txtDecimalQty.setEnabled(false);
            this.btnSeqEdit.setEnabled(false);
            this.chkIsSplitBill.setEnabled(false);
            this.chkIsAttendCollect.setEnabled(false);
            this.chkIsAttendCollect.setSelected(false);
            this.chkIsSplitBill.setSelected(false);
            this.prmtAsstActType.setValue(null);
            this.txtDecimalQty.setValue((Object)new Integer(0));
            this.txtDecimalQty.setText("");
        } else if (this.asst.equals(obj)) {
            this.txtDecimalQty.setEnabled(false);
            this.txtStrLength.setEnabled(false);
            this.btnSeqEdit.setEnabled(false);
            this.chkIsAttendCollect.setEnabled(false);
            this.chkIsSplitBill.setEnabled(false);
            this.chkIsSplitBill.setSelected(false);
            this.chkIsAttendCollect.setSelected(false);
            this.txtDecimalQty.setValue((Object)new Integer(0));
            this.txtStrLength.setValue((Object)new Integer(0));
            this.txtStrLength.setText("");
            this.txtDecimalQty.setText("");
        } else if (this.dates.equals(obj)) {
            this.prmtAsstActType.setEnabled(false);
            this.txtDecimalQty.setEnabled(false);
            this.txtStrLength.setEnabled(false);
            this.btnSeqEdit.setEnabled(false);
            this.chkIsAttendCollect.setEnabled(false);
            this.chkIsAttendRepColl.setEnabled(false);
            this.chkIsSplitBill.setEnabled(false);
            this.chkIsSplitBill.setSelected(false);
            this.chkIsAttendCollect.setSelected(false);
            this.chkIsAttendRepColl.setSelected(false);
            this.prmtAsstActType.setValue(null);
            this.txtDecimalQty.setValue((Object)new Integer(0));
            this.txtStrLength.setValue((Object)new Integer(0));
            this.txtDecimalQty.setText("");
            this.txtStrLength.setText("");
        } else if (this.num.equals(obj)) {
            this.prmtAsstActType.setEnabled(false);
            this.prmtAsstActType.setValue(null);
            this.txtStrLength.setEnabled(false);
            this.btnSeqEdit.setEnabled(false);
            this.chkIsAttendRepColl.setEnabled(false);
            this.chkIsAttendRepColl.setSelected(false);
            this.txtStrLength.setValue((Object)new Integer(0));
            this.txtStrLength.setText("");
        }
    }

    private void clearValue(FaDefPropertyInfo old) {
        Object obj = this.comboType.getSelectedItem();
        if (this.seq.equals(obj)) {
            old.setDecimalQty(0);
            old.setStrLength(0);
            this.txtStrLength.setValue((Object)new Integer(0));
        } else if (this.str.equals(obj)) {
            old.setDecimalQty(0);
        } else if (this.asst.equals(obj)) {
            old.setDecimalQty(0);
            old.setStrLength(0);
        } else if (this.dates.equals(obj)) {
            old.setDecimalQty(0);
            old.setStrLength(0);
        } else if (this.num.equals(obj)) {
            old.setStrLength(0);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        boolean addNew;
        if (!FaDefPropertyTypeEnum.SEQ.equals(this.comboType.getSelectedItem())) {
            this.editData.getEnums().clear();
        }
        boolean bl = addNew = this.editData.getId() == null;
        if (!addNew) {
            this.storeFields();
            FaDefPropertyInfo old = (FaDefPropertyInfo)FaDefPropertyFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            this.clearValue(old);
            if (!this.verifyInputs()) {
                SysUtil.abort();
            }
            if (old != null && !old.equals("") && old.getDecimalQty() > this.editData.getDecimalQty() && MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.def.DEFAutoGenerateResource", (String)"25_FaDefPropertyEditUI")) == 2) {
                SysUtil.abort();
            }
        }
        if (!this.verifyInputs()) {
            SysUtil.abort();
        }
        this.storeFields();
        super.actionSubmit_actionPerformed(e);
        FaDefPropertyEditUI.updateAllProperty();
    }

    public static void updateAllProperty() throws BOSException, EASBizException {
        String scheme = "tBj8Gt3jAcrgQ8CoPwoByiyY1lE=";
        CustomSchemeUtil.disableScheme((String)scheme);
        FaDefPropertyValueManager pm = new FaDefPropertyValueManager();
        pm.clearConfigured();
        FaDefPropertyCollection cc = FaDefPropertyFactory.getRemoteInstance().getFaDefPropertyCollection();
        for (int i = 0; i < cc.size(); ++i) {
            pm.addProperty(cc.get(i));
        }
        pm.update();
        pm.updateAllQuery();
        CustomSchemeUtil.enableScheme((String)scheme);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.isIsUsed()) {
            String message = FaDefResource.getResource("isUsedNotDelete");
            MsgBox.showInfo((Component)((Object)this), (String)message);
            return;
        }
        super.actionRemove_actionPerformed(e);
        FaDefPropertyEditUI.updateAllProperty();
    }

    private boolean verifyInputs() throws Exception {
        IFaDefProperty iFaDefProperty = FaDefPropertyFactory.getRemoteInstance();
        Object obj = this.comboType.getSelectedItem();
        String number = this.txtNumber.getText();
        if (number.length() == 0) {
            this.message = FaDefResource.getResource("numberNotNull");
            MsgBox.showInfo((Component)((Object)this), (String)this.message);
            this.txtNumber.requestFocus();
            return false;
        }
        if (number.equalsIgnoreCase("ID") || number.equalsIgnoreCase("BILLID")) {
            this.message = FaDefResource.getResource("numberBound");
            MsgBox.showInfo((Component)((Object)this), (String)this.message);
            this.txtNumber.requestFocus();
            return false;
        }
        if (!number.matches("\\w+") || number.matches("\\d.*")) {
            this.message = EASResource.getString((String)"com.kingdee.eas.fi.fa.def.DEFAutoGenerateResource", (String)"26_FaDefPropertyEditUI");
            MsgBox.showInfo((Component)((Object)this), (String)this.message);
            return false;
        }
        if (number.toUpperCase(Locale.getDefault()).endsWith("ID") && this.str.equals(obj)) {
            this.message = FaDefResource.getResource("StrDefPropertyCanntEndWithID");
            MsgBox.showInfo((Component)((Object)this), (String)this.message);
            this.txtNumber.requestFocus();
            return false;
        }
        this.editData.setNumber(number);
        try {
            iFaDefProperty.checkNumberDup(this.editData);
        }
        catch (Exception ex) {
            this.handleException(ex);
            this.txtNumber.requestFocus();
            return false;
        }
        if (this.txtName.getSelectedItemData() == null || this.txtName.getSelectedItemData().toString().trim().length() == 0) {
            this.message = FaDefResource.getResource("nameNotNull");
            MsgBox.showInfo((Component)((Object)this), (String)this.message);
            this.txtName.requestFocus();
            return false;
        }
        this.editData.setName(this.txtName.getSelectedItemData().toString());
        try {
            iFaDefProperty.checkNameDup(this.editData);
        }
        catch (EASBizException e1) {
            this.txtName.requestFocus();
            this.handleException((Exception)((Object)e1));
            return false;
        }
        if (this.str.equals(obj)) {
            String strLengths = this.txtStrLength.getText();
            if (strLengths == null || this.txtStrLength.getText().trim().length() == 0) {
                this.message = FaDefResource.getResource("strLengthNotNull");
                MsgBox.showInfo((Component)((Object)this), (String)this.message);
                this.txtStrLength.requestFocus();
                return false;
            }
            if (strLengths.indexOf(".") != -1 || strLengths.indexOf("-") != -1) {
                this.message = FaDefResource.getResource("strLengthIsInt");
                MsgBox.showInfo((Component)((Object)this), (String)this.message);
                this.txtStrLength.requestFocus();
                return false;
            }
            if (this.txtStrLength.getNumberValue().intValue() == 0 || this.txtStrLength.getNumberValue().intValue() > 255) {
                this.message = FaDefResource.getResource("strLengthRange");
                MsgBox.showInfo((Component)((Object)this), (String)this.message);
                this.txtStrLength.requestFocus();
                return false;
            }
        }
        if (this.num.equals(obj)) {
            String decimalQty = this.txtDecimalQty.getText();
            if (decimalQty == null || decimalQty.trim().length() == 0) {
                this.txtDecimalQty.setValue((Object)new Integer(0));
            } else {
                if (decimalQty.indexOf(".") != -1 || decimalQty.indexOf("-") != -1) {
                    this.message = FaDefResource.getResource("decimalQtyIsInt");
                    MsgBox.showInfo((Component)((Object)this), (String)this.message);
                    this.txtDecimalQty.requestFocus();
                    return false;
                }
                if (Integer.parseInt(decimalQty) > 6) {
                    this.message = FaDefResource.getResource("decimalQtyRange");
                    MsgBox.showInfo((Component)((Object)this), (String)this.message);
                    this.txtDecimalQty.requestFocus();
                    return false;
                }
            }
        }
        if (this.seq.equals(obj) && (this.editData.getEnums() == null || this.editData.getEnums().size() < 1)) {
            this.message = FaDefResource.getResource("seqNotValue");
            MsgBox.showInfo((Component)((Object)this), (String)this.message);
            this.btnSeqEdit.requestFocus();
            return false;
        }
        if (this.asst.equals(obj) && this.prmtAsstActType.getData() == null) {
            this.message = FaDefResource.getResource("asstActTypeNotNull");
            MsgBox.showInfo((Component)((Object)this), (String)this.message);
            this.prmtAsstActType.requestFocus();
            return false;
        }
        return true;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.editData.setCompany(SysContext.getSysContext().getCurrentFIUnit());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("enums.*");
        sic.add("company.id");
        return sic;
    }

    protected IObjectValue createNewData() {
        FaDefPropertyInfo info = new FaDefPropertyInfo();
        info.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        info.setIsAttendFilter(true);
        info.setIsQuerySee(true);
        info.setIsAttendUpdate(true);
        info.setIsAttendSort(true);
        info.setDecimalQty(0);
        info.setType(FaDefPropertyTypeEnum.STRING);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaDefPropertyFactory.getRemoteInstance();
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        FaDefPropertyInfo info = (FaDefPropertyInfo)newData;
        info.setIsUsed(false);
    }
}

