/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.def.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.def.DefCompanyFilterUtil;
import com.kingdee.eas.fi.fa.def.FaDefPropertyFactory;
import com.kingdee.eas.fi.fa.def.FaDefResource;
import com.kingdee.eas.fi.fa.def.client.AbstractFaDefPropertyListUI;
import com.kingdee.eas.fi.fa.def.client.FaDefPropertyEditUI;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class FaDefPropertyListUI
extends AbstractFaDefPropertyListUI {
    private static final Logger logger = CoreUIObject.getLogger(FaDefPropertyListUI.class);

    public FaDefPropertyListUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getColumn("strLength").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("decimalQty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        FaClientUtils.changeTableTextFormat((KDTable)this.tblMain, (String[])new String[]{"strLength", "decimalQty"});
        this.tblMain.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                FaDefPropertyListUI.this.lockAction();
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.lockAction();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaDefPropertyFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int[] rs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < rs.length; ++i) {
            IRow r = this.tblMain.getRow(rs[i]);
            if (r.getCell("isUsed").getValue() == null || !((Boolean)r.getCell("isUsed").getValue()).booleanValue()) continue;
            String message = FaDefResource.getResource("isUsedNotDelete");
            MsgBox.showInfo((Component)((Object)this), (String)message);
            return;
        }
        super.actionRemove_actionPerformed(e);
        FaDefPropertyEditUI.updateAllProperty();
    }

    protected void runRemove(IObjectPK pk) throws Exception {
        this.getBizInterface().delete(pk);
        FaDefPropertyEditUI.updateAllProperty();
    }

    protected String getEditUIName() {
        return FaDefPropertyEditUI.class.getName();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return DefCompanyFilterUtil.createDefFilter(SysContext.getSysContext().getCurrentFIUnit().getLongNumber());
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        int firstIndex = e.getFirstRow();
        int lastIndex = e.getLastRow();
        for (int r = firstIndex; r <= lastIndex; ++r) {
            Object decimalQty;
            IRow row = this.tblMain.getRow(r);
            Object strLength = row.getCell("strLength").getValue();
            if (strLength instanceof Number && ((Number)strLength).intValue() == 0) {
                row.getCell("strLength").setValue((Object)"");
            }
            if (!((decimalQty = row.getCell("decimalQty").getValue()) instanceof Number) || ((Number)decimalQty).intValue() != 0) continue;
            row.getCell("decimalQty").setValue((Object)"");
        }
    }

    protected void execQuery() {
        super.execQuery();
        this.lockAction();
    }

    protected void lockAction() {
        String cpName = SysContext.getSysContext().getCurrentFIUnit().getName();
        boolean falg = false;
        boolean isUserdByAssetCat = false;
        int[] selects = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selects.length; ++i) {
            if (this.tblMain.getRow(selects[i]) != null) {
                Object value = this.tblMain.getRow(selects[i]).getCell("company.name").getValue();
                if (cpName == null || value == null || !cpName.equalsIgnoreCase(value.toString())) {
                    falg = true;
                }
            } else {
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
                return;
            }
            isUserdByAssetCat = (Boolean)this.tblMain.getRow(selects[i]).getCell("isUsed").getValue() != false || isUserdByAssetCat;
        }
        if (falg) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else {
            if (isUserdByAssetCat) {
                this.actionRemove.setEnabled(false);
            } else {
                this.actionRemove.setEnabled(true);
            }
            this.actionEdit.setEnabled(selects.length == 1);
        }
    }
}

