/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.def.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;

public class TableHelperEx {
    private static final BigDecimal MAXVALUE = new BigDecimal(999999999);

    public static void SetTableDateFormat(KDTable tbl, String[] cols) {
        int length = cols.length;
        for (int i = 0; i < length; ++i) {
            if (tbl.getColumn(cols[i]) == null) continue;
            IColumn col = tbl.getColumn(cols[i]);
            KDDatePicker bizDate = new KDDatePicker();
            bizDate.setSupportedEmpty(false);
            col.setEditor((ICellEditor)new KDTDefaultCellEditor(bizDate));
            col.getStyleAttributes().setNumberFormat(FaClientUtils.getDateFormatString());
        }
    }

    public static IColumn getColumn(KDTable table, String fieldName) {
        IColumn column = null;
        if (table != null && fieldName != null && fieldName.trim().length() != 0) {
            column = table.getColumn(fieldName);
        }
        return column;
    }

    public static void setWidthForColumn(KDTable tbl, Map map) {
        Set keySet = map.keySet();
        Iterator iter = keySet.iterator();
        String strCol = null;
        Integer length = null;
        Object obj = null;
        while (iter.hasNext()) {
            strCol = (String)iter.next();
            IColumn col = TableHelperEx.getColumn(tbl, strCol);
            if (col == null) continue;
            obj = map.get(strCol);
            length = obj;
            col.setWidth(length.intValue());
        }
    }

    public static void setFieldsHorizontalAlignment(Styles.HorizontalAlignment hAlign, KDTable table, String[] fieldNames) {
        if (fieldNames != null) {
            IColumn col = null;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                col = TableHelperEx.getColumn(table, fieldNames[i]);
                if (col == null) continue;
                col.getStyleAttributes().setHorizontalAlign(hAlign);
            }
        }
    }

    public static void setRate(KDTable table, String[] fieldNames, int precision) {
        if (fieldNames != null) {
            IColumn col = null;
            for (int i = 0; i < fieldNames.length; ++i) {
                col = TableHelperEx.getColumn(table, fieldNames[i]);
                if (col == null) continue;
                col.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)TableHelperEx.getBigDecimalTextField(precision, new BigDecimal(1), new BigDecimal(0))));
                col.getStyleAttributes().setNumberFormat(TableHelperEx.getFormatString(precision));
            }
        }
    }

    public static void removeKDEditAdapter(KDTable table) {
        EventListenerList listenerList = table.getListenerList();
        EventListener[] event = listenerList.getListeners(KDTEditAdapter.class);
        int length = event.length;
        EventListener listener = null;
        for (int i = 0; i < length; ++i) {
            listener = event[i];
            table.removeKDTEditListener((KDTEditListener)listener);
        }
    }

    public static void rowToUseObject(IRow row, String[] cols, String[] propertys) {
        if (cols == null || row == null || propertys == null) {
            return;
        }
        Object obj = row.getUserObject();
        if (obj == null) {
            return;
        }
        if (obj instanceof AbstractObjectValue) {
            AbstractObjectValue objectValue = (AbstractObjectValue)obj;
            Enumeration key = null;
            int length = cols.length <= propertys.length ? cols.length : propertys.length;
            String strCol = null;
            String proCol = null;
            Object colValue = null;
            for (int i = 0; i < length; ++i) {
                strCol = cols[i];
                proCol = propertys[i];
                key = objectValue.keys();
                boolean flag = TableHelperEx.checkContain(proCol, key);
                flag = true;
                ICell cell = row.getCell(strCol);
                if (!flag || cell == null) continue;
                colValue = row.getCell(strCol).getValue();
                objectValue.put(proCol, colValue);
            }
        }
    }

    public static void rowToUseObject(IRow row, String[] cols) {
        if (cols == null || row == null) {
            return;
        }
        Object obj = row.getUserObject();
        if (obj == null) {
            return;
        }
        if (obj instanceof AbstractObjectValue) {
            AbstractObjectValue objectValue = (AbstractObjectValue)obj;
            int length = cols.length;
            String strCol = null;
            Object colValue = null;
            for (int i = 0; i < length; ++i) {
                strCol = cols[i];
                boolean flag = true;
                ICell cell = row.getCell(strCol);
                if (!flag || cell == null) continue;
                colValue = row.getCell(strCol).getValue();
                objectValue.put(strCol, colValue);
            }
        }
    }

    public static void useObjectToRow(AbstractObjectValue useObject, IRow row, String[] cols) {
        if (cols == null || row == null || useObject == null) {
            return;
        }
        row.setUserObject((Object)useObject);
        Enumeration key = null;
        int length = cols.length;
        String strCol = null;
        Object colValue = null;
        for (int i = 0; i < length; ++i) {
            strCol = cols[i];
            key = useObject.keys();
            boolean flag = TableHelperEx.checkContain(strCol, key);
            ICell cell = row.getCell(strCol);
            if (!flag || cell == null) continue;
            colValue = useObject.get(strCol);
            row.getCell(strCol).setValue(colValue);
        }
    }

    public static void useObjectToRow(AbstractObjectValue useObject, IRow row, String[] cols, String[] propertys) {
        if (cols == null || row == null || useObject == null) {
            return;
        }
        row.setUserObject((Object)useObject);
        Enumeration key = null;
        int length = cols.length <= propertys.length ? cols.length : propertys.length;
        String strCol = null;
        String property = null;
        Object colValue = null;
        for (int i = 0; i < length; ++i) {
            strCol = cols[i];
            property = propertys[i];
            key = useObject.keys();
            boolean flag = TableHelperEx.checkContain(property, key);
            ICell cell = row.getCell(strCol);
            if (!flag || cell == null) continue;
            colValue = useObject.get(property);
            row.getCell(strCol).setValue(colValue);
        }
    }

    public static boolean checkContain(String property, Enumeration keys) {
        Object obj = null;
        boolean flag = false;
        while (keys.hasMoreElements()) {
            obj = keys.nextElement();
            if (!obj.toString().equalsIgnoreCase(property)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static void setLockFields(KDTable table, String[] fieldNames, boolean isLock) {
        if (fieldNames != null) {
            IColumn column = null;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                column = TableHelperEx.getColumn(table, fieldNames[i]);
                if (column == null) continue;
                column.getStyleAttributes().setLocked(isLock);
            }
        }
    }

    public static void setBigDecimalFieldsPrecision(int precision, KDTable table, String[] fieldNames) {
        if (fieldNames != null) {
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                TableHelperEx.setBigDecimalFieldsPrecisionByColumn(TableHelperEx.getColumn(table, fieldNames[i]), precision);
            }
        }
    }

    public static void setBigDecimalFieldsPrecisionByColumn(IColumn column, int precision) {
        if (column != null) {
            column.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)TableHelperEx.getBigDecimalTextField(precision, null)));
            column.getStyleAttributes().setNumberFormat(TableHelperEx.getFormatString(precision));
        }
    }

    public static KDFormattedTextField getBigDecimalTextField(int precision, BigDecimal maxValue) {
        KDFormattedTextField colTxtField = new KDFormattedTextField();
        colTxtField.setDataType(1);
        colTxtField.setPrecision(precision);
        colTxtField.setHorizontalAlignment(4);
        colTxtField.setSupportedEmpty(true);
        colTxtField.setMaximumValue((Comparable)MAXVALUE);
        return colTxtField;
    }

    public static KDFormattedTextField getBigDecimalTextField(int precision, BigDecimal maxValue, BigDecimal minValue) {
        KDFormattedTextField colTxtField = new KDFormattedTextField();
        colTxtField.setDataType(1);
        colTxtField.setPrecision(precision);
        colTxtField.setHorizontalAlignment(4);
        colTxtField.setSupportedEmpty(true);
        colTxtField.setMaximumValue((Comparable)maxValue);
        colTxtField.setMinimumValue((Comparable)minValue);
        return colTxtField;
    }

    public static void setRequiredFields(KDTable table, String[] fieldNames, boolean isRequired) {
        if (fieldNames != null) {
            IColumn column = null;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                column = TableHelperEx.getColumn(table, fieldNames[i]);
                if (column == null) continue;
                column.setRequired(isRequired);
            }
        }
    }

    public static void setHideFields(KDTable table, String[] fieldNames, boolean isHide) {
        if (fieldNames != null) {
            IColumn column = null;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                column = TableHelperEx.getColumn(table, fieldNames[i]);
                if (column == null) continue;
                column.getStyleAttributes().setHided(isHide);
            }
        }
    }

    public static void setColEditor(KDTable table, Map columnEditors) {
        if (table != null && columnEditors != null) {
            Iterator itor = columnEditors.keySet().iterator();
            Object key = null;
            Object editor = null;
            IColumn column = null;
            while (itor.hasNext()) {
                key = itor.next();
                if (key instanceof String) {
                    column = TableHelperEx.getColumn(table, key.toString());
                } else if (key instanceof Integer) {
                    column = TableHelperEx.getColumn(table, Integer.parseInt(key.toString()));
                }
                editor = columnEditors.get(key);
                if (column != null && editor instanceof IKDEditor) {
                    column.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)editor));
                    continue;
                }
                if (column == null || !(editor instanceof KDTDefaultCellEditor)) continue;
                column.setEditor((ICellEditor)editor);
            }
        }
    }

    public static IColumn getColumn(KDTable table, int columnIndex) {
        IColumn column = null;
        if (table != null && columnIndex > -1) {
            column = table.getColumn(columnIndex);
        }
        return column;
    }

    public static Object getFieldValue(IRow row, String fieldName) {
        Object result = null;
        ICell cell = TableHelperEx.getCell(row, fieldName);
        if (cell != null) {
            result = cell.getValue();
        }
        return result;
    }

    public static Object getFieldValue(KDTable table, int rowIndex, String fieldName) {
        Object result = null;
        ICell cell = TableHelperEx.getCell(table, rowIndex, fieldName);
        if (cell != null) {
            result = cell.getValue();
        }
        return result;
    }

    public static String getFieldName(KDTable table, int columnIndex) {
        String fieldName = null;
        if (table != null && columnIndex > -1) {
            fieldName = table.getColumnKey(columnIndex);
        }
        return fieldName;
    }

    public static Object getFieldValue(KDTable table, int rowIndex, int columnIndex) {
        Object result = null;
        ICell cell = TableHelperEx.getCell(table, rowIndex, columnIndex);
        if (cell != null) {
            result = cell.getValue();
        }
        return result;
    }

    public static String getFieldString(KDTable table, int rowIndex, String columnIndex) {
        Object result = null;
        ICell cell = TableHelperEx.getCell(table, rowIndex, columnIndex);
        if (cell != null) {
            result = cell.getValue();
        }
        return result == null ? null : result.toString();
    }

    public static boolean getFieldBoolean(KDTable table, int rowIndex, String columnIndex) {
        Object result = null;
        ICell cell = TableHelperEx.getCell(table, rowIndex, columnIndex);
        if (cell != null) {
            result = cell.getValue();
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    public static List getFieldValues(KDTable table, int rowIndex, String[] fieldNames) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (table != null && rowIndex > -1 && fieldNames != null) {
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                values.add(i, TableHelperEx.getFieldValue(table, rowIndex, fieldNames[i]));
            }
        }
        return values;
    }

    public static List getMapFieldValues(KDTable table, String[] fieldNames) {
        ArrayList<Map> allList = new ArrayList<Map>();
        if (table != null && fieldNames != null) {
            for (int i = 0; i < table.getRowCount(); ++i) {
                Map map = TableHelperEx.getMapFieldValues(table, i, fieldNames);
                allList.add(map);
            }
        }
        return allList;
    }

    public static Map getMapFieldValues(KDTable table, int rowIndex, String[] fieldNames) {
        HashMap map = new HashMap();
        List list = TableHelperEx.getFieldValues(table, rowIndex, fieldNames);
        for (int j = 0; j < fieldNames.length; ++j) {
            map.put(fieldNames[j], list.get(j));
        }
        return map;
    }

    public static List getFieldValues(KDTable table, int rowIndex, int[] columnIndexes) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (table != null && rowIndex > -1 && columnIndexes != null) {
            int size = columnIndexes.length;
            for (int i = 0; i < size; ++i) {
                values.add(i, TableHelperEx.getFieldValue(table, rowIndex, columnIndexes[i]));
            }
        }
        return values;
    }

    public static void setFieldValues(KDTable table, int rowIndex, String[] fieldNames, Object[] values) {
        if (fieldNames != null) {
            int vSize = values.length;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                if (i > -1 && i < vSize) {
                    TableHelperEx.setFieldValue(table, rowIndex, fieldNames[i], values[i]);
                    continue;
                }
                TableHelperEx.setFieldValue(table, rowIndex, fieldNames[i], null);
            }
        }
    }

    public static void setFieldValues(KDTable table, int rowIndex, int[] columnIndexes, Object[] values) {
        if (columnIndexes != null) {
            int vSize = values.length;
            int size = columnIndexes.length;
            for (int i = 0; i < size; ++i) {
                if (i > -1 && i < vSize) {
                    TableHelperEx.setFieldValue(table, rowIndex, columnIndexes[i], values[i]);
                    continue;
                }
                TableHelperEx.setFieldValue(table, rowIndex, columnIndexes[i], null);
            }
        }
    }

    public static void setFieldValue(KDTable table, int rowIndex, String fieldName, Object value) {
        ICell cell = TableHelperEx.getCell(table, rowIndex, fieldName);
        if (cell != null) {
            cell.setValue(value);
        }
    }

    public static void setFieldValue(IRow row, String fieldName, Object value) {
        ICell cell = row.getCell(fieldName);
        if (cell != null) {
            cell.setValue(value);
        }
    }

    public static void setFieldValue(KDTable table, int rowIndex, int columnIndex, Object value) {
        ICell cell = TableHelperEx.getCell(table, rowIndex, columnIndex);
        if (cell != null) {
            cell.setValue(value);
        }
    }

    public static ICell getCell(KDTable table, int rowIndex, String fieldName) {
        ICell cell = null;
        if (table != null && rowIndex > -1 && fieldName != null && fieldName.trim().length() != 0) {
            cell = table.getRow(rowIndex).getCell(fieldName);
        }
        return cell;
    }

    public static ICell getCell(IRow row, String fieldName) {
        ICell cell = null;
        if (fieldName != null && fieldName.trim().length() != 0) {
            cell = row.getCell(fieldName);
        }
        return cell;
    }

    public static ICell getCell(KDTable table, int rowIndex, int columnIndex) {
        ICell cell = null;
        if (table != null && rowIndex > -1 && columnIndex > -1) {
            cell = table.getRow(rowIndex).getCell(columnIndex);
        }
        return cell;
    }

    public static String getFormatString(int precision) {
        if (precision == 0) {
            return "%R-{#,##0}f";
        }
        StringBuffer buffer = new StringBuffer();
        if (precision == 0) {
            buffer.append("#");
        } else {
            buffer.append("0.");
        }
        for (int i = 0; i < precision; ++i) {
            buffer = buffer.append("0");
        }
        StringBuffer formatString = new StringBuffer();
        formatString.append("%r-[=]{#,##").append(buffer).append("}f");
        return formatString.toString();
    }

    public static IRow appendFootRow(KDTable tblMain, String[] strFieldSum) {
        if (strFieldSum.length > 0) {
            IRow footRow = null;
            KDTFootManager footRowManager = tblMain.getFootManager();
            if (footRowManager == null) {
                String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
                footRowManager = new KDTFootManager(tblMain);
                footRowManager.addFootView();
                tblMain.setFootManager(footRowManager);
                footRow = footRowManager.addFootRow(0);
                footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                tblMain.getIndexColumn().setWidthAdjustMode((short)1);
                tblMain.getIndexColumn().setWidth(30);
                footRowManager.addIndexText(0, total);
            } else {
                footRow = footRowManager.getFootRow(0);
            }
            String colFormat = "%{0.##########}f";
            int columnCount = tblMain.getColumnCount();
            for (int c = 0; c < columnCount; ++c) {
                String fieldName = tblMain.getColumn(c).getFieldName();
                for (int i = 0; i < strFieldSum.length; ++i) {
                    String name = strFieldSum[i];
                    if (!name.equalsIgnoreCase(fieldName)) continue;
                    ICell cell = footRow.getCell(c);
                    cell.getStyleAttributes().setNumberFormat(colFormat);
                    cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                    cell.getStyleAttributes().setFontColor(Color.BLACK);
                }
            }
            footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
            return footRow;
        }
        return null;
    }

    public static void setSumToRow(KDTable tbl, String[] cols) {
        IRow row = tbl.getFootManager().getFootRow(0);
        for (int i = 0; i < cols.length; ++i) {
            TableHelperEx.setFieldValue(row, cols[i], null);
        }
        Map mapSum = TableHelperEx.sumTable(tbl, cols);
        Set setKey = mapSum.keySet();
        for (String str : setKey) {
            TableHelperEx.setFieldValue(row, str, mapSum.get(str));
        }
    }

    public static Map sumTable(KDTable tbl, String[] cols) {
        HashMap mapSum = new HashMap();
        if (tbl == null || tbl.getRowCount() == 0 || cols == null || cols.length == 0) {
            return mapSum;
        }
        int tblLength = tbl.getRowCount();
        int colLength = cols.length;
        for (int i = 0; i < tblLength; ++i) {
            IRow row = tbl.getRow(i);
            for (int j = 0; j < colLength; ++j) {
                TableHelperEx.addBigDecimalOfRow(mapSum, cols[j], row);
            }
        }
        return mapSum;
    }

    public static void addBigDecimalOfRow(Map map, String str, IRow row) {
        if (row.getCell(str) == null) {
            return;
        }
        Object obj = map.get(str);
        Object dec = row.getCell(str).getValue();
        if (obj instanceof BigDecimal && dec instanceof BigDecimal) {
            map.put(str, ((BigDecimal)obj).add((BigDecimal)dec));
        } else if (obj == null && dec instanceof BigDecimal) {
            map.put(str, (BigDecimal)dec);
        }
    }

    public static String[] getStringsTableColumns(KDTable tbl) {
        if (tbl == null) {
            return null;
        }
        int count = tbl.getColumnCount();
        if (count == 0) {
            return null;
        }
        String[] str = new String[count];
        for (int i = 0; i < count; ++i) {
            str[i] = tbl.getColumnKey(i);
        }
        return str;
    }

    public static List getListTableColumns(KDTable tbl) {
        if (tbl == null) {
            return null;
        }
        int count = tbl.getColumnCount();
        if (count == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            list.add(tbl.getColumnKey(i));
        }
        return list;
    }

    public static List getRequiredColumn(KDTable tbl) {
        ArrayList<String> list = new ArrayList<String>();
        if (tbl == null) {
            return list;
        }
        int count = tbl.getColumnCount();
        IColumn col = null;
        for (int i = 0; i < count; ++i) {
            col = tbl.getColumn(i);
            if (!col.isRequired()) continue;
            list.add(col.getKey());
        }
        return list;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

