/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.def.client.design.layout;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.fi.fa.def.FaDefPropertyInfo;
import com.kingdee.eas.fi.fa.def.FaDefStylePageInfo;
import com.kingdee.eas.fi.fa.def.FaDefStylePagePropertyCollection;
import com.kingdee.eas.fi.fa.def.FaDefStylePagePropertyInfo;
import com.kingdee.eas.fi.fa.def.client.design.layout.ComponentUtil;
import com.kingdee.eas.fi.fa.def.client.design.layout.Config;
import com.kingdee.eas.fi.fa.def.client.design.layout.LayoutListener;
import com.kingdee.eas.fi.fa.def.client.design.layout.WrapComponent;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class LayoutCanvas
extends KDPanel
implements MouseMotionListener,
MouseListener,
KeyListener {
    private int mouse_x = 0;
    private int mouse_y = 0;
    private boolean dragging = false;
    private int rows = 2;
    private int cols = 2;
    private int rowHeight = 30;
    private int colWidth = 270;
    private FaDefStylePageInfo page;
    private List wcList = new ArrayList();
    private LayoutListener l = null;

    public LayoutCanvas() {
        this.setLayout(null);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
    }

    public void setPage(FaDefStylePageInfo page) {
        this.page = page;
        this.wcList.clear();
        FaDefStylePagePropertyCollection cc = page.getProperties();
        for (int i = 0; i < cc.size(); ++i) {
            WrapComponent wc = WrapComponent.createByProperty(cc.get(i).getProperty(), this, this, this);
            wc.setStylePagePropertyInfo(cc.get(i));
            this.wcList.add(wc);
        }
        this.reLayout();
    }

    public FaDefStylePageInfo getPage() {
        return this.page;
    }

    public void setLayoutListener(LayoutListener l) {
        this.l = l;
    }

    public WrapComponent addProperty(Point location, FaDefPropertyInfo pp) {
        FaDefStylePagePropertyInfo sp = new FaDefStylePagePropertyInfo();
        sp.setLabelWidth(Config.label_default_width);
        sp.setProperty(pp);
        this.page.getProperties().add(sp);
        sp.setPage(this.page);
        WrapComponent wc = WrapComponent.createByProperty(pp, this, this, this);
        wc.setStylePagePropertyInfo(sp);
        this.wcList.add(wc);
        Point p = this.getRowCol(location);
        sp.setRow(p.y);
        sp.setCol(p.x);
        sp.setRows(1);
        sp.setCols(1);
        this.reLayout();
        if (this.l != null) {
            this.l.onAddComponent(wc);
        }
        this.select(wc);
        wc.updateUI();
        return wc;
    }

    public void removeProperty(FaDefStylePagePropertyInfo info) {
        for (int i = 0; i < this.wcList.size(); ++i) {
            WrapComponent wc = (WrapComponent)((Object)this.wcList.get(i));
            if (wc.getStylePagePropertyInfo() != info) continue;
            this.doRemoveWrapComponent(wc);
        }
    }

    private Point getRowCol(Point location) {
        Point p = new Point();
        p.x = location.x / this.colWidth;
        p.y = location.y / this.rowHeight;
        if (p.x >= this.cols) {
            p.x = this.cols - 1;
        }
        if (p.y >= this.rows) {
            p.y = this.rows - 1;
        }
        return p;
    }

    public boolean checkLayout(boolean showOKMessage) {
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < this.wcList.size(); ++i) {
            WrapComponent wc = (WrapComponent)((Object)this.wcList.get(i));
            FaDefStylePagePropertyInfo sp = wc.getStylePagePropertyInfo();
            int width = sp.getWidth();
            int height = sp.getHeight();
            int labelWidth = sp.getLabelWidth();
            sp.setWidth(0);
            sp.setHeight(0);
            sp.setLabelWidth(Config.label_default_width);
            for (int j = i + 1; j < this.wcList.size(); ++j) {
                Rectangle r2;
                WrapComponent wc2 = (WrapComponent)((Object)this.wcList.get(j));
                FaDefStylePagePropertyInfo sp2 = wc2.getStylePagePropertyInfo();
                Rectangle r1 = new Rectangle(sp.getCol(), sp.getRow(), sp.getCols(), sp.getRows());
                if (!ComponentUtil.hasDuplicateArea(r1, r2 = new Rectangle(sp2.getCol(), sp2.getRow(), sp2.getCols(), sp2.getRows()))) continue;
                msg.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.def.DEFAutoGenerateResource", (String)"35_LayoutCanvas"), sp.getProperty().getName(), sp2.getProperty().getName()));
                msg.append("\r\n");
            }
            sp.setWidth(width);
            sp.setHeight(height);
            sp.setLabelWidth(labelWidth);
        }
        boolean ok = true;
        if (msg.length() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)msg.toString());
            ok = false;
        } else if (showOKMessage) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.def.DEFAutoGenerateResource", (String)"24_LayoutCanvas"));
        }
        this.reLayout();
        return ok;
    }

    public void reLayout() {
        this.rows = this.page.getRows();
        this.cols = this.page.getCols();
        if (this.page.getRowHeight() > 0) {
            this.rowHeight = this.page.getRowHeight() + 3;
        }
        if (this.page.getColWidth() > 0) {
            this.colWidth = this.page.getColWidth();
        }
        this.removeAll();
        for (int i = 0; i < this.wcList.size(); ++i) {
            WrapComponent wc = (WrapComponent)((Object)this.wcList.get(i));
            FaDefStylePagePropertyInfo sp = wc.getStylePagePropertyInfo();
            wc.getWrapComponent().setBoundLabelLength(sp.getLabelWidth());
            if (sp.getRow() >= this.rows) {
                sp.setRow(this.rows - 1);
            }
            if (sp.getCol() >= this.cols) {
                sp.setCol(this.cols - 1);
            }
            while (sp.getRow() + sp.getRows() > this.rows) {
                sp.setRows(sp.getRows() - 1);
            }
            while (sp.getCol() + sp.getCols() > this.cols) {
                sp.setCols(sp.getCols() - 1);
            }
            int w = sp.getWidth() > 0 ? sp.getWidth() : sp.getCols() * this.colWidth - 4;
            int h = sp.getHeight() > 0 ? sp.getHeight() : sp.getRows() * this.rowHeight - 4;
            wc.setBounds(sp.getCol() * this.colWidth + 2, sp.getRow() * this.rowHeight + 2, w, h);
            this.add((Component)((Object)wc));
        }
        this.doLayout();
        this.repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.paintLayoutGrid(g);
        this.paintDragShadow(g);
    }

    private void paintLayoutGrid(Graphics g) {
        int i;
        g.setColor(Config.layout_grid_color);
        for (i = 0; i <= this.rows; ++i) {
            g.drawLine(0, i * this.rowHeight, this.cols * this.colWidth, i * this.rowHeight);
        }
        for (i = 0; i <= this.cols; ++i) {
            g.drawLine(i * this.colWidth, 0, i * this.colWidth, this.rows * this.rowHeight);
        }
    }

    private void paintDragShadow(Graphics g) {
        if (this.dragging) {
            WrapComponent wc = this.getSelected();
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Config.dragging_shadow_color);
            g2.setStroke(Config.dragging_shadow_store);
            int x = this.mouse_x - wc.getWidth() / 2;
            int y = this.mouse_y - wc.getHeight() / 2;
            g.drawRect(x, y, wc.getWidth() - 1, wc.getHeight() - 1);
        }
    }

    private void catchMousePosition(MouseEvent e) {
        this.mouse_x = e.getX();
        this.mouse_y = e.getY();
        for (Component c = e.getComponent(); c != this; c = c.getParent()) {
            this.mouse_x += c.getX();
            this.mouse_y += c.getY();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.getMouseOnWrapeComponent(e) != null && this.getSelected() != null) {
            this.dragging = true;
            this.catchMousePosition(e);
            this.setCursor(new Cursor(13));
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.catchMousePosition(e);
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        WrapComponent wc = this.getMouseOnWrapeComponent(e);
        if (wc != null) {
            this.select(wc);
        }
    }

    private WrapComponent getMouseOnWrapeComponent(MouseEvent e) {
        for (Component c = e.getComponent(); c != this; c = c.getParent()) {
            if (!(c instanceof WrapComponent)) continue;
            return (WrapComponent)((Object)c);
        }
        return null;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setCursor(new Cursor(0));
        WrapComponent wc = this.getSelected();
        if (this.dragging) {
            this.dragging = false;
            if (wc != null) {
                Point p = this.getRowCol(new Point(this.mouse_x, this.mouse_y));
                FaDefStylePagePropertyInfo sp = wc.getStylePagePropertyInfo();
                if (sp.getRow() != p.y || sp.getCol() != p.x) {
                    sp.setRow(p.y);
                    sp.setCol(p.x);
                    this.reLayout();
                    if (this.l != null) {
                        this.l.onMoveComponent(wc);
                    }
                }
            }
        }
    }

    public void select(WrapComponent wc) {
        for (int i = 0; i < this.wcList.size(); ++i) {
            WrapComponent c;
            c.setSelected((c = (WrapComponent)((Object)this.wcList.get(i))) == wc);
        }
        if (this.l != null) {
            this.l.onSelected(wc);
        }
        this.repaint();
        this.requestFocus();
    }

    private WrapComponent getSelected() {
        for (int i = 0; i < this.wcList.size(); ++i) {
            WrapComponent c = (WrapComponent)((Object)this.wcList.get(i));
            if (!c.isSelected()) continue;
            return c;
        }
        return null;
    }

    public WrapComponent getComponentBy(FaDefPropertyInfo p) {
        for (int i = 0; i < this.wcList.size(); ++i) {
            WrapComponent c = (WrapComponent)((Object)this.wcList.get(i));
            if (c.getStylePagePropertyInfo().getProperty() != p) continue;
            return c;
        }
        return null;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        WrapComponent selected;
        if (e.getKeyCode() == 127 && (selected = this.getSelected()) != null) {
            this.doRemoveWrapComponent(selected);
            this.reLayout();
            if (this.l != null) {
                this.l.onRemoveComponent(selected);
            }
        }
    }

    private void doRemoveWrapComponent(WrapComponent wc) {
        this.wcList.remove((Object)wc);
        FaDefStylePagePropertyInfo sp = wc.getStylePagePropertyInfo();
        sp.getPage().getProperties().remove(sp);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

