/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.icon.Icon;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.IVirtualRptBaseFacade;
import com.kingdee.eas.framework.report.SimpleCompanyUserObject;
import com.kingdee.eas.framework.report.client.AbstractVirtualRptBaseUI;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.AbortException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericException;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class VirtualRptBaseUI
extends AbstractVirtualRptBaseUI {
    private static final Logger logger = CoreUIObject.getLogger(VirtualRptBaseUI.class);
    EntityViewInfo condition = null;
    private CellTreeRenderer virtureCompanyRender = null;
    public int insertRowCount = 0;
    public int insertRowIndex = 0;
    private RptParams IDPramas = null;
    protected ArrayList allIdList;
    protected boolean isExpand = false;

    @Override
    public void onLoad() throws Exception {
        this.setMergeColumn();
        super.onLoad();
        this.getTable().getDataRequestManager().setDataRequestMode(1);
    }

    public void setIDPramas(RptParams pp) {
        this.IDPramas = pp;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    @Override
    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    @Override
    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    @Override
    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    @Override
    protected ICommRptBase getRemoteInstance() throws BOSException {
        return null;
    }

    @Override
    protected KDTable getTableForPrintSetting() {
        return null;
    }

    @Override
    protected RptParams getParamsForInit() {
        return null;
    }

    @Override
    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return null;
    }

    @Override
    protected void query() {
        this.setCellTreeRenderer();
    }

    @Override
    public void tableDataRequest(KDTDataRequestEvent e) {
        super.tableDataRequest(e);
    }

    public void setCellTreeRenderer() {
        IColumn treeCol = this.getTable().getColumn(this.getTreeCol());
        if (treeCol != null) {
            if (this.virtureCompanyRender == null) {
                this.virtureCompanyRender = new CellTreeRenderer();
            }
            treeCol.setRenderer((IBasicRender)this.virtureCompanyRender);
        }
    }

    public String getTreeCol() {
        return "fcompanyid";
    }

    public String getCompanyIdByRow(int rowIndex) {
        SimpleCompanyUserObject companyUserObject = (SimpleCompanyUserObject)this.getTable().getRow(rowIndex).getCell(this.getTreeCol()).getValue();
        return companyUserObject != null ? companyUserObject.getCompanyId() : null;
    }

    public void initVirtualCompanyListener() {
        this.getTable().addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                int row = e.getRowIndex();
                int column = e.getColIndex();
                if (e.getClickCount() == 1) {
                    VirtualRptBaseUI.this.cellClicked(row, column, e.getX(), e.getY());
                } else if (e.getClickCount() == 2) {
                    VirtualRptBaseUI.this.tblDoubleClicked(row, column, e.getX(), e.getY());
                }
            }
        });
    }

    public void tblDoubleClicked(int row, int column, int x, int y) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellClicked(int row, int column, int x, int y) {
        if (this.getTable().getRowCount() > 0 && row > -1 && column == this.getTable().getColumnIndex(this.getTreeCol())) {
            SimpleCompanyUserObject companyUserObject = (SimpleCompanyUserObject)this.getTable().getRow(row).getCell(column).getValue();
            if (companyUserObject == null) {
                return;
            }
            try {
                this.setCursorOfWair();
                this.doExpand(companyUserObject, row);
            }
            catch (Exception e) {
                this.handleException(e);
            }
            finally {
                this.setCursorOfDefault();
            }
        }
    }

    public void doExpand(SimpleCompanyUserObject companyUserObject, int rowIndex) throws Exception {
        int rowCount = this.getTable().getRowCount();
        if (companyUserObject.isLeaf() || companyUserObject.isIconEmpty()) {
            return;
        }
        this.isExpand = true;
        this.getTable().setRefresh(false);
        if (companyUserObject.isExpanded()) {
            String compblockId = companyUserObject.getBlockId();
            for (int i = rowIndex + 1; i < rowCount; ++i) {
                IRow row2 = this.getTable().getRow(i);
                SimpleCompanyUserObject company2 = (SimpleCompanyUserObject)row2.getCell(this.getTreeCol()).getValue();
                if (company2 == null) continue;
                if (company2.getLevel() == companyUserObject.getLevel()) break;
                if (company2.getLevel() <= companyUserObject.getLevel()) continue;
                if (!compblockId.equals(company2.getBlockId())) break;
                row2.getStyleAttributes().setHided(true);
                if (company2.getLevel() != companyUserObject.getLevel() || !row2.getStyleAttributes().isHided()) continue;
                row2.getStyleAttributes().setHided(false);
            }
            companyUserObject.setExpanded(false);
        } else if (companyUserObject.isHasExpanded()) {
            this.expandRow(rowIndex);
            companyUserObject.setExpanded(true);
        } else {
            RptParams pp = this.findData(rowIndex, companyUserObject);
            RptRowSet rs = (RptRowSet)pp.getObject("rowset");
            if (pp.getObject("LevelCount") != null) {
                this.insertRowIndex = pp.getInt("LevelCount");
                this.insertRowIndex = this.insertRowIndex == 0 ? rowIndex + 1 : (this.insertRowIndex += rowIndex);
                this.insertRows(rs, this.insertRowIndex, this.getTable(), true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), 0);
            } else {
                this.insertRows(rs, rowIndex + 1, this.getTable(), true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), 0);
            }
            this.insertRowCount += rs.getRowCount();
            this.getTable().setRowCount(this.getTable().getRowCount() + rs.getRowCount());
            this.setMergeRow(rowIndex);
            companyUserObject.setExpanded(true);
            companyUserObject.setHasExpanded(true);
        }
        this.getTable().setRefresh(true);
        this.getTable().reLayoutAndPaint();
        this.isExpand = false;
    }

    public void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.getTable().getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                if (this.getTable().getColumn(mergeColumnKeys[i]) == null) continue;
                this.getTable().getColumn(mergeColumnKeys[i]).setGroup(true);
                this.getTable().getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    public String[] getMergeColumnKeys() {
        return null;
    }

    private void setMergeRow(int rowIndex) {
        SimpleCompanyUserObject company2;
        IRow row2;
        int i;
        String treeCol;
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        int mergeRowCount = 0;
        int mergeStartRow = 0;
        IRow row = this.getTable().getRow(rowIndex);
        SimpleCompanyUserObject company = (SimpleCompanyUserObject)row.getCell(treeCol = this.getTreeCol()).getValue();
        if (company == null) {
            return;
        }
        for (i = rowIndex; i >= 0; --i) {
            row2 = this.getTable().getRow(i);
            company2 = (SimpleCompanyUserObject)row2.getCell(treeCol).getValue();
            if (company2 == null) continue;
            if (!company.getBlockId().equals(company2.getBlockId())) break;
            mergeStartRow = i;
        }
        for (i = rowIndex; i < this.getTable().getRowCount(); ++i) {
            row2 = this.getTable().getRow(i);
            if (row2.getCell(treeCol).getValue() == null || (company2 = (SimpleCompanyUserObject)row2.getCell(treeCol).getValue()) == null) continue;
            if (company2.getLevel() == 1 && i > rowIndex || !company.getBlockId().equals(company2.getBlockId())) break;
            ++rowIndex;
            ++mergeRowCount;
        }
        int colIndex = 0;
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            for (int i2 = 0; i2 < mergeColumnKeys.length; ++i2) {
                colIndex = this.getTable().getColumn(mergeColumnKeys[i2]).getColumnIndex();
                KDTMergeManager mm = this.getTable().getMergeManager();
                boolean c = mm.mergeBlock(mergeStartRow, colIndex, rowIndex - 1, colIndex);
                System.out.println(c);
            }
        }
    }

    public RptParams findData(int rowIndex, SimpleCompanyUserObject companyUserObject) throws Exception {
        RptParams pp = new RptParams();
        IRow row = this.getTable().getRow(rowIndex);
        pp.setString("fid", row.getCell("fblock").getValue().toString());
        pp.setString("fparentid", companyUserObject.getCompanyId().toString());
        pp.setString("tempTable", this.getTempTable());
        IVirtualRptBaseFacade report = this.getVirtualRemoteInstance();
        RptParams result = report.findData(pp, -1, -1, this.getTempTable(), companyUserObject);
        return result;
    }

    public void insertRows(RptRowSet rs, int insertRowIndex, KDTable table, boolean refreshUI, KDTableInsertHandler handler, int insertRowCount) {
    }

    protected IVirtualRptBaseFacade getVirtualRemoteInstance() throws BOSException {
        return null;
    }

    protected int expandRow(int rowIndex) {
        IRow row = this.getTable().getRow(rowIndex);
        int rowCount = this.getTable().getRowCount();
        String treeCol = this.getTreeCol();
        SimpleCompanyUserObject companyUserObject = (SimpleCompanyUserObject)row.getCell(treeCol).getValue();
        while (++rowIndex < rowCount) {
            IRow row2 = this.getTable().getRow(rowIndex);
            SimpleCompanyUserObject companyUserObject2 = (SimpleCompanyUserObject)row2.getCell(treeCol).getValue();
            if (companyUserObject2 == null) continue;
            IRow row3 = this.getTable().getRow(rowIndex - 1);
            if (companyUserObject2.isIconEmpty()) {
                row2.getStyleAttributes().setHided(row3.getStyleAttributes().isHided());
                continue;
            }
            if (companyUserObject2.getLevel() > companyUserObject.getLevel() && companyUserObject.getBlockId().equals(companyUserObject2.getBlockId().toString())) {
                row2.getStyleAttributes().setHided(false);
                if (companyUserObject2.isExpanded() || companyUserObject2.isLeaf()) continue;
                rowIndex = this.expandSkipChildren(rowIndex);
                continue;
            }
            --rowIndex;
            break;
        }
        return rowIndex;
    }

    private int expandSkipChildren(int rowIndex) {
        IRow row = this.getTable().getRow(rowIndex);
        int rowCount = this.getTable().getRowCount();
        SimpleCompanyUserObject companyUserObject = (SimpleCompanyUserObject)row.getCell(this.getTreeCol()).getValue();
        while (++rowIndex < rowCount) {
            IRow row2 = this.getTable().getRow(rowIndex);
            SimpleCompanyUserObject companyUserObject2 = (SimpleCompanyUserObject)row2.getCell(this.getTreeCol()).getValue();
            if (companyUserObject2 == null) continue;
            if (companyUserObject2.isIconEmpty()) {
                IRow row3 = this.getTable().getRow(rowIndex - 1);
                row2.getStyleAttributes().setHided(row3.getStyleAttributes().isHided());
                continue;
            }
            if (companyUserObject2.getLevel() != companyUserObject.getLevel()) continue;
            break;
        }
        return rowIndex - 1;
    }

    protected KDTable getTable() {
        return null;
    }

    protected void processException(Exception ex) {
        String errMsg = this.getExceptionMessage(ex);
        if (errMsg != null && errMsg.length() > 0) {
            this.setShowMessagePolicy(2);
            this.setMessageText(errMsg);
            this.setIsShowTextOnly(false);
            this.setMessageBgcolor(SHOW_MESSAGE_BG_ERROR);
            this.setMessageIcon(SHOW_MESSAGE_ICON_ERROR);
            this.showMessage();
        }
    }

    protected String getExceptionMessage(Exception exc) {
        if (exc instanceof AbortException) {
            return null;
        }
        if (exc instanceof NumericException) {
            return exc.getMessage();
        }
        return exc.getMessage();
    }

    protected void getAllDataOfId() {
        GetIdThread getAllIdThread = new GetIdThread(this);
        getAllIdThread.setDaemon(true);
        getAllIdThread.start();
        Date nowEnd = new Date();
        logger.debug((Object)("getAllDataOfId end at : " + nowEnd));
    }

    protected void setButtonEnabled(boolean enabled) {
        this.btnQuery.setEnabled(enabled);
        this.btnRefresh.setEnabled(enabled);
    }

    public static class CellTreeRenderer
    implements IBasicRender {
        protected SimpleTextRender simpleRender = new SimpleTextRender();
        protected Icon cbIcon;
        private Map mapOfTreeNodeLocation = new Hashtable();

        public CellTreeRenderer() {
            this.cbIcon = new TreeIcon();
        }

        public boolean inRect(SimpleCompanyUserObject companyUserObject, int x, int y) {
            String companyId = companyUserObject.getCompanyId();
            Rectangle rec = (Rectangle)this.mapOfTreeNodeLocation.get(companyId);
            if (rec != null) {
                return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
            }
            return false;
        }

        public void draw(Graphics g, Shape clip, Object value, Style style) {
            SimpleCompanyUserObject companyUserObject = null;
            if (!(value instanceof SimpleCompanyUserObject)) {
                companyUserObject = new SimpleCompanyUserObject();
                companyUserObject.setName((String)value);
                companyUserObject.setCompanyId("");
                companyUserObject.setisIconEmpty(true);
            } else {
                companyUserObject = (SimpleCompanyUserObject)value;
            }
            int ident = companyUserObject.getLevel() * 8;
            Rectangle rect = clip.getBounds();
            int x = rect.x + ident;
            int y = rect.y + (rect.height - this.cbIcon.getHeight()) / 2;
            int v = companyUserObject.isLeaf() ? 0 : (companyUserObject.isExpanded() ? 2 : 1);
            if (companyUserObject.isIconEmpty()) {
                v = 3;
            }
            Color color = style.getFontColor();
            g.setColor(color);
            Rectangle locRec = new Rectangle(x, y, this.cbIcon.getWidth(), this.cbIcon.getWidth());
            String companyId = companyUserObject.getCompanyId();
            this.mapOfTreeNodeLocation.put(companyId, locRec);
            int xx = x + this.cbIcon.getWidth() + 8;
            Rectangle newRec = new Rectangle(xx, rect.y, clip.getBounds().width - this.cbIcon.getWidth() - 8, (int)clip.getBounds().getHeight());
            this.simpleRender.draw(g, (Shape)newRec, companyUserObject.toString(), style);
            this.cbIcon.paint((Object)new Integer(v), g, x, y);
        }
    }

    public static class TreeIcon
    implements Icon {
        private int iconSize;
        private int margin;

        public TreeIcon() {
            this(9);
        }

        public TreeIcon(int iconSize) {
            this.iconSize = iconSize;
            this.margin = 2;
        }

        public int getWidth() {
            return this.iconSize;
        }

        public int getHeight() {
            return this.iconSize;
        }

        public void paint(Object value, Graphics g, int x, int y) {
            int type;
            if (value instanceof Integer && (type = ((Integer)value).intValue()) != 3) {
                if (type == 0) {
                    this.drawLeaf(g, x, y);
                } else if (type == 1) {
                    this.drawCollapsed(g, x, y);
                } else {
                    this.drawExpanded(g, x, y);
                }
            }
        }

        protected void drawLeaf(Graphics g, int x, int y) {
            int lineSize = this.iconSize - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.iconSize / 2, x + this.margin + lineSize, y + this.iconSize / 2);
        }

        protected void drawExpanded(Graphics g, int x, int y) {
            g.drawRect(x, y, this.iconSize, this.iconSize);
            int lineSize = this.iconSize - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.iconSize / 2, x + this.margin + lineSize, y + this.iconSize / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            g.drawRect(x, y, this.iconSize, this.iconSize);
            int lineSize = this.iconSize - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.iconSize / 2, x + this.margin + lineSize, y + this.iconSize / 2);
            g.drawLine(x + 1 + this.iconSize / 2, y + this.margin, x + 1 + this.iconSize / 2, y + this.margin + lineSize);
        }
    }

    class GetIdThread
    extends Thread {
        VirtualRptBaseUI baseUi;

        public GetIdThread(VirtualRptBaseUI baseUI) {
            this.baseUi = baseUI;
        }

        @Override
        public void run() {
            try {
                VirtualRptBaseUI.this.allIdList = new ArrayList();
                if (VirtualRptBaseUI.this.getTempTable() != null) {
                    RptParams pp = new RptParams();
                    if (VirtualRptBaseUI.this.IDPramas != null) {
                        pp = VirtualRptBaseUI.this.IDPramas;
                    } else {
                        pp.setString("tempTable", VirtualRptBaseUI.this.getTempTable());
                    }
                    IVirtualRptBaseFacade report = VirtualRptBaseUI.this.getVirtualRemoteInstance();
                    IRowSet result = report.getIdList(pp);
                    while (result.next()) {
                        VirtualRptBaseUI.this.allIdList.add(result.getString("FId"));
                    }
                }
                VirtualRptBaseUI.this.getTable().setRowCount(VirtualRptBaseUI.this.allIdList.size());
                VirtualRptBaseUI.this.setButtonEnabled(true);
            }
            catch (Exception ex) {
                VirtualRptBaseUI.this.setButtonEnabled(true);
                this.baseUi.handUIExceptionAndAbort(ex);
            }
        }
    }
}

