/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.report.sample.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.IVirtualRptBaseFacade;
import com.kingdee.eas.framework.report.SimpleCompanyUserObject;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.sample.HelloVirtualRptFacadeFactory;
import com.kingdee.eas.framework.report.sample.client.AbstractHelloVirtualRptUI;
import com.kingdee.eas.framework.report.sample.client.HelloReportConditionUI;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class HelloVirtualRptUI
extends AbstractHelloVirtualRptUI {
    private static final Logger logger = CoreUIObject.getLogger(HelloVirtualRptUI.class);
    private boolean firstLoadData = true;
    private int hasRowCount = 0;

    public HelloVirtualRptUI() throws Exception {
        this.tblmain.checkParsed();
        this.tblmain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblmain.getDataRequestManager().setDataRequestMode(1);
        this.enableExportExcel(this.tblmain);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    @Override
    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    @Override
    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    @Override
    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        this.insertRowCount = 0;
        super.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        super.actionQuery_actionPerformed(e);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    @Override
    protected RptParams getParamsForInit() {
        RptParams initParam = new RptParams();
        initParam.setString("init_title", "AA");
        return initParam;
    }

    @Override
    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return new HelloReportConditionUI();
    }

    @Override
    protected void query() {
        String title = this.params.getString("title");
        this.tblmain.removeColumns();
        this.tblmain.removeRows();
        super.query();
    }

    @Override
    protected ICommRptBase getRemoteInstance() throws BOSException {
        return HelloVirtualRptFacadeFactory.getRemoteInstance();
    }

    @Override
    public void tableDataRequest(KDTDataRequestEvent e) {
        int start = e.getFirstRow();
        int length = e.getLastRow() - start + 1;
        RptParams pp = new RptParams();
        Date nowBegin = new Date();
        try {
            if (start == 0 && this.firstLoadData) {
                try {
                    this.firstLoadData = false;
                    pp.setString("cuId", SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
                    RptParams rpt = HelloVirtualRptFacadeFactory.getRemoteInstance().createTempTable(pp);
                    this.setTempTable(rpt.getString("tempTable"));
                    RptTableHeader header = (RptTableHeader)rpt.getObject("header");
                    pp.setString("tempTable", this.getTempTable());
                    KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tblmain);
                    this.tblmain.getColumn(this.getTreeCol()).getStyleAttributes().setLocked(true);
                    rpt = HelloVirtualRptFacadeFactory.getRemoteInstance().query(pp, start, length);
                    RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                    this.hasRowCount += length;
                    this.insertRows(rs, start, this.tblmain, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), 0);
                    if (rs.getRowCount() == length) {
                        this.getAllDataOfId();
                    }
                }
                catch (BOSException ex) {
                    logger.error((Object)ex);
                    ex.printStackTrace();
                    this.handUIExceptionAndAbort((Exception)((Object)ex));
                }
                return;
            }
            ArrayList newList = new ArrayList(length);
            if (this.allIdList != null) {
                for (int i = start; i < start + length && i < this.allIdList.size(); ++i) {
                    newList.add(this.allIdList.get(i));
                }
            }
            if (newList != null && newList.size() > 0) {
                pp.setString("tempTable", this.getTempTable());
                RptParams rpt = HelloVirtualRptFacadeFactory.getRemoteInstance().getDataForIdList(newList, pp);
                RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                this.hasRowCount += length;
                this.insertRows(rs, start, this.tblmain, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), this.insertRowCount);
            }
        }
        catch (Exception ee) {
            logger.error((Object)ee);
            ee.printStackTrace();
            this.abort();
        }
        Date nowEnd = new Date();
        float waitSecond = (float)(nowEnd.getTime() - nowBegin.getTime()) / 1000.0f;
        logger.debug((Object)("getData used of times : " + waitSecond + " second."));
    }

    @Override
    public String[] getMergeColumnKeys() {
        String[] strMergeColKeys = new String[]{"fblock", "fmaterialname", "fmodel"};
        return strMergeColKeys;
    }

    @Override
    public void insertRows(RptRowSet rs, int insertRowIndex1, KDTable table, boolean refreshUI, KDTableInsertHandler handler, int insertRowCount1) {
        table.setRefresh(false);
        int rowIndex = insertRowIndex1 + insertRowCount1;
        while (rs.next()) {
            IRow row = table.addRow(rowIndex++);
            SimpleCompanyUserObject companyUserObject = new SimpleCompanyUserObject();
            companyUserObject.setCompanyId(rs.getString("fstorageorgunitid"));
            companyUserObject.setCuId(rs.getString("fblock"));
            companyUserObject.setName(rowIndex + "");
            companyUserObject.setExpanded(false);
            companyUserObject.setBlockId(rs.getString("fblock"));
            int isleaf = rs.getInt("fisleaf");
            if (isleaf == 1) {
                companyUserObject.setLeaf(true);
            } else {
                companyUserObject.setLeaf(false);
            }
            companyUserObject.setLevel(rs.getInt("flevel"));
            handler.setTableRowData(row, rs.toRowArray());
            ICell cell = row.getCell(this.getTreeCol());
            cell.setValue((Object)companyUserObject);
            cell.setUserObject((Object)companyUserObject);
        }
        if (refreshUI) {
            table.setRefresh(true);
        }
        if (rs.getRowCount() > 0) {
            table.reLayoutAndPaint();
        } else {
            table.repaint();
        }
    }

    protected void initListener() {
        super.initVirtualCompanyListener();
    }

    @Override
    protected IVirtualRptBaseFacade getVirtualRemoteInstance() throws BOSException {
        return HelloVirtualRptFacadeFactory.getRemoteInstance();
    }

    @Override
    public RptParams findData(int rowIndex, SimpleCompanyUserObject companyUserObject) throws Exception {
        RptParams pp = new RptParams();
        IRow row = this.getTable().getRow(rowIndex);
        pp.setString("fid", row.getCell("fblock").getValue().toString());
        pp.setString("fparentid", companyUserObject.getCompanyId().toString());
        pp.setString("tempTable", this.getTempTable());
        IVirtualRptBaseFacade report = this.getVirtualRemoteInstance();
        RptParams result = report.findData(pp, -1, -1, this.getTempTable(), companyUserObject);
        this.insertRowIndex += 100;
        return result;
    }

    @Override
    public String getTreeCol() {
        return "fstorageorgunitid";
    }

    @Override
    public String getCompanyIdByRow(int rowIndex) {
        SimpleCompanyUserObject companyUserObject = (SimpleCompanyUserObject)this.getTable().getRow(rowIndex).getCell(this.getTreeCol()).getValue();
        return companyUserObject.getCompanyId();
    }

    @Override
    protected KDTable getTableForPrintSetting() {
        return this.tblmain;
    }

    @Override
    protected KDTable getTable() {
        return this.tblmain;
    }
}

