/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.report.util;

import com.kingdee.bos.ctrl.common.GlobalLocator;
import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.eas.framework.report.util.CommRptResourceUtil;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.filechooser.FileFilter;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExcelExporter {
    public static final int ALIGN_LEFT = HorizontalAlignment.LEFT.getCode();
    public static final int ALIGN_CENTER = HorizontalAlignment.CENTER.getCode();
    public static final int ALIGN_RIGHT = HorizontalAlignment.RIGHT.getCode();
    private String exportFile = null;
    private Object[][] header = null;
    private int currentIndex = 0;
    private int pageIndex = -1;
    private boolean currentPageHasTitle = false;
    private OutputStream os = null;
    private HSSFSheet sheet = null;
    private HSSFWorkbook wb = null;
    private int[] widths = null;
    private int[] align = null;
    private HSSFFont font = null;
    private int[] numberColumns = null;
    private KDFileChooser fileChooser = null;
    private Component owner;
    private String pageTitle = "sheet";
    private List headMergedRegionList = new ArrayList();
    private Map colorMap = new HashMap();
    private Map csMap = new HashMap();
    private boolean isSetHeadMergedRegionList = false;

    public ExcelExporter(Component owner) {
        this.owner = owner;
    }

    public static String getTempFilename(String prefix) {
        String filename;
        String pp = System.getProperty("user.dir") + File.separator + "eastmp.xls" + File.separator + prefix;
        long timestamp = System.currentTimeMillis();
        File f = null;
        do {
            filename = pp + timestamp + ".xls";
            f = new File(filename);
            ++timestamp;
        } while (f.exists());
        return filename;
    }

    private void switchPage(boolean noHeader) {
        ++this.pageIndex;
        this.sheet = this.wb.createSheet(this.pageTitle + (this.pageIndex + 1));
        this.currentIndex = 0;
        this.currentPageHasTitle = false;
        if (!noHeader) {
            this.exportHeader();
        }
    }

    private void exportHeader() {
        int i;
        HSSFRow row = null;
        if (this.headMergedRegionList != null) {
            for (int i2 = 0; i2 < this.headMergedRegionList.size(); ++i2) {
                CellRangeAddress r = (CellRangeAddress)this.headMergedRegionList.get(i2);
                this.addMergedRegion(r.getFirstRow() + this.currentIndex, r.getFirstColumn(), r.getLastRow() + this.currentIndex, r.getLastColumn());
            }
        }
        for (i = 0; i < this.header.length; ++i) {
            row = this.sheet.createRow(this.currentIndex);
            ++this.currentIndex;
            this.setRowData(row, this.header[i], null, Color.LIGHT_GRAY, true);
        }
        this.currentPageHasTitle = true;
        if (this.widths != null) {
            for (i = 0; i < this.widths.length; i = (int)((short)(i + 1))) {
                this.sheet.setColumnWidth(i, (int)((short)(this.widths[i] * 37)));
            }
        }
    }

    public void insertColumn(Object labelValue, int colIndex, int alignment, int width, boolean isNumberColumn) {
        int i;
        int i2;
        int col = this.header[0].length + 1;
        if (colIndex < 0) {
            colIndex = col + colIndex;
        }
        Object[][] buf = new Object[this.header.length][col];
        for (i2 = 0; i2 < buf.length; ++i2) {
            int j;
            for (j = 0; j < colIndex; ++j) {
                buf[i2][j] = this.header[i2][j];
            }
            buf[i2][colIndex] = labelValue;
            for (j = colIndex; j < col - 1; ++j) {
                buf[i2][j + 1] = this.header[i2][j];
            }
        }
        this.header = buf;
        buf = null;
        if (this.align != null) {
            int[] buf2 = new int[this.align.length + 1];
            for (i = 0; i < colIndex; ++i) {
                buf2[i] = this.align[i];
            }
            buf2[colIndex] = alignment;
            for (i = colIndex; i < this.align.length; ++i) {
                buf2[i + 1] = this.align[i];
            }
            this.align = buf2;
            buf2 = null;
        }
        if (this.widths != null) {
            int[] buf2 = new int[this.widths.length + 1];
            for (i = 0; i < colIndex; ++i) {
                buf2[i] = this.widths[i];
            }
            buf2[colIndex] = width;
            for (i = colIndex; i < this.widths.length; ++i) {
                buf2[i + 1] = this.widths[i];
            }
            this.widths = buf2;
            buf2 = null;
        }
        if (this.numberColumns != null) {
            for (i2 = 0; i2 < this.numberColumns.length; ++i2) {
                if (this.numberColumns[i2] < colIndex) continue;
                int n = i2;
                this.numberColumns[n] = this.numberColumns[n] + 1;
            }
            if (isNumberColumn) {
                int[] buf2 = new int[this.numberColumns.length + 1];
                System.arraycopy(this.numberColumns, 0, buf2, 0, this.numberColumns.length);
                buf2[this.numberColumns.length] = colIndex;
                this.numberColumns = buf2;
                buf2 = null;
            }
        }
        if (!this.isSetHeadMergedRegionList) {
            for (i = 0; i < this.headMergedRegionList.size(); ++i) {
                CellRangeAddress r = (CellRangeAddress)this.headMergedRegionList.get(i);
                if (r.getFirstColumn() <= colIndex && r.getLastColumn() >= colIndex) {
                    if (r.getFirstColumn() == r.getLastColumn()) {
                        this.moveRegion(r, 0, 1);
                        continue;
                    }
                    r.setLastColumn((int)((short)(r.getLastColumn() + 1)));
                    continue;
                }
                if (r.getFirstColumn() <= colIndex) continue;
                this.moveRegion(r, 0, 1);
            }
            this.headMergedRegionList.add(new CellRangeAddress(0, (int)((short)colIndex), this.header.length - 1, (int)((short)colIndex)));
        }
    }

    public void setColumnLabel(Object labelValue, int colIndex) {
        if (colIndex < 0) {
            colIndex = this.header[0].length + colIndex;
        }
        for (int i = 0; i < this.header.length; ++i) {
            this.header[i][colIndex] = labelValue;
        }
    }

    private void setRowData(HSSFRow row, Object[] data, String[] strFormat, Color bgColor, boolean isHeader) {
        short alignment = HorizontalAlignment.LEFT.getCode();
        HSSFDataFormat formats = this.wb.createDataFormat();
        short formatment = formats.getFormat("@");
        int n = data.length;
        for (int j = 0; j < n; ++j) {
            if (this.align != null && this.align.length == data.length) {
                alignment = (short)this.align[j];
            }
            if (strFormat != null && strFormat[j] != null && strFormat[j].trim().length() > 0 && strFormat.length == data.length) {
                formatment = formats.getFormat(strFormat[j]);
            }
            HSSFCellStyle style = this.getCellStyle(bgColor, alignment, formatment, isHeader);
            HSSFCell cell = row.createCell((int)((short)j));
            cell.setCellStyle(style);
            if (strFormat == null) {
                this.setCellValue(cell, data[j] == null ? null : data[j].toString());
            } else if (this.isTextStyle(strFormat[j])) {
                this.setCellValue(cell, data[j] == null ? null : data[j].toString());
            } else {
                this.exportCellTextAsNumber(cell, data[j] == null ? null : data[j].toString());
            }
            if (isHeader) {
                row.setHeight((short)435);
                continue;
            }
            row.setHeight((short)270);
        }
    }

    public void open() throws IOException {
        File dd;
        if (this.exportFile == null) {
            this.exportFile = ExcelExporter.getTempFilename("GL");
        }
        if (!(dd = new File(new File(this.exportFile).getParentFile().getPath())).exists()) {
            dd.mkdirs();
        }
        this.os = new FileOutputStream(this.exportFile);
        this.wb = new HSSFWorkbook();
    }

    public void export(Object[][] data, boolean newPage) throws Exception {
        this.export(data, null, newPage, false);
    }

    public void export(Object[][] data, boolean newPage, boolean noHeader) throws Exception {
        this.export(data, null, newPage, noHeader);
    }

    public void export(Object[][] data, Color[] rowColor, boolean newPage, boolean noHeader) throws Exception {
        if (newPage || this.currentIndex == 0) {
            this.switchPage(noHeader);
        }
        if (!noHeader && !this.currentPageHasTitle) {
            this.exportHeader();
        }
        for (int i = 0; i < data.length; ++i) {
            HSSFRow row = this.sheet.createRow(this.currentIndex);
            if (rowColor == null || rowColor[i] == null) {
                this.setRowData(row, data[i], null, null, false);
            } else {
                this.setRowData(row, data[i], null, rowColor[i], false);
            }
            ++this.currentIndex;
            if (this.currentIndex != 65536) continue;
            this.switchPage(noHeader);
        }
    }

    public void export(Object[][] data, String[][] strFormat, Color[] rowColor, boolean newPage, boolean noHeader) throws Exception {
        if (newPage || this.currentIndex == 0) {
            this.switchPage(noHeader);
        }
        if (!noHeader && !this.currentPageHasTitle) {
            this.exportHeader();
        }
        for (int i = 0; i < data.length; ++i) {
            HSSFRow row = this.sheet.createRow(this.currentIndex);
            if (rowColor == null || rowColor[i] == null) {
                this.setRowData(row, data[i], strFormat[i], null, false);
            } else {
                this.setRowData(row, data[i], strFormat[i], rowColor[i], false);
            }
            ++this.currentIndex;
            if (this.currentIndex != 65536) continue;
            this.switchPage(noHeader);
        }
    }

    public void addMergedRegion(int rowFrom, int colFrom, int rowTo, int colTo) {
        if (this.sheet != null) {
            this.sheet.addMergedRegion(new CellRangeAddress(rowFrom, rowTo, colFrom, colTo));
        }
    }

    public void close() throws IOException {
        this.wb.write(this.os);
        this.os.flush();
        this.os.close();
    }

    public void openOrSaveExportFile() throws Exception {
        block6: {
            try {
                File f = GlobalLocator.getInstance().locateResourceFile("/client/LanchFile.bat");
                if (f == null) {
                    throw new IOException();
                }
                Runtime.getRuntime().exec("\"" + f.getAbsolutePath() + "\" \"excel\" \"" + this.getExportFile() + "\"");
            }
            catch (IOException e) {
                int result = this.getFileChooser().showSaveDialog(this.owner);
                if (result != 0) break block6;
                File file = this.fileChooser.getSelectedFile();
                String path = file.getAbsolutePath();
                FileFilter ext = this.fileChooser.getFileFilter();
                if (ext != null && !ext.accept(file)) {
                    if (ext instanceof ExcelFileFilter) {
                        path = path + ".xls";
                    }
                    file = new File(path);
                }
                if (file.exists()) {
                    file.delete();
                }
                new File(this.exportFile).renameTo(file);
            }
        }
    }

    public String getExportFile() {
        return this.exportFile;
    }

    public void setExportFile(String exportFile) {
        this.exportFile = exportFile;
    }

    public Object[][] getHeader() {
        return this.header;
    }

    public void setHeader(Object[][] header) {
        throw new RuntimeException(CommRptResourceUtil.getRes((String)"not_supported_method"));
    }

    public void setHeader(KDTable tbl) {
        throw new RuntimeException(CommRptResourceUtil.getRes((String)"not_supported_method"));
    }

    private Object[][] parseHeadArray(KDTable t) {
        int rows = t.getHeadRowCount();
        int cols = t.getColumnCount();
        int showColNum = 0;
        for (int i = 0; i < t.getColumnCount(); ++i) {
            if (!t.getColumn(i).getStyleAttributes().isHided()) {
                ++showColNum;
                continue;
            }
            t.getColumn(i).getWidth();
        }
        Object[][] data = new Object[rows][showColNum];
        for (int i = 0; i < rows; ++i) {
            int index = 0;
            for (int j = 0; j < cols; ++j) {
                if (t.getColumn(j).getStyleAttributes().isHided()) continue;
                data[i][index] = t.getHeadRow(i).getCell(j).getValue();
                ++index;
            }
        }
        return data;
    }

    private Object[][] mixHeader(Object[][] h1, Object[][] h2) {
        int row1 = h1.length;
        int row2 = h2.length;
        int row = Math.max(row1, row2);
        int col1 = h1[0].length;
        int col2 = h2[0].length;
        int col = col1 + col2;
        Object[][] re = new Object[row][col];
        if (row1 > row2) {
            for (int i = 0; i < row1; ++i) {
                for (int j = 0; j < col1; ++j) {
                    re[i][j] = h1[i][j];
                }
            }
            int n = row1 - row2;
            for (int i = 0; i < row2; ++i) {
                for (int j = 0; j < col2; ++j) {
                    re[i + n][j + col1] = h2[i][j];
                }
            }
        } else {
            int j;
            int i;
            int n = row2 - row1;
            for (i = 0; i < row1; ++i) {
                for (j = 0; j < col1; ++j) {
                    re[i + n][j] = h1[i][j];
                }
            }
            for (i = 0; i < row; ++i) {
                for (j = 0; j < col2; ++j) {
                    re[i][j + col1] = h2[i][j];
                }
            }
        }
        return re;
    }

    private CellRangeAddress parseRegion(int rowFrom, int colFrom, int rowTo, int colTo, int rowOffset, int colOffset) {
        return new CellRangeAddress(rowFrom += rowOffset, rowTo += rowOffset, colFrom += colOffset, colTo += colOffset);
    }

    private void moveRegion(CellRangeAddress r, int rowOffset, int colOffset) {
        r.setFirstRow(r.getFirstRow() + rowOffset);
        r.setLastRow(r.getLastRow() + rowOffset);
        r.setFirstColumn((int)((short)(r.getFirstColumn() + colOffset)));
        r.setLastRow((int)((short)(r.getLastColumn() + colOffset)));
    }

    void adjustDeleteCol(List mergeBlockList, int index) {
        Iterator it = mergeBlockList.iterator();
        ArrayList<KDTMergeBlock> temp = new ArrayList<KDTMergeBlock>();
        while (it.hasNext()) {
            KDTMergeBlock mb = (KDTMergeBlock)it.next();
            if (index < mb.getLeft()) continue;
            if (mb.getRight() == index && mb.getRight() == mb.getLeft()) {
                temp.add(mb);
                continue;
            }
            if (index > mb.getRight()) continue;
            mb.setRight(mb.getRight() - 1);
            if (!this.isInvalidMergeBloc(mb)) continue;
            temp.add(mb);
        }
        it = null;
        mergeBlockList.removeAll(temp);
        for (KDTMergeBlock mb : mergeBlockList) {
            if (index >= mb.getLeft()) continue;
            mb.setLeft(mb.getLeft() - 1);
            mb.setRight(mb.getRight() - 1);
        }
        it = null;
    }

    private boolean isInvalidMergeBloc(KDTMergeBlock mb) {
        boolean bool = false;
        if (mb.getLeft() == mb.getRight() && mb.getBottom() == mb.getTop()) {
            bool = true;
        }
        return bool;
    }

    public void setHeader(KDTable t1, KDTable t2) {
        if (!this.isSetHeadMergedRegionList) {
            int i;
            int i2;
            int r1 = t1.getHeadRowCount();
            int r2 = t2.getHeadRowCount();
            Object[][] head1 = this.parseHeadArray(t1);
            Object[][] head2 = this.parseHeadArray(t2);
            this.header = this.mixHeader(head1, head2);
            this.headMergedRegionList.clear();
            ArrayList<Object> m1Clone = new ArrayList<Object>();
            ArrayList<Object> m2Clone = new ArrayList<Object>();
            for (KDTMergeBlock mb : t1.getHeadMergeManager().getMergeBlockList()) {
                m1Clone.add(mb.clone());
            }
            for (KDTMergeBlock mb : t2.getHeadMergeManager().getMergeBlockList()) {
                m2Clone.add(mb.clone());
            }
            int hideCount = 0;
            for (i2 = 0; i2 < t1.getColumnCount(); ++i2) {
                if (!t1.getColumn(i2).getStyleAttributes().isHided()) continue;
                this.adjustDeleteCol(m1Clone, i2 - hideCount);
                ++hideCount;
            }
            hideCount = 0;
            for (i2 = 0; i2 < t2.getColumnCount(); ++i2) {
                if (!t2.getColumn(i2).getStyleAttributes().isHided()) continue;
                this.adjustDeleteCol(m2Clone, i2 - hideCount);
                ++hideCount;
            }
            int colOffset = 0;
            int rowOffset = r1 - r2;
            if (rowOffset >= 0) {
                rowOffset = 0;
            } else {
                for (i = 0; i < t1.getColumnCount(); ++i) {
                    this.headMergedRegionList.add(this.parseRegion(0, i, r1, i, 0, 0));
                    this.header[0][i] = this.header[-rowOffset][i];
                }
                rowOffset += 0;
            }
            for (i = 0; i < m1Clone.size(); ++i) {
                KDTMergeBlock mb = (KDTMergeBlock)m1Clone.get(i);
                this.headMergedRegionList.add(this.parseRegion(mb.getTop(), (short)mb.getLeft(), mb.getBottom(), (short)mb.getRight(), rowOffset, colOffset));
            }
            colOffset = t1.getColumnCount();
            rowOffset = r2 - r1;
            if (rowOffset >= 0) {
                rowOffset = 0;
            } else {
                for (i = 0; i < t2.getColumnCount(); ++i) {
                    this.headMergedRegionList.add(this.parseRegion(0, i + colOffset, r2, i + colOffset, 0, 0));
                    this.header[0][i + colOffset] = this.header[-rowOffset][i + colOffset];
                }
                rowOffset += 0;
            }
            for (i = 0; i < m2Clone.size(); ++i) {
                KDTMergeBlock mb = (KDTMergeBlock)m2Clone.get(i);
                this.headMergedRegionList.add(this.parseRegion(mb.getTop(), (short)mb.getLeft(), mb.getBottom(), (short)mb.getRight(), rowOffset, colOffset));
            }
        }
        int showColNum = 0;
        for (int i = 0; i < t2.getColumnCount(); ++i) {
            if (t2.getColumn(i).getStyleAttributes().isHided()) continue;
            ++showColNum;
        }
        int col = t1.getColumnCount() + t2.getColumnCount();
        int showCol = t1.getColumnCount() + showColNum;
        int len1 = t1.getColumnCount();
        this.widths = new int[showCol];
        this.align = new int[showCol];
        int m = 0;
        for (int i = 0; i < col; ++i) {
            KDTable t;
            int n;
            if (i < len1) {
                n = i;
                t = t1;
            } else {
                n = i - len1;
                t = t2;
            }
            if (t.getColumn(n).getStyleAttributes().isHided()) continue;
            this.widths[m] = t.getColumn(n).getWidth();
            this.align[m] = t.getColumn(n).getStyleAttributes().getHorizontalAlign().getValue();
            ++m;
        }
        this.font = this.wb.createFont();
        Style style = t1.getHeadRow(0).getCell(0).getStyle();
        this.font.setFontName(style.getFontName());
        this.font.setFontHeightInPoints((short)style.getFontSize());
    }

    private HSSFCellStyle getCellStyle(Color bgColor, short alignment, short formatment, boolean isHeader) {
        short hc = bgColor == null ? this.getNearestColor(Color.WHITE).getIndex() : this.getNearestColor(bgColor).getIndex();
        String key = alignment + "-" + formatment + "-" + hc + "-" + isHeader;
        if (!this.csMap.containsKey(key)) {
            HSSFCellStyle cs = this.wb.createCellStyle();
            cs.setFont(this.font);
            cs.setFillBackgroundColor(hc);
            cs.setFillForegroundColor(hc);
            cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cs.setAlignment(HorizontalAlignment.forInt((int)alignment));
            cs.setDataFormat(formatment);
            if (isHeader) {
                cs.setAlignment(HorizontalAlignment.CENTER);
                cs.setVerticalAlignment(VerticalAlignment.CENTER);
            }
            this.csMap.put(key, cs);
        }
        return (HSSFCellStyle)this.csMap.get(key);
    }

    private KDFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            String title = LanguageManager.getLangMessage((String)"FileChooserTitle", KDTMenuManager.class, (String)"Save As...");
            this.fileChooser = new KDFileChooser();
            this.fileChooser.setDialogTitle(title);
            this.fileChooser.setFileFilter((FileFilter)new ExcelFileFilter());
        }
        return this.fileChooser;
    }

    private HSSFColor getNearestColor(Color awtColor) {
        if (this.colorMap.containsKey(awtColor)) {
            return (HSSFColor)this.colorMap.get(awtColor);
        }
        HSSFColor color = null;
        Map triplets = HSSFColor.getTripletHash();
        Set keys = triplets.keySet();
        if (keys != null && keys.size() > 0) {
            Object key2 = null;
            HSSFColor crtColor = null;
            short[] rgb = null;
            int diff = 0;
            int minDiff = 999;
            for (Object key2 : keys) {
                crtColor = (HSSFColor)triplets.get(key2);
                rgb = crtColor.getTriplet();
                diff = Math.abs(rgb[0] - awtColor.getRed()) + Math.abs(rgb[1] - awtColor.getGreen()) + Math.abs(rgb[2] - awtColor.getBlue());
                if (diff >= minDiff) continue;
                minDiff = diff;
                color = crtColor;
            }
            this.colorMap.put(awtColor, color);
        }
        return color;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }

    public int[] getWidths() {
        return this.widths;
    }

    public void setWidths(int[] widths) {
        this.widths = widths;
    }

    public int[] getNumberColumns() {
        return this.numberColumns;
    }

    public void setNumberColumns(int[] numberColumns) {
        this.numberColumns = numberColumns;
    }

    private boolean isTextStyle(String numberFormat) {
        return numberFormat != null && numberFormat.trim().length() > 0 && (numberFormat.equals("@") || numberFormat.equals("%l{@}s"));
    }

    private void exportCellTextAsNumber(HSSFCell cell, String text) {
        if (text == null) {
            return;
        }
        try {
            Double d = Double.valueOf(text);
            cell.setCellValue(((Number)d).doubleValue());
        }
        catch (NumberFormatException e) {
            this.setCellValue(cell, text);
        }
    }

    private void setCellValue(HSSFCell cell, String text) {
        if (!StringUtil.isEmptyString((String)text)) {
            cell.setCellValue(text);
        }
    }

    public void setHeadMergedRegionList(boolean isSetHeadMergedRegionList) {
        isSetHeadMergedRegionList = true;
    }

    class ExcelFileFilter
    extends FileFilter {
        protected static final String POSTFIX = ".xls";
        protected final String description = "Excel File";

        ExcelFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.getName().toLowerCase(Locale.getDefault()).endsWith(POSTFIX) || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return ".xls(Excel File)";
        }
    }
}

