/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.bi.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.bi.BIItemCollection;
import com.kingdee.eas.fi.gr.bi.BIItemFactory;
import com.kingdee.eas.fi.gr.bi.BIItemInfo;
import com.kingdee.eas.fi.gr.bi.IBIItem;
import com.kingdee.eas.fi.gr.bi.SubjectInfo;
import com.kingdee.eas.fi.gr.bi.client.AbstractBISubjectItemMaintainUI;
import com.kingdee.eas.fi.gr.bi.client.BISubjectItemEditUI;
import com.kingdee.eas.fi.gr.bi.client.ExtractItemDataUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BISubjectItemMaintainUI
extends AbstractBISubjectItemMaintainUI {
    private static final Logger logger = CoreUIObject.getLogger(BISubjectItemMaintainUI.class);
    private IBIItem ibiItem = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnUp.setEnabled(true);
        this.btnDown.setEnabled(true);
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnSaveSequence.setIcon(EASResource.getIcon((String)"imgTbtn_saveall"));
        this.btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.createTree();
        this.refreshTable((SubjectInfo)SubjectInfo.getSubjects().get(0));
        this.kDTree1.setSelectionRow(0);
        this.tblMain.setEditable(false);
        KeyStroke ks = KeyStroke.getKeyStroke("ctrl D");
        String strKey = "CTRL_D";
        this.getActionMap().put(strKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Frame frame = UIFactoryHelper.getMainFrame((Map)BISubjectItemMaintainUI.this.getUIContext());
                    ExtractItemDataUI.createDialog(frame).show();
                }
                catch (Exception ex) {
                    BISubjectItemMaintainUI.this.handleException(ex);
                }
            }
        });
        this.getInputMap(2).put(ks, strKey);
    }

    private void createTree() {
        KDTreeNode root = new KDTreeNode((Object)"HaHa ~_~");
        List list = SubjectInfo.getSubjects();
        for (int i = 0; i < list.size(); ++i) {
            root.add((MutableTreeNode)new KDTreeNode(list.get(i)));
        }
        this.kDTree1.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
    }

    @Override
    public void actionUp_actionPerformed(ActionEvent e) throws Exception {
        this.moveUp();
    }

    @Override
    public void actionDown_actionPerformed(ActionEvent e) throws Exception {
        this.moveDown();
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        IRow row = this.getSelectedRow();
        if (row == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"37_BISubjectItemMaintainUI"));
            return;
        }
        UIContext ctx = new UIContext((Object)this);
        BIItemInfo info = (BIItemInfo)row.getUserObject();
        ctx.put((Object)"Edit_Object", (Object)info);
        IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BISubjectItemEditUI.class.getName(), (Map)ctx, null, OprtState.VIEW);
        ui.show();
    }

    private void refreshTable(SubjectInfo info) {
        StringBuffer oql = new StringBuffer("select * where biSubjectName = '");
        oql.append(info.getNumber()).append("' order by sequence");
        try {
            BIItemCollection col = BIItemFactory.getRemoteInstance().getCollection(oql.toString());
            this.tblMain.removeRows();
            for (int i = 0; i < col.size(); ++i) {
                BIItemInfo item = col.get(i);
                this.addRow(item);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"BIItemgetCollection_BOSException", (Throwable)e);
            SysUtil.abort((Throwable)e);
        }
    }

    private void addRow(BIItemInfo item) {
        IRow row = this.tblMain.addRow();
        this.updateRow(item, row);
    }

    private void updateRow(BIItemInfo item, IRow row) {
        row.getCell("Item", true).setValue((Object)(this.getIndent(item.getIndent()) + item.getItemName()));
        row.getCell("RealItem", true).setValue((Object)item.getItemDefine());
        row.getCell("Description", true).setValue((Object)item.getDescription());
        row.getCell("unit", true).setValue((Object)item.getUnit());
        row.getCell("standard", true).setValue((Object)item.getStandard());
        row.setUserObject((Object)item);
    }

    private String getIndent(int indent) {
        String r = "";
        for (int i = 0; i < indent; ++i) {
            r = r + " ";
        }
        return r;
    }

    @Override
    protected void subject_selection_changed(TreeSelectionEvent e) throws Exception {
        SubjectInfo info = this.getSelectedSubject();
        this.refreshTable(info);
    }

    private SubjectInfo getSelectedSubject() {
        return (SubjectInfo)((KDTreeNode)this.kDTree1.getLastSelectedPathComponent()).getUserObject();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void moveUp() {
        IRow row = this.getSelectedRow();
        if (row != null && row.getRowIndex() > 0) {
            this.tblMain.removeRow(row.getRowIndex());
            int i = row.getRowIndex() - 1;
            this.tblMain.addRow(i, row);
            this.selectRow(i);
        }
    }

    private void moveDown() {
        IRow row = this.getSelectedRow();
        if (row != null && row.getRowIndex() < this.tblMain.getRowCount() - 1) {
            this.tblMain.removeRow(row.getRowIndex());
            int i = row.getRowIndex() + 1;
            this.tblMain.addRow(i, row);
            this.selectRow(i);
        }
    }

    private void selectRow(int row) {
        this.tblMain.getSelectManager().select(row, 0);
    }

    @Override
    public void actionAddnew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddnew_actionPerformed(e);
        UIContext ctx = new UIContext((Object)this);
        SubjectInfo subj = this.getSelectedSubject();
        BIItemInfo info = new BIItemInfo();
        info.setBiSubjectName(subj.getNumber());
        info.setSequence(new BigDecimal("" + (this.tblMain.getRowCount() + 20)));
        info.setRemoveable(true);
        info.setEditable(true);
        info.setIsStandard(false);
        info.setNumber(BOSUuid.create((String)"CSLBI").toString());
        ctx.put((Object)"Edit_Object", (Object)info);
        IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BISubjectItemEditUI.class.getName(), (Map)ctx, null, OprtState.ADDNEW);
        ui.show();
        if (!StringUtils.isEmpty((String)info.getItemName())) {
            BOSUuid pk = BOSUuid.create((BOSObjectType)info.getBOSType());
            this.getRemoteController().addnew((IObjectPK)new ObjectUuidPK(pk), info);
            info.setId(pk);
            this.addRow(info);
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        IRow row = this.getSelectedRow();
        if (row == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"37_BISubjectItemMaintainUI"));
            return;
        }
        UIContext ctx = new UIContext((Object)this);
        BIItemInfo info = (BIItemInfo)row.getUserObject();
        ctx.put((Object)"Edit_Object", (Object)info);
        IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BISubjectItemEditUI.class.getName(), (Map)ctx, null, OprtState.EDIT);
        ui.show();
        this.getRemoteController().update((IObjectPK)new ObjectUuidPK(info.getId()), info);
        this.updateRow(info, row);
    }

    private IBIItem getRemoteController() throws BOSException {
        if (this.ibiItem == null) {
            this.ibiItem = BIItemFactory.getRemoteInstance();
        }
        return this.ibiItem;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        int size = this.tblMain.getRowCount();
        HashMap<String, BigDecimal> sequence = new HashMap<String, BigDecimal>();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.getRow(i);
            BIItemInfo info = (BIItemInfo)row.getUserObject();
            info.setSequence(new BigDecimal(i));
            sequence.put(info.getId().toString(), info.getSequence());
        }
        this.getRemoteController().updateSequence(sequence);
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        super.actionExit_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.getSelectedRow();
        if (row != null) {
            BIItemInfo info = (BIItemInfo)row.getUserObject();
            if (!info.isEditable() || !info.isRemoveable()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"38_BISubjectItemMaintainUI"));
                return;
            }
            int r = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"39_BISubjectItemMaintainUI"));
            if (!MsgBox.isOk((int)r)) {
                return;
            }
            this.getRemoteController().delete((IObjectPK)new ObjectUuidPK(info.getId()));
            this.tblMain.removeRow(row.getRowIndex());
        }
    }

    private IRow getSelectedRow() {
        int row = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row2 = this.tblMain.getRow(row);
        return row2;
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 2 && e.getButton() == 1) {
            this.actionView_actionPerformed(null);
        }
    }
}

