/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.bi.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.bi.client.AbstractItemAnalysisFilterUI;
import com.kingdee.eas.fi.gr.bi.client.EnumChooserLabelProvider;
import com.kingdee.eas.fi.gr.bi.client.FetchTypeLabelProvider;
import com.kingdee.eas.fi.gr.bi.client.FetchTypeProvider;
import com.kingdee.eas.fi.gr.bi.client.IChooserContentProvider;
import com.kingdee.eas.fi.gr.bi.client.IChooserLabelProvider;
import com.kingdee.eas.fi.gr.bi.client.ItemContentProvider;
import com.kingdee.eas.fi.gr.bi.client.ItemLabelProvider;
import com.kingdee.eas.fi.gr.bi.client.OrgUnitTreeSelector;
import com.kingdee.eas.fi.gr.bi.client.SortableChooser;
import com.kingdee.eas.fi.gr.bi.util.AnalysisAdjustEnum;
import com.kingdee.eas.fi.gr.bi.util.RptBiUtil;
import com.kingdee.eas.fi.gr.cslrpt.CslDataSrcTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ItemAnalysisFilterUI
extends AbstractItemAnalysisFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ItemAnalysisFilterUI.class);
    String treeidLast = "";
    int flag = 2;
    ItemListener orgListener = new OrgTreeItemListener();

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.createController();
        this.btnCancel.setVisible(false);
        this.btnOK.setVisible(false);
        this.remove((Component)this.btnCancel);
        this.remove((Component)this.btnOK);
        this.endYearSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    ItemAnalysisFilterUI.this.endYearSpin_stateChanged(e);
                }
                catch (Exception exc) {
                    ItemAnalysisFilterUI.this.handUIException(exc);
                }
            }
        });
        this.endPeriodSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    ItemAnalysisFilterUI.this.endPeriodSpin_stateChanged(e);
                }
                catch (Exception exc) {
                    ItemAnalysisFilterUI.this.handUIException(exc);
                }
            }
        });
        if (this.orgTreeCombo.getItemListeners().length == 0) {
            this.orgTreeCombo.addItemListener(this.orgListener);
        }
    }

    private void createController() throws Exception {
        this.createPeriodCtrl();
        this.createOrgPromp();
        this.itemPromp.setEditable(false);
        this.itemPromp.setSelectAllOnFocus(false);
        this.itemPromp.setSelector((KDPromptSelector)new SortableChooser(new ItemContentProvider(){

            @Override
            public List getSelected() {
                return (List)ItemAnalysisFilterUI.this.itemPromp.getData();
            }
        }, new ItemLabelProvider(), (IUIObject)this));
        this.fetchTypePromp.setEditable(false);
        this.fetchTypePromp.setSelectAllOnFocus(false);
        this.fetchTypePromp.setSelector((KDPromptSelector)new SortableChooser(new FetchTypeProvider(){

            @Override
            public List getSelected() {
                return (List)ItemAnalysisFilterUI.this.fetchTypePromp.getData();
            }
        }, new FetchTypeLabelProvider(), (IUIObject)this));
        this.currencyPromp.setEditable(false);
        this.currencyPromp.setSelectAllOnFocus(false);
        CurrencyProvider contentP = new CurrencyProvider();
        this.currencyPromp.setSelector((KDPromptSelector)new SortableChooser(contentP, new CurrencyLabelProvider(), (IUIObject)this));
        this.currencyPromp.setData((Object)contentP.getContents());
        this.createDataType();
        this.createAdjustPromp();
        this.dataSourceCombo.addItem((Object)CslDataSrcTypeEnum.COMBINE);
        this.dataSourceCombo.addItem((Object)CslDataSrcTypeEnum.SUMMARY);
        this.dataSourceCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (CslDataSrcTypeEnum.COMBINE.equals((Object)((CslDataSrcTypeEnum)((Object)ItemAnalysisFilterUI.this.dataSourceCombo.getSelectedItem())))) {
                        ItemAnalysisFilterUI.this.chkDisplayElimData.setEnabled(true);
                    } else {
                        ItemAnalysisFilterUI.this.chkDisplayElimData.setSelected(false);
                        ItemAnalysisFilterUI.this.chkDisplayElimData.setEnabled(false);
                    }
                }
            }
        });
    }

    private void createAdjustPromp() {
        this.adjustPromp.setEditable(false);
        this.adjustPromp.setSelectAllOnFocus(false);
        this.adjustPromp.setSelector((KDPromptSelector)new SortableChooser(new IChooserContentProvider(){
            List contents = null;

            @Override
            public int compare(Object obj1, Object obj2) {
                return obj1 == obj2 ? 0 : 1;
            }

            @Override
            public boolean enableFilter() {
                return false;
            }

            @Override
            public List getContents() throws Exception {
                if (this.contents == null) {
                    this.contents = new ArrayList();
                    this.contents.add(AnalysisAdjustEnum.ADJUSTED);
                    this.contents.add(AnalysisAdjustEnum.BEFOREADJUST);
                    this.contents.add(AnalysisAdjustEnum.ADJUSTVALUE);
                }
                return this.contents;
            }

            @Override
            public List getSelected() {
                return (List)ItemAnalysisFilterUI.this.adjustPromp.getData();
            }

            @Override
            public boolean matchFilter(Object item, int column, String filterString) {
                return false;
            }

            @Override
            public void setContents(ArrayList contents) {
                this.contents = contents;
            }

            @Override
            public boolean enableTemplateFilter() {
                return false;
            }
        }, new EnumChooserLabelProvider(), (IUIObject)this));
    }

    private void createDataType() {
        this.dataTypePromp.setEditable(false);
        this.dataTypePromp.setSelectAllOnFocus(false);
        this.dataTypePromp.setSelector((KDPromptSelector)new SortableChooser(new IChooserContentProvider(){
            List contents = null;

            @Override
            public int compare(Object obj1, Object obj2) {
                return obj1 == obj2 ? 0 : 1;
            }

            @Override
            public boolean enableFilter() {
                return false;
            }

            @Override
            public List getContents() throws Exception {
                if (this.contents == null) {
                    this.contents = new ArrayList();
                    this.contents.add(ValueTypeEnum.MONEY);
                    this.contents.add(ValueTypeEnum.QUANTITY);
                }
                return this.contents;
            }

            @Override
            public List getSelected() {
                return (List)ItemAnalysisFilterUI.this.dataTypePromp.getData();
            }

            @Override
            public boolean matchFilter(Object item, int column, String filterString) {
                return false;
            }

            @Override
            public void setContents(ArrayList contents) {
                this.contents = contents;
            }

            @Override
            public boolean enableTemplateFilter() {
                return false;
            }
        }, new EnumChooserLabelProvider(), (IUIObject)this));
    }

    private void createPeriodCtrl() throws EASBizException, BOSException {
        this.periodTypeCombo.addItems(RptPeriodTypeEnum.getEnumList().toArray());
        this.setSpineRange(this.startYearSpin, 1901, 2099);
        this.setSpineRange(this.endYearSpin, 1901, 2099);
        Calendar calendar = Calendar.getInstance();
        this.startYearSpin.setValue((Object)new Integer(calendar.get(1)));
        this.endYearSpin.setValue((Object)new Integer(calendar.get(1)));
        this.periodTypeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ItemAnalysisFilterUI.this.flag = 1;
                    ItemListener[] orglistens = ItemAnalysisFilterUI.this.orgTreeCombo.getItemListeners();
                    for (int i = 0; i < orglistens.length; ++i) {
                        ItemAnalysisFilterUI.this.orgTreeCombo.removeItemListener(orglistens[i]);
                    }
                    RptPeriodTypeEnum item = (RptPeriodTypeEnum)e.getItem();
                    if (FiscalPeriodHelper.isMergeByFiscalPeriod(ItemAnalysisFilterUI.this.isMergeByFiscalPeriod, item)) {
                        FiscalPeriodHelper.setSpineRangeByPeriodType(ItemAnalysisFilterUI.this.startPeriodSpin, item);
                        FiscalPeriodHelper.setSpineRangeByPeriodType(ItemAnalysisFilterUI.this.endPeriodSpin, item);
                    } else {
                        ItemAnalysisFilterUI.this.setPeriodRange(ItemAnalysisFilterUI.this.startPeriodSpin, item.getValue(), (Integer)ItemAnalysisFilterUI.this.startYearSpin.getValue());
                        ItemAnalysisFilterUI.this.setPeriodRange(ItemAnalysisFilterUI.this.endPeriodSpin, item.getValue(), (Integer)ItemAnalysisFilterUI.this.endYearSpin.getValue());
                    }
                    int[] period = ItemAnalysisFilterUI.this.getLastPeriod(item);
                    ItemAnalysisFilterUI.this.startYearSpin.setValue((Object)new Integer(period[0]));
                    ItemAnalysisFilterUI.this.endYearSpin.setValue((Object)new Integer(period[0]));
                    ItemAnalysisFilterUI.this.startPeriodSpin.setValue((Object)new Integer(period[1]));
                    orglistens = ItemAnalysisFilterUI.this.orgTreeCombo.getItemListeners();
                    if (orglistens.length == 0) {
                        ItemAnalysisFilterUI.this.orgTreeCombo.addItemListener(ItemAnalysisFilterUI.this.orgListener);
                    }
                    ItemAnalysisFilterUI.this.flag = 2;
                    ItemAnalysisFilterUI.this.endPeriodSpin.setValue((Object)new Integer(period[1]));
                }
            }
        });
        this.periodTypeCombo.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        this.initOrgTreeCombo();
    }

    protected void endYearSpin_stateChanged(ChangeEvent e) throws Exception {
        if (this.flag != 1) {
            this.initOrgTreeCombo();
        }
    }

    protected void endPeriodSpin_stateChanged(ChangeEvent e) throws Exception {
        if (this.flag != 1) {
            this.initOrgTreeCombo();
        }
    }

    private void initOrgTreeCombo() throws EASBizException, BOSException {
        int endYear = (Integer)this.endYearSpin.getValue();
        int endPeriod = (Integer)this.endPeriodSpin.getValue();
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.periodTypeCombo.getSelectedItem();
        List rptYearAndPeriodAndDate = RPTDateUtil.getRptYearAndPeriodAndDate(endYear, endPeriod, periodType);
        Date rptDate = (Date)rptYearAndPeriodAndDate.get(rptYearAndPeriodAndDate.size() - 1);
        OrgTreeCollection otc = CslRptUIUtil.getOrgTreeCollection(rptDate);
        int size = otc.size();
        for (int i = size - 1; i >= 0; --i) {
            if (OrgViewType.COMPANY.equals((Object)otc.get(i).getLayerType())) continue;
            otc.removeObject(i);
        }
        if (this.orgTreeCombo.getSelectedItem() != null && this.flag == 2) {
            this.treeidLast = ((OrgTreeInfo)this.orgTreeCombo.getSelectedItem()).getNumber();
        }
        this.orgTreeCombo.removeAllItems();
        this.orgTreeCombo.addItems(otc.toArray());
        if (!"".equals(this.treeidLast) && this.orgTreeCombo.getSelectedItem() == null) {
            this.orgPromp.setData(null);
        }
    }

    private int[] getLastPeriod(RptPeriodTypeEnum t) {
        Calendar c = Calendar.getInstance();
        int thismonth = c.get(2);
        do {
            c.add(5, -1);
        } while (c.get(2) == thismonth);
        int[] period = RPTDateUtil.getPeriod(new Date(c.getTimeInMillis()), t);
        return period;
    }

    private void createOrgPromp() {
        this.orgPromp.setEditable(false);
        this.orgPromp.setSelectAllOnFocus(false);
        this.orgPromp.setSelector((KDPromptSelector)new OrgUnitTreeSelector((IUIObject)this, this.orgPromp, (OrgTreeInfo)this.orgTreeCombo.getSelectedItem(), null){

            @Override
            public OrgUnitInfo getOrg() {
                return null;
            }

            @Override
            public OrgTreeInfo getTree() {
                Object obj = ItemAnalysisFilterUI.this.orgTreeCombo.getSelectedItem();
                if (obj == null) {
                    MsgBox.showError((Component)((Object)ItemAnalysisFilterUI.this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"49_ItemAnalysisFilterUI"));
                    SysUtil.abort();
                }
                return (OrgTreeInfo)obj;
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    String getMainUIName() {
        return null;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = new CustomerParams();
        params.putInt("PERIODTYPECOMBO", ((RptPeriodTypeEnum)this.periodTypeCombo.getSelectedItem()).getValue());
        params.addCustomerParam("FETCH_TYPE", this.getCollectionNumbers((List)this.fetchTypePromp.getData()));
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.orgTreeCombo.getSelectedItem();
        params.addCustomerParam("ORG_TREE_ID", orgTreeInfo.getId().toString());
        params.addCustomerParam("ORGS", this.getCollectionIDs((List)this.orgPromp.getData()));
        params.addCustomerParam("ITEMS", this.getCollectionNumbers((List)this.itemPromp.getData()));
        params.putBoolean("SHOW_ORG_SUM", this.showOrgSumChk.isSelected());
        params.putBoolean("SHOW_PERIOD_SUM", this.showPeriodSumChk.isSelected());
        params.addCustomerParam("DATA_TYPE", this.getEnumValues((List)this.dataTypePromp.getData()));
        params.putInt("DATA_SRC_TYPE", ((CslDataSrcTypeEnum)((Object)this.dataSourceCombo.getSelectedItem())).getValue());
        params.putBoolean("DISPLAY_ELIM_DATA", this.chkDisplayElimData.isSelected());
        params.addCustomerParam("ADJUST", this.getEnumValues((List)this.adjustPromp.getData()));
        params.addCustomerParam("CURRENCY_ID", this.getCollectionNumbers((List)this.currencyPromp.getData()));
        params.addCustomerParam("START_YEAR", "" + this.startYearSpin.getValue());
        params.addCustomerParam("START_PERIOD", "" + this.startPeriodSpin.getValue());
        params.addCustomerParam("END_YEAR", "" + this.endYearSpin.getValue());
        params.addCustomerParam("END_PERIOD", "" + this.endPeriodSpin.getValue());
        return params;
    }

    public void setCustomerParams(CustomerParams params) {
        String p = null;
        try {
            RptPeriodTypeEnum periodTypeEnum = RptPeriodTypeEnum.getEnum((int)params.getInt("PERIODTYPECOMBO"));
            if (periodTypeEnum != null) {
                this.periodTypeCombo.setSelectedItem((Object)periodTypeEnum);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error on Analysis", (Throwable)e);
        }
        try {
            p = params.getCustomerParam("START_YEAR");
            this.startYearSpin.setValue((Object)new Integer(p.toString()));
        }
        catch (Exception e) {
            logger.error((Object)"Error on Analysis", (Throwable)e);
        }
        try {
            p = params.getCustomerParam("START_PERIOD");
            this.startPeriodSpin.setValue((Object)new Integer(p.toString()));
        }
        catch (Exception e) {
            logger.error((Object)"Error on Analysis", (Throwable)e);
        }
        try {
            p = params.getCustomerParam("END_YEAR");
            this.endYearSpin.setValue((Object)new Integer(p.toString()));
        }
        catch (Exception e) {
            logger.error((Object)"Error on Analysis", (Throwable)e);
        }
        try {
            p = params.getCustomerParam("END_PERIOD");
            this.endPeriodSpin.setValue((Object)new Integer(p.toString()));
        }
        catch (Exception e) {
            logger.error((Object)"Error on Analysis", (Throwable)e);
        }
        try {
            int endYear = Integer.parseInt(params.getCustomerParam("END_YEAR"));
            int endPeriod = Integer.parseInt(params.getCustomerParam("END_PERIOD"));
            RptPeriodTypeEnum periodType = RptPeriodTypeEnum.getEnum((int)params.getInt("PERIODTYPECOMBO"));
            if (periodType == null) {
                periodType = (RptPeriodTypeEnum)this.periodTypeCombo.getSelectedItem();
            }
            List rptYearAndPeriodAndDate = RPTDateUtil.getRptYearAndPeriodAndDate(endYear, endPeriod, periodType);
            Date rptDate = (Date)rptYearAndPeriodAndDate.get(rptYearAndPeriodAndDate.size() - 1);
            OrgTreeCollection otc = CslRptUIUtil.getOrgTreeCollection(rptDate);
            this.orgTreeCombo.removeAllItems();
            this.orgTreeCombo.addItems(otc.toArray());
            this.selectComboboxObject(this.orgTreeCombo, (IObjectValue)OrgTreeFactory.getRemoteInstance().getOrgTreeInfo((IObjectPK)new ObjectUuidPK(params.getCustomerParam("ORG_TREE_ID"))));
        }
        catch (Exception e) {
            logger.error((Object)"Error on Analysis", (Throwable)e);
        }
        try {
            p = params.getCustomerParam("FETCH_TYPE");
            this.fetchTypePromp.setData((Object)RptBiUtil.findFetchTypes(Arrays.asList(p.split(","))));
        }
        catch (Exception e) {
            logger.error((Object)"Error on Analysis", (Throwable)e);
        }
        try {
            p = params.getCustomerParam("ITEMS");
            this.itemPromp.setData((Object)RptBiUtil.getRptItemCollection(Arrays.asList(p.split(","))));
        }
        catch (Exception e) {
            logger.error((Object)"Error on Analysis", (Throwable)e);
        }
        try {
            String showOrgSum = params.getCustomerParam("SHOW_ORG_SUM");
            String showPeriodSum = params.getCustomerParam("SHOW_PERIOD_SUM");
            String displayElimData = params.getCustomerParam("DISPLAY_ELIM_DATA");
            if (showOrgSum != null) {
                this.showOrgSumChk.setSelected(RptUtil.isTrue((Object)showOrgSum));
            }
            if (showPeriodSum != null) {
                this.showPeriodSumChk.setSelected(RptUtil.isTrue((Object)showPeriodSum));
            }
            if (displayElimData != null) {
                this.chkDisplayElimData.setSelected(RptUtil.isTrue((Object)displayElimData));
            }
            this.dataTypePromp.setData((Object)this.getDataTypes(params.getCustomerParam("DATA_TYPE")));
        }
        catch (Exception e) {
            logger.error((Object)"Error on Analysis", (Throwable)e);
        }
        try {
            CslDataSrcTypeEnum eee = CslDataSrcTypeEnum.getEnum(params.getInt("DATA_SRC_TYPE"));
            if (eee != null) {
                this.dataSourceCombo.setSelectedItem((Object)eee);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error on Analysis", (Throwable)e);
        }
        try {
            this.adjustPromp.setData((Object)this.getAdjustEnums(params.getCustomerParam("ADJUST")));
        }
        catch (Exception e) {
            logger.error((Object)"Error on Analysis", (Throwable)e);
        }
        try {
            this.currencyPromp.setData((Object)this.getValuesByNumber(params.getCustomerParam("CURRENCY_ID"), (ICoreBase)CurrencyFactory.getRemoteInstance()));
        }
        catch (Exception e) {
            logger.error((Object)"Error on Analysis", (Throwable)e);
        }
        try {
            this.orgPromp.setData((Object)this.getValuesByID(params.getCustomerParam("ORGS"), (ICoreBase)FullOrgUnitFactory.getRemoteInstance()));
        }
        catch (Exception e) {
            logger.error((Object)"Error on Analysis", (Throwable)e);
        }
    }

    private void selectComboboxObject(KDComboBox box, IObjectValue value) {
        if (value == null) {
            return;
        }
        this.treeidLast = ((OrgTreeInfo)value).getNumber();
        Object object2 = value.get("id");
        if (object2 == null) {
            return;
        }
        int itemCount = box.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            Object object;
            IObjectValue o = (IObjectValue)box.getItemAt(i);
            if (o == null || (object = o.get("id")) == null || !object.equals(object2)) continue;
            box.setSelectedIndex(i);
            break;
        }
    }

    private List getDataTypes(String value) {
        ArrayList<ValueTypeEnum> l = new ArrayList<ValueTypeEnum>();
        String[] split = value.split(",");
        for (int i = 0; i < split.length; ++i) {
            if (StringUtils.isEmpty((String)split[i])) continue;
            l.add(ValueTypeEnum.getEnum(Integer.parseInt(split[i])));
        }
        return l;
    }

    private List getAdjustEnums(String value) {
        ArrayList<AnalysisAdjustEnum> l = new ArrayList<AnalysisAdjustEnum>();
        String[] split = value.split(",");
        for (int i = 0; i < split.length; ++i) {
            if (StringUtils.isEmpty((String)split[i])) continue;
            l.add(AnalysisAdjustEnum.getEnum(Integer.parseInt(split[i])));
        }
        return l;
    }

    private List getValuesByID(String numbers, ICoreBase api) throws Exception {
        String[] split = numbers.split(",");
        StringBuffer oql = new StringBuffer();
        oql.append("select id, name, number,isUnion where id in (");
        boolean comma = false;
        for (int i = 0; i < split.length; ++i) {
            if (StringUtils.isEmpty((String)split[i])) continue;
            if (comma) {
                oql.append(',');
            } else {
                comma = true;
            }
            oql.append('\'');
            oql.append(split[i]);
            oql.append('\'');
        }
        oql.append(")");
        CoreBaseCollection coll = api.getCollection(oql.toString());
        if (coll.size() < 1) {
            return null;
        }
        ArrayList<Object> rs = new ArrayList<Object>(split.length);
        for (int i = 0; i < split.length; ++i) {
            Object findInfoBy;
            if (StringUtils.isEmpty((String)split[i]) || (findInfoBy = RptBiUtil.findInfoBy("id", split[i], (IObjectCollection)coll)) == null) continue;
            rs.add(findInfoBy);
        }
        return rs.size() < 1 ? null : rs;
    }

    private List getValuesByNumber(String numbers, ICoreBase api) throws Exception {
        String[] split = numbers.split(",");
        StringBuffer oql = new StringBuffer();
        oql.append("select id, name, number where number in (");
        for (int i = 0; i < split.length; ++i) {
            if (i != 0) {
                oql.append(',');
            }
            oql.append('\'');
            oql.append(split[i]);
            oql.append('\'');
        }
        oql.append(")");
        CoreBaseCollection coll = api.getCollection(oql.toString());
        if (coll.size() < 1) {
            return null;
        }
        ArrayList<Object> rs = new ArrayList<Object>(split.length);
        for (int i = 0; i < split.length; ++i) {
            Object findInfoBy;
            if (StringUtils.isEmpty((String)split[i]) || (findInfoBy = RptBiUtil.findInfoBy("number", split[i], (IObjectCollection)coll)) == null) continue;
            rs.add(findInfoBy);
        }
        return rs.size() < 1 ? null : rs;
    }

    private String getCollectionIDs(List l) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; l != null && i < l.size(); ++i) {
            CoreBaseInfo info = (CoreBaseInfo)l.get(i);
            sb.append(',').append(info.get("id"));
        }
        return sb.length() < 1 ? null : sb.toString();
    }

    private String getCollectionNumbers(List l) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; l != null && i < l.size(); ++i) {
            CoreBaseInfo info = (CoreBaseInfo)l.get(i);
            sb.append(',').append(info.get("number"));
        }
        return sb.length() < 1 ? null : sb.toString();
    }

    private String getEnumValues(List l) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; l != null && i < l.size(); ++i) {
            IntEnum info = (IntEnum)l.get(i);
            sb.append(',').append(info.getValue());
        }
        return sb.length() < 1 ? null : sb.toString();
    }

    public RptParams getCustomCondition() {
        RptParams params = new RptParams();
        Integer startyear = (Integer)this.startYearSpin.getValue();
        Integer endyear = (Integer)this.endYearSpin.getValue();
        Integer startPeriod = (Integer)this.startPeriodSpin.getValue();
        Integer endperiod = (Integer)this.endPeriodSpin.getValue();
        Integer swap = new Integer(-1);
        if (startyear > endyear) {
            swap = endyear;
            endyear = startyear;
            startyear = swap;
            swap = endperiod;
            endperiod = startPeriod;
            startPeriod = swap;
        } else if (startyear.intValue() == endyear.intValue() && startPeriod > endperiod) {
            swap = endyear;
            endyear = startyear;
            startyear = swap;
            swap = endperiod;
            endperiod = startPeriod;
            startPeriod = swap;
        }
        params.setObject("START_YEAR", (Object)startyear);
        params.setObject("END_YEAR", (Object)endyear);
        params.setObject("START_PERIOD", (Object)startPeriod);
        params.setObject("END_PERIOD", (Object)endperiod);
        params.setInt("PERIOD_TYPE", ((RptPeriodTypeEnum)this.periodTypeCombo.getSelectedItem()).getValue());
        params.setObject("FETCH_TYPE", this.fetchTypePromp.getData());
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.orgTreeCombo.getSelectedItem();
        params.setObject("ORG_TREE_ID", (Object)orgTreeInfo.getId().toString());
        params.setObject("ORG_TREE_Number", (Object)orgTreeInfo.getNumber());
        params.setObject("ORGS", this.orgPromp.getData());
        params.setObject("ITEMS", this.itemPromp.getData());
        params.setBoolean("SHOW_ORG_SUM", this.showOrgSumChk.isSelected());
        params.setBoolean("SHOW_PERIOD_SUM", this.showPeriodSumChk.isSelected());
        params.setBoolean("DISPLAY_ELIM_DATA", this.chkDisplayElimData.isSelected());
        params.setObject("DATA_TYPE", this.dataTypePromp.getData());
        params.setInt("DATA_SRC_TYPE", ((CslDataSrcTypeEnum)((Object)this.dataSourceCombo.getSelectedItem())).getValue());
        params.setObject("ADJUST", this.adjustPromp.getData());
        params.setObject("CURRENCY", this.currencyPromp.getData());
        params.setBoolean("INDEPENDENT_ANALYSIS", true);
        try {
            this.getUIContext().put("periodCollection", FiscalPeriodHelper.getPeriodCollection(null, orgTreeInfo));
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        params.setObject("periodCollection", this.getUIContext().get("periodCollection"));
        params.setObject("isMergeByFiscalPeriod", (Object)this.isMergeByFiscalPeriod);
        return params;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
    }

    public void clear() {
        if (RptPeriodTypeEnum.MONTHLY.equals(this.periodTypeCombo.getSelectedItem())) {
            int[] period = this.getLastPeriod(RptPeriodTypeEnum.MONTHLY);
            this.startYearSpin.setValue((Object)new Integer(period[0]));
            this.endYearSpin.setValue((Object)new Integer(period[0]));
            this.startPeriodSpin.setValue((Object)new Integer(period[1]));
            this.endPeriodSpin.setValue((Object)new Integer(period[1]));
        } else {
            this.periodTypeCombo.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        }
        this.fetchTypePromp.setData(null);
        if (this.orgTreeCombo.getItemCount() > 0) {
            this.orgTreeCombo.setSelectedIndex(0);
        }
        this.orgPromp.setData(null);
        this.itemPromp.setData(null);
        this.showOrgSumChk.setSelected(false);
        this.showPeriodSumChk.setSelected(false);
        this.chkDisplayElimData.setSelected(false);
        this.dataTypePromp.setData(Arrays.asList(new Object[]{ValueTypeEnum.MONEY}));
        this.adjustPromp.setData(Arrays.asList(new Object[]{AnalysisAdjustEnum.ADJUSTED}));
        if (this.dataSourceCombo.getItemCount() > 0) {
            this.dataSourceCombo.setSelectedIndex(0);
        }
        try {
            CurrencyInfo cui = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency().getId()));
            this.currencyPromp.setData(Arrays.asList(cui));
        }
        catch (Exception e) {
            logger.debug((Object)"", (Throwable)e);
        }
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public void setCustomCondition(RptParams params) {
    }

    public boolean verify() {
        if (this.orgTreeCombo.getSelectedItem() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"50_ItemAnalysisFilterUI"));
            return false;
        }
        if (this.orgPromp.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"51_ItemAnalysisFilterUI"));
            return false;
        }
        if (this.itemPromp.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"52_ItemAnalysisFilterUI"));
            return false;
        }
        if (this.fetchTypePromp.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"53_ItemAnalysisFilterUI"));
            return false;
        }
        if (this.currencyPromp.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"54_ItemAnalysisFilterUI"));
            return false;
        }
        if (this.dataTypePromp.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"55_ItemAnalysisFilterUI"));
            return false;
        }
        if (this.dataSourceCombo.getSelectedItem() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"56_ItemAnalysisFilterUI"));
            return false;
        }
        if (this.adjustPromp.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"57_ItemAnalysisFilterUI"));
            return false;
        }
        int startYear = (Integer)this.startYearSpin.getValue();
        int endYear = (Integer)this.endYearSpin.getValue();
        int startPeriod = (Integer)this.startPeriodSpin.getValue();
        int endPeriod = (Integer)this.endPeriodSpin.getValue();
        if (startYear == endYear && endPeriod < startPeriod || endYear < startYear) {
            MsgBox.showError((Component)((Object)this), (String)RptBiUtil.getString("endPeriodLessStart"));
            return false;
        }
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.periodTypeCombo.getSelectedItem();
        if (RptPeriodTypeEnum.DAILY.equals((Object)periodType)) {
            Date startDate = RPTDateUtil.getPeriodLastDate(startYear, startPeriod, periodType);
            Date endDate = RPTDateUtil.getPeriodLastDate(endYear, endPeriod, periodType);
            long dates = (endDate.getTime() - startDate.getTime()) / 86400000L;
            if (dates > 366L) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"great366dates"));
                return false;
            }
        }
        return true;
    }

    private class OrgTreeItemListener
    implements ItemListener {
        private OrgTreeItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                String treeidNew = "";
                if (ItemAnalysisFilterUI.this.orgTreeCombo.getSelectedItem() != null) {
                    treeidNew = ((OrgTreeInfo)ItemAnalysisFilterUI.this.orgTreeCombo.getSelectedItem()).getNumber();
                    if (!treeidNew.equals(ItemAnalysisFilterUI.this.treeidLast)) {
                        ItemAnalysisFilterUI.this.orgPromp.setData(null);
                    }
                } else {
                    ItemAnalysisFilterUI.this.orgPromp.setData(null);
                }
            }
        }
    }

    private class CurrencyProvider
    implements IChooserContentProvider {
        private List content = null;

        private CurrencyProvider() {
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            CurrencyInfo info1 = (CurrencyInfo)obj1;
            CurrencyInfo info2 = (CurrencyInfo)obj2;
            return info1.getId().equals((Object)info2.getId()) ? 0 : 1;
        }

        @Override
        public boolean enableFilter() {
            return false;
        }

        @Override
        public List getContents() throws Exception {
            CurrencyCollection col = CurrencyFactory.getRemoteInstance().getCurrencyCollection("where number != 'GLC' and number !='GRC')");
            if (this.content == null) {
                this.content = Arrays.asList(col.toArray());
            }
            return this.content;
        }

        @Override
        public List getSelected() {
            return (List)ItemAnalysisFilterUI.this.currencyPromp.getData();
        }

        @Override
        public boolean matchFilter(Object item, int column, String filterString) {
            return false;
        }

        @Override
        public void setContents(ArrayList content) {
            this.content = content;
        }

        @Override
        public boolean enableTemplateFilter() {
            return false;
        }
    }

    private class CurrencyLabelProvider
    implements IChooserLabelProvider {
        private String[] header = new String[]{EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"47_FetchTypeLabelProvider"), EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"40_EnumChooserLabelProvider")};

        private CurrencyLabelProvider() {
        }

        @Override
        public String getColumnText(Object obj, int i) {
            CurrencyInfo info = (CurrencyInfo)obj;
            switch (i) {
                case 0: {
                    return info.getNumber();
                }
                case 1: {
                    return info.getName();
                }
            }
            return null;
        }

        @Override
        public String[] getHeaderText() {
            return this.header;
        }
    }
}

