/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.bi.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.gr.bi.client.IChooserContentProvider;
import com.kingdee.eas.fi.gr.bi.util.RptBiUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassInfo;
import java.util.ArrayList;
import java.util.List;

public abstract class ItemContentProvider
implements IChooserContentProvider {
    private ArrayList contents;
    private final boolean includeFreezed;

    public String getCompanyId() {
        return null;
    }

    public ItemContentProvider() {
        this.includeFreezed = true;
    }

    public ItemContentProvider(boolean bIncludeFreezed) {
        this.includeFreezed = bIncludeFreezed;
    }

    @Override
    public int compare(Object obj1, Object obj2) {
        RPTItemInfo info1 = (RPTItemInfo)obj1;
        RPTItemInfo info2 = (RPTItemInfo)obj2;
        return info1.getId().equals((Object)info2.getId()) ? 0 : 1;
    }

    @Override
    public List getContents() throws Exception {
        if (this.contents == null) {
            try {
                this.contents = this.loadContents();
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
        }
        return this.contents;
    }

    private ArrayList loadContents() throws BOSException {
        this.contents = RptBiUtil.getRptItemCollection(null, this.getCompanyId(), this.includeFreezed);
        return this.contents;
    }

    @Override
    public abstract List getSelected();

    @Override
    public boolean enableFilter() {
        return true;
    }

    @Override
    public boolean matchFilter(Object item, int column, String filterString) {
        RPTItemInfo info = (RPTItemInfo)item;
        switch (column) {
            case 0: {
                return info.getNumber().indexOf(filterString) > -1;
            }
            case 1: {
                return info.getName().indexOf(filterString) > -1;
            }
            case 2: {
                ReportClassInfo type = info.getReportClass();
                if (type == null || type.getName() == null) {
                    return false;
                }
                return type.getName().indexOf(filterString) > -1;
            }
        }
        return false;
    }

    @Override
    public void setContents(ArrayList contents) {
        this.contents = contents;
    }

    @Override
    public boolean enableTemplateFilter() {
        return true;
    }
}

