/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.bi.client;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.facade.rangesel.RangeSelector;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.fi.gr.bi.client.AbstractRptCellAnalysisFilterUI;
import com.kingdee.eas.fi.gr.bi.client.OrgUnitTreeSelector;
import com.kingdee.eas.fi.gr.bi.client.RptCellAnalysisMainUI;
import com.kingdee.eas.fi.gr.bi.client.RptCellAnalysisSolutionUI;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptProcessUI;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.rpt.CompanyF7Helper;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.excelformula.util.CellReferenceHelper;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class RptCellAnalysisFilterUI
extends AbstractRptCellAnalysisFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptCellAnalysisFilterUI.class);
    private RangeSelector rowTitleRangeSelector;
    private RangeSelector colTitleRangeSelector;
    private RangeSelector rangeSelector;
    private SpreadManager spreadManager;
    private IBookProvider bookprovider;
    private String analysisSheetName;
    private List sheetNameList;
    private boolean isNormalReport = false;
    private String tree_id = null;

    public String getTreeId() {
        return this.tree_id;
    }

    void setSpreadManager(SpreadManager sm) {
        this.spreadManager = sm;
    }

    public boolean isNormalReport() {
        return this.isNormalReport;
    }

    @Override
    protected String getMainUIName() {
        return RptCellAnalysisMainUI.class.getName();
    }

    @Override
    public void onLoad() throws Exception {
        Book book;
        Sheet sheet;
        Range range;
        super.onLoad();
        this.spreadManager = (SpreadManager)this.getUIContext().get("SPREAD_MANAGER");
        this.bookprovider = (IBookProvider)this.getUIContext().get("BOOK_PROVIDER");
        this.getSheetsName();
        ReportBaseInfo info = (ReportBaseInfo)this.bookprovider.getEditValue();
        if (info instanceof ReportInfo || info.getSourceType() == RptSrcTypeEnum.NORMAL || info.getSourceType() == RptSrcTypeEnum.COMMITREPORT || info.getSourceType() == RptSrcTypeEnum.DYNAMICNORMALREPORT) {
            if (info instanceof CslReportInfo) {
                CslReportInfo csl = (CslReportInfo)info;
                if (csl.isIsCommitReport() && !(this.getUIContext().get("Owner") instanceof GroupRptProcessUI)) {
                    this.isNormalReport = true;
                }
            } else {
                this.isNormalReport = true;
            }
        }
        this.createControl(this.spreadManager);
        if (!this.isOpenOnMainui() && !(range = (sheet = (book = this.spreadManager.getSpreadContainer().getBook()).getActiveSheet()).getSelectionRange()).isSingleCell()) {
            int topRow = Integer.MAX_VALUE;
            int leftCol = Integer.MAX_VALUE;
            int bottomRow = Integer.MIN_VALUE;
            int rightCol = Integer.MIN_VALUE;
            for (int i = 0; i < range.size(); ++i) {
                CellBlock cell = range.getBlock(i);
                if (cell.getCol2() > rightCol) {
                    rightCol = cell.getCol2();
                }
                if (cell.getRow2() > bottomRow) {
                    bottomRow = cell.getRow2();
                }
                if (cell.getCol() < leftCol) {
                    leftCol = cell.getCol();
                }
                if (cell.getRow() >= topRow) continue;
                topRow = cell.getRow();
            }
            if (topRow != bottomRow && leftCol != rightCol) {
                Range colRange = sheet.getColRange(leftCol, leftCol);
                Range rowRange = sheet.getRowRange(topRow, topRow);
                ((KDTextField)this.rowTitleRangeSelector.getComponent(0)).setText(sheet.getSheetName() + "!" + CellReferenceHelper.xy2Area((int)-1, (int)leftCol, (int)-1, (int)leftCol));
                ((KDTextField)this.colTitleRangeSelector.getComponent(0)).setText(sheet.getSheetName() + "!" + CellReferenceHelper.xy2Area((int)topRow, (int)-1, (int)topRow, (int)-1));
                SumcalcRange s = new SumcalcRange(range.getName());
                s.removeRange(colRange);
                s.removeRange(rowRange);
                String serialString = s.toSerialString();
                if (!StringUtils.isEmpty((String)serialString)) {
                    ((KDTextField)this.rangeSelector.getComponent(0)).setText(sheet.getSheetName() + "!" + serialString);
                }
            }
        }
        this.orgF7.setEditable(false);
    }

    private void setRangeSelectorValue(RangeSelector rangeSelector, PropertyChangeEvent evt) {
        if ("RangeSelected".equals(evt.getPropertyName())) {
            String rangeText = (String)evt.getNewValue();
            this.getActiveSheetName();
            String badSheetName = "'" + this.analysisSheetName + "'";
            if (rangeText.indexOf(badSheetName) > -1) {
                rangeSelector.setText(this.analysisSheetName + rangeText.substring(badSheetName.length()));
            }
        }
    }

    private void createControl(SpreadManager sm) throws ReportException {
        this.rowTitleRangeSelector = sm.createRangeSelector(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"64_RptCellAnalysisFilterUI"));
        this.rowTitleRangeSelector.setSelectMode(2);
        ((KDTextField)this.rowTitleRangeSelector.getComponent(0)).setRequired(true);
        this.rowTitleRangeSelector.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RptCellAnalysisFilterUI.this.setRangeSelectorValue(RptCellAnalysisFilterUI.this.rowTitleRangeSelector, evt);
            }
        });
        this.colTitleRangeSelector = sm.createRangeSelector(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"65_RptCellAnalysisFilterUI"));
        this.colTitleRangeSelector.setSelectMode(1);
        ((KDTextField)this.colTitleRangeSelector.getComponent(0)).setRequired(true);
        this.colTitleRangeSelector.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RptCellAnalysisFilterUI.this.setRangeSelectorValue(RptCellAnalysisFilterUI.this.colTitleRangeSelector, evt);
            }
        });
        this.rangeSelector = sm.createRangeSelector(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"66_RptCellAnalysisFilterUI"));
        ((KDTextField)this.rangeSelector.getComponent(0)).setRequired(true);
        this.rangeSelector.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RptCellAnalysisFilterUI.this.setRangeSelectorValue(RptCellAnalysisFilterUI.this.rangeSelector, evt);
            }
        });
        ReportBaseInfo info = (ReportBaseInfo)this.bookprovider.getEditValue();
        if (info.getTemplate().getTemplateType() == RptTmpTypeEnum.COMMONREPORT || info.getTemplate().getTemplateType() == RptTmpTypeEnum.COMMONPUBLICTEMPLATE) {
            this.orgF7.setEnabled(false);
        }
        if (this.isNormalReport) {
            this.tree_id = null;
            OrgType orgType = RptNewUIUtil.getOrgTypeOnContext((Map)this.getUIContext());
            CompanyF7Helper.MultiOrgViewTypeUnitF7 f7 = new CompanyF7Helper.MultiOrgViewTypeUnitF7((IUIObject)this, orgType){

                public Object getData() {
                    Object data = super.getData();
                    if (data instanceof Object[]) {
                        return Arrays.asList((Object[])data);
                    }
                    return super.getData();
                }
            };
            f7.setMultiSelect(true);
            HashSet<String> orgIds = new HashSet<String>();
            orgIds.add(info.getCompany().getId().toString());
            f7.setSelectedOrgIds(orgIds);
            this.orgF7.setSelector((KDPromptSelector)f7);
            this.orgF7.setData(Arrays.asList(info.getCompany()));
            this.orgF7.addSelectorListener(new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    HashSet<String> orgSet = new HashSet<String>();
                    List orgs = (List)RptCellAnalysisFilterUI.this.orgF7.getData();
                    if (orgs == null) {
                        return;
                    }
                    for (OrgUnitInfo info : orgs) {
                        orgSet.add(info.getId().toString());
                    }
                    ((NewCompanyF7)RptCellAnalysisFilterUI.this.orgF7.getSelector()).refresh();
                    ((NewCompanyF7)RptCellAnalysisFilterUI.this.orgF7.getSelector()).setSelectedOrgIds(orgSet);
                }
            });
        } else {
            try {
                if (CSLContextHelper.getCSLContext().getCurOrgBound() == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"78_RptCellAnalysisFilterUI"));
                    SysUtil.abort();
                }
                ReportBaseInfo report = (ReportBaseInfo)this.bookprovider.getEditValue();
                OrgTreeInfo tree = CSLContextHelper.getCSLContext().getCurOrgBound();
                OrgUnitInfo org = CSLContextHelper.getCSLContext().getCurOrgGroup();
                String string = this.tree_id = report.getOrgTree() == null ? tree.getId().toString() : report.getOrgTree().getId().toString();
                if (info instanceof CslReportInfo) {
                    CslReportInfo csl = (CslReportInfo)info;
                    this.orgF7.setData(Arrays.asList(csl.getOrgUnit()));
                    if (tree == null) {
                        tree = csl.getOrgTree();
                        org = csl.getOrgUnit();
                    }
                } else {
                    this.orgF7.setData(Arrays.asList(org));
                }
                this.orgF7.setSelector((KDPromptSelector)new OrgUnitTreeSelector((IUIObject)this, this.orgF7, tree, org));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        this.setSpineRange(this.startYearSpin, 1901, 2099);
        this.setSpineRange(this.endYearSpin, 1901, 2099);
        RptPeriodTypeEnum periodType = info.getPeriodType();
        Integer year = new Integer(info.getYear());
        if (FiscalPeriodHelper.isMergeByFiscalPeriod(this.isMergeByFiscalPeriod, periodType)) {
            FiscalPeriodHelper.setSpineRangeByPeriodType(this.startPeriodSpin, periodType);
            FiscalPeriodHelper.setSpineRangeByPeriodType(this.endPeriodSpin, periodType);
        } else {
            this.setPeriodRange(this.startPeriodSpin, periodType.getValue(), year);
            this.setPeriodRange(this.endPeriodSpin, periodType.getValue(), year);
            if (RptPeriodTypeEnum.MONTHLY == info.getPeriodType() && info.getPeriod() > 12 && !CslRptUtil.isSupport13Period(null)) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"2_RptCellAnalysisFilterUI");
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{MessageFormat.format(msg, info.getPeriod())});
            }
        }
        this.startYearSpin.setValue((Object)year);
        this.endYearSpin.setValue((Object)year);
        Integer period = new Integer(info.getPeriod());
        this.startPeriodSpin.setValue((Object)period);
        this.endPeriodSpin.setValue((Object)period);
        this.lineLabel.setBoundEditor((JComponent)this.rowTitleRangeSelector);
        this.colLabel.setBoundEditor((JComponent)this.colTitleRangeSelector);
        this.rangeLabel.setBoundEditor((JComponent)this.rangeSelector);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public RptParams getCustomCondition() {
        RptParams params = new RptParams();
        Integer startyear = (Integer)this.startYearSpin.getValue();
        Integer endyear = (Integer)this.endYearSpin.getValue();
        Integer startPeriod = (Integer)this.startPeriodSpin.getValue();
        Integer endperiod = (Integer)this.endPeriodSpin.getValue();
        if (this.getParent().getParent() instanceof RptCellAnalysisSolutionUI) {
            int selectedIndex = ((RptCellAnalysisSolutionUI)((Object)this.getParent().getParent())).list.getSelectedIndex();
            params.setObject("selectedIndex", (Object)new Integer(selectedIndex));
        }
        Integer swap = new Integer(-1);
        if (startyear > endyear) {
            swap = endyear;
            endyear = startyear;
            startyear = swap;
            swap = endperiod;
            endperiod = startPeriod;
            startPeriod = swap;
        } else if (startyear.intValue() == endyear.intValue() && startPeriod > endperiod) {
            swap = endyear;
            endyear = startyear;
            startyear = swap;
            swap = endperiod;
            endperiod = startPeriod;
            startPeriod = swap;
        }
        params.setObject("START_YEAR", (Object)startyear);
        params.setObject("END_YEAR", (Object)endyear);
        params.setObject("START_PERIOD", (Object)startPeriod);
        params.setObject("END_PERIOD", (Object)endperiod);
        params.setObject("ORGS", this.orgF7.getValue());
        params.setObject("ROW_RANGE", (Object)this.rowTitleRangeSelector.getText());
        params.setObject("COL_RANGE", (Object)this.colTitleRangeSelector.getText());
        this.getActiveSheetName();
        List rowTitle = this.getRowTitle();
        List colTitle = this.getColTitle();
        params.setObject("ROW_TITLES", (Object)rowTitle);
        params.setObject("COL_TITLES", (Object)colTitle);
        try {
            params.setObject("RANGES", (Object)this.getAnalysisRange().toSerialString());
            params.setObject("RANGES_TEXT", (Object)this.rangeSelector.getText());
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        params.setObject("SHEET_NAME", (Object)this.analysisSheetName);
        ReportBaseInfo info = (ReportBaseInfo)this.bookprovider.getEditValue();
        params.setObject("TEMPLATE_ID", (Object)info.getTemplate().getId().toString());
        params.setString("CURRENCY_NUMBER", info.getCurrency().getNumber());
        if (info instanceof CslReportInfo) {
            params.setString("SRC_CURRENCY_NUMBER", ((CslReportInfo)info).getSourceCurrency().getNumber());
            params.setBoolean("IS_CSL_REPORT", true);
            params.setString("KEY_DATACOLLECT_NUMBER", ((CslReportInfo)info).getDataCollectNumber());
            if (!this.isNormalReport && info.getOrgTree() == null) {
                try {
                    params.setString("ORG_TREE_ID", CSLContextHelper.getCSLContext().getCurOrgBound().getId().toString());
                }
                catch (Exception exception) {}
            }
        } else {
            params.setBoolean("IS_CSL_REPORT", false);
            params.setString("KEY_DATACOLLECT_NUMBER", ((ReportInfo)info).getDataCollectNumber());
            if (((ReportInfo)info).getSourceCurrency() != null) {
                params.setString("SRC_CURRENCY_NUMBER", ((ReportInfo)info).getSourceCurrency().getNumber());
            }
        }
        params.setInt("REPORT_TYPE", info.getSourceType().getValue());
        if (info.getOrgTree() != null) {
            params.setString("ORG_TREE_ID", info.getOrgTree().getId().toString());
        }
        params.setString("REPORT_ID", info.getId().toString());
        params.setBoolean("SHOW_ORG_SUM", this.chkShowOrg.isSelected());
        params.setBoolean("SHOW_PERIOD_SUM", this.chkShowPeriod.isSelected());
        params.setBoolean("IS_NORMAL_REPORT", this.isNormalReport);
        params.setObject("periodCollection", this.getUIContext().get("periodCollection"));
        params.setObject("isMergeByFiscalPeriod", (Object)this.isMergeByFiscalPeriod);
        params.setObject("orgType", (Object)RptNewUIUtil.getOrgTypeOnContext((Map)this.getUIContext()));
        this.rangeSelector.getSelection();
        return params;
    }

    private boolean isIntersect() {
        int i;
        SumcalcRange rowtitle = this.getRange(this.rowTitleRangeSelector.getText());
        SumcalcRange coltitle = this.getRange(this.colTitleRangeSelector.getText());
        SumcalcRange ranges = new SumcalcRange(this.rangeSelector.getText());
        for (i = 0; i < rowtitle.size(); ++i) {
            if (!ranges.isIntersect(rowtitle.getCellBlock(i))) continue;
            return true;
        }
        for (i = 0; i < coltitle.size(); ++i) {
            if (!ranges.isIntersect(coltitle.getCellBlock(i))) continue;
            return true;
        }
        return false;
    }

    private void getSheetsName() {
        Book book = this.spreadManager.getSpreadContainer().getBook();
        this.sheetNameList = new ArrayList();
        int count = book.getSheetCount();
        for (int i = 0; i < count; ++i) {
            Sheet sheet = book.getSheet(i);
            this.sheetNameList.add(sheet.getSheetName());
        }
        this.analysisSheetName = book.getActiveSheet().getSheetName();
    }

    private void getActiveSheetName() {
        Book book = this.spreadManager.getSpreadContainer().getBook();
        this.analysisSheetName = book.getActiveSheet().getSheetName();
    }

    private List getRowTitle() {
        Book book = this.spreadManager.getSpreadContainer().getBook();
        String cellRef = this.rowTitleRangeSelector.getText();
        TreeMap<Integer, String> names = new TreeMap<Integer, String>();
        try {
            CellBlock ref = this.getRef(cellRef);
            if (ref == null) {
                return null;
            }
            SumcalcRange blocks = this.getAnalysisRange();
            for (int col = ref.getCol(); col <= ref.getCol2(); ++col) {
                for (int i = 0; i < blocks.size(); ++i) {
                    CellBlock block = blocks.getCellBlock(i);
                    for (int j = block.getRow(); j <= block.getRow2(); ++j) {
                        Integer key = new Integer(j);
                        String object = (String)names.get(key);
                        Variant value = this.getCellValue(book.getSheetByName(this.analysisSheetName), j, col);
                        String string = " ";
                        if (value != Variant.nullVariant && !value.isNull()) {
                            string = value.toString();
                        } else if (object == null) {
                            object = string;
                        }
                        if (!StringUtils.isEmpty((String)string)) {
                            object = object != null ? object + " - " + string : string;
                        }
                        names.put(key, object);
                    }
                }
            }
            ArrayList measureName = new ArrayList();
            measureName.addAll(names.values());
            return measureName;
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    private SumcalcRange getAnalysisRange() throws SyntaxErrorException {
        SumcalcRange ranges = new SumcalcRange();
        ranges.addRange(this.rangeSelector.getText());
        Book book = this.spreadManager.getSpreadContainer().getBook();
        int maxRowIndex = book.getSheetByName(this.analysisSheetName).getMaxRowIndex();
        int maxColIndex = book.getSheetByName(this.analysisSheetName).getMaxColIndex();
        SumcalcRange blocks = new SumcalcRange();
        for (int i = 0; i < ranges.size(); ++i) {
            CellBlock bigblock = CellBlock.getNewCellBlock((int)0, (int)0, (int)maxRowIndex, (int)maxColIndex);
            CellBlock block = ranges.getCellBlock(i);
            if (block.getRow() > bigblock.getRow()) {
                bigblock.setRow(block.getRow());
            }
            if (block.getCol() > bigblock.getCol()) {
                bigblock.setCol(block.getCol());
            }
            if (block.getRow2() < bigblock.getRow2()) {
                bigblock.setRow2(block.getRow2());
            }
            if (block.getCol2() < bigblock.getCol2()) {
                bigblock.setCol2(block.getCol2());
            }
            blocks.addCellBlock(bigblock);
        }
        if (blocks.getCellBlock(0) != null && (blocks.getCellBlock(0).getCol() > blocks.getCellBlock(0).getCol2() || blocks.getCellBlock(0).getRow() > blocks.getCellBlock(0).getRow2())) {
            return ranges;
        }
        if (blocks.getCellBlock(0) != null && (blocks.getCellBlock(0).getCol() > blocks.getCellBlock(0).getCol2() || blocks.getCellBlock(0).getRow() > blocks.getCellBlock(0).getRow2())) {
            return ranges;
        }
        return blocks;
    }

    private List getColTitle() {
        Book book = this.spreadManager.getSpreadContainer().getBook();
        String cellRef = this.colTitleRangeSelector.getText();
        TreeMap<Integer, String> names = new TreeMap<Integer, String>();
        try {
            CellBlock ref = this.getRef(cellRef);
            if (ref == null) {
                return null;
            }
            SumcalcRange blocks = this.getAnalysisRange();
            for (int row = ref.getRow(); row <= ref.getRow2(); ++row) {
                for (int i = 0; i < blocks.size(); ++i) {
                    CellBlock block = blocks.getCellBlock(i);
                    for (int j = block.getCol(); j <= block.getCol2(); ++j) {
                        Integer key = new Integer(j);
                        String object = (String)names.get(key);
                        Variant value = this.getCellValue(book.getSheetByName(this.analysisSheetName), row, j);
                        String string = " ";
                        if (value != Variant.nullVariant && !value.isNull()) {
                            string = value.toString();
                        } else if (object == null) {
                            object = string;
                        }
                        if (!StringUtils.isEmpty((String)string)) {
                            object = object != null ? object + " - " + string : string;
                        }
                        names.put(key, object);
                    }
                }
            }
            ArrayList measureName = new ArrayList();
            measureName.addAll(names.values());
            return measureName;
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    private Variant getCellValue(Sheet sheet, int row, int col) {
        CellBlock mergeBlock = sheet.getMergeBlock(row, col);
        if (mergeBlock == null) {
            return sheet.getRange(row, col).getValue();
        }
        return sheet.getRange(mergeBlock).getValue();
    }

    private CellBlock getRef(String cellRef) {
        SumcalcRange range = new SumcalcRange(cellRef);
        CellBlock block = range.getCellBlock(0);
        CellBlock block2 = range.getCellBlock(range.size() - 1);
        block.setCol2(block2.getCol2());
        block.setRow2(block2.getRow2());
        return block;
    }

    @Override
    public void setInitParams(RptParams params) {
        ((KDTextField)this.rowTitleRangeSelector.getComponent(0)).setText(params.getString("ROW_RANGE"));
        ((KDTextField)this.colTitleRangeSelector.getComponent(0)).setText(params.getString("COL_RANGE"));
        ((KDTextField)this.rangeSelector.getComponent(0)).setText(params.getString("RANGES_TEXT"));
        this.orgF7.setData(params.getObject("ORGS"));
        this.startYearSpin.setValue(params.getObject("START_YEAR"));
        this.endYearSpin.setValue(params.getObject("END_YEAR"));
        this.startPeriodSpin.setValue(params.getObject("START_PERIOD"));
        this.endPeriodSpin.setValue(params.getObject("END_PERIOD"));
        this.chkShowOrg.setSelected(params.getBoolean("SHOW_ORG_SUM"));
        this.chkShowPeriod.setSelected(params.getBoolean("SHOW_PERIOD_SUM"));
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public void setCustomCondition(RptParams params) {
    }

    private boolean isRangeContinuous(SumcalcRange r, boolean isRow) {
        boolean result = true;
        CellBlock lastBlock = null;
        for (int i = 0; i < r.size(); ++i) {
            CellBlock cellBlock = r.getCellBlock(i);
            if (lastBlock == null) {
                lastBlock = cellBlock;
                continue;
            }
            if (isRow) {
                if (lastBlock.getRow2() + 1 != cellBlock.getRow()) {
                    result = false;
                    break;
                }
            } else if (lastBlock.getCol2() + 1 != cellBlock.getCol()) {
                result = false;
                break;
            }
            lastBlock = cellBlock;
        }
        return result;
    }

    public boolean verify() {
        String rowText = this.rowTitleRangeSelector.getText();
        String colText = this.colTitleRangeSelector.getText();
        String rangeText = this.rangeSelector.getText();
        if (rowText.lastIndexOf("!") < 0 || colText.lastIndexOf("!") < 0 || rangeText.lastIndexOf("!") < 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"69_RptCellAnalysisFilterUI"));
            return false;
        }
        SumcalcRange rowtitle = this.getRange(rowText);
        if (rowtitle == null) {
            return false;
        }
        SumcalcRange coltitle = this.getRange(colText);
        if (coltitle == null) {
            return false;
        }
        if (StringUtils.isEmpty((String)rowText)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"70_RptCellAnalysisFilterUI"));
            this.rowTitleRangeSelector.requestFocus();
            return false;
        }
        if (!this.isRangeContinuous(rowtitle, false)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"71_RptCellAnalysisFilterUI"));
            this.rowTitleRangeSelector.requestFocus();
            return false;
        }
        if (StringUtils.isEmpty((String)colText)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"72_RptCellAnalysisFilterUI"));
            this.colTitleRangeSelector.requestFocus();
            return false;
        }
        if (!this.isRangeContinuous(coltitle, true)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"73_RptCellAnalysisFilterUI"));
            this.colTitleRangeSelector.requestFocus();
            return false;
        }
        if (StringUtils.isEmpty((String)rangeText)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"74_RptCellAnalysisFilterUI"));
            this.rangeSelector.requestFocus();
            return false;
        }
        if (this.isIntersect()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"75_RptCellAnalysisFilterUI"));
            this.rangeSelector.requestFocus();
            return false;
        }
        String row = rowText.substring(0, rowText.lastIndexOf("!"));
        String col = colText.substring(0, colText.lastIndexOf("!"));
        String range = rangeText.substring(0, rangeText.lastIndexOf("!"));
        if (!row.equals(col) || !col.equals(range)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"76_RptCellAnalysisFilterUI"));
            return false;
        }
        boolean flag = false;
        for (int i = 0; i < this.sheetNameList.size(); ++i) {
            String sheetName = (String)this.sheetNameList.get(i);
            if (!sheetName.equals(row)) continue;
            this.analysisSheetName = sheetName;
            flag = true;
        }
        if (!flag) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"69_RptCellAnalysisFilterUI"));
            return false;
        }
        if (this.orgF7.getValue() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"77_RptCellAnalysisFilterUI"));
            this.orgF7.requestFocus();
            return false;
        }
        return true;
    }

    public IBookProvider getBookprovider() {
        return this.bookprovider;
    }
}

