/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.bi.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.facade.rangesel.RangeSelector;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.fi.gr.bi.client.AbstractRptDynaItemAnalysisFilterUI;
import com.kingdee.eas.fi.gr.bi.client.FetchTypeLabelProvider;
import com.kingdee.eas.fi.gr.bi.client.FetchTypeProvider;
import com.kingdee.eas.fi.gr.bi.client.IChooserContentProvider;
import com.kingdee.eas.fi.gr.bi.client.IChooserLabelProvider;
import com.kingdee.eas.fi.gr.bi.client.ItemContentProvider;
import com.kingdee.eas.fi.gr.bi.client.ItemLabelProvider;
import com.kingdee.eas.fi.gr.bi.client.OrgUnitTreeSelector;
import com.kingdee.eas.fi.gr.bi.client.RptDynaItemAnalysisMainUI;
import com.kingdee.eas.fi.gr.bi.client.SortableChooser;
import com.kingdee.eas.fi.gr.bi.util.DynaItemInfo;
import com.kingdee.eas.fi.gr.bi.util.RptBiUtil;
import com.kingdee.eas.fi.gr.cslrpt.AdjustStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslDataSrcTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.HisRptReceivedCollection;
import com.kingdee.eas.fi.gr.cslrpt.HisRptReceivedFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RptReceivedCollection;
import com.kingdee.eas.fi.gr.cslrpt.RptReceivedFactory;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptProcessUI;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class RptDynaItemAnalysisFilterUI
extends AbstractRptDynaItemAnalysisFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptDynaItemAnalysisFilterUI.class);
    private SpreadManager spreadManager;
    private IBookProvider bookprovider;
    private RangeSelector rangeChooser;
    private int isQueryBudget = 0;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.spreadManager = (SpreadManager)this.getUIContext().get("SPREAD_MANAGER");
        this.bookprovider = (IBookProvider)this.getUIContext().get("BOOK_PROVIDER");
        if (this.getUIContext().get("ISQUERYBUDGET") != null) {
            this.isQueryBudget = (Integer)this.getUIContext().get("ISQUERYBUDGET");
        }
        this.createControl();
        if (!this.isOpenOnMainui()) {
            ((KDTextField)this.rangeChooser.getComponent(0)).setText(this.spreadManager.getSpreadContainer().getBook().getActiveSheet().getSelectionRange().getName(true));
            this.applySelectionRange();
        }
    }

    private void applySelectionRange() {
        String text = this.rangeChooser.getText();
        if (StringUtils.isEmpty((String)text)) {
            return;
        }
        SumcalcRange ranges = this.getRange(text);
        if (ranges == null) {
            return;
        }
        ArrayList<String> items = new ArrayList<String>();
        ArrayList<String> fetch_types = new ArrayList<String>();
        ArrayList<DynaItemInfo> dyitems = new ArrayList<DynaItemInfo>();
        HashSet<ValueTypeEnum> dataType = new HashSet<ValueTypeEnum>(2);
        Sheet activeSheet = this.spreadManager.getSpreadContainer().getBook().getActiveSheet();
        ArrayList basePointList = DynamicTemplateUtility.getBasePointList((Sheet)activeSheet);
        HashMap<String, ArrayList> basePoints = new HashMap<String, ArrayList>();
        basePoints.put(activeSheet.getSheetName(), basePointList);
        for (int i = 0; i < ranges.size(); ++i) {
            CellBlock block = ranges.getCellBlock(i);
            Sheet.ICellsIterator it = activeSheet.getCellsIterator(block, false, true);
            while (it.hasNext()) {
                String dataElementNumber;
                String itemNumber;
                DynaParameters params;
                String ditemNumber;
                Cell cell = it.next();
                ItemFormula item = NewRptUtil.getItemFormula((Cell)cell, basePoints);
                if (item == null || !item.isDItem() || (ditemNumber = item.getDItemNumber()) == null || "".equals(ditemNumber)) continue;
                Point basePoint = DynamicTemplateUtility.getBasePoint((Sheet)activeSheet, (Point)new Point(cell.getCol(), cell.getRow()), (ArrayList)basePointList);
                try {
                    params = DynamicTemplateUtility.getDynaParameters((Sheet)activeSheet, (Point)basePoint);
                }
                catch (NullPointerException e) {
                    continue;
                }
                String ditemName = null;
                ditemName = params.getSpreadStyle() == 0 ? activeSheet.getRange(cell.getRow(), basePoint.x).getValue().toString() : activeSheet.getRange(basePoint.y, cell.getCol()).getValue().toString();
                DynaItemInfo values = new DynaItemInfo(StringUtils.trim((String)ditemName), ditemNumber);
                if (!dyitems.contains(values)) {
                    dyitems.add(values);
                }
                if (!items.contains(itemNumber = item.getItemNumber())) {
                    items.add(itemNumber);
                }
                if (!fetch_types.contains(dataElementNumber = item.getDataElementNumber())) {
                    fetch_types.add(dataElementNumber);
                }
                if ((e = ValueTypeEnum.getEnum(item.getValueType())) == ValueTypeEnum.TXT) continue;
                dataType.add(e);
            }
        }
        try {
            if (items.size() > 0) {
                this.itemPromp.setData((Object)RptBiUtil.getRptItemCollection(items));
                this.fetchTypePromp.setData((Object)RptBiUtil.findFetchTypes(fetch_types));
                this.dyitemPromp.setData(dyitems);
            }
            if (dataType.size() > 0) {
                this.dataTypeCombo.setData(new ArrayList(dataType));
            } else {
                this.dataTypeCombo.setData(null);
            }
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
    }

    private void createControl() throws ReportException {
        this.rangeChooser = this.spreadManager.createRangeSelector(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"79_RptDynaItemAnalysisFilterUI"));
        this.labelRange.setBoundEditor((JComponent)this.rangeChooser);
        this.setSpineRange(this.startYearSpin, 1901, 2099);
        this.setSpineRange(this.endYearSpin, 1901, 2099);
        ReportBaseInfo info = (ReportBaseInfo)this.bookprovider.getEditValue();
        Integer year = new Integer(info.getYear());
        RptPeriodTypeEnum periodType = info.getPeriodType();
        if (FiscalPeriodHelper.isMergeByFiscalPeriod(this.isMergeByFiscalPeriod, periodType)) {
            FiscalPeriodHelper.setSpineRangeByPeriodType(this.startPeriodSpin, periodType);
            FiscalPeriodHelper.setSpineRangeByPeriodType(this.endPeriodSpin, periodType);
        } else {
            this.setPeriodRange(this.startPeriodSpin, periodType.getValue(), year);
            this.setPeriodRange(this.endPeriodSpin, periodType.getValue(), year);
            if (RptPeriodTypeEnum.MONTHLY == info.getPeriodType() && info.getPeriod() > 12 && !CslRptUtil.isSupport13Period(null)) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"2_RptCellAnalysisFilterUI");
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{MessageFormat.format(msg, info.getPeriod())});
            }
        }
        this.startYearSpin.setValue((Object)year);
        this.endYearSpin.setValue((Object)year);
        Integer period = new Integer(info.getPeriod());
        this.startPeriodSpin.setValue((Object)period);
        this.endPeriodSpin.setValue((Object)period);
        boolean isNormalReport = false;
        if (info instanceof ReportInfo || info.getSourceType() == RptSrcTypeEnum.NORMAL || info.getSourceType() == RptSrcTypeEnum.COMMITREPORT || info.getSourceType() == RptSrcTypeEnum.DYNAMICNORMALREPORT) {
            if (info instanceof CslReportInfo) {
                CslReportInfo csl = (CslReportInfo)info;
                if (csl.isIsCommitReport() && !(this.getUIContext().get("Owner") instanceof GroupRptProcessUI)) {
                    isNormalReport = true;
                }
            } else {
                isNormalReport = true;
            }
        }
        if (isNormalReport) {
            NewCompanyF7 f7 = new NewCompanyF7((IUIObject)this){

                public Object getData() {
                    Object data = super.getData();
                    if (data instanceof Object[]) {
                        return Arrays.asList((Object[])data);
                    }
                    return super.getData();
                }
            };
            f7.setMultiSelect(true);
            HashSet<String> orgIds = new HashSet<String>();
            orgIds.add(info.getCompany().getId().toString());
            f7.setSelectedOrgIds(orgIds);
            this.orgsPromp.setSelector((KDPromptSelector)f7);
            this.orgsPromp.setData(Arrays.asList(info.getCompany()));
            this.srcTypeCombo.setEnabled(false);
        } else {
            try {
                OrgTreeInfo tree = CSLContextHelper.getCSLContext().getCurOrgBound();
                OrgUnitInfo org = CSLContextHelper.getCSLContext().getCurOrgGroup();
                if (info instanceof CslReportInfo) {
                    CslReportInfo csl = (CslReportInfo)info;
                    FullOrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(csl.getOrgUnit().getId().toString()));
                    this.orgsPromp.setData(Arrays.asList(orgUnitInfo));
                    if (tree == null) {
                        tree = csl.getOrgTree();
                        org = csl.getOrgUnit();
                    }
                } else {
                    this.orgsPromp.setData(Arrays.asList(org));
                }
                this.orgsPromp.setSelector((KDPromptSelector)new OrgUnitTreeSelector((IUIObject)this, this.orgsPromp, tree, org));
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        this.createDataSrcPromp(this.dataTypeCombo);
        this.srcTypeCombo.addItem((Object)CslDataSrcTypeEnum.COMBINE);
        this.srcTypeCombo.addItem((Object)CslDataSrcTypeEnum.SUMMARY);
        if (info.getSourceType() == RptSrcTypeEnum.DYNAMICSUMREPORT || info.getSourceType() == RptSrcTypeEnum.SUM) {
            this.srcTypeCombo.setSelectedItem((Object)CslDataSrcTypeEnum.SUMMARY);
        } else if (info.getSourceType() == RptSrcTypeEnum.DYNAMICCSLREPORT || info.getSourceType() == RptSrcTypeEnum.CONSOLIDATION) {
            this.srcTypeCombo.setSelectedItem((Object)CslDataSrcTypeEnum.COMBINE);
        }
        this.itemPromp.setSelector((KDPromptSelector)new SortableChooser(new ItemContentProvider(){

            @Override
            public List getSelected() {
                return (List)RptDynaItemAnalysisFilterUI.this.itemPromp.getData();
            }

            @Override
            public String getCompanyId() {
                return ((ReportBaseInfo)RptDynaItemAnalysisFilterUI.this.bookprovider.getEditValue()).getCompany().getId().toString();
            }
        }, new ItemLabelProvider(), (IUIObject)this));
        this.fetchTypePromp.setSelector((KDPromptSelector)new SortableChooser(new FetchTypeProvider(){

            @Override
            public List getSelected() {
                return (List)RptDynaItemAnalysisFilterUI.this.fetchTypePromp.getData();
            }

            @Override
            public String getCompanyId() {
                return ((ReportBaseInfo)RptDynaItemAnalysisFilterUI.this.bookprovider.getEditValue()).getCompany().getId().toString();
            }
        }, new FetchTypeLabelProvider(), (IUIObject)this));
        this.dyitemPromp.setSelector((KDPromptSelector)new SortableChooser(new IChooserContentProvider(){

            @Override
            public List getSelected() {
                return (List)RptDynaItemAnalysisFilterUI.this.dyitemPromp.getData();
            }

            @Override
            public int compare(Object obj1, Object obj2) {
                return obj1.equals(obj2) ? 0 : 1;
            }

            @Override
            public boolean enableFilter() {
                return false;
            }

            @Override
            public List getContents() throws Exception {
                return RptDynaItemAnalysisFilterUI.this.initDyitems();
            }

            @Override
            public boolean matchFilter(Object item, int column, String filterString) {
                return false;
            }

            @Override
            public void setContents(ArrayList contents) {
            }

            @Override
            public boolean enableTemplateFilter() {
                return false;
            }
        }, new IChooserLabelProvider(){
            private String[] header = new String[]{EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"80_RptDynaItemAnalysisFilterUI"), EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"81_RptDynaItemAnalysisFilterUI")};

            @Override
            public String getColumnText(Object obj, int i) {
                switch (i) {
                    case 0: {
                        return ((DynaItemInfo)obj).getDitemNumber();
                    }
                    case 1: {
                        return ((DynaItemInfo)obj).getDitemName();
                    }
                }
                return null;
            }

            @Override
            public String[] getHeaderText() {
                return this.header;
            }
        }, (IUIObject)this));
        this.applyBtn.setAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RptDynaItemAnalysisFilterUI.this.applySelectionRange();
            }
        });
        this.applyBtn.setIcon(EASResource.getIcon((String)"imgTbtn_applycondition"));
        this.adjustCombo.addItem((Object)AdjustStatusEnum.ADJUSTED);
        this.adjustCombo.addItem((Object)AdjustStatusEnum.BEFOREADJUST);
        this.itemPromp.setEditable(false);
        this.dyitemPromp.setEditable(false);
        this.orgsPromp.setEditable(false);
        this.srcTypeCombo.setEditable(false);
        this.fetchTypePromp.setEditable(false);
    }

    private List initDyitems() {
        ArrayList<DynaItemInfo> dyitems = new ArrayList<DynaItemInfo>();
        String text = this.rangeChooser.getText();
        if (StringUtils.isEmpty((String)text)) {
            return dyitems;
        }
        SumcalcRange ranges = this.getRange(text);
        if (ranges == null) {
            return dyitems;
        }
        Sheet activeSheet = this.spreadManager.getSpreadContainer().getBook().getActiveSheet();
        ArrayList basePointList = DynamicTemplateUtility.getBasePointList((Sheet)activeSheet);
        HashMap<String, ArrayList> basePoints = new HashMap<String, ArrayList>();
        basePoints.put(activeSheet.getSheetName(), basePointList);
        for (int i = 0; i < ranges.size(); ++i) {
            CellBlock block = ranges.getCellBlock(i);
            Sheet.ICellsIterator it = activeSheet.getCellsIterator(block, false, true);
            while (it.hasNext()) {
                DynaParameters params;
                String ditemNumber;
                Cell cell = it.next();
                ItemFormula item = NewRptUtil.getItemFormula((Cell)cell, basePoints);
                if (item == null || !item.isDItem() || (ditemNumber = item.getDItemNumber()) == null || "".equals(ditemNumber)) continue;
                Point basePoint = DynamicTemplateUtility.getBasePoint((Sheet)activeSheet, (Point)new Point(cell.getCol(), cell.getRow()), (ArrayList)basePointList);
                try {
                    params = DynamicTemplateUtility.getDynaParameters((Sheet)activeSheet, (Point)basePoint);
                }
                catch (NullPointerException e) {
                    continue;
                }
                String ditemName = null;
                ditemName = params.getSpreadStyle() == 0 ? activeSheet.getRange(cell.getRow(), basePoint.x).getValue().toString() : activeSheet.getRange(basePoint.y, cell.getCol()).getValue().toString();
                DynaItemInfo values = new DynaItemInfo(StringUtils.trim((String)ditemName), ditemNumber);
                if (dyitems.contains(values)) continue;
                dyitems.add(values);
            }
        }
        return dyitems;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public RptParams getCustomCondition() {
        RptParams params = new RptParams();
        Integer startyear = (Integer)this.startYearSpin.getValue();
        Integer endyear = (Integer)this.endYearSpin.getValue();
        Integer startPeriod = (Integer)this.startPeriodSpin.getValue();
        Integer endperiod = (Integer)this.endPeriodSpin.getValue();
        Integer swap = new Integer(-1);
        if (startyear > endyear) {
            swap = endyear;
            endyear = startyear;
            startyear = swap;
            swap = endperiod;
            endperiod = startPeriod;
            startPeriod = swap;
        } else if (startyear.intValue() == endyear.intValue() && startPeriod > endperiod) {
            swap = endyear;
            endyear = startyear;
            startyear = swap;
            swap = endperiod;
            endperiod = startPeriod;
            startPeriod = swap;
        }
        params.setObject("TEXT_Ranges", (Object)this.rangeChooser.getText());
        params.setObject("START_YEAR", (Object)startyear);
        params.setObject("END_YEAR", (Object)endyear);
        params.setObject("START_PERIOD", (Object)startPeriod);
        params.setObject("END_PERIOD", (Object)endperiod);
        ReportBaseInfo info = (ReportBaseInfo)this.bookprovider.getEditValue();
        params.setInt("PERIOD_TYPE", info.getPeriodType().getValue());
        params.setObject("FETCH_TYPE", this.fetchTypePromp.getData());
        String org_tree_number = null;
        try {
            if (this.isQueryBudget == 0) {
                RptReceivedCollection collection = RptReceivedFactory.getRemoteInstance().getRptReceivedCollection("select orgtree where report = '" + info.getId().toString() + "'");
                if (collection != null && collection.size() != 0) {
                    org_tree_number = collection.get(0).getOrgTree().getId().toString();
                }
            } else if (this.isQueryBudget == 1) {
                HisRptReceivedCollection collection = HisRptReceivedFactory.getRemoteInstance().getHisRptReceivedCollection("select orgtree where report = '" + info.getId().toString() + "'");
                if (collection != null && collection.size() != 0) {
                    org_tree_number = collection.get(0).getOrgTree().getId().toString();
                }
            } else {
                logger.debug((Object)"something wrong in RptDynaItemAnalysisFilterUI,can't get param 'isQueryBudget'");
            }
        }
        catch (BOSException e) {
            logger.debug((Object)"get org_tree_number error in RptDynaItemAnalysisFilterUI.getCustomCondition()");
        }
        params.setObject("ORG_TREE_Number", org_tree_number);
        params.setObject("ORGS", this.orgsPromp.getData());
        params.setObject("ITEMS", this.itemPromp.getData());
        params.setBoolean("SHOW_ORG_SUM", this.showOrgSumChk.isSelected());
        params.setBoolean("SHOW_PERIOD_SUM", this.showPeriodSumChk.isSelected());
        params.setObject("DATA_TYPE", this.dataTypeCombo.getData());
        params.setInt("DATA_SRC_TYPE", ((CslDataSrcTypeEnum)((Object)this.srcTypeCombo.getSelectedItem())).getValue());
        params.setInt("ADJUST", ((AdjustStatusEnum)((Object)this.adjustCombo.getSelectedItem())).getValue());
        params.setString("REPORT_ID", info.getId().toString());
        params.setString("CURRENCY_ID", info.getCurrency().getId().toString());
        params.setObject("DITEMS", this.dyitemPromp.getData());
        params.setObject("DATACOLLECT", info.get("dataCollectNumber"));
        if (!(info.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) || info.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT) || info.getSourceType().equals((Object)RptSrcTypeEnum.DYNACSLELIMREPORT) || info.getSourceType().equals((Object)RptSrcTypeEnum.DYNACSLELIMREPORT_FASTMERGE) || info.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE) || info.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT_FASTMERGE))) {
            params.setObject("COMMITSTATUS", (Object)info.getCommittedStatus().getValue());
        }
        params.setObject("periodCollection", this.getUIContext().get("periodCollection"));
        params.setObject("isMergeByFiscalPeriod", (Object)this.isMergeByFiscalPeriod);
        return params;
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    @Override
    public void setInitParams(RptParams params) {
        this.startYearSpin.setValue(params.getObject("START_YEAR"));
        this.endYearSpin.setValue(params.getObject("END_YEAR"));
        this.startPeriodSpin.setValue(params.getObject("START_PERIOD"));
        this.endPeriodSpin.setValue(params.getObject("END_PERIOD"));
        ((JTextField)this.rangeChooser.getComponent(0)).setText(params.getString("TEXT_Ranges"));
        this.fetchTypePromp.setData(params.getObject("FETCH_TYPE"));
        this.orgsPromp.setData(params.getObject("ORGS"));
        this.itemPromp.setData(params.getObject("ITEMS"));
        this.showOrgSumChk.setSelected(params.getBoolean("SHOW_ORG_SUM"));
        this.showPeriodSumChk.setSelected(params.getBoolean("SHOW_PERIOD_SUM"));
        this.dataTypeCombo.setData(params.getObject("DATA_TYPE"));
        this.srcTypeCombo.setSelectedItem((Object)CslDataSrcTypeEnum.getEnum(params.getInt("DATA_SRC_TYPE")));
        this.adjustCombo.setSelectedItem((Object)AdjustStatusEnum.getEnum(params.getInt("ADJUST")));
        this.dyitemPromp.setData(params.getObject("DITEMS"));
    }

    public void setCustomCondition(RptParams params) {
    }

    public boolean verify() {
        if (this.itemPromp.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"82_RptDynaItemAnalysisFilterUI"));
            return false;
        }
        if (this.fetchTypePromp.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"83_RptDynaItemAnalysisFilterUI"));
            return false;
        }
        if (this.orgsPromp.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"77_RptCellAnalysisFilterUI"));
            return false;
        }
        if (this.dyitemPromp.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"84_RptDynaItemAnalysisFilterUI"));
            return false;
        }
        if (this.dataTypeCombo.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"85_RptDynaItemAnalysisFilterUI"));
            return false;
        }
        return true;
    }

    @Override
    String getMainUIName() {
        return RptDynaItemAnalysisMainUI.class.getName();
    }

    @Override
    int isQueryBudget() {
        return this.isQueryBudget;
    }
}

