/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.bi.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.facade.rangesel.RangeSelector;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.fi.gr.bi.client.AbstractRptItemAnalysisFilterUI;
import com.kingdee.eas.fi.gr.bi.client.FetchTypeLabelProvider;
import com.kingdee.eas.fi.gr.bi.client.FetchTypeProvider;
import com.kingdee.eas.fi.gr.bi.client.ItemContentProvider;
import com.kingdee.eas.fi.gr.bi.client.ItemLabelProvider;
import com.kingdee.eas.fi.gr.bi.client.OrgUnitTreeSelector;
import com.kingdee.eas.fi.gr.bi.client.RptItemAnalysisMainUI;
import com.kingdee.eas.fi.gr.bi.client.SortableChooser;
import com.kingdee.eas.fi.gr.bi.util.AnalysisAdjustEnum;
import com.kingdee.eas.fi.gr.bi.util.RptBiUtil;
import com.kingdee.eas.fi.gr.cslrpt.CslDataSrcTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SumRptProcessUI;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.rpt.CompanyF7Helper;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class RptItemAnalysisFilterUI
extends AbstractRptItemAnalysisFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptItemAnalysisFilterUI.class);
    private SpreadManager spreadManager;
    private IBookProvider bookprovider;
    private RangeSelector rangeChooser;
    private int isQueryBudget = 0;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.spreadManager = (SpreadManager)this.getUIContext().get("SPREAD_MANAGER");
        this.bookprovider = (IBookProvider)this.getUIContext().get("BOOK_PROVIDER");
        if (this.getUIContext().get("ISQUERYBUDGET") != null) {
            this.isQueryBudget = (Integer)this.getUIContext().get("ISQUERYBUDGET");
        }
        this.createControl();
        if (!this.isOpenOnMainui()) {
            ((KDTextField)this.rangeChooser.getComponent(0)).setText(this.spreadManager.getSpreadContainer().getBook().getActiveSheet().getSelectionRange().getName(true));
            this.applySelectionRange();
        }
        this.orgPromp.setEditable(false);
        this.itemPromp.setEditable(false);
        this.fetchTypePromp.setEditable(false);
    }

    private void createControl() throws BOSException, ReportException {
        this.rangeChooser = this.spreadManager.createRangeSelector(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"79_RptDynaItemAnalysisFilterUI"));
        this.lblRange.setBoundEditor((JComponent)this.rangeChooser);
        this.setSpineRange(this.startYearSpin, 1901, 2099);
        this.setSpineRange(this.endYearSpin, 1901, 2099);
        ReportBaseInfo info = (ReportBaseInfo)this.bookprovider.getEditValue();
        Integer year = new Integer(info.getYear());
        RptPeriodTypeEnum periodType = info.getPeriodType();
        if (FiscalPeriodHelper.isMergeByFiscalPeriod(this.isMergeByFiscalPeriod, periodType)) {
            FiscalPeriodHelper.setSpineRangeByPeriodType(this.startPeriodSpin, periodType);
            FiscalPeriodHelper.setSpineRangeByPeriodType(this.endPeriodSpin, periodType);
        } else {
            this.setPeriodRange(this.startPeriodSpin, periodType.getValue(), year);
            this.setPeriodRange(this.endPeriodSpin, periodType.getValue(), year);
            if (RptPeriodTypeEnum.MONTHLY == info.getPeriodType() && info.getPeriod() > 12 && !CslRptUtil.isSupport13Period(null)) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"2_RptCellAnalysisFilterUI");
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{MessageFormat.format(msg, info.getPeriod())});
            }
        }
        this.startYearSpin.setValue((Object)year);
        this.endYearSpin.setValue((Object)year);
        Integer period = new Integer(info.getPeriod());
        this.startPeriodSpin.setValue((Object)period);
        this.endPeriodSpin.setValue((Object)period);
        boolean isNormalReport = false;
        if (info instanceof ReportInfo || info.getSourceType() == RptSrcTypeEnum.NORMAL || info.getSourceType() == RptSrcTypeEnum.COMMITREPORT || info.getSourceType() == RptSrcTypeEnum.DYNAMICNORMALREPORT) {
            if (info instanceof CslReportInfo) {
                CslReportInfo csl = (CslReportInfo)info;
                if (csl.isIsCommitReport() && !(this.getUIContext().get("Owner") instanceof GroupRptProcessUI)) {
                    isNormalReport = true;
                }
            } else {
                isNormalReport = true;
            }
        }
        if (isNormalReport) {
            OrgType orgType = RptNewUIUtil.getOrgTypeOnContext((Map)this.getUIContext());
            CompanyF7Helper.MultiOrgViewTypeUnitF7 f7 = new CompanyF7Helper.MultiOrgViewTypeUnitF7((IUIObject)this, orgType){

                public Object getData() {
                    Object data = super.getData();
                    if (data instanceof Object[]) {
                        return Arrays.asList((Object[])data);
                    }
                    return super.getData();
                }
            };
            HashSet<String> orgIds = new HashSet<String>();
            orgIds.add(info.getCompany().getId().toString());
            f7.setSelectedOrgIds(orgIds);
            f7.setMultiSelect(true);
            f7.setShowAssistantOrg(true);
            f7.setCheckedAssistantOrgChkBox(true);
            this.orgPromp.setSelector((KDPromptSelector)f7);
            this.orgPromp.setDisplayFormat("$name$");
            this.orgPromp.setData(Arrays.asList(info.getCompany()));
            this.orgPromp.addSelectorListener(new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    HashSet<String> orgSet = new HashSet<String>();
                    List orgs = (List)RptItemAnalysisFilterUI.this.orgPromp.getData();
                    if (orgs == null) {
                        return;
                    }
                    for (OrgUnitInfo info : orgs) {
                        orgSet.add(info.getId().toString());
                    }
                    ((NewCompanyF7)RptItemAnalysisFilterUI.this.orgPromp.getSelector()).refresh();
                    ((NewCompanyF7)RptItemAnalysisFilterUI.this.orgPromp.getSelector()).setSelectedOrgIds(orgSet);
                }
            });
            this.reportTypeCmbo.setEnabled(false);
        } else {
            try {
                OrgTreeInfo tree = CSLContextHelper.getCSLContext().getCurOrgBound();
                OrgUnitInfo org = CSLContextHelper.getCSLContext().getCurOrgGroup();
                if (info instanceof CslReportInfo) {
                    CslReportInfo csl = (CslReportInfo)info;
                    this.orgPromp.setData(Arrays.asList(csl.getOrgUnit()));
                    if (csl.getOrgTree() != null) {
                        tree = csl.getOrgTree();
                        org = csl.getOrgUnit();
                    }
                } else {
                    this.orgPromp.setData(Arrays.asList(org));
                }
                this.orgPromp.setSelector((KDPromptSelector)new OrgUnitTreeSelector((IUIObject)this, this.orgPromp, tree, org));
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        String txt = this.applyBtn.getToolTipText();
        this.applyBtn.setAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RptItemAnalysisFilterUI.this.applySelectionRange();
            }
        });
        this.applyBtn.setToolTipText(txt);
        this.applyBtn.setIcon(EASResource.getIcon((String)"imgTbtn_applycondition"));
        this.itemPromp.setSelector((KDPromptSelector)new SortableChooser(new ItemContentProvider(){

            @Override
            public List getSelected() {
                return (List)RptItemAnalysisFilterUI.this.itemPromp.getData();
            }

            @Override
            public String getCompanyId() {
                return ((ReportBaseInfo)RptItemAnalysisFilterUI.this.bookprovider.getEditValue()).getCompany().getId().toString();
            }
        }, new ItemLabelProvider(), (IUIObject)this));
        this.fetchTypePromp.setSelector((KDPromptSelector)new SortableChooser(new FetchTypeProvider(){

            @Override
            public List getSelected() {
                return (List)RptItemAnalysisFilterUI.this.fetchTypePromp.getData();
            }

            @Override
            public String getCompanyId() {
                return ((ReportBaseInfo)RptItemAnalysisFilterUI.this.bookprovider.getEditValue()).getCompany().getId().toString();
            }
        }, new FetchTypeLabelProvider(), (IUIObject)this));
        this.createDataSrcPromp(this.typeComb);
        this.reportTypeCmbo.addItem((Object)CslDataSrcTypeEnum.COMBINE);
        this.reportTypeCmbo.addItem((Object)CslDataSrcTypeEnum.SUMMARY);
        if (this.getUIContext().get("Owner") instanceof SumRptProcessUI) {
            this.reportTypeCmbo.setSelectedItem((Object)CslDataSrcTypeEnum.SUMMARY);
        } else {
            this.reportTypeCmbo.setSelectedItem((Object)CslDataSrcTypeEnum.COMBINE);
        }
        this.isAdjustComb.removeAllItems();
        this.isAdjustComb.addItem((Object)AnalysisAdjustEnum.ADJUSTED);
        this.isAdjustComb.addItem((Object)AnalysisAdjustEnum.BEFOREADJUST);
    }

    protected void applySelectionRange() {
        String text = this.rangeChooser.getText();
        if (StringUtils.isEmpty((String)text)) {
            return;
        }
        SumcalcRange ranges = this.getRange(text);
        if (ranges == null) {
            return;
        }
        ArrayList<String> items = new ArrayList<String>();
        ArrayList<String> fetch_types = new ArrayList<String>();
        HashSet<ValueTypeEnum> data_types = new HashSet<ValueTypeEnum>();
        for (int i = 0; i < ranges.size(); ++i) {
            CellBlock block = ranges.getCellBlock(i);
            Sheet.ICellsIterator it = this.spreadManager.getSpreadContainer().getBook().getActiveSheet().getCellsIterator(block, false, true);
            while (it.hasNext()) {
                ValueTypeEnum e;
                Cell cell = it.next();
                ItemFormula item = UserObjectHelper.getItemFormula((Cell)cell);
                if (item == null || item.getItemNumber() == null) continue;
                if (!items.contains(item.getItemNumber())) {
                    items.add(item.getItemNumber());
                }
                if (!fetch_types.contains(item.getDataElementNumber())) {
                    fetch_types.add(item.getDataElementNumber());
                }
                if ((e = ValueTypeEnum.getEnum(item.getValueType())) == ValueTypeEnum.TXT) continue;
                data_types.add(e);
            }
        }
        try {
            if (items.size() > 0) {
                String companyId = ((ReportBaseInfo)this.bookprovider.getEditValue()).getCompany().getId().toString();
                this.itemPromp.setData((Object)RptBiUtil.getRptItemCollection(items, companyId, true));
                ArrayList elemants = RptBiUtil.findFetchTypes(fetch_types, companyId);
                if (elemants.size() == 0) {
                    elemants = null;
                }
                this.fetchTypePromp.setData((Object)elemants);
            }
            if (data_types.size() > 0) {
                this.typeComb.setData(new ArrayList(data_types));
            } else {
                this.typeComb.setData(null);
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    @Override
    protected String getMainUIName() {
        return RptItemAnalysisMainUI.class.getName();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public RptParams getCustomCondition() {
        RptParams params = new RptParams();
        Integer startyear = (Integer)this.startYearSpin.getValue();
        Integer endyear = (Integer)this.endYearSpin.getValue();
        Integer startPeriod = (Integer)this.startPeriodSpin.getValue();
        Integer endperiod = (Integer)this.endPeriodSpin.getValue();
        Integer swap = new Integer(-1);
        if (startyear > endyear) {
            swap = endyear;
            endyear = startyear;
            startyear = swap;
            swap = endperiod;
            endperiod = startPeriod;
            startPeriod = swap;
        } else if (startyear.intValue() == endyear.intValue() && startPeriod > endperiod) {
            swap = endyear;
            endyear = startyear;
            startyear = swap;
            swap = endperiod;
            endperiod = startPeriod;
            startPeriod = swap;
        }
        params.setObject("TEXT_Ranges", (Object)this.rangeChooser.getText());
        params.setObject("START_YEAR", (Object)startyear);
        params.setObject("END_YEAR", (Object)endyear);
        params.setObject("START_PERIOD", (Object)startPeriod);
        params.setObject("END_PERIOD", (Object)endperiod);
        ReportBaseInfo info = (ReportBaseInfo)this.bookprovider.getEditValue();
        params.setInt("PERIOD_TYPE", info.getPeriodType().getValue());
        params.setObject("FETCH_TYPE", this.fetchTypePromp.getData());
        params.setObject("ORG_TREE_ID", info.getOrgTree() == null ? null : info.getOrgTree().getId().toString());
        params.setObject("ORG_TREE_Number", info.getOrgTree() == null ? null : info.getOrgTree().getNumber());
        params.setObject("ORGS", this.orgPromp.getData());
        params.setObject("ITEMS", this.itemPromp.getData());
        params.setBoolean("SHOW_ORG_SUM", this.chkShowOrgs.isSelected());
        params.setBoolean("SHOW_PERIOD_SUM", this.kDCheckBox2.isSelected());
        params.setObject("DATA_TYPE", this.typeComb.getData());
        params.setInt("DATA_SRC_TYPE", ((CslDataSrcTypeEnum)((Object)this.reportTypeCmbo.getSelectedItem())).getValue());
        params.setObject("ADJUST", Arrays.asList(this.isAdjustComb.getSelectedItem()));
        params.setString("REPORT_ID", info.getId().toString());
        params.setObject("CURRENCY", Arrays.asList(info.getCurrency()));
        params.setObject("DATACOLLECT", info.get("dataCollectNumber"));
        Boolean isRptProcess = (Boolean)this.getUIContext().get("isRptProcess");
        params.setBoolean("isRptProcess", isRptProcess == null ? false : isRptProcess);
        params.setObject("periodCollection", this.getUIContext().get("periodCollection"));
        params.setObject("isMergeByFiscalPeriod", (Object)this.isMergeByFiscalPeriod);
        params.setObject("orgType", (Object)RptNewUIUtil.getOrgTypeOnContext((Map)this.getUIContext()));
        return params;
    }

    @Override
    public void setInitParams(RptParams params) {
        List l = (List)params.getObject("DATA_TYPE");
        if (l != null && l.size() > 0) {
            this.typeComb.setData((Object)l);
        }
        this.reportTypeCmbo.setSelectedItem((Object)CslDataSrcTypeEnum.getEnum(params.getInt("DATA_SRC_TYPE")));
        ((KDTextField)this.rangeChooser.getComponent(0)).setText(params.getString("TEXT_Ranges"));
        this.orgPromp.setData(params.getObject("ORGS"));
        this.itemPromp.setData(params.getObject("ITEMS"));
        this.fetchTypePromp.setData(params.getObject("FETCH_TYPE"));
        this.startYearSpin.setValue(params.getObject("START_YEAR"));
        this.endYearSpin.setValue(params.getObject("END_YEAR"));
        this.startPeriodSpin.setValue(params.getObject("START_PERIOD"));
        this.endPeriodSpin.setValue(params.getObject("END_PERIOD"));
        this.chkShowOrgs.setSelected(params.getBoolean("SHOW_ORG_SUM"));
        this.kDCheckBox2.setSelected(params.getBoolean("SHOW_PERIOD_SUM"));
        l = (List)params.getObject("ADJUST");
        if (l != null && l.size() > 0) {
            this.isAdjustComb.setSelectedItem(l.get(0));
        }
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public void setCustomCondition(RptParams params) {
    }

    public boolean verify() {
        if (this.itemPromp.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"82_RptDynaItemAnalysisFilterUI"));
            return false;
        }
        if (this.fetchTypePromp.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"83_RptDynaItemAnalysisFilterUI"));
            return false;
        }
        if (this.orgPromp.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"77_RptCellAnalysisFilterUI"));
            return false;
        }
        if (this.typeComb.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"85_RptDynaItemAnalysisFilterUI"));
            return false;
        }
        return true;
    }

    public SpreadManager getSpreadManager() {
        return this.spreadManager;
    }

    public void setSpreadManager(SpreadManager spreadManager) {
        this.spreadManager = spreadManager;
    }

    @Override
    int isQueryBudget() {
        return this.isQueryBudget;
    }
}

