/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.bi.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.facade.rangesel.RangeSelector;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.bi.client.AbstractRptXDynaItemAnalysisFilterUI;
import com.kingdee.eas.fi.gr.bi.client.FetchTypeLabelProvider;
import com.kingdee.eas.fi.gr.bi.client.FetchTypeProvider;
import com.kingdee.eas.fi.gr.bi.client.IChooserContentProvider;
import com.kingdee.eas.fi.gr.bi.client.IChooserLabelProvider;
import com.kingdee.eas.fi.gr.bi.client.ItemContentProvider;
import com.kingdee.eas.fi.gr.bi.client.ItemLabelProvider;
import com.kingdee.eas.fi.gr.bi.client.RptXDynaItemAnalysisMainUI;
import com.kingdee.eas.fi.gr.bi.client.SortableChooser;
import com.kingdee.eas.fi.gr.bi.util.DynaItemInfo;
import com.kingdee.eas.fi.gr.bi.util.RptBiUtil;
import com.kingdee.eas.fi.gr.cslrpt.CslDataSrcTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.CslRptAsstAccountFactory;
import com.kingdee.eas.fi.gr.dynamic.util.AsstAccountUtils;
import com.kingdee.eas.fi.gr.dynamic.util.AsstActTypeUtils;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.rpt.CompanyF7Helper;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class RptXDynaItemAnalysisFilterUI
extends AbstractRptXDynaItemAnalysisFilterUI {
    private static final long serialVersionUID = -2219003304181365549L;
    private static final Logger logger = CoreUIObject.getLogger(RptXDynaItemAnalysisFilterUI.class);
    private SpreadManager spreadManager;
    private IBookProvider bookprovider;
    private RangeSelector rangeChooser;
    private Sheet curSheet;
    private static final int COLUMN_LENGTH = 120;
    private Point basePoint;
    private ArrayList basePointList;
    private DynaParameters parameters;
    private Map f7Controller;
    private Map asstActTypeNumber2AttribeMap;
    private Map asstActTypeAttribeMap2NumberMap;
    private int curRow = 0;
    private int curCol = 0;
    private Map tmpTableData;
    private Map asstItemMap;
    private boolean isNormalReport;
    private String colSplit = ",,";
    private String nameCodeSplit = ";;";
    private String selectSplit = "&&";
    private List asstTypeList = new ArrayList();

    public RptXDynaItemAnalysisFilterUI() throws Exception {
        this.tmpTableData = new HashMap();
        this.asstItemMap = new HashMap();
        this.f7Controller = new HashMap();
        this.asstActTypeNumber2AttribeMap = new HashMap();
        this.asstActTypeAttribeMap2NumberMap = new HashMap();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.parameters = null;
        this.basePoint = null;
        this.setBounds(this.getBounds().x, this.getBounds().y, this.getBounds().width, 425);
        this.spreadManager = (SpreadManager)this.getUIContext().get("SPREAD_MANAGER");
        this.bookprovider = (IBookProvider)this.getUIContext().get("BOOK_PROVIDER");
        this.srcTypeCombo.removeAllItems();
        this.srcTypeCombo.addItem((Object)CslDataSrcTypeEnum.SUMMARY);
        this.srcTypeCombo.addItem((Object)CslDataSrcTypeEnum.COMBINE);
        UserObject userObject = this.spreadManager.getSpreadContainer().getBook().getActiveSheet().getUserObject("COMPANY_NUMBER");
        if (userObject != null && userObject.getValue() != null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"86_RptMultiCslAnalysisFilterUI"));
            SysUtil.abort();
        }
        this.createControl();
        if (!this.isOpenOnMainui()) {
            ((KDTextField)this.rangeChooser.getComponent(0)).setText(this.spreadManager.getSpreadContainer().getBook().getActiveSheet().getSelectionRange().getName(true));
        }
        this.initCurSheet();
        this.initTable();
        this.addDataToTable(this.getTableData());
    }

    private void initCurSheet() {
        this.curSheet = this.spreadManager.getSpreadContainer().getBook().getActiveSheet();
        if (this.curSheet == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"TableIsNull"));
            SysUtil.abort();
        }
    }

    private void initTable() throws EASBizException, BOSException {
        this.tblMain.getActionMap().remove("Paste");
        this.tblMain.getActionMap().remove("Copy");
        this.tblMain.getActionMap().remove("Cut");
        DynaParameters parameters = this.getParameters();
        AsstAccountUtils asstAccount = parameters.getAsstAccount();
        ArrayList<String> attributeList = new ArrayList<String>(asstAccount.getAsstActTypeList().size());
        for (AsstActTypeUtils asstActType : asstAccount.getAsstActTypeList()) {
            attributeList.add(asstActType.getAsstHGAttribute());
        }
        ReportBaseInfo info = (ReportBaseInfo)this.bookprovider.getEditValue();
        HashMap<String, FullOrgUnitInfo> uiContext = new HashMap<String, FullOrgUnitInfo>();
        if (info != null) {
            uiContext.put("Company", info.getCompany());
        }
        Map itemCollections = CslRptAsstAccountFactory.getRemoteInstance().getItemCollections(attributeList, uiContext);
        int perfectWidth = 0;
        this.asstTypeList.clear();
        for (String attribute : attributeList) {
            Map.Entry entry = this.getAsstItemEntryByAttribute(attribute, itemCollections);
            if (entry == null) continue;
            AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)entry.getKey();
            IObjectCollection asstCollection = (IObjectCollection)entry.getValue();
            perfectWidth += 120;
            this.addSelectController(asstActTypeInfo, asstCollection, uiContext);
            this.cacheAsstActAttribute(asstActTypeInfo);
            this.asstTypeList.add(asstActTypeInfo);
        }
        this.tblMain.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                RptXDynaItemAnalysisFilterUI.this.curRow = e.getRowIndex();
                RptXDynaItemAnalysisFilterUI.this.curCol = e.getColumnIndex();
            }
        });
    }

    private void cacheAsstActAttribute(AsstActTypeInfo asstActTypeInfo) {
        this.asstActTypeNumber2AttribeMap.put(asstActTypeInfo.getNumber(), asstActTypeInfo.getAsstHGAttribute());
        this.asstActTypeAttribeMap2NumberMap.put(asstActTypeInfo.getAsstHGAttribute(), asstActTypeInfo.getNumber());
    }

    private Map.Entry getAsstItemEntryByAttribute(String attribute, Map itemCollections) {
        if (itemCollections != null) {
            for (Map.Entry entry : itemCollections.entrySet()) {
                AsstActTypeInfo key = (AsstActTypeInfo)entry.getKey();
                if (!attribute.equals(key.getAsstHGAttribute())) continue;
                return entry;
            }
        }
        return null;
    }

    private void addSelectController(AsstActTypeInfo asstActTypeInfo, IObjectCollection asstCollection, Map uiContext) throws EASBizException, BOSException {
        if (asstCollection != null && asstCollection.size() > 0) {
            KDComboBox comboBox = new KDComboBox();
            ArrayList<IObjectValue> itemList = new ArrayList<IObjectValue>();
            for (IObjectValue info : asstCollection) {
                comboBox.addItem((Object)info);
                itemList.add(info);
            }
            this.asstItemMap.put(asstActTypeInfo.getAsstHGAttribute(), itemList);
        }
        KDBizPromptBox f7 = new KDBizPromptBox();
        KDTDefaultCellEditor f7Editor = new KDTDefaultCellEditor((IKDEditor)f7);
        f7.setQueryInfo(asstActTypeInfo.getDefaultQueryName());
        EntityViewInfo view = DynamicTemplateUtility.createAsstItemFilter(null, (AsstActTypeInfo)asstActTypeInfo, (Map)uiContext);
        f7.setEntityViewInfo(view);
        f7.setCommitFormat("$number$;$name$");
        f7.setDisplayFormat("$name$");
        f7.setEditFormat("$number$");
        f7.setHistoryRecordEnabled(false);
        f7.setEditable(false);
        f7.setMyCommonUseEnabled(false);
        f7.setSelector((KDPromptSelector)new SortableChooser(new IChooserContentProvider(){

            @Override
            public List getSelected() {
                return (List)RptXDynaItemAnalysisFilterUI.this.tblMain.getCell(RptXDynaItemAnalysisFilterUI.this.curRow, RptXDynaItemAnalysisFilterUI.this.curCol).getValue();
            }

            @Override
            public int compare(Object obj1, Object obj2) {
                return obj1.equals(obj2) ? 0 : 1;
            }

            @Override
            public boolean enableFilter() {
                return false;
            }

            @Override
            public List getContents() throws Exception {
                return (List)RptXDynaItemAnalysisFilterUI.this.tmpTableData.get(String.valueOf(RptXDynaItemAnalysisFilterUI.this.curRow));
            }

            @Override
            public boolean matchFilter(Object item, int column, String filterString) {
                return false;
            }

            @Override
            public void setContents(ArrayList contents) {
            }

            @Override
            public boolean enableTemplateFilter() {
                return false;
            }
        }, new IChooserLabelProvider(){
            private String[] header = new String[]{EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"80_RptDynaItemAnalysisFilterUI"), EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"81_RptDynaItemAnalysisFilterUI")};

            @Override
            public String getColumnText(Object obj, int i) {
                switch (i) {
                    case 0: {
                        return ((DynaItemInfo)obj).getDitemNumber();
                    }
                    case 1: {
                        return ((DynaItemInfo)obj).getDitemName();
                    }
                }
                return null;
            }

            @Override
            public String[] getHeaderText() {
                return this.header;
            }
        }, (IUIObject)this));
        this.f7Controller.put(asstActTypeInfo.getAsstHGAttribute(), f7Editor);
    }

    private void applySelectionRange() {
        this.addDataToTable(this.getTableData());
        String text = this.rangeChooser.getText();
        if (StringUtils.isEmpty((String)text)) {
            return;
        }
        SumcalcRange ranges = this.getRange(text);
        if (ranges == null) {
            return;
        }
        ArrayList<String> items = new ArrayList<String>();
        ArrayList<String> fetch_types = new ArrayList<String>();
        HashSet<ValueTypeEnum> dataType = new HashSet<ValueTypeEnum>(2);
        Sheet activeSheet = this.spreadManager.getSpreadContainer().getBook().getActiveSheet();
        for (int i = 0; i < ranges.size(); ++i) {
            CellBlock block = ranges.getCellBlock(i);
            Sheet.ICellsIterator it = activeSheet.getCellsIterator(block, false, true);
            while (it.hasNext()) {
                ValueTypeEnum e;
                String dataElementNumber;
                Cell cell = it.next();
                ItemFormula item = UserObjectHelper.getItemFormula((Cell)cell);
                if (item == null || !item.isDItem()) continue;
                String itemNumber = item.getItemNumber();
                if (!items.contains(itemNumber)) {
                    items.add(itemNumber);
                }
                if (!fetch_types.contains(dataElementNumber = item.getDataElementNumber())) {
                    fetch_types.add(dataElementNumber);
                }
                if ((e = ValueTypeEnum.getEnum(item.getValueType())) == ValueTypeEnum.TXT) continue;
                dataType.add(e);
            }
        }
        try {
            if (items.size() > 0) {
                this.itemPromp.setData((Object)RptBiUtil.getRptItemCollection(items));
                this.fetchTypePromp.setData((Object)RptBiUtil.findFetchTypes(fetch_types));
            }
            if (dataType.size() > 0) {
                this.dataTypeCombo.setData(new ArrayList(dataType));
            } else {
                this.dataTypeCombo.setData(null);
            }
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
    }

    private void createControl() throws BOSException, EASBizException {
        this.rangeChooser = this.spreadManager.createRangeSelector(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"79_RptDynaItemAnalysisFilterUI"));
        this.labelRange.setBoundEditor((JComponent)this.rangeChooser);
        this.setSpineRange(this.startYearSpin, 1901, 2099);
        this.setSpineRange(this.endYearSpin, 1901, 2099);
        ReportBaseInfo info = (ReportBaseInfo)this.bookprovider.getEditValue();
        Integer year = new Integer(info.getYear());
        RptPeriodTypeEnum periodType = info.getPeriodType();
        if (FiscalPeriodHelper.isMergeByFiscalPeriod(this.isMergeByFiscalPeriod, periodType)) {
            FiscalPeriodHelper.setSpineRangeByPeriodType(this.startPeriodSpin, periodType);
            FiscalPeriodHelper.setSpineRangeByPeriodType(this.endPeriodSpin, periodType);
        } else {
            this.setPeriodRange(this.startPeriodSpin, periodType.getValue(), year);
            this.setPeriodRange(this.endPeriodSpin, periodType.getValue(), year);
            if (RptPeriodTypeEnum.MONTHLY == info.getPeriodType() && info.getPeriod() > 12 && !CslRptUtil.isSupport13Period(null)) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"2_RptCellAnalysisFilterUI");
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{MessageFormat.format(msg, info.getPeriod())});
            }
        }
        this.startYearSpin.setValue((Object)year);
        this.endYearSpin.setValue((Object)year);
        Integer period = new Integer(info.getPeriod());
        this.startPeriodSpin.setValue((Object)period);
        this.endPeriodSpin.setValue((Object)period);
        this.isNormalReport = false;
        if (info instanceof ReportInfo || info.getSourceType() == RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT) {
            this.isNormalReport = true;
        }
        NewCompanyF7 f7 = CompanyF7Helper.getAnalysisCompanyBizUnitF7((IUIObject)this);
        f7.setMultiSelect(true);
        HashSet<Object> orgIds = new HashSet<Object>();
        ArrayList<CompanyOrgUnitInfo> orgs = new ArrayList<CompanyOrgUnitInfo>();
        if (this.isNormalReport) {
            orgIds.add(info.getCompany().getId().toString());
            this.orgsPromp.setData(Arrays.asList(info.getCompany()));
        } else {
            Range ranges = this.spreadManager.getSpreadContainer().getBook().getActiveSheet().getSelectionRange();
            if (ranges == null) {
                return;
            }
            Sheet activeSheet = this.spreadManager.getSpreadContainer().getBook().getActiveSheet();
            for (int i = 0; i < ranges.size(); ++i) {
                CellBlock block = ranges.getBlock(i);
                Sheet.ICellsIterator it = activeSheet.getCellsIterator(block, false, true);
                while (it.hasNext()) {
                    Cell cell = it.next();
                    UserObject o = cell.getRowObject().getUserObject("COMPANY_NUMBER");
                    if (o == null || o.getValue() == null || orgIds.contains(o.getValue())) continue;
                    orgIds.add(o.getValue());
                    ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getRemoteInstance();
                    try {
                        orgs.add(iCompany.getCompanyOrgUnitInfo("where id='" + o.getValue() + "'"));
                    }
                    catch (ObjectNotFoundException e) {
                        super.handUIException((Throwable)e);
                    }
                }
            }
            this.orgsPromp.setData(orgs);
        }
        f7.setSelectedOrgIds(orgIds);
        this.orgsPromp.setSelector((KDPromptSelector)f7);
        this.srcTypeCombo.setEnabled(false);
        this.createDataSrcPromp(this.dataTypeCombo);
        if (info.getSourceType() == RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT || info.getSourceType() == RptSrcTypeEnum.MULTIDYNAMICSUMREPORT || info.getSourceType() == RptSrcTypeEnum.SUM) {
            this.srcTypeCombo.setSelectedItem((Object)CslDataSrcTypeEnum.SUMMARY);
        } else if (info.getSourceType() == RptSrcTypeEnum.CONSOLIDATION) {
            this.srcTypeCombo.setSelectedItem((Object)CslDataSrcTypeEnum.COMBINE);
        }
        this.itemPromp.setSelector((KDPromptSelector)new SortableChooser(new ItemContentProvider(){

            @Override
            public List getSelected() {
                return (List)RptXDynaItemAnalysisFilterUI.this.itemPromp.getData();
            }

            @Override
            public String getCompanyId() {
                return ((ReportBaseInfo)RptXDynaItemAnalysisFilterUI.this.bookprovider.getEditValue()).getCompany().getId().toString();
            }
        }, new ItemLabelProvider(), (IUIObject)this));
        this.fetchTypePromp.setSelector((KDPromptSelector)new SortableChooser(new FetchTypeProvider(){

            @Override
            public List getSelected() {
                return (List)RptXDynaItemAnalysisFilterUI.this.fetchTypePromp.getData();
            }

            @Override
            public String getCompanyId() {
                return ((ReportBaseInfo)RptXDynaItemAnalysisFilterUI.this.bookprovider.getEditValue()).getCompany().getId().toString();
            }
        }, new FetchTypeLabelProvider(), (IUIObject)this));
        this.applyBtn.setAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RptXDynaItemAnalysisFilterUI.this.applySelectionRange();
            }
        });
        this.applyBtn.setIcon(EASResource.getIcon((String)"imgTbtn_applycondition"));
        this.itemPromp.setEditable(false);
        this.orgsPromp.setEditable(false);
        this.srcTypeCombo.setEditable(false);
        this.fetchTypePromp.setEditable(false);
    }

    @Override
    public void setInitParams(RptParams params) {
        this.startYearSpin.setValue(params.getObject("START_YEAR"));
        this.endYearSpin.setValue(params.getObject("END_YEAR"));
        this.startPeriodSpin.setValue(params.getObject("START_PERIOD"));
        this.endPeriodSpin.setValue(params.getObject("END_PERIOD"));
        ((JTextField)this.rangeChooser.getComponent(0)).setText(params.getString("TEXT_Ranges"));
        this.fetchTypePromp.setData(params.getObject("FETCH_TYPE"));
        this.orgsPromp.setData(params.getObject("ORGS"));
        this.itemPromp.setData(params.getObject("ITEMS"));
        this.showOrgSumChk.setSelected(params.getBoolean("SHOW_ORG_SUM"));
        this.showPeriodSumChk.setSelected(params.getBoolean("SHOW_PERIOD_SUM"));
        this.showTypeSumChk.setSelected(params.getBoolean("SHOW_TYPE_SUM"));
        this.ShowSumUp.setSelected(params.getBoolean("SHOW_SUM_UP"));
        this.dataTypeCombo.setData(params.getObject("DATA_TYPE"));
        this.srcTypeCombo.setSelectedItem((Object)CslDataSrcTypeEnum.getEnum(params.getInt("DATA_SRC_TYPE")));
        Map tableData = (Map)params.getObject("TableData");
        Map[] tableDatas = new TreeMap[tableData.size()];
        for (int i = 0; i < tableData.size(); ++i) {
            tableDatas[i] = (TreeMap)tableData.get(String.valueOf(i));
        }
        this.addDataToTable(tableDatas);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    String getMainUIName() {
        return RptXDynaItemAnalysisMainUI.class.getName();
    }

    public RptParams getCustomCondition() {
        RptParams params = new RptParams();
        Integer startyear = (Integer)this.startYearSpin.getValue();
        Integer endyear = (Integer)this.endYearSpin.getValue();
        Integer startPeriod = (Integer)this.startPeriodSpin.getValue();
        Integer endperiod = (Integer)this.endPeriodSpin.getValue();
        Integer swap = new Integer(-1);
        if (startyear > endyear) {
            swap = endyear;
            endyear = startyear;
            startyear = swap;
            swap = endperiod;
            endperiod = startPeriod;
            startPeriod = swap;
        } else if (startyear.intValue() == endyear.intValue() && startPeriod > endperiod) {
            swap = endyear;
            endyear = startyear;
            startyear = swap;
            swap = endperiod;
            endperiod = startPeriod;
            startPeriod = swap;
        }
        params.setObject("TEXT_Ranges", (Object)this.rangeChooser.getText());
        params.setObject("START_YEAR", (Object)startyear);
        params.setObject("END_YEAR", (Object)endyear);
        params.setObject("START_PERIOD", (Object)startPeriod);
        params.setObject("END_PERIOD", (Object)endperiod);
        ReportBaseInfo info = (ReportBaseInfo)this.bookprovider.getEditValue();
        params.setInt("PERIOD_TYPE", info.getPeriodType().getValue());
        params.setString("PERIOD_TYPE_NAME", info.getPeriodType().getName());
        params.setObject("FETCH_TYPE", this.fetchTypePromp.getData());
        params.setObject("ORG_TREE_ID", info.getOrgTree() == null ? null : info.getOrgTree().getId().toString());
        params.setObject("ORG_TREE_Number", info.getOrgTree() == null ? null : info.getOrgTree().getNumber());
        params.setObject("ORGS", this.orgsPromp.getData());
        params.setObject("ITEMS", this.itemPromp.getData());
        params.setBoolean("SHOW_ORG_SUM", this.showOrgSumChk.isSelected());
        params.setBoolean("SHOW_PERIOD_SUM", this.showPeriodSumChk.isSelected());
        params.setBoolean("SHOW_TYPE_SUM", this.showTypeSumChk.isSelected());
        params.setBoolean("SHOW_SUM_UP", this.ShowSumUp.isSelected());
        params.setObject("DATA_TYPE", this.dataTypeCombo.getData());
        params.setInt("DATA_SRC_TYPE", ((CslDataSrcTypeEnum)((Object)this.srcTypeCombo.getSelectedItem())).getValue());
        params.setString("REPORT_ID", info.getId().toString());
        params.setString("CURRENCY", info.getCurrency().getNumber());
        TreeMap<Integer, Object> ditems = new TreeMap<Integer, Object>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            ICell cell = this.tblMain.getCell(i, "select");
            if (cell.getValue() == null || ((List)cell.getValue()).size() <= 0) continue;
            ditems.put(new Integer(i), cell.getValue());
        }
        params.setObject("DITEMS", ditems);
        Map[] tableData = this.getTableData();
        TreeMap tableDatas = new TreeMap();
        for (int i = 0; i < tableData.length; ++i) {
            TreeMap tmpMap = new TreeMap();
            tmpMap.putAll(tableData[i]);
            tableDatas.put(String.valueOf(i), tmpMap);
        }
        params.setObject("TableData", tableDatas);
        params.setObject("ASST", (Object)this.asstTypeList);
        params.setObject("periodCollection", this.getUIContext().get("periodCollection"));
        params.setObject("isMergeByFiscalPeriod", (Object)this.isMergeByFiscalPeriod);
        return params;
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public void setCustomCondition(RptParams params) {
    }

    public boolean verify() {
        if (this.itemPromp.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"82_RptDynaItemAnalysisFilterUI"));
            return false;
        }
        if (this.fetchTypePromp.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"83_RptDynaItemAnalysisFilterUI"));
            return false;
        }
        if (this.orgsPromp.getData() == null || ((List)this.orgsPromp.getData()).size() == 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"77_RptCellAnalysisFilterUI"));
            return false;
        }
        if (this.dataTypeCombo.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"85_RptDynaItemAnalysisFilterUI"));
            return false;
        }
        int sum = 0;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            ICell cell = this.tblMain.getCell(i, "select");
            if (cell.getValue() == null || ((List)cell.getValue()).size() == 0) continue;
            ++sum;
        }
        if (sum == 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"87_RptMultiCslAnalysisFilterUI"));
            return false;
        }
        return true;
    }

    private void addDataToTable(Map[] itemData) {
        this.tblMain.checkParsed();
        String itemDataKey = "";
        this.tblMain.removeRows();
        this.tmpTableData.clear();
        if (itemData[1] != null && itemData[0] != null) {
            Iterator itemdata = itemData[1].keySet().iterator();
            while (itemdata.hasNext()) {
                itemDataKey = itemdata.next().toString();
                IRow row = this.tblMain.addRow();
                ICell cell = row.getCell("asstActType");
                cell.setValue(itemData[1].get(itemDataKey));
                cell.setUserObject((Object)itemDataKey);
                cell = row.getCell("select");
                cell.getStyleAttributes().setLocked(false);
                KDTDefaultCellEditor cellEditor = (KDTDefaultCellEditor)this.f7Controller.get(itemDataKey);
                cell.setEditor((ICellEditor)cellEditor);
                cell.setValue(itemData[0].get(itemDataKey));
                int rowIndex = row.getRowIndex();
                if (this.tmpTableData.containsKey(String.valueOf(rowIndex))) continue;
                this.tmpTableData.put(String.valueOf(rowIndex), itemData[0].get(itemDataKey));
            }
        }
        List asslist = null;
        Point point = DynamicTemplateUtility.getBasePoint((Sheet)this.curSheet);
        Range range = this.curSheet.getRange(point.x, point.y);
        asslist = DynamicTemplateUtility.getAssActTypeFromCell((Range)range);
        if (asslist != null) {
            for (int i = 0; i < asslist.size(); ++i) {
                this.tblMain.getRow(i).getCell("asstActType").setValue(asslist.get(i));
            }
        }
    }

    private DynaParameters getParameters() {
        if (this.parameters == null) {
            Point basePoint = this.getBasePoint();
            this.parameters = DynamicTemplateUtility.getDynaParametersFromCell((Sheet)this.curSheet, (int)basePoint.y, (int)basePoint.x);
        }
        return this.parameters;
    }

    private Point getBasePoint() {
        if (this.basePoint == null) {
            Point activePoint = new Point(this.curSheet.getActiveCol(), this.curSheet.getActiveRow());
            this.basePoint = new Point(2, 2);
            int col = activePoint.x;
            int row = activePoint.y;
            ArrayList list = this.getBasePointList();
            if (list == null || list.size() == 0) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Dyna_NotInRange"));
                SysUtil.abort();
            }
            if (col >= 0 && row >= 0) {
                this.basePoint.x = col < 0 ? 0 : col;
                int n = this.basePoint.y = row < 0 ? 0 : row;
                if (list.size() > 0) {
                    this.basePoint = DynamicTemplateUtility.getBasePoint((Sheet)this.curSheet, (Point)this.basePoint, (ArrayList)list);
                    if (this.basePoint == null) {
                        if (list.size() == 1) {
                            this.basePoint = (Point)list.get(0);
                        } else {
                            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Dyna_NotInRange"));
                            SysUtil.abort();
                        }
                    }
                }
            } else if (list.size() > 0) {
                this.basePoint = (Point)list.get(0);
            }
        }
        return this.basePoint;
    }

    public ArrayList getBasePointList() {
        this.basePointList = DynamicTemplateUtility.getBasePointList((Sheet)this.curSheet);
        if (this.basePointList == null) {
            this.basePointList = new ArrayList();
        }
        return this.basePointList;
    }

    public Map[] getTableData() {
        Map[] result = new TreeMap[2];
        result[0] = new TreeMap();
        String text = this.rangeChooser.getText();
        if (StringUtils.isEmpty((String)text)) {
            return result;
        }
        SumcalcRange ranges = this.getRange(text);
        if (ranges == null) {
            return result;
        }
        if (ranges.getRanges().size() > 1) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"88_RptMultiCslAnalysisFilterUI"));
            SysUtil.abort();
            return result;
        }
        ArrayList asstActTypeList = this.getParameters().getAsstAccount().getAsstActTypeList();
        HashMap<String, Integer> sort = new HashMap<String, Integer>();
        for (int j = 0; j < asstActTypeList.size(); ++j) {
            AsstActTypeUtils asstActType = (AsstActTypeUtils)asstActTypeList.get(j);
            String asstHGAttribute = asstActType.getAsstHGAttribute();
            sort.put(asstHGAttribute, new Integer(j));
        }
        result[1] = new TreeMap(new Treec(sort));
        Sheet activeSheet = this.spreadManager.getSpreadContainer().getBook().getActiveSheet();
        ArrayList basePointList = DynamicTemplateUtility.getBasePointList((Sheet)activeSheet);
        ArrayList<String> items = new ArrayList<String>();
        ArrayList<String> fetch_types = new ArrayList<String>();
        HashSet<ValueTypeEnum> dataType = new HashSet<ValueTypeEnum>(2);
        int curIndex = 0;
        if (!this.isNormalReport) {
            curIndex = 1;
        }
        for (int i = 0; i < ranges.size(); ++i) {
            CellBlock block = ranges.getCellBlock(i);
            for (int j = 0; j < asstActTypeList.size(); ++j) {
                AsstActTypeUtils asstActType = (AsstActTypeUtils)asstActTypeList.get(j);
                String asstHGAttribute = asstActType.getAsstHGAttribute();
                String ditemTypeName = asstActType.getProperityAlias();
                String properityAlias = asstActType.getProperityName();
                if (!StringUtils.isEmpty((String)properityAlias)) {
                    ++curIndex;
                }
                if (!result[1].containsKey(asstHGAttribute)) {
                    result[1].put(asstHGAttribute, ditemTypeName);
                }
                ArrayList<DynaItemInfo> dyitems = new ArrayList<DynaItemInfo>();
                Sheet.ICellsIterator it = activeSheet.getCellsIterator(block, false, true);
                while (it.hasNext()) {
                    ValueTypeEnum e;
                    String dataElementNumber;
                    String ditemNumber;
                    Cell cell = it.next();
                    ItemFormula item = UserObjectHelper.getItemFormula((Cell)cell);
                    if (item == null || !item.isDItem() || (ditemNumber = item.getDItemNumber()) == null || "".equals(ditemNumber)) continue;
                    Point basePoint = DynamicTemplateUtility.getBasePoint((Sheet)activeSheet, (Point)new Point(cell.getCol(), cell.getRow()), (ArrayList)basePointList);
                    String ditemName = null;
                    CellBlock cellMergeBlock = activeSheet.getMergeBlock(cell.getRow(), basePoint.x + curIndex);
                    ditemName = cellMergeBlock == null ? activeSheet.getRange(cell.getRow(), basePoint.x + curIndex).getValue().toString() : activeSheet.getRange(cellMergeBlock.getRow(), cellMergeBlock.getCol()).getValue().toString();
                    String[] ditemNumberarr = ditemNumber.split(";");
                    for (int k = 0; k < ditemNumberarr.length; ++k) {
                        DynaItemInfo values;
                        if (!ditemNumberarr[k].startsWith(this.asstActTypeAttribeMap2NumberMap.get(asstHGAttribute).toString() + '|') || dyitems.contains(values = new DynaItemInfo(StringUtils.trim((String)ditemName), ditemNumberarr[k])) || values.getDitemName().length() == 0) continue;
                        dyitems.add(values);
                    }
                    String itemNumber = item.getItemNumber();
                    if (!items.contains(itemNumber)) {
                        items.add(itemNumber);
                    }
                    if (!fetch_types.contains(dataElementNumber = item.getDataElementNumber())) {
                        fetch_types.add(dataElementNumber);
                    }
                    if ((e = ValueTypeEnum.getEnum(item.getValueType())) == ValueTypeEnum.TXT || dataType.contains((Object)e)) continue;
                    dataType.add(e);
                }
                if (dyitems.size() > 0) {
                    ++curIndex;
                }
                result[0].put(asstHGAttribute, dyitems);
            }
        }
        try {
            if (items.size() > 0) {
                this.itemPromp.setData((Object)RptBiUtil.getRptItemCollection(items));
                this.fetchTypePromp.setData((Object)RptBiUtil.findFetchTypes(fetch_types));
            }
            if (dataType.size() > 0) {
                ArrayList dataTypes = new ArrayList(dataType);
                this.dataTypeCombo.setData(dataTypes);
            } else {
                this.dataTypeCombo.setData(null);
            }
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        return result;
    }

    public FilterInfo getFilterInfo() {
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
        }
        int formulaIndex = 0;
        StringBuffer sbFormula = new StringBuffer();
        ArrayList<Object> tmpDatas = new ArrayList<Object>();
        try {
            List orgs;
            List dataTypes;
            List dataElements;
            FilterItemInfo filterItem0 = new FilterItemInfo("labelRange", (Object)((JTextField)this.rangeChooser.getComponent(0)).getText(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItem0);
            sbFormula.append(" #" + formulaIndex++);
            List items = (List)this.itemPromp.getData();
            if (items != null) {
                tmpDatas.clear();
                for (int i = 0; i < items.size(); ++i) {
                    RPTItemInfo itemInfo = (RPTItemInfo)items.get(i);
                    if (itemInfo == null) continue;
                    tmpDatas.add(itemInfo.getNumber());
                }
                FilterItemInfo filterItem1 = new FilterItemInfo("itemNumbers", new HashSet(tmpDatas), CompareType.INCLUDE);
                this.filterInfo.getFilterItems().add(filterItem1);
                sbFormula.append(" and #" + formulaIndex++);
            }
            if ((dataElements = (List)this.fetchTypePromp.getData()) != null) {
                tmpDatas.clear();
                for (int i = 0; i < dataElements.size(); ++i) {
                    DataElementInfo fetchTypeInfo = (DataElementInfo)dataElements.get(i);
                    if (fetchTypeInfo == null) continue;
                    tmpDatas.add(fetchTypeInfo.getNumber());
                }
                FilterItemInfo filterItem2 = new FilterItemInfo("dataElementNumbers", new HashSet(tmpDatas), CompareType.INCLUDE);
                this.filterInfo.getFilterItems().add(filterItem2);
                sbFormula.append(" and #" + formulaIndex++);
            }
            if ((dataTypes = (List)this.dataTypeCombo.getData()) != null) {
                tmpDatas.clear();
                for (int i = 0; i < dataTypes.size(); ++i) {
                    ValueTypeEnum dataType = (ValueTypeEnum)((Object)dataTypes.get(i));
                    if (dataType == null) continue;
                    tmpDatas.add(new Integer(dataType.getValue()));
                }
                FilterItemInfo filterItem3 = new FilterItemInfo("dataTypes", new HashSet(tmpDatas), CompareType.INCLUDE);
                this.filterInfo.getFilterItems().add(filterItem3);
                sbFormula.append(" and #" + formulaIndex++);
            }
            if ((orgs = (List)this.orgsPromp.getData()) != null) {
                tmpDatas.clear();
                for (int i = 0; i < orgs.size(); ++i) {
                    OrgUnitInfo orgInfo = (OrgUnitInfo)orgs.get(i);
                    if (orgInfo == null) continue;
                    String id = orgInfo.getId().toString();
                    tmpDatas.add(id);
                }
                FilterItemInfo filterItem4 = new FilterItemInfo("orgID", new HashSet(tmpDatas), CompareType.INCLUDE);
                this.filterInfo.getFilterItems().add(filterItem4);
                sbFormula.append(" and #" + formulaIndex++);
            }
            FilterItemInfo filterItem5 = new FilterItemInfo("startYear", this.startYearSpin.getValue());
            this.filterInfo.getFilterItems().add(filterItem5);
            sbFormula.append(" and #" + formulaIndex++);
            FilterItemInfo filterItem6 = new FilterItemInfo("startPeriod", this.startPeriodSpin.getValue());
            this.filterInfo.getFilterItems().add(filterItem6);
            sbFormula.append(" and #" + formulaIndex++);
            FilterItemInfo filterItem7 = new FilterItemInfo("endYear", this.endYearSpin.getValue());
            this.filterInfo.getFilterItems().add(filterItem7);
            sbFormula.append(" and #" + formulaIndex++);
            FilterItemInfo filterItem8 = new FilterItemInfo("endPeriod", this.endPeriodSpin.getValue());
            this.filterInfo.getFilterItems().add(filterItem8);
            sbFormula.append(" and #" + formulaIndex++);
            CslDataSrcTypeEnum type = (CslDataSrcTypeEnum)((Object)this.srcTypeCombo.getSelectedItem());
            if (type != null) {
                FilterItemInfo filterItem9 = new FilterItemInfo("srcTypeCombo", (Object)new Integer(type.getValue()), CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItem9);
                sbFormula.append(" and #" + formulaIndex++);
            }
            int tableCounts = this.tblMain.getRowCount();
            tmpDatas.clear();
            StringBuffer rowData = new StringBuffer();
            String cellVale = null;
            String asstHGAttribute = null;
            List dyItems = null;
            for (int i = 0; i < tableCounts; ++i) {
                rowData.delete(0, rowData.length());
                cellVale = (String)this.tblMain.getCell(i, 0).getValue();
                asstHGAttribute = (String)this.tblMain.getCell(i, 0).getUserObject();
                rowData.append(asstHGAttribute).append(this.nameCodeSplit);
                rowData.append(cellVale).append(this.colSplit);
                dyItems = (List)this.tblMain.getCell(i, 1).getValue();
                for (int j = 0; j < dyItems.size(); ++j) {
                    DynaItemInfo itemInfo = (DynaItemInfo)dyItems.get(j);
                    if (itemInfo != null) {
                        rowData.append(itemInfo.getDitemNumber());
                        rowData.append(this.nameCodeSplit);
                        rowData.append(itemInfo.getDitemName());
                    }
                    if (j == dyItems.size() - 1) continue;
                    rowData.append(this.selectSplit);
                }
                tmpDatas.add(rowData.toString());
            }
            FilterItemInfo filterItem10 = new FilterItemInfo("tableData", new HashSet(tmpDatas), CompareType.INCLUDE);
            this.filterInfo.getFilterItems().add(filterItem10);
            sbFormula.append(" and #" + formulaIndex++);
            FilterItemInfo filterItem11 = new FilterItemInfo("showOrgSumChk", (Object)new Integer(this.showOrgSumChk.getSelected()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItem11);
            sbFormula.append(" and #" + formulaIndex++);
            FilterItemInfo filterItem12 = new FilterItemInfo("showPeriodSumChk", (Object)new Integer(this.showPeriodSumChk.getSelected()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItem12);
            sbFormula.append(" and #" + formulaIndex++);
            FilterItemInfo filterItem13 = new FilterItemInfo("showTypeSumChk", (Object)new Integer(this.showTypeSumChk.getSelected()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItem13);
            sbFormula.append(" and #" + formulaIndex++);
            FilterItemInfo filterItem14 = new FilterItemInfo("ShowSumUp", (Object)new Integer(this.ShowSumUp.getSelected()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItem14);
            sbFormula.append(" and #" + formulaIndex++);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.clearUI();
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        try {
            for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
                String tmpRowData;
                Iterator tbData;
                FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("labelRange")) {
                    String labelRange1 = (String)filterItemInfo.getCompareValue();
                    ((JTextField)this.rangeChooser.getComponent(0)).setText(labelRange1);
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("itemNumbers")) {
                    HashSet itemNumbers = (HashSet)filterItemInfo.getCompareValue();
                    this.itemPromp.setData((Object)RptBiUtil.getRptItemCollection(new ArrayList(itemNumbers)));
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("dataElementNumbers")) {
                    HashSet dataElementNumbers = (HashSet)filterItemInfo.getCompareValue();
                    this.fetchTypePromp.setData((Object)RptBiUtil.findFetchTypes(new ArrayList(dataElementNumbers)));
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("dataTypes")) {
                    HashSet dataTypes = (HashSet)filterItemInfo.getCompareValue();
                    ArrayList<ValueTypeEnum> tmpData = new ArrayList<ValueTypeEnum>();
                    for (Integer dataValue : dataTypes) {
                        if (dataValue == null) continue;
                        tmpData.add(ValueTypeEnum.getEnum(dataValue));
                    }
                    this.dataTypeCombo.setData(tmpData);
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("orgID")) {
                    HashSet orgID = (HashSet)filterItemInfo.getCompareValue();
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)orgID, CompareType.INCLUDE));
                    viewInfo.setFilter(filter);
                    OrgUnitCollection orgCollection = null;
                    orgCollection = this.isNormalReport ? CompanyOrgUnitFactory.getRemoteInstance().getOrgUnitCollection(viewInfo) : FullOrgUnitFactory.getRemoteInstance().getOrgUnitCollection(viewInfo);
                    Iterator itr = orgCollection.iterator();
                    ArrayList<OrgUnitInfo> al = new ArrayList<OrgUnitInfo>();
                    while (itr.hasNext()) {
                        OrgUnitInfo orgUnit = (OrgUnitInfo)itr.next();
                        al.add(orgUnit);
                    }
                    this.orgsPromp.setData(al);
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("srcTypeCombo")) {
                    Integer srcType = (Integer)filterItemInfo.getCompareValue();
                    this.srcTypeCombo.setSelectedItem((Object)CslDataSrcTypeEnum.getEnum(srcType));
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("startYear")) {
                    this.startYearSpin.setValue(filterItemInfo.getCompareValue());
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("startPeriod")) {
                    this.startPeriodSpin.setValue(filterItemInfo.getCompareValue());
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("endYear")) {
                    this.endYearSpin.setValue(filterItemInfo.getCompareValue());
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("endPeriod")) {
                    this.endPeriodSpin.setValue(filterItemInfo.getCompareValue());
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("tableData")) {
                    HashSet tableData = (HashSet)filterItemInfo.getCompareValue();
                    tbData = tableData.iterator();
                    tmpRowData = null;
                } else {
                    if (filterItemInfo.getPropertyName().equalsIgnoreCase("showOrgSumChk")) {
                        Integer showOrgSum = (Integer)filterItemInfo.getCompareValue();
                        this.showOrgSumChk.setSelected(showOrgSum.intValue());
                        continue;
                    }
                    if (filterItemInfo.getPropertyName().equalsIgnoreCase("showPeriodSumChk")) {
                        Integer showPeriodSum = (Integer)filterItemInfo.getCompareValue();
                        this.showPeriodSumChk.setSelected(showPeriodSum.intValue());
                        continue;
                    }
                    if (filterItemInfo.getPropertyName().equalsIgnoreCase("showTypeSumChk")) {
                        Integer showTypeSum = (Integer)filterItemInfo.getCompareValue();
                        this.showTypeSumChk.setSelected(showTypeSum.intValue());
                        continue;
                    }
                    if (!filterItemInfo.getPropertyName().equalsIgnoreCase("ShowSumUp")) continue;
                    Integer ShowSum = (Integer)filterItemInfo.getCompareValue();
                    this.ShowSumUp.setSelected(ShowSum.intValue());
                    continue;
                }
                while (tbData.hasNext()) {
                    String[] colData;
                    tmpRowData = (String)tbData.next();
                    if (tmpRowData == null || (colData = tmpRowData.split(this.colSplit)).length != 2) continue;
                    String[] dItemType = colData[0].split(this.nameCodeSplit);
                    String[] itemData = colData[1].split(this.selectSplit);
                    ArrayList<DynaItemInfo> itemDatas = new ArrayList<DynaItemInfo>();
                    for (int j = 0; j < itemData.length; ++j) {
                        String[] tmpItemData = itemData[j].split(this.nameCodeSplit);
                        if (tmpItemData.length != 2) continue;
                        itemDatas.add(new DynaItemInfo(StringUtils.trim((String)tmpItemData[1]), tmpItemData[0]));
                    }
                    IRow row = this.tblMain.addRow();
                    ICell cell = row.getCell("asstActType");
                    cell.setValue((Object)dItemType[1]);
                    cell.setUserObject((Object)dItemType[0]);
                    cell = row.getCell("select");
                    cell.getStyleAttributes().setLocked(false);
                    KDTDefaultCellEditor cellEditor = (KDTDefaultCellEditor)this.f7Controller.get(dItemType[0]);
                    cell.setEditor((ICellEditor)cellEditor);
                    cell.setValue(itemDatas);
                }
            }
            return;
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    public void initCheckBox() {
        this.showOrgSumChk.setSelected(false);
        this.showPeriodSumChk.setSelected(false);
        this.showTypeSumChk.setSelected(true);
        this.ShowSumUp.setSelected(true);
    }

    public void clearUI() {
        ((JTextField)this.rangeChooser.getComponent(0)).setText(null);
        this.itemPromp.setData(null);
        this.fetchTypePromp.setData(null);
        this.dataTypeCombo.setData(null);
        this.tblMain.removeRows();
    }

    public void clear() {
        super.clear();
        try {
            this.initCheckBox();
            this.createControl();
            if (!this.isOpenOnMainui()) {
                ((KDTextField)this.rangeChooser.getComponent(0)).setText(this.spreadManager.getSpreadContainer().getBook().getActiveSheet().getSelectionRange().getName(true));
            }
            this.addDataToTable(this.getTableData());
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    public void actionbtnOK_Performed() {
        if (this.verify()) {
            if (!this.isOpenOnMainui()) {
                Map ctx = this.getUIContext();
                ctx.put("com.kingdee.eas.framework.bireport.client.BireportBaseMainUI#UICONTEXT_KEY_BE_JOINQUERY", true);
                ctx.put("com.kingdee.eas.framework.bireport.client.BireportBaseMainUI#UICONTEXT_KEY_JOINQUERY_PARAMS", this.getCustomCondition());
                ctx.put("Owner", this.getUIContext().get("Owner"));
                ctx.put("SINGLE" + System.currentTimeMillis(), "");
                try {
                    IUIWindow win = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getMainUIName(), ctx, this.dataObjects);
                    win.show();
                }
                catch (UIException e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            } else {
                this.actionbtnOK_Performed();
            }
        }
    }

    class Treec
    implements Comparator {
        Map sort;

        public Treec(Map sort) {
            this.sort = sort;
        }

        public int compare(Object arg0, Object arg1) {
            return (Integer)this.sort.get(arg0) - (Integer)this.sort.get(arg1);
        }
    }
}

