/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.bi.util;

import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.fi.gr.bi.util.SimplePeriod;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

public class PeriodIterator {
    private final int periodType;
    private Calendar start;
    private Calendar end;
    private PeriodCollection periodCollection;
    private boolean isMergeByFiscalPeriod;
    private Iterator iter = null;

    public PeriodIterator(int starty, int endy, int startp, int endp, int periodType, PeriodCollection periodCollection, boolean isMergeByFiscalPeriod) {
        this.periodType = periodType;
        this.periodCollection = periodCollection;
        this.isMergeByFiscalPeriod = isMergeByFiscalPeriod;
        if (this.isMergeByFiscalPeriod()) {
            List list = FiscalPeriodHelper.getYearAndPeriodList(periodCollection, isMergeByFiscalPeriod, starty, endy, startp, endp, RptPeriodTypeEnum.getEnum((int)periodType));
            if (list != null) {
                this.iter = list.iterator();
            }
        } else {
            this.start = Calendar.getInstance();
            this.start.set(1, starty);
            this.start.set(5, 1);
            this.end = Calendar.getInstance();
            this.end.set(1, endy);
            this.end.set(5, 1);
            switch (periodType) {
                case 6: {
                    this.start.set(6, startp);
                    this.end.set(6, endp);
                    break;
                }
                case 1: {
                    this.start.set(6, startp);
                    this.end.set(6, endp);
                    break;
                }
                case 2: {
                    this.start.set(3, startp);
                    this.end.set(3, endp);
                    break;
                }
                case 3: {
                    this.start.set(2, startp - 1);
                    this.end.set(2, endp - 1);
                    break;
                }
                case 4: {
                    this.start.set(2, startp * 3 - 1);
                    this.end.set(2, endp * 3 - 1);
                    break;
                }
                case 5: {
                    this.start.set(2, startp * 6 - 1);
                    this.end.set(2, endp * 6 - 1);
                }
            }
        }
    }

    public boolean hasNext() {
        if (this.isMergeByFiscalPeriod()) {
            if (this.iter == null) {
                return false;
            }
            return this.iter.hasNext();
        }
        return !this.start.after(this.end);
    }

    public boolean isMergeByFiscalPeriod() {
        return FiscalPeriodHelper.isMergeByFiscalPeriod(this.isMergeByFiscalPeriod, RptPeriodTypeEnum.getEnum((int)this.periodType)) && this.periodCollection != null;
    }

    public SimplePeriod next() {
        if (this.isMergeByFiscalPeriod()) {
            if (this.iter == null) {
                return null;
            }
            int[] yearAndPeriod = (int[])this.iter.next();
            return new SimplePeriod(yearAndPeriod[0], yearAndPeriod[1], this.periodType, this.periodCollection, this.isMergeByFiscalPeriod);
        }
        int p = 0;
        int y = this.start.get(1);
        switch (this.periodType) {
            case 6: {
                p = 1;
                SimplePeriod rs = new SimplePeriod(this.start.get(1), p, this.periodType, this.periodCollection, this.isMergeByFiscalPeriod);
                this.start.add(1, 1);
                return rs;
            }
            case 1: {
                p = this.start.get(6);
                this.start.add(6, 1);
                break;
            }
            case 2: {
                p = this.start.get(3);
                this.start.add(3, 1);
                break;
            }
            case 3: {
                p = this.start.get(2) + 1;
                this.start.add(2, 1);
                break;
            }
            case 4: {
                p = (this.start.get(2) + 1) / 3;
                this.start.add(2, 3);
                break;
            }
            case 5: {
                p = (this.start.get(2) + 1) / 6;
                this.start.add(2, 6);
            }
        }
        return new SimplePeriod(y, p, this.periodType, this.periodCollection, this.isMergeByFiscalPeriod);
    }

    public static void main(String[] args) {
    }
}

