/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.netctrl.ObjectUpdateLock;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportCalculatorFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICSLReportCalculator;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.MnsFillOrgUnitCollection;
import com.kingdee.eas.fi.gr.cslrpt.MnsFillOrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.SumRptException;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.MnsRptCalculate;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.RptCalcHelper;
import com.kingdee.eas.fi.newrpt.IReportBatchCalculateFacade;
import com.kingdee.eas.fi.newrpt.ReportBatchCalculateFacadeFactory;
import com.kingdee.eas.fi.newrpt.samecontrol.SameControlUtil;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ReportCollection;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.Point;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jfree.util.Log;

public class CslRptCalcUtil {
    private boolean isDEBUG = true;
    private static final Logger logger = Logger.getLogger(CslRptCalcUtil.class);

    public void calculateSheets(Context ctx, Book book, CslReportInfo cslRptInfo, Map params) throws EASBizException, UIException {
        int precision = RptCalcHelper.getPrecisionByCry(ctx, cslRptInfo.getCurrency());
        if (cslRptInfo.getSourceType().equals((Object)RptSrcTypeEnum.CONSOLIDATION)) {
            this.consolidationRptCalculate(ctx, book, cslRptInfo, precision);
        } else if (cslRptInfo.getSourceType().equals((Object)RptSrcTypeEnum.MANUSCRIPT)) {
            MnsRptCalculate msnRptCalculate = new MnsRptCalculate(ctx);
            msnRptCalculate.setSupportCrossMerger(false);
            msnRptCalculate.setCslRptInfo(cslRptInfo);
            msnRptCalculate.setBook(book);
            msnRptCalculate.setCalcType(0);
            Integer relating = params.get("dataElementRelating") == null ? Integer.valueOf(-1) : (Integer)params.get("dataElementRelating");
            msnRptCalculate.setDataElementRelating(relating);
            msnRptCalculate.setSupportHandElim(false);
            msnRptCalculate.setIncludeUnAuditElim(false);
            try {
                msnRptCalculate.prepareCalculate();
                msnRptCalculate.calculate();
                msnRptCalculate.afterCalculate();
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void consolidationRptCalculate(Context ctx, Book book, CslReportInfo cslRptInfo, int precision) throws EASBizException {
        HashMap<String, Sheet> tables = new HashMap<String, Sheet>();
        HashMap<String, Serializable> tableFormulas = new HashMap<String, Serializable>();
        tableFormulas.put("isCalcCslBeginByCurPeriod", Boolean.valueOf(SameControlUtil.getBookVariable((Book)book, (String)"isCalcCslBeginByCurPeriod")));
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            if (!sheet.isEnableCalculation()) continue;
            tables.put(sheet.getID(), sheet);
            HashMap cellFormula = CslRptCalcUtil.constructTableMap(sheet);
            tableFormulas.put(sheet.getID(), cellFormula);
        }
        if (tableFormulas.size() > 0) {
            ICSLReportCalculator calculator = null;
            try {
                calculator = ctx == null ? CSLReportCalculatorFactory.getRemoteInstance() : CSLReportCalculatorFactory.getLocalInstance(ctx);
                Map sumResult = calculator.calculateCSLReport((IObjectPK)new ObjectUuidPK(cslRptInfo.getId()), tableFormulas);
                boolean isRoundingByPrecision = Boolean.valueOf(ParamManager.getParamValue((Context)ctx, null, (String)"GR_CSL_RoundingByPrecision"));
                CslRptCalcUtil.refreshTableData(tables, sumResult, precision, isRoundingByPrecision);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (SumRptException e) {
                logger.error((Object)e.getMessage(), (Throwable)((Object)e));
            }
        }
    }

    public static HashMap constructTableMap(Sheet sheet) {
        if (sheet == null) {
            return null;
        }
        HashMap<Point, ItemFormula> result = new HashMap<Point, ItemFormula>();
        int rowCount = sheet.getMaxRowIndex() + 1;
        int colCount = sheet.getMaxColIndex() + 1;
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < colCount; ++columnIndex) {
                ItemFormula curFormula = (ItemFormula)sheet.getRange(rowIndex, columnIndex).getUserObject("ITEM");
                if (curFormula == null || !curFormula.isValidity()) continue;
                curFormula.setCell(null);
                Point position = new Point(columnIndex, rowIndex);
                result.put(position, curFormula);
            }
        }
        return result;
    }

    public static void refreshTableData(Map sheets, Map sheetData, int precision, boolean isRoundingByPrecision) {
        RptCalcHelper.refreshTableData(sheets, sheetData, precision, isRoundingByPrecision);
    }

    public static MutexParameter setMutexParameter(Uuid uuid, String mutextName, MutexLockType lockType) {
        MutexParameter param = new MutexParameter();
        param.setRequestId(uuid);
        param.setMutexName(mutextName);
        param.setMutexLockType(lockType);
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkMutexLock(Context ctx, Component objectUI, String objectId) {
        IMutexServiceControl mutexService = null;
        boolean tag = true;
        try {
            mutexService = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
            tag = mutexService.requestObjIDForUpdate(objectId);
        }
        catch (Exception ex) {
            Log.error((Object)ex.getMessage(), (Exception)ex);
        }
        finally {
            if (tag) {
                mutexService.releaseObjIDForUpdate(objectId);
            }
        }
        if (!tag) {
            MsgBox.showError((Component)objectUI, (String)RptUtil.getReportResource((String)"Error_Request_ObjectUpdateLock"));
            SysUtil.abort();
        }
    }

    public static void batchCheckMutexLock(Component objectUI, List idList, boolean isCslRpt, boolean isConfirm) {
        CslRptCalcUtil.batchCheckMutexLock(objectUI, idList, isCslRpt, isConfirm, true);
    }

    public static void batchCheckMutexLock(Component objectUI, List idList, boolean isCslRpt, boolean isConfirm, boolean isShowNumber) {
        IReportBatchCalculateFacade irptFacade = null;
        String detailMsg = "";
        List noMutexList = new ArrayList();
        try {
            irptFacade = ReportBatchCalculateFacadeFactory.getRemoteInstance();
            noMutexList = irptFacade.batchRequestMutexIDForUpdate(idList);
            if (noMutexList.size() == 0) {
                return;
            }
            detailMsg = CslRptCalcUtil.getDetailMsgByListID(noMutexList, isCslRpt, isShowNumber);
        }
        catch (EASBizException e) {
            Log.error((Object)"", (Exception)((Object)e));
        }
        catch (BOSException e) {
            Log.error((Object)"", (Exception)((Object)e));
        }
        if (isConfirm) {
            if (MsgBox.showConfirm3a((String)CslRptUtil.getStringWithFormatCR("batchCalc_mutex_exit_hint", new Object[]{new Integer(noMutexList.size())}), (String)(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"mutex_object_locked") + detailMsg)) == 2) {
                SysUtil.abort();
            } else {
                idList.removeAll(noMutexList);
            }
        } else {
            MsgBox.showDetailAndOK((Component)objectUI, (String)CslRptUtil.getStringWithFormatCR("batchCalc_mutex_exit_hint", new Object[]{new Integer(noMutexList.size())}), (String)(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"mutex_object_locked") + detailMsg), (int)1);
            SysUtil.abort();
        }
    }

    public static void batchCheckMutexLock(Component objectUI, List idList) {
        String rptName = null;
        String userNumber = null;
        String cslrptID = null;
        try {
            cslrptID = idList.get(0).toString();
            IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
            String dcName = SysContext.getSysContext().getDcName() != null ? SysContext.getSysContext().getDcName() : "";
            ObjectUpdateLock exist = mutexServiceControl.requestObjIDForUpdate2(cslrptID, SysContext.getSysContext().getUserName(), dcName);
            if (exist != null && exist.getUserName() != null) {
                userNumber = exist.getUserName();
            }
            if (userNumber == null) {
                return;
            }
            rptName = CslRptCalcUtil.getDetailMsgByID(cslrptID);
        }
        catch (BOSException e) {
            Log.error((Object)"", (Exception)((Object)e));
        }
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"468_UserMutexOpen"), rptName, userNumber)).append("\n");
        if (MsgBox.showConfirm2((String)errorMsg.toString()) != 0) {
            SysUtil.abort();
        }
    }

    public static String getDetailMsgByListID(List idList, boolean isCslRpt) throws BOSException {
        return CslRptCalcUtil.getDetailMsgByListID(idList, isCslRpt, true);
    }

    public static String getDetailMsgByID(String id) throws BOSException {
        String rptName;
        block0: {
            StringBuffer detailMsg = new StringBuffer("\n");
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("Name"));
            view.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
            view.setFilter(filter);
            ICslReport report = null;
            report = CslReportFactory.getRemoteInstance();
            CslReportCollection reportColl = report.getCslReportCollection(view);
            rptName = null;
            int i = 0;
            if (i >= reportColl.size()) break block0;
            CslReportInfo info = reportColl.get(i);
            rptName = info.getName();
        }
        return rptName;
    }

    public static String getDetailMsgByListID(List idList, boolean isCslRpt, boolean isShowNumber) throws BOSException {
        HashSet idSet = new HashSet(idList);
        StringBuffer detailMsg = new StringBuffer("\n");
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("Name"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        if (isCslRpt) {
            ICslReport report = null;
            report = CslReportFactory.getRemoteInstance();
            CslReportCollection reportColl = report.getCslReportCollection(view);
            for (int i = 0; i < reportColl.size(); ++i) {
                detailMsg = isShowNumber ? detailMsg.append(reportColl.get(i).getNumber()).append(":") : detailMsg;
                detailMsg.append(reportColl.get(i).getName()).append("\n");
            }
        } else {
            IReport report = null;
            report = ReportFactory.getRemoteInstance();
            ReportCollection reportColl = report.getReportCollection(view);
            for (int i = 0; i < reportColl.size(); ++i) {
                detailMsg = isShowNumber ? detailMsg.append(reportColl.get(i).getNumber()).append(":") : detailMsg;
                detailMsg.append(reportColl.get(i).getName()).append("\n");
            }
        }
        return detailMsg.toString();
    }

    public static void initMnsFillOrgUnitCol(Context ctx, MnsFillOrgUnitCollection fillOrgUnitColl, Date date) throws Exception {
        if (fillOrgUnitColl == null || fillOrgUnitColl.size() <= 0 || date == null) {
            return;
        }
        HashMap treeNumber_unionNumbers = new HashMap();
        MnsFillOrgUnitInfo info = null;
        String orgTreeNumber = null;
        Set unionNumbers = null;
        for (int i = 0; i < fillOrgUnitColl.size(); ++i) {
            info = fillOrgUnitColl.get(i);
            orgTreeNumber = info.getOrgTreeInfo().getNumber();
            unionNumbers = (HashSet<String>)treeNumber_unionNumbers.get(orgTreeNumber);
            if (unionNumbers == null) {
                unionNumbers = new HashSet<String>();
                treeNumber_unionNumbers.put(orgTreeNumber, unionNumbers);
            }
            if (!info.getFullOrgUnitInfo().isIsUnion()) continue;
            unionNumbers.add(info.getFullOrgUnitInfo().getNumber());
        }
        if (!treeNumber_unionNumbers.isEmpty()) {
            StringBuffer sql = new StringBuffer();
            sql.append(" select tree.number,tree.id ,unit.number,unit.id ");
            sql.append(" where unit.isunion=1 and (");
            int i = 0;
            for (String curOrgTreeNumber : treeNumber_unionNumbers.keySet()) {
                if (i > 0) {
                    sql.append(" or ");
                }
                sql.append(" (");
                sql.append(" tree.number='").append(curOrgTreeNumber).append("' ");
                unionNumbers = (Set)treeNumber_unionNumbers.get(curOrgTreeNumber);
                if (!unionNumbers.isEmpty()) {
                    sql.append(" and unit.number in(").append(CslRptUtil.changeIdSet2String(unionNumbers)).append(")");
                } else {
                    sql.append(" and parent.id is null ");
                }
                sql.append(" ) ");
                ++i;
            }
            sql.append(" ) ");
            treeNumber_unionNumbers.clear();
            String ksqlDate = new StringBuffer().append("{ts'").append(DateTimeUtils.getYear((Date)date)).append("-").append(DateTimeUtils.getMonth((Date)date)).append("-").append(DateTimeUtils.getDay((Date)date)).append(" 00:00:00'}").toString();
            sql.append(" and ((tree.status=").append(2).append(" and tree.startDate<= ");
            sql.append(ksqlDate).append(" and tree.endDate>= ").append(ksqlDate);
            sql.append(") or (tree.status=").append(1);
            sql.append(" and tree.startDate<=").append(ksqlDate).append("))");
            try {
                HashMap<String, HashMap<String, String>> tree_unitMap = new HashMap<String, HashMap<String, String>>();
                HashMap<String, String> treeMap = new HashMap<String, String>();
                Map unitMap = null;
                OrgStructureCollection coll = (ctx == null ? OrgStructureFactory.getRemoteInstance() : OrgStructureFactory.getLocalInstance((Context)ctx)).getOrgStructureCollection(sql.toString());
                OrgStructureInfo structInfo = null;
                for (int m = 0; m < coll.size(); ++m) {
                    structInfo = coll.get(m);
                    treeMap.put(structInfo.getTree().getNumber(), structInfo.getTree().getId().toString());
                    unitMap = (HashMap<String, String>)tree_unitMap.get(structInfo.getTree().getNumber());
                    if (unitMap == null) {
                        unitMap = new HashMap<String, String>();
                        tree_unitMap.put(structInfo.getTree().getNumber(), (HashMap<String, String>)unitMap);
                    }
                    unitMap.put(structInfo.getUnit().getNumber(), structInfo.getUnit().getId().toString());
                }
                if (!treeMap.isEmpty()) {
                    String treeId = null;
                    String unitId = null;
                    for (int n = 0; n < fillOrgUnitColl.size(); ++n) {
                        info = fillOrgUnitColl.get(n);
                        treeId = (String)treeMap.get(info.getOrgTreeInfo().getNumber());
                        if (!StringUtils.isEmpty((String)treeId)) {
                            info.getOrgTreeInfo().setId(BOSUuid.read((String)treeId));
                        }
                        if (!info.getFullOrgUnitInfo().isIsUnion() || (unitMap = (Map)tree_unitMap.get(info.getOrgTreeInfo().getNumber())) == null || unitMap.isEmpty() || StringUtils.isEmpty((String)(unitId = (String)unitMap.get(info.getFullOrgUnitInfo().getNumber())))) continue;
                        info.getFullOrgUnitInfo().setId(BOSUuid.read((String)unitId));
                    }
                }
                treeMap.clear();
                tree_unitMap.clear();
            }
            catch (Exception e) {
                logger.error((Object)"initFillOrgUnitCol error", (Throwable)e);
                throw e;
            }
        }
    }
}

