/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.util.client.EASResource;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Map;

public class DataUpdateHelper {
    public static void UpdateData(Map param) throws BOSException, EASBizException {
        DataUpdateHelper.UpdateDynaReportItemdata((ArrayList)param.get("dynaitemdata"));
    }

    public static void UpdateDynaReportItemdata(ArrayList lst) throws BOSException, EASBizException {
        CslReportInfo cslreportinfo = null;
        ICslReport csl = CslReportFactory.getRemoteInstance();
        if (lst == null || lst.size() < 1) {
            return;
        }
        int size = lst.size();
        for (int i = 0; i < size; ++i) {
            ObjectUuidPK pk = new ObjectUuidPK((String)lst.get(i));
            cslreportinfo = csl.getCslReportInfo((IObjectPK)pk);
            if (!cslreportinfo.getReportSourceType().equals((Object)RptSrcTypeEnum.DYNAMICNORMALREPORT) && !cslreportinfo.getReportSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) && !cslreportinfo.getReportSourceType().equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT)) continue;
            Book book = null;
            ReportVariables vs = null;
            try {
                book = cslreportinfo.getBook();
                vs = (ReportVariables)book.getUserObjectValue("VARIABLES");
            }
            catch (Exception e) {
                throw new BOSException(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"740_DataUpdateHelper"), (Throwable)e);
            }
            int size2 = book.getSheetCount();
            for (int j = 0; j < size2; ++j) {
                DateFormat df2;
                RptSheetParamInfo p = new RptSheetParamInfo();
                Sheet sheet = book.getSheet(j);
                String sheetName = sheet.getSheetName();
                p.setSheetID(sheet.getID());
                p.setSheetName(sheetName);
                p.setStartYear(vs.getIntValue("StartYear", sheetName, 0));
                p.setEndYear(vs.getIntValue("EndYear", sheetName, 0));
                p.setStartPeriod(vs.getIntValue("StartPeriod", sheetName, 0));
                p.setEndPeriod(vs.getIntValue("EndPeriod", sheetName, 0));
                if (vs.getStringValue("StartDate", sheetName) != null) {
                    try {
                        df2 = DateFormat.getDateInstance();
                        p.setStartDate(df2.parse(vs.getStringValue("StartDate", sheetName)));
                    }
                    catch (Exception df2) {
                        // empty catch block
                    }
                }
                if (vs.getStringValue("EndDate", sheetName) != null) {
                    try {
                        df2 = DateFormat.getDateInstance();
                        p.setEndDate(df2.parse(vs.getStringValue("EndDate", sheetName)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                p.setIsIncludingUnposted(vs.getBoolValue("IncludePosted", sheetName, false));
                p.setReportClass(CSLReportGroupEnum.getEnum(vs.getIntValue("SheetClass", sheet.getSheetName(), 1)));
                p.setRelaType(ReportTypeEnum.CSLREPORT);
                cslreportinfo.getSheetParam().add(p);
            }
            csl.update((IObjectPK)pk, cslreportinfo, false);
        }
    }
}

