/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.IOrgTreePeriod;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.OrgTreePeriodCollection;
import com.kingdee.eas.fi.gr.cslrpt.OrgTreePeriodFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RptPeriodException;
import com.kingdee.eas.fi.gr.cslrpt.UnionVersionUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.newrpt.MultOrgUnitHelper;
import com.kingdee.eas.fi.newrpt.OrgUnitConvtHelper;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class FiscalPeriodHelper {
    private static final Logger logger = Logger.getLogger(FiscalPeriodHelper.class);
    public static final int[] EMPTY_YEAR_AND_PERIOD = new int[]{-1, -1};
    public static final int[] YearSpineRange = new int[]{1900, 2999};

    private FiscalPeriodHelper() {
    }

    private static void init(boolean isMergeByFiscalPeriod, KDComboBox comboPeriodType, KDSpinner spnYear, KDSpinner spnPeriod, KDDatePicker pkRptDate, Map fiscalPeriodInfo) {
        if (!isMergeByFiscalPeriod) {
            return;
        }
        Map yearMap = (Map)fiscalPeriodInfo.get("yearMap");
        if (yearMap.isEmpty()) {
            return;
        }
        Object[] array = yearMap.keySet().toArray();
        Arrays.sort(array);
        CslRptUIUtil.setSpineRange(spnYear, (Integer)array[0], (Integer)array[array.length - 1]);
        FiscalPeriodHelper.refreshFields(comboPeriodType, spnYear, spnPeriod, pkRptDate);
        FiscalPeriodHelper.refreshPeriod(isMergeByFiscalPeriod, comboPeriodType, spnYear, spnPeriod, pkRptDate, fiscalPeriodInfo);
        FiscalPeriodHelper.refreshRptDate(isMergeByFiscalPeriod, comboPeriodType, spnYear, spnPeriod, pkRptDate, fiscalPeriodInfo);
    }

    private static void refreshFields(KDComboBox comboPeriodType, KDSpinner spnYear, KDSpinner spnPeriod, KDDatePicker pkRptDate) {
        RptPeriodTypeEnum periodTypeEnum = (RptPeriodTypeEnum)comboPeriodType.getSelectedItem();
        if (periodTypeEnum == null || periodTypeEnum.equals((Object)RptPeriodTypeEnum.DAILY) || periodTypeEnum.equals((Object)RptPeriodTypeEnum.WEEKLY)) {
            spnYear.setEnabled(false);
            spnPeriod.setEnabled(false);
            pkRptDate.setEnabled(true);
        } else {
            spnYear.setEnabled(true);
            spnPeriod.setEnabled(true);
            pkRptDate.setEnabled(false);
        }
    }

    private static void refreshPeriod(boolean isMergeByFiscalPeriod, KDComboBox comboPeriodType, KDSpinner spnYear, KDSpinner spnPeriod, KDDatePicker pkRptDate, Map fiscalPeriodInfo) {
        if (isMergeByFiscalPeriod) {
            RptPeriodTypeEnum periodTypeEnum = (RptPeriodTypeEnum)comboPeriodType.getSelectedItem();
            if (!FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, periodTypeEnum)) {
                return;
            }
            Integer year = FiscalPeriodHelper.resetSpnYearValue(spnYear, fiscalPeriodInfo);
            Map yearMap = (Map)fiscalPeriodInfo.get("yearMap");
            Object period = spnPeriod.getValue();
            int maxPeriod = 0;
            int minPeriod = 0;
            if (periodTypeEnum.equals((Object)RptPeriodTypeEnum.MONTHLY)) {
                List periodList = (List)yearMap.get(year);
                minPeriod = (Integer)periodList.get(0);
                maxPeriod = (Integer)periodList.get(periodList.size() - 1);
            }
            if (periodTypeEnum.equals((Object)RptPeriodTypeEnum.QUARTERLY)) {
                Map year_quarterMap = (Map)fiscalPeriodInfo.get("year_quarterMap");
                List quarterList = (List)year_quarterMap.get(year);
                minPeriod = (Integer)quarterList.get(0);
                maxPeriod = (Integer)quarterList.get(quarterList.size() - 1);
            }
            if (periodTypeEnum.equals((Object)RptPeriodTypeEnum.SEMIYEARLY)) {
                minPeriod = 1;
                maxPeriod = 2;
            }
            if (periodTypeEnum.equals((Object)RptPeriodTypeEnum.YEARLY)) {
                minPeriod = 1;
                maxPeriod = 1;
            }
            CslRptUIUtil.setSpineRange(spnPeriod, minPeriod, maxPeriod);
            if ((Integer)period > maxPeriod) {
                spnPeriod.setValue((Object)new Integer(maxPeriod));
            } else {
                spnPeriod.setValue(period);
            }
            if ((Integer)period == minPeriod) {
                FiscalPeriodHelper.refreshRptDate(isMergeByFiscalPeriod, comboPeriodType, spnYear, spnPeriod, pkRptDate, fiscalPeriodInfo);
            }
        }
    }

    private static Integer resetSpnYearValue(KDSpinner spnYear, Map fiscalPeriodInfo) {
        Map yearMap = (Map)fiscalPeriodInfo.get("yearMap");
        if (yearMap.isEmpty()) {
            return (Integer)spnYear.getValue();
        }
        Object[] array = yearMap.keySet().toArray();
        Arrays.sort(array);
        if ((Integer)spnYear.getValue() > (Integer)array[array.length - 1]) {
            spnYear.setValue(array[array.length - 1]);
            return (Integer)array[array.length - 1];
        }
        if ((Integer)spnYear.getValue() < (Integer)array[0]) {
            return (Integer)array[0];
        }
        return (Integer)spnYear.getValue();
    }

    private static void refreshRptDate(boolean isMergeByFiscalPeriod, KDComboBox comboPeriodType, KDSpinner spnYear, KDSpinner spnPeriod, KDDatePicker pkRptDate, Map fiscalPeriodInfo) {
        if (isMergeByFiscalPeriod) {
            List monthdateList;
            RptPeriodTypeEnum periodTypeEnum = (RptPeriodTypeEnum)comboPeriodType.getSelectedItem();
            if (!FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, periodTypeEnum)) {
                return;
            }
            Integer year = FiscalPeriodHelper.resetSpnYearValue(spnYear, fiscalPeriodInfo);
            Map yearMap = (Map)fiscalPeriodInfo.get("yearMap");
            Map monthEndDateMap = (Map)fiscalPeriodInfo.get("monthEndDateMap");
            Map quarterEndDateMap = (Map)fiscalPeriodInfo.get("quarterEndDateMap");
            if (periodTypeEnum.equals((Object)RptPeriodTypeEnum.MONTHLY)) {
                List periodList = (List)yearMap.get(year);
                List monthdateList2 = (List)monthEndDateMap.get(year);
                for (int i = 0; i < periodList.size(); ++i) {
                    if (!periodList.get(i).equals(spnPeriod.getValue())) continue;
                    pkRptDate.setValue(monthdateList2.get(i));
                }
            }
            if (periodTypeEnum.equals((Object)RptPeriodTypeEnum.QUARTERLY)) {
                pkRptDate.setValue(quarterEndDateMap.get(year + "-" + spnPeriod.getValue()));
            }
            if (periodTypeEnum.equals((Object)RptPeriodTypeEnum.SEMIYEARLY)) {
                if (spnPeriod.getValue().equals(new Integer(1))) {
                    pkRptDate.setValue(quarterEndDateMap.get(year + "-2"));
                }
                if (spnPeriod.getValue().equals(new Integer(2))) {
                    monthdateList = (List)monthEndDateMap.get(year);
                    pkRptDate.setValue(monthdateList.get(monthdateList.size() - 1));
                }
            }
            if (periodTypeEnum.equals((Object)RptPeriodTypeEnum.YEARLY)) {
                monthdateList = (List)monthEndDateMap.get(year);
                pkRptDate.setValue(monthdateList.get(monthdateList.size() - 1));
            }
        }
    }

    public static void refreshAndAddListeners(final boolean isMergeByFiscalPeriod, final KDComboBox comboPeriodType, final KDSpinner spnYear, final KDSpinner spnPeriod, final KDDatePicker pkRptDate, PeriodCollection periodCollection) {
        if (!isMergeByFiscalPeriod) {
            return;
        }
        final Map fiscalPeriodInfo = FiscalPeriodHelper.getFiscalPeriodInfo(periodCollection);
        FiscalPeriodHelper.init(isMergeByFiscalPeriod, comboPeriodType, spnYear, spnPeriod, pkRptDate, fiscalPeriodInfo);
        comboPeriodType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FiscalPeriodHelper.refreshFields(comboPeriodType, spnYear, spnPeriod, pkRptDate);
                FiscalPeriodHelper.refreshPeriod(isMergeByFiscalPeriod, comboPeriodType, spnYear, spnPeriod, pkRptDate, fiscalPeriodInfo);
            }
        });
        spnYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FiscalPeriodHelper.refreshPeriod(isMergeByFiscalPeriod, comboPeriodType, spnYear, spnPeriod, pkRptDate, fiscalPeriodInfo);
            }
        });
        spnPeriod.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FiscalPeriodHelper.refreshRptDate(isMergeByFiscalPeriod, comboPeriodType, spnYear, spnPeriod, pkRptDate, fiscalPeriodInfo);
            }
        });
    }

    public static boolean isMergeByFiscalPeriod(Context ctx) {
        return CslRptUtil.isMergeByFiscalPeriod(ctx);
    }

    public static boolean isMergeByFiscalPeriod(boolean isMergeByFiscalPeriod, RptPeriodTypeEnum periodTypeEnum) {
        if (isMergeByFiscalPeriod) {
            return periodTypeEnum != null && !periodTypeEnum.equals((Object)RptPeriodTypeEnum.DAILY) && !periodTypeEnum.equals((Object)RptPeriodTypeEnum.WEEKLY);
        }
        return false;
    }

    public static Map getFiscalPeriodInfo(PeriodCollection periodCollection) {
        HashMap<Integer, ArrayList<Integer>> yearMap = new HashMap<Integer, ArrayList<Integer>>();
        HashMap<Integer, ArrayList<Date>> monthEndDateMap = new HashMap<Integer, ArrayList<Date>>();
        HashMap<Integer, ArrayList<Date>> monthBeginDateMap = new HashMap<Integer, ArrayList<Date>>();
        HashMap<String, Date> quarterEndDateMap = new HashMap<String, Date>();
        HashMap<String, Date> quarterBeginDateMap = new HashMap<String, Date>();
        HashMap<Integer, ArrayList<Integer>> year_quarterMap = new HashMap<Integer, ArrayList<Integer>>();
        if (periodCollection != null && periodCollection.size() > 0) {
            for (int i = 0; i < periodCollection.size(); ++i) {
                int year = periodCollection.get(i).getPeriodYear();
                int period = periodCollection.get(i).getPeriodNumber();
                int quarter = periodCollection.get(i).getPeriodQuarter();
                Date beginDate = periodCollection.get(i).getBeginDate();
                Date endDate = new Date(periodCollection.get(i).getEndDate().getTime());
                ArrayList<Integer> periodList = (ArrayList<Integer>)yearMap.get(new Integer(year));
                ArrayList<Integer> quarterList = (ArrayList<Integer>)year_quarterMap.get(new Integer(year));
                if (periodList == null) {
                    periodList = new ArrayList<Integer>(12);
                    quarterList = new ArrayList<Integer>(12);
                    yearMap.put(new Integer(year), periodList);
                    year_quarterMap.put(new Integer(year), quarterList);
                }
                periodList.add(new Integer(period));
                quarterList.add(new Integer(quarter));
                ArrayList<Date> endDateList = (ArrayList<Date>)monthEndDateMap.get(new Integer(year));
                if (endDateList == null) {
                    endDateList = new ArrayList<Date>(12);
                    monthEndDateMap.put(new Integer(year), endDateList);
                }
                endDateList.add(endDate);
                ArrayList<Date> beginDateList = (ArrayList<Date>)monthBeginDateMap.get(new Integer(year));
                if (beginDateList == null) {
                    beginDateList = new ArrayList<Date>(12);
                    monthBeginDateMap.put(new Integer(year), beginDateList);
                }
                beginDateList.add(beginDate);
                quarterEndDateMap.put(year + "-" + quarter, endDate);
                if (quarterBeginDateMap.get(year + "-" + quarter) != null) continue;
                quarterBeginDateMap.put(year + "-" + quarter, beginDate);
            }
        }
        HashMap<String, HashMap<Object, Cloneable>> returnMap = new HashMap<String, HashMap<Object, Cloneable>>(8);
        returnMap.put("yearMap", yearMap);
        returnMap.put("monthEndDateMap", monthEndDateMap);
        returnMap.put("quarterEndDateMap", quarterEndDateMap);
        returnMap.put("monthBeginDateMap", monthBeginDateMap);
        returnMap.put("quarterBeginDateMap", quarterBeginDateMap);
        returnMap.put("year_quarterMap", year_quarterMap);
        return returnMap;
    }

    public static void setSpineRangeByPeriodType(KDSpinner sp, RptPeriodTypeEnum periodTypeEnum) {
        FiscalPeriodHelper.setSpineRangeByPeriodType(sp, periodTypeEnum, true, false);
    }

    public static void setSpineRangeByPeriodType(KDSpinner sp, RptPeriodTypeEnum periodTypeEnum, boolean isReset) {
        FiscalPeriodHelper.setSpineRangeByPeriodType(sp, periodTypeEnum, isReset, true);
    }

    public static void setSpineRangeByPeriodType(KDSpinner sp, RptPeriodTypeEnum periodTypeEnum, boolean isResetVal, boolean isRemoveChangeListener) {
        if (periodTypeEnum == null) {
            return;
        }
        int minVal = 0;
        int maxVal = 366;
        switch (periodTypeEnum.getValue()) {
            case 3: {
                minVal = 1;
                maxVal = 99;
                break;
            }
            case 4: {
                minVal = 1;
                maxVal = 9;
                break;
            }
            case 5: {
                minVal = 1;
                maxVal = 2;
                break;
            }
            case 6: {
                minVal = 1;
                maxVal = 1;
                break;
            }
        }
        CslRptUIUtil.setSpineRange(sp, minVal, maxVal, isResetVal, isRemoveChangeListener);
    }

    public static void setPeriodSpineRangeNoFiscalPeriod(KDSpinner sp, RptPeriodTypeEnum periodTypeEnum, boolean isResetVal, boolean isMergeFiscalPeriod) {
        FiscalPeriodHelper.setPeriodSpineRangeNoFiscalPeriod(sp, periodTypeEnum, isResetVal, isMergeFiscalPeriod, false);
    }

    public static void setPeriodSpineRangeNoFiscalPeriod(KDSpinner sp, RptPeriodTypeEnum periodTypeEnum, boolean isResetVal, boolean isMergeFiscalPeriod, boolean isRemoveChangeListener) {
        if (periodTypeEnum == null) {
            return;
        }
        int minVal = 0;
        int maxVal = 366;
        switch (periodTypeEnum.getValue()) {
            case 3: {
                minVal = 1;
                maxVal = 12;
                if (!isMergeFiscalPeriod) break;
                maxVal = 13;
                break;
            }
            case 4: {
                minVal = 1;
                maxVal = 4;
                break;
            }
            case 5: {
                minVal = 1;
                maxVal = 2;
                break;
            }
            case 6: {
                minVal = 1;
                maxVal = 1;
                break;
            }
        }
        CslRptUIUtil.setSpineRange(sp, minVal, maxVal, isResetVal, isRemoveChangeListener);
    }

    public static Date getPrePeriodLastDayByDate(Date date, RptPeriodTypeEnum periodType, PeriodCollection periodCollection, boolean isMergeByFiscalPeriod) {
        if (!FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, periodType) || periodCollection == null) {
            return RPTDateUtil.getPrePeriodLastDayByDate(date, periodType);
        }
        int[] year_period = FiscalPeriodHelper.getPeriod(date, periodType, periodCollection, isMergeByFiscalPeriod);
        int[] preYear_period = FiscalPeriodHelper.getPrevYearAndPeriod(periodCollection, year_period[0], year_period[1], periodType, isMergeByFiscalPeriod, false);
        return FiscalPeriodHelper.getPeriodLastDate(periodCollection, preYear_period[0], preYear_period[1], periodType, isMergeByFiscalPeriod);
    }

    public static int[] getPerYearAndPeriod(int year, int period, RptPeriodTypeEnum periodType, PeriodCollection periodCollection, boolean isMergeByFiscalPeriod, boolean isSupport13Period) {
        if (!FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, periodType) || periodCollection == null) {
            if (isSupport13Period) {
                return RPTDate13Util.getPreYearAndPeriod(year, period, periodType, isSupport13Period);
            }
            return RPTDateUtil.getPrevYearAndPeriod(year, period, periodType);
        }
        Map fiscalPeriodInfo = FiscalPeriodHelper.getFiscalPeriodInfo(periodCollection);
        Map yearMap = (Map)fiscalPeriodInfo.get("yearMap");
        Map monthBeginDateMap = (Map)fiscalPeriodInfo.get("monthBeginDateMap");
        Map year_quarterMap = (Map)fiscalPeriodInfo.get("year_quarterMap");
        Object[] yearArray = monthBeginDateMap.keySet().toArray();
        Arrays.sort(yearArray);
        if (periodType.equals((Object)RptPeriodTypeEnum.MONTHLY)) {
            if (period == 1 && year == (Integer)yearArray[0]) {
                return null;
            }
            if (period == 1) {
                List periodList = (List)yearMap.get(new Integer(year - 1));
                if (periodList == null || periodList.isEmpty()) {
                    return EMPTY_YEAR_AND_PERIOD;
                }
                return new int[]{year - 1, (Integer)periodList.get(periodList.size() - 1)};
            }
            return new int[]{year, period - 1};
        }
        if (periodType.equals((Object)RptPeriodTypeEnum.QUARTERLY)) {
            if (period == 1 && year == (Integer)yearArray[0]) {
                return null;
            }
            if (period == 1) {
                List quarterList = (List)year_quarterMap.get(new Integer(year - 1));
                if (quarterList == null || quarterList.isEmpty()) {
                    return EMPTY_YEAR_AND_PERIOD;
                }
                int maxQuarter = (Integer)quarterList.get(quarterList.size() - 1);
                return new int[]{year - 1, maxQuarter};
            }
            return new int[]{year, period - 1};
        }
        if (periodType.equals((Object)RptPeriodTypeEnum.SEMIYEARLY)) {
            if (period == 1 && year == (Integer)yearArray[0]) {
                return null;
            }
            if (period == 1) {
                return new int[]{year - 1, 2};
            }
            return new int[]{year, 1};
        }
        if (periodType.equals((Object)RptPeriodTypeEnum.YEARLY)) {
            if (year == (Integer)yearArray[0]) {
                return null;
            }
            return new int[]{year - 1, 1};
        }
        return null;
    }

    public static Date getPeriodFirstDate(int year, int period, RptPeriodTypeEnum periodType, PeriodCollection periodCollection, boolean isMergeByFiscalPeriod) {
        if (periodCollection == null || !FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, periodType)) {
            return RPTDateUtil.getPeriodFirstDate(year, period, periodType);
        }
        Map FiscalPeriodInfo = FiscalPeriodHelper.getFiscalPeriodInfo(periodCollection);
        if (periodType.equals((Object)RptPeriodTypeEnum.MONTHLY)) {
            int position = -1;
            Map yearMap = (Map)FiscalPeriodInfo.get("yearMap");
            List periodList = (List)yearMap.get(new Integer(year));
            for (int i = 0; periodList != null && i < periodList.size(); ++i) {
                if (period != (Integer)periodList.get(i)) continue;
                position = i;
                break;
            }
            if (position == -1) {
                return null;
            }
            Map monthBeginDateMap = (Map)FiscalPeriodInfo.get("monthBeginDateMap");
            return (Date)((List)monthBeginDateMap.get(new Integer(year))).get(position);
        }
        if (periodType.equals((Object)RptPeriodTypeEnum.QUARTERLY)) {
            Map quarterBeginDateMap = (Map)FiscalPeriodInfo.get("quarterBeginDateMap");
            return (Date)quarterBeginDateMap.get(year + "-" + period);
        }
        if (periodType.equals((Object)RptPeriodTypeEnum.SEMIYEARLY)) {
            Map quarterBeginDateMap = (Map)FiscalPeriodInfo.get("quarterBeginDateMap");
            if (period == 2) {
                return (Date)quarterBeginDateMap.get(year + "-3");
            }
            return (Date)quarterBeginDateMap.get(year + "-1");
        }
        if (periodType.equals((Object)RptPeriodTypeEnum.YEARLY)) {
            Map quarterBeginDateMap = (Map)FiscalPeriodInfo.get("quarterBeginDateMap");
            return (Date)quarterBeginDateMap.get(year + "-1");
        }
        return null;
    }

    public static PeriodTypeInfo getPeriodTypeByOrgTree(Context ctx, OrgTreeInfo tree) throws EASBizException, BOSException {
        OrgTreePeriodCollection OrgTreePeriods;
        OrgTreeInfo orgTree;
        IOrgTree orgTreeInterface;
        IOrgTreePeriod orgTreePeriodInterface;
        if (tree == null || tree.getNumber() == null && tree.getId() == null) {
            return null;
        }
        if (ctx == null) {
            orgTreePeriodInterface = OrgTreePeriodFactory.getRemoteInstance();
            orgTreeInterface = OrgTreeFactory.getRemoteInstance();
        } else {
            orgTreePeriodInterface = OrgTreePeriodFactory.getLocalInstance(ctx);
            orgTreeInterface = OrgTreeFactory.getLocalInstance((Context)ctx);
        }
        String orgTreeNumber = null;
        if (!StringUtils.isEmpty((String)tree.getNumber())) {
            orgTreeNumber = tree.getNumber();
        }
        if (StringUtils.isEmpty(orgTreeNumber) && tree.getId() != null && (orgTree = orgTreeInterface.getOrgTreeInfo("select number where id='" + tree.getId().toString() + "'")) != null) {
            orgTreeNumber = orgTree.getNumber();
        }
        if (!StringUtils.isEmpty((String)orgTreeNumber) && (OrgTreePeriods = orgTreePeriodInterface.getOrgTreePeriodCollection("select periodType.* where orgTree.number='" + orgTreeNumber + "'")).size() > 0) {
            return OrgTreePeriods.get(0).getPeriodType();
        }
        return null;
    }

    public static PeriodCollection getPeriodCollection(Context ctx, ReportBaseInfo info) throws BOSException, EASBizException {
        if (info == null) {
            return null;
        }
        if (info instanceof CslReportInfo) {
            RptSrcTypeEnum rptType = info.getSourceType();
            if (rptType != null) {
                if (rptType.equals((Object)RptSrcTypeEnum.CONSOLIDATION) || rptType.equals((Object)RptSrcTypeEnum.SUM) || rptType.equals((Object)RptSrcTypeEnum.CONSOLIDATION_FASTMERGE) || rptType.equals((Object)RptSrcTypeEnum.SUM_FASTMERGE) || rptType.equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT) || rptType.equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) || rptType.equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE) || rptType.equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT_FASTMERGE) || rptType.equals((Object)RptSrcTypeEnum.MANUSCRIPT_FASTMERGE) || rptType.equals((Object)RptSrcTypeEnum.MULTIDYNAMICSUMREPORT) || rptType.equals((Object)RptSrcTypeEnum.MULTIDYNAMICCSLREPORT) || rptType.equals((Object)RptSrcTypeEnum.MANUSCRIPT) || rptType.equals((Object)RptSrcTypeEnum.SUM_FASTMERGE)) {
                    OrgTreeInfo orgTree = info.getOrgTree();
                    if (orgTree != null) {
                        return FiscalPeriodHelper.getPeriodCollection(ctx, orgTree);
                    }
                } else {
                    CompanyOrgUnitInfo company = OrgUnitConvtHelper.convtFullToCompanyNotRemote((FullOrgUnitInfo)info.getCompany());
                    if (company != null) {
                        return FiscalPeriodHelper.getPeriodCollection(ctx, company.getId().toString());
                    }
                    OrgTreeInfo orgTree = info.getOrgTree();
                    if (orgTree != null) {
                        return FiscalPeriodHelper.getPeriodCollection(ctx, orgTree);
                    }
                }
            }
        } else {
            CompanyOrgUnitInfo company = OrgUnitConvtHelper.convtFullToCompanyNotRemote((FullOrgUnitInfo)info.getCompany());
            if (company != null) {
                return FiscalPeriodHelper.getPeriodCollection(ctx, company.getId().toString());
            }
        }
        return null;
    }

    public static PeriodCollection getPeriodCollection(Context ctx, OrgTreeInfo tree) throws BOSException, EASBizException {
        PeriodTypeInfo periodType = FiscalPeriodHelper.getPeriodTypeByOrgTree(ctx, tree);
        return FiscalPeriodHelper.getPeriodCollection(ctx, periodType);
    }

    public static PeriodCollection getPeriodCollection(Context ctx, String CompanyId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo;
        if (!StringUtils.isEmpty((String)CompanyId) && (companyInfo = MultOrgUnitHelper.getInstance().getDelegateCompany(OrgType.NONE, CompanyId, ctx)) != null && companyInfo.getAccountPeriodType() != null) {
            return FiscalPeriodHelper.getPeriodCollection(ctx, companyInfo.getAccountPeriodType());
        }
        return null;
    }

    public static PeriodCollection getPeriodCollection(Context ctx, PeriodTypeInfo periodType) throws BOSException, EASBizException {
        if (periodType != null) {
            IPeriod periodInteface = ctx != null ? PeriodFactory.getLocalInstance((Context)ctx) : PeriodFactory.getRemoteInstance();
            return periodInteface.getPeriodCollection("select * where periodType.id='" + periodType.getId().toString() + "' order by periodYear,periodNumber asc");
        }
        return null;
    }

    public static Map getPeriodCollectionsByOrgTreeNumbers(Context ctx, List orgTreeNumbers) throws BOSException, EASBizException {
        HashMap orgTreeNumber_periods = new HashMap();
        if (orgTreeNumbers != null && orgTreeNumbers.size() > 0) {
            StringBuffer sb = new StringBuffer();
            Iterator itr = orgTreeNumbers.iterator();
            while (itr.hasNext()) {
                sb.append("'").append(itr.next().toString()).append("',");
            }
            sb.deleteCharAt(sb.lastIndexOf(","));
            IOrgTreePeriod orgTreePeriodInterface = ctx == null ? OrgTreePeriodFactory.getRemoteInstance() : OrgTreePeriodFactory.getLocalInstance(ctx);
            OrgTreePeriodCollection OrgTreePeriods = orgTreePeriodInterface.getOrgTreePeriodCollection("select periodType.id,orgTree.number where orgTree.number in (" + sb.toString() + ")");
            HashMap<String, String> orgTreeNumber_periodType = new HashMap<String, String>();
            ArrayList<String> periodTypeIds = new ArrayList<String>();
            String orgTreeNumber2 = null;
            String periodTypeId = null;
            for (int i = 0; i < OrgTreePeriods.size(); ++i) {
                orgTreeNumber2 = OrgTreePeriods.get(i).getOrgTree().getNumber();
                periodTypeId = OrgTreePeriods.get(i).getPeriodType().getId().toString();
                orgTreeNumber_periodType.put(orgTreeNumber2, periodTypeId);
                if (periodTypeIds.contains(periodTypeId)) continue;
                periodTypeIds.add(periodTypeId);
            }
            Map periodCollections = FiscalPeriodHelper.getPeriodCollectionsByPeriodTypeIds(ctx, periodTypeIds);
            for (String orgTreeNumber2 : orgTreeNumber_periodType.keySet()) {
                periodTypeId = (String)orgTreeNumber_periodType.get(orgTreeNumber2);
                if (!periodCollections.containsKey(periodTypeId)) continue;
                orgTreeNumber_periods.put(orgTreeNumber2, periodCollections.get(periodTypeId));
            }
        }
        return orgTreeNumber_periods;
    }

    public static Map getPeriodCollectionsByCompanyIds(Context ctx, List companyIds) throws BOSException, EASBizException {
        return FiscalPeriodHelper.getPeriodCollectionsByCompanyIds(ctx, companyIds, false);
    }

    public static Map getPeriodCollectionsByCompanyIds(Context ctx, List companyIds, boolean ifNullRetAll) throws BOSException, EASBizException {
        boolean companyIsNull;
        HashMap companyId_periods = new HashMap();
        boolean bl = companyIsNull = companyIds == null || companyIds.isEmpty();
        if (!ifNullRetAll && companyIsNull) {
            return companyId_periods;
        }
        ICompanyOrgUnit iCompanyOrgUnit = null;
        iCompanyOrgUnit = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        StringBuffer whereExpr = new StringBuffer();
        if (!companyIsNull) {
            whereExpr.append(" where id in( ");
            Iterator itr = companyIds.iterator();
            while (itr.hasNext()) {
                whereExpr.append("'").append(itr.next().toString()).append("',");
            }
            whereExpr.deleteCharAt(whereExpr.lastIndexOf(","));
            whereExpr.append(" ) ");
        }
        CompanyOrgUnitCollection companyInfos = iCompanyOrgUnit.getCompanyOrgUnitCollection("select id,accountPeriodType.id " + whereExpr);
        HashMap<String, String> companyId_periodTypeId = new HashMap<String, String>();
        ArrayList<String> PeriodTyperIds = new ArrayList<String>();
        CompanyOrgUnitInfo companyInfo2 = null;
        String companyId2 = null;
        String periodTypeId = null;
        for (CompanyOrgUnitInfo companyInfo2 : companyInfos) {
            companyId2 = companyInfo2.getId().toString();
            periodTypeId = companyInfo2.getAccountPeriodType().getId().toString();
            companyId_periodTypeId.put(companyId2, periodTypeId);
            if (PeriodTyperIds.contains(periodTypeId)) continue;
            PeriodTyperIds.add(periodTypeId);
        }
        Map periodCollections = FiscalPeriodHelper.getPeriodCollectionsByPeriodTypeIds(ctx, PeriodTyperIds);
        for (String companyId2 : companyId_periodTypeId.keySet()) {
            periodTypeId = (String)companyId_periodTypeId.get(companyId2);
            if (!periodCollections.containsKey(periodTypeId)) continue;
            companyId_periods.put(companyId2, periodCollections.get(periodTypeId));
        }
        return companyId_periods;
    }

    public static Map getPeriodCollectionsByPeriodTypeIds(Context ctx, List periodTypeIds) throws BOSException, EASBizException {
        HashMap<String, PeriodCollection> periodType_periods = new HashMap<String, PeriodCollection>();
        if (periodTypeIds != null && periodTypeIds.size() > 0) {
            IPeriod periodInteface = ctx != null ? PeriodFactory.getLocalInstance((Context)ctx) : PeriodFactory.getRemoteInstance();
            StringBuffer sb = new StringBuffer();
            Iterator itr = periodTypeIds.iterator();
            while (itr.hasNext()) {
                sb.append("'").append(itr.next().toString()).append("',");
            }
            sb.deleteCharAt(sb.lastIndexOf(","));
            PeriodCollection periods = periodInteface.getPeriodCollection("select * where periodType.id in (" + sb.toString() + ") order by periodYear,periodNumber asc");
            PeriodInfo periodInfo = null;
            String periodTypeId = null;
            PeriodCollection curPeriods = null;
            for (int i = 0; i < periods.size(); ++i) {
                periodInfo = periods.get(i);
                periodTypeId = periodInfo.getPeriodType().getId().toString();
                if (!periodType_periods.containsKey(periodTypeId)) {
                    curPeriods = new PeriodCollection();
                    periodType_periods.put(periodTypeId, curPeriods);
                }
                curPeriods = (PeriodCollection)periodType_periods.get(periodTypeId);
                curPeriods.add(periodInfo);
            }
        }
        return periodType_periods;
    }

    public static void setYearSpineRange(OrgTreeInfo orgTree, KDSpinner spCurYear) throws Exception {
        FiscalPeriodHelper.setYearSpineRange(orgTree, spCurYear, true);
    }

    public static void setYearSpineRange(OrgTreeInfo orgTree, KDSpinner spCurYear, boolean isReset) throws Exception {
        if (orgTree != null) {
            PeriodCollection periods = FiscalPeriodHelper.getPeriodCollection(null, orgTree);
            FiscalPeriodHelper.setYearSpineRange(periods, spCurYear, isReset);
        }
    }

    public static void setYearSpineRange(PeriodCollection periods, KDSpinner spCurYear, boolean isReset) throws Exception {
        FiscalPeriodHelper.setYearSpineRange(periods, spCurYear, isReset, false);
    }

    public static void setYearSpineRange(PeriodCollection periods, KDSpinner spCurYear, boolean isReset, boolean isRemoveChangeListener) throws Exception {
        if (periods != null) {
            Map periodInfo = FiscalPeriodHelper.getFiscalPeriodInfo(periods);
            if (periodInfo.containsKey("yearMap")) {
                Map yearMap = (Map)periodInfo.get("yearMap");
                Object[] values = yearMap.keySet().toArray();
                Arrays.sort(values);
                CslRptUIUtil.setSpineRange(spCurYear, (Integer)values[0], (Integer)values[values.length - 1], isReset, isRemoveChangeListener);
            }
        } else {
            CslRptUIUtil.setSpineRange(spCurYear, 1900, 2999, isReset, isRemoveChangeListener);
        }
    }

    public static void setPeriodSpineRange(OrgTreeInfo orgTree, int year, RptPeriodTypeEnum periodTypeEnum, KDSpinner spCurPeriod) throws Exception {
        FiscalPeriodHelper.setPeriodSpineRange(orgTree, year, periodTypeEnum, spCurPeriod, true);
    }

    public static void setPeriodSpineRange(OrgTreeInfo orgTree, int year, RptPeriodTypeEnum periodTypeEnum, KDSpinner spCurPeriod, boolean isReset) throws Exception {
        if (orgTree != null && periodTypeEnum != null) {
            PeriodCollection periods = FiscalPeriodHelper.getPeriodCollection(null, orgTree);
            FiscalPeriodHelper.setPeriodSpineRange(periods, year, periodTypeEnum, spCurPeriod, isReset, true);
        }
    }

    public static void setPeriodSpineRange(PeriodCollection periods, int year, RptPeriodTypeEnum periodTypeEnum, KDSpinner spCurPeriod, boolean isReset, boolean isMergeFiscalPeriod) throws Exception {
        FiscalPeriodHelper.setPeriodSpineRange(periods, year, periodTypeEnum, spCurPeriod, isReset, isMergeFiscalPeriod, false);
    }

    public static void setPeriodSpineRange(PeriodCollection periods, int year, RptPeriodTypeEnum periodTypeEnum, KDSpinner spCurPeriod, boolean isReset, boolean isMergeFiscalPeriod, boolean isRemoveChangeListener) throws Exception {
        if (periods != null) {
            Map periodInfo = FiscalPeriodHelper.getFiscalPeriodInfo(periods);
            if (periodTypeEnum.equals((Object)RptPeriodTypeEnum.MONTHLY)) {
                Integer tmpYear;
                Map yearMap;
                if (periodInfo.containsKey("yearMap") && (yearMap = (Map)periodInfo.get("yearMap")).containsKey(tmpYear = new Integer(year))) {
                    Object[] periodList = ((ArrayList)yearMap.get(tmpYear)).toArray();
                    Arrays.sort(periodList);
                    CslRptUIUtil.setSpineRange(spCurPeriod, (Integer)periodList[0], (Integer)periodList[periodList.length - 1], isReset, isRemoveChangeListener);
                }
            } else if (periodTypeEnum.equals((Object)RptPeriodTypeEnum.QUARTERLY)) {
                Integer tmpYear;
                Map year_quarterMap;
                if (periodInfo.containsKey("year_quarterMap") && (year_quarterMap = (Map)periodInfo.get("year_quarterMap")).containsKey(tmpYear = new Integer(year))) {
                    Object[] periodList = ((ArrayList)year_quarterMap.get(tmpYear)).toArray();
                    Arrays.sort(periodList);
                    CslRptUIUtil.setSpineRange(spCurPeriod, (Integer)periodList[0], (Integer)periodList[periodList.length - 1], isReset, isRemoveChangeListener);
                }
            } else if (periodTypeEnum.equals((Object)RptPeriodTypeEnum.SEMIYEARLY)) {
                CslRptUIUtil.setSpineRange(spCurPeriod, 1, 2, isReset, isRemoveChangeListener);
            } else if (periodTypeEnum.equals((Object)RptPeriodTypeEnum.YEARLY)) {
                CslRptUIUtil.setSpineRange(spCurPeriod, 1, 1, isReset, isRemoveChangeListener);
            }
        } else {
            FiscalPeriodHelper.setPeriodSpineRangeNoFiscalPeriod(spCurPeriod, periodTypeEnum, isReset, isMergeFiscalPeriod, isRemoveChangeListener);
        }
    }

    public static Date getRptDate(OrgTreeInfo orgTree, int year, int period, RptPeriodTypeEnum periodTypeEnum, boolean isMergeByFiscalPeriod) throws Exception {
        if (periodTypeEnum != null && !FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, periodTypeEnum)) {
            return RPTDateUtil.getPeriodLastDate(year, period, periodTypeEnum);
        }
        if (orgTree != null && periodTypeEnum != null) {
            PeriodCollection periods = FiscalPeriodHelper.getPeriodCollection(null, orgTree);
            FiscalPeriodHelper.getRptDate(periods, year, period, periodTypeEnum, isMergeByFiscalPeriod);
        }
        return null;
    }

    public static Date getRptDate(PeriodCollection periods, int year, int period, RptPeriodTypeEnum periodTypeEnum, boolean isMergeByFiscalPeriod) throws Exception {
        if (periods != null) {
            return FiscalPeriodHelper.getPeriodLastDate(periods, year, period, periodTypeEnum, isMergeByFiscalPeriod);
        }
        return RPTDateUtil.getPeriodLastDate(year, period, periodTypeEnum);
    }

    public static Date getRptLastDate(OrgTreeInfo orgTree, int year, int period, RptPeriodTypeEnum periodTypeEnum, boolean isMergeByFiscalPeriod, Context serverCtx) throws Exception {
        if (periodTypeEnum != null && !FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, periodTypeEnum)) {
            return RPTDateUtil.getPeriodLastDate(year, period, periodTypeEnum);
        }
        if (orgTree != null && periodTypeEnum != null) {
            PeriodCollection periods = FiscalPeriodHelper.getPeriodCollection(serverCtx, orgTree);
            if (periods != null) {
                return FiscalPeriodHelper.getPeriodLastDate(periods, year, period, periodTypeEnum, isMergeByFiscalPeriod);
            }
            return RPTDateUtil.getPeriodLastDate(year, period, periodTypeEnum);
        }
        return null;
    }

    public static Date getRptLastDate(String orgTreeId, int year, int period, RptPeriodTypeEnum periodType, Context serverCtx) throws BOSException, EASBizException {
        IOrgTree orgTreeInterface = null;
        orgTreeInterface = serverCtx == null ? OrgTreeFactory.getRemoteInstance() : OrgTreeFactory.getLocalInstance((Context)serverCtx);
        OrgTreeInfo orgTreeInfo = orgTreeInterface.getOrgTreeInfo("where id = '" + orgTreeId + "'");
        return FiscalPeriodHelper.getRptLastDate(orgTreeInfo, year, period, periodType, serverCtx);
    }

    public static Date getRptLastDate(OrgTreeInfo orgTree, int year, int period, RptPeriodTypeEnum periodType, Context serverCtx) {
        boolean isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod(serverCtx);
        try {
            return FiscalPeriodHelper.getRptLastDate(orgTree, year, period, periodType, isMergeByFiscalPeriod, serverCtx);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            return RPTDateUtil.getPeriodLastDate(year, period, periodType);
        }
    }

    public static Date getPeriodLastDate(PeriodCollection periods, int year, int period, RptPeriodTypeEnum periodTypeEnum, boolean isMergeByFiscalPeriod) {
        if (periodTypeEnum != null) {
            if (!FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, periodTypeEnum)) {
                return RPTDate13Util.getPeriodLastDate(year, period, periodTypeEnum);
            }
            if (periods != null) {
                Map monthEndDate;
                Map periodInfo = FiscalPeriodHelper.getFiscalPeriodInfo(periods);
                if (periodTypeEnum.equals((Object)RptPeriodTypeEnum.MONTHLY)) {
                    ArrayList endDates;
                    Map monthEndDate2;
                    if (periodInfo.containsKey("monthEndDateMap") && (monthEndDate2 = (Map)periodInfo.get("monthEndDateMap")).containsKey(new Integer(year)) && (endDates = (ArrayList)monthEndDate2.get(new Integer(year))).size() >= period) {
                        return (Date)endDates.get(period - 1);
                    }
                } else if (periodTypeEnum.equals((Object)RptPeriodTypeEnum.QUARTERLY)) {
                    String yearPeriod;
                    Map monthEndDate3;
                    if (periodInfo.containsKey("quarterEndDateMap") && (monthEndDate3 = (Map)periodInfo.get("quarterEndDateMap")).containsKey(yearPeriod = year + "-" + period)) {
                        return (Date)monthEndDate3.get(yearPeriod);
                    }
                } else if (periodTypeEnum.equals((Object)RptPeriodTypeEnum.SEMIYEARLY)) {
                    if (period == 1) {
                        Map quarterEndDateMap = (Map)periodInfo.get("quarterEndDateMap");
                        return (Date)quarterEndDateMap.get(year + "-2");
                    }
                    if (period == 2) {
                        Map monthEndDateMap = (Map)periodInfo.get("monthEndDateMap");
                        List monthdateList = (List)monthEndDateMap.get(new Integer(year));
                        if (monthdateList == null || monthdateList.size() <= 0) {
                            return null;
                        }
                        return (Date)monthdateList.get(monthdateList.size() - 1);
                    }
                } else if (periodTypeEnum.equals((Object)RptPeriodTypeEnum.YEARLY) && periodInfo.containsKey("monthEndDateMap") && (monthEndDate = (Map)periodInfo.get("monthEndDateMap")).containsKey(new Integer(year))) {
                    ArrayList endDates = (ArrayList)monthEndDate.get(new Integer(year));
                    return (Date)endDates.get(endDates.size() - 1);
                }
            } else {
                return RPTDate13Util.getPeriodLastDate(year, period, periodTypeEnum);
            }
        }
        return null;
    }

    public static int[] getPeriod(Context ctx, Date date, RptPeriodTypeEnum periodTypeEnum, OrgTreeInfo orgTree, boolean isMergeByFiscalPeriod) throws Exception {
        if (periodTypeEnum == null || date == null) {
            return null;
        }
        if (orgTree != null && FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, periodTypeEnum)) {
            PeriodCollection periods = FiscalPeriodHelper.getPeriodCollection(ctx, orgTree);
            return FiscalPeriodHelper.getPeriod(date, periodTypeEnum, periods, isMergeByFiscalPeriod);
        }
        return RPTDateUtil.getPeriod(date, periodTypeEnum);
    }

    public static int[] getPeriod(Date date, RptPeriodTypeEnum periodTypeEnum, PeriodCollection periods, boolean isMergeByFiscalPeriod) {
        if (periodTypeEnum == null || date == null) {
            return null;
        }
        if (FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, periodTypeEnum) && periods != null) {
            PeriodInfo periosInfo = null;
            for (int i = 0; i < periods.size(); ++i) {
                periosInfo = periods.get(i);
                if (periosInfo.getBeginDate().compareTo(date) > 0 || periosInfo.getEndDate().compareTo(new Timestamp(date.getTime())) < 0) continue;
                if (periodTypeEnum.equals((Object)RptPeriodTypeEnum.MONTHLY)) {
                    return new int[]{periosInfo.getPeriodYear(), periosInfo.getPeriodNumber()};
                }
                if (periodTypeEnum.equals((Object)RptPeriodTypeEnum.QUARTERLY)) {
                    return new int[]{periosInfo.getPeriodYear(), periosInfo.getPeriodQuarter()};
                }
                if (periodTypeEnum.equals((Object)RptPeriodTypeEnum.YEARLY)) {
                    return new int[]{periosInfo.getPeriodYear(), 1};
                }
                if (!periodTypeEnum.equals((Object)RptPeriodTypeEnum.SEMIYEARLY)) continue;
                if (periosInfo.getPeriodQuarter() > 2) {
                    return new int[]{periosInfo.getPeriodYear(), 2};
                }
                return new int[]{periosInfo.getPeriodYear(), 1};
            }
        }
        return RPTDateUtil.getPeriod(date, periodTypeEnum);
    }

    public static List getYearAndPeriodList(PeriodCollection periodCollection, boolean isMergeByFiscalPeriod, int startYear, int endYear, int startPeriod, int endPeriod, RptPeriodTypeEnum periodType) {
        int temp;
        if (periodCollection == null || !FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, periodType)) {
            return null;
        }
        int size = periodCollection.size();
        int minYear = periodCollection.get(0).getPeriodYear();
        int maxYear = periodCollection.get(size - 1).getPeriodYear();
        if (startYear > endYear) {
            temp = endYear;
            endYear = startYear;
            startYear = temp;
        }
        if (startYear > maxYear || endYear < minYear) {
            return null;
        }
        if (startYear == endYear && startPeriod > endPeriod) {
            temp = endPeriod;
            endPeriod = startPeriod;
            startPeriod = temp;
        }
        if (startYear < minYear) {
            startYear = minYear;
            startPeriod = 1;
        }
        int n = endYear = endYear > maxYear ? maxYear : endYear;
        if (periodType.equals((Object)RptPeriodTypeEnum.MONTHLY)) {
            ArrayList<int[]> result = new ArrayList<int[]>((endYear - startYear + 1) * 12);
            for (int m = 0; m < size; ++m) {
                int year = periodCollection.get(m).getPeriodYear();
                int period = periodCollection.get(m).getPeriodNumber();
                if (startYear == endYear) {
                    if (year != startYear || period < startPeriod || period > endPeriod) continue;
                    result.add(new int[]{year, period});
                    continue;
                }
                if (year == startYear && period >= startPeriod) {
                    result.add(new int[]{year, period});
                    continue;
                }
                if (year == endYear && period <= endPeriod) {
                    result.add(new int[]{year, period});
                    continue;
                }
                if (year <= startYear || year >= endYear) continue;
                result.add(new int[]{year, period});
            }
            return result;
        }
        if (periodType.equals((Object)RptPeriodTypeEnum.QUARTERLY)) {
            ArrayList<int[]> result = new ArrayList<int[]>((endYear - startYear + 1) * 4);
            int[] preValue = new int[]{-1, -1};
            boolean flag = false;
            for (int m = 0; m < size; ++m) {
                int year = periodCollection.get(m).getPeriodYear();
                int quarter = periodCollection.get(m).getPeriodQuarter();
                if (startYear == endYear) {
                    if (year == startYear && quarter >= startPeriod && quarter <= endPeriod) {
                        flag = true;
                    }
                } else if (year == startYear && quarter >= startPeriod) {
                    flag = true;
                } else if (year == endYear && quarter <= endPeriod) {
                    flag = true;
                } else if (year > startYear && year < endYear) {
                    flag = true;
                }
                if (!flag) continue;
                flag = false;
                if (year == preValue[0] && quarter == preValue[1]) continue;
                preValue[0] = year;
                preValue[1] = quarter;
                result.add(new int[]{year, quarter});
            }
            return result;
        }
        if (periodType.equals((Object)RptPeriodTypeEnum.SEMIYEARLY)) {
            ArrayList<int[]> result = new ArrayList<int[]>((endYear - startYear + 1) * 2);
            for (int j = startYear; j <= endYear; ++j) {
                if (startYear == endYear) {
                    if (startPeriod > 2 || endPeriod < 1) continue;
                    if (startPeriod == 1) {
                        result.add(new int[]{j, 1});
                    }
                    if (endPeriod != 2) continue;
                    result.add(new int[]{j, 2});
                    continue;
                }
                if (j == startYear) {
                    if (startPeriod == 1) {
                        result.add(new int[]{j, 1});
                    }
                    result.add(new int[]{j, 2});
                    continue;
                }
                if (j == endYear) {
                    result.add(new int[]{j, 1});
                    if (endPeriod != 2) continue;
                    result.add(new int[]{j, 2});
                    continue;
                }
                if (j <= startYear || j >= endYear) continue;
                result.add(new int[]{j, 1});
                result.add(new int[]{j, 2});
            }
            return result;
        }
        if (periodType.equals((Object)RptPeriodTypeEnum.YEARLY)) {
            ArrayList<int[]> result = new ArrayList<int[]>(endYear - startYear + 1);
            int j = startYear;
            while (j <= endYear) {
                result.add(new int[]{j++, 1});
            }
            return result;
        }
        return null;
    }

    public static int[] getRptYearAndPeriod(PeriodCollection periods, int RptYear, int RptPeriod, int RptPeriodType, int offsetYear, int offsetPeriod, boolean isMergeByFiscalPeriod) {
        if (periods == null || !FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, RptPeriodTypeEnum.getEnum((int)RptPeriodType))) {
            if (periods == null && RptPeriod == 13 && isMergeByFiscalPeriod && 3 == RptPeriodType) {
                return RPTDate13Util.getRptYearAndPeriod(RptYear, RptPeriod, RptPeriodType, offsetYear, offsetPeriod, true);
            }
            return RPTDateUtil.getRptYearAndPeriod(RptYear, RptPeriod, RptPeriodType, offsetYear, offsetPeriod);
        }
        return FiscalPeriodHelper.getRptFormualYearAndPeriod(periods, RptYear, RptPeriod, RptPeriodType, offsetYear, offsetPeriod, isMergeByFiscalPeriod);
    }

    public static int[] getRptFormualYearAndPeriod(PeriodCollection periods, int RptYear, int RptPeriod, int RptPeriodType, int offsetYear, int offsetPeriod, boolean isMergeByFiscalPeriod) {
        return FiscalPeriodHelper.getRptFormualYearAndPeriod(false, periods, RptYear, RptPeriod, RptPeriodType, offsetYear, offsetPeriod, isMergeByFiscalPeriod);
    }

    public static int[] getRptFormualYearAndPeriod(boolean isSupport13Period, PeriodCollection periods, int RptYear, int RptPeriod, int RptPeriodType, int offsetYear, int offsetPeriod, boolean isMergeByFiscalPeriod) {
        int year = RptYear + offsetYear;
        int period = RptPeriod + offsetPeriod;
        if (offsetPeriod > 0) {
            period -= RptPeriod;
        }
        if (offsetYear > 1000) {
            year -= RptYear;
        }
        if (period <= 0) {
            if (periods != null && FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, RptPeriodTypeEnum.getEnum((int)RptPeriodType))) {
                --year;
                Map periodInfo = FiscalPeriodHelper.getFiscalPeriodInfo(periods);
                if (RptPeriodTypeEnum.getEnum((int)RptPeriodType).equals((Object)RptPeriodTypeEnum.MONTHLY)) {
                    if (periodInfo.containsKey("yearMap")) {
                        Map yearMap = (Map)periodInfo.get("yearMap");
                        if (yearMap.containsKey(new Integer(year))) {
                            Object[] periosList = ((ArrayList)yearMap.get(new Integer(year))).toArray();
                            Arrays.sort(periosList);
                            period += ((Integer)periosList[periosList.length - 1]).intValue();
                        } else {
                            period = 0;
                        }
                    } else {
                        period = 0;
                    }
                } else if (RptPeriodTypeEnum.getEnum((int)RptPeriodType).equals((Object)RptPeriodTypeEnum.QUARTERLY)) {
                    if (periodInfo.containsKey("year_quarterMap")) {
                        Map yearQuarter = (Map)periodInfo.get("year_quarterMap");
                        if (yearQuarter.containsKey(new Integer(year))) {
                            Object[] periosList = ((ArrayList)yearQuarter.get(new Integer(year))).toArray();
                            Arrays.sort(periosList);
                            period += ((Integer)periosList[periosList.length - 1]).intValue();
                        } else {
                            period = 0;
                        }
                    } else {
                        period = 0;
                    }
                } else if (RptPeriodTypeEnum.getEnum((int)RptPeriodType).equals((Object)RptPeriodTypeEnum.SEMIYEARLY)) {
                    period += 2;
                } else if (RptPeriodType == 6) {
                    period = 1;
                }
            } else {
                if (isSupport13Period) {
                    return RPTDate13Util.getRptYearAndPeriod(RptYear, RptPeriod, RptPeriodType, offsetYear, offsetPeriod, isSupport13Period);
                }
                return RPTDateUtil.getRptYearAndPeriod(RptYear, RptPeriod, RptPeriodType, offsetYear, offsetPeriod);
            }
        }
        return new int[]{year, period};
    }

    public static Map getOrgTreeByPeriods(Context ctx, PeriodCollection periods, String orgTreeNumber, int iStartYear, int iEndYear, int iStartPeriod, int iEndPeriod, int iPeriodType, boolean isMergeByFiscalPeriod, boolean isSupport13Period, String orgTreeName) throws EASBizException, BOSException {
        return FiscalPeriodHelper.getOrgTreeByPeriods(ctx, periods, orgTreeNumber, iStartYear, iEndYear, iStartPeriod, iEndPeriod, iPeriodType, isMergeByFiscalPeriod, isSupport13Period, orgTreeName, false);
    }

    public static Map getOrgTreeByPeriods(Context ctx, PeriodCollection periods, String orgTreeNumber, int iStartYear, int iEndYear, int iStartPeriod, int iEndPeriod, int iPeriodType, boolean isMergeByFiscalPeriod, boolean isSupport13Period, String orgTreeName, boolean isConvt) throws EASBizException, BOSException {
        if (periods == null || !FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, RptPeriodTypeEnum.getEnum((int)iPeriodType))) {
            if (iPeriodType == 3) {
                int bigPeriod;
                int wholeYearPeriodNum = 12;
                if (isMergeByFiscalPeriod || isSupport13Period) {
                    wholeYearPeriodNum = 13;
                }
                if (iStartPeriod > wholeYearPeriodNum) {
                    bigPeriod = iStartPeriod;
                    iStartPeriod = bigPeriod % wholeYearPeriodNum;
                    iStartYear += bigPeriod / wholeYearPeriodNum;
                }
                if (iEndPeriod > wholeYearPeriodNum) {
                    bigPeriod = iEndPeriod;
                    iEndPeriod = bigPeriod % wholeYearPeriodNum;
                    iEndYear += bigPeriod / wholeYearPeriodNum;
                }
            }
            if (!StringUtils.isEmpty((String)orgTreeName)) {
                return UnionVersionUtil.getOrgTreeByPeriods(ctx, orgTreeNumber, iStartYear, iEndYear, iStartPeriod, iEndPeriod, iPeriodType, orgTreeName, isConvt);
            }
            return UnionVersionUtil.getOrgTreeByPeriods(ctx, orgTreeNumber, iStartYear, iEndYear, iStartPeriod, iEndPeriod, iPeriodType, null, isConvt);
        }
        RptPeriodTypeEnum curPeriodType = RptPeriodTypeEnum.getEnum((int)iPeriodType);
        IOrgTree orgTree = null;
        orgTree = ctx == null ? OrgTreeFactory.getRemoteInstance() : OrgTreeFactory.getLocalInstance((Context)ctx);
        OrgTreeCollection orgTreeCL = orgTree.getOrgTreeCollection("select id,startDate,endDate where number = '" + orgTreeNumber + "' and (status=" + 2 + " or status=" + 1 + ") order by startDate desc,endDate desc");
        HashMap mapResult = new HashMap();
        if (orgTreeCL != null && orgTreeCL.size() > 0) {
            List yearAndPeriods = FiscalPeriodHelper.getYearAndPeriodList(periods, isMergeByFiscalPeriod, iStartYear, iEndYear, iStartPeriod, iEndPeriod, curPeriodType);
            if (yearAndPeriods != null) {
                block0: for (int i = yearAndPeriods.size() - 1; i >= 0; --i) {
                    int[] yearAndPeriod = (int[])yearAndPeriods.get(i);
                    Date curDate = FiscalPeriodHelper.getPeriodLastDate(periods, yearAndPeriod[0], yearAndPeriod[1], curPeriodType, isMergeByFiscalPeriod);
                    for (int j = 0; j < orgTreeCL.size(); ++j) {
                        String strOrgTreeID = orgTreeCL.get(j).getId().toString();
                        Timestamp sDate = orgTreeCL.get(j).getStartDate();
                        if (curDate == null || sDate.compareTo(new Timestamp(curDate.getTime())) > 0) continue;
                        HashMap<String, Integer> mapTemp = new HashMap<String, Integer>();
                        mapTemp.put("KEY_STARTYEAR", new Integer(yearAndPeriod[0]));
                        mapTemp.put("KEY_ENDYEAR", new Integer(yearAndPeriod[0]));
                        mapTemp.put("KEY_STARTPERIOD", new Integer(yearAndPeriod[1]));
                        mapTemp.put("KEY_ENDPERIOD", new Integer(yearAndPeriod[1]));
                        mapResult.put(strOrgTreeID, mapTemp);
                        continue block0;
                    }
                }
            }
            return mapResult;
        }
        throw new BOSException("not found orgTree!");
    }

    public static List getRptYearAndPeriodAndDate(PeriodCollection periods, int RptYear, int RptPeriod, int RptPeriodType, int offsetYear, int offsetPeriod, boolean isMergeByFiscalPeriod) {
        if (periods == null || !FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, RptPeriodTypeEnum.getEnum((int)RptPeriodType))) {
            if (periods == null && RptPeriod == 13 && isMergeByFiscalPeriod && 3 == RptPeriodType) {
                return RPTDate13Util.getRptYearAndPeriodAndDate(RptYear, RptPeriod, RptPeriodType, offsetYear, offsetPeriod, true);
            }
            return RPTDateUtil.getRptYearAndPeriodAndDate(RptYear, RptPeriod, RptPeriodType, offsetYear, offsetPeriod);
        }
        ArrayList<Comparable<Integer>> result = new ArrayList<Comparable<Integer>>();
        int[] yearAndPeriod = FiscalPeriodHelper.getRptYearAndPeriod(periods, RptYear, RptPeriod, RptPeriodType, offsetYear, offsetPeriod, isMergeByFiscalPeriod);
        Integer year = new Integer(yearAndPeriod[0]);
        Integer period = new Integer(yearAndPeriod[1]);
        Date date = FiscalPeriodHelper.getPeriodLastDate(periods, year, period, RptPeriodTypeEnum.getEnum((int)RptPeriodType), isMergeByFiscalPeriod);
        result.add(0, year);
        result.add(1, period);
        result.add(2, date);
        return result;
    }

    public static void getRptYearAndPeriod(PeriodCollection periods, ItemFormula srcFormula, int RptYear, int RptPeriod, RptPeriodTypeEnum RptPeriodType, boolean isMergeByFiscalPeriod) throws EASBizException, BOSException {
        if (srcFormula == null) {
            return;
        }
        if (periods == null || !FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, RptPeriodType)) {
            if (periods == null && RptPeriod == 13 && isMergeByFiscalPeriod && 3 == RptPeriodType.getValue()) {
                RPTDate13Util.getRptYearAndPeriod(srcFormula, RptYear, RptPeriod, RptPeriodType, true);
            } else {
                RPTDateUtil.getRptYearAndPeriod(srcFormula, RptYear, RptPeriod, RptPeriodType);
            }
        } else {
            List ls = FiscalPeriodHelper.getRptYearAndPeriodAndDate(periods, RptYear, RptPeriod, RptPeriodType.getValue(), srcFormula.getYearOffSet(), srcFormula.getPeriodOffSet(), isMergeByFiscalPeriod);
            Date t = (Date)ls.get(2);
            if (t == null) {
                throw new RptPeriodException(RptPeriodException.HASNOTFISCALPERIOD, new Object[]{ls.get(0).toString(), ls.get(1)});
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            srcFormula.putExt("10", ls.get(0).toString());
            srcFormula.putExt("11", ls.get(1).toString());
            srcFormula.putExt("12", format.format(t).toString());
        }
    }

    public static int[] getPrevYearAndPeriod(PeriodCollection periods, int iYear, int iPeriod, RptPeriodTypeEnum periodType, boolean isMergeByFiscalPeriod, boolean isSupport13Period) {
        if (periodType == null || periods == null || !FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, periodType)) {
            return RPTDate13Util.getPreYearAndPeriod(iYear, iPeriod, periodType, isSupport13Period);
        }
        return FiscalPeriodHelper.getRptYearAndPeriod(periods, iYear, iPeriod, periodType.getValue(), 0, -1, isMergeByFiscalPeriod);
    }

    public static int[] getPrevYearAndPeriod(PeriodCollection periods, int iYear, int iPeriod, RptPeriodTypeEnum periodType, boolean isMergeByFiscalPeriod, boolean isSupport13Period, boolean isCanOverPeriods) {
        if (isCanOverPeriods) {
            return FiscalPeriodHelper.getPrevYearAndPeriod(periods, iYear, iPeriod, periodType, isMergeByFiscalPeriod, isSupport13Period);
        }
        if (periodType == null || periods == null || !FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, periodType)) {
            return RPTDate13Util.getPreYearAndPeriod(iYear, iPeriod, periodType, isSupport13Period);
        }
        return FiscalPeriodHelper.getRptFormualYearAndPeriod(periods, iYear, iPeriod, periodType.getValue(), 0, -1, isMergeByFiscalPeriod, isCanOverPeriods);
    }

    public static int[] getRptFormualYearAndPeriod(PeriodCollection periods, int RptYear, int RptPeriod, int RptPeriodType, int offsetYear, int offsetPeriod, boolean isMergeByFiscalPeriod, boolean isCanOverPeriods) {
        int[] yearAndPeriod = FiscalPeriodHelper.getRptFormualYearAndPeriod(periods, RptYear, RptPeriod, RptPeriodType, offsetYear, offsetPeriod, isMergeByFiscalPeriod);
        if (isCanOverPeriods) {
            return yearAndPeriod;
        }
        if (periods == null || periods.size() == 0) {
            return null;
        }
        PeriodInfo lowPeriodInfo = periods.get(0);
        PeriodInfo largePeriodInfo = periods.get(periods.size() - 1);
        if (lowPeriodInfo.getPeriodYear() > yearAndPeriod[0] || lowPeriodInfo.getPeriodYear() == yearAndPeriod[0] && lowPeriodInfo.getPeriodNumber() > yearAndPeriod[1]) {
            return null;
        }
        if (largePeriodInfo.getPeriodYear() < yearAndPeriod[0] || largePeriodInfo.getPeriodYear() == yearAndPeriod[0] && largePeriodInfo.getPeriodNumber() < yearAndPeriod[1]) {
            return null;
        }
        return yearAndPeriod;
    }

    public static boolean isGeneratePeriod(PeriodCollection periods, int iYear, int iPeriod, RptPeriodTypeEnum periodType, boolean isMergeByFiscalPeriod) {
        if (periods == null || !FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, periodType)) {
            Date date = RPTDateUtil.getPeriodLastDate(iYear, iPeriod, periodType);
            return RPTDateUtil.isYearLastPeriod(date, periodType);
        }
        if (periodType.equals((Object)RptPeriodTypeEnum.YEARLY)) {
            return true;
        }
        if (periodType.equals((Object)RptPeriodTypeEnum.SEMIYEARLY)) {
            return iPeriod == 2;
        }
        if (periodType.equals((Object)RptPeriodTypeEnum.QUARTERLY)) {
            Map map = FiscalPeriodHelper.getFiscalPeriodInfo(periods);
            Map year_quarterMap = (Map)map.get("year_quarterMap");
            List list = (List)year_quarterMap.get(new Integer(iYear));
            return iPeriod == (Integer)list.get(list.size() - 1);
        }
        if (periodType.equals((Object)RptPeriodTypeEnum.MONTHLY)) {
            for (int i = 0; i < periods.size(); ++i) {
                int year = periods.get(i).getPeriodYear();
                int period = periods.get(i).getPeriodNumber();
                if (iYear != year || iPeriod != period) continue;
                if (i + 1 == periods.size()) {
                    return true;
                }
                if (iYear != periods.get(i + 1).getPeriodYear()) {
                    return true;
                }
                return periods.get(i + 1).isIsAdjustPeriod();
            }
        }
        return false;
    }

    public static boolean isGeneratePeriodNextPeriod(PeriodCollection periods, int iYear, int iPeriod, RptPeriodTypeEnum periodType, boolean isMergeByFiscalPeriod) {
        if (periodType.equals((Object)RptPeriodTypeEnum.MONTHLY)) {
            for (int i = 0; i < periods.size(); ++i) {
                int year = periods.get(i).getPeriodYear();
                int period = periods.get(i).getPeriodNumber();
                if (iYear != year || iPeriod != period) continue;
                if (i + 1 == periods.size()) {
                    return false;
                }
                if (iYear != periods.get(i + 1).getPeriodYear()) {
                    return false;
                }
                return periods.get(i + 1).isIsAdjustPeriod();
            }
        }
        return false;
    }

    public static Date getEndOfYear(PeriodCollection periods, int year) {
        if (periods == null) {
            return RPTDateUtil.getEndOfYear(year);
        }
        for (int i = 0; i < periods.size(); ++i) {
            if (periods.get(i).getPeriodYear() != year || i + 1 != periods.size() && (i + 1 == periods.size() || year == periods.get(i + 1).getPeriodYear())) continue;
            return periods.get(i).getEndDate();
        }
        return null;
    }

    public static Date getBeginOfYear(PeriodCollection periods, int year) {
        if (periods == null) {
            return RPTDateUtil.getBeginOfYear(year);
        }
        for (int i = 0; i < periods.size(); ++i) {
            if (periods.get(i).getPeriodYear() != year) continue;
            return periods.get(i).getBeginDate();
        }
        return null;
    }

    public static Date getBeginOfYear(PeriodCollection periods, int year, RptPeriodTypeEnum periodType, boolean isMergeByFiscalPeriod) {
        if (periods == null || !FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, periodType)) {
            return RPTDateUtil.getBeginOfYear(year);
        }
        return FiscalPeriodHelper.getBeginOfYear(periods, year);
    }

    public static boolean HaveManyOrgTreeVersion(Component comp, KDComboBox periodTypeCombo, KDSpinner startYearSpin, KDSpinner endYearSpin, KDSpinner startPeriodSpin, KDSpinner endPeriodSpin, KDComboBox cbxOrgBound, PeriodCollection periods, boolean isMergeByFiscalPeriod, boolean isSupport13Period) {
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)periodTypeCombo.getSelectedItem();
        if (periods == null || !FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, periodType)) {
            return CslRptUIUtil.HaveManyOrgTreeVersion(comp, periodTypeCombo, startYearSpin, endYearSpin, startPeriodSpin, endPeriodSpin, cbxOrgBound);
        }
        Integer startYear = (Integer)startYearSpin.getValue();
        Integer endYear = (Integer)endYearSpin.getValue();
        Integer permStartYear = null;
        Integer permEndYear = null;
        if (startYear <= endYear) {
            permStartYear = startYear;
            permEndYear = endYear;
        } else {
            permStartYear = endYear;
            permEndYear = startYear;
        }
        Integer startPeriod = (Integer)startPeriodSpin.getValue();
        Integer endPeriod = (Integer)endPeriodSpin.getValue();
        Integer permStartPeriod = null;
        Integer permEndPeriod = null;
        permStartPeriod = startPeriod;
        permEndPeriod = endPeriod;
        if (cbxOrgBound.getItemCount() != 0 && cbxOrgBound.getSelectedItem() != null) {
            OrgTreeInfo tree = (OrgTreeInfo)cbxOrgBound.getSelectedItem();
            try {
                Map mapResult = FiscalPeriodHelper.getOrgTreeByPeriods(null, periods, tree.getNumber(), permStartYear, permEndYear, permStartPeriod, permEndPeriod, periodType.getValue(), isMergeByFiscalPeriod, isSupport13Period);
                if (mapResult.size() > 1) {
                    MsgBox.showError((Component)comp, (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"391_CslRptUIUtil"));
                    return false;
                }
            }
            catch (EASBizException eASBizException) {
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
        }
        return true;
    }

    public static Map HaveManyOrgTreeVersion(RptPeriodTypeEnum periodType, KDSpinner startYearSpin, KDSpinner endYearSpin, KDSpinner startPeriodSpin, KDSpinner endPeriodSpin, OrgTreeInfo tree, PeriodCollection periods, boolean isMergeByFiscalPeriod, boolean isSupport13Period) {
        if (periods == null || !FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, periodType)) {
            return CslRptUIUtil.HaveManyOrgTreeVersion(periodType, startYearSpin, endYearSpin, startPeriodSpin, endPeriodSpin, tree);
        }
        Integer startYear = (Integer)startYearSpin.getValue();
        Integer endYear = (Integer)endYearSpin.getValue();
        Integer permStartYear = null;
        Integer permEndYear = null;
        if (startYear <= endYear) {
            permStartYear = startYear;
            permEndYear = endYear;
        } else {
            permStartYear = endYear;
            permEndYear = startYear;
        }
        Integer startPeriod = (Integer)startPeriodSpin.getValue();
        Integer endPeriod = (Integer)endPeriodSpin.getValue();
        Integer permStartPeriod = null;
        Integer permEndPeriod = null;
        permStartPeriod = startPeriod;
        permEndPeriod = endPeriod;
        Map mapResult = null;
        try {
            mapResult = FiscalPeriodHelper.getOrgTreeByPeriods(null, periods, tree.getNumber(), permStartYear, permEndYear, permStartPeriod, permEndPeriod, periodType.getValue(), isMergeByFiscalPeriod, isSupport13Period);
            if (mapResult.size() > 1) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"391_CslRptUIUtil"));
                return null;
            }
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return mapResult;
    }

    public static Map getOrgTreeByPeriods(Context ctx, PeriodCollection periods, String orgTreeNumber, int iStartYear, int iEndYear, int iStartPeriod, int iEndPeriod, int iPeriodType, boolean isMergeByFiscalPeriod, boolean isSupport13Period) throws EASBizException, BOSException {
        return FiscalPeriodHelper.getOrgTreeByPeriods(ctx, periods, orgTreeNumber, iStartYear, iEndYear, iStartPeriod, iEndPeriod, iPeriodType, isMergeByFiscalPeriod, isSupport13Period, null);
    }

    public static List getPeriodList(PeriodCollection periods, RptPeriodTypeEnum periodType, int[] yearAndPeriod, boolean isMergeByFiscalPeriod) {
        ArrayList<Integer> periodlist;
        block9: {
            Map periodInfo;
            block11: {
                Integer tmpYear;
                Map year_quarterMap;
                block10: {
                    Integer tmpYear2;
                    Map year_quarterMap2;
                    block8: {
                        periodlist = new ArrayList<Integer>();
                        if (periodType == null || !RptPeriodTypeEnum.QUARTERLY.equals((Object)periodType) && !RptPeriodTypeEnum.SEMIYEARLY.equals((Object)periodType) && !RptPeriodTypeEnum.YEARLY.equals((Object)periodType)) {
                            return periodlist;
                        }
                        if (periods != null && FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, periodType)) break block8;
                        int count = 0;
                        count = FiscalPeriodHelper.getEndDayIndexByPeriodType(yearAndPeriod[1], periodType);
                        for (int i = 0; i < count; ++i) {
                            periodlist.add(new Integer(yearAndPeriod[1] - i));
                        }
                        break block9;
                    }
                    periodInfo = FiscalPeriodHelper.getFiscalPeriodInfo(periods);
                    if (!periodType.equals((Object)RptPeriodTypeEnum.QUARTERLY)) break block10;
                    int curQuartrly = 0;
                    if (!periodInfo.containsKey("year_quarterMap") || !(year_quarterMap2 = (Map)periodInfo.get("year_quarterMap")).containsKey(tmpYear2 = new Integer(yearAndPeriod[0]))) break block9;
                    Object[] periodList = ((ArrayList)year_quarterMap2.get(tmpYear2)).toArray();
                    Arrays.sort(periodList);
                    if (yearAndPeriod[1] <= periodList.length) {
                        curQuartrly = (Integer)periodList[yearAndPeriod[1] - 1];
                        for (int i = yearAndPeriod[1] - 1; i >= 0 && (Integer)periodList[i] == curQuartrly; --i) {
                            periodlist.add(new Integer(i + 1));
                        }
                    }
                    break block9;
                }
                if (!periodType.equals((Object)RptPeriodTypeEnum.SEMIYEARLY)) break block11;
                int curQuartrly = 0;
                if (!periodInfo.containsKey("year_quarterMap") || !(year_quarterMap = (Map)periodInfo.get("year_quarterMap")).containsKey(tmpYear = new Integer(yearAndPeriod[0]))) break block9;
                Object[] periodList = ((ArrayList)year_quarterMap.get(tmpYear)).toArray();
                Arrays.sort(periodList);
                if (yearAndPeriod[1] <= periodList.length) {
                    curQuartrly = (Integer)periodList[yearAndPeriod[1] - 1];
                    int endIndex = curQuartrly > 2 ? 3 : 1;
                    for (int i = yearAndPeriod[1] - 1; i >= 0 && (Integer)periodList[i] >= endIndex; --i) {
                        periodlist.add(new Integer(i + 1));
                    }
                }
                break block9;
            }
            if (periodType.equals((Object)RptPeriodTypeEnum.YEARLY) && periodInfo.containsKey("yearMap")) {
                Map year_periodList = (Map)periodInfo.get("yearMap");
                List periodList = (List)year_periodList.get(new Integer(yearAndPeriod[0]));
                Object[] periodArray = periodList.toArray();
                Arrays.sort(periodArray);
                for (int i = 0; i < periodArray.length && (Integer)periodArray[0] <= yearAndPeriod[1]; ++i) {
                    periodlist.add((Integer)periodArray[0]);
                }
            }
        }
        return periodlist;
    }

    public static int[] getYearAndPeriod(PeriodCollection periods, Date date, RptPeriodTypeEnum periodType, boolean isMergeByFiscalPeriod) {
        if (!FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, periodType) || periods == null) {
            return RPTDateUtil.getPeriod(date, periodType);
        }
        PeriodInfo periodInfo = null;
        for (int i = 0; i <= periods.size(); ++i) {
            periodInfo = periods.get(i);
            if (periodInfo == null || periodInfo.isIsAdjustPeriod() || periodInfo.getBeginDate().compareTo(date) > 0 || periodInfo.getEndDate().compareTo(new Timestamp(date.getTime())) < 0) continue;
            if (periodType.equals((Object)RptPeriodTypeEnum.MONTHLY)) {
                return new int[]{periodInfo.getPeriodYear(), periodInfo.getPeriodNumber()};
            }
            if (periodType.equals((Object)RptPeriodTypeEnum.QUARTERLY)) {
                return new int[]{periodInfo.getPeriodYear(), periodInfo.getPeriodQuarter()};
            }
            if (periodType.equals((Object)RptPeriodTypeEnum.SEMIYEARLY)) {
                int curPeriod = 0;
                curPeriod = periodInfo.getPeriodQuarter() > 2 ? 2 : 1;
                return new int[]{periodInfo.getPeriodYear(), curPeriod};
            }
            if (!periodType.equals((Object)RptPeriodTypeEnum.YEARLY)) continue;
            return new int[]{periodInfo.getPeriodYear(), 1};
        }
        return RPTDateUtil.getPeriod(date, periodType);
    }

    public static int getMaxPeriodNumber(PeriodCollection periods, int year) {
        Integer tmpYear;
        Map yearMap;
        if (periods == null || periods.size() <= 0) {
            return 0;
        }
        Map periodInfo = FiscalPeriodHelper.getFiscalPeriodInfo(periods);
        if (periodInfo.containsKey("yearMap") && (yearMap = (Map)periodInfo.get("yearMap")).containsKey(tmpYear = new Integer(year))) {
            Object[] periodList = ((ArrayList)yearMap.get(tmpYear)).toArray();
            Arrays.sort(periodList);
            return (Integer)periodList[periodList.length - 1];
        }
        return 0;
    }

    public static int[] getYearAndFirstPeriodNumber(PeriodCollection periods, int year, int period, RptPeriodTypeEnum periodType, boolean isMergeByFiscalPeriod) {
        return FiscalPeriodHelper.getYearAndFirstOrLastPeriodNumber(periods, year, period, periodType, isMergeByFiscalPeriod, true);
    }

    public static int[] getYearAndLastPeriodNumber(PeriodCollection periods, int year, int period, RptPeriodTypeEnum periodType, boolean isMergeByFiscalPeriod) {
        return FiscalPeriodHelper.getYearAndFirstOrLastPeriodNumber(periods, year, period, periodType, isMergeByFiscalPeriod, false);
    }

    public static int[] getYearAndFirstOrLastPeriodNumber(PeriodCollection periods, int year, int period, RptPeriodTypeEnum periodType, boolean isMergeByFiscalPeriod, boolean isFirst) {
        if (FiscalPeriodHelper.isMergeByFiscalPeriod(isMergeByFiscalPeriod, periodType) && periods != null) {
            Map year_quarterMap;
            Map periodInfo = FiscalPeriodHelper.getFiscalPeriodInfo(periods);
            if (periodType.equals((Object)RptPeriodTypeEnum.MONTHLY)) {
                return new int[]{year, period};
            }
            if (periodType.equals((Object)RptPeriodTypeEnum.QUARTERLY)) {
                Integer tmpYear;
                if (periodInfo.containsKey("year_quarterMap") && (year_quarterMap = (Map)periodInfo.get("year_quarterMap")).containsKey(tmpYear = new Integer(year))) {
                    Object[] periodList = ((ArrayList)year_quarterMap.get(tmpYear)).toArray();
                    Arrays.sort(periodList);
                    if (isFirst) {
                        for (int i = 0; i < periodList.length; ++i) {
                            if ((Integer)periodList[i] != period) continue;
                            return new int[]{year, i + 1};
                        }
                    } else {
                        for (int i = periodList.length - 1; i >= 0; --i) {
                            if ((Integer)periodList[i] != period) continue;
                            return new int[]{year, i + 1};
                        }
                    }
                }
            } else if (periodType.equals((Object)RptPeriodTypeEnum.SEMIYEARLY)) {
                Integer tmpYear;
                if (periodInfo.containsKey("year_quarterMap") && (year_quarterMap = (Map)periodInfo.get("year_quarterMap")).containsKey(tmpYear = new Integer(year))) {
                    Object[] periodList = ((ArrayList)year_quarterMap.get(tmpYear)).toArray();
                    Arrays.sort(periodList);
                    if (period == 1) {
                        if (isFirst) {
                            return new int[]{year, 1};
                        }
                        for (int i = periodList.length - 1; i >= 0; --i) {
                            if ((Integer)periodList[i] > 2) continue;
                            return new int[]{year, i + 1};
                        }
                    } else if (period == 2) {
                        if (isFirst) {
                            for (int i = 0; i <= periodList.length; ++i) {
                                if ((Integer)periodList[i] <= 2) continue;
                                return new int[]{year, i + 1};
                            }
                        } else {
                            for (int i = periodList.length - 1; i >= 0; --i) {
                                if ((Integer)periodList[i] <= 2) continue;
                                return new int[]{year, i + 1};
                            }
                        }
                    }
                }
            } else if (periodType.equals((Object)RptPeriodTypeEnum.YEARLY) && periodInfo.containsKey("yearMap")) {
                Map year_periodList = (Map)periodInfo.get("yearMap");
                List periodList = (List)year_periodList.get(new Integer(year));
                Object[] periodArray = periodList.toArray();
                Arrays.sort(periodArray);
                if (isFirst) {
                    return new int[]{year, (Integer)periodArray[0]};
                }
                return new int[]{year, (Integer)periodArray[periodArray.length - 1]};
            }
        }
        Date periodLastDate = isFirst ? RPTDateUtil.getPeriodFirstDate(year, period, periodType) : RPTDateUtil.getPeriodLastDate(year, period, periodType);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(periodLastDate);
        return new int[]{calendar.get(1), calendar.get(2) + 1};
    }

    public static OrgTreeCollection getOrgTreeCollection(Context ctx, int year, int period, RptPeriodTypeEnum periodType, boolean isMergeByFiscalPeriod, IObjectPK userPK) throws EASBizException, BOSException {
        if (!isMergeByFiscalPeriod || userPK == null) {
            return new OrgTreeCollection();
        }
        IPermission ip = ctx == null ? PermissionFactory.getRemoteInstance() : PermissionFactory.getLocalInstance((Context)ctx);
        OrgTreeCollection alltrees = ip.getAllUnionTrees(userPK);
        OrgTreeCollection trees = new OrgTreeCollection();
        if (alltrees != null && alltrees.size() > 0) {
            ArrayList<String> orgTreeNumber = new ArrayList<String>(alltrees.size());
            int size = alltrees.size();
            for (int i = 0; i < size; ++i) {
                orgTreeNumber.add(alltrees.get(i).getNumber());
            }
            Map orgTreeNumber_periods = FiscalPeriodHelper.getPeriodCollectionsByOrgTreeNumbers(ctx, orgTreeNumber);
            IOrgTree itree = ctx == null ? OrgTreeFactory.getRemoteInstance() : OrgTreeFactory.getLocalInstance((Context)ctx);
            Date rptDate = null;
            List time = RPTDateUtil.getRptYearAndPeriodAndDate(year, period, periodType);
            Date oldDate = (Date)time.get(2);
            String filter = CslRptUtil.handleBudgetFilter(ctx, null, null, null);
            int size2 = alltrees.size();
            for (int i = 0; i < size2; ++i) {
                OrgTreeCollection treeInfos;
                OrgTreeInfo tree = alltrees.get(i);
                if (tree.isIsForBudget() || tree.isIsHide()) continue;
                rptDate = orgTreeNumber_periods.get(tree.getNumber()) == null ? oldDate : ((rptDate = FiscalPeriodHelper.getPeriodLastDate((PeriodCollection)orgTreeNumber_periods.get(tree.getNumber()), year, period, periodType, isMergeByFiscalPeriod)) == null ? oldDate : rptDate);
                Date dDate = new Date(rptDate.getTime());
                String ksqlDate = new StringBuffer().append("{ts'").append(DateTimeUtils.getYear((Date)dDate)).append("-").append(DateTimeUtils.getMonth((Date)dDate)).append("-").append(DateTimeUtils.getDay((Date)dDate)).append(" 00:00:00'}").toString();
                StringBuffer oql = new StringBuffer();
                oql.append("select id where id ='").append(tree.getId().toString()).append("' and ((status=").append(2).append(" and startDate<= ").append(ksqlDate).append(" and endDate>= ").append(ksqlDate).append(") or (status=").append(1).append(" and startDate<=").append(ksqlDate).append("))");
                if (!StringUtils.isEmpty((String)filter)) {
                    oql.append(" and ").append(filter);
                }
                if ((treeInfos = itree.getOrgTreeCollection(oql.toString())) == null || treeInfos.size() == 0) continue;
                trees.add(tree);
            }
        }
        return trees;
    }

    public static boolean checkOrgTreeIsPeriod(OrgTreeInfo orgBound, Context ctx) throws BOSException, EASBizException {
        if (orgBound == null) {
            return false;
        }
        IOrgTreePeriod otpDao = null;
        otpDao = ctx == null ? OrgTreePeriodFactory.getRemoteInstance() : OrgTreePeriodFactory.getLocalInstance(ctx);
        String orgBoundNum = null;
        if (orgBound.getNumber() != null) {
            orgBoundNum = orgBound.getNumber();
        } else if (orgBound.getId() != null) {
            IOrgTree orgTreeDao = null;
            orgTreeDao = ctx == null ? OrgTreeFactory.getRemoteInstance() : OrgTreeFactory.getLocalInstance((Context)ctx);
            OrgTreeInfo orgTreeInfo = orgTreeDao.getOrgTreeInfo("SELECT NUMBER,ID WHERE ID = '" + orgBound.getId().toString() + "'");
            if (orgTreeInfo == null || orgTreeInfo.getNumber() == null) {
                return false;
            }
            orgBoundNum = orgTreeInfo.getNumber();
        } else {
            return false;
        }
        return otpDao.exists("select id where orgTree.number = '" + orgBoundNum + "'");
    }

    public static OrgTreeInfo getStartBaseOrgBound(boolean onlyId) throws EASBizException, BOSException {
        OrgTreeInfo baseTreeInfo = null;
        String selectExpr = "";
        if (onlyId) {
            selectExpr = " select id ";
        }
        String oql = selectExpr + " where type =" + 8 + " and basic = 1 and status=" + 1 + " and isForBudget =0";
        baseTreeInfo = OrgTreeFactory.getRemoteInstance().getOrgTreeInfo(oql);
        if (baseTreeInfo == null) {
            throw new EASBizException(new NumericExceptionSubItem("001", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"495_ExchCheckageFilterUI")));
        }
        return baseTreeInfo;
    }

    public static PeriodCollection initFormualFiscalPeriods(Context _serverCtx, ICalculateContextProvider context) {
        if (context == null) {
            return null;
        }
        PeriodCollection periods = null;
        int rptSourceType = 0;
        Object rptType = context.getReportAdapter().getReportProperty("Report.SourceType");
        if (rptType != null) {
            rptSourceType = (Integer)rptType;
        }
        try {
            Object orgTreeNum = context.getReportAdapter().getReportProperty("CSLReport_OrgTree_Number");
            if (CslRptUtil.isCslRpt(rptSourceType)) {
                if (orgTreeNum != null) {
                    OrgTreeInfo orgTreeInfoWithOnlyId = new OrgTreeInfo();
                    orgTreeInfoWithOnlyId.setNumber((String)orgTreeNum);
                    return FiscalPeriodHelper.getPeriodCollection(_serverCtx, orgTreeInfoWithOnlyId);
                }
            } else {
                Object companyId = context.getReportAdapter().getReportProperty("Company.ID");
                Object orgUnit_Id = context.getReportAdapter().getReportProperty("OrgUnit.Id");
                OrgType rptOrgType = FiscalPeriodHelper.getRptOrgType(context);
                if (companyId != null) {
                    CompanyOrgUnitInfo companyInfo;
                    if (!OrgType.Company.equals((Object)rptOrgType) && (companyInfo = RptNewUIUtil.getDelegateCompany((OrgType)rptOrgType, (String)companyId.toString())) != null && companyInfo.getId() != null) {
                        companyId = companyInfo.getId().toString();
                    }
                    periods = FiscalPeriodHelper.getPeriodCollection(_serverCtx, companyId.toString());
                } else if (orgTreeNum != null) {
                    OrgTreeInfo orgTreeInfoWithOnlyId = new OrgTreeInfo();
                    orgTreeInfoWithOnlyId.setNumber((String)orgTreeNum);
                    periods = FiscalPeriodHelper.getPeriodCollection(_serverCtx, orgTreeInfoWithOnlyId);
                } else if (orgUnit_Id != null) {
                    CompanyOrgUnitInfo companyInfo;
                    if (!OrgType.Company.equals((Object)rptOrgType) && (companyInfo = RptNewUIUtil.getDelegateCompany((OrgType)rptOrgType, (String)orgUnit_Id.toString())) != null && companyInfo.getId() != null) {
                        orgUnit_Id = companyInfo.getId().toString();
                    }
                    periods = FiscalPeriodHelper.getPeriodCollection(_serverCtx, orgUnit_Id.toString());
                }
            }
            return periods;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static OrgType getRptOrgType(ICalculateContextProvider context) {
        if (context == null || context.getReportAdapter() == null) {
            return OrgType.Company;
        }
        Object rptOrgType = context.getReportAdapter().getReportProperty("orgType");
        if (!(rptOrgType instanceof OrgType)) {
            return OrgType.Company;
        }
        return (OrgType)rptOrgType;
    }

    public static int getEndDayIndexByPeriodType(int iPeriod, RptPeriodTypeEnum rptPeriodTypeEnum) {
        int iEndIndex = iPeriod;
        switch (rptPeriodTypeEnum.getValue()) {
            case 4: {
                iEndIndex = iPeriod % 3;
                if (iEndIndex != 0) break;
                iEndIndex = 3;
                break;
            }
            case 5: {
                iEndIndex = iPeriod % 6;
                if (iEndIndex != 0) break;
                iEndIndex = 6;
                break;
            }
            case 6: {
                break;
            }
        }
        if (iEndIndex < 1) {
            iEndIndex = 1;
        }
        return iEndIndex;
    }
}

