/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class FiscalYearPeriodDateTmp {
    private static final Logger logger = Logger.getLogger(FiscalYearPeriodDateTmp.class);
    private OrgTreeInfo orgBound;
    private KDComboBox comboOrgBound;
    private KDComboBox comboPeriodType;
    private KDDatePicker pkRptDate;
    private KDSpinner spYear;
    private KDSpinner spPeriod;
    private boolean isMergeByFiscalPeriod;
    private boolean mergeByFiscalPeriod = false;
    private boolean disablePeriodTypeCombo = false;
    private RptPeriodTypeEnum defaultPeriodType = null;
    private boolean isSupport13Period;
    private Map propVars = new HashMap(0);

    private FiscalYearPeriodDateTmp(OrgTreeInfo orgBound, KDDatePicker pkRptDate, KDSpinner spYear, KDSpinner spPeriod) {
        this.orgBound = orgBound;
        this.pkRptDate = pkRptDate;
        this.spYear = spYear;
        this.spPeriod = spPeriod;
        try {
            boolean[] value = CSLParamUtil.batchGetParam(null, new String[]{"GR_CSL_MergeByFiscalPeriod", "GR_CSL_Support13Period"});
            this.mergeByFiscalPeriod = value[0];
            this.isSupport13Period = value[1];
            this.isMergeByFiscalPeriod = this.checkIsMergeByFiscalPeriod();
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.isMergeByFiscalPeriod = false;
        }
        catch (BOSException e) {
            this.isMergeByFiscalPeriod = false;
        }
    }

    private boolean checkIsMergeByFiscalPeriod() throws BOSException, EASBizException {
        return this.mergeByFiscalPeriod && FiscalPeriodHelper.checkOrgTreeIsPeriod(this.orgBound, null);
    }

    public FiscalYearPeriodDateTmp(OrgTreeInfo orgBound, KDComboBox comboPeriodType, KDDatePicker pkRptDate, KDSpinner spYear, KDSpinner spPeriod) {
        this(orgBound, pkRptDate, spYear, spPeriod);
        this.comboPeriodType = comboPeriodType;
    }

    public FiscalYearPeriodDateTmp(OrgTreeInfo orgBound, RptPeriodTypeEnum defaultPeriodType, KDDatePicker pkRptDate, KDSpinner spYear, KDSpinner spPeriod) {
        this(orgBound, pkRptDate, spYear, spPeriod);
        this.disablePeriodTypeCombo = true;
        this.defaultPeriodType = defaultPeriodType;
    }

    public boolean initTimeCtrlValAndStatusByContext(ICSLContext ctx, CoreUIObject ui, boolean isAddListener) throws BOSException {
        return this.initTimeCtrlValAndStatus(ctx.getCurRptPeriodType(), ctx.getCurOrgBound(), ctx.getCurRptYear(), ctx.getCurRptPeriod(), ui, isAddListener, null);
    }

    public boolean initTimeCtrlValAndStatusByContextAndPrePeriod(ICSLContext ctx, CoreUIObject ui, Context serverCtx, boolean useCurPeriodIfNonPre, boolean isAddListener) throws BOSException, EASBizException {
        int[] preYearAndPeriod;
        OrgTreeInfo curOrgBound = ctx.getCurOrgBound();
        int curRptYear = ctx.getCurRptYear();
        int curRptPeriod = ctx.getCurRptPeriod();
        RptPeriodTypeEnum curRptPeriodType = ctx.getCurRptPeriodType();
        PeriodCollection periods = null;
        if (this.isMergeByFiscalPeriod(curRptPeriodType, null)) {
            periods = FiscalPeriodHelper.getPeriodCollection(serverCtx, curOrgBound);
        }
        if ((preYearAndPeriod = FiscalPeriodHelper.getPerYearAndPeriod(curRptYear, curRptPeriod, curRptPeriodType, periods, this.isMergeByFiscalPeriod, this.isSupport13Period)) == FiscalPeriodHelper.EMPTY_YEAR_AND_PERIOD || preYearAndPeriod == null || preYearAndPeriod.length != 2) {
            if (!useCurPeriodIfNonPre) {
                return false;
            }
            preYearAndPeriod = new int[]{curRptYear, curRptPeriod};
        }
        return this.initTimeCtrlValAndStatus(curRptPeriodType, curOrgBound, preYearAndPeriod[0], preYearAndPeriod[1], ui, isAddListener, periods);
    }

    public boolean initTimeCtrlValAndStatus(RptPeriodTypeEnum periodType, OrgTreeInfo orgBoundPara, int rptYear, int rptPeriod, CoreUIObject ui, boolean isAddListener, PeriodCollection periods) {
        try {
            if (this.comboPeriodType != null) {
                this.comboPeriodType.setSelectedItem((Object)periodType, true);
            }
            this.resetDateYearPeriodUIStatus();
            if (isAddListener) {
                this.addTimeListeners();
            }
            this.pkRptDate.setValue((Object)FiscalPeriodHelper.getRptLastDate(orgBoundPara, rptYear, rptPeriod, periodType, this.isMergeByFiscalPeriod, null), false);
            this.spPeriod.setValue((Object)new Integer(rptPeriod), false);
            this.spYear.setValue((Object)new Integer(rptYear), false);
            if (periods == null && this.isMergeByFiscalPeriod(periodType, null)) {
                periods = FiscalPeriodHelper.getPeriodCollection(null, orgBoundPara);
            }
            FiscalPeriodHelper.setYearSpineRange(periods, this.spYear, false);
            FiscalPeriodHelper.setPeriodSpineRange(periods, Integer.parseInt(this.spYear.getValue().toString()), this.getPeriodType(), this.spPeriod, false, this.isMergeByFiscalPeriod(periodType, null));
            return true;
        }
        catch (Exception e) {
            ui.handUIException((Throwable)e);
            return false;
        }
    }

    public boolean isMergeByFiscalPeriod() {
        return this.isMergeByFiscalPeriod(null);
    }

    public boolean isMergeByFiscalPeriod(Context ctx) {
        try {
            return this.isMergeByFiscalPeriod(this.getPeriodType(), ctx);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return false;
    }

    public boolean isMergeByFiscalPeriod(RptPeriodTypeEnum periodType, Context ctx) throws EASBizException, BOSException {
        if (periodType == null) {
            logger.error((Object)"[isMergeByFiscalPeriod]please set periodType", (Throwable)new EASBizException(EASBizException.CHECKEXIST));
            return false;
        }
        return this.isMergeByFiscalPeriod && !periodType.equals((Object)RptPeriodTypeEnum.DAILY) && !periodType.equals((Object)RptPeriodTypeEnum.WEEKLY);
    }

    public void resetDateYearPeriodUIStatus() throws BOSException {
        if (this.isMergeByFiscalPeriod()) {
            this.pkRptDate.setEnabled(false);
            this.spYear.setEnabled(true);
            this.spPeriod.setEnabled(true);
            return;
        }
        this.spYear.setEnabled(false);
        this.spPeriod.setEnabled(false);
        this.pkRptDate.setEnabled(true);
    }

    public void resetYearPeriodDate() {
        block4: {
            try {
                this.resetDateYearPeriodUIStatus();
                if (!this.isMergeByFiscalPeriod()) break block4;
                try {
                    FiscalPeriodHelper.setYearSpineRange(this.orgBound, this.spYear, false);
                    FiscalPeriodHelper.setPeriodSpineRange(this.orgBound, Integer.parseInt(this.spYear.getValue().toString()), this.getPeriodType(), this.spPeriod, false);
                    this.pkRptDate.setValue((Object)FiscalPeriodHelper.getRptLastDate(this.orgBound, Integer.parseInt(this.spYear.getValue().toString()), Integer.parseInt(this.spPeriod.getValue().toString()), this.getPeriodType(), this.isMergeByFiscalPeriod, null), false);
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                }
                return;
            }
            catch (BOSException e1) {
                logger.error((Object)"", (Throwable)e1);
            }
        }
    }

    public void addTimeListeners() {
        if (this.comboPeriodType != null) {
            this.comboPeriodType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FiscalYearPeriodDateTmp.this.resetYearPeriodDate();
                }
            });
        }
        this.spYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FiscalYearPeriodDateTmp.this.listener_yearChange();
            }
        });
        this.spPeriod.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FiscalYearPeriodDateTmp.this.listener_periodChange();
            }
        });
    }

    protected void listener_yearChange() {
        if (this.isMergeByFiscalPeriod()) {
            try {
                int rptYear = Integer.parseInt(this.spYear.getValue().toString());
                RptPeriodTypeEnum rptType = this.getPeriodType();
                FiscalPeriodHelper.setPeriodSpineRange(this.orgBound, rptYear, rptType, this.spPeriod, false);
                this.setRptDateInFiscalPeriod();
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    protected void listener_periodChange() {
        if (this.isMergeByFiscalPeriod()) {
            this.setRptDateInFiscalPeriod();
        }
    }

    public void setRptDateInFiscalPeriod() {
        try {
            int rptYear = Integer.parseInt(this.spYear.getValue().toString());
            int rptPeriod = Integer.parseInt(this.spPeriod.getValue().toString());
            RptPeriodTypeEnum rptType = this.getPeriodType();
            this.pkRptDate.setValue((Object)FiscalPeriodHelper.getRptLastDate(this.orgBound, rptYear, rptPeriod, rptType, this.isMergeByFiscalPeriod, null), true);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public RptPeriodTypeEnum getPeriodType() {
        if (this.disablePeriodTypeCombo) {
            return this.defaultPeriodType;
        }
        if (this.comboPeriodType == null) {
            return null;
        }
        return (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
    }

    public void setComboOrgBound(KDComboBox comboOrgBound, boolean isInitListener, ActionListener replaceDefaultAction) {
        this.comboOrgBound = comboOrgBound;
        if (this.comboOrgBound != null && isInitListener) {
            if (replaceDefaultAction == null) {
                replaceDefaultAction = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FiscalYearPeriodDateTmp.this.orgBound = (OrgTreeInfo)FiscalYearPeriodDateTmp.this.comboOrgBound.getSelectedItem();
                        try {
                            FiscalYearPeriodDateTmp.this.isMergeByFiscalPeriod = FiscalYearPeriodDateTmp.this.checkIsMergeByFiscalPeriod();
                        }
                        catch (EASBizException e1) {
                            logger.error((Object)"", (Throwable)e1);
                            FiscalYearPeriodDateTmp.this.isMergeByFiscalPeriod = false;
                        }
                        catch (BOSException e1) {
                            logger.error((Object)"", (Throwable)e1);
                            FiscalYearPeriodDateTmp.this.isMergeByFiscalPeriod = false;
                        }
                        FiscalYearPeriodDateTmp.this.resetYearPeriodDate();
                    }
                };
            }
            this.comboOrgBound.addActionListener(replaceDefaultAction);
        }
    }

    public boolean isSupport13Period() {
        return this.isSupport13Period;
    }

    public void setPropVars(Map propVars) {
        this.propVars = propVars;
    }
}

