/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.mobile.MobileUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.util.PsSql;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class InterTradeServerUtils {
    private static final int HASCHECKED = 1;
    private static final int BASEDATA = 2;
    private static final int CANDELETE = 0;
    private static final int NOTCURGROUP = 3;
    private static Logger logger = Logger.getLogger((String)InterTradeServerUtils.class.getName());

    public static int tryToDelete(Context ctx, IObjectPK pk, int mergeType, OrgTreeInfo tree, OrgUnitInfo orgUnit, ElimTypeEnum elimType) throws BOSException {
        block12: {
            String tableName = null;
            if (elimType == ElimTypeEnum.ComeAndGo) {
                tableName = "T_CSL_InterItemData";
            } else if (elimType == ElimTypeEnum.exchange) {
                tableName = "T_CSL_ExchItemData";
            }
            String sql = "SELECT FSourceType, FCheckageStatus, FImportedGroup FROM " + tableName + " where FId = ?";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
            try {
                if (!rowSet.next()) break block12;
                int type = rowSet.getInt("FSourceType");
                int status = rowSet.getInt("FCheckageStatus");
                String group = rowSet.getString("FImportedGroup");
                if (type != 2) {
                    return 2;
                }
                if (status == 2) {
                    return 1;
                }
                OrgUnitInfo orgUnitInfo = null;
                try {
                    orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo("select number where id='" + group + "'");
                }
                catch (EASBizException e) {
                    throw new BOSException((Throwable)e);
                }
                String orgNumber = "";
                if (orgUnitInfo != null) {
                    orgNumber = orgUnitInfo.getNumber();
                }
                if (mergeType == 1 && !StringUtils.equals((String)orgNumber, (String)orgUnit.getNumber().toString())) {
                    return 3;
                }
                if (!StringUtils.equals((String)orgNumber, (String)orgUnit.getNumber().toString())) {
                    return 3;
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return 0;
    }

    public static Map checkDelete(Context ctx, Map param) throws BOSException, EASBizException {
        String ids = (String)param.get("ids");
        ElimTypeEnum elimType = (ElimTypeEnum)((Object)param.get("elimType"));
        Boolean isGetItemDataId = (Boolean)param.get("getItemDataId");
        if (isGetItemDataId == null) {
            isGetItemDataId = false;
        }
        StringBuffer buffer = new StringBuffer();
        if (isGetItemDataId.booleanValue()) {
            buffer.append(" SELECT DISTINCT checkage.FNumber checkageNumber, itemData.FId itemDataId \r\n");
        } else {
            buffer.append(" SELECT DISTINCT rpt.fid FId, u.fnumber companyNumber, u.FName_l2 companyName, t.fname, t.FNumber \r\n");
        }
        buffer.append("   FROM ").append(elimType == ElimTypeEnum.ComeAndGo ? "T_CSL_InterItemData" : "T_CSL_ExchItemData").append(" itemData \r\n");
        buffer.append("   JOIN ").append(elimType == ElimTypeEnum.ComeAndGo ? "T_CSL_InterDataCheckage" : "T_CSL_ExchCheckage").append(" checkage \r\n");
        buffer.append("     ON itemData.FCheckageRecord = checkage.FId \r\n");
        buffer.append("   JOIN T_CSL_Cslreport rpt \r\n");
        buffer.append("     ON rpt.FId = itemData.FReport \r\n");
        buffer.append("   JOIN T_ORG_BaseUnit u \r\n");
        buffer.append("     on u.FId = rpt.FOrgUnitId \r\n");
        buffer.append("   JOIN T_RPT_Template t \r\n");
        buffer.append("     ON t.FId = rpt.FTemplateId \r\n");
        buffer.append("  WHERE itemData.FId IN \r\n");
        buffer.append("        (").append(ids).append(") \r\n");
        buffer.append("    AND checkage.FCheckedStatus=").append(2).append(" \r\n");
        if (isGetItemDataId.booleanValue()) {
            buffer.append("  ORDER BY checkage.FNumber");
        } else {
            buffer.append("  ORDER BY t.FNumber, u.FNumber");
        }
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        try {
            HashSet<String> existCheckedRptIds = new HashSet<String>();
            HashSet<String> existItemDataIds = new HashSet<String>();
            ArrayList<String> checkageNumber = new ArrayList<String>();
            StringBuffer msg = new StringBuffer();
            while (row.next()) {
                if (isGetItemDataId.booleanValue()) {
                    existItemDataIds.add(row.getString("itemDataId"));
                    if (checkageNumber.contains(row.getString("checkageNumber"))) continue;
                    checkageNumber.add(row.getString("checkageNumber"));
                    continue;
                }
                if (existCheckedRptIds.contains(row.getString("FId"))) continue;
                existCheckedRptIds.add(row.getString("FId"));
                msg.append(row.getString("companyNumber")).append("\t");
                String companyName = row.getString("companyName");
                msg.append(companyName);
                if (!StringUtils.isEmpty((String)companyName) && companyName.toCharArray().length > 8) {
                    msg.append("\t");
                } else {
                    msg.append("\t\t");
                }
                msg.append(row.getString("FNumber")).append("\t");
                msg.append(row.getString("FName")).append("\t\n");
            }
            if (isGetItemDataId.booleanValue()) {
                result.put("existItemDataIds", existItemDataIds);
                if (checkageNumber.size() > 0) {
                    String numbers = "";
                    String prefix = elimType == ElimTypeEnum.ComeAndGo ? "WL-" : "JY-";
                    for (int i = 0; i < checkageNumber.size(); ++i) {
                        numbers = numbers + prefix + checkageNumber.get(i) + ", ";
                    }
                    if (numbers.length() > 0) {
                        numbers = numbers.substring(0, numbers.length() - 2);
                    }
                    msg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"867_ExistCheckdData2", (Locale)ctx.getLocale(), (Object[])new Object[]{numbers})).append("\r\n");
                }
            } else {
                result.put("existCheckedRptIds", existCheckedRptIds);
                if (msg.length() > 0) {
                    msg = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"865_ExistCheckedData", (Locale)ctx.getLocale(), (Object[])new Object[]{msg})).append("\r\n");
                }
            }
            result.put("msg", msg);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Deprecated
    public static void checkDelete(Context ctx, String ids, ElimTypeEnum elimType) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append(" select b.FCheckedStatus FCheckedStatus from ");
        sb.append(InterTradeServerUtils.getMainTableNames(elimType));
        sb.append(" , T_CSL_RptItem d, T_CSL_Cslreport e ");
        sb.append(" where a.FReport = e.fid and e.FDataCollectNumber = b.FDataCollectNumber ");
        sb.append(" and b.fid = c.FCheckageID and d.FId=c.FItemId and a.FItemNumber = d.FNumber  ");
        sb.append(" and a.FCompanyID = c.FCompanyID and a.FTargetCompanyID = c.FTargetCompanyID  ");
        sb.append(" and a.FYear = b.FYear and a.FPeriod = b.FPeriod and b.FPeriodType = a.FPeriodType ");
        sb.append(" and b.FCurrencyID = a.FTargetCurrencyID and a.FOrgBoundID = b.FOrgBoundID ");
        sb.append(" and a.fid in ").append(ids);
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (row.next()) {
                String CheckedStatus = row.getString("FCheckedStatus");
                if (!"2".equals(CheckedStatus)) continue;
                throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"InterDataCheckedStatus_Confirm", (Locale)ctx.getLocale())));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String checkDelete(Context ctx, String ids, ElimTypeEnum elimType, boolean isComeAndExch) throws BOSException, EASBizException {
        String sql = InterTradeServerUtils.getCheckSql(ctx, ids, elimType);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        StringBuffer msg = new StringBuffer();
        try {
            while (rs.next()) {
                if (!isComeAndExch) continue;
                throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"InterAndExchDataCheckedStatus_Confirm", (Locale)ctx.getLocale())));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return msg.toString();
    }

    public static String getCheckSql(Context ctx, String ids, ElimTypeEnum elimType) {
        SQLBuilder buffer = new SQLBuilder();
        String l = ctx.getLocale().toString();
        buffer.append(" SELECT DISTINCT e.FName, u1.FName_" + l + " targetCompanyName, u2.FName_" + l + " companyName, u.FName_" + l + " orgUnit,b.FNumber \n");
        buffer.append("   FROM ").append(InterTradeServerUtils.getMainTableNames(elimType)).append(" ,T_CSL_RptItem d, T_CSL_Cslreport e, T_ORG_BaseUnit u1, T_ORG_BaseUnit u2 \n");
        buffer.append("   \t   ,T_ORG_BaseUnit u \n");
        buffer.append("  WHERE a.FReport = e.fid AND e.FDataCollectNumber = b.FDataCollectNumber              \n");
        buffer.append("    AND b.fid = c.FCheckageID AND d.FId=c.FItemId AND a.FItemNumber = d.FNumber        \n");
        buffer.append("    AND a.FCompanyID = c.FCompanyID AND a.FTargetCompanyID = c.FTargetCompanyID        \n");
        buffer.append("    AND a.FYear = b.FYear AND a.FPeriod = b.FPeriod AND b.FPeriodType = a.FPeriodType  \n");
        buffer.append("    AND b.FCurrencyID = a.FTargetCurrencyID AND a.FOrgBoundID = b.FOrgBoundID          \n");
        buffer.append("    AND u1.fid = a.ftargetcompanyid AND u2.fid = a.fcompanyid AND u.FId = b.FOrgUnitId \n");
        buffer.append("    AND a.FId IN ").append(ids);
        buffer.append("    AND b.FCheckedStatus = 2");
        if (logger.isDebugEnabled() || MobileUtil.isDebug) {
            InterTradeServerUtils.debug(buffer, EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"966_InterTradeServerUtils"));
        }
        return buffer.toString();
    }

    public static void debug(SQLBuilder buffer, String title) {
        try {
            if (logger.isDebugEnabled() || MobileUtil.isDebug) {
                String kql = PsSql.getSqlWithParams((Object)buffer.getSQL(), (Object[])buffer.getParams(), (int)7, (boolean)false);
                MobileUtil.debugLog(logger, "[" + title + "]******************************************:\n" + kql);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static String getMainTableNames(ElimTypeEnum elimType) {
        if (ElimTypeEnum.ComeAndGo.equals((Object)elimType)) {
            return "T_CSL_InterItemData a, T_CSL_InterDataCheckage b,T_CSL_DataCheckageEntry c ";
        }
        return "T_CSL_ExchItemData a,T_CSL_ExchCheckage b, T_CSL_ExchCheckageEntry c ";
    }

    public static String getReportFieldNameNameByElimType(ElimTypeEnum elimType, boolean isMulti) {
        if (isMulti) {
            return "FReport";
        }
        switch (elimType.getValue()) {
            case 1: {
                return "FReport";
            }
            case 3: {
                return "FReport";
            }
        }
        return "FREPORTID";
    }

    public static String getTableNameByElimType(ElimTypeEnum elimType, boolean isMulti) {
        if (isMulti) {
            return "T_CSL_MultiInterItemData";
        }
        switch (elimType.getValue()) {
            case 1: {
                return "T_CSL_InterItemData";
            }
            case 3: {
                return "T_CSL_ExchItemData";
            }
        }
        return "T_CSL_InvestItemData";
    }
}

