/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.AdjustAndElimDispenseCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustAndElimDispenseFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustAndElimDispenseInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslPostilInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.HisAdjustDynamicItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.HisAdjustEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.HisAdjustInfo;
import com.kingdee.eas.fi.gr.cslrpt.HisCaliAdjustEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.HisCaliAdjustInfo;
import com.kingdee.eas.fi.gr.cslrpt.HisCslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.HisDataCheckageEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.HisElimDynaItemEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.HisElimRecordInfo;
import com.kingdee.eas.fi.gr.cslrpt.HisEliminationEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.HisEliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.HisExchCheckageEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.HisExchCheckageInfo;
import com.kingdee.eas.fi.gr.cslrpt.HisInterDataCheckageInfo;
import com.kingdee.eas.fi.gr.cslrpt.HisRptReceivedInfo;
import com.kingdee.eas.fi.gr.cslrpt.HisSumRptRelaInfo;
import com.kingdee.eas.fi.gr.cslrpt.IItemHisExchgRate;
import com.kingdee.eas.fi.gr.cslrpt.InterCheckSolutionEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.InterCheckSolutionInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataYearInitInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemHisExchgRateCollection;
import com.kingdee.eas.fi.gr.cslrpt.ItemHisExchgRateFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemHisExchgRateInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTExchItemDataInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTInterItemDataInfo;
import com.kingdee.eas.fi.gr.cslrpt.RptReceivedInfo;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.UnionBeforeVersion;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.dynamic.DynaItemDataEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.DynaItemDataInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.util.TemplateDispenseNewUtil;
import com.kingdee.eas.fi.rpt.PostilInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class UnionVersionUtil {
    private static final Logger logger = CoreUIObject.getLogger(UnionVersionUtil.class);
    public static final ConcurrentHashMap<String, Object> UnionVersionThreadMap = new ConcurrentHashMap();
    public static final int rptSrcTypeAll = 999;
    protected static ThreadLocal<String[]> tl = new ThreadLocal();

    public static void copyToHistory(Context ctx, String oldTreeId, String newTreeId, Timestamp date, PeriodCollection periods, boolean isMergeByFiscalPeriod) throws BOSException, EASBizException {
        Map elimMapping = UnionVersionUtil.copyEliminationToHistory(ctx, oldTreeId, newTreeId, date, periods, isMergeByFiscalPeriod);
        Map interMapping = UnionVersionUtil.copyCheckageToHistory(ctx, oldTreeId, newTreeId, date, 1, periods, isMergeByFiscalPeriod);
        Map exchMapping = UnionVersionUtil.copyCheckageToHistory(ctx, oldTreeId, newTreeId, date, 3, periods, isMergeByFiscalPeriod);
        HashMap rptMapping = new HashMap();
        HashMap sumRptMapping = new HashMap();
        HashMap adjustMapping = new HashMap();
        HashMap caliAdjustMapping = new HashMap();
        UnionVersionUtil.copyElimRecordToHistory(ctx, elimMapping, interMapping);
        UnionVersionUtil.copyElimRecordToHistory(ctx, elimMapping, exchMapping);
        UnionVersionUtil.copyCommonReportToHistory(ctx, oldTreeId, newTreeId, date, interMapping, exchMapping, rptMapping, sumRptMapping, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.copyDynamicReportToHistory(ctx, oldTreeId, newTreeId, date, interMapping, exchMapping, rptMapping, sumRptMapping, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.updateSourceRpt(ctx, rptMapping, sumRptMapping);
        UnionVersionUtil.copyAdjustToHistory(ctx, oldTreeId, newTreeId, date, adjustMapping, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.copyCaliAdjustToHistory(ctx, oldTreeId, newTreeId, date, caliAdjustMapping, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.copyRptReceivedToHistory(ctx, oldTreeId, newTreeId, date, rptMapping, sumRptMapping, adjustMapping, caliAdjustMapping, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.copyInterExchItemdataToHistory(ctx, date, interMapping, exchMapping, rptMapping, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.copySumRptRelaToHistory(ctx, sumRptMapping, rptMapping);
    }

    public static void repairRptReceivedData(Context ctx, String treeId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO T_CSL_RptReceived (FID,FReportID,forgtreeid,FCREATORID,FCREATETIME) ");
        String bosType = new RptReceivedInfo().getBOSType().toString();
        sql.append(" SELECT newbosid('").append(bosType).append("') as FID,  ");
        sql.append(" rpt.fid as FReportID, '").append(treeId).append("' AS forgtreeid,");
        sql.append(" rpt.FCREATORID,rpt.FCREATETIME ");
        sql.append(" FROM t_csl_cslreport rpt ");
        sql.append(" INNER JOIN t_org_structure struct ON struct.funitid = rpt.forgunitid ");
        sql.append(" WHERE struct.ftreeid = '" + treeId + "'  ");
        sql.append(" AND NOT EXISTS( SELECT 1 FROM T_CSL_RptReceived WHERE FReportID = rpt.fid)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void copySumRptRelaToHistory(Context ctx, Map sumRpt, Map rpt) throws BOSException {
        if (sumRpt.isEmpty() || rpt.isEmpty()) {
            return;
        }
        StringBuffer sqlRela = null;
        StringBuffer sqlInsertRela = null;
        sqlRela = new StringBuffer();
        sqlRela.append(" select newbosid('").append(new HisSumRptRelaInfo().getBOSType().toString()).append("') as newid,");
        sqlRela.append(" FID,FSUMREPORTID,FREPORTID,FCREATETIME,FCREATORID, \n");
        sqlRela.append(" FLASTUPDATETIME,FLASTUPDATEUSERID,FCONTROLUNITID,FSHEETID \n");
        sqlRela.append(" From t_csl_sumRptRela  \n");
        sqlRela.append(" Where  FSUMREPORTID IN (").append(UnionVersionUtil.getMapKeyString(sumRpt)).append(") ");
        sqlInsertRela = new StringBuffer();
        sqlInsertRela.append(" insert into T_Csl_HisSumRptRela(FID,FSUMREPORTID,FREPORTID,FCREATETIME,FCREATORID, \n");
        sqlInsertRela.append(" FLASTUPDATETIME,FLASTUPDATEUSERID,FCONTROLUNITID,FSHEETID) \n");
        sqlInsertRela.append(" values(?,?,?,?,?,?,?,?,?) ");
        IRowSet rsRela = null;
        Connection cn = null;
        PreparedStatement psRela = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            psRela = cn.prepareStatement(sqlInsertRela.toString());
            rsRela = DbUtil.executeQuery((Context)ctx, (String)sqlRela.toString());
            while (rsRela.next()) {
                String newSumRptId = (String)sumRpt.get(rsRela.getString("FSUMREPORTID"));
                String newRptId = (String)rpt.get(rsRela.getString("FREPORTID"));
                if (StringUtils.isEmpty((String)newSumRptId) || StringUtils.isEmpty((String)newRptId)) continue;
                psRela.setString(1, rsRela.getString("newid"));
                psRela.setString(2, newSumRptId);
                psRela.setString(3, newRptId);
                psRela.setDate(4, rsRela.getDate("FCREATETIME"));
                psRela.setString(5, rsRela.getString("FCREATORID"));
                psRela.setDate(6, rsRela.getDate("FLASTUPDATETIME"));
                psRela.setString(7, rsRela.getString("FLASTUPDATEUSERID"));
                psRela.setString(8, rsRela.getString("FCONTROLUNITID"));
                psRela.setString(9, rsRela.getString("FSHEETID"));
                psRela.addBatch();
            }
            psRela.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(psRela, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)psRela, (Connection)cn);
    }

    private static String getMapKeyString(Map map) {
        StringBuffer sql = new StringBuffer();
        Set s = map.keySet();
        for (String id : s) {
            sql.append("'").append(id).append("',");
        }
        return sql.length() > 0 ? sql.substring(0, sql.length() - 1) : "";
    }

    private static void copyElimRecordToHistory(Context ctx, Map elimMapping, Map checkageMapping) throws BOSException {
        if (elimMapping.isEmpty() || checkageMapping.isEmpty()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select newbosid('").append(new HisElimRecordInfo().getBOSType().toString()).append("') as newid,");
        sql.append(" FID,FCREATORID,FCREATETIME,FLASTUPDATEUSERID,FLASTUPDATETIME,FELIMINATIONID, \n");
        sql.append(" FCHECKAGEDATAID,FCONTROLUNITID ");
        sql.append(" From t_csl_elimRecord ");
        sql.append(" where FELIMINATIONID in (").append(UnionVersionUtil.getMapKeyString(elimMapping)).append(")");
        sql.append(" and FCHECKAGEDATAID in (").append(UnionVersionUtil.getMapKeyString(checkageMapping)).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer sqlInsert = null;
        Connection cn = null;
        Statement st = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            st = cn.createStatement();
            while (rs.next()) {
                sqlInsert = new StringBuffer();
                String newEliminationID = (String)elimMapping.get(rs.getString("FELIMINATIONID"));
                String newCheckageID = (String)checkageMapping.get(rs.getString("FCHECKAGEDATAID"));
                if (StringUtils.isEmpty((String)newEliminationID) || StringUtils.isEmpty((String)newCheckageID)) continue;
                sqlInsert.append(" insert into T_CSL_HisElimRecord(FID,FCREATORID,FCREATETIME,FLASTUPDATEUSERID,FLASTUPDATETIME, \n");
                sqlInsert.append(" FELIMINATIONID,FCHECKAGEDATAID,FCONTROLUNITID) ");
                sqlInsert.append(" values(");
                sqlInsert.append(" '").append(rs.getString("newid")).append("',");
                if (rs.getString("FCREATORID") != null) {
                    sqlInsert.append(" '").append(rs.getString("FCREATORID")).append("',");
                } else {
                    sqlInsert.append(" null,");
                }
                if (rs.getTimestamp("FCREATETIME") != null) {
                    sqlInsert.append(" Timestamp'").append(rs.getTimestamp("FCREATETIME")).append("',");
                } else {
                    sqlInsert.append(" null,");
                }
                if (rs.getString("FLASTUPDATEUSERID") != null) {
                    sqlInsert.append(" '").append(rs.getString("FLASTUPDATEUSERID")).append("',");
                } else {
                    sqlInsert.append(" null,");
                }
                if (rs.getTimestamp("FLASTUPDATETIME") != null) {
                    sqlInsert.append(" Timestamp'").append(rs.getTimestamp("FLASTUPDATETIME")).append("',");
                } else {
                    sqlInsert.append(" null,");
                }
                sqlInsert.append(" '").append(rs.getString("FELIMINATIONID")).append("',");
                sqlInsert.append(" '").append(rs.getString("FCHECKAGEDATAID")).append("',");
                sqlInsert.append(" '").append(rs.getString("FCONTROLUNITID")).append("')");
                st.addBatch(sqlInsert.toString());
            }
            st.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st);
        SQLUtils.cleanup((Connection)cn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void copyDynamicReportToHistory(Context ctx, String oldTreeId, String newTreeId, Timestamp date, Map inter, Map exch, Map rpt, Map sumRpt, PeriodCollection periods, boolean isMergeByFiscalPeriod) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select newBosId('").append(new HisCslReportInfo().getBOSType().toString()).append("') as newid,");
        sql.append(" c.FID,c.FNUMBER,c.FNAME,c.FORGTREEID,c.FORGUNITID,c.FYEAR,c.FPERIOD, \n");
        sql.append(" c.FSTARTDATE,c.FENDDATE,c.FCREATORID,c.FCREATETIME,FTEMPLATEID,c.FLASTUPDATEUSERID,c.FLASTUPDATETIME, \n");
        sql.append(" c.FDESCRIPTION,c.FAUDITORID,c.FCOMPANYID,c.FPERIODTYPE,c.FPUBLICSTATUS,c.FPUBLISHEDSTATUS,c.FCOMMITTEDSTATUS, \n");
        sql.append(" c.FHANDLESTATUS,c.FSOURCETYPE,c.FCURRENCYID,c.FAUDITEDTIME,c.FAUDITEDSTATUS,c.FCHECKEDSTATUS,c.FDATA, \n");
        sql.append(" c.FSOURCECURRENCYID,c.FREPORTDATE,c.FSOURCERPTID,c.FCONTROLUNITID,c.FADJUSTSTATUS,c.FCONVERTSTATUS, \n");
        sql.append(" c.FISCOMMITREPORT,c.FDYNARPTTYPE,c.FISSAVEAS,c.FSAVEASVERSIONNUM,c.FREMARK,c.FCOMMITTIME,c.FRECEIVETIME, \n");
        sql.append(" c.FCOMMITORID,c.FRECEIVERID,c.FRECEIVESTATUS,c.FDATACOLLECTID,c.FDATACOLLECTNUMBER \n");
        sql.append(" From t_csl_cslreport c join t_csl_rptreceived r on c.fid=r.FReportId \n");
        sql.append(" join t_rpt_template t on c.FTemplateId=t.FID \n");
        sql.append(" Where  r.forgTreeId = ? and c.FIsSaveAs=0 \n");
        sql.append(" and c.FDataCollectNumber = '").append("BUDGETDATA").append("' \n");
        sql.append(" and c.FSourceType in (10,11,12,32,35)");
        sql.append(" and ").append(UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (String)"c", (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        sql.append(" order by c.FAdjustStatus desc \n");
        StringBuffer sqlItemdata = new StringBuffer();
        sqlItemdata.append(" select newBosId('").append(new DynaItemDataInfo().getBOSType().toString()).append("') as newid,");
        sqlItemdata.append(" d.FID,d.FORGUNITID,d.FCurrencyID,d.FPERIODTYPE,d.FDATASOURCE,d.FReportId, \n");
        sqlItemdata.append(" d.FCOMMITSTATUS,d.FCONTROLUNITID,d.FSOURCECURRENCYID,d.FDATATYPE,d.FDYNATYPE, \n");
        sqlItemdata.append(" d.FDATACOLLECTNUMBER \n");
        sqlItemdata.append(" From t_csl_dynaitemdata d \n");
        sqlItemdata.append(" join t_csl_cslreport c on d.FReportId=c.FId \n");
        sqlItemdata.append(" join t_csl_rptreceived r on c.fid=r.FReportId \n");
        sqlItemdata.append(" join t_rpt_template t on c.FTemplateId=t.FID \n");
        sqlItemdata.append(" Where  r.forgTreeId = ? \n");
        sqlItemdata.append(" and c.FDataCollectNumber = '").append("BUDGETDATA").append("' \n");
        sqlItemdata.append(" and c.FSourceType in (10,11,12)");
        sqlItemdata.append(" and ").append(UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (String)"c", (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        StringBuffer sqlInsertReport = new StringBuffer();
        sqlInsertReport.append(" insert into t_csl_hisCslReport(FID,FNUMBER,FNAME,FORGTREEID,FORGUNITID,FYEAR,FPERIOD, \n");
        sqlInsertReport.append(" FSTARTDATE,FENDDATE,FCREATORID,FCREATETIME,FTEMPLATEID,FLASTUPDATEUSERID,FLASTUPDATETIME, \n");
        sqlInsertReport.append(" FDESCRIPTION,FAUDITORID,FCOMPANYID,FPERIODTYPE,FPUBLICSTATUS,FPUBLISHEDSTATUS,FCOMMITTEDSTATUS, \n");
        sqlInsertReport.append(" FHANDLESTATUS,FSOURCETYPE,FCURRENCYID,FAUDITEDTIME,FAUDITEDSTATUS,FCHECKEDSTATUS,FDATA, \n");
        sqlInsertReport.append(" FSOURCECURRENCYID,FREPORTDATE,FSOURCERPTID,FCONTROLUNITID,FADJUSTSTATUS,FCONVERTSTATUS, \n");
        sqlInsertReport.append(" FISCOMMITREPORT,FDYNARPTTYPE,FISSAVEAS,FSAVEASVERSIONNUM,FREMARK,FCOMMITTIME,FRECEIVETIME, \n");
        sqlInsertReport.append(" FCOMMITORID,FRECEIVERID,FRECEIVESTATUS,FDATACOLLECTID,FDATACOLLECTNUMBER,FOriginalRpt) \n");
        sqlInsertReport.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        ArrayList<String> param = new ArrayList<String>();
        param.add(oldTreeId);
        IRowSet rs = null;
        IRowSet rsItemdata = null;
        HashMap itemdata = new HashMap();
        Connection cn = null;
        PreparedStatement ps = null;
        try {
            rsItemdata = DbUtil.executeQuery((Context)ctx, (String)sqlItemdata.toString(), (Object[])param.toArray());
            while (rsItemdata.next()) {
                HashMap<String, String> entry = new HashMap<String, String>();
                itemdata.put(rsItemdata.getString("FReportId"), entry);
                entry.put("newid", rsItemdata.getString("newid"));
                entry.put("oldid", rsItemdata.getString("FID"));
            }
            cn = EJBFactory.getConnection((Context)ctx);
            ps = cn.prepareStatement(sqlInsertReport.toString());
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
            while (rs.next()) {
                if (UnionVersionUtil.isDynaSumRptReport(rs.getInt("FSourceType"))) {
                    sumRpt.put(rs.getString("FID"), rs.getString("newid"));
                } else {
                    rpt.put(rs.getString("FID"), rs.getString("newid"));
                }
                UnionVersionUtil.insertDynamicItemdataOne(ctx, rs, itemdata, ps, inter, exch);
                UnionVersionUtil.addAttachment(ctx, rs.getString("FID"), rs.getString("newid"));
                HashMap sheetMapping = new HashMap();
                UnionVersionUtil.insertReportSheetPara(ctx, rs.getString("FID"), rs.getString("newid"), sheetMapping);
                UnionVersionUtil.addCSLPostil(ctx, rs.getString("FID"), rs.getString("newid"), sheetMapping);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
                catch (BOSException e2) {
                    throw new BOSException((Throwable)e2);
                }
                catch (IOException e3) {
                    throw new BOSException((Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup(cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)cn);
    }

    private static void copyCommonReportToHistory(Context ctx, String oldTreeId, String newTreeId, Timestamp date, Map inter, Map exch, Map rpt, Map sumRpt, PeriodCollection periods, boolean isMergeByFiscalPeriod) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select i.FId as FItemdataId, newBosId('").append(new HisCslReportInfo().getBOSType().toString()).append("') as newid,");
        sql.append(" c.FID,c.FNUMBER,c.FNAME,c.FORGTREEID,c.FORGUNITID,c.FYEAR,c.FPERIOD, \n");
        sql.append(" c.FSTARTDATE,c.FENDDATE,c.FCREATORID,c.FCREATETIME,c.FTEMPLATEID,c.FLASTUPDATEUSERID,c.FLASTUPDATETIME, \n");
        sql.append(" c.FDESCRIPTION,c.FAUDITORID,c.FCOMPANYID,c.FPERIODTYPE,c.FPUBLICSTATUS,c.FPUBLISHEDSTATUS,c.FCOMMITTEDSTATUS, \n");
        sql.append(" c.FHANDLESTATUS,c.FSOURCETYPE,c.FCURRENCYID,c.FAUDITEDTIME,c.FAUDITEDSTATUS,c.FCHECKEDSTATUS,c.FDATA, \n");
        sql.append(" c.FSOURCECURRENCYID,c.FREPORTDATE,c.FSOURCERPTID,c.FCONTROLUNITID,c.FADJUSTSTATUS,c.FCONVERTSTATUS, \n");
        sql.append(" c.FISCOMMITREPORT,c.FDYNARPTTYPE,c.FISSAVEAS,c.FSAVEASVERSIONNUM,c.FREMARK,c.FCOMMITTIME,c.FRECEIVETIME, \n");
        sql.append(" c.FCOMMITORID,c.FRECEIVERID,c.FRECEIVESTATUS,c.FDATACOLLECTID,c.FDATACOLLECTNUMBER \n");
        sql.append(" From t_csl_cslreport c join t_csl_rptreceived r on c.fid=r.FReportId \n");
        sql.append(" left join t_csl_itemdata i on i.FReportId=c.FID \n");
        sql.append(" join t_rpt_template t on c.FTemplateId=t.FID \n");
        sql.append(" Where  r.forgTreeId = ? and c.FIsSaveAs=0 \n");
        sql.append(" and c.FDataCollectNumber = '").append("BUDGETDATA").append("' \n");
        sql.append(" and c.fsourcetype in (1,2,3,4,6,7,8,31,33,34) \n");
        sql.append(" and ").append(UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (String)"c", (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        sql.append(" order by c.FAdjustStatus desc \n");
        StringBuffer sqlInsertReport = new StringBuffer();
        sqlInsertReport.append(" insert into t_csl_hisCslReport(FID,FNUMBER,FNAME,FORGTREEID,FORGUNITID,FYEAR,FPERIOD, \n");
        sqlInsertReport.append(" FSTARTDATE,FENDDATE,FCREATORID,FCREATETIME,FTEMPLATEID,FLASTUPDATEUSERID,FLASTUPDATETIME, \n");
        sqlInsertReport.append(" FDESCRIPTION,FAUDITORID,FCOMPANYID,FPERIODTYPE,FPUBLICSTATUS,FPUBLISHEDSTATUS,FCOMMITTEDSTATUS, \n");
        sqlInsertReport.append(" FHANDLESTATUS,FSOURCETYPE,FCURRENCYID,FAUDITEDTIME,FAUDITEDSTATUS,FCHECKEDSTATUS,FDATA, \n");
        sqlInsertReport.append(" FSOURCECURRENCYID,FREPORTDATE,FSOURCERPTID,FCONTROLUNITID,FADJUSTSTATUS,FCONVERTSTATUS, \n");
        sqlInsertReport.append(" FISCOMMITREPORT,FDYNARPTTYPE,FISSAVEAS,FSAVEASVERSIONNUM,FREMARK,FCOMMITTIME,FRECEIVETIME, \n");
        sqlInsertReport.append(" FCOMMITORID,FRECEIVERID,FRECEIVESTATUS,FDATACOLLECTID,FDATACOLLECTNUMBER,FOriginalRpt) \n");
        sqlInsertReport.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        ArrayList<String> param = new ArrayList<String>();
        param.add(oldTreeId);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        Connection cn = null;
        PreparedStatement ps = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            List itemdatatables = UnionVersionUtil.getItemdataTables(ctx);
            ps = cn.prepareStatement(sqlInsertReport.toString());
            while (rs.next()) {
                if (UnionVersionUtil.isSumRptReport(rs.getInt("FSourceType"))) {
                    sumRpt.put(rs.getString("FID"), rs.getString("newid"));
                } else {
                    rpt.put(rs.getString("FID"), rs.getString("newid"));
                }
                UnionVersionUtil.insertItemdataOne(ctx, oldTreeId, newTreeId, rs, ps, itemdatatables, inter, exch);
                UnionVersionUtil.addAttachment(ctx, rs.getString("FID"), rs.getString("newid"));
                HashMap sheetMapping = new HashMap();
                UnionVersionUtil.insertReportSheetPara(ctx, rs.getString("FID"), rs.getString("newid"), sheetMapping);
                UnionVersionUtil.addCSLPostil(ctx, rs.getString("FID"), rs.getString("newid"), sheetMapping);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)cn);
    }

    private static List getItemdataTables(Context ctx) throws BOSException, SQLException {
        ArrayList<String> itemdatatables = new ArrayList<String>();
        IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)"select FID,FTableName From t_csl_ItemdataTable order by FTableName ASC");
        while (rsTemp.next()) {
            itemdatatables.add(rsTemp.getString("FTableName"));
        }
        return itemdatatables;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addRPTPostil(Context ctx, String oldId, String newId, Map sheet) throws BOSException {
        ArrayList<String> param = null;
        StringBuffer sqlSelect = new StringBuffer();
        param = new ArrayList<String>();
        sqlSelect.append(" select newBosId('").append(new PostilInfo().getBOSType().toString()).append("') as newid, \n");
        sqlSelect.append(" FID,FDESCRIPTION,FSHEETID,FCELLNAME,FCREATORID,FPOSTILTYPE,FREPORTID,");
        sqlSelect.append(" FCREATETIME,FLASTUPDATETIME,FLASTUPDATEUSERID,FITEMNUMBER,FREPORTTYPE,FCONTROLUNITID \n");
        sqlSelect.append(" From t_rpt_rptpostil \n");
        sqlSelect.append(" Where  FREPORTID =? ");
        param.add(oldId);
        StringBuffer sqlInsert = new StringBuffer();
        sqlInsert.append(" insert into t_rpt_rptpostil");
        sqlInsert.append(" (FID,FDESCRIPTION,FSHEETID,FCELLNAME,FCREATORID,FPOSTILTYPE,FREPORTID,FCREATETIME, \n");
        sqlInsert.append(" FLASTUPDATETIME,FLASTUPDATEUSERID,FITEMNUMBER,FREPORTTYPE,FCONTROLUNITID) \n");
        sqlInsert.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?)  \n");
        Connection conn = null;
        Statement st = null;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlSelect.toString(), (Object[])param.toArray());
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.createStatement();
            while (rs.next()) {
                String newSheetId = rs.getString("FSHEETID");
                if (!StringUtils.isEmpty((String)newSheetId)) {
                    newSheetId = (String)sheet.get(newSheetId);
                }
                String patchSql = sqlInsert.toString();
                patchSql = CslRptUtil.replaceSqlByParam(patchSql, "?", rs.getString("newid"), 2);
                patchSql = CslRptUtil.replaceSqlByParam(patchSql, "?", rs.getString("FDESCRIPTION"), 2);
                patchSql = CslRptUtil.replaceSqlByParam(patchSql, "?", newSheetId, 2);
                patchSql = CslRptUtil.replaceSqlByParam(patchSql, "?", rs.getString("FCELLNAME"), 2);
                patchSql = CslRptUtil.replaceSqlByParam(patchSql, "?", rs.getString("FCREATORID"), 2);
                patchSql = CslRptUtil.replaceSqlByParam(patchSql, "?", new Integer(rs.getInt("FPOSTILTYPE")), 1);
                patchSql = CslRptUtil.replaceSqlByParam(patchSql, "?", newId, 2);
                patchSql = CslRptUtil.replaceSqlByParam(patchSql, "?", rs.getDate("FCREATETIME"), 3);
                patchSql = CslRptUtil.replaceSqlByParam(patchSql, "?", rs.getDate("FLASTUPDATETIME"), 3);
                patchSql = CslRptUtil.replaceSqlByParam(patchSql, "?", rs.getString("FLASTUPDATEUSERID"), 2);
                patchSql = CslRptUtil.replaceSqlByParam(patchSql, "?", rs.getString("FITEMNUMBER"), 2);
                patchSql = CslRptUtil.replaceSqlByParam(patchSql, "?", new Integer(rs.getInt("FREPORTTYPE")), 1);
                patchSql = CslRptUtil.replaceSqlByParam(patchSql, "?", rs.getString("FCONTROLUNITID"), 2);
                st.addBatch(patchSql);
            }
            st.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
                catch (Exception e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }

    public static void addCSLPostil(Context ctx, String oldId, String newId, Map sheet) throws BOSException {
        StringBuffer sql = null;
        DbUtil.execute((Context)ctx, (String)"delete t_rpt_rptpostil where FREPORTID=?", (Object[])new Object[]{newId});
        DbUtil.execute((Context)ctx, (String)"delete t_csl_cslpostil where FREPORTID=?", (Object[])new Object[]{newId});
        UnionVersionUtil.addRPTPostil(ctx, oldId, newId, sheet);
        sql = new StringBuffer();
        sql.append(" insert into t_csl_cslpostil");
        sql.append(" (FID,FITEMNUMBER,FDATAELEMENT,FDESCRIPTION,FREPORTID,FVALUETYPE,FYEAR,FPERIOD, \n");
        sql.append(" FPOSTILTYPE,FCREATORID,FCREATETIME,FLASTUPDATEUSERID,FLASTUPDATETIME,FCONTROLUNITID) \n");
        sql.append(" select newBosId('").append(new CslPostilInfo().getBOSType().toString()).append("'), \n");
        sql.append(" FITEMNUMBER,FDATAELEMENT,FDESCRIPTION, \n");
        sql.append(" '").append(newId).append("',");
        sql.append(" FVALUETYPE,FYEAR,FPERIOD,FPOSTILTYPE,FCREATORID,FCREATETIME,FLASTUPDATEUSERID,FLASTUPDATETIME,FCONTROLUNITID \n");
        sql.append(" From t_csl_cslpostil \n");
        sql.append(" Where  FREPORTID ='").append(oldId).append("' ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static boolean isSumRptReport(int type) throws SQLException {
        return type == 3 || type == 2 || type == 8;
    }

    private static boolean isDynaSumRptReport(int type) throws SQLException {
        return type == 12 || type == 11;
    }

    public static void insertReportSheetPara(Context ctx, String oldId, String newId, Map sheet) throws BOSException {
        ArrayList<Object> param = null;
        StringBuffer sqlSelect = new StringBuffer();
        param = new ArrayList<Object>();
        sqlSelect.append(" select newBosId('").append(new RptSheetParamInfo().getBOSType().toString()).append("') as newid, \n");
        sqlSelect.append(" FID,FSHEETID,FSHEETNAME,FSTARTYEAR,FENDYEAR,FSTARTPERIOD,FENDPERIOD,FSTARTDATE, \n");
        sqlSelect.append(" FENDDATE,FISINCLUDINGUNPOSTED,FCURRENCYID,FREPORTID,FCREATETIME,FCREATORID,  \n");
        sqlSelect.append(" FLASTUPDATETIME,FLASTUPDATEUSERID,FRELATYPE,FCSLSHEETMANNER,FREPORTCLASS,FCONTROLUNITID \n");
        sqlSelect.append(" From t_rpt_RptSheetPara \n");
        sqlSelect.append(" Where  FREPORTID =? ");
        param.add(oldId);
        StringBuffer sqlInsert = new StringBuffer();
        sqlInsert.append(" insert into t_rpt_RptSheetPara");
        sqlInsert.append(" (FID,FSHEETID,FSHEETNAME,FSTARTYEAR,FENDYEAR,FSTARTPERIOD,FENDPERIOD, \n");
        sqlInsert.append(" FISINCLUDINGUNPOSTED,FREPORTID,FCREATETIME,FCREATORID,    \n");
        sqlInsert.append(" FLASTUPDATETIME,FLASTUPDATEUSERID,FRELATYPE,FCSLSHEETMANNER,FREPORTCLASS,FCONTROLUNITID \n");
        StringBuffer sqlInsertMaskInit = new StringBuffer();
        sqlInsertMaskInit.append(" ) values ( ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?");
        StringBuffer sqlInsertMask = new StringBuffer();
        StringBuffer exeSql = new StringBuffer();
        StringBuffer tmpWher = new StringBuffer();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlSelect.toString(), (Object[])param.toArray());
        try {
            while (rs.next()) {
                sheet.put(rs.getString("FID"), rs.getString("newid"));
                param = new ArrayList();
                param.add(rs.getString("newid"));
                param.add(rs.getString("FSheetID"));
                param.add(rs.getString("FSHEETNAME"));
                param.add(new Integer(rs.getInt("FSTARTYEAR")));
                param.add(new Integer(rs.getInt("FENDYEAR")));
                param.add(new Integer(rs.getInt("FSTARTPERIOD")));
                param.add(new Integer(rs.getInt("FENDPERIOD")));
                param.add(new Integer(rs.getInt("FISINCLUDINGUNPOSTED")));
                param.add(newId);
                param.add(rs.getDate("FCREATETIME"));
                param.add(rs.getString("FCREATORID"));
                param.add(rs.getDate("FLASTUPDATETIME"));
                param.add(rs.getString("FLASTUPDATEUSERID"));
                param.add(new Integer(rs.getInt("FRELATYPE")));
                param.add(new Integer(rs.getInt("FCSLSHEETMANNER")));
                param.add(new Integer(rs.getInt("FREPORTCLASS")));
                param.add(rs.getString("FCONTROLUNITID"));
                if (rs.getDate("FSTARTDATE") != null) {
                    tmpWher.append(",FSTARTDATE");
                    param.add(rs.getDate("FSTARTDATE"));
                    sqlInsertMask.append(",?");
                }
                if (rs.getDate("FENDDATE") != null) {
                    tmpWher.append(",FENDDATE");
                    param.add(rs.getDate("FENDDATE"));
                    sqlInsertMask.append(",?");
                }
                if (rs.getString("FCURRENCYID") != null) {
                    tmpWher.append(",FCURRENCYID");
                    param.add(rs.getString("FCURRENCYID"));
                    sqlInsertMask.append(",?");
                }
                sqlInsertMask.append(")");
                exeSql.append(sqlInsert).append(tmpWher).append(sqlInsertMaskInit).append(sqlInsertMask);
                DbUtil.execute((Context)ctx, (String)exeSql.toString(), (Object[])param.toArray());
                tmpWher.setLength(0);
                sqlInsertMask.setLength(0);
                exeSql.setLength(0);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private static void insertDynamicItemdataOne(Context ctx, IRowSet rs, Map itemdata, PreparedStatement ps, Map inter, Map exch) throws SQLException, BOSException, IOException {
        UnionVersionUtil.insertCslReport(rs, ps);
        Map entry = (Map)itemdata.get(rs.getString("FID"));
        if (entry != null) {
            String newItemdataId = (String)entry.get("newid");
            String oldItemdataId = (String)entry.get("oldid");
            UnionVersionUtil.insertDynamicItemdata(ctx, rs, rs.getString("newid"), newItemdataId, oldItemdataId);
        }
    }

    private static void insertDynamicItemdata(Context ctx, IRowSet rs, String newReportId, String newItemdataId, String oldItemdataId) throws SQLException, BOSException {
        StringBuffer sqlInsertItemdata = new StringBuffer();
        sqlInsertItemdata.append(" insert into t_csl_dynaitemdata(FID,FOrgUnitID,FSourceCurrencyID, \n");
        sqlInsertItemdata.append(" FCurrencyID,FPeriodType,FDataSource,FReportID,FCommitStatus, \n");
        sqlInsertItemdata.append(" FControlUnitID,FDataType,FDynaType,FDATACOLLECTNUMBER) \n");
        sqlInsertItemdata.append(" select ?,FOrgUnitID,FSourceCurrencyID, \n");
        sqlInsertItemdata.append(" FCurrencyID,FPeriodType,FDataSource,'").append(newReportId).append("', \n");
        sqlInsertItemdata.append(" FCommitStatus,FControlUnitID,FDataType,FDynaType,FDATACOLLECTNUMBER \n");
        sqlInsertItemdata.append(" From t_csl_dynaitemdata \n");
        sqlInsertItemdata.append(" where FId=? ");
        StringBuffer sqlInsertItemdataEntry = new StringBuffer();
        sqlInsertItemdataEntry.append(" insert into t_csl_dynaitemdataEntry(FID,FItemDataID,FItemID, \n");
        sqlInsertItemdataEntry.append(" FKeyNumber,FKeyName,FDataElement,FValueType,FYear,FPeriod,FValue, \n");
        sqlInsertItemdataEntry.append(" FTextValue,FDynaItemType, FGradeNumber) \n");
        sqlInsertItemdataEntry.append(" select newBosId('").append(new DynaItemDataEntryInfo().getBOSType().toString()).append("'),");
        sqlInsertItemdataEntry.append(" ?,FItemID, \n");
        sqlInsertItemdataEntry.append(" FKeyNumber,FKeyName,FDataElement,FValueType,FYear,FPeriod,FValue, \n");
        sqlInsertItemdataEntry.append(" FTextValue,FDynaItemType, FGradeNumber \n");
        sqlInsertItemdataEntry.append(" From t_csl_dynaitemdataEntry Where FItemdataID=?");
        DbUtil.execute((Context)ctx, (String)sqlInsertItemdata.toString(), (Object[])new Object[]{newItemdataId, oldItemdataId});
        DbUtil.execute((Context)ctx, (String)sqlInsertItemdataEntry.toString(), (Object[])new Object[]{newItemdataId, oldItemdataId});
    }

    private static void updateSourceRpt(Context ctx, String oldRptId, String newRptId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update t_csl_hisCslReport set FSourceRptId = ?");
        sql.append(" Where  FSourceRptId =? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{newRptId, oldRptId});
    }

    private static void updateSourceRpt(Context ctx, Map rptMapping, Map sumRptMapping) throws BOSException {
        String newRptId;
        Set set = rptMapping.keySet();
        for (String oldRptId : set) {
            newRptId = (String)rptMapping.get(oldRptId);
            UnionVersionUtil.updateSourceRpt(ctx, oldRptId, newRptId);
        }
        set = sumRptMapping.keySet();
        for (String oldRptId : set) {
            newRptId = (String)rptMapping.get(oldRptId);
            UnionVersionUtil.updateSourceRpt(ctx, oldRptId, newRptId);
        }
    }

    private static void insertItemdataOne(Context ctx, String oldTreeId, String newTreeId, IRowSet rs, PreparedStatement ps, List itemdatatables, Map inter, Map exch) throws SQLException, BOSException {
        UnionVersionUtil.insertCslReport(rs, ps);
        UnionVersionUtil.insertItemdata(ctx, itemdatatables, rs.getString("FItemdataId"), rs.getString("newid"));
    }

    private static void copyInterExchItemdataToHistory(Context ctx, Timestamp date, Map inter, Map exch, Map rpt, PeriodCollection periods, boolean isMergeByFiscalPeriod) throws BOSException {
        StringBuffer sqlInsert = null;
        StringBuffer sql = null;
        sql = new StringBuffer();
        sql.append(" select newbosid('").append(new RPTInterItemDataInfo().getBOSType().toString()).append("') as newid,");
        sql.append(" FID,FITEMNUMBER,FORGBOUNDID,FTARGETCOMPANYID, \n");
        sql.append(" FCOMPANYID,FCURRENCYID,FTARGETCURRENCYID,FYEAR,FPERIOD,FDAY,FMONEY,FITEMPOSTIL, \n");
        sql.append(" FPERIODTYPE,FCHECKAGESTATUS,FCHECKAGERECORD,FREPORT,FCOMMITSTATUS,FCOMMITDATE, \n");
        sql.append(" FSOURCETYPE,FIMPORTEDGROUP,FDATAELEMENT,FDATACOLLECTNUMBER \n");
        sql.append(" From t_csl_InterItemdata   \n");
        sql.append(" Where FDataCollectNumber='BUDGETDATA' \n");
        sql.append(" and ").append(UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        IRowSet rsInter = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rsInter.next()) {
                String newInterId = rsInter.getString("newid");
                String newCheckId = null;
                newCheckId = StringUtils.isEmpty((String)rsInter.getString("FCHECKAGERECORD")) ? "null" : (StringUtils.isEmpty((String)((String)inter.get(rsInter.getString("FCHECKAGERECORD")))) ? "null" : "'" + (String)inter.get(rsInter.getString("FCHECKAGERECORD")) + "'");
                String newReportId = null;
                if (StringUtils.isEmpty((String)rsInter.getString("FREPORT"))) continue;
                newReportId = StringUtils.isEmpty((String)((String)rpt.get(rsInter.getString("FREPORT")))) ? "'" + rsInter.getString("FREPORT") + "'" : "'" + (String)rpt.get(rsInter.getString("FREPORT")) + "'";
                sqlInsert = new StringBuffer();
                sqlInsert.append(" insert into T_CSL_HisInterItemdata(FID,FITEMNUMBER,FORGBOUNDID,FTARGETCOMPANYID, \n");
                sqlInsert.append(" FCOMPANYID,FCURRENCYID,FTARGETCURRENCYID,FYEAR,FPERIOD,FDAY,FMONEY,FITEMPOSTIL, \n");
                sqlInsert.append(" FPERIODTYPE,FCHECKAGESTATUS,FCHECKAGERECORD,FREPORT,FCOMMITSTATUS,FCOMMITDATE, \n");
                sqlInsert.append(" FSOURCETYPE,FIMPORTEDGROUP,FDATAELEMENT,FDATACOLLECTNUMBER) \n");
                sqlInsert.append(" values (");
                sqlInsert.append("'").append(newInterId).append("',");
                sqlInsert.append("'").append(rsInter.getString("FITEMNUMBER")).append("',");
                sqlInsert.append("'").append(rsInter.getString("FORGBOUNDID")).append("',");
                sqlInsert.append("'").append(rsInter.getString("FTARGETCOMPANYID")).append("',");
                sqlInsert.append("'").append(rsInter.getString("FCOMPANYID")).append("',");
                sqlInsert.append("'").append(rsInter.getString("FCURRENCYID")).append("',");
                sqlInsert.append("'").append(rsInter.getString("FTARGETCURRENCYID")).append("',");
                sqlInsert.append(rsInter.getInt("FYEAR")).append(",");
                sqlInsert.append(rsInter.getInt("FPERIOD")).append(",");
                sqlInsert.append(rsInter.getTimestamp("FDAY") == null ? "null," : "Timestamp'" + rsInter.getTimestamp("FDAY") + "',");
                sqlInsert.append(rsInter.getBigDecimal("FMONEY")).append(",");
                sqlInsert.append(rsInter.getString("FITEMPOSTIL") == null ? "null," : "'" + rsInter.getString("FITEMPOSTIL") + "',");
                sqlInsert.append(rsInter.getInt("FPERIODTYPE")).append(",");
                sqlInsert.append(rsInter.getInt("FCHECKAGESTATUS")).append(",");
                sqlInsert.append(newCheckId).append(",");
                sqlInsert.append(newReportId).append(",");
                sqlInsert.append(rsInter.getInt("FCOMMITSTATUS")).append(",");
                sqlInsert.append(rsInter.getTimestamp("FCOMMITDATE") == null ? "null," : "Timestamp'" + rsInter.getTimestamp("FCOMMITDATE") + "',");
                sqlInsert.append(rsInter.getInt("FSOURCETYPE")).append(",");
                sqlInsert.append("'").append(rsInter.getString("FIMPORTEDGROUP")).append("',");
                sqlInsert.append(rsInter.getInt("FDATAELEMENT")).append(",");
                sqlInsert.append("'").append(rsInter.getString("FDATACOLLECTNUMBER")).append("'");
                sqlInsert.append(")");
                DbUtil.execute((Context)ctx, (String)sqlInsert.toString());
            }
        }
        catch (UuidException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        sql = new StringBuffer();
        sql.append(" select newbosid('").append(new RPTExchItemDataInfo().getBOSType().toString()).append("') as newid,");
        sql.append(" FID,FITEMNUMBER,FORGBOUNDID,FTARGETCOMPANYID, \n");
        sql.append(" FCOMPANYID,FCURRENCYID,FTARGETCURRENCYID,FYEAR,FPERIOD,FDAY,FMONEY,FITEMPOSTIL, \n");
        sql.append(" FPERIODTYPE,FCHECKAGESTATUS,FCHECKAGERECORD,FREPORT,FCOMMITSTATUS,FCOMMITDATE, \n");
        sql.append(" FSOURCETYPE,FIMPORTEDGROUP,FDATAELEMENT,FDATACOLLECTNUMBER \n");
        sql.append(" From t_csl_ExchItemdata   \n");
        sql.append(" Where FDataCollectNumber='BUDGETDATA' \n");
        sql.append(" and ").append(UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        IRowSet rsExch = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rsExch.next()) {
                String newExchId = rsExch.getString("newid");
                String newCheckId = null;
                newCheckId = StringUtils.isEmpty((String)rsExch.getString("FCHECKAGERECORD")) ? "null" : (StringUtils.isEmpty((String)((String)inter.get(rsExch.getString("FCHECKAGERECORD")))) ? "null" : "'" + (String)inter.get(rsExch.getString("FCHECKAGERECORD")) + "'");
                String newReportId = null;
                if (StringUtils.isEmpty((String)rsExch.getString("FREPORT"))) continue;
                newReportId = StringUtils.isEmpty((String)((String)rpt.get(rsExch.getString("FREPORT")))) ? "'" + rsExch.getString("FREPORT") + "'" : "'" + (String)rpt.get(rsExch.getString("FREPORT")) + "'";
                sqlInsert = new StringBuffer();
                sqlInsert.append(" insert into t_csl_HisExchItemdata(FID,FITEMNUMBER,FORGBOUNDID,FTARGETCOMPANYID, \n");
                sqlInsert.append(" FCOMPANYID,FCURRENCYID,FTARGETCURRENCYID,FYEAR,FPERIOD,FDAY,FMONEY,FITEMPOSTIL, \n");
                sqlInsert.append(" FPERIODTYPE,FCHECKAGESTATUS,FCHECKAGERECORD,FREPORT,FCOMMITSTATUS,FCOMMITDATE, \n");
                sqlInsert.append(" FSOURCETYPE,FIMPORTEDGROUP,FDATAELEMENT,FDATACOLLECTNUMBER) \n");
                sqlInsert.append(" values (");
                sqlInsert.append("'").append(newExchId).append("',");
                sqlInsert.append("'").append(rsExch.getString("FITEMNUMBER")).append("',");
                sqlInsert.append("'").append(rsExch.getString("FORGBOUNDID")).append("',");
                sqlInsert.append("'").append(rsExch.getString("FTARGETCOMPANYID")).append("',");
                sqlInsert.append("'").append(rsExch.getString("FCOMPANYID")).append("',");
                sqlInsert.append("'").append(rsExch.getString("FCURRENCYID")).append("',");
                sqlInsert.append("'").append(rsExch.getString("FTARGETCURRENCYID")).append("',");
                sqlInsert.append(rsExch.getInt("FYEAR")).append(",");
                sqlInsert.append(rsExch.getInt("FPERIOD")).append(",");
                sqlInsert.append(rsExch.getTimestamp("FDAY") == null ? "null," : "Timestamp'" + rsExch.getTimestamp("FDAY") + "',");
                sqlInsert.append(rsExch.getBigDecimal("FMONEY")).append(",");
                sqlInsert.append(rsExch.getString("FITEMPOSTIL") == null ? "null," : "'" + rsExch.getString("FITEMPOSTIL") + "',");
                sqlInsert.append(rsExch.getInt("FPERIODTYPE")).append(",");
                sqlInsert.append(rsExch.getInt("FCHECKAGESTATUS")).append(",");
                sqlInsert.append(newCheckId).append(",");
                sqlInsert.append(newReportId).append(",");
                sqlInsert.append(rsExch.getInt("FCOMMITSTATUS")).append(",");
                sqlInsert.append(rsExch.getTimestamp("FCOMMITDATE") == null ? "null," : "Timestamp'" + rsExch.getTimestamp("FCOMMITDATE") + "',");
                sqlInsert.append(rsExch.getInt("FSOURCETYPE")).append(",");
                sqlInsert.append("'").append(rsExch.getString("FIMPORTEDGROUP")).append("',");
                sqlInsert.append(rsExch.getInt("FDATAELEMENT")).append(",");
                sqlInsert.append("'").append(rsExch.getString("FDATACOLLECTNUMBER")).append("'");
                sqlInsert.append(")");
                DbUtil.execute((Context)ctx, (String)sqlInsert.toString());
            }
        }
        catch (UuidException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private static void insertItemdata(Context ctx, List itemdatatables, String itemdataId, String newReportid) throws SQLException, BOSException {
        if (StringUtils.isEmpty((String)itemdataId)) {
            return;
        }
        String itemdataid = Uuid.create().toString();
        StringBuffer sqlInsertItemdata = new StringBuffer();
        sqlInsertItemdata.append(" insert into t_csl_itemdata(FID,FCOMPANYID,FCURRENCYID,FTARGETCURRENCYID, \n");
        sqlInsertItemdata.append(" FPERIODTYPE,FDATASOURCE,FREPORTID,FCOMMITSTATUS,FCOMMITDATE,FISADJUSTED, \n");
        sqlInsertItemdata.append(" FDATACOLLECTNUMBER) \n");
        sqlInsertItemdata.append(" select '").append(itemdataid).append("',FCompanyId,FCurrencyID, \n");
        sqlInsertItemdata.append(" FTargetCurrencyId,FPERIODTYPE,FDATASOURCE,'").append(newReportid.toString()).append("', \n");
        sqlInsertItemdata.append(" FCOMMITSTATUS,FCOMMITDATE,FISADJUSTED,FDATACOLLECTNUMBER \n");
        sqlInsertItemdata.append(" From t_csl_itemdata \n");
        sqlInsertItemdata.append(" where FId='").append(itemdataId).append("' ");
        StringBuffer sqlItemdataEntry = new StringBuffer();
        sqlItemdataEntry.append(" select FID,FITEMDATAID,FDATAELEMENT, \n");
        sqlItemdataEntry.append(" FVALUETYPE,FYEAR,FPERIOD,FDAY \n");
        sqlItemdataEntry.append(" From t_csl_itemdataentry \n");
        sqlItemdataEntry.append(" where FITEMDATAID= ? ");
        IRowSet rsItemdataEntry = DbUtil.executeQuery((Context)ctx, (String)sqlItemdataEntry.toString(), (Object[])new Object[]{itemdataId});
        StringBuffer sqlInsertItemdataEntry = new StringBuffer();
        ArrayList<String> sqlInsertItemdataEntryX = new ArrayList<String>();
        while (rsItemdataEntry.next()) {
            String itemdataEntryId = Uuid.create().toString();
            sqlInsertItemdataEntry.append(" insert into t_csl_itemdataentry(FID,FITEMDATAID,FDATAELEMENT, \n");
            sqlInsertItemdataEntry.append(" FVALUETYPE,FYEAR,FPERIOD,FDAY)");
            sqlInsertItemdataEntry.append(" values(");
            sqlInsertItemdataEntry.append("'").append(itemdataEntryId).append("',");
            sqlInsertItemdataEntry.append("'").append(itemdataid).append("',");
            sqlInsertItemdataEntry.append(rsItemdataEntry.getInt("FDataELEMENT")).append(",");
            sqlInsertItemdataEntry.append(rsItemdataEntry.getInt("FVALUETYPE")).append(",");
            sqlInsertItemdataEntry.append(rsItemdataEntry.getInt("FYEAR")).append(",");
            sqlInsertItemdataEntry.append(rsItemdataEntry.getInt("FPERIOD")).append(",");
            sqlInsertItemdataEntry.append("Timestamp'").append(rsItemdataEntry.getTimestamp("FDAY")).append("')");
            StringBuffer sqlInsertItemdataEntryXXX = null;
            int size = itemdatatables.size();
            for (int i = 0; i < size; ++i) {
                sqlInsertItemdataEntryXXX = new StringBuffer();
                sqlInsertItemdataEntryXXX.append(" insert into ").append(itemdatatables.get(i)).append("(FID,");
                UnionVersionUtil.addItemFiledsSQL(sqlInsertItemdataEntryXXX, i);
                sqlInsertItemdataEntryXXX.append(" ) ");
                sqlInsertItemdataEntryXXX.append(" select '").append(itemdataEntryId).append("',");
                UnionVersionUtil.addItemFiledsSQL(sqlInsertItemdataEntryXXX, i);
                sqlInsertItemdataEntryXXX.append(" From ").append(itemdatatables.get(i));
                sqlInsertItemdataEntryXXX.append(" where FID='").append(rsItemdataEntry.getString("FID")).append("'");
                sqlInsertItemdataEntryX.add(sqlInsertItemdataEntryXXX.toString());
            }
        }
        if (sqlInsertItemdata != null && sqlInsertItemdata.length() > 1) {
            DbUtil.execute((Context)ctx, (String)sqlInsertItemdata.toString());
        }
        if (sqlInsertItemdataEntry != null && sqlInsertItemdataEntry.length() > 1) {
            DbUtil.execute((Context)ctx, (String)sqlInsertItemdataEntry.toString());
        }
        int size = sqlInsertItemdataEntryX.size();
        for (int i = 0; i < size; ++i) {
            String itemsql = (String)sqlInsertItemdataEntryX.get(i);
            if (itemsql == null || itemsql.length() <= 0) continue;
            DbUtil.execute((Context)ctx, (String)itemsql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertCslReport(IRowSet rs, PreparedStatement ps) throws SQLException, BOSException {
        ps.setString(1, rs.getString("newid"));
        ps.setString(2, rs.getString("FNumber"));
        ps.setString(3, rs.getString("FName"));
        ps.setString(4, rs.getString("FORGTREEID"));
        ps.setString(5, rs.getString("FORGUNITID"));
        ps.setInt(6, rs.getInt("FYEAR"));
        ps.setInt(7, rs.getInt("FPERIOD"));
        ps.setDate(8, rs.getDate("FSTARTDATE"));
        ps.setDate(9, rs.getDate("FENDDATE"));
        ps.setString(10, rs.getString("FCREATORID"));
        ps.setDate(11, rs.getDate("FCREATETIME"));
        ps.setString(12, rs.getString("FTEMPLATEID"));
        ps.setString(13, rs.getString("FLASTUPDATEUSERID"));
        ps.setDate(14, rs.getDate("FLASTUPDATETIME"));
        ps.setString(15, rs.getString("FDESCRIPTION"));
        ps.setString(16, rs.getString("FAUDITORID"));
        ps.setString(17, rs.getString("FCOMPANYID"));
        ps.setInt(18, rs.getInt("FPERIODTYPE"));
        ps.setInt(19, rs.getInt("FPUBLICSTATUS"));
        ps.setInt(20, rs.getInt("FPUBLISHEDSTATUS"));
        ps.setInt(21, rs.getInt("FCOMMITTEDSTATUS"));
        ps.setInt(22, rs.getInt("FHANDLESTATUS"));
        ps.setInt(23, rs.getInt("FSOURCETYPE"));
        ps.setString(24, rs.getString("FCURRENCYID"));
        ps.setDate(25, rs.getDate("FAUDITEDTIME"));
        ps.setInt(26, rs.getInt("FAUDITEDSTATUS"));
        ps.setInt(27, rs.getInt("FCHECKEDSTATUS"));
        Blob b = rs.getBlob("FData");
        InputStream iStrm = null;
        try {
            iStrm = b.getBinaryStream();
            byte[] bytes = CslRptUtil.InputStreamToByte(iStrm);
            ps.setBytes(28, bytes);
            ps.setString(29, rs.getString("FSOURCECURRENCYID"));
            ps.setDate(30, rs.getDate("FREPORTDATE"));
            ps.setString(31, rs.getString("FSOURCERPTID"));
            ps.setString(32, rs.getString("FCONTROLUNITID"));
            ps.setInt(33, rs.getInt("FADJUSTSTATUS"));
            ps.setInt(34, rs.getInt("FCONVERTSTATUS"));
            ps.setInt(35, rs.getInt("FISCOMMITREPORT"));
            ps.setInt(36, rs.getInt("FDYNARPTTYPE"));
            ps.setInt(37, rs.getInt("FISSAVEAS"));
            ps.setInt(38, rs.getInt("FSAVEASVERSIONNUM"));
            ps.setString(39, rs.getString("FREMARK"));
            ps.setDate(40, rs.getDate("FCOMMITTIME"));
            ps.setDate(41, rs.getDate("FRECEIVETIME"));
            ps.setString(42, rs.getString("FCOMMITORID"));
            ps.setString(43, rs.getString("FRECEIVERID"));
            ps.setInt(44, rs.getInt("FRECEIVESTATUS"));
            ps.setString(45, rs.getString("FDATACOLLECTID"));
            ps.setString(46, rs.getString("FDATACOLLECTNUMBER"));
            ps.setString(47, rs.getString("FID"));
            ps.execute();
        }
        finally {
            CslRptUtil.closeInputStream(iStrm);
        }
    }

    private static void copyRptReceivedToHistory(Context ctx, String oldUnionID, String newUnionID, Timestamp date, Map rptMapping, Map sumRptMapping, Map adjustMapping, Map caliAdjustMapping, PeriodCollection periods, boolean isMergeByFiscalPeriod) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select newbosid('").append(new HisRptReceivedInfo().getBOSType().toString()).append("') as newid,");
        sql.append(" FID,FREPORTID,FORGTREEID,FCREATORID,FCREATETIME, \n");
        sql.append(" FLASTUPDATEUSERID,FLASTUPDATETIME \n");
        sql.append(" From t_csl_rptreceived   \n");
        sql.append(" where \n");
        sql.append(" FID in ( ");
        sql.append("     select rec.FID as FID from t_csl_rptreceived rec ");
        sql.append("     inner join t_csl_cslreport rpt on rpt.fid = rec.freportid and rpt.fsourcetype in (1,7,10)");
        sql.append("     where rpt.FDataCollectNumber='BUDGETDATA' and rec.forgtreeid = '" + oldUnionID + "'  ");
        sql.append("        and " + UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        sql.append(" ) ");
        sql.append(" OR FID in ( ");
        sql.append("     select rec.FID as FID from t_csl_rptreceived rec ");
        sql.append("     inner join t_csl_adjust rpt on rpt.fid = rec.freportid ");
        sql.append("     where rpt.FDataCollectNumber='BUDGETDATA' and  rec.forgtreeid = '" + oldUnionID + "'  ");
        sql.append("        and " + UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        sql.append(" ) ");
        sql.append(" OR FID in ( ");
        sql.append("     select rec.FID as FID from t_csl_rptreceived rec ");
        sql.append("     inner join t_csl_caliadjust rpt on rpt.fid = rec.freportid ");
        sql.append("     where rpt.FDataCollectNumber='BUDGETDATA' and  rec.forgtreeid = '" + oldUnionID + "'  ");
        sql.append("        and " + UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        sql.append(" ) ");
        sql.append(" OR FID in ( ");
        sql.append("     select rec.FID as FID from t_csl_rptreceived rec ");
        sql.append("     inner join t_csl_cslreport rpt on rpt.fid = rec.freportid and rpt.fsourcetype in (2,3,4,8,11,12,31,32,33,34,35)");
        sql.append("     where rpt.FDataCollectNumber='BUDGETDATA' and  rec.forgtreeid = '" + oldUnionID + "'  ");
        sql.append("        and " + UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        sql.append(" ) ");
        StringBuffer sqlInsert = new StringBuffer();
        sqlInsert.append("insert into t_csl_hisRptReceived(FID,FREPORTID,FORGTREEID,FCREATORID,FCREATETIME, \n");
        sqlInsert.append(" FLASTUPDATEUSERID,FLASTUPDATETIME) \n");
        sqlInsert.append(" values(?,?,?,?,?,?,?) \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        Connection cn = null;
        PreparedStatement ps = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            ps = cn.prepareStatement(sqlInsert.toString());
            while (rs.next()) {
                String newRptId = null;
                newRptId = rptMapping.get(rs.getString("FREPORTID")) != null ? (String)rptMapping.get(rs.getString("FREPORTID")) : (sumRptMapping.get(rs.getString("FREPORTID")) != null ? (String)sumRptMapping.get(rs.getString("FREPORTID")) : (adjustMapping.get(rs.getString("FREPORTID")) != null ? (String)adjustMapping.get(rs.getString("FREPORTID")) : (caliAdjustMapping.get(rs.getString("FREPORTID")) != null ? (String)caliAdjustMapping.get(rs.getString("FREPORTID")) : rs.getString("FREPORTID"))));
                ps.setString(1, rs.getString("newid"));
                ps.setString(2, newRptId);
                ps.setString(3, rs.getString("FOrgTreeId"));
                ps.setString(4, rs.getString("FCREATORID"));
                ps.setDate(5, rs.getDate("FCREATETIME"));
                ps.setString(6, rs.getString("FLASTUPDATEUSERID"));
                ps.setDate(7, rs.getDate("FLASTUPDATETIME"));
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
    }

    private static void addItemFiledsSQL(StringBuffer sqlInsertItemdataEntryXXX, int index) {
        int start = index * 300 + 1;
        int end = (index + 1) * 300;
        if (sqlInsertItemdataEntryXXX != null) {
            for (int j = start; j <= end; ++j) {
                sqlInsertItemdataEntryXXX.append("F").append(j);
                if (j >= end) continue;
                sqlInsertItemdataEntryXXX.append(",");
            }
        }
    }

    private static void copyAdjustToHistory(Context ctx, String oldTreeId, String newTreeId, Timestamp date, Map adjustMapping, PeriodCollection periods, boolean isMergeByFiscalPeriod) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select i.FID as FItemdataId,newBosId('").append(new HisAdjustInfo().getBOSType().toString()).append("') as newid,");
        sql.append(" a.FID,a.FNUMBER,a.FBIZDATE,a.FYEAR,a.FPERIOD,a.FDATE,a.FCREATORID,a.FCREATETIME, \n");
        sql.append(" a.FLASTUPDATEUSERID,a.FLASTUPDATETIME,a.FHANDLERID,a.FDESCRIPTION,a.FHASEFFECTED,a.FAUDITORID, \n");
        sql.append(" a.FSOURCEBILLID,a.FSOURCEFUNCTION,a.FCOMPANYID,a.FCURRENCYID,a.FORGBOUNDID,a.FORGUNIT,a.FAUDITDATE, \n");
        sql.append(" a.FPERIODTYPE,a.FCHECKEDSTATUS,a.FDATASOURCE,a.FTEMPLETID,a.FARCHIVEDSTATUS,a.FVALUETYPE,a.FADJUSTMODE, \n");
        sql.append(" a.FCONTROLUNITID,a.FISCITEDBYLATER,a.FSOURCECURRENCYID,a.FCONVERTBEFOREID,a.FDATACOLLECTID, \n");
        sql.append(" a.FDATACOLLECTNUMBER,a.FISFIXED,a.FRemark \n");
        sql.append(" From t_csl_Adjust a \n");
        sql.append(" left join t_csl_itemdata i on a.FID=i.FReportId \n");
        sql.append(" Where  a.FORGBOUNDID = ? \n");
        sql.append(" and a.FDataCollectNumber = '").append("BUDGETDATA").append("' \n");
        sql.append(" and ").append(UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (String)"a", (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        sql.append(" order by a.FCONVERTBEFOREID asc ");
        StringBuffer sqlInsertAdjust = new StringBuffer();
        sqlInsertAdjust.append(" insert into t_csl_hisAdjust(FID,FNUMBER,FBIZDATE,FYEAR,FPERIOD,FDATE,FCREATORID,FCREATETIME, \n");
        sqlInsertAdjust.append(" FLASTUPDATEUSERID,FLASTUPDATETIME,FHANDLERID,FDESCRIPTION,FHASEFFECTED,FAUDITORID, \n");
        sqlInsertAdjust.append(" FSOURCEBILLID,FSOURCEFUNCTION,FCOMPANYID,FCURRENCYID,FORGBOUNDID,FORGUNIT,FAUDITDATE, \n");
        sqlInsertAdjust.append(" FPERIODTYPE,FCHECKEDSTATUS,FDATASOURCE,FTEMPLETID,FARCHIVEDSTATUS,FVALUETYPE,FADJUSTMODE, \n");
        sqlInsertAdjust.append(" FCONTROLUNITID,FISCITEDBYLATER,FSOURCECURRENCYID,FCONVERTBEFOREID,FDATACOLLECTID, \n");
        sqlInsertAdjust.append(" FDATACOLLECTNUMBER,FISFIXED,FRemark,FOriginalID) \n");
        sqlInsertAdjust.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        StringBuffer sqlInsertEntry = new StringBuffer();
        sqlInsertEntry.append(" insert into t_csl_hisAdjustEntry(FID,FSEQ,FCREATORID,FCREATETIME,FLASTUPDATEUSERID, \n");
        sqlInsertEntry.append(" FLASTUPDATETIME,FITEMID,FDEBIT,FCREDIT,FSUMMARY,FDATAELEMENT,FADJUSTID,FISVISIBLE) \n");
        sqlInsertEntry.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?)");
        StringBuffer sqlInsertDynaEntry = new StringBuffer();
        sqlInsertDynaEntry.append(" insert into T_CSL_HisAdjustDynamicItem(FID,FSEQ,FADJUSTENTRYID,FRPTITEMID,FKEYLONGNUMBER, \n");
        sqlInsertDynaEntry.append(" FKEYNUMBER,FKEYNAME,FVALUE,FASSTACTTYPENUMBER,FREMARK_L1,FREMARK_L2, \n");
        sqlInsertDynaEntry.append(" FREMARK_L3,FISAUTOCREATED) \n");
        sqlInsertDynaEntry.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?) \n");
        ArrayList<String> param = new ArrayList<String>();
        param.add(oldTreeId);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        Connection cn = null;
        PreparedStatement ps = null;
        PreparedStatement psEntry = null;
        PreparedStatement psDynaEntry = null;
        Statement st = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            String sqlInsertAdjuststr = sqlInsertAdjust.toString();
            String sqlInsertEntrystr = sqlInsertEntry.toString();
            String sqlInsertDynaEntrystr = sqlInsertDynaEntry.toString();
            ps = cn.prepareStatement(sqlInsertAdjuststr);
            psEntry = cn.prepareStatement(sqlInsertEntrystr);
            psDynaEntry = cn.prepareStatement(sqlInsertDynaEntrystr);
            st = cn.createStatement();
            List itemdatatables = UnionVersionUtil.getItemdataTables(ctx);
            while (rs.next()) {
                String oldId = rs.getString("FID");
                String newId = rs.getString("newid");
                adjustMapping.put(oldId, newId);
                ps.setString(1, newId);
                ps.setString(2, rs.getString("FNUMBER"));
                ps.setDate(3, rs.getDate("FBIZDATE"));
                ps.setInt(4, rs.getInt("FYear"));
                ps.setInt(5, rs.getInt("FPeriod"));
                ps.setDate(6, rs.getDate("FDate"));
                ps.setString(7, rs.getString("FCREATORID"));
                ps.setDate(8, rs.getDate("FCREATETIME"));
                ps.setString(9, rs.getString("FLASTUPDATEUSERID"));
                ps.setDate(10, rs.getDate("FLASTUPDATETIME"));
                ps.setString(11, rs.getString("FHANDLERID"));
                ps.setString(12, rs.getString("FDESCRIPTION"));
                ps.setInt(13, rs.getInt("FHASEFFECTED"));
                ps.setString(14, rs.getString("FAUDITORID"));
                ps.setString(15, rs.getString("FSOURCEBILLID"));
                ps.setString(16, rs.getString("FSOURCEFUNCTION"));
                ps.setString(17, rs.getString("FCOMPANYID"));
                ps.setString(18, rs.getString("FCURRENCYID"));
                ps.setString(19, rs.getString("FORGBOUNDID"));
                ps.setString(20, rs.getString("FORGUNIT"));
                ps.setDate(21, rs.getDate("FAUDITDATE"));
                ps.setInt(22, rs.getInt("FPERIODTYPE"));
                ps.setInt(23, rs.getInt("FCHECKEDSTATUS"));
                ps.setInt(24, rs.getInt("FDATASOURCE"));
                ps.setString(25, rs.getString("FTEMPLETID"));
                ps.setInt(26, rs.getInt("FARCHIVEDSTATUS"));
                ps.setInt(27, rs.getInt("FVALUETYPE"));
                ps.setString(28, rs.getString("FADJUSTMODE"));
                ps.setString(29, rs.getString("FCONTROLUNITID"));
                ps.setInt(30, rs.getInt("FISCITEDBYLATER"));
                ps.setString(31, rs.getString("FSOURCECURRENCYID"));
                ps.setString(32, rs.getString("FCONVERTBEFOREID"));
                ps.setString(33, rs.getString("FDATACOLLECTID"));
                ps.setString(34, rs.getString("FDATACOLLECTNUMBER"));
                ps.setInt(35, rs.getInt("FISFIXED"));
                ps.setString(36, rs.getString("FRemark"));
                ps.setString(37, oldId);
                ps.addBatch();
                sql = new StringBuffer();
                sql.append(" select newbosid('").append(new HisAdjustEntryInfo().getBOSType().toString()).append("') as newid,");
                sql.append(" entry.FID,entry.FSEQ,entry.FCREATORID,entry.FCREATETIME,entry.FLASTUPDATEUSERID, \n");
                sql.append(" entry.FLASTUPDATETIME,entry.FITEMID,entry.FDEBIT,entry.FCREDIT,entry.FSUMMARY,entry.FDATAELEMENT,entry.FADJUSTID,entry.FISVISIBLE \n");
                sql.append(" From t_csl_AdjustEntry entry \n");
                sql.append(" Where FAdjustId = ? \n");
                IRowSet rsEntry = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{oldId});
                while (rsEntry.next()) {
                    String oldEntryId = rsEntry.getString("FID");
                    String newEntryId = rsEntry.getString("newId");
                    psEntry.setString(1, newEntryId);
                    psEntry.setInt(2, rsEntry.getInt("FSEQ"));
                    psEntry.setString(3, rsEntry.getString("FCREATORID"));
                    psEntry.setDate(4, rsEntry.getDate("FCREATETIME"));
                    psEntry.setString(5, rsEntry.getString("FLASTUPDATEUSERID"));
                    psEntry.setDate(6, rsEntry.getDate("FLASTUPDATETIME"));
                    psEntry.setString(7, rsEntry.getString("FITEMID"));
                    psEntry.setBigDecimal(8, rsEntry.getBigDecimal("FDEBIT"));
                    psEntry.setBigDecimal(9, rsEntry.getBigDecimal("FCREDIT"));
                    psEntry.setString(10, rsEntry.getString("FSUMMARY"));
                    psEntry.setInt(11, rsEntry.getInt("FDATAELEMENT"));
                    psEntry.setString(12, newId);
                    psEntry.setInt(13, rsEntry.getInt("FISVISIBLE"));
                    psEntry.addBatch();
                    sql = new StringBuffer();
                    sql.append(" select newbosid('").append(new HisAdjustDynamicItemInfo().getBOSType().toString()).append("') as newid,");
                    sql.append(" dyna.FSEQ,dyna.FADJUSTENTRYID,");
                    sql.append(" dyna.FRPTITEMID,dyna.FKEYLONGNUMBER, \n");
                    sql.append(" dyna.FKEYNUMBER,dyna.FKEYNAME,dyna.FVALUE,dyna.FASSTACTTYPENUMBER,dyna.FREMARK_L1,dyna.FREMARK_L2, \n");
                    sql.append(" dyna.FREMARK_L3,dyna.FISAUTOCREATED \n");
                    sql.append(" From T_CSL_AdjustDynamicItem dyna join t_csl_adjustEntry entry on dyna.FAdjustEntryId=entry.FID \n");
                    sql.append(" where dyna.fAdjustEntryId=? ");
                    IRowSet rsDyna = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{oldEntryId});
                    while (rsDyna.next()) {
                        psDynaEntry.setString(1, rsDyna.getString("newid"));
                        psDynaEntry.setInt(2, rsDyna.getInt("FSEQ"));
                        psDynaEntry.setString(3, newEntryId);
                        psDynaEntry.setString(4, rsDyna.getString("FRPTITEMID"));
                        psDynaEntry.setString(5, rsDyna.getString("FKEYLONGNUMBER"));
                        psDynaEntry.setString(6, rsDyna.getString("FKEYNUMBER"));
                        psDynaEntry.setString(7, rsDyna.getString("FKEYNAME"));
                        psDynaEntry.setBigDecimal(8, rsDyna.getBigDecimal("FVALUE"));
                        psDynaEntry.setString(9, rsDyna.getString("FASSTACTTYPENUMBER"));
                        psDynaEntry.setString(10, rsDyna.getString("FREMARK_L1"));
                        psDynaEntry.setString(11, rsDyna.getString("FREMARK_L2"));
                        psDynaEntry.setString(12, rsDyna.getString("FREMARK_L3"));
                        psDynaEntry.setInt(13, rsDyna.getInt("FISAUTOCREATED"));
                        psDynaEntry.addBatch();
                    }
                }
                UnionVersionUtil.updateConvertBeforeId(ctx, st, oldId, newId, true);
                UnionVersionUtil.insertItemdata(ctx, itemdatatables, rs.getString("FItemdataId"), rs.getString("newid"));
                UnionVersionUtil.addAttachment(ctx, oldId, newId);
            }
            ps.executeBatch();
            psEntry.executeBatch();
            psDynaEntry.executeBatch();
            st.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup(psEntry);
                SQLUtils.cleanup(psDynaEntry);
                SQLUtils.cleanup(st);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Statement)psEntry);
        SQLUtils.cleanup((Statement)psDynaEntry);
        SQLUtils.cleanup((Statement)st);
        SQLUtils.cleanup((Connection)cn);
    }

    private static void updateConvertBeforeId(Context ctx, Statement st, String oldId, String newId, boolean isAdjusted) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(isAdjusted ? "T_CSL_HisAdjust" : "T_CSL_HisElimination");
        sql.append(" set FCONVERTBEFOREID='").append(newId).append("' ");
        sql.append(" where FCONVERTBEFOREID='").append(oldId).append("' ");
        try {
            st.addBatch(sql.toString());
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private static void copyCaliAdjustToHistory(Context ctx, String oldTreeId, String newTreeId, Timestamp date, Map caliAdjustMapping, PeriodCollection periods, boolean isMergeByFiscalPeriod) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select i.FID as FItemdataId,newBosId('").append(new HisCaliAdjustInfo().getBOSType().toString()).append("') as newid,");
        sql.append(" a.FID,a.FNUMBER,a.FBIZDATE,a.FYEAR,a.FPERIOD,a.FDATE,a.FCREATORID,a.FCREATETIME, \n");
        sql.append(" a.FLASTUPDATEUSERID,a.FLASTUPDATETIME,a.FHANDLERID,a.FDESCRIPTION,a.FHASEFFECTED,a.FAUDITORID, \n");
        sql.append(" a.FSOURCEBILLID,a.FSOURCEFUNCTION,a.FCOMPANYID,a.FCURRENCYID,a.FORGBOUNDID,a.FORGUNITID,a.FAUDITDATE, \n");
        sql.append(" a.FPERIODTYPE,a.FCHECKEDSTATUS,a.FDATASOURCE,a.FTEMPLETID,a.FARCHIVEDSTATUS,a.FVALUETYPE,a.FADJUSTMODEID, \n");
        sql.append(" a.FCONTROLUNITID,a.FISCITEDBYLATER,a.FSOURCECURRENCYID,a.FCONVERTBEFORE,a.FDATACOLLECTID, \n");
        sql.append(" a.FDATACOLLECTNUMBER,a.FISFIXED \n");
        sql.append(" From t_csl_CaliAdjust a \n");
        sql.append(" left join t_csl_Itemdata i on a.FID=i.FReportId  \n");
        sql.append(" Where  a.FORGBOUNDID = ? \n");
        sql.append(" and a.FDataCollectNumber = '").append("BUDGETDATA").append("' \n");
        sql.append(" and ").append(UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (String)"a", (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        StringBuffer sqlInsertAdjust = new StringBuffer();
        sqlInsertAdjust.append(" insert into t_csl_hisCaliAdjust(FID,FNUMBER,FBIZDATE,FYEAR,FPERIOD,FDATE,FCREATORID,FCREATETIME, \n");
        sqlInsertAdjust.append(" FLASTUPDATEUSERID,FLASTUPDATETIME,FHANDLERID,FDESCRIPTION,FHASEFFECTED,FAUDITORID, \n");
        sqlInsertAdjust.append(" FSOURCEBILLID,FSOURCEFUNCTION,FCOMPANYID,FCURRENCYID,FORGBOUNDID,FORGUNITID,FAUDITDATE, \n");
        sqlInsertAdjust.append(" FPERIODTYPE,FCHECKEDSTATUS,FDATASOURCE,FTEMPLETID,FARCHIVEDSTATUS,FVALUETYPE,FADJUSTMODEID, \n");
        sqlInsertAdjust.append(" FCONTROLUNITID,FISCITEDBYLATER,FSOURCECURRENCYID,FCONVERTBEFORE,FDATACOLLECTID, \n");
        sqlInsertAdjust.append(" FDATACOLLECTNUMBER,FISFIXED,FOriginalID) \n");
        sqlInsertAdjust.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        StringBuffer sqlInsertEntry = new StringBuffer();
        sqlInsertEntry.append(" insert into t_csl_hisCaliAdjustEntry(FID,FSEQ, \n");
        sqlInsertEntry.append(" FITEMID,FDEBIT,FCREDIT,FSUMMARY,FDATAELEMENT,FADJUSTID,FISVISIBLE) \n");
        sqlInsertEntry.append(" values(?,?,?,?,?,?,?,?,?)");
        ArrayList<String> param = new ArrayList<String>();
        param.add(oldTreeId);
        String sqlstr = sql.toString();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlstr, (Object[])param.toArray());
        Connection cn = null;
        PreparedStatement ps = null;
        PreparedStatement psEntry = null;
        Statement st = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            ps = cn.prepareStatement(sqlInsertAdjust.toString());
            psEntry = cn.prepareStatement(sqlInsertEntry.toString());
            st = cn.createStatement();
            List itemdatatables = UnionVersionUtil.getItemdataTables(ctx);
            while (rs.next()) {
                String oldId = rs.getString("FID");
                String newId = rs.getString("newid");
                caliAdjustMapping.put(oldId, newId);
                ps.setString(1, newId);
                ps.setString(2, rs.getString("FNUMBER"));
                ps.setDate(3, rs.getDate("FBIZDATE"));
                ps.setInt(4, rs.getInt("FYear"));
                ps.setInt(5, rs.getInt("FPeriod"));
                ps.setDate(6, rs.getDate("FDate"));
                ps.setString(7, rs.getString("FCREATORID"));
                ps.setDate(8, rs.getDate("FCREATETIME"));
                ps.setString(9, rs.getString("FLASTUPDATEUSERID"));
                ps.setDate(10, rs.getDate("FLASTUPDATETIME"));
                ps.setString(11, rs.getString("FHANDLERID"));
                ps.setString(12, rs.getString("FDESCRIPTION"));
                ps.setInt(13, rs.getInt("FHASEFFECTED"));
                ps.setString(14, rs.getString("FAUDITORID"));
                ps.setString(15, rs.getString("FSOURCEBILLID"));
                ps.setString(16, rs.getString("FSOURCEFUNCTION"));
                ps.setString(17, rs.getString("FCOMPANYID"));
                ps.setString(18, rs.getString("FCURRENCYID"));
                ps.setString(19, rs.getString("FORGBOUNDID"));
                ps.setString(20, rs.getString("FORGUNITID"));
                ps.setDate(21, rs.getDate("FAUDITDATE"));
                ps.setInt(22, rs.getInt("FPERIODTYPE"));
                ps.setInt(23, rs.getInt("FCHECKEDSTATUS"));
                ps.setInt(24, rs.getInt("FDATASOURCE"));
                ps.setString(25, rs.getString("FTEMPLETID"));
                ps.setInt(26, rs.getInt("FARCHIVEDSTATUS"));
                ps.setInt(27, rs.getInt("FVALUETYPE"));
                ps.setString(28, rs.getString("FADJUSTMODEID"));
                ps.setString(29, rs.getString("FCONTROLUNITID"));
                ps.setInt(30, rs.getInt("FISCITEDBYLATER"));
                ps.setString(31, rs.getString("FSOURCECURRENCYID"));
                ps.setString(32, rs.getString("FCONVERTBEFORE"));
                ps.setString(33, rs.getString("FDATACOLLECTID"));
                ps.setString(34, rs.getString("FDATACOLLECTNUMBER"));
                ps.setInt(35, rs.getInt("FISFIXED"));
                ps.setString(36, oldId);
                ps.addBatch();
                sql = new StringBuffer();
                sql.append(" select newbosid('").append(new HisCaliAdjustEntryInfo().getBOSType().toString()).append("') as newid,");
                sql.append(" entry.FID,entry.FSEQ,entry.FITEMID,entry.FDEBIT,entry.FCREDIT, \n");
                sql.append(" entry.FSUMMARY,entry.FDATAELEMENT,entry.FADJUSTID,entry.FISVISIBLE \n");
                sql.append(" From t_csl_CaliAdjustEntry entry \n");
                sql.append(" Where FAdjustId = ? \n");
                IRowSet rsEntry = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{oldId});
                while (rsEntry.next()) {
                    String oldEntryId = rsEntry.getString("FID");
                    String newEntryId = rsEntry.getString("newId");
                    psEntry.setString(1, newEntryId);
                    psEntry.setInt(2, rsEntry.getInt("FSEQ"));
                    psEntry.setString(3, rsEntry.getString("FITEMID"));
                    psEntry.setBigDecimal(4, rsEntry.getBigDecimal("FDEBIT"));
                    psEntry.setBigDecimal(5, rsEntry.getBigDecimal("FCREDIT"));
                    psEntry.setString(6, rsEntry.getString("FSUMMARY"));
                    psEntry.setInt(7, rsEntry.getInt("FDATAELEMENT"));
                    psEntry.setString(8, newId);
                    psEntry.setInt(9, rsEntry.getInt("FISVISIBLE"));
                    psEntry.addBatch();
                }
                UnionVersionUtil.insertItemdata(ctx, itemdatatables, rs.getString("FItemdataId"), rs.getString("newid"));
                UnionVersionUtil.addAttachment(ctx, oldId, newId);
            }
            ps.executeBatch();
            psEntry.executeBatch();
            st.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup(psEntry);
                SQLUtils.cleanup(st);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Statement)psEntry);
        SQLUtils.cleanup((Statement)st);
        SQLUtils.cleanup((Connection)cn);
    }

    private static Map copyEliminationToHistory(Context ctx, String oldTreeId, String newTreeId, Timestamp date, PeriodCollection periods, boolean isMergeByFiscalPeriod) throws BOSException, EASBizException {
        HashMap<String, String> ret = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select newBosId('").append(new HisEliminationInfo().getBOSType().toString()).append("') as newid,");
        sql.append(" FID,FNUMBER,FBIZDATE,FYEAR,FPERIOD,FDATE,FCREATORID,FCREATETIME,      \n");
        sql.append(" FLASTUPDATEUSERID,FLASTUPDATETIME,FHANDLERID,FDESCRIPTION,FHASEFFECTED,FAUDITORID, \n");
        sql.append(" FSOURCEBILLID,FSOURCEFUNCTION,FCOMPANYID,FCURRENCYID,FORGBOUNDID,FORGUNIT,FAUDITDATE, \n");
        sql.append(" FPERIODTYPE,FCHECKEDSTATUS,FDATASOURCE,FTEMPLETID,FARCHIVEDSTATUS,FVALUETYPE,FELIMTYPE, \n");
        sql.append(" FCONTROLUNITID,FISCITEDBYLATER,FSOURCECURRENCYID,FCONVERTBEFOREID, \n");
        sql.append(" FDATACOLLECTID,FDATACOLLECTNUMBER,FISFIXED,FDISPLAYTEMPLATETYPEID,FRemark,FinvestNewType \n");
        sql.append(" From t_csl_Elimination a \n");
        sql.append(" Where  FORGBOUNDID = ? \n");
        sql.append(" and a.FDataCollectNumber = '").append("BUDGETDATA").append("' \n");
        sql.append(" and ").append(UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        sql.append(" order by FCONVERTBEFOREID Asc ");
        StringBuffer sqlInsertElim = new StringBuffer();
        sqlInsertElim.append(" insert into t_csl_hisElimination(FID,FNUMBER,FBIZDATE,FYEAR,FPERIOD,FDATE,FCREATORID,FCREATETIME,      \n");
        sqlInsertElim.append(" FLASTUPDATEUSERID,FLASTUPDATETIME,FHANDLERID,FDESCRIPTION,FHASEFFECTED,FAUDITORID, \n");
        sqlInsertElim.append(" FSOURCEBILLID,FSOURCEFUNCTION,FCOMPANYID,FCURRENCYID,FORGBOUNDID,FORGUNIT,FAUDITDATE, \n");
        sqlInsertElim.append(" FPERIODTYPE,FCHECKEDSTATUS,FDATASOURCE,FTEMPLETID,FARCHIVEDSTATUS,FVALUETYPE,FELIMTYPE, \n");
        sqlInsertElim.append(" FCONTROLUNITID,FISCITEDBYLATER,FSOURCECURRENCYID,FCONVERTBEFOREID, \n");
        sqlInsertElim.append(" FDATACOLLECTID,FDATACOLLECTNUMBER,FISFIXED,FDISPLAYTEMPLATETYPEID,FRemark,FinvestNewType) \n");
        sqlInsertElim.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        StringBuffer sqlInsertEntry = new StringBuffer();
        sqlInsertEntry.append(" insert into t_csl_hisEliminationEntry(FID,FSEQ,FITEMID,FDEBIT,FCREDIT,FSUMMARY, \n");
        sqlInsertEntry.append(" FELIMINATIONID,FDATAELEMENT,FCOMPANYID,FISVISIBLE) \n");
        sqlInsertEntry.append(" values(?,?,?,?,?,?,?,?,?,?)");
        StringBuffer sqlInsertDynaEntry = new StringBuffer();
        sqlInsertDynaEntry.append(" insert into T_CSL_HisElimDynaItemEntry(FID,FSEQ,FELIMINATIONENTRYID, \n");
        sqlInsertDynaEntry.append(" FRPTITEMID,FKEYNUMBER,FKEYLONGNUMBER,FKEYNAME,FVALUE,FASSTACTTYPENUMBER, \n");
        sqlInsertDynaEntry.append(" FREMARK_L1,FREMARK_L2,FREMARK_L3) \n");
        sqlInsertDynaEntry.append(" values(?,?,?,?,?,?,?,?,?,?,?,?) \n");
        ArrayList<String> param = new ArrayList<String>();
        param.add(oldTreeId);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        Connection cn = null;
        PreparedStatement ps = null;
        PreparedStatement psEntry = null;
        PreparedStatement psDynaEntry = null;
        Statement st = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            ps = cn.prepareStatement(sqlInsertElim.toString());
            psEntry = cn.prepareStatement(sqlInsertEntry.toString());
            psDynaEntry = cn.prepareStatement(sqlInsertDynaEntry.toString());
            st = cn.createStatement();
            while (rs.next()) {
                String oldId = rs.getString("FID");
                String newId = rs.getString("newid");
                if (rs.getInt("FELIMTYPE") == 1 || rs.getInt("FELIMTYPE") == 3) {
                    ret.put(oldId, newId);
                }
                ps.setString(1, newId);
                ps.setString(2, rs.getString("FNUMBER"));
                ps.setDate(3, rs.getDate("FBIZDATE"));
                ps.setInt(4, rs.getInt("FYear"));
                ps.setInt(5, rs.getInt("FPeriod"));
                ps.setDate(6, rs.getDate("FDate"));
                ps.setString(7, rs.getString("FCREATORID"));
                ps.setDate(8, rs.getDate("FCREATETIME"));
                ps.setString(9, rs.getString("FLASTUPDATEUSERID"));
                ps.setDate(10, rs.getDate("FLASTUPDATETIME"));
                ps.setString(11, rs.getString("FHANDLERID"));
                ps.setString(12, rs.getString("FDESCRIPTION"));
                ps.setInt(13, rs.getInt("FHASEFFECTED"));
                ps.setString(14, rs.getString("FAUDITORID"));
                ps.setString(15, rs.getString("FSOURCEBILLID"));
                ps.setString(16, rs.getString("FSOURCEFUNCTION"));
                ps.setString(17, rs.getString("FCOMPANYID"));
                ps.setString(18, rs.getString("FCURRENCYID"));
                ps.setString(19, rs.getString("FORGBOUNDID"));
                ps.setString(20, rs.getString("FORGUNIT"));
                ps.setDate(21, rs.getDate("FAUDITDATE"));
                ps.setInt(22, rs.getInt("FPERIODTYPE"));
                ps.setInt(23, rs.getInt("FCHECKEDSTATUS"));
                ps.setInt(24, rs.getInt("FDATASOURCE"));
                ps.setString(25, rs.getString("FTEMPLETID"));
                ps.setInt(26, rs.getInt("FARCHIVEDSTATUS"));
                ps.setInt(27, rs.getInt("FVALUETYPE"));
                ps.setInt(28, rs.getInt("FELIMTYPE"));
                ps.setString(29, rs.getString("FCONTROLUNITID"));
                ps.setInt(30, rs.getInt("FISCITEDBYLATER"));
                ps.setString(31, rs.getString("FSOURCECURRENCYID"));
                ps.setString(32, rs.getString("FCONVERTBEFOREID"));
                ps.setString(33, rs.getString("FDATACOLLECTID"));
                ps.setString(34, rs.getString("FDATACOLLECTNUMBER"));
                ps.setInt(35, rs.getInt("FISFIXED"));
                ps.setString(36, rs.getString("FDISPLAYTEMPLATETYPEID"));
                ps.setString(37, rs.getString("FREMARK"));
                ps.setInt(38, rs.getInt("FinvestNewType"));
                ps.addBatch();
                sql = new StringBuffer();
                sql.append(" select newbosid('").append(new HisEliminationEntryInfo().getBOSType().toString()).append("') as newid,");
                sql.append(" FID,FSEQ,FITEMID,FDEBIT,FCREDIT,FSUMMARY, \n");
                sql.append(" FELIMINATIONID,FDATAELEMENT,FCOMPANYID,FISVISIBLE \n");
                sql.append(" From t_csl_EliminationEntry  \n");
                sql.append(" Where FELIMINATIONID = ? \n");
                IRowSet rsEntry = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{oldId});
                while (rsEntry.next()) {
                    String oldEntryId = rsEntry.getString("FID");
                    String newEntryId = rsEntry.getString("newId");
                    psEntry.setString(1, newEntryId);
                    psEntry.setInt(2, rsEntry.getInt("FSEQ"));
                    psEntry.setString(3, rsEntry.getString("FITEMID"));
                    psEntry.setBigDecimal(4, rsEntry.getBigDecimal("FDEBIT"));
                    psEntry.setBigDecimal(5, rsEntry.getBigDecimal("FCREDIT"));
                    psEntry.setString(6, rsEntry.getString("FSUMMARY"));
                    psEntry.setString(7, newId);
                    psEntry.setInt(8, rsEntry.getInt("FDATAELEMENT"));
                    psEntry.setString(9, rsEntry.getString("FCOMPANYID"));
                    psEntry.setInt(10, rsEntry.getInt("FISVISIBLE"));
                    psEntry.addBatch();
                    sql = new StringBuffer();
                    sql.append(" select newbosid('").append(new HisElimDynaItemEntryInfo().getBOSType().toString()).append("') as newid,");
                    sql.append(" dyna.FID,dyna.FSEQ,dyna.FELIMINATIONENTRYID, \n");
                    sql.append(" dyna.FRPTITEMID,dyna.FKEYNUMBER,dyna.FKEYLONGNUMBER,dyna.FKEYNAME,dyna.FVALUE,dyna.FASSTACTTYPENUMBER, \n");
                    sql.append(" dyna.FREMARK_L1,dyna.FREMARK_L2,dyna.FREMARK_L3 \n");
                    sql.append(" From T_CSL_ElimDynaItemEntry dyna join t_csl_EliminationEntry entry on dyna.FEliminationEntryId=entry.FID \n");
                    sql.append(" where dyna.fEliminationEntryId=? ");
                    IRowSet rsDyna = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{oldEntryId});
                    while (rsDyna.next()) {
                        psDynaEntry.setString(1, rsDyna.getString("newid"));
                        psDynaEntry.setInt(2, rsDyna.getInt("FSEQ"));
                        psDynaEntry.setString(3, newEntryId);
                        psDynaEntry.setString(4, rsDyna.getString("FRPTITEMID"));
                        psDynaEntry.setString(5, rsDyna.getString("FKEYNUMBER"));
                        psDynaEntry.setString(6, rsDyna.getString("FKEYLONGNUMBER"));
                        psDynaEntry.setString(7, rsDyna.getString("FKEYNAME"));
                        psDynaEntry.setBigDecimal(8, rsDyna.getBigDecimal("FVALUE"));
                        psDynaEntry.setString(9, rsDyna.getString("FASSTACTTYPENUMBER"));
                        psDynaEntry.setString(10, rsDyna.getString("FREMARK_L1"));
                        psDynaEntry.setString(11, rsDyna.getString("FREMARK_L2"));
                        psDynaEntry.setString(12, rsDyna.getString("FREMARK_L3"));
                        psDynaEntry.addBatch();
                    }
                }
                UnionVersionUtil.updateConvertBeforeId(ctx, st, oldId, newId, false);
                UnionVersionUtil.addAttachment(ctx, oldId, newId);
            }
            ps.executeBatch();
            psEntry.executeBatch();
            psDynaEntry.executeBatch();
            st.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup(psEntry);
                SQLUtils.cleanup(psDynaEntry);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Statement)psEntry);
        SQLUtils.cleanup((Statement)psDynaEntry);
        SQLUtils.cleanup((Connection)cn);
        return ret;
    }

    private static void addAttachment(Context ctx, String oldId, String newId) throws BOSException, EASBizException {
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        asm.deleteAttachemtsByBoID(newId);
        String[] attachIDs = asm.getAttachmentIDsByBoID(oldId);
        asm.addAssociations(newId, attachIDs);
    }

    private static String getCheckageTableNameByType(int type, boolean isHead, boolean isHistory) {
        String tableName = null;
        if (type == 1) {
            tableName = isHistory ? (isHead ? "T_CSL_HisInterDataCheckage" : "T_CSL_HisDataCheckageEntry") : (isHead ? "T_CSL_InterDataCheckage" : "T_CSL_DataCheckageEntry");
        } else if (type == 3) {
            tableName = isHistory ? (isHead ? "T_CSL_HisExchCheckage" : "T_CSL_HisExchCheckageEntry") : (isHead ? "T_CSL_ExchCheckage" : "T_CSL_ExchCheckageEntry");
        }
        return tableName;
    }

    private static String getCheckItemdataTableNameByType(int type, boolean isHistory) {
        String tableName = null;
        if (type == 1) {
            tableName = isHistory ? "T_CSL_HisInterItemdata" : "T_CSL_InterItemdata";
        } else if (type == 3) {
            tableName = isHistory ? "T_CSL_HisExchItemdata" : "T_CSL_ExchItemdata";
        }
        return tableName;
    }

    private static Map copyCheckageToHistory(Context ctx, String oldTreeId, String newTreeId, Timestamp date, int type, PeriodCollection periods, boolean isMergeByFiscalPeriod) throws BOSException, EASBizException {
        HashMap<String, String> ret = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select newBosId('").append(type == 1 ? new HisInterDataCheckageInfo().getBOSType().toString() : new HisExchCheckageInfo().getBOSType().toString()).append("') as newid,");
        sql.append(" FID,FNumber,FBizDate,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime, \n");
        sql.append(" FHandlerID,FDescription,FHasEffected ,FAuditorID ,FSourceBillID ,FSourceFunction, \n");
        sql.append(" FCompanyID,FTempletID,FCurrencyID,FYear,FPeriod ,FDay,FOrgBoundID,FOrgUnitID, \n");
        sql.append(" FDiffValue,FDiffMode,FPeriodType,FCheckedStatus,FAuditDate,FElimStatus,FControlUnitID, \n");
        sql.append(" FSingleDC,FDataCollectNumber  \n");
        sql.append(" From " + UnionVersionUtil.getCheckageTableNameByType(type, true, false) + " a \n");
        sql.append(" Where  FORGBOUNDID = ? \n");
        sql.append(" and a.FDataCollectNumber = '").append("BUDGETDATA").append("' \n");
        sql.append(" and ").append(UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        StringBuffer sqlInsertHead = new StringBuffer();
        sqlInsertHead.append(" insert into " + UnionVersionUtil.getCheckageTableNameByType(type, true, true) + "( \n");
        sqlInsertHead.append(" FID,FNumber,FBizDate,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime, \n");
        sqlInsertHead.append(" FHandlerID,FDescription,FHasEffected ,FAuditorID ,FSourceBillID ,FSourceFunction, \n");
        sqlInsertHead.append(" FCompanyID,FTempletID,FCurrencyID,FYear,FPeriod ,FDay,FOrgBoundID,FOrgUnitID, \n");
        sqlInsertHead.append(" FDiffValue,FDiffMode,FPeriodType,FCheckedStatus,FAuditDate,FElimStatus,FControlUnitID, \n");
        sqlInsertHead.append(" FSingleDC,FDataCollectNumber) \n");
        sqlInsertHead.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        StringBuffer sqlInsertEntry = new StringBuffer();
        sqlInsertEntry.append(" insert into " + UnionVersionUtil.getCheckageTableNameByType(type, false, true) + "( \n");
        sqlInsertEntry.append(" FID,FSeq,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FItemID, \n");
        sqlInsertEntry.append(" FCompanyID,FTargetCompanyID,FDebit,FCredit,FValiDebit,FValiCredit, \n");
        sqlInsertEntry.append(" FDATAELEMENT,FCheckageID) \n");
        sqlInsertEntry.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        ArrayList<String> param = new ArrayList<String>();
        param.add(oldTreeId);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        Connection cn = null;
        PreparedStatement ps = null;
        PreparedStatement psEntry = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            ps = cn.prepareStatement(sqlInsertHead.toString());
            psEntry = cn.prepareStatement(sqlInsertEntry.toString());
            while (rs.next()) {
                String oldId = rs.getString("FID");
                String newId = rs.getString("newid");
                ret.put(oldId, newId);
                ps.setString(1, newId);
                ps.setString(2, rs.getString("FNUMBER"));
                ps.setDate(3, rs.getDate("FBIZDATE"));
                ps.setString(4, rs.getString("FCreatorID"));
                ps.setDate(5, rs.getDate("FCreateTime"));
                ps.setString(6, rs.getString("FLastUpdateUserID"));
                ps.setDate(7, rs.getDate("FLastUpdateTime"));
                ps.setString(8, rs.getString("FHandlerID"));
                ps.setString(9, rs.getString("FDescription"));
                ps.setInt(10, rs.getInt("FHasEffected"));
                ps.setString(11, rs.getString("FAuditorID"));
                ps.setString(12, rs.getString("FSourceBillID"));
                ps.setString(13, rs.getString("FSourceFunction"));
                ps.setString(14, rs.getString("FCompanyID"));
                ps.setString(15, rs.getString("FTempletID"));
                ps.setString(16, rs.getString("FCurrencyID"));
                ps.setInt(17, rs.getInt("FYear"));
                ps.setInt(18, rs.getInt("FPeriod"));
                ps.setDate(19, rs.getDate("FDay"));
                ps.setString(20, rs.getString("FOrgBoundID"));
                ps.setString(21, rs.getString("FOrgUnitID"));
                ps.setBigDecimal(22, rs.getBigDecimal("FDiffValue"));
                ps.setInt(23, rs.getInt("FDiffMode"));
                ps.setInt(24, rs.getInt("FPeriodType"));
                ps.setInt(25, rs.getInt("FCheckedStatus"));
                ps.setDate(26, rs.getDate("FAuditDate"));
                ps.setInt(27, rs.getInt("FElimStatus"));
                ps.setString(28, rs.getString("FControlUnitID"));
                ps.setInt(29, rs.getInt("FSingleDC"));
                ps.setString(30, rs.getString("FDataCollectNumber"));
                ps.addBatch();
                sql = new StringBuffer();
                sql.append(" select newbosid('").append(type == 1 ? new HisDataCheckageEntryInfo().getBOSType().toString() : new HisExchCheckageEntryInfo().getBOSType().toString()).append("') as newid,");
                sql.append(" FID,FSeq,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FItemID, \n");
                sql.append(" FCompanyID,FTargetCompanyID,FDebit,FCredit,FValiDebit,FValiCredit, \n");
                sql.append(" FDATAELEMENT,FCheckageID \n");
                sql.append(" From " + UnionVersionUtil.getCheckageTableNameByType(type, false, false) + "   \n");
                sql.append(" Where FCheckageID = ? \n");
                IRowSet rsEntry = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{oldId});
                while (rsEntry.next()) {
                    String oldEntryId = rsEntry.getString("FID");
                    String newEntryId = rsEntry.getString("newId");
                    psEntry.setString(1, newEntryId);
                    psEntry.setInt(2, rsEntry.getInt("FSEQ"));
                    psEntry.setString(3, rsEntry.getString("FCreatorID"));
                    psEntry.setDate(4, rsEntry.getDate("FCreateTime"));
                    psEntry.setString(5, rsEntry.getString("FLastUpdateUserID"));
                    psEntry.setDate(6, rsEntry.getDate("FLastUpdateTime"));
                    psEntry.setString(7, rsEntry.getString("FITEMID"));
                    psEntry.setString(8, rsEntry.getString("FCompanyID"));
                    psEntry.setString(9, rsEntry.getString("FTargetCompanyID"));
                    psEntry.setBigDecimal(10, rsEntry.getBigDecimal("FDebit"));
                    psEntry.setBigDecimal(11, rsEntry.getBigDecimal("FCredit"));
                    psEntry.setBigDecimal(12, rsEntry.getBigDecimal("FValiDebit"));
                    psEntry.setBigDecimal(13, rsEntry.getBigDecimal("FValiCredit"));
                    psEntry.setInt(14, rsEntry.getInt("FDATAELEMENT"));
                    psEntry.setString(15, newId);
                    psEntry.addBatch();
                }
                UnionVersionUtil.addAttachment(ctx, oldId, newId);
            }
            ps.executeBatch();
            psEntry.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup(psEntry);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Statement)psEntry);
        SQLUtils.cleanup((Connection)cn);
        return ret;
    }

    public static void rollbackHistory(Context ctx, String treeId, String oldTreeId, Timestamp date, PeriodCollection periods, boolean isMergeByFiscalPeriod) throws BOSException, EASBizException {
        try {
            String datesql = UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod);
            UnionVersionUtil.deleteSameAdjust(ctx, treeId, oldTreeId, datesql);
            UnionVersionUtil.deleteSameCaliAdjust(ctx, treeId, oldTreeId, datesql);
            UnionVersionUtil.deleteSameElimination(ctx, treeId, oldTreeId, datesql);
            UnionVersionUtil.deleteSameCheckage(ctx, treeId, oldTreeId, datesql);
            UnionVersionUtil.deleteSameReportData(ctx, treeId, oldTreeId, date);
            UnionVersionUtil.deleteSameRptReceived(ctx, treeId, oldTreeId, datesql);
            UnionVersionUtil.rollbackHistoryToElimination(ctx, oldTreeId, date);
            UnionVersionUtil.rollbackHistoryToCheckage(ctx, oldTreeId, date, 1);
            UnionVersionUtil.rollbackHistoryToCheckage(ctx, oldTreeId, date, 3);
            UnionVersionUtil.rollbackHistoryToElimRecord(ctx, oldTreeId, date);
            UnionVersionUtil.rollbackHistoryToCslReport(ctx, oldTreeId, date);
            UnionVersionUtil.rollbackHistoryToSumRptRela(ctx, oldTreeId, date);
            UnionVersionUtil.rollbackHistoryToAdjust(ctx, oldTreeId, date);
            UnionVersionUtil.rollbackHistoryToCaliAdjust(ctx, oldTreeId, date);
            UnionVersionUtil.rollbackHistoryToRptReceived(ctx, oldTreeId, date);
            UnionVersionUtil.clearHistory(ctx, oldTreeId);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private static void clearHistory(Context ctx, String oldTreeId) throws SQLException, BOSException {
        StringBuffer sql = null;
        sql = new StringBuffer();
        sql.append(" delete t_csl_HisCslReport where FId in (");
        sql.append(" select t1.FID from t_csl_HisCslReport t1 join t_csl_HisRptReceived t2 on t1.fid=t2.fReportId ");
        sql.append(" where t2.FOrgTreeId='").append(oldTreeId).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" delete t_csl_HisCslReport where FOrgTreeId='").append(oldTreeId).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" delete t_csl_HisAdjustDynamicItem where FId in ( \n");
        sql.append(" select dyna.FId \n");
        sql.append(" From t_csl_HisAdjustDynamicItem dyna \n");
        sql.append(" join t_csl_HisAdjustEntry entry on entry.FId=dyna.FAdjustEntryId \n ");
        sql.append(" join t_csl_HisAdjust head on entry.FAdjustId=head.FID \n ");
        sql.append(" where head.FOrgBoundId='").append(oldTreeId).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" delete t_csl_HisAdjustEntry where FId in (");
        sql.append(" select entry.FId From t_csl_HisAdjustEntry entry join t_csl_HisAdjust head on entry.FAdjustId=head.FID ");
        sql.append(" where head.FOrgBoundId='").append(oldTreeId).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" delete t_csl_HisAdjust ");
        sql.append(" where FOrgBoundId='").append(oldTreeId).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" delete t_csl_HisCaliAdjustEntry where FId in (");
        sql.append(" select entry.FId From t_csl_HisCaliAdjustEntry entry join t_csl_HisCaliAdjust head on entry.FAdjustId=head.FID ");
        sql.append(" where head.FOrgBoundId='").append(oldTreeId).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" delete t_csl_HisCaliAdjust ");
        sql.append(" where FOrgBoundId='").append(oldTreeId).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" delete t_csl_HisElimDynaItemEntry where FId in ( \n");
        sql.append(" select dyna.FId \n");
        sql.append(" From t_csl_HisElimDynaItemEntry dyna \n");
        sql.append(" join t_csl_HisEliminationEntry entry on entry.FId=dyna.FEliminationEntryId \n ");
        sql.append(" join t_csl_HisElimination head on entry.FEliminationId=head.FID \n ");
        sql.append(" where head.FOrgBoundId='").append(oldTreeId).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" delete t_csl_HisEliminationEntry where FId in ( \n");
        sql.append(" select entry.FId From t_csl_HisEliminationEntry entry join t_csl_HisElimination head on entry.FEliminationId=head.FID \n");
        sql.append(" where head.FOrgBoundId='").append(oldTreeId).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" delete t_csl_HisElimination ");
        sql.append(" where FOrgBoundId='").append(oldTreeId).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" delete t_csl_HisSumRptRela where FId in ( ");
        sql.append(" select s.FId From t_csl_HisSumRptRela s join t_csl_HisRptReceived r on s.FSumReportId=r.FReportID \n");
        sql.append(" where r.FOrgTreeId='").append(oldTreeId).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" delete t_csl_HisInterItemdata where FId in ( ");
        sql.append(" select FId From t_csl_HisInterItemdata  \n");
        sql.append(" where FOrgBoundId='").append(oldTreeId).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" delete t_csl_HisExchItemdata where FId in ( ");
        sql.append(" select FId From t_csl_HisExchItemdata  \n");
        sql.append(" where FOrgBoundId='").append(oldTreeId).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" delete t_csl_HisDataCheckageEntry where FId in ( \n");
        sql.append(" select entry.FId From t_csl_HisDataCheckageEntry entry join t_csl_HisInterDataCheckage head on entry.FCheckageId=head.FID \n");
        sql.append(" where head.FOrgBoundId='").append(oldTreeId).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" delete t_csl_HisInterDataCheckage ");
        sql.append(" where FOrgBoundId='").append(oldTreeId).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" delete t_csl_HisExchCheckageEntry where FId in ( \n");
        sql.append(" select entry.FId From t_csl_HisExchCheckageEntry entry join t_csl_HisExchCheckage head on entry.FCheckageId=head.FID \n");
        sql.append(" where head.FOrgBoundId='").append(oldTreeId).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" delete t_csl_HisExchCheckage ");
        sql.append(" where FOrgBoundId='").append(oldTreeId).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" delete t_csl_HisRptReceived ");
        sql.append(" where FOrgTreeId='").append(oldTreeId).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void rollbackHistoryToCslReport(Context ctx, String oldTreeId, Timestamp date) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into t_csl_CslReport(FID,FNUMBER,FNAME,FORGTREEID,FORGUNITID,FYEAR,FPERIOD, \n");
        sql.append(" FSTARTDATE,FENDDATE,FCREATORID,FCREATETIME,FTEMPLATEID,FLASTUPDATEUSERID,FLASTUPDATETIME, \n");
        sql.append(" FDESCRIPTION,FAUDITORID,FCOMPANYID,FPERIODTYPE,FPUBLICSTATUS,FPUBLISHEDSTATUS,FCOMMITTEDSTATUS, \n");
        sql.append(" FHANDLESTATUS,FSOURCETYPE,FCURRENCYID,FAUDITEDTIME,FAUDITEDSTATUS,FCHECKEDSTATUS,FDATA, \n");
        sql.append(" FSOURCECURRENCYID,FREPORTDATE,FSOURCERPTID,FCONTROLUNITID,FADJUSTSTATUS,FCONVERTSTATUS, \n");
        sql.append(" FISCOMMITREPORT,FDYNARPTTYPE,FISSAVEAS,FSAVEASVERSIONNUM,FREMARK,FCOMMITTIME,FRECEIVETIME, \n");
        sql.append(" FCOMMITORID,FRECEIVERID,FRECEIVESTATUS,FDATACOLLECTID,FDATACOLLECTNUMBER) \n");
        sql.append(" select c.FID,c.FNUMBER,c.FNAME,c.FORGTREEID,c.FORGUNITID,c.FYEAR,c.FPERIOD, \n");
        sql.append(" c.FSTARTDATE,c.FENDDATE,c.FCREATORID,c.FCREATETIME,c.FTEMPLATEID,c.FLASTUPDATEUSERID,c.FLASTUPDATETIME, \n");
        sql.append(" c.FDESCRIPTION,c.FAUDITORID,c.FCOMPANYID,c.FPERIODTYPE,c.FPUBLICSTATUS,c.FPUBLISHEDSTATUS,c.FCOMMITTEDSTATUS, \n");
        sql.append(" c.FHANDLESTATUS,c.FSOURCETYPE,c.FCURRENCYID,c.FAUDITEDTIME,c.FAUDITEDSTATUS,c.FCHECKEDSTATUS,c.FDATA, \n");
        sql.append(" c.FSOURCECURRENCYID,c.FREPORTDATE,c.FSOURCERPTID,c.FCONTROLUNITID,c.FADJUSTSTATUS,c.FCONVERTSTATUS, \n");
        sql.append(" c.FISCOMMITREPORT,c.FDYNARPTTYPE,c.FISSAVEAS,c.FSAVEASVERSIONNUM,c.FREMARK,c.FCOMMITTIME,c.FRECEIVETIME, \n");
        sql.append(" c.FCOMMITORID,c.FRECEIVERID,c.FRECEIVESTATUS,c.FDATACOLLECTID,c.FDATACOLLECTNUMBER \n");
        sql.append(" From t_csl_HisCslreport c join t_csl_HisRptreceived r on c.fid=r.FReportId \n");
        sql.append(" join t_rpt_template t on t.fid=c.FTemplateId \n");
        sql.append(" Where  r.FOrgTreeID ='").append(oldTreeId).append("' \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void rollbackHistoryToSumRptRela(Context ctx, String oldTreeId, Timestamp date) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into t_csl_SumRptRela(FID,FSUMREPORTID,FREPORTID,FCREATETIME,FCREATORID, \n");
        sql.append(" FLASTUPDATETIME,FLASTUPDATEUSERID,FCONTROLUNITID,FSHEETID) \n");
        sql.append(" select s.FID,s.FSUMREPORTID,s.FREPORTID,s.FCREATETIME,s.FCREATORID, \n");
        sql.append(" s.FLASTUPDATETIME,s.FLASTUPDATEUSERID,s.FCONTROLUNITID,s.FSHEETID \n");
        sql.append(" From t_csl_HisSumRptRela s \n");
        sql.append(" join t_csl_HisRptReceived r on s.FSumReportId=r.FReportId \n");
        sql.append(" Where  r.FOrgTreeID ='").append(oldTreeId).append("' \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void rollbackHistoryToRptReceived(Context ctx, String oldTreeId, Timestamp date) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into t_csl_RptReceived(FID,FREPORTID,FORGTREEID,FCREATORID,FCREATETIME, \n");
        sql.append(" FLASTUPDATEUSERID,FLASTUPDATETIME) \n");
        sql.append(" select r.FID,");
        sql.append(" r.FREPORTID,r.FORGTREEID,r.FCREATORID,r.FCREATETIME, \n");
        sql.append(" r.FLASTUPDATEUSERID,r.FLASTUPDATETIME \n");
        sql.append(" From t_csl_HisRptreceived r  \n");
        sql.append(" Where  r.FOrgTreeID ='").append(oldTreeId).append("' \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void rollbackHistoryToAdjust(Context ctx, String oldTreeId, Timestamp date) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into t_csl_Adjust(FID,FNUMBER,FBIZDATE,FYEAR,FPERIOD,FDATE,FCREATORID,FCREATETIME, \n");
        sql.append(" FLASTUPDATEUSERID,FLASTUPDATETIME,FHANDLERID,FDESCRIPTION,FHASEFFECTED,FAUDITORID, \n");
        sql.append(" FSOURCEBILLID,FSOURCEFUNCTION,FCOMPANYID,FCURRENCYID,FORGBOUNDID,FORGUNIT,FAUDITDATE, \n");
        sql.append(" FPERIODTYPE,FCHECKEDSTATUS,FDATASOURCE,FTEMPLETID,FARCHIVEDSTATUS,FVALUETYPE,FADJUSTMODE, \n");
        sql.append(" FCONTROLUNITID,FISCITEDBYLATER,FSOURCECURRENCYID,FCONVERTBEFOREID,FDATACOLLECTID, \n");
        sql.append(" FDATACOLLECTNUMBER,FISFIXED,FREMARK) \n");
        sql.append(" select FID,FNUMBER,FBIZDATE,FYEAR,FPERIOD,FDATE,FCREATORID,FCREATETIME, \n");
        sql.append(" FLASTUPDATEUSERID,FLASTUPDATETIME,FHANDLERID,FDESCRIPTION,FHASEFFECTED,FAUDITORID, \n");
        sql.append(" FSOURCEBILLID,FSOURCEFUNCTION,FCOMPANYID,FCURRENCYID,FORGBOUNDID,FORGUNIT,FAUDITDATE, \n");
        sql.append(" FPERIODTYPE,FCHECKEDSTATUS,FDATASOURCE,FTEMPLETID,FARCHIVEDSTATUS,FVALUETYPE,FADJUSTMODE, \n");
        sql.append(" FCONTROLUNITID,FISCITEDBYLATER,FSOURCECURRENCYID,FCONVERTBEFOREID,FDATACOLLECTID, \n");
        sql.append(" FDATACOLLECTNUMBER,FISFIXED,FREMARK \n");
        sql.append(" From t_csl_HisAdjust a \n");
        sql.append(" Where  a.FORGBOUNDID ='").append(oldTreeId).append("' \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" insert into t_csl_AdjustEntry(FID,FSEQ,FCREATORID,FCREATETIME,FLASTUPDATEUSERID, \n");
        sql.append(" FLASTUPDATETIME,FITEMID,FDEBIT,FCREDIT,FSUMMARY,FDATAELEMENT,FADJUSTID,FISVISIBLE) \n");
        sql.append(" select entry.FID,entry.FSEQ,entry.FCREATORID,entry.FCREATETIME,entry.FLASTUPDATEUSERID, \n");
        sql.append(" entry.FLASTUPDATETIME,entry.FITEMID,entry.FDEBIT,entry.FCREDIT,entry.FSUMMARY,entry.FDATAELEMENT,entry.FADJUSTID,entry.FISVISIBLE \n");
        sql.append(" From t_csl_HisAdjustEntry entry join t_csl_HisAdjust a on entry.FAdjustId=a.FID \n");
        sql.append(" Where  a.FORGBOUNDID ='").append(oldTreeId).append("' \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" insert into T_CSL_AdjustDynamicItem(FID,FSEQ,FADJUSTENTRYID,FRPTITEMID,FKEYLONGNUMBER, \n");
        sql.append(" FKEYNUMBER,FKEYNAME,FVALUE,FASSTACTTYPENUMBER,FREMARK_L1,FREMARK_L2, \n");
        sql.append(" FREMARK_L3,FISAUTOCREATED) \n");
        sql.append(" select dyna.FID,dyna.FSEQ,dyna.FADJUSTENTRYID,dyna.FRPTITEMID,dyna.FKEYLONGNUMBER, \n");
        sql.append(" dyna.FKEYNUMBER,dyna.FKEYNAME,dyna.FVALUE,dyna.FASSTACTTYPENUMBER,dyna.FREMARK_L1,dyna.FREMARK_L2, \n");
        sql.append(" dyna.FREMARK_L3,dyna.FISAUTOCREATED \n");
        sql.append(" From T_CSL_HisAdjustDynamicItem dyna \n");
        sql.append(" join t_csl_HisAdjustEntry entry on entry.fid=dyna.FAdjustEntryId \n");
        sql.append(" join t_csl_HisAdjust a on a.fid=entry.fAdjustId \n");
        sql.append(" Where  a.FORGBOUNDID ='").append(oldTreeId).append("' \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void rollbackHistoryToCaliAdjust(Context ctx, String oldTreeId, Timestamp date) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into t_csl_CaliAdjust(FID,FNUMBER,FBIZDATE,FYEAR,FPERIOD,FDATE,FCREATORID,FCREATETIME, \n");
        sql.append(" FLASTUPDATEUSERID,FLASTUPDATETIME,FHANDLERID,FDESCRIPTION,FHASEFFECTED,FAUDITORID, \n");
        sql.append(" FSOURCEBILLID,FSOURCEFUNCTION,FCOMPANYID,FCURRENCYID,FORGBOUNDID,FORGUNITID,FAUDITDATE, \n");
        sql.append(" FPERIODTYPE,FCHECKEDSTATUS,FDATASOURCE,FTEMPLETID,FARCHIVEDSTATUS,FVALUETYPE,FADJUSTMODEID, \n");
        sql.append(" FCONTROLUNITID,FISCITEDBYLATER,FSOURCECURRENCYID,FCONVERTBEFORE,FDATACOLLECTID, \n");
        sql.append(" FDATACOLLECTNUMBER,FISFIXED) \n");
        sql.append(" select FID,FNUMBER,FBIZDATE,FYEAR,FPERIOD,FDATE,FCREATORID,FCREATETIME, \n");
        sql.append(" FLASTUPDATEUSERID,FLASTUPDATETIME,FHANDLERID,FDESCRIPTION,FHASEFFECTED,FAUDITORID, \n");
        sql.append(" FSOURCEBILLID,FSOURCEFUNCTION,FCOMPANYID,FCURRENCYID,FORGBOUNDID,FORGUNITID,FAUDITDATE, \n");
        sql.append(" FPERIODTYPE,FCHECKEDSTATUS,FDATASOURCE,FTEMPLETID,FARCHIVEDSTATUS,FVALUETYPE,FADJUSTMODEID, \n");
        sql.append(" FCONTROLUNITID,FISCITEDBYLATER,FSOURCECURRENCYID,FCONVERTBEFORE,FDATACOLLECTID, \n");
        sql.append(" FDATACOLLECTNUMBER,FISFIXED \n");
        sql.append(" From t_csl_HisCaliAdjust a \n");
        sql.append(" Where  a.FORGBOUNDID ='").append(oldTreeId).append("' \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" insert into t_csl_CaliAdjustEntry(FID,FSEQ,\n");
        sql.append(" FITEMID,FDEBIT,FCREDIT,FSUMMARY,FDATAELEMENT,FADJUSTID,FISVISIBLE) \n");
        sql.append(" select entry.FID,entry.FSEQ, \n");
        sql.append(" entry.FITEMID,entry.FDEBIT,entry.FCREDIT,entry.FSUMMARY,entry.FDATAELEMENT,entry.FADJUSTID,entry.FISVISIBLE \n");
        sql.append(" From t_csl_HisCaliAdjustEntry entry join t_csl_HisCaliAdjust a on entry.FAdjustId=a.FID \n");
        sql.append(" Where  a.FORGBOUNDID ='").append(oldTreeId).append("' \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void rollbackHistoryToElimination(Context ctx, String oldTreeId, Timestamp date) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into t_csl_Elimination(FID,FNUMBER,FBIZDATE,FYEAR,FPERIOD,FHANDLERID,FDESCRIPTION, \n");
        sql.append(" FHASEFFECTED,FAUDITORID,FSOURCEBILLID,FSOURCEFUNCTION,FCOMPANYID,FCURRENCYID, \n");
        sql.append(" FORGBOUNDID,FAUDITDATE,FPERIODTYPE,FCHECKEDSTATUS,FDATASOURCE,FARCHIVEDSTATUS, \n");
        sql.append(" FTEMPLETID,FVALUETYPE,FELIMTYPE,FDATE,FORGUNIT,FCREATORID,FCREATETIME,FLASTUPDATEUSERID, \n");
        sql.append(" FLASTUPDATETIME,FISCITEDBYLATER,FCONTROLUNITID,FSOURCECURRENCYID,FCONVERTBEFOREID, \n");
        sql.append(" FDISPLAYTEMPLATETYPEID,FDATACOLLECTID,FDATACOLLECTNUMBER,FISFIXED,FREMARK,FinvestNewType) \n");
        sql.append(" select FID,FNUMBER,FBIZDATE,FYEAR,FPERIOD,FHANDLERID,FDESCRIPTION, \n");
        sql.append(" FHASEFFECTED,FAUDITORID,FSOURCEBILLID,FSOURCEFUNCTION,FCOMPANYID,FCURRENCYID, \n");
        sql.append(" FORGBOUNDID,FAUDITDATE,FPERIODTYPE,FCHECKEDSTATUS,FDATASOURCE,FARCHIVEDSTATUS, \n");
        sql.append(" FTEMPLETID,FVALUETYPE,FELIMTYPE,FDATE,FORGUNIT,FCREATORID,FCREATETIME,FLASTUPDATEUSERID, \n");
        sql.append(" FLASTUPDATETIME,FISCITEDBYLATER,FCONTROLUNITID,FSOURCECURRENCYID,FCONVERTBEFOREID, \n");
        sql.append(" FDISPLAYTEMPLATETYPEID,FDATACOLLECTID,FDATACOLLECTNUMBER,FISFIXED,FREMARK,FinvestNewType \n");
        sql.append(" From t_csl_HisElimination a \n");
        sql.append(" Where  a.FORGBOUNDID ='").append(oldTreeId).append("' \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" insert into t_csl_EliminationEntry(FID,FSEQ,FITEMID,FDEBIT,FCREDIT,FSUMMARY, \n");
        sql.append(" FELIMINATIONID,FDATAELEMENT,FCOMPANYID,FISVISIBLE) \n");
        sql.append(" select entry.FID,entry.FSEQ,entry.FITEMID,entry.FDEBIT,entry.FCREDIT,entry.FSUMMARY, \n");
        sql.append(" entry.FELIMINATIONID,entry.FDATAELEMENT,entry.FCOMPANYID,entry.FISVISIBLE \n");
        sql.append(" From t_csl_HisEliminationEntry entry join t_csl_HisElimination a on entry.FEliminationID=a.FID \n");
        sql.append(" Where  a.FORGBOUNDID ='").append(oldTreeId).append("' \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" insert into T_CSL_ElimDynaItemEntry(FID,FSEQ,FELIMINATIONENTRYID, \n");
        sql.append(" FRPTITEMID,FKEYNUMBER,FKEYLONGNUMBER,FKEYNAME,FVALUE,FASSTACTTYPENUMBER, \n");
        sql.append(" FREMARK_L1,FREMARK_L2,FREMARK_L3) \n");
        sql.append(" select dyna.FID,dyna.FSEQ,dyna.FELIMINATIONENTRYID,dyna.FRPTITEMID,dyna.FKEYNUMBER, \n");
        sql.append(" dyna.FKEYLONGNUMBER,dyna.FKEYNAME,dyna.FVALUE,dyna.FASSTACTTYPENUMBER, \n");
        sql.append(" dyna.FREMARK_L1,dyna.FREMARK_L2,dyna.FREMARK_L3 \n");
        sql.append(" From T_CSL_HisElimDynaItemEntry dyna \n");
        sql.append(" join t_csl_HisEliminationEntry entry on entry.fid=dyna.FEliminationEntryId \n");
        sql.append(" join t_csl_HisElimination a on a.fid=entry.FEliminationId \n");
        sql.append(" Where  a.FORGBOUNDID ='").append(oldTreeId).append("' \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void rollbackHistoryToCheckage(Context ctx, String oldTreeId, Timestamp date, int type) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into " + UnionVersionUtil.getCheckItemdataTableNameByType(type, false) + "( \n");
        sql.append(" FID,FITEMNUMBER,FORGBOUNDID,FTARGETCOMPANYID, \n");
        sql.append(" FCOMPANYID,FCURRENCYID,FTARGETCURRENCYID,FYEAR,FPERIOD,FDAY,FMONEY,FITEMPOSTIL, \n");
        sql.append(" FPERIODTYPE,FCHECKAGESTATUS,FCHECKAGERECORD,FREPORT,FCOMMITSTATUS,FCOMMITDATE, \n");
        sql.append(" FSOURCETYPE,FIMPORTEDGROUP,FDATAELEMENT,FDATACOLLECTNUMBER) \n");
        sql.append(" select FID,FITEMNUMBER,FORGBOUNDID,FTARGETCOMPANYID, \n");
        sql.append(" FCOMPANYID,FCURRENCYID,FTARGETCURRENCYID,FYEAR,FPERIOD,FDAY,FMONEY,FITEMPOSTIL, \n");
        sql.append(" FPERIODTYPE,FCHECKAGESTATUS,FCHECKAGERECORD,FREPORT,FCOMMITSTATUS,FCOMMITDATE, \n");
        sql.append(" FSOURCETYPE,FIMPORTEDGROUP,FDATAELEMENT,FDATACOLLECTNUMBER \n");
        sql.append(" From " + UnionVersionUtil.getCheckItemdataTableNameByType(type, true) + " a \n");
        sql.append(" Where  a.FORGBOUNDID ='").append(oldTreeId).append("' \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" insert into " + UnionVersionUtil.getCheckageTableNameByType(type, true, false) + "( \n");
        sql.append(" FID,FNumber,FBizDate,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime, \n");
        sql.append(" FHandlerID,FDescription,FHasEffected ,FAuditorID ,FSourceBillID ,FSourceFunction, \n");
        sql.append(" FCompanyID,FTempletID,FCurrencyID,FYear,FPeriod ,FDay,FOrgBoundID,FOrgUnitID, \n");
        sql.append(" FDiffValue,FDiffMode,FPeriodType,FCheckedStatus,FAuditDate,FElimStatus,FControlUnitID, \n");
        sql.append(" FSingleDC,FDataCollectNumber) \n");
        sql.append(" select FID,FNumber,FBizDate,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime, \n");
        sql.append(" FHandlerID,FDescription,FHasEffected ,FAuditorID ,FSourceBillID ,FSourceFunction, \n");
        sql.append(" FCompanyID,FTempletID,FCurrencyID,FYear,FPeriod ,FDay,FOrgBoundID,FOrgUnitID, \n");
        sql.append(" FDiffValue,FDiffMode,FPeriodType,FCheckedStatus,FAuditDate,FElimStatus,FControlUnitID, \n");
        sql.append(" FSingleDC,FDataCollectNumber \n");
        sql.append(" From " + UnionVersionUtil.getCheckageTableNameByType(type, true, true) + " a \n");
        sql.append(" Where  a.FORGBOUNDID ='").append(oldTreeId).append("' \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" insert into " + UnionVersionUtil.getCheckageTableNameByType(type, false, false) + "( \n");
        sql.append(" FID,FSeq,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FItemID, \n");
        sql.append(" FCompanyID,FTargetCompanyID,FDebit,FCredit,FValiDebit,FValiCredit, \n");
        sql.append(" FDATAELEMENT,FCheckageID) \n");
        sql.append(" select entry.FID,entry.FSeq,entry.FCreatorID,entry.FCreateTime,entry.FLastUpdateUserID, \n");
        sql.append(" entry.FLastUpdateTime,entry.FItemID,entry.FCompanyID,entry.FTargetCompanyID, \n");
        sql.append(" entry.FDebit,entry.FCredit,entry.FValiDebit,entry.FValiCredit, \n");
        sql.append(" entry.FDATAELEMENT,entry.FCheckageID \n");
        sql.append(" From " + UnionVersionUtil.getCheckageTableNameByType(type, false, true) + " entry \n");
        sql.append(" join " + UnionVersionUtil.getCheckageTableNameByType(type, true, true) + " a on entry.FCheckageID=a.FID \n");
        sql.append(" Where  a.FORGBOUNDID ='").append(oldTreeId).append("' \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void rollbackHistoryToElimRecord(Context ctx, String oldTreeId, Timestamp date) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into T_CSL_HisElimRecord(FID,FCREATORID,FCREATETIME,FLASTUPDATEUSERID, \n");
        sql.append(" FLASTUPDATETIME,FELIMINATIONID,FCHECKAGEDATAID,FCONTROLUNITID) ");
        sql.append(" select er.FID,er.FCREATORID,er.FCREATETIME,er.FLASTUPDATEUSERID, \n");
        sql.append(" er.FLASTUPDATETIME,er.FELIMINATIONID,er.FCHECKAGEDATAID,er.FCONTROLUNITID \n");
        sql.append(" From T_CSL_HisElimRecord er \n");
        sql.append(" join T_CSL_Elimination e on er.FEliminationId=e.FID \n");
        sql.append(" Where  e.FORGBOUNDID ='").append(oldTreeId).append("' \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public static void updateData(Context ctx, String oldTreeId, String newTreeId, Timestamp date, PeriodCollection periods, boolean isMergeByFiscalPeriod) throws BOSException, EASBizException {
        tl.set(new String[]{TemplateDispenseNewUtil.getDisTable((Context)ctx, (String)oldTreeId), TemplateDispenseNewUtil.templatedis_new});
        UnionVersionUtil.updateElimTempletGroup(ctx, oldTreeId, newTreeId, date);
        UnionVersionUtil.updateTemplate(ctx, oldTreeId, newTreeId, date, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.updateNormalReport(ctx, oldTreeId, newTreeId, date, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.updateGroupReport(ctx, oldTreeId, newTreeId, date, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.updateNormalAdjust(ctx, oldTreeId, newTreeId, date, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.updateGroupAdjust(ctx, oldTreeId, newTreeId, date, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.updateNormalCaliAdjust(ctx, oldTreeId, newTreeId, date, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.updateGroupCaliAdjust(ctx, oldTreeId, newTreeId, date, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.updateElimination(ctx, oldTreeId, newTreeId, date, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.updateCheckageData(ctx, oldTreeId, newTreeId, date, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.updateItemHisExchgRate(ctx, oldTreeId, newTreeId, date);
        UnionVersionUtil.updateElimInvestRate(ctx, oldTreeId, newTreeId, date, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.updateCheckageSolutionData(ctx, oldTreeId, newTreeId, date);
        UnionVersionUtil.updateAdjustAndElimDispendse(ctx, oldTreeId, newTreeId);
        UnionVersionUtil.updateIndexData(ctx, oldTreeId, newTreeId);
        UnionVersionUtil.updateFastMergeSolution(ctx, oldTreeId, newTreeId);
        TemplateDispenseNewUtil.addNewJob((Context)ctx);
        UnionVersionUtil.updateMnsListScheme(ctx, oldTreeId, newTreeId);
    }

    public static void rollbackMnsListScheme(Context ctx, String newTreeId, String oldTreeId) throws BOSException {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" delete from T_CSL_MnsRptSeqSchemeEntry where fid in(");
            sql.append(" select schEntry.fid from T_CSL_MnsRptSeqSchemeEntry schEntry ");
            sql.append(" inner join T_CSL_MnsRptSeqScheme sch on schEntry.Fparent = sch.fid ");
            sql.append(" where sch.forgtree=? )");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{newTreeId});
            sql.setLength(0);
            sql.append(" delete from T_CSL_MnsRptSeqScheme where forgtree=? ");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{newTreeId});
        }
        catch (Exception e) {
            logger.error((Object)"rollbackMnsListScheme error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void updateMnsListScheme(Context ctx, String oldTreeId, String newTreeId) throws BOSException, EASBizException {
        Object cn = null;
        Object st = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select distinct newstru.ftreeid, newstru.funitid, parentstru.funitid parentId,sch1.fmergemode,newstru.fparentid, oldsch.fseq, newstru.flongnumber ");
            sql.append(" from t_org_structure newstru ");
            sql.append(" inner join t_org_baseunit newunit on newunit.fid = newstru.funitid ");
            sql.append(" inner join t_org_structure parentstru on parentstru.fid = newstru.fparentid ");
            sql.append(" inner join t_org_baseunit parentunit on parentunit.fid = parentstru.funitid ");
            sql.append(" inner join t_org_baseunit schParent1 on schParent1.fnumber = parentunit.fnumber ");
            sql.append(" inner join T_CSL_MnsRptSeqScheme sch1 on schParent1.fid = sch1.forgunitgroup and sch1.forgtree =? ");
            sql.append(" left join (select unit.fnumber, schEntry.Fseq,schParent.fnumber parentNumber ");
            sql.append("            from T_CSL_MnsRptSeqScheme sch");
            sql.append("            inner join T_CSL_MnsRptSeqSchemeEntry schEntry on schEntry.Fparent = sch.fid  ");
            sql.append("            inner join t_org_baseunit unit on unit.fid = schEntry.Fcompany  ");
            sql.append("            inner join t_org_baseunit schParent on schParent.fid = sch.forgunitgroup  ");
            sql.append("            where sch.forgtree =? ");
            sql.append("  ) oldsch  on oldsch.fnumber = newunit.fnumber and oldsch.parentnumber = parentunit.fnumber ");
            sql.append(" where newstru.ftreeid = ? ");
            sql.append(" order by newstru.fparentid, oldsch.fseq, newstru.flongnumber asc ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{oldTreeId, oldTreeId, newTreeId});
            if (rs != null && rs.size() > 0) {
                sql.setLength(0);
                sql.append(" insert into T_CSL_MnsRptSeqScheme(FID,FORGTREE,FORGUNITGROUP,FMERGEMODE) values(?,?,?,?)");
                String entrySql = "insert into T_CSL_MnsRptSeqSchemeEntry(FID,FPARENT,FCOMPANY,FSEQ) values(?,?,?,?)";
                ArrayList<Object[]> headParams = new ArrayList<Object[]>();
                ArrayList<Object[]> entryParams = new ArrayList<Object[]>();
                HashMap<String, String> parentId_id = new HashMap<String, String>();
                String headId = null;
                int i = 0;
                while (rs.next()) {
                    String parentId = rs.getString("parentId");
                    headId = (String)parentId_id.get(parentId);
                    if (StringUtils.isEmpty((String)headId)) {
                        headId = Uuid.create().toString();
                        headParams.add(new Object[]{headId, newTreeId, parentId, rs.getInt("fmergemode")});
                        parentId_id.put(parentId, headId);
                        i = 0;
                    }
                    entryParams.add(new Object[]{Uuid.create().toString(), headId, rs.getString("funitid"), i++});
                }
                CslRptUtil.batchExecute(ctx, sql.toString(), (Object[][])headParams.toArray((T[])new Object[headParams.size()][4]));
                CslRptUtil.batchExecute(ctx, entrySql, (Object[][])entryParams.toArray((T[])new Object[entryParams.size()][4]));
            }
        }
        catch (Exception e) {
            logger.error((Object)"updateMnsListScheme error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateAdjustAndElimDispendse(Context ctx, String oldTreeId, String newTreeId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>(2);
        sql.append(" select unit.Fnumber,unit.Fid from t_org_baseUnit unit           \t\t           \n").append(" join t_org_structure s on unit.Fid = s.FunitId   \t\t\t\t\t\t           \n").append(" join t_org_tree tree on tree.FId = s.FtreeId \t    \t\t\t\t               \n").append(" where exists(select 'X' from t_org_baseUnit unit2    \t\t\t\t\t           \n").append(" join t_org_structure s2 on unit2.Fid = s2.FunitId      \t\t\t\t \t       \n").append(" join t_org_tree tree2 on tree2.Fid = s2.FtreeId        \t\t\t\t           \n").append(" where tree2.Fid = ? and unit.Fnumber = unit2.Fnumber )    \n").append(" and tree.Fid = ? \t\t\t\t\t\t\t\t\t       \n");
        params.add(oldTreeId);
        params.add(newTreeId);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        ArrayList<String> unitNum = new ArrayList<String>();
        HashMap<String, String> numMap2Id = new HashMap<String, String>();
        try {
            while (rowSet.next()) {
                unitNum.add(rowSet.getString("Fnumber"));
                numMap2Id.put(rowSet.getString("Fnumber"), rowSet.getString("Fid"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (unitNum.size() == 0) {
            return;
        }
        String numberStr = CslRptUtil.AryToItemString(unitNum);
        StringBuffer oql = new StringBuffer();
        oql.append("select *,company.*  where company.number in(").append(numberStr).append(")");
        oql.append(" and orgBound.id ='").append(oldTreeId).append("'");
        AdjustAndElimDispenseCollection col = AdjustAndElimDispenseFactory.getLocalInstance(ctx).getAdjustAndElimDispenseCollection(oql.toString());
        if (col == null || col.size() == 0) {
            return;
        }
        Connection cn = null;
        Statement ps = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            IORMappingDAO iOrMapping = ORMappingDAO.getInstance((BOSObjectType)new AdjustAndElimDispenseInfo().getBOSType(), (Context)ctx, (Connection)cn);
            Iterator it = col.iterator();
            AdjustAndElimDispenseInfo info = null;
            OrgTreeInfo treeInfo = new OrgTreeInfo();
            treeInfo.setId(BOSUuid.read((String)newTreeId));
            FullOrgUnitInfo unit = null;
            String unitNum2 = "";
            String newUnitId = "";
            while (it.hasNext()) {
                info = (AdjustAndElimDispenseInfo)it.next();
                info.setId(BOSUuid.create((BOSObjectType)new AdjustAndElimDispenseInfo().getBOSType()));
                info.setOrgBound(treeInfo);
                unitNum2 = info.getCompany().getNumber();
                newUnitId = (String)numMap2Id.get(unitNum2);
                if (StringUtil.isEmpty((String)unitNum2)) continue;
                unit = new FullOrgUnitInfo();
                unit.setId(BOSUuid.read((String)newUnitId));
                info.setCompany(unit);
                iOrMapping.addNewBatch((IObjectValue)info);
            }
            iOrMapping.executeBatch();
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(ps, (Connection)cn);
        }
    }

    private static void rollbackAdjustAndElimDispense(Context ctx, String oldTreeId, String newTreeId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete T_csl_adjustAndElimDispense where ForgBoundId = '").append(newTreeId).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void rollbackCheckageSolution(Context ctx, String treeId) throws BOSException {
        StringBuffer sqlQuery = new StringBuffer();
        sqlQuery.append(" select fid ");
        sqlQuery.append(" from T_CSL_INTERCHECKSOLUTION");
        sqlQuery.append(" where FOrgBoundID = '").append(treeId).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlQuery.toString());
        try {
            if (rowSet.next()) {
                StringBuffer sqlentry = new StringBuffer();
                sqlentry.append("delete T_CSL_INTERCHECKSOLUTIONENTRY");
                sqlentry.append(" where FCheckSolutionID IN (");
                sqlentry.append(" select fid ");
                sqlentry.append(" from T_CSL_INTERCHECKSOLUTION ");
                sqlentry.append(" where FOrgBoundID = ?)");
                DbUtil.execute((Context)ctx, (String)sqlentry.toString(), (Object[])new Object[]{treeId});
                String sql = "delete T_CSL_INTERCHECKSOLUTION where FOrgBoundID = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{treeId});
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private static void updateElimTempletGroup(Context ctx, String oldTreeId, String newTreeId, Timestamp date) throws BOSException {
        String tmplTabName = null;
        try {
            tmplTabName = UnionVersionUtil.insertOrg2TmplTableForElimGroup(ctx, oldTreeId, newTreeId);
            BOSObjectType bosType = new TempletDispenseInfo().getBOSType();
            StringBuffer sql = new StringBuffer();
            sql.append(" insert into ").append(TemplateDispenseNewUtil.templatedis_new).append("(  fid,fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime,").append("fcompanyid,FOrgBoundID,fsourcetype,fdispensesrcid,FIsAllowChgTemplet,FIsCoverTmpFormula,FIsCoverFormula,FControlUnitID,FIsAllowChgSol ) ");
            sql.append(" select newbosid('" + bosType.toString() + "') as fid, b.fcreatorid,b.fcreatetime,b.flastupdateuserid, b.flastupdatetime,");
            sql.append(" struct.funitid as fcompanyid, '" + newTreeId + "' as FOrgBoundID, b.fsourcetype,b.fdispensesrcid,b.FIsAllowChgTemplet,b.FIsCoverTmpFormula,b.FIsCoverFormula,b.FControlUnitID,b.FIsAllowChgSol ");
            sql.append(" from  ").append(tl.get()[0]).append(" b ");
            sql.append(" inner join ").append(tmplTabName).append(" struct on struct.foldunitid = b.fcompanyid ").append(" and struct.foldtreeid = b.forgboundid \n");
            sql.append(" where b.fsourcetype = 2 and b.forgboundid = '" + oldTreeId + "'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tmplTabName != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tmplTabName);
            }
        }
    }

    private static String insertOrg2TmplTableForElimGroup(Context ctx, String oldTreeId, String newTreeId) throws Exception {
        String createSql = "create table t_org_tmpl001(ftreeid varchar(44),funitid varchar(44),foldtreeid varchar(44),foldunitid varchar(44))";
        String tableName = TempTablePool.getInstance((Context)ctx).createTempTable(createSql);
        StringBuffer sql = new StringBuffer(300);
        sql.append(" insert into ").append(tableName).append("\n").append(" select struct.ftreeid,struct.funitid,oldstr.ftreeid,oldstr.funitid \n").append(" from t_org_baseunit oldorg \n").append(" inner join t_org_structure oldstr on oldstr.funitid = oldorg.fid and oldstr.ftreeid = '" + oldTreeId + "'  and oldorg.fisunion = 1").append(" inner join t_org_baseunit neworg on neworg.fnumber = oldorg.fnumber and neworg.fisfreeze = 0 \n").append(" inner join t_org_structure struct on struct.funitid = neworg.fid and struct.ftreeid = '" + newTreeId + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        return tableName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void updateTemplate(Context ctx, String oldTreeId, String newTreeId, Timestamp date, PeriodCollection periods, boolean isMergeByFiscalPeriod) throws BOSException {
        BOSObjectType bosType = new TempletDispenseInfo().getBOSType();
        boolean isUseParallel = CSLParamUtil.getBooleanCslParamValue(ctx, "KEY_CSLPARAM_ISUSEPARALLEL");
        String tmplTabName = null;
        try {
            long curTime = System.currentTimeMillis();
            StringBuffer sql = new StringBuffer();
            sql.append(" delete  t_csl_rptreceived where FID in ( \n");
            sql.append("     select rec.FID as FID from t_csl_rptreceived rec ");
            sql.append("     inner join t_csl_cslreport rpt on rpt.fid = rec.freportid and rpt.fsourcetype in (1,7,10,13) \n");
            sql.append("     inner join t_rpt_template tem on rpt.ftemplateid = tem.fid \n");
            sql.append("     inner join t_org_structure struct on struct.funitid = rpt.forgunitid and struct.ftreeid = '" + newTreeId + "' ");
            sql.append("     where rec.forgtreeid = '" + oldTreeId + "'  ");
            sql.append("        and " + UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (String)"rpt", (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
            sql.append("     and tem.FGroup not in (");
            sql.append(" select t2.FGroup from ").append(tl.get()[0]).append(" t1 join t_rpt_template t2 on t1.FDispenseSrcID=t2.FId ");
            sql.append(" where t1.FOrgBoundID = '" + oldTreeId + "')");
            sql.append(" ) ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            tmplTabName = UnionVersionUtil.insertOrg2TmplTable(ctx, oldTreeId, newTreeId);
            sql.setLength(0);
            String dbType = ContextUtil.getDbType((Context)ctx);
            boolean isOracle = dbType.equals(DbType.getName((int)2));
            sql.append(" insert  ").append(isOracle ? "/*+PARALLEL(8)*/" : "").append(" into ").append(TemplateDispenseNewUtil.templatedis_new).append("(  fid,fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime,").append("fcompanyid,FOrgBoundID,fsourcetype,fdispensesrcid,FIsAllowChgTemplet,FIsCoverTmpFormula,FIsCoverFormula,FControlUnitID,FIsAllowChgSol ) ");
            sql.append(" select ").append(isOracle ? "/*+PARALLEL(8)*/ " : " ").append("newbosid('" + bosType.toString() + "') as fid, dis.fcreatorid,dis.fcreatetime,dis.flastupdateuserid, dis.flastupdatetime,");
            sql.append(" struct.funitid as FCompanyID,struct.ftreeid as FOrgBoundID, dis.fsourcetype,dis.fdispensesrcid,dis.FIsAllowChgTemplet,");
            sql.append(" dis.FIsCoverTmpFormula,dis.FIsCoverFormula,dis.FControlUnitID, dis.FIsAllowChgSol ");
            sql.append(" from ").append(tl.get()[0]).append(" dis ");
            sql.append(" inner join ").append(tmplTabName).append(" struct on struct.foldunitid = dis.fcompanyid ").append(" and struct.foldtreeid = dis.forgboundid \n");
            sql.append(" left join ").append(TemplateDispenseNewUtil.templatedis_new).append(" dis2 on dis2.FCompanyID=struct.funitid and dis2.fdispensesrcid=dis.fdispensesrcid and dis2.FOrgBoundID=struct.ftreeid ");
            sql.append(" where dis.forgboundid = '" + oldTreeId + "' and dis2.fid is null ");
            if (DebugLogger.isDebug) {
                logger.error((Object)("updateTemplate sql:" + sql.toString()));
            }
            DbUtil.execute((Context)ctx, (String)sql.toString());
            TemplateDispenseNewUtil.insertTempletDisOrgTree((Context)ctx, (String)newTreeId);
            logger.error((Object)("---------updateTemplate time:" + (System.currentTimeMillis() - curTime)));
            if (tmplTabName == null || DebugLogger.isDebug) return;
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                if (tmplTabName == null || DebugLogger.isDebug) throw throwable;
                TempTablePool.getInstance((Context)ctx).releaseTable(tmplTabName);
                throw throwable;
            }
        }
        TempTablePool.getInstance((Context)ctx).releaseTable(tmplTabName);
        return;
    }

    private static String insertOrg2TmplTable(Context ctx, String oldTreeId, String newTreeId) throws Exception {
        String createSql = "create table t_org_tmpl001(ftreeid varchar(44),funitid varchar(44),foldtreeid varchar(44),foldunitid varchar(44))";
        String tableName = TempTablePool.getInstance((Context)ctx).createTempTable(createSql);
        StringBuffer sql = new StringBuffer(300);
        sql.append(" insert into ").append(tableName).append("\n").append(" select struct.ftreeid,struct.funitid,oldstr.ftreeid,oldstr.funitid \n").append(" from t_org_baseunit oldorg \n").append(" inner join t_org_structure oldstr on oldstr.funitid = oldorg.fid and oldstr.ftreeid = '" + oldTreeId + "'").append(" inner join t_org_baseunit neworg on neworg.fnumber = oldorg.fnumber and neworg.fisfreeze = 0 \n").append(" inner join t_org_structure struct on struct.funitid = neworg.fid and struct.ftreeid = '" + newTreeId + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        return tableName;
    }

    private static void updateItemdataYearInit(Context ctx, String oldUnionID, String newUnionID, Timestamp date) throws BOSException {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        int year = ca.get(1);
        BOSObjectType bosType = new ItemDataYearInitInfo().getBOSType();
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO T_CSL_ItemDataYearInit ");
        sql.append("(FId, FOrgTreeId, FOrgUnitId, FYear, FItemId, FCurrencyId, FSourceCurrencyId, ");
        sql.append("FDataElement, FValueType, FDebit, FCredit, FConvertStatus, FCreatorId, ");
        sql.append("FCreateTime, FLastUpdateUserId, FLastUpdateTime, FControlUnitId, ");
        sql.append("FPeriod, FDataCollectID, FDataCollectNumber,FMergeType)\n");
        sql.append(" select newbosid('" + bosType.toString() + "') as FID,struct.ftreeid as FOrgTreeID, struct.funitid as FOrgUnitID,");
        sql.append(" a.FYear,a.FItemID,a.FCurrencyID,a.FSourceCurrencyID,");
        sql.append(" a.FDataElement,a.FValueType,a.FDebit,a.FCredit,a.FConvertStatus,");
        sql.append(" a.FCreatorID,a.FCreateTime,a.FLastUpdateUserID,a.FLastUpdateTime,a.FControlUnitID,");
        sql.append(" a.FPeriod,a.FDataCollectID,a.FDataCollectNumber,FMergeType \n");
        sql.append(" from  T_CSL_ItemDataYearInit a");
        sql.append(" inner join t_org_baseunit oldorg  on oldorg.fid = a.forgunitid and oldorg.fisfreeze = 0 ");
        sql.append(" inner join t_org_baseunit neworg  on neworg.fnumber =oldorg.fnumber and neworg.fisfreeze = 0");
        sql.append(" inner join t_org_structure struct on struct.funitid = neworg.fid and struct.ftreeid = '" + newUnionID + "'");
        sql.append(" where a.fyear >= " + year + " and a.FOrgUnitID in (select funitid from t_org_structure where ftreeid='" + oldUnionID + "')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void updateNormalReport(Context ctx, String oldUnionID, String newUnionID, Timestamp date, PeriodCollection periods, boolean isMergeByFiscalPeriod) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.delete(0, sql.length());
        sql.append(" update  t_csl_rptreceived set FOrgTreeID = '" + newUnionID + "' ");
        sql.append(" where FID in ( ");
        sql.append("     select rec.FID as FID from t_csl_rptreceived rec ");
        sql.append("     inner join t_csl_cslreport rpt on rpt.fid = rec.freportid and rpt.fsourcetype in (1,7,10,13)");
        sql.append("     inner join t_org_structure struct on struct.funitid = rpt.fcompanyid and struct.ftreeid = '" + newUnionID + "' ");
        sql.append("     where rec.forgtreeid = '" + oldUnionID + "'  ");
        sql.append("        and " + UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        sql.append(" ) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.delete(0, sql.length());
        sql.append(" update  t_csl_rptreceived set FOrgTreeID = '" + newUnionID + "' ");
        sql.append(" where FID in ( ");
        sql.append("     select rec.FID as FID from t_csl_rptreceived rec ");
        sql.append("     inner join t_csl_adjust rpt on rpt.fid = rec.freportid ");
        sql.append("     inner join t_org_structure struct on struct.funitid = rpt.forgunit and struct.ftreeid = '" + newUnionID + "' ");
        sql.append("     where rec.forgtreeid = '" + oldUnionID + "'  ");
        sql.append("        and " + UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        sql.append(" ) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.delete(0, sql.length());
        sql.append(" update  t_csl_rptreceived set FOrgTreeID = '" + newUnionID + "' ");
        sql.append(" where FID in ( ");
        sql.append("     select rec.FID as FID from t_csl_rptreceived rec ");
        sql.append("     inner join t_csl_caliadjust rpt on rpt.fid = rec.freportid ");
        sql.append("     inner join t_org_structure struct on struct.funitid = rpt.forgunitid and struct.ftreeid = '" + newUnionID + "' ");
        sql.append("     where rec.forgtreeid = '" + oldUnionID + "'  ");
        sql.append("        and " + UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        sql.append(" ) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.delete(0, sql.length());
        sql.append(" delete from t_csl_rptreceived ");
        sql.append(" where FID in ( ");
        sql.append(" select rec.FID as FID from t_csl_rptreceived rec ");
        sql.append(" inner join t_csl_cslreport rpt on rpt.fid = rec.freportid and rpt.fsourcetype in (1,7,10,13)");
        sql.append(" where rec.forgtreeid = '" + oldUnionID + "' ");
        sql.append("     and " + UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        sql.append("     and not exists ( ");
        sql.append("        select struct.funitid as FOrgUnitID from t_org_structure struct ");
        sql.append("        inner join t_org_baseunit org on org.fid = struct.funitid and org.fisgrouping = 0 ");
        sql.append("        where struct.ftreeid = '" + newUnionID + "' and rpt.forgunitid = org.fid ");
        sql.append("     ) )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.delete(0, sql.length());
        sql.append(" update t_csl_cslreport set FOrgTreeId='" + newUnionID + "'");
        sql.append(" where fsourcetype in (1,7,10,13) and forgtreeid = '" + oldUnionID + "' ");
        sql.append("     and " + UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void updateGroupReport(Context ctx, String oldTreeId, String newTreeId, Timestamp date, PeriodCollection periods, boolean isMergeByFiscalPeriod) throws BOSException {
        DbUtil.execute((Context)ctx, (String)"delete t_csl_backedsheet");
        DbUtil.execute((Context)ctx, (String)"delete t_csl_backedReport");
        String datesql = UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod);
        UpdateClass uc = new UpdateClass(ctx, "T_CSL_CslReport", "FOrgTreeId", oldTreeId, newTreeId, datesql);
        uc.setUnitColumnName("FOrgUnitId");
        uc.setWhereClause(" FSourceType in (2,3,4,8,11,12,14,15,16,31,32,33,34,35) ");
        uc.execute();
        StringBuffer sql = new StringBuffer();
        sql.append(" select itemdata.fid, rpt.forgunitid from t_csl_rptreceived rec ");
        sql.append("  inner join t_csl_cslreport rpt on rpt.fid = rec.freportid and rpt.fsourcetype in (2,3,4,8,31,33,34)");
        sql.append("  inner join t_org_structure struct on struct.funitid = rpt.forgunitid and struct.ftreeid = '" + newTreeId + "' ");
        sql.append("  inner join t_csl_itemdata itemdata on itemdata.freportid=rec.freportid");
        sql.append("  where rec.forgtreeid = '" + oldTreeId + "'  ");
        sql.append("     and " + UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (String)"rpt", (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String updateItemDataSql = "update t_csl_itemdata set fcompanyid = ? where fid = ? ";
        Connection cn = null;
        PreparedStatement ps = null;
        boolean flag = false;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            ps = cn.prepareStatement(updateItemDataSql);
            while (rsTemp.next()) {
                ps.setString(1, rsTemp.getString("forgunitid"));
                ps.setString(2, rsTemp.getString("fid"));
                ps.addBatch();
                flag = true;
            }
            if (flag) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
        flag = false;
        try {
            updateItemDataSql = "update t_csl_itemdataEntry set fcompanyid = ? where fItemDataID = ? ";
            cn = EJBFactory.getConnection((Context)ctx);
            ps = cn.prepareStatement(updateItemDataSql);
            rsTemp.beforeFirst();
            while (rsTemp.next()) {
                ps.setString(1, rsTemp.getString("forgunitid"));
                ps.setString(2, rsTemp.getString("fid"));
                ps.addBatch();
                flag = true;
            }
            if (flag) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)cn);
        }
        sql = new StringBuffer();
        sql.append(" select itemdata.fid, rpt.forgunitid from t_csl_rptreceived rec ");
        sql.append("  inner join t_csl_cslreport rpt on rpt.fid = rec.freportid and rpt.fsourcetype in (11,12,32,35)");
        sql.append("  inner join t_org_structure struct on struct.funitid = rpt.forgunitid and struct.ftreeid = '" + newTreeId + "' ");
        sql.append("  inner join t_csl_dynaitemdata itemdata on itemdata.freportid=rec.freportid");
        sql.append("    where rec.forgtreeid = '" + oldTreeId + "'  ");
        sql.append("      and " + UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (String)"rpt", (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        rsTemp = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        updateItemDataSql = "update t_csl_dynaitemdata set forgunitid = ? where fid = ?";
        flag = false;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            ps = cn.prepareStatement(updateItemDataSql);
            while (rsTemp.next()) {
                ps.setString(1, rsTemp.getString("forgunitid"));
                ps.setString(2, rsTemp.getString("fid"));
                ps.addBatch();
                flag = true;
            }
            if (flag) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)cn);
        }
        sql = new StringBuffer();
        sql.append("     select itemdata.fid,rpt.forgunitid from t_csl_rptreceived rec ");
        sql.append("     inner join t_csl_cslreport rpt on rpt.fid = rec.freportid and rpt.fsourcetype in (14,15,16)");
        sql.append("     inner join t_org_structure struct on struct.funitid = rpt.forgunitid and struct.ftreeid = '" + newTreeId + "' ");
        sql.append("     inner join t_csl_multidynaitemdata itemdata on itemdata.freportid=rec.freportid");
        sql.append("     where rec.forgtreeid = '" + oldTreeId + "'  ");
        sql.append("        and " + UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (String)"rpt", (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        rsTemp = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        updateItemDataSql = "update t_csl_multidynaitemdata set forgunitid = ? where fid = ?";
        flag = false;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            ps = cn.prepareStatement(updateItemDataSql);
            while (rsTemp.next()) {
                ps.setString(1, rsTemp.getString("forgunitid"));
                ps.setString(2, rsTemp.getString("fid"));
                ps.addBatch();
                flag = true;
            }
            if (flag) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)cn);
        }
        sql = new StringBuffer();
        sql.append(" update  t_csl_rptreceived set FOrgTreeID = '" + newTreeId + "' ");
        sql.append(" where FID in ( ");
        sql.append("     select rec.FID as FID from t_csl_rptreceived rec ");
        sql.append("     inner join t_csl_cslreport rpt on rpt.fid = rec.freportid and rpt.fsourcetype in (2,3,4,8,11,12,14,15,16,31,32,33,34,35)");
        sql.append("     inner join t_org_structure struct on struct.funitid = rpt.forgunitid and struct.ftreeid = '" + newTreeId + "' ");
        sql.append("     where rec.forgtreeid = '" + oldTreeId + "'  ");
        sql.append("        and " + UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        sql.append(" ) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void updateNormalAdjust(Context ctx, String oldTreeId, String newTreeId, Timestamp date, PeriodCollection periods, boolean isMergeByFiscalPeriod) throws BOSException {
        String datesql = UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod);
        UpdateClass uc = new UpdateClass(ctx, "T_CSL_Adjust", "FOrgBoundId", oldTreeId, newTreeId, datesql);
        uc.setWhereClause(" FDataSource=1 ");
        uc.execute();
        StringBuffer sql = new StringBuffer();
        sql.append(" update  t_csl_rptreceived set FOrgTreeID = '" + newTreeId + "' ");
        sql.append(" where FID in ( ");
        sql.append("     select rec.FID as FID from t_csl_rptreceived rec ");
        sql.append("     inner join t_csl_adjust rpt on rpt.fid = rec.freportid and rpt.fdatasource=1");
        sql.append("     inner join t_org_structure struct on struct.funitid = rpt.forgunit and struct.ftreeid = '" + newTreeId + "' ");
        sql.append("     where rec.forgtreeid = '" + oldTreeId + "'  ");
        sql.append("        and " + UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        sql.append(" ) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void updateGroupAdjust(Context ctx, String oldTreeId, String newTreeId, Timestamp date, PeriodCollection periods, boolean isMergeByFiscalPeriod) throws BOSException {
        String datesql = UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod);
        UpdateClass uc = new UpdateClass(ctx, "T_CSL_Adjust", "FOrgBoundId", oldTreeId, newTreeId, datesql);
        uc.setUnitColumnName("FOrgUnit");
        uc.setWhereClause(" FDataSource in (2,3) ");
        uc.execute();
        StringBuffer sql = new StringBuffer();
        sql.append("     select itemdata.fid, rpt.FOrgUnit from t_csl_rptreceived rec ");
        sql.append("     inner join t_csl_adjust rpt on rpt.fid = rec.freportid and rpt.fdatasource in (2,3)");
        sql.append("     inner join t_org_structure struct on struct.funitid = rpt.forgunit and struct.ftreeid = '" + newTreeId + "' ");
        sql.append("     inner join t_csl_itemdata itemdata on itemdata.freportid=rec.freportid");
        sql.append("     where rec.forgtreeid = '" + oldTreeId + "'  ");
        sql.append("        and " + UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (String)"rpt", (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String updateItemDataSql = "update t_csl_itemdata set fcompanyid = ? where fid = ? ";
        Connection cn = null;
        PreparedStatement ps = null;
        boolean flag = false;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            ps = cn.prepareStatement(updateItemDataSql);
            while (rsTemp.next()) {
                ps.setString(1, rsTemp.getString("FOrgUnit"));
                ps.setString(2, rsTemp.getString("fid"));
                ps.addBatch();
                flag = true;
            }
            if (flag) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
        flag = false;
        try {
            updateItemDataSql = "update t_csl_itemdataEntry set fcompanyid = ? where fItemDataID = ? ";
            cn = EJBFactory.getConnection((Context)ctx);
            ps = cn.prepareStatement(updateItemDataSql);
            rsTemp.beforeFirst();
            while (rsTemp.next()) {
                ps.setString(1, rsTemp.getString("FOrgUnit"));
                ps.setString(2, rsTemp.getString("fid"));
                ps.addBatch();
                flag = true;
            }
            if (flag) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)cn);
        }
        sql = new StringBuffer();
        sql.append(" select itemdata.fid, rpt.FOrgUnit from t_csl_rptreceived rec ");
        sql.append("  inner join t_csl_adjust rpt on rpt.fid = rec.freportid and rpt.fdatasource in (2,3)");
        sql.append("  inner join t_org_structure struct on struct.funitid = rpt.forgunit and struct.ftreeid = '" + newTreeId + "' ");
        sql.append("  inner join t_csl_dynaitemdata itemdata on itemdata.freportid=rec.freportid");
        sql.append("   where rec.forgtreeid = '" + oldTreeId + "'  ");
        sql.append("    and " + UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (String)"rpt", (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        rsTemp = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        updateItemDataSql = "update t_csl_dynaitemdata set forgunitid = ? where fid = ? ";
        flag = false;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            ps = cn.prepareStatement(updateItemDataSql);
            while (rsTemp.next()) {
                ps.setString(1, rsTemp.getString("FOrgUnit"));
                ps.setString(2, rsTemp.getString("fid"));
                ps.addBatch();
                flag = true;
            }
            if (flag) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)cn);
        }
        sql = new StringBuffer();
        sql.append(" update  t_csl_rptreceived set FOrgTreeID = '" + newTreeId + "' ");
        sql.append(" where FID in ( ");
        sql.append("     select rec.FID as FID from t_csl_rptreceived rec ");
        sql.append("     inner join t_csl_adjust rpt on rpt.fid = rec.freportid and rpt.fdatasource in (2,3)");
        sql.append("     inner join t_org_structure struct on struct.funitid = rpt.forgunit and struct.ftreeid = '" + newTreeId + "' ");
        sql.append("     where rec.forgtreeid = '" + oldTreeId + "'  ");
        sql.append("        and " + UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        sql.append(" ) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void updateNormalCaliAdjust(Context ctx, String oldTreeId, String newTreeId, Timestamp date, PeriodCollection periods, boolean isMergeByFiscalPeriod) throws BOSException {
        String datesql = UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod);
        UpdateClass uc = new UpdateClass(ctx, "T_CSL_CaliAdjust", "FOrgBoundId", oldTreeId, newTreeId, datesql);
        uc.setWhereClause(" FDataSource=1 ");
        uc.execute();
        StringBuffer sql = new StringBuffer();
        sql.append(" update  t_csl_rptreceived set FOrgTreeID = '" + newTreeId + "' ");
        sql.append(" where FID in ( ");
        sql.append("     select rec.FID as FID from t_csl_rptreceived rec ");
        sql.append("     inner join T_CSL_CaliAdjust rpt on rpt.fid = rec.freportid and rpt.fdatasource=1");
        sql.append("     inner join t_org_structure struct on struct.funitid = rpt.forgunitid and struct.ftreeid = '" + newTreeId + "' ");
        sql.append("     where rec.forgtreeid = '" + oldTreeId + "'  ");
        sql.append("        and " + UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        sql.append(" ) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void updateGroupCaliAdjust(Context ctx, String oldTreeId, String newTreeId, Timestamp date, PeriodCollection periods, boolean isMergeByFiscalPeriod) throws BOSException {
        String datesql = UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod);
        UpdateClass uc = new UpdateClass(ctx, "T_CSL_CaliAdjust", "FOrgBoundId", oldTreeId, newTreeId, datesql);
        uc.setUnitColumnName("FOrgUnitId");
        uc.setWhereClause(" FDataSource in (2,3) ");
        uc.execute();
        StringBuffer sql = new StringBuffer();
        sql.append(" select itemdata.fid, rpt.FOrgUnitId from t_csl_rptreceived rec ");
        sql.append("  inner join T_CSL_CaliAdjust rpt on rpt.fid = rec.freportid and rpt.fdatasource in (2,3)");
        sql.append("  inner join t_org_structure struct on struct.funitid = rpt.forgunitid and struct.ftreeid = '" + newTreeId + "' ");
        sql.append("  inner join t_csl_itemdata itemdata on itemdata.freportid=rec.freportid");
        sql.append("   where rec.forgtreeid = '" + oldTreeId + "'  ");
        sql.append("     and " + UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (String)"rpt", (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String updateItemDataSql = "update t_csl_itemdata set fcompanyid = ? where fid = ?";
        Connection cn = null;
        PreparedStatement ps = null;
        boolean flag = false;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            ps = cn.prepareStatement(updateItemDataSql);
            while (rsTemp.next()) {
                ps.setString(1, rsTemp.getString("FOrgUnit"));
                ps.setString(2, rsTemp.getString("fid"));
                ps.addBatch();
                flag = true;
            }
            if (flag) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
        flag = false;
        try {
            updateItemDataSql = "update t_csl_itemdataEntry set fcompanyid = ? where fItemDataID = ?";
            cn = EJBFactory.getConnection((Context)ctx);
            ps = cn.prepareStatement(updateItemDataSql);
            rsTemp.beforeFirst();
            while (rsTemp.next()) {
                ps.setString(1, rsTemp.getString("FOrgUnit"));
                ps.setString(2, rsTemp.getString("fid"));
                ps.addBatch();
                flag = true;
            }
            if (flag) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)cn);
        }
        sql = new StringBuffer();
        sql.append(" update  t_csl_rptreceived set FOrgTreeID = '" + newTreeId + "' ");
        sql.append(" where FID in ( ");
        sql.append("     select rec.FID as FID from t_csl_rptreceived rec ");
        sql.append("     inner join T_CSL_CaliAdjust rpt on rpt.fid = rec.freportid and rpt.fdatasource in (2,3)");
        sql.append("     inner join t_org_structure struct on struct.funitid = rpt.forgunitid and struct.ftreeid = '" + newTreeId + "' ");
        sql.append("     where rec.forgtreeid = '" + oldTreeId + "'  ");
        sql.append("        and " + UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        sql.append(" ) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void updateElimination(Context ctx, String oldTreeId, String newTreeId, Timestamp date, PeriodCollection periods, boolean isMergeByFiscalPeriod) throws BOSException {
        String datesql = UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod);
        UpdateClass uc = new UpdateClass(ctx, "T_CSL_Elimination", "FOrgBoundId", oldTreeId, newTreeId, datesql);
        uc.setUnitColumnName("FOrgUnit");
        uc.execute();
    }

    private static void deleteSameElimination(Context ctx, String oldTreeId, String newTreeId, String datesql) throws BOSException {
        ArrayList<String> param = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" Delete t_csl_ElimDynaItemEntry Where FEliminationEntryID in ( \n");
        sql.append(" select entry.FID From t_csl_Elimination a \n");
        sql.append(" join t_csl_EliminationEntry entry on a.FId=entry.FEliminationID \n");
        sql.append(" Where a.FDataCollectNumber='BUDGETDATA' and a.FOrgBoundId = ?) \n");
        param.add(oldTreeId);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        sql = new StringBuffer();
        param = new ArrayList();
        sql.append(" Delete t_csl_eliminationEntry where FEliminationId in ( \n");
        sql.append(" select a.FId From t_csl_Elimination a \n");
        sql.append(" Where a.FDataCollectNumber='BUDGETDATA' and a.FOrgBoundId = ? ) \n");
        param.add(oldTreeId);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        sql = new StringBuffer();
        param = new ArrayList();
        sql.append(" Delete t_csl_elimination where FId in ( \n");
        sql.append(" select a.FId From t_csl_Elimination a \n");
        sql.append(" Where a.FDataCollectNumber='BUDGETDATA' and a.FOrgBoundId = ? ) \n");
        param.add(oldTreeId);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
    }

    private static void deleteSameRptReceived(Context ctx, String oldTreeId, String newTreeId, String datesql) throws BOSException {
        StringBuffer sql = null;
        ArrayList<String> param = null;
        sql = new StringBuffer();
        param = new ArrayList<String>();
        sql.append(" Delete t_csl_RptReceived where FId in ( \n");
        sql.append(" select a.FId From t_csl_RptReceived a \n");
        sql.append(" Where a.FOrgTreeId = ?   \n");
        param.add(newTreeId);
        sql.append(" and exists (select 'X' From t_csl_HisRptReceived b  \n");
        sql.append(" Where b.FOrgTreeId = ?  \n");
        param.add(newTreeId);
        sql.append(" and a.FReportId=b.FReportId ))");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
    }

    private static void deleteSameCaliAdjust(Context ctx, String oldTreeId, String newTreeId, String datesql) throws BOSException {
        ArrayList<String> param = null;
        StringBuffer ids = null;
        StringBuffer sql = null;
        sql = new StringBuffer();
        param = new ArrayList<String>();
        sql.append(" select a.FID From t_csl_CaliAdjust a \n");
        sql.append(" join t_csl_CaliAdjustEntry entry on a.FId=entry.FAdjustID \n");
        sql.append(" Where a.FDataCollectNumber='BUDGETDATA' and a.FOrgBoundId = ? \n");
        param.add(oldTreeId);
        IRowSet rsAdjust = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        try {
            ids = new StringBuffer();
            while (rsAdjust.next()) {
                if (ids.length() > 1) {
                    ids.append(",");
                }
                ids.append("'").append(rsAdjust.getString("FID")).append("'");
                if (ids.length() <= 60000) continue;
                UnionVersionUtil.deleteAdjustRelatingdata(ctx, ids, true);
                ids = new StringBuffer();
            }
            if (ids.length() > 1) {
                UnionVersionUtil.deleteAdjustRelatingdata(ctx, ids, true);
            }
        }
        catch (SQLException e1) {
            throw new SQLDataException(e1);
        }
    }

    private static void deleteSameAdjust(Context ctx, String oldTreeId, String newTreeId, String datesql) throws BOSException {
        ArrayList<String> param = null;
        StringBuffer ids = null;
        StringBuffer sql = null;
        sql = new StringBuffer();
        param = new ArrayList<String>();
        sql.append(" select a.FID From t_csl_Adjust a \n");
        sql.append(" join t_csl_AdjustEntry entry on a.FId=entry.FAdjustID \n");
        sql.append(" Where a.FDataCollectNumber='BUDGETDATA' and a.FOrgBoundId = ? \n");
        param.add(oldTreeId);
        IRowSet rsAdjust = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        try {
            ids = new StringBuffer();
            while (rsAdjust.next()) {
                if (ids.length() > 1) {
                    ids.append(",");
                }
                ids.append("'").append(rsAdjust.getString("FID")).append("'");
                if (ids.length() <= 60000) continue;
                UnionVersionUtil.deleteAdjustRelatingdata(ctx, ids, false);
                ids = new StringBuffer();
            }
            if (ids.length() > 1) {
                UnionVersionUtil.deleteAdjustRelatingdata(ctx, ids, false);
            }
        }
        catch (SQLException e1) {
            throw new SQLDataException(e1);
        }
    }

    private static void deleteSameCheckage(Context ctx, String oldTreeId, String newTreeId, String datesql) throws BOSException {
        StringBuffer sql = null;
        ArrayList<String> param = null;
        sql = new StringBuffer();
        param = new ArrayList<String>();
        sql.append(" Delete t_csl_InterItemdata where FId in ( \n");
        sql.append(" select a.FId From t_csl_InterItemdata a \n");
        sql.append(" Where a.FDataCollectNumber='BUDGETDATA' and a.FOrgBoundId = ? ) \n");
        param.add(oldTreeId);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        sql = new StringBuffer();
        param = new ArrayList();
        sql.append(" Delete t_csl_ExchItemdata where FId in ( \n");
        sql.append(" select a.FId From t_csl_ExchItemdata a \n");
        sql.append(" Where a.FDataCollectNumber='BUDGETDATA' and a.FOrgBoundId = ?)  \n");
        param.add(oldTreeId);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        sql = new StringBuffer();
        param = new ArrayList();
        sql.append(" Delete t_csl_DataCheckageEntry where FCheckageId in ( \n");
        sql.append(" select a.FId From t_csl_InterDataCheckage a \n");
        sql.append(" Where a.FDataCollectNumber='BUDGETDATA' and a.FOrgBoundId = ?)  \n");
        param.add(oldTreeId);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        sql = new StringBuffer();
        param = new ArrayList();
        sql.append(" Delete t_csl_InterDataCheckage where FId in ( \n");
        sql.append(" select a.FId From t_csl_InterDataCheckage a \n");
        sql.append(" Where a.FDataCollectNumber='BUDGETDATA' and a.FOrgBoundId = ? ) \n");
        param.add(oldTreeId);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        sql = new StringBuffer();
        param = new ArrayList();
        sql.append(" Delete t_csl_ExchCheckageEntry where FCheckageId in ( \n");
        sql.append(" select a.FId From t_csl_ExchCheckage a \n");
        sql.append(" Where a.FDataCollectNumber='BUDGETDATA' and a.FOrgBoundId = ? ) \n");
        param.add(oldTreeId);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        sql = new StringBuffer();
        param = new ArrayList();
        sql.append(" Delete t_csl_ExchCheckage where FId in ( \n");
        sql.append(" select a.FId From t_csl_ExchCheckage a \n");
        sql.append(" Where a.FDataCollectNumber='BUDGETDATA' and a.FOrgBoundId = ? ) \n");
        param.add(oldTreeId);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
    }

    private static void deleteSameReportData(Context ctx, String oldTreeId, String newTreeId, Timestamp date) throws BOSException, EASBizException {
        ArrayList<String> param = null;
        StringBuffer ids = new StringBuffer();
        StringBuffer sql = null;
        sql = new StringBuffer();
        param = new ArrayList<String>();
        sql.append(" select a.FId as FID From T_CSL_CslReport a \n");
        sql.append(" join t_csl_RptReceived r1 on a.FId=r1.FReportId \n");
        sql.append(" join t_rpt_template t1 on t1.FId=a.FTemplateId \n");
        sql.append(" Where a.FSourceType in (1,7) and a.FDataCollectNumber='BUDGETDATA' and r1.FOrgTreeId =? \n");
        param.add(oldTreeId);
        IRowSet rsRpt = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        try {
            ids = new StringBuffer();
            while (rsRpt.next()) {
                if (ids.length() > 1) {
                    ids.append(",");
                }
                ids.append("'").append(rsRpt.getString("FID")).append("'");
                if (ids.length() > 60000) {
                    UnionVersionUtil.deleteCommonReportRelatingData(ctx, ids.toString(), true);
                    ids = new StringBuffer();
                }
                UnionVersionUtil.updateSubCompanyReportInReportSys(ctx, rsRpt);
            }
            if (ids.length() > 1) {
                UnionVersionUtil.deleteCommonReportRelatingData(ctx, ids.toString(), true);
            }
        }
        catch (SQLException e1) {
            throw new SQLDataException(e1);
        }
        sql = new StringBuffer();
        param = new ArrayList();
        sql.append(" select a.FId as FID From T_CSL_CslReport a \n");
        sql.append(" join t_csl_RptReceived r1 on a.FId=r1.FReportId \n");
        sql.append(" join t_rpt_template t1 on t1.FId=a.FTemplateId \n");
        sql.append(" Where a.FSourceType = 10 and a.FDataCollectNumber='BUDGETDATA' and r1.FOrgTreeId =? \n");
        param.add(oldTreeId);
        IRowSet rsDynaRpt = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        try {
            ids = new StringBuffer();
            while (rsDynaRpt.next()) {
                if (ids.length() > 1) {
                    ids.append(",");
                }
                ids.append("'").append(rsDynaRpt.getString("FID")).append("'");
                if (ids.length() > 60000) {
                    UnionVersionUtil.deleteDynamicReportRelaingData(ctx, ids.toString());
                    ids = new StringBuffer();
                }
                UnionVersionUtil.updateSubCompanyReportInReportSys(ctx, rsDynaRpt);
            }
            if (ids.length() > 1) {
                UnionVersionUtil.deleteDynamicReportRelaingData(ctx, ids.toString());
            }
        }
        catch (SQLException e1) {
            throw new SQLDataException(e1);
        }
        sql = new StringBuffer();
        param = new ArrayList();
        sql.append(" select a.FId From T_CSL_CslReport a \n");
        sql.append(" join t_csl_RptReceived r1 on a.FId=r1.FReportId \n");
        sql.append(" join t_rpt_template t1 on t1.FId=a.FTemplateId \n");
        sql.append(" Where a.FSourceType in (2,3,4,6,8) and a.FDataCollectNumber='BUDGETDATA' and r1.FOrgTreeId =? \n");
        param.add(oldTreeId);
        IRowSet rsGroup = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        try {
            ids = new StringBuffer();
            while (rsGroup.next()) {
                if (ids.length() > 1) {
                    ids.append(",");
                }
                ids.append("'").append(rsGroup.getString("FID")).append("'");
                if (ids.length() <= 60000) continue;
                UnionVersionUtil.deleteCommonReportRelatingData(ctx, ids.toString(), false);
                ids = new StringBuffer();
            }
            if (ids.length() > 1) {
                UnionVersionUtil.deleteCommonReportRelatingData(ctx, ids.toString(), false);
            }
        }
        catch (SQLException e1) {
            throw new SQLDataException(e1);
        }
        sql = new StringBuffer();
        param = new ArrayList();
        sql.append(" select a.FId From T_CSL_CslReport a \n");
        sql.append(" join t_csl_RptReceived r1 on a.FId=r1.FReportId \n");
        sql.append(" Where a.FSourceType in (11,12) and a.FDataCollectNumber='BUDGETDATA' and r1.FOrgTreeId =? \n");
        param.add(oldTreeId);
        IRowSet rsDynaGroup = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        try {
            ids = new StringBuffer();
            while (rsDynaGroup.next()) {
                if (ids.length() > 1) {
                    ids.append(",");
                }
                ids.append("'").append(rsDynaGroup.getString("FID")).append("'");
                if (ids.length() <= 60000) continue;
                UnionVersionUtil.deleteDynamicReportRelaingData(ctx, ids.toString());
                ids = new StringBuffer();
            }
            if (ids.length() > 1) {
                UnionVersionUtil.deleteDynamicReportRelaingData(ctx, ids.toString());
            }
        }
        catch (SQLException e1) {
            throw new SQLDataException(e1);
        }
        sql = new StringBuffer();
        param = new ArrayList();
        sql.append(" Delete T_CSL_DataCheckageEntry where FCheckageId in (  \n");
        sql.append(" select a.FId From T_CSL_InterDataCheckage a \n");
        sql.append(" join t_csl_DataCheckageEntry entry on a.FId=entry.FCheckageId \n");
        sql.append(" Where a.FDataCollectNumber='BUDGETDATA' and a.FOrgBoundId = ? ) \n");
        param.add(oldTreeId);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        sql = new StringBuffer();
        param = new ArrayList();
        sql.append(" Delete T_CSL_InterDataCheckage where FId in (  \n");
        sql.append(" select a.FId From T_CSL_InterDataCheckage a \n");
        sql.append(" join t_csl_DataCheckageEntry entry on a.FId=entry.FCheckageId \n");
        sql.append(" Where a.FDataCollectNumber='BUDGETDATA' and a.FOrgBoundId = ? ) \n");
        param.add(oldTreeId);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        sql = new StringBuffer();
        param = new ArrayList();
        sql.append(" Delete T_CSL_ExchCheckageEntry where FCheckageId in (  \n");
        sql.append(" select a.FId From T_CSL_ExchCheckage a \n");
        sql.append(" join T_CSL_ExchCheckageEntry entry on a.FId=entry.FCheckageId \n");
        sql.append(" Where a.FDataCollectNumber='BUDGETDATA' and a.FOrgBoundId = ?) \n");
        param.add(oldTreeId);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        sql = new StringBuffer();
        param = new ArrayList();
        sql.append(" Delete T_CSL_ExchCheckage where FId in (  \n");
        sql.append(" select a.FId From T_CSL_ExchCheckage a \n");
        sql.append(" join T_CSL_ExchCheckageEntry entry on a.FId=entry.FCheckageId \n");
        sql.append(" Where a.FDataCollectNumber='BUDGETDATA' and a.FOrgBoundId = ? ) \n");
        param.add(oldTreeId);
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
    }

    private static void updateSubCompanyReportInReportSys(Context ctx, IRowSet rsRpt) throws BOSException, EASBizException {
        String sqlSel = " select FID,fcompanyid,fyear,fperiod,fperiodtype,fcurrencyid,FSOURCECURRENCYID,fsourcetype,FTemplateId from t_rpt_report where fcslreportid = ? and fisSupportGroup=1";
        byte[] data = null;
        String rptId = null;
        String hisRptId = null;
        InputStream tempInput = null;
        try {
            IRowSet temp = DbUtil.executeQuery((Context)ctx, (String)sqlSel, (Object[])new Object[]{rsRpt.getString("FID")});
            if (temp.next()) {
                rptId = temp.getString("FID");
                StringBuffer sql2 = new StringBuffer();
                ArrayList<Object> p = new ArrayList<Object>();
                sql2.append(" select h.* from t_csl_HisCslReport h \n");
                sql2.append(" join t_rpt_template t on h.FTemplateId = t.FId \n");
                sql2.append(" where h.fcompanyid =? \n");
                p.add(temp.getString("fcompanyid"));
                sql2.append(" and h.fyear=? \n");
                p.add(new Integer(temp.getInt("fyear")));
                sql2.append(" and h.fperiod=? \n");
                p.add(new Integer(temp.getInt("fperiod")));
                sql2.append(" and h.fperiodtype=? \n");
                p.add(new Integer(temp.getInt("fperiodtype")));
                sql2.append(" and h.fcurrencyid=? \n");
                p.add(temp.getString("fcurrencyid"));
                sql2.append(" and h.FSOURCECURRENCYID=? \n");
                p.add(temp.getString("FSOURCECURRENCYID"));
                sql2.append(" and h.fsourcetype=? \n");
                p.add(new Integer(temp.getInt("fsourcetype") == 7 ? 1 : temp.getInt("fsourcetype")));
                sql2.append(" and t.fgroup in (select FGroup From t_rpt_template where FTemplateId=?) \n");
                p.add(temp.getString("FTemplateId"));
                sql2.append(" and fdataCollectNumber='BUDGETDATA' \n");
                sql2.append(" and fadjuststatus=0 \n");
                IRowSet hisrpt = DbUtil.executeQuery((Context)ctx, (String)sql2.toString(), (Object[])p.toArray());
                if (hisrpt.next()) {
                    hisRptId = hisrpt.getString("FID");
                    Blob b = hisrpt.getBlob("FData");
                    tempInput = b.getBinaryStream();
                    data = CslRptUtil.InputStreamToByte(tempInput);
                    StringBuffer updateSQL = new StringBuffer();
                    ArrayList<Object> p2 = new ArrayList<Object>();
                    updateSQL.append(" update t_rpt_report set FNUMBER=?, ");
                    p2.add(hisrpt.getString("FNUMBER"));
                    updateSQL.append(" FNAME=?, \n");
                    p2.add(hisrpt.getString("FNAME"));
                    updateSQL.append(" FDESCRIPTION=?, \n");
                    p2.add(hisrpt.getString("FDESCRIPTION"));
                    updateSQL.append(" FDATA=?, \n");
                    p2.add(data);
                    updateSQL.append(" FTEMPLATEID=?, \n");
                    p2.add(hisrpt.getString("FTEMPLATEID"));
                    updateSQL.append(" FPERIODTYPE=?, \n");
                    p2.add(new Integer(hisrpt.getInt("FPERIODTYPE")));
                    updateSQL.append(" FCOMPANYID=?, \n");
                    p2.add(hisrpt.getString("FCOMPANYID"));
                    updateSQL.append(" FYEAR=?, \n");
                    p2.add(new Integer(hisrpt.getInt("FYEAR")));
                    updateSQL.append(" FPERIOD=?, \n");
                    p2.add(new Integer(hisrpt.getInt("FPERIOD")));
                    updateSQL.append(" FCREATORID=?, \n");
                    p2.add(hisrpt.getString("FCREATORID"));
                    updateSQL.append(" FCREATETIME=?, \n");
                    p2.add(hisrpt.getDate("FCREATETIME"));
                    updateSQL.append(" FLASTUPDATEUSERID=?, \n");
                    p2.add(hisrpt.getString("FLASTUPDATEUSERID"));
                    updateSQL.append(" FLASTUPDATETIME=?, \n");
                    p2.add(hisrpt.getDate("FLASTUPDATETIME"));
                    updateSQL.append(" FAUDITORID=?, \n");
                    p2.add(hisrpt.getString("FAUDITORID"));
                    updateSQL.append(" FCOMMITTEDSTATUS=?, \n");
                    p2.add(new Integer(hisrpt.getInt("FCOMMITTEDSTATUS")));
                    updateSQL.append(" FHANDLESTATUS=?, \n");
                    p2.add(new Integer(hisrpt.getInt("FHANDLESTATUS")));
                    updateSQL.append(" FSOURCETYPE=?, \n");
                    p2.add(new Integer(hisrpt.getInt("FSOURCETYPE")));
                    updateSQL.append(" FORGTREEID=?, \n");
                    p2.add(hisrpt.getString("FORGTREEID"));
                    updateSQL.append(" FCURRENCYID=?, \n");
                    p2.add(hisrpt.getString("FCURRENCYID"));
                    updateSQL.append(" FAUDITEDTIME=?, \n");
                    p2.add(hisrpt.getDate("FAUDITEDTIME"));
                    updateSQL.append(" FAUDITEDSTATUS=?, \n");
                    p2.add(new Integer(hisrpt.getInt("FAUDITEDSTATUS")));
                    updateSQL.append(" FCHECKEDSTATUS=?, \n");
                    p2.add(new Integer(hisrpt.getInt("FCHECKEDSTATUS")));
                    updateSQL.append(" FCSLREPORTID=?, \n");
                    p2.add(hisRptId);
                    updateSQL.append(" FCOMMITTIME=?, \n");
                    p2.add(hisrpt.getDate("FCOMMITTIME"));
                    updateSQL.append(" FSOURCECURRENCYID=?, \n");
                    p2.add(hisrpt.getString("FSOURCECURRENCYID"));
                    updateSQL.append(" FCONVERTSTATUS=? \n");
                    p2.add(new Integer(hisrpt.getInt("FCONVERTSTATUS")));
                    updateSQL.append(" where FID = ? ");
                    p2.add(rptId);
                    DbUtil.execute((Context)ctx, (String)updateSQL.toString(), (Object[])p2.toArray());
                    UnionVersionUtil.addAttachment(ctx, hisRptId, rptId);
                    HashMap sheetMapping = new HashMap();
                    DbUtil.execute((Context)ctx, (String)"delete t_rpt_RptSheetPara where freportid=?", (Object[])new Object[]{rptId});
                    UnionVersionUtil.insertReportSheetPara(ctx, hisRptId, rptId, sheetMapping);
                    DbUtil.execute((Context)ctx, (String)"delete t_rpt_rptpostil where freportid=?", (Object[])new Object[]{rptId});
                    UnionVersionUtil.addRPTPostil(ctx, hisRptId, rptId, sheetMapping);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            CslRptUtil.closeInputStream(tempInput);
        }
    }

    public static void deleteDynamicReportRelaingData(Context ctx, String ids) throws BOSException, SQLDataException {
        StringBuffer sql = null;
        sql = new StringBuffer();
        sql.append(" Delete T_CSL_DynaItemdataEntry where FID in ( \n");
        sql.append(" select t2.FID \n");
        sql.append(" From t_csl_DynaItemdata t1 \n");
        sql.append(" join t_csl_DynaItemdataEntry t2 on t1.FID=t2.FItemdataID \n");
        sql.append(" where t1.FReportID IN (").append(ids.toString()).append("))");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" Delete T_CSL_DynaItemdata where FReportId in (").append(ids.toString()).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" Delete T_RPT_RptSheetPara where FReportId in (").append(ids.toString()).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" Delete T_RPT_RptPostil where FReportId in (").append(ids.toString()).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" Delete T_CSL_CslPostil where FReportId in (").append(ids.toString()).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" Delete T_CSL_RptReceived where FReportId in (").append(ids.toString()).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" Delete T_CSL_CslReport where FId in (").append(ids.toString()).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void deleteAdjustRelatingdata(Context ctx, StringBuffer ids, boolean isCali) throws BOSException, SQLDataException {
        StringBuffer sql = null;
        ArrayList<String> itemdatatables = new ArrayList<String>();
        IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)"select FID,FTableName From t_csl_ItemdataTable order by FTableName ASC");
        try {
            while (rsTemp.next()) {
                itemdatatables.add(rsTemp.getString("FTableName"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        int size = itemdatatables.size();
        for (int i = 0; i < size; ++i) {
            sql = new StringBuffer();
            sql.append(" Delete ").append((String)itemdatatables.get(i)).append(" where FID IN (");
            sql.append(" select t2.FID ");
            sql.append(" From T_CSL_Itemdata t1 \n");
            sql.append(" join T_CSL_ItemdataEntry t2 on t1.FId=t2.FItemdataId \n");
            sql.append(" where FReportId IN (").append(ids.toString()).append("))");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        sql = new StringBuffer();
        sql.append(" Delete T_CSL_ItemdataEntry where FID IN (");
        sql.append(" select t2.FID ");
        sql.append(" From T_CSL_Itemdata t1 \n");
        sql.append(" join T_CSL_ItemdataEntry t2 on t1.FId=t2.FItemdataId \n");
        sql.append(" where FReportId IN (").append(ids.toString()).append("))");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" Delete T_CSL_Itemdata where FID IN (").append(ids.toString()).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" Delete T_CSL_RptReceived where FReportId in (").append(ids.toString()).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        if (!isCali) {
            sql = new StringBuffer();
            sql.append(" Delete t_csl_AdjustDynamicItem Where FAdjustEntryID in ( \n");
            sql.append(" select entry.FID From t_csl_Adjust a \n");
            sql.append(" join t_csl_AdjustEntry entry on a.FId=entry.FAdjustID \n");
            sql.append(" Where a.FID in (").append(ids.toString()).append("))");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        sql = new StringBuffer();
        sql.append(" Delete " + (isCali ? "T_CSL_CaliAdjustEntry" : "T_CSL_AdjustEntry") + " where FAdjustId in ( \n");
        sql.append(" select a.FId From " + (isCali ? "T_CSL_CaliAdjust" : "T_CSL_Adjust") + " a \n");
        sql.append(" Where a.FID in (").append(ids.toString()).append("))");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" Delete " + (isCali ? "T_CSL_CaliAdjust" : "T_CSL_Adjust") + " where FId in (").append(ids.toString()).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public static void deleteCommonReportRelatingData(Context ctx, String ids, boolean isNormal) throws BOSException, SQLDataException {
        StringBuffer sql = null;
        if (isNormal) {
            sql = new StringBuffer();
            sql.append(" Delete T_CSL_InterItemdata where FReport in (").append(ids.toString()).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql = new StringBuffer();
            sql.append(" Delete T_CSL_ExchItemdata where FReport in (").append(ids.toString()).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        ArrayList<String> itemdatatables = new ArrayList<String>();
        IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)"select FID,FTableName From t_csl_ItemdataTable order by FTableName ASC");
        try {
            while (rsTemp.next()) {
                itemdatatables.add(rsTemp.getString("FTableName"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        int size = itemdatatables.size();
        for (int i = 0; i < size; ++i) {
            sql = new StringBuffer();
            sql.append(" Delete ").append((String)itemdatatables.get(i)).append(" where FID IN (");
            sql.append(" select t2.FID ");
            sql.append(" From T_CSL_Itemdata t1 \n");
            sql.append(" join T_CSL_ItemdataEntry t2 on t1.FId=t2.FItemdataId \n");
            sql.append(" where FReportId IN (").append(ids.toString()).append("))");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        sql = new StringBuffer();
        sql.append(" Delete T_CSL_ItemdataEntry where FID IN (");
        sql.append(" select t2.FID ");
        sql.append(" From T_CSL_Itemdata t1 \n");
        sql.append(" join T_CSL_ItemdataEntry t2 on t1.FId=t2.FItemdataId \n");
        sql.append(" where FReportId IN (").append(ids.toString()).append("))");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" Delete T_CSL_Itemdata where FID IN (").append(ids.toString()).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" Delete T_RPT_RptSheetPara where FReportId in (").append(ids.toString()).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" Delete T_RPT_RptPostil where FReportId in (").append(ids.toString()).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" Delete T_CSL_CslPostil where FReportId in (").append(ids.toString()).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" Delete T_CSL_RptReceived where FReportId in (").append(ids.toString()).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" Delete T_CSL_CslReport where FId in (").append(ids.toString()).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void updateCheckageSolutionData(Context ctx, String oldTreeId, String newTreeId, Timestamp date) throws BOSException {
        block17: {
            StringBuffer sqlQuery = new StringBuffer();
            sqlQuery.append("select FID  ");
            sqlQuery.append(" from T_CSL_INTERCHECKSOLUTION");
            sqlQuery.append(" where  FOrgBoundID ='").append(oldTreeId).append("'");
            IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)sqlQuery.toString());
            try {
                if (!rsTemp.next()) break block17;
                StringBuffer sqlMain = new StringBuffer();
                StringBuffer sql = new StringBuffer();
                BOSObjectType bosType = new InterCheckSolutionInfo().getBOSType();
                String bosTypeStr = bosType.toString();
                sqlMain.append(" select newbosid('" + bosTypeStr + "') as newid,FID,FNumber,FName,'" + newTreeId + "' as FOrgBoundID,");
                sqlMain.append("FElimType,FCompanyID,FBizDate,FHandlerID,FDescription,FHasEffected,FAuditorID,FSourceBillID,");
                sqlMain.append("FSourceFunction,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID");
                sqlMain.append(" from T_CSL_INTERCHECKSOLUTION");
                sqlMain.append(" where FOrgBoundID ='").append(oldTreeId).append("'");
                sql.append(" insert into T_CSL_INTERCHECKSOLUTION ");
                sql.append("(FID,FNumber,FName,FOrgBoundID,FElimType,FCompanyID,FBizDate,");
                sql.append("FHandlerID,FDescription,FHasEffected,FAuditorID,FSourceBillID,FSourceFunction,");
                sql.append("FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID) \n");
                sql.append(" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)\n");
                ArrayList<String> entry = new ArrayList<String>();
                IRowSet rs = null;
                Connection cn = null;
                PreparedStatement ps = null;
                boolean flag = false;
                cn = EJBFactory.getConnection((Context)ctx);
                ps = cn.prepareStatement(sql.toString());
                try {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sqlMain.toString());
                    while (rs.next()) {
                        ps.setString(1, rs.getString("newid"));
                        ps.setString(2, rs.getString("FNumber"));
                        ps.setString(3, rs.getString("FName"));
                        ps.setString(4, rs.getString("FOrgBoundID"));
                        ps.setString(5, rs.getString("FElimType"));
                        ps.setString(6, rs.getString("FCompanyID"));
                        ps.setDate(7, rs.getDate("FBizDate"));
                        ps.setString(8, rs.getString("FHandlerID"));
                        ps.setString(9, rs.getString("FDescription"));
                        ps.setString(10, rs.getString("FHasEffected"));
                        ps.setString(11, rs.getString("FAuditorID"));
                        ps.setString(12, rs.getString("FSourceBillID"));
                        ps.setString(13, rs.getString("FSourceFunction"));
                        ps.setString(14, rs.getString("FCreatorID"));
                        ps.setDate(15, rs.getDate("FCreateTime"));
                        ps.setString(16, rs.getString("FLastUpdateUserID"));
                        ps.setDate(17, rs.getDate("FLastUpdateTime"));
                        ps.setString(18, rs.getString("FControlUnitID"));
                        entry.add(rs.getString("FID"));
                        entry.add(rs.getString("newid"));
                        ps.addBatch();
                        flag = true;
                    }
                    if (flag) {
                        ps.executeBatch();
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
                finally {
                    SQLUtils.cleanup((Statement)ps);
                    SQLUtils.cleanup((Connection)cn);
                }
                if (entry == null || entry.size() <= 0) break block17;
                StringBuffer entrySql = new StringBuffer();
                entrySql.append(" insert into T_CSL_INTERCHECKSOLUTIONENTRY ");
                entrySql.append(" (FID,FTemGroup,FTemNumber,FTemName,FCheckSolutionID,FSeq) \n");
                entrySql.append(" values(?,?,?,?,?,?) \n");
                IRowSet rsEntry = null;
                Connection cnEntry = null;
                PreparedStatement psEntry = null;
                boolean flagEntry = false;
                cnEntry = EJBFactory.getConnection((Context)ctx);
                String entrySqlstr = entrySql.toString();
                psEntry = cnEntry.prepareStatement(entrySqlstr);
                try {
                    int n = entry.size();
                    for (int i = 0; i < n; ++i) {
                        if (i % 2 != 0) continue;
                        StringBuffer sqlEntry = new StringBuffer();
                        BOSObjectType bosEntryType = new InterCheckSolutionEntryInfo().getBOSType();
                        sqlEntry.append(" select newbosid('" + bosEntryType.toString() + "') as FID,");
                        sqlEntry.append(" FTemGroup,FTemNumber,FTemName, '" + entry.get(i + 1) + "'as FCheckSolutionID,FSeq");
                        sqlEntry.append(" from T_CSL_INTERCHECKSOLUTIONENTRY ");
                        sqlEntry.append(" inner join T_CSL_INTERCHECKSOLUTION as b");
                        sqlEntry.append(" on b.FID = FCheckSolutionID");
                        sqlEntry.append(" where b.FOrgBoundID ='").append(oldTreeId).append("'");
                        sqlEntry.append(" and b.FID ='").append(entry.get(i)).append("'");
                        rsEntry = DbUtil.executeQuery((Context)ctx, (String)sqlEntry.toString());
                        while (rsEntry.next()) {
                            psEntry.setString(1, rsEntry.getString("FID"));
                            psEntry.setString(2, rsEntry.getString("FTemGroup"));
                            psEntry.setString(3, rsEntry.getString("FTemNumber"));
                            psEntry.setString(4, rsEntry.getString("FTemName"));
                            psEntry.setString(5, rsEntry.getString("FCheckSolutionID"));
                            psEntry.setInt(6, rsEntry.getInt("FSeq"));
                            psEntry.addBatch();
                            flagEntry = true;
                        }
                    }
                    if (flagEntry) {
                        psEntry.executeBatch();
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
                finally {
                    SQLUtils.cleanup((Statement)psEntry, (Connection)cnEntry);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
    }

    private static void updateCheckageData(Context ctx, String oldTreeId, String newTreeId, Timestamp date, PeriodCollection periods, boolean isMergeByFiscalPeriod) throws BOSException {
        String datesql = UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod);
        UpdateClass uc = new UpdateClass(ctx, "T_CSL_InterItemdata", "FOrgBoundId", oldTreeId, newTreeId, datesql);
        uc.execute();
        uc = new UpdateClass(ctx, "T_CSL_ExchItemdata", "FOrgBoundId", oldTreeId, newTreeId, datesql);
        uc.execute();
        uc = new UpdateClass(ctx, "T_CSL_InvestItemdata", "FOrgBoundId", oldTreeId, newTreeId, datesql);
        uc.setUnitColumnName("FOrgUnitId");
        uc.execute();
        uc = new UpdateClass(ctx, "T_CSL_InterDataCheckage", "FOrgBoundId", oldTreeId, newTreeId, datesql);
        uc.setUnitColumnName("FOrgUnitId");
        uc.execute();
        uc = new UpdateClass(ctx, "T_CSL_ExchCheckage", "FOrgBoundId", oldTreeId, newTreeId, datesql);
        uc.setUnitColumnName("FOrgUnitId");
        uc.execute();
        uc = new UpdateClass(ctx, "T_CSL_InvestCheckage", "FOrgBoundId", oldTreeId, newTreeId, datesql);
        uc.setUnitColumnName("FOrgUnitId");
        uc.execute();
        uc = new UpdateClass(ctx, "T_CSL_InterestCheckage", "FOrgBoundId", oldTreeId, newTreeId, datesql);
        uc.setUnitColumnName("FOrgUnitId");
        uc.execute();
        uc = new UpdateClass(ctx, "T_CSL_IIAssistant", "FOrgBoundId", oldTreeId, newTreeId, datesql);
        uc.setUnitColumnName("FOrgUnitId");
        uc.execute();
        uc = new UpdateClass(ctx, "T_CSL_IIAssistantItemData", "FOrgBoundId", oldTreeId, newTreeId, datesql);
        uc.setUnitColumnName("FOrgUnitId");
        uc.execute();
    }

    private static void updateItemHisExchgRate(Context ctx, String oldTreeId, String newTreeId, Timestamp date) throws BOSException, EASBizException {
        String d = CslRptUtil.formatDateForSql(date);
        String oql = " where orgBound.id = '" + oldTreeId + "' and changeDate >= " + d;
        IItemHisExchgRate iitemHisExchgRate = ItemHisExchgRateFactory.getLocalInstance(ctx);
        ItemHisExchgRateCollection col = iitemHisExchgRate.getItemHisExchgRateCollection(oql);
        OrgTreeInfo tree = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo((IObjectPK)new ObjectStringPK(newTreeId));
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            ItemHisExchgRateInfo info = (ItemHisExchgRateInfo)iter.next();
            info.setOrgBound(tree);
            if (info.getOrgBoundGrp() == null) continue;
            String unitId = info.getOrgBoundGrp().getId().toString();
            unitId = UnionVersionUtil.getNewUnitId(ctx, newTreeId, unitId);
            String sql = "update T_CSL_ItemHisExchgRate set FOrgBoundID = ?, FOrgBoundGrpID = ? where FId = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{tree.getId().toString(), unitId, info.getId().toString()});
        }
    }

    public static void rollbackData(Context ctx, String treeId, String oldTreeId, Timestamp date, PeriodCollection periods, boolean isMergeByFiscalPeriod) throws BOSException {
        tl.set(new String[]{TemplateDispenseNewUtil.getDisTable((Context)ctx, (String)oldTreeId), TemplateDispenseNewUtil.getDisTable((Context)ctx, (String)treeId)});
        UnionVersionUtil.rollBackTemplate(ctx, treeId, oldTreeId);
        UnionVersionUtil.rollbackYearInit(ctx, treeId);
        UnionVersionUtil.updateNormalReport(ctx, treeId, oldTreeId, date, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.updateGroupReport(ctx, treeId, oldTreeId, date, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.updateNormalAdjust(ctx, treeId, oldTreeId, date, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.updateGroupAdjust(ctx, treeId, oldTreeId, date, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.updateNormalCaliAdjust(ctx, treeId, oldTreeId, date, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.updateGroupCaliAdjust(ctx, treeId, oldTreeId, date, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.updateElimination(ctx, treeId, oldTreeId, date, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.updateCheckageData(ctx, treeId, oldTreeId, date, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.rollbackItemHisExchgRate(ctx, treeId);
        UnionVersionUtil.updateElimInvestRate(ctx, treeId, oldTreeId, date, periods, isMergeByFiscalPeriod);
        UnionVersionUtil.rollbackCheckageSolution(ctx, treeId);
        UnionVersionUtil.rollbackAdjustAndElimDispense(ctx, oldTreeId, treeId);
        UnionVersionUtil.updateIndexData(ctx, treeId, oldTreeId);
        UnionVersionUtil.updateFastMergeSolution(ctx, treeId, oldTreeId);
        UnionVersionUtil.rollbackMnsListScheme(ctx, treeId, oldTreeId);
    }

    private static void rollBackTemplate(Context ctx, String treeId, String oldTreeId) throws BOSException {
        String oldDisTable = tl.get()[0];
        StringBuilder sql = new StringBuilder(500);
        sql.append(" delete ").append(tl.get()[1]).append(" where fid in(   \n").append(" select disp.fid from ").append(tl.get()[1]).append(" disp \n").append(" join t_org_baseUnit unit on disp.FCompanyId = unit.FId     \n").append(" join ( \n").append(" select unit.FNumber uNumber,disp.FSourceType,disp.FDispenseSrcId  \n").append(" from ").append(oldDisTable).append(" disp \n").append(" join t_org_baseUnit unit on disp.FCompanyId = unit.FId \n").append(" where disp.fsourcetype in (0,1,2) and disp.forgboundid = ? ) as oldDisp \n").append(" on unit.FNumber = oldDisp.uNumber and disp.FDispenseSrcId = oldDisp.FDispenseSrcId \n").append(" and disp.fsourcetype = oldDisp.fsourcetype       \n").append(" where disp.fsourcetype in (0,1,2) and disp.forgboundid = ? ) \n");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{oldTreeId, treeId});
        sql.setLength(0);
        if (oldDisTable.equals(tl.get()[1])) {
            sql.append(" update ").append(oldDisTable).append(" set forgboundid = ?").append(" where forgboundid = ? and fsourcetype in (0,1) ").append(" and fcompanyId in (select unit.fid from t_org_structure s \n").append(" join t_org_baseunit unit on s.funitid = unit.fid \n").append(" where unit.fisgrouping = 0 and s.ftreeid = ? )");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{oldTreeId, treeId, treeId});
        } else {
            sql.append(" insert into ").append(oldDisTable);
            sql.append("(fid,fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime,fcompanyid,FOrgBoundID,fsourcetype,fdispensesrcid,");
            sql.append("FIsAllowChgTemplet,FIsCoverTmpFormula,FIsCoverFormula,FControlUnitID,FIsAllowChgSol,FISCOVERNOLOCKCELL)");
            sql.append(" select fid,fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime,");
            sql.append(" fcompanyid,'").append(oldTreeId).append("' FOrgBoundID,fsourcetype,fdispensesrcid, ");
            sql.append(" FIsAllowChgTemplet,FIsCoverTmpFormula,FIsCoverFormula,FControlUnitID,FIsAllowChgSol,FISCOVERNOLOCKCELL ");
            sql.append(" from ").append(tl.get()[1]);
            sql.append(" where forgboundid = ? and fsourcetype in (0,1) ");
            sql.append(" and fcompanyId in (select unit.fid from t_org_structure s \n");
            sql.append(" join t_org_baseunit unit on s.funitid = unit.fid \n");
            sql.append(" where unit.fisgrouping = 0 and s.ftreeid = ? )");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{treeId, treeId});
        }
        Connection cnn = null;
        PreparedStatement ps = null;
        try {
            cnn = EJBFactory.getConnection((Context)ctx);
            sql.setLength(0);
            if (oldDisTable.equals(tl.get()[1])) {
                sql.append(" select oldUnitId,oldTreeId,newUnitId,newTreeId from (\n").append("  select unit.fnumber oldNum,unit.fid oldUnitId,s.ftreeid oldTreeId from t_org_structure s \n").append("  join t_org_baseunit unit on s.funitid = unit.fid \n").append("  where s.ftreeid = ? and unit.fisgrouping = 1 \n").append(" )as oldStr \n").append(" join (").append("  select unit.fnumber newNum,unit.fid newUnitId,s.ftreeid newTreeId from t_org_structure s \n").append("  join t_org_baseunit unit on s.funitid = unit.fid \n").append("  where s.ftreeid = ? and unit.fisgrouping = 1 \n").append(" ) as newStr on oldStr.oldNum = newStr.newNum");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{oldTreeId, treeId});
                if (rs.size() <= 0) {
                    return;
                }
                sql.setLength(0);
                sql.append(" update ").append(oldDisTable).append(" set forgBoundid = ?,fcompanyId = ? ").append(" where forgBoundId = ? and fCompanyId = ? ");
                ps = cnn.prepareStatement(sql.toString());
                while (rs.next()) {
                    ps.setObject(1, rs.getString("oldTreeId"));
                    ps.setObject(2, rs.getString("oldUnitId"));
                    ps.setObject(3, rs.getString("newTreeId"));
                    ps.setObject(4, rs.getString("newUnitId"));
                    ps.addBatch();
                }
                ps.executeBatch();
            } else {
                sql.append(" insert into ").append(oldDisTable);
                sql.append(" (fid,fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime,");
                sql.append(" fcompanyid,FOrgBoundID,fsourcetype,fdispensesrcid, ");
                sql.append(" FIsAllowChgTemplet,FIsCoverTmpFormula,FIsCoverFormula,FControlUnitID,FIsAllowChgSol,FISCOVERNOLOCKCELL) ");
                sql.append(" select fid,fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime,");
                sql.append(" orgMap.oldUnitId fcompanyid,orgMap.oldTreeId FOrgBoundID,fsourcetype,fdispensesrcid, ");
                sql.append(" FIsAllowChgTemplet,FIsCoverTmpFormula,FIsCoverFormula,FControlUnitID,FIsAllowChgSol,FISCOVERNOLOCKCELL ");
                sql.append(" from ").append(tl.get()[1]).append(" newDisp ");
                sql.append(" inner join (select oldUnitId,oldTreeId,newUnitId,newTreeId from (\n").append("  select unit.fnumber oldNum,unit.fid oldUnitId,s.ftreeid oldTreeId from t_org_structure s \n").append("  join t_org_baseunit unit on s.funitid = unit.fid \n").append("  where s.ftreeid = ? and unit.fisgrouping = 1 \n").append(" )as oldStr \n").append(" join (").append("  select unit.fnumber newNum,unit.fid newUnitId,s.ftreeid newTreeId from t_org_structure s \n").append("  join t_org_baseunit unit on s.funitid = unit.fid \n").append("  where s.ftreeid = ? and unit.fisgrouping = 1 \n").append(" ) as newStr on oldStr.oldNum = newStr.newNum");
                sql.append(") orgMap on newDisp.FOrgBoundID=orgMap.newTreeId and newDisp.fcompanyid=orgMap.newUnitId ");
                sql.append(" where newDisp.forgBoundId=? ");
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{oldTreeId, treeId, treeId});
                sql.setLength(0);
                sql.append(" delete ").append(tl.get()[1]);
                sql.append(" where forgboundid = ? ");
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{treeId});
            }
            TemplateDispenseNewUtil.deleteTempletDisOrgTree((Context)ctx, (String)treeId);
            SQLUtils.cleanup((Statement)ps, (Connection)cnn);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(ps, (Connection)cnn);
        }
    }

    private static void rollbackYearInit(Context ctx, String treeId) throws BOSException {
        String sql = "delete T_CSL_ItemDataYearInit where forgtreeid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{treeId});
    }

    private static void rollbackItemHisExchgRate(Context ctx, String treeId) throws BOSException {
        String oql = "delete t_csl_ItemHisExchgRate where FOrgBoundID = ?";
        DbUtil.execute((Context)ctx, (String)oql, (Object[])new Object[]{treeId});
    }

    private static String getNewUnitId(Context ctx, String newTreeId, String oldUnitId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select s.FUnitId ");
        sql.append(" from t_org_structure s join ");
        sql.append(" t_org_baseunit base on s.FUnitId = base.FId ");
        sql.append(" where s.FTreeId = ? and base.FNumber in");
        sql.append("(select FNumber from t_org_baseunit where FId = ?)");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{newTreeId, oldUnitId});
        try {
            if (rowSet.next()) {
                String unitid = rowSet.getString("FUnitId");
                return unitid;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return null;
    }

    public String getOrgTreeId(String orgTreeNumber, Timestamp curDate) {
        return null;
    }

    public String getOrgUnitId(String orgUnitNumber, String strOrgTreeID) {
        return null;
    }

    public static Map getOrgTreeByPeriods(Context ctx, String orgTreeNumber, int iStartYear, int iEndYear, int iStartPeriod, int iEndPeriod, int iPeriodType, String orgTreeName, boolean isConvt) throws BOSException, EASBizException {
        RptPeriodTypeEnum curPeriodType = RptPeriodTypeEnum.getEnum((int)iPeriodType);
        IOrgTree orgTree = null;
        orgTree = ctx == null ? OrgTreeFactory.getRemoteInstance() : OrgTreeFactory.getLocalInstance((Context)ctx);
        OrgTreeCollection orgTreeCL = orgTree.getOrgTreeCollection("select id,startDate,endDate where number = '" + orgTreeNumber + "' and (status=" + 2 + " or status=" + 1 + ") order by startDate desc,endDate desc");
        HashMap mapResult = new HashMap();
        if (orgTreeCL != null && orgTreeCL.size() > 0) {
            int iSPeriod = iStartPeriod;
            int iEPeriod = iEndPeriod;
            int curStartPeriod = iStartPeriod;
            int curEndPeriod = iEndPeriod;
            if (!curPeriodType.equals((Object)RptPeriodTypeEnum.MONTHLY)) {
                int[] yearPeriod = RPTDateUtil.getPeriod(RPTDateUtil.getPeriodFirstDate(iStartYear, iStartPeriod, curPeriodType), RptPeriodTypeEnum.MONTHLY);
                int[] lastYearPeriod = RPTDateUtil.getPeriod(RPTDateUtil.getPeriodLastDate(iEndYear, iEndPeriod, curPeriodType), RptPeriodTypeEnum.MONTHLY);
                curStartPeriod = yearPeriod[1];
                curEndPeriod = lastYearPeriod[1];
                curPeriodType = RptPeriodTypeEnum.MONTHLY;
            }
            for (int iYear = iEndYear; iYear >= iStartYear; --iYear) {
                if (iStartYear != iEndYear) {
                    if (iYear == iStartYear) {
                        iSPeriod = curStartPeriod;
                        iEPeriod = 12;
                    } else if (iYear == iEndYear) {
                        iSPeriod = 1;
                        iEPeriod = curEndPeriod;
                    } else {
                        iSPeriod = 1;
                        iEPeriod = 12;
                    }
                }
                block1: for (int iPeriod = iEPeriod; iPeriod >= iSPeriod; --iPeriod) {
                    Date curDate = RPTDate13Util.getPeriodLastDate(iYear, iPeriod, curPeriodType);
                    for (int i = 0; i < orgTreeCL.size(); ++i) {
                        String strOrgTreeID = orgTreeCL.get(i).getId().toString();
                        Timestamp sDate = orgTreeCL.get(i).getStartDate();
                        if (sDate.compareTo(new Timestamp(curDate.getTime())) > 0) continue;
                        HashMap<String, Integer> mapTemp = new HashMap<String, Integer>();
                        mapTemp.put("KEY_STARTYEAR", new Integer(iYear));
                        mapTemp.put("KEY_ENDYEAR", new Integer(iYear));
                        mapTemp.put("KEY_STARTPERIOD", new Integer(iPeriod));
                        mapTemp.put("KEY_ENDPERIOD", new Integer(iPeriod));
                        mapResult.put(strOrgTreeID, mapTemp);
                        continue block1;
                    }
                }
            }
            return mapResult;
        }
        throw new BOSException("not found orgTree!");
    }

    public static Map getOrgTreeByPeriods(Context ctx, String orgTreeNumber, int iStartYear, int iEndYear, int iStartPeriod, int iEndPeriod, int iPeriodType) throws BOSException, EASBizException {
        return UnionVersionUtil.getOrgTreeByPeriods(ctx, orgTreeNumber, iStartYear, iEndYear, iStartPeriod, iEndPeriod, iPeriodType, null, false);
    }

    public static Map getOrgTreeByPeriods(Context ctx, String orgTreeNumber, int iStartYear, int iEndYear, int iStartPeriod, int iEndPeriod, int iPeriodType, String orgTreeName) throws BOSException, EASBizException {
        return UnionVersionUtil.getOrgTreeByPeriods(ctx, orgTreeNumber, iStartYear, iEndYear, iStartPeriod, iEndPeriod, iPeriodType, orgTreeName, false);
    }

    public static Map getBaseOrgTreeByPeriods(Context ctx, String orgTreeNumber, int iStartYear, int iEndYear, int iStartPeriod, int iEndPeriod, int iPeriodType) throws BOSException, EASBizException {
        RptPeriodTypeEnum curPeriodType = RptPeriodTypeEnum.getEnum((int)iPeriodType);
        IOrgTree orgTree = null;
        orgTree = ctx != null ? OrgTreeFactory.getLocalInstance((Context)ctx) : OrgTreeFactory.getRemoteInstance();
        StringBuffer sql = new StringBuffer();
        sql.append("select id,startDate,endDate where number = '").append(orgTreeNumber).append("'");
        sql.append(" and basic =").append(1);
        sql.append(" and (status=").append(2).append(" or status=");
        sql.append(1).append(") order by startDate desc,endDate desc");
        OrgTreeCollection orgTreeCL = orgTree.getOrgTreeCollection(sql.toString());
        HashMap<String, String> mapResult = new HashMap<String, String>();
        if (orgTreeCL != null && orgTreeCL.size() > 0) {
            int iSPeriod = iStartPeriod;
            int iEPeriod = iEndPeriod;
            for (int iYear = iEndYear; iYear >= iStartYear; --iYear) {
                if (iStartYear != iEndYear) {
                    if (iYear == iStartPeriod) {
                        iSPeriod = iStartPeriod;
                        iEPeriod = 12;
                    } else if (iYear == iEndYear) {
                        iSPeriod = 1;
                        iEPeriod = iEndPeriod;
                    } else {
                        iSPeriod = 1;
                        iEPeriod = 12;
                    }
                }
                block1: for (int iPeriod = iEPeriod; iPeriod >= iSPeriod; --iPeriod) {
                    Date curDate = RPTDate13Util.getPeriodLastDate(iYear, iPeriod, curPeriodType);
                    for (int i = 0; i < orgTreeCL.size(); ++i) {
                        String strOrgTreeID = orgTreeCL.get(i).getId().toString();
                        Timestamp sDate = orgTreeCL.get(i).getStartDate();
                        if (((Date)sDate).compareTo(curDate) > 0) continue;
                        mapResult.put("treeId", strOrgTreeID);
                        continue block1;
                    }
                }
            }
            return mapResult;
        }
        throw new BOSException("not found orgTree!");
    }

    private static void updateElimInvestRate(Context ctx, String oldTreeId, String newTreeId, Timestamp date, PeriodCollection periods, boolean isMergeByFiscalPeriod) throws BOSException {
        if (CSLParamUtil.getBooleanCslParamValue(ctx, "isUseOldUpdateElimInvestRate")) {
            String datesql = UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod);
            UpdateClass uc = new UpdateClass(ctx, "T_CSL_ElimInvestRate", "FOrgBoundId", oldTreeId, newTreeId, datesql);
            uc.setUnitColumnName("FOrgUnit");
            uc.execute();
        } else {
            try {
                String datesql = UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (String)"investRate", (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod);
                if (!StringUtils.isEmpty((String)datesql)) {
                    ArrayList<String> params;
                    SQLBuilder sqlBuild = new SQLBuilder();
                    sqlBuild.append(" select distinct investRate.forgUnit, investRate.fid ");
                    sqlBuild.append(" from T_CSL_ElimInvestRate investRate ");
                    sqlBuild.append(" inner join t_org_structure oldCompStrct on oldCompStrct.Funitid = investRate.Fcompany ");
                    sqlBuild.append(" inner join t_org_structure oldTargCompStrct on oldTargCompStrct.Funitid = investRate.Ftargetcompany ");
                    sqlBuild.append(" inner join t_org_structure compStrct on compStrct.Funitid = investRate.Fcompany ");
                    sqlBuild.append(" inner join t_org_structure targCompStrct on targCompStrct.Funitid = investRate.Ftargetcompany ");
                    sqlBuild.append("  where investRate.Forgboundid = ? ", (Object)oldTreeId);
                    sqlBuild.append("   and oldCompStrct.Ftreeid = ?", (Object)oldTreeId);
                    sqlBuild.append("   and oldTargCompStrct.Ftreeid = ? ", (Object)oldTreeId);
                    sqlBuild.append("   and compStrct.Ftreeid = ?", (Object)newTreeId);
                    sqlBuild.append("   and targCompStrct.Ftreeid = ? ", (Object)newTreeId);
                    sqlBuild.append(" and oldCompStrct.flongnumber=compStrct.flongnumber and oldTargCompStrct.flongnumber=targCompStrct.flongnumber ");
                    sqlBuild.append(" and ").append(datesql);
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuild.getSQL(), (Object[])sqlBuild.getParams());
                    OneToManyMap orgUnit_rates = new OneToManyMap();
                    while (rowSet.next()) {
                        String orgUnitId = rowSet.getString("forgUnit");
                        String investId = rowSet.getString("fid");
                        orgUnit_rates.put(orgUnitId, investId);
                    }
                    if (!orgUnit_rates.isEmpty()) {
                        params = new ArrayList<String>();
                        for (String unitId : orgUnit_rates.keySet()) {
                            if (params.size() >= 30) {
                                UnionVersionUtil.updateElimInvestRate(ctx, newTreeId, oldTreeId, params, (Map<String, Object>)orgUnit_rates, false);
                                params.clear();
                            }
                            params.add(unitId);
                        }
                        if (!params.isEmpty()) {
                            UnionVersionUtil.updateElimInvestRate(ctx, newTreeId, oldTreeId, params, (Map<String, Object>)orgUnit_rates, false);
                        }
                    }
                    sqlBuild.reset();
                    sqlBuild.append(" select distinct compStrct.flongnumber comLongNumber,targCompStrct.flongnumber targLongNumber,investRate.forgUnit, investRate.fid ");
                    sqlBuild.append(" from T_CSL_ElimInvestRate investRate ");
                    sqlBuild.append(" inner join t_org_structure compStrct on compStrct.Funitid = investRate.Fcompany ");
                    sqlBuild.append(" inner join t_org_structure targCompStrct on targCompStrct.Funitid = investRate.Ftargetcompany ");
                    sqlBuild.append("  where investRate.Forgboundid = ? ", (Object)oldTreeId);
                    sqlBuild.append("   and compStrct.Ftreeid = ?", (Object)newTreeId);
                    sqlBuild.append("   and targCompStrct.Ftreeid = ? ", (Object)newTreeId);
                    sqlBuild.append(" and ").append(datesql);
                    rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuild.getSQL(), (Object[])sqlBuild.getParams());
                    orgUnit_rates.clear();
                    while (rowSet.next()) {
                        String comLongNumber = rowSet.getString("comLongNumber");
                        String targLongNumber = rowSet.getString("targLongNumber");
                        String orgUnit = rowSet.getString("forgUnit");
                        if (StringUtils.isEmpty((String)orgUnit)) continue;
                        orgUnit_rates.put(orgUnit, new String[]{comLongNumber, targLongNumber, rowSet.getString("fid")});
                    }
                    if (!orgUnit_rates.isEmpty()) {
                        params = new ArrayList();
                        for (String unitId : orgUnit_rates.keySet()) {
                            if (params.size() >= 30) {
                                UnionVersionUtil.updateElimInvestRate(ctx, newTreeId, oldTreeId, params, (Map<String, Object>)orgUnit_rates, true);
                                params.clear();
                            }
                            params.add(unitId);
                        }
                        if (!params.isEmpty()) {
                            UnionVersionUtil.updateElimInvestRate(ctx, newTreeId, oldTreeId, params, (Map<String, Object>)orgUnit_rates, true);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"updateElimInvestRate error", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    public static void updateElimInvestRate(Context ctx, String newTreeId, String oldTreeId, List unitIds, Map<String, Object> orgUnit_rates, boolean isOrgUnitChanged) throws Exception {
        if (!orgUnit_rates.isEmpty()) {
            SQLBuilder sqlBuild = new SQLBuilder();
            sqlBuild.append(" select distinct oldUnit.fid oldId, newUnit.fid newId ");
            if (isOrgUnitChanged) {
                sqlBuild.append(",newStr.flongNumber ");
            }
            sqlBuild.append(" from t_org_structure oldStr ");
            sqlBuild.append(" inner join t_org_baseunit oldUnit on oldUnit.fid = oldStr.Funitid ");
            sqlBuild.append(" inner join t_org_baseunit newUnit on newUnit.fnumber = oldUnit.fnumber ");
            sqlBuild.append(" inner join t_org_structure newStr on newStr.Funitid = newUnit.fid ");
            sqlBuild.append("  where oldStr.ftreeid = ? ", (Object)oldTreeId);
            sqlBuild.append("  and newStr.ftreeid = ? ", (Object)newTreeId);
            sqlBuild.append(" and oldStr.funitid in ", (Collection)unitIds);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuild.getSQL(), (Object[])sqlBuild.getParams());
            ArrayList<String[]> paramList = new ArrayList<String[]>();
            while (rowSet.next()) {
                String oldId = rowSet.getString("oldId");
                String newId = rowSet.getString("newId");
                if (isOrgUnitChanged) {
                    String longNumber = rowSet.getString("flongNumber") + "!";
                    List objs = (List)orgUnit_rates.get(oldId);
                    for (String[] obj : objs) {
                        String companyLongNum = obj[0];
                        String targCompanyLongNum = obj[1];
                        String rateId = obj[2];
                        if (companyLongNum == null || !companyLongNum.startsWith(longNumber) || targCompanyLongNum == null || !targCompanyLongNum.startsWith(longNumber)) continue;
                        String[] params = new String[]{newTreeId, newId, rateId};
                        paramList.add(params);
                    }
                    continue;
                }
                List rateIds = (List)orgUnit_rates.get(oldId);
                for (String rateId : rateIds) {
                    String[] params = new String[]{newTreeId, newId, rateId};
                    paramList.add(params);
                }
            }
            if (!paramList.isEmpty()) {
                DbUtil.executeBatch((Context)ctx, (String)"update T_CSL_ElimInvestRate set Forgboundid=?,FORGUNIT=? where fid=?", paramList);
            }
        }
    }

    public static void repairDataAfterVersioning(Context ctx, String treeId, Timestamp date, PeriodCollection periods, boolean isMergeByFiscalPeriod, int startState) throws BOSException {
        UnionVersionUtil.repairRptReceivedRepeatRecords(ctx, treeId, date, periods, isMergeByFiscalPeriod, startState);
        UnionVersionUtil.repairCslReportTreeId(ctx, treeId, date, periods, isMergeByFiscalPeriod, startState);
    }

    private static void repairRptReceivedRepeatRecords(Context ctx, String treeId, Timestamp date, PeriodCollection periods, boolean isMergeByFiscalPeriod, int startState) throws BOSException {
    }

    private static void repairCslReportTreeId(Context ctx, String treeId, Timestamp date, PeriodCollection periods, boolean isMergeByFiscalPeriod, int startState) throws BOSException {
        StringBuilder sql = new StringBuilder(1000);
        DbUtil.execute((Context)ctx, (String)"delete t_csl_unionversionlog where fcurrenttreeid = ? and frepairType = 2", (Object[])new Object[]{treeId});
        sql.append(" insert into t_csl_unionVersionLog(freportid,fcnt1,fcnt2,ftreeid,").append(" ftreenum,ftreestartdate,ftreeenddate,ftreeLastupdate,freportNum,").append(" fyear,fperiod,fcompanyNum,frepairType,fcurrentTreeId,fstartState)").append(" select r.fid,1,1,tree.fid,tree.fnumber,tree.fstartdate, \n").append(" tree.fenddate,tree.flastupdatetime,r.fnumber,r.fyear,r.fperiod,\n").append(" unit.fnumber,2,").append("'" + treeId + "',").append(startState).append(" from t_csl_cslreport r \n").append(" join t_org_tree tree on r.forgtreeid = tree.fid     \n").append(" join t_org_baseUnit unit on unit.fid = r.forgunitid \n").append(" where r.fsourcetype in(11,12,14,15,16,31,32,33,34,35,42,43,44,45,46) \n").append(" and tree.fnumber in(select fnumber from t_org_tree where fid = ? )").append(" and \n").append(UnionBeforeVersion.getSqlByDateMore((Timestamp)date, (String)"r", (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod));
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{treeId});
        sql.setLength(0);
        sql.append(" update t_csl_cslreport set forgtreeid ='" + treeId + "' \n").append(" where fid in( \n").append(" select r.fid from t_csl_cslreport r \n").append(" join t_csl_unionVersionLog l   \n").append(" on r.fid = l.freportid \n").append(" and r.forgtreeid = l.ftreeid \n").append(" where l.ftreeid <> l.fcurrentTreeId \n").append(" and l.frepairType = 2 and l.fcurrentTreeId = '" + treeId + "')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        if (!DbType.isOracle((int)DbType.getValue((String)ContextUtil.getDbType((Context)ctx)))) {
            return;
        }
        sql.setLength(0);
        sql.append(" update t_csl_cslreport r set forgUnitId =( select unit.Fid \n").append(" from t_org_baseUnit unit  \t\t\t\t\n").append(" join t_org_structure s on unit.fid = s.funitId   \n").append(" join t_csl_unionVersionLog l   \t\t\n").append(" on l.fcurrenttreeid = s.ftreeid \t\t\n").append(" where l.frepairType = 2 and l.fcurrentTreeId = '" + treeId + "'").append(" and l.fcompanyNum = unit.fnumber \t\t\n").append(" and r.fid = l.freportid \t\t\t\t\n").append(" and r.forgtreeid = l.fcurrentTreeId )\t\n").append(" where exists ( select 1 from t_org_baseUnit unit \n ").append(" join t_org_structure s on unit.fid = s.funitId   \n").append(" join t_csl_unionVersionLog l  \t\t\t\n").append(" on l.fcurrenttreeid = s.ftreeid \t\t\n").append(" where l.frepairType = 2 and l.fcurrentTreeId = '" + treeId + "'").append(" and l.fcompanyNum = unit.fnumber \t\t\n").append(" and r.fid = l.freportid \t\t\t\t\n").append(" and r.forgtreeid = l.fcurrentTreeId )  \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public static void main(String[] args) throws Exception {
        UnionVersionUtil.repairDataAfterVersioning(null, null, new Timestamp(new Date().getTime()), null, false, 1);
    }

    private static void updateIndexData(Context ctx, String oldTreeId, String newTreeId) throws BOSException {
        SQLBuilder buffer = new SQLBuilder();
        buffer.append(" UPDATE T_CSL_IndexType ");
        buffer.append("    SET FOrgBoundId = ? ", (Object)newTreeId);
        buffer.append("  WHERE FOrgBoundId = ? ", (Object)oldTreeId);
        DbUtil.execute((Context)ctx, (String)buffer.getSQL(), (Object[])buffer.getParams());
    }

    public static List getGroupNormalRpts(Context ctx, String treeId, List companyIds, String datesql, Timestamp date, String dataCollectNumber) throws BOSException {
        TableInfo table = new TableInfo("T_TMPL_CMPIDSS");
        table.addColumn("ID");
        ParamTempTblService srv = new ParamTempTblService(ctx, table, (Collection)companyIds, null);
        StringBuffer sql = new StringBuffer();
        sql.append("select FId, FReportId from t_csl_rptreceived r");
        sql.append(" where FOrgTreeID = '").append(treeId);
        sql.append("' and FReportID in (");
        sql.append("select FId from t_csl_cslreport");
        sql.append(" where FSourceType in (1,7,10,13)");
        sql.append(" and FReportDate >= Date'").append(date);
        sql.append("' and ").append(datesql);
        sql.append(" and FOrgUnitId in (").append(srv.getParamsSql());
        sql.append(" ) ");
        if (!StringUtils.isEmpty((String)dataCollectNumber)) {
            sql.append(" and FDataCollectNumber='" + dataCollectNumber + "'");
        }
        sql.append(" ) ");
        sql.append(" and not exists(select 1 from t_csl_rptreceived rc where rc.freportid=r.FReportID and rc.FOrgTreeID<>'");
        sql.append(treeId).append("')");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            ArrayList<String> rptreceiveList = new ArrayList<String>();
            while (rowSet.next()) {
                rptreceiveList.add(rowSet.getString("FId"));
            }
            ArrayList<String> arrayList = rptreceiveList;
            return arrayList;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            srv.release();
        }
    }

    public static List getAdjust(Context ctx, String treeId, String orgUnitId, List companyIds, String datesql, Timestamp date, String dataCollectNumber) throws BOSException {
        StringBuffer sql = new StringBuffer();
        ArrayList<String> param = new ArrayList<String>();
        sql.append("select FId from t_csl_adjust");
        sql.append(" where FOrgBoundId = '").append(treeId).append("' \n");
        if (!StringUtils.isEmpty((String)dataCollectNumber)) {
            sql.append(" and FDataCollectNumber='").append(dataCollectNumber).append("' ");
        }
        if (date != null) {
            sql.append(" and FDate >= Date'").append(date).append("' \n");
        }
        if (!StringUtils.isEmpty((String)datesql)) {
            sql.append(" and ").append(datesql);
        }
        sql.append(" and FOrgUnit in (");
        sql.append("select s.FUnitId from t_org_structure s");
        sql.append(" join t_org_baseunit b on s.FUnitId = b.FId");
        sql.append(" where s.FTreeId = ? and b.FIsGrouping = 0");
        param.add(treeId);
        sql.append(" and s.FParentId in (");
        sql.append(" select FId from t_org_structure where");
        if (!StringUtils.isEmpty((String)orgUnitId)) {
            sql.append(" FUnitId = ? and ");
            param.add(orgUnitId);
        }
        sql.append(" FTreeId = ?))");
        param.add(treeId);
        if (companyIds != null && !companyIds.isEmpty()) {
            sql.append(" and FOrgUnit in (");
            int s = companyIds.size();
            for (int i = 0; i < s; ++i) {
                if (i > 0) {
                    sql.append(",");
                }
                sql.append("'").append(companyIds.get(i)).append("'");
            }
            sql.append(" ) ");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        try {
            ArrayList<String> adjustList = new ArrayList<String>();
            while (rowSet.next()) {
                adjustList.add(rowSet.getString("FId"));
            }
            return adjustList;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static List getGroupRpt(Context ctx, String treeId, Collection<String> orgUnitIds, String datesql, Timestamp date, int rpttype, String dataCollectNumber) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FId from t_csl_cslreport");
        sql.append(" where FOrgTreeId = '").append(treeId).append("' ");
        if (orgUnitIds != null && !orgUnitIds.isEmpty()) {
            sql.append(" and FOrgUnitId in (").append(CslRptUtil.collection2String(orgUnitIds, ",", true)).append(")");
        }
        if (date != null) {
            sql.append(" and FReportDate >= Date'").append(date).append("' ");
        }
        if (!StringUtils.isEmpty((String)datesql)) {
            sql.append(" and ").append(datesql);
        }
        if (!StringUtils.isEmpty((String)dataCollectNumber)) {
            sql.append(" and FDataCollectNumber='" + dataCollectNumber + "'");
        }
        if (rpttype == 2) {
            sql.append(" and FSourceType in (2,8,11,14,31,32)");
        } else if (rpttype == 4) {
            sql.append(" and FSourceType in (4,16,33) ");
        } else if (rpttype == 3) {
            sql.append(" and FSourceType in (3,12,15,34,35,42,43) ");
        } else if (rpttype == 999) {
            sql.append(" and FSourceType in (2,3,4,8,11,12,14,15,16,31,32,33,34,35,42,43) ");
        } else {
            sql.append(" and FSourceType = 2 ");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            ArrayList<String> sumRptList = new ArrayList<String>();
            while (rowSet.next()) {
                sumRptList.add(rowSet.getString("FId"));
            }
            return sumRptList;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static List getElimination(Context ctx, String treeId, Collection<String> orgUnitIds, String datesql, Timestamp date, String dataCollectNumber) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FId from t_csl_elimination");
        sql.append(" where FOrgBoundId = '").append(treeId).append("'");
        if (orgUnitIds != null && !orgUnitIds.isEmpty()) {
            sql.append(" and FOrgUnit in (").append(CslRptUtil.collection2String(orgUnitIds, ",", true)).append(")");
        }
        if (date != null) {
            sql.append(" and FDate >= Date'").append(date).append("'");
        }
        if (!StringUtils.isEmpty((String)datesql)) {
            sql.append(" and ").append(datesql);
        }
        if (!StringUtils.isEmpty((String)dataCollectNumber)) {
            sql.append(" and FDataCollectNumber='").append(dataCollectNumber).append("' ");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            ArrayList<String> elimList = new ArrayList<String>();
            while (rowSet.next()) {
                elimList.add(rowSet.getString("FId"));
            }
            return elimList;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static Map getFastMergeSolu(Context ctx, String treeId, Collection<String> orgUnitIds) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select solu.FId Fid,unit.FOrgUnitid FOrgUnitid from T_CSL_FastMergesolu solu \n");
        sql.append(" inner join T_CSL_FastMergeOrgUnit unit on unit.FFastMergeSoluId = solu.Fid \n");
        sql.append(" where solu.FOrgBoundId = '").append(treeId).append("'");
        if (orgUnitIds != null && !orgUnitIds.isEmpty()) {
            sql.append(" and unit.FOrgUnitid in (").append(CslRptUtil.collection2String(orgUnitIds, ",", true)).append(") \n");
            sql.append(" and unit.fisselected = 1 \n");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            HashMap orgUnitMap = new HashMap();
            while (rowSet.next()) {
                String soluid = rowSet.getString("FId");
                String unitid = rowSet.getString("FOrgUnitid");
                if (orgUnitMap.containsKey(soluid)) {
                    List list = (List)orgUnitMap.get(soluid);
                    list.add(unitid);
                    continue;
                }
                ArrayList<String> orgUnits = new ArrayList<String>();
                orgUnits.add(unitid);
                orgUnitMap.put(soluid, orgUnits);
            }
            return orgUnitMap;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private static void updateFastMergeSolution(Context ctx, String oldTreeId, String newTreeId) throws BOSException {
        UnionVersionUtil.updateOrgUnitid(ctx, oldTreeId, newTreeId);
        SQLBuilder buffer = new SQLBuilder();
        buffer.append(" UPDATE T_CSL_FastMergeSolu ");
        buffer.append("    SET FOrgBoundId = ? ", (Object)newTreeId);
        buffer.append("  WHERE FOrgBoundId = ? ", (Object)oldTreeId);
        DbUtil.execute((Context)ctx, (String)buffer.getSQL(), (Object[])buffer.getParams());
    }

    private static void updateOrgUnitid(Context ctx, String oldTreeId, String newTreeId) throws BOSException {
        String updateOrgUnitSql = "update T_CSL_FastMergeOrgUnit set forgUnitid = ? where fid = ?";
        SQLBuilder sql = new SQLBuilder();
        sql.append("Select s.FUnitId forgunitid, ab.FId fid \n");
        sql.append("from t_org_structure s \n");
        sql.append("inner join t_org_baseunit base on s.FUnitId = base.FId \n");
        sql.append("inner join ( \n");
        sql.append("select b.FNumber, a.FId \n");
        sql.append("from t_org_baseunit b \n");
        sql.append("inner join T_CSL_FastMergeOrgUnit a on a.forgunitid = b.fid \n");
        sql.append("inner join  T_CSL_FastMergesolu c on c.FID = a.FFASTMERGESOLUID ");
        sql.append("where c.FORGBOUNDID =?", (Object)oldTreeId);
        sql.append(")ab on base.FNumber = ab.FNumber \n");
        sql.append("where s.FTreeId =?", (Object)newTreeId);
        IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sql.getParams());
        Connection cn = null;
        PreparedStatement ps = null;
        boolean flag = false;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            ps = cn.prepareStatement(updateOrgUnitSql);
            while (rsTemp.next()) {
                ps.setString(1, rsTemp.getString("forgunitid"));
                ps.setString(2, rsTemp.getString("fid"));
                ps.addBatch();
                flag = true;
            }
            if (flag) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
    }

    public static class UpdateClass {
        String _tableName = null;
        String _treeColumnName = null;
        String _oldTreeId = null;
        String _newTreeId = null;
        String _unitColumnName = null;
        Context _ctx = null;
        String _datesql = null;
        String _whereClause = null;

        public UpdateClass(Context ctx, String tableName, String columnName, String oldTreeId, String newTreeId, String datesql) {
            this._tableName = tableName;
            this._treeColumnName = columnName;
            this._oldTreeId = oldTreeId;
            this._newTreeId = newTreeId;
            this._ctx = ctx;
            this._datesql = datesql;
        }

        public void setUnitColumnName(String unitColumnName) {
            this._unitColumnName = unitColumnName;
        }

        public void setWhereClause(String where) {
            this._whereClause = where;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void execute() throws BOSException {
            PreparedStatement ps;
            Connection conn;
            block8: {
                if (this._unitColumnName == null) {
                    StringBuffer sbSQL = new StringBuffer();
                    sbSQL.append(" update ").append(this._tableName);
                    sbSQL.append(" set ").append(this._treeColumnName).append("= ?");
                    sbSQL.append(" where ").append(this._treeColumnName).append("= ?");
                    sbSQL.append(" and ").append(this._datesql);
                    if (this._whereClause != null) {
                        sbSQL.append(" and ").append(this._whereClause);
                    }
                    DbUtil.execute((Context)this._ctx, (String)sbSQL.toString(), (Object[])new Object[]{this._newTreeId, this._oldTreeId});
                    return;
                }
                StringBuffer sql = new StringBuffer();
                sql.append("select s.FUnitId, ab.FId ");
                sql.append(" from t_org_structure s join ");
                sql.append(" t_org_baseunit base on s.FUnitId = base.FId join ");
                sql.append("(select b.FNumber, a.FId");
                sql.append(" from t_org_baseunit b join ").append(this._tableName).append(" a");
                sql.append(" on b.FId = a.").append(this._unitColumnName);
                sql.append(" where a.").append(this._treeColumnName).append(" = ?");
                sql.append(" and ").append(this._datesql);
                if (this._whereClause != null) {
                    sql.append(" and ").append(this._whereClause);
                }
                sql.append(") ab on base.FNumber = ab.FNumber");
                sql.append(" where s.FTreeId = ?");
                IRowSet rowSet = DbUtil.executeQuery((Context)this._ctx, (String)sql.toString(), (Object[])new Object[]{this._oldTreeId, this._newTreeId});
                conn = null;
                ps = null;
                try {
                    StringBuffer update = new StringBuffer();
                    update.append("update ").append(this._tableName);
                    update.append(" set ").append(this._treeColumnName).append(" = ?,");
                    update.append(this._unitColumnName).append(" = ?");
                    update.append(" where FId = ?");
                    conn = EJBFactory.getConnnection((Context)this._ctx);
                    ps = conn.prepareStatement(update.toString());
                    boolean isEmpty = true;
                    while (rowSet.next()) {
                        isEmpty = false;
                        ps.setObject(1, this._newTreeId);
                        ps.setObject(2, rowSet.getString("FUnitId"));
                        ps.setObject(3, rowSet.getString("FId"));
                        ps.addBatch();
                    }
                    if (isEmpty) break block8;
                    ps.executeBatch();
                    ps.clearBatch();
                }
                catch (SQLException exc) {
                    try {
                        throw new SQLDataException(exc);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(ps, conn);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
            return;
        }
    }
}

