/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.articulation.articulationprocessor;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.StringUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CheckFormulaException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.OperateSymbolEnum;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.ArticulationInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.Formula;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.ItemFormulaInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationprocessor.IArticulationProcessor;
import com.kingdee.eas.fi.gr.cslrpt.articulation.fillformula.FillFormulaFactory;
import com.kingdee.eas.fi.gr.cslrpt.articulation.fillformula.IFillFormula;
import com.kingdee.eas.fi.gr.cslrpt.util.ParameterContext;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractArticulationProcessor
implements IArticulationProcessor {
    protected static final int ID = 0;
    protected static final int LFORMULA = 1;
    protected static final int RFORMULA = 2;
    protected static final int DIFFSTANDVALUE = 2;
    protected static final int OPERATER = 3;
    protected static final int RANGE = 4;
    protected static final int REPORT = 5;
    protected static final int ORGTREE = 6;
    protected static final int ARTICULATIONINFO = 7;
    protected static final String FORMULA_ITEM_NAME = "item";
    protected static final String FORMULA_DITEM_NAME = "ditem";
    protected static final String FORMULA_ACCTITEM_NAME = "acctitem";
    protected static final String FORMULA_DYITEM_NAME = "dyitem";
    protected static final String FORMULA_HISRATEDATA_NAME = "hisratedata";
    protected static final String BRACKET = "(";

    protected boolean isFormula(String s) {
        return true;
    }

    protected void checkFormulaAvailability(Context ctx, Sheet sheet, ArticulationInfo articulationInfo, String formula) throws EASBizException {
        if (!RptUtil.isFormulaValid((String)formula, (Sheet)sheet)) {
            throw new CheckFormulaException(CheckFormulaException.REPORT_CALC_ERROR, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"127_CheckFormulaControllerBean", (Locale)ctx.getOriginLocale()), articulationInfo.getNumber(), formula});
        }
    }

    protected Expression processFormulaExpression(Context ctx, Expression expression, ParameterContext parameterContext) {
        if (expression instanceof FunctionExpr) {
            FunctionExpr functionExpr = (FunctionExpr)expression;
            IFillFormula fillFormula = FillFormulaFactory.getFillFormula(functionExpr.funcionName);
            expression = fillFormula.fillFormulaParameter(ctx, (FunctionExpr)expression, parameterContext);
        } else if (expression instanceof BinaryOperationExpr) {
            Expression expr;
            ((BinaryOperationExpr)expression).left = expr = this.processFormulaExpression(ctx, ((BinaryOperationExpr)expression).left, parameterContext);
            ((BinaryOperationExpr)expression).right = expr = this.processFormulaExpression(ctx, ((BinaryOperationExpr)expression).right, parameterContext);
        } else if (expression instanceof UnaryOperationExpr) {
            Expression expr;
            ((UnaryOperationExpr)expression).operand = expr = this.processFormulaExpression(ctx, ((UnaryOperationExpr)expression).operand, parameterContext);
        }
        return expression;
    }

    protected boolean checkIsCommonReport(CslReportInfo rptInfo) {
        return rptInfo.getSourceType().getValue() == 1 || rptInfo.getSourceType().getValue() == 7 || rptInfo.getSourceType().getValue() == 10 || rptInfo.getSourceType().getValue() == 13;
    }

    protected Object getCalculateValue(ArticulationInfo articulationInfo, Variant objValue, String formula) throws EASBizException {
        if (objValue == null || objValue.isNull()) {
            objValue = new Variant((Object)new BigDecimal("0"));
        }
        if (objValue.getValue() instanceof Boolean) {
            return new BigDecimal((Boolean)objValue.getValue() != false ? "1" : "0");
        }
        if (objValue.isString()) {
            boolean isNumeric = false;
            try {
                new BigDecimal(objValue.toString());
                isNumeric = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (!isNumeric) {
                Object[] obj = new Object[]{objValue, articulationInfo.getNumber(), formula};
                throw new CheckFormulaException(CheckFormulaException.REPORT_CALC_ERROR, obj);
            }
        }
        Object value = null;
        value = objValue.getValue() instanceof Throwable ? objValue.getValue() : CslRptUtil.toBigDecimal(objValue);
        return value;
    }

    protected boolean isComparePass(Object left, Object right, OperateSymbolEnum operator, BigDecimal bdRange) {
        if (left instanceof Throwable || right instanceof Throwable) {
            return false;
        }
        BigDecimal bdLeftValue = (BigDecimal)left;
        BigDecimal bdRightValue = (BigDecimal)right;
        if (operator.equals((Object)OperateSymbolEnum.EQUAL)) {
            if (bdRange == null) {
                return bdLeftValue.equals(bdRightValue);
            }
            return bdLeftValue.equals(bdRightValue) || bdLeftValue.subtract(bdRightValue).abs().compareTo(bdRange.abs()) <= 0;
        }
        if (operator.equals((Object)OperateSymbolEnum.LESS)) {
            if (bdRange == null || bdRange.compareTo(new BigDecimal("0")) == 0) {
                return bdLeftValue.compareTo(bdRightValue) < 0;
            }
            return bdLeftValue.compareTo(bdRightValue) < 0 || bdLeftValue.compareTo(bdRange.add(bdRightValue)) <= 0;
        }
        if (operator.equals((Object)OperateSymbolEnum.LESSANDEQUAL)) {
            if (bdRange == null) {
                return this.isComparePass(bdLeftValue, bdRightValue, OperateSymbolEnum.EQUAL, null) || this.isComparePass(bdLeftValue, bdRightValue, OperateSymbolEnum.LESS, null);
            }
            return this.isComparePass(bdLeftValue, bdRightValue, OperateSymbolEnum.EQUAL, bdRange) || this.isComparePass(bdLeftValue, bdRightValue, OperateSymbolEnum.LESS, bdRange);
        }
        if (operator.equals((Object)OperateSymbolEnum.MORE)) {
            if (bdRange == null || bdRange.compareTo(new BigDecimal("0")) == 0) {
                return bdLeftValue.compareTo(bdRightValue) > 0;
            }
            return bdLeftValue.compareTo(bdRightValue) > 0 || bdLeftValue.compareTo(bdRightValue.subtract(bdRange)) >= 0;
        }
        if (operator.equals((Object)OperateSymbolEnum.MOREANDEQUAL)) {
            if (bdRange == null) {
                return this.isComparePass(bdLeftValue, bdRightValue, OperateSymbolEnum.EQUAL, null) || this.isComparePass(bdLeftValue, bdRightValue, OperateSymbolEnum.MORE, null);
            }
            return this.isComparePass(bdLeftValue, bdRightValue, OperateSymbolEnum.EQUAL, bdRange) || this.isComparePass(bdLeftValue, bdRightValue, OperateSymbolEnum.MORE, bdRange);
        }
        if (operator.equals((Object)OperateSymbolEnum.UNEQUAL)) {
            return this.isComparePass(bdLeftValue, bdRightValue, OperateSymbolEnum.MORE, null) || this.isComparePass(bdLeftValue, bdRightValue, OperateSymbolEnum.LESS, null);
        }
        return false;
    }

    public boolean isArticulationHasPostil(ArticulationInfo articulationInfo) {
        boolean isHasPostil = false;
        for (Map.Entry entry : articulationInfo.getDetailFormulaMap().entrySet()) {
            Formula formula = (Formula)entry.getValue();
            ItemFormulaInfo itemFormulaInfo = (ItemFormulaInfo)formula.getExtendedProperty().get("itemFormulaInfo");
            if (itemFormulaInfo == null || StringUtil.isEmpty((String)itemFormulaInfo.getPostil())) continue;
            isHasPostil = true;
            break;
        }
        return isHasPostil;
    }
}

