/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.articulation.articulationprocessor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCheckResultTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.OperateSymbolEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCheckFormulaInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.ArticulationCheckResult;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.ArticulationInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.BtwTableArticulationInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationprocessor.AbstractArticulationProcessor;
import com.kingdee.eas.fi.gr.cslrpt.util.ParameterContext;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BtwTableArticulationProcessor
extends AbstractArticulationProcessor {
    @Override
    public List getArticulationInfoList(Context ctx, CslReportInfo rptInfo, ParameterContext parameterContext) throws BOSException {
        Boolean isSupportOtherDS = (Boolean)parameterContext.getAttribute("isSupportOtherDS");
        StringBuffer sql = new StringBuffer();
        sql.append(" select formula.FID, formula.FNumber, formula.FName, formula.FIfClause, formula.FLFormula, ");
        sql.append(" formula.FOperateSymbol, formula.FRFormula, formula.FRange, formula.FCheckResult, formula.FPrompt ");
        sql.append(" from T_CSL_FormulaDispense dispense inner join T_CSL_CheckFormula formula on dispense.FCheckFormulaID = formula.FID");
        sql.append(" where dispense.FFormulaType = ").append(1);
        sql.append(" and dispense.FTemplateNumber = ? and dispense.FTemplateType = ? and formula.fisFreezed = 0");
        if (isSupportOtherDS.booleanValue()) {
            sql.append(" and formula.FID not in (");
            sql.append(" select FID from T_CSL_CheckFormula \n");
            sql.append(" where FLFormula like '%");
            sql.append(rptInfo.getDataCollectNumber().equals("BUDGETDATA") ? "ACTUALDATA" : "BUDGETDATA").append("%'");
            sql.append(" and FRFormula like '%");
            sql.append(rptInfo.getDataCollectNumber().equals("BUDGETDATA") ? "ACTUALDATA" : "BUDGETDATA").append("%')");
        } else {
            sql.append(" and formula.FID not in (");
            sql.append(" select FID from T_CSL_CheckFormula \n");
            sql.append(" where FLFormula like '%");
            sql.append("BUDGETDATA").append("%'");
            sql.append(" and FRFormula like '%");
            sql.append("BUDGETDATA").append("%')");
        }
        ArrayList<Object> param = new ArrayList<Object>();
        param.add(rptInfo.getTemplate().getNumber());
        int tmpType = rptInfo.getTemplate().getTemplateType().getValue();
        if (tmpType == 2) {
            tmpType = 6;
        } else if (tmpType == 12) {
            tmpType = 10;
        } else if (tmpType == 16) {
            tmpType = 15;
        }
        param.add(new Integer(tmpType));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        BtwTableArticulationInfo articulationInfo = null;
        RPTItemCheckFormulaInfo checkFormulaInfo = null;
        ArrayList<BtwTableArticulationInfo> articulationList = new ArrayList<BtwTableArticulationInfo>();
        try {
            while (rowSet.next()) {
                checkFormulaInfo = new RPTItemCheckFormulaInfo();
                checkFormulaInfo.setId(BOSUuid.read((String)rowSet.getString("FID")));
                checkFormulaInfo.setNumber(rowSet.getString("FNumber"));
                checkFormulaInfo.setName(rowSet.getString("FName"));
                checkFormulaInfo.setIfClause(rowSet.getString("FIfClause"));
                checkFormulaInfo.setLFormula(rowSet.getString("FLFormula"));
                checkFormulaInfo.setOperateSymbol(OperateSymbolEnum.getEnum(rowSet.getInt("FOperateSymbol")));
                checkFormulaInfo.setRFormula(rowSet.getString("FRFormula"));
                checkFormulaInfo.setRange(rowSet.getBigDecimal("FRange"));
                checkFormulaInfo.setCheckResult(FormulaCheckResultTypeEnum.getEnum(rowSet.getInt("FCheckResult")));
                checkFormulaInfo.setPrompt(rowSet.getString("FPrompt"));
                articulationInfo = new BtwTableArticulationInfo(checkFormulaInfo);
                articulationList.add(articulationInfo);
            }
        }
        catch (SQLException ex) {
            throw new SQLDataException(ex);
        }
        return articulationList;
    }

    @Override
    public ArticulationInfo newArticulationInfoInstance(ArticulationInfo articulationInfo, OrgTreeInfo orgTreeInfo) {
        return new BtwTableArticulationInfo(((BtwTableArticulationInfo)articulationInfo).getCheckFormulaInfo(), orgTreeInfo);
    }

    @Override
    public void fillFormulaParameter(Context ctx, ArticulationInfo articulationInfo, ParameterContext parameterContext) {
        BtwTableArticulationInfo btwTableArticulationInfo = (BtwTableArticulationInfo)articulationInfo;
        Expression lExpression = this.processFormulaExpression(ctx, btwTableArticulationInfo.getlExpression(), parameterContext);
        Expression rExpression = this.processFormulaExpression(ctx, btwTableArticulationInfo.getrExpression(), parameterContext);
        btwTableArticulationInfo.setlExpression(lExpression);
        btwTableArticulationInfo.setrExpression(rExpression);
    }

    @Override
    public void fillFormulaIntoCalculateBook(Context ctx, Sheet calculateSheet, int row, ArticulationInfo articulationInfo, CslReportInfo cslReportInfo, OrgTreeInfo orgTreeInfo) throws EASBizException {
        BtwTableArticulationInfo btwTableArticulationInfo = (BtwTableArticulationInfo)articulationInfo;
        calculateSheet.getRange(row, 0).setValue(new Variant((Object)btwTableArticulationInfo.getCheckFormulaInfo().getId().toString()));
        String lformula = btwTableArticulationInfo.getlExpression().toString();
        if (this.isFormula(lformula)) {
            this.checkFormulaAvailability(ctx, calculateSheet, btwTableArticulationInfo, lformula);
            calculateSheet.getRange(row, 1).setFormula("=" + lformula);
        } else {
            calculateSheet.getRange(row, 1).setValue(new Variant((Object)lformula));
        }
        String rformula = btwTableArticulationInfo.getrExpression().toString();
        if (this.isFormula(rformula)) {
            this.checkFormulaAvailability(ctx, calculateSheet, btwTableArticulationInfo, rformula);
            calculateSheet.getRange(row, 2).setFormula("=" + rformula);
        } else {
            calculateSheet.getRange(row, 2).setValue(new Variant((Object)rformula));
        }
        calculateSheet.getRange(row, 3).setValue(new Variant((Object)btwTableArticulationInfo.getCheckFormulaInfo().getOperateSymbol()));
        calculateSheet.getRange(row, 4).setValue(new Variant((Object)btwTableArticulationInfo.getCheckFormulaInfo().getRange()));
        calculateSheet.getRange(row, 6).setValue(new Variant((Object)orgTreeInfo));
        calculateSheet.getRange(row, 5).setValue(new Variant((Object)cslReportInfo));
        calculateSheet.getRange(row, 7).setValue(new Variant((Object)btwTableArticulationInfo));
    }

    @Override
    public void compareCalculateValue(Map reportArticulationResult, Sheet calculateSheet, int row) throws EASBizException {
        ArticulationInfo articulationInfo = (ArticulationInfo)calculateSheet.getRange(row, 7).getValue().getValue();
        BtwTableArticulationInfo btwTableArticulationInfo = (BtwTableArticulationInfo)articulationInfo;
        Variant objLValue = calculateSheet.getRange(row, 1).getValue();
        Object lValue = this.getCalculateValue(articulationInfo, objLValue, btwTableArticulationInfo.getlExpression().toString());
        btwTableArticulationInfo.setlValue(lValue);
        Variant objRValue = calculateSheet.getRange(row, 2).getValue();
        Object rValue = this.getCalculateValue(articulationInfo, objRValue, btwTableArticulationInfo.getrExpression().toString());
        btwTableArticulationInfo.setrValue(rValue);
        BigDecimal range = btwTableArticulationInfo.getRange();
        OperateSymbolEnum operateSymbol = btwTableArticulationInfo.getCheckFormulaInfo().getOperateSymbol();
        CslReportInfo report = (CslReportInfo)calculateSheet.getRange(row, 5).getValue().getValue();
        ArticulationCheckResult articulationCheckResult = (ArticulationCheckResult)reportArticulationResult.get(report.getId().toString());
        if (!this.isComparePass(lValue, rValue, operateSymbol, range)) {
            articulationInfo.setCheckResultCode(258);
            articulationCheckResult.addErrorArticulation(btwTableArticulationInfo);
            this.setArticulationCheckResult(btwTableArticulationInfo, articulationCheckResult);
        } else {
            articulationInfo.setCheckResultCode(257);
            if (articulationCheckResult.isDispenseArticulation()) {
                articulationCheckResult.setPassArticulationCheckResultCode();
            }
        }
    }

    private void setArticulationCheckResult(BtwTableArticulationInfo btwTableArticulationInfo, ArticulationCheckResult articulationCheckResult) {
        int checkResultType = btwTableArticulationInfo.getCheckFormulaInfo().getCheckResult().getValue();
        if (!articulationCheckResult.isDispenseArticulation()) {
            return;
        }
        if (checkResultType == 1) {
            articulationCheckResult.setCheckResultCode(3);
        } else if (checkResultType == 2) {
            articulationCheckResult.setPassArticulationCheckResultCode();
        }
    }
}

