/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.articulation.batchquery;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.Formula;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.ItemFormulaInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.batchquery.DItemLocationBatchQuery;
import com.kingdee.eas.fi.gr.cslrpt.articulation.batchquery.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.articulation.batchquery.ItemFormulaInfoSQLProcessor;
import com.kingdee.eas.fi.gr.cslrpt.articulation.batchquery.ItemFormulaInfoSortState;
import com.kingdee.eas.fi.gr.cslrpt.util.ParameterContext;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.BatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterProcessor;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.ICombineHandler;
import com.kingdee.eas.fi.rpt.batch.ICombineRowSetHandler;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.RowSetCombineHandler;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableJdbcTemplate;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ItemFormulaInfoBatchQuery {
    private static Logger logger = Logger.getLogger(ItemFormulaInfoBatchQuery.class);
    private BatchHelper batchHelper;
    private BatchSQLSorterRegister itemFormulaInfosortRegister;
    private BatchSQLSorterRegister ditemLocationsortRegister;
    private ParameterContext parameterContext;

    public ItemFormulaInfoBatchQuery(Context ctx) {
        this(ctx, null);
    }

    public ItemFormulaInfoBatchQuery(Context ctx, ParameterContext parameterContext) {
        this.parameterContext = parameterContext;
        this.batchHelper = new BatchHelper(ctx);
        this.initSortRegister();
    }

    public void setParameterContext(ParameterContext parameterContext) {
        this.parameterContext = parameterContext;
    }

    private void registerFormula(ItemFormula itemFormula) {
        this.itemFormulaInfosortRegister.register((IFormulaCalculator)itemFormula);
    }

    private List getOrgBoundHistoryList(String number) throws BOSException {
        StringBuffer kql = new StringBuffer();
        kql.append(" select FID, FNumber, FStartDate, FEndDate from T_ORG_Tree \n");
        kql.append(" where FNumber = ? and FStatus in (1, 2) order by FstartDate desc, FendDate desc");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(number);
        IRowSet rowSet = DbUtil.executeQuery((Context)this.batchHelper.getServerContext(), (String)kql.toString(), (Object[])paramList.toArray());
        ArrayList<OrgTreeInfo> orgBoundHistoryList = new ArrayList<OrgTreeInfo>();
        try {
            while (rowSet.next()) {
                OrgTreeInfo treeInfo = new OrgTreeInfo();
                treeInfo.setId(BOSUuid.read((String)rowSet.getString("FID")));
                treeInfo.setNumber(rowSet.getString("FNumber"));
                treeInfo.setStartDate(rowSet.getTimestamp("FStartDate"));
                treeInfo.setEndDate(rowSet.getTimestamp("FEndDate"));
                orgBoundHistoryList.add(treeInfo);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return orgBoundHistoryList;
    }

    private void reviseOrgBound(List orgBoundHistoryList, PeriodCollection periodCollection, ItemFormula itemFormula, CslReportInfo reportInfo, OrgTreeInfo orgTreeInfo, boolean isMergeByFiscalPeriod) throws BOSException {
        int year = itemFormula.year;
        int period = itemFormula.period;
        RptPeriodTypeEnum periodType = reportInfo.getPeriodType();
        Date periodDate = FiscalPeriodHelper.getPeriodLastDate(periodCollection, year, period, periodType, isMergeByFiscalPeriod);
        for (OrgTreeInfo orgTreeInfo1 : orgBoundHistoryList) {
            Timestamp orgTreeStartDate = orgTreeInfo1.getStartDate();
            if (orgTreeStartDate.compareTo(new Timestamp(periodDate.getTime())) > 0) continue;
            itemFormula.orgBoundId = orgTreeInfo1.getId().toString();
            break;
        }
    }

    public void init(List formulaList) throws EASBizException, BOSException {
        CslReportInfo reportInfo = (CslReportInfo)this.parameterContext.getAttribute("cslReportInfo");
        Boolean isMergeByFiscalPeriod = (Boolean)this.parameterContext.getAttribute("isMergeByFiscalPeriod");
        Boolean isSupport13Period = (Boolean)this.parameterContext.getAttribute("isSupport13Period");
        PeriodCollection periodCollection = (PeriodCollection)this.parameterContext.getAttribute("periodCollection");
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.parameterContext.getAttribute("orgTreeInfo");
        List orgBoundHistoryList = this.getOrgBoundHistoryList(orgTreeInfo.getNumber());
        ArrayList entry = new ArrayList();
        for (Formula formula : formulaList) {
            ItemFormula itemFormula = new ItemFormula(formula, this.batchHelper);
            itemFormula.initFormulaParameter(reportInfo);
            itemFormula.revisePeriod(periodCollection, reportInfo, isSupport13Period, isMergeByFiscalPeriod);
            this.reviseOrgBound(orgBoundHistoryList, periodCollection, itemFormula, reportInfo, orgTreeInfo, isMergeByFiscalPeriod);
            this.registerFormula(itemFormula);
            HashMap<String, Object> entryMap = new HashMap<String, Object>();
            entryMap.put("itemNumber", itemFormula.itemNumber);
            entryMap.put("dataElement", itemFormula.dataElement);
            entry.add(entryMap);
        }
        ParamTempTblService srv = this.getTempTblService(this.batchHelper.getServerContext(), this.getParams(entry));
        String tblName = srv.getTmpTableName();
        TempTableJdbcTemplate tableJdbcTemplate = new TempTableJdbcTemplate(this.batchHelper.getServerContext());
        this.parameterContext.setAttribute("tempTblName", tblName);
        this.parameterContext.setAttribute("tableJdbcTemplate", tableJdbcTemplate);
    }

    private Set getParams(List entry) {
        HashSet result = new HashSet();
        int size = entry.size();
        for (int i = 0; i < size; ++i) {
            ArrayList<String> list = new ArrayList<String>();
            Map entryMap = (Map)entry.get(i);
            String itemNumber = String.valueOf(entryMap.get("itemNumber"));
            list.add(itemNumber);
            String dataElement = String.valueOf(entryMap.get("dataElement"));
            list.add(dataElement);
            result.add(list);
        }
        return result;
    }

    private ParamTempTblService getTempTblService(Context ctx, Collection ids) {
        TableInfo table = new TableInfo("t_temp_itemFormula");
        table.addColumn(new ColumnInfo("FItemNumber", "varchar(80)"));
        table.addColumn(new ColumnInfo("FDataElement", "int"));
        ParamTempTblService service = ParamTempTblService.getInstance((Context)ctx, (TableInfo)table, (Collection)ids, null);
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeItemFormulaInfoBatchQuery() throws BOSException {
        RowSetCombineHandler combineHandler = new RowSetCombineHandler(new ICombineRowSetHandler(){

            public void processRowSet(IRowSet rs, IFormulaCalculator formula, IBatchSQLProcessor sqlBuilder) throws SQLException {
                ItemFormulaInfoSQLProcessor itemFormulaInfoSQLProcessor = (ItemFormulaInfoSQLProcessor)sqlBuilder;
                ItemFormulaInfoSortState itemFormulaInfoSortState = itemFormulaInfoSQLProcessor.getItemFormulaInfoSortState();
                ItemFormula itemFormula = (ItemFormula)formula;
                Formula formula1 = itemFormula.formula;
                ItemFormulaInfo itemFormulaInfo = new ItemFormulaInfo();
                itemFormulaInfo.setTemplateId(rs.getString("templateId"));
                itemFormulaInfo.setReportId(rs.getString("reportId"));
                itemFormulaInfo.setItemNumber(rs.getString("itemNumber"));
                if (!itemFormulaInfoSortState.isKeyNumberEmpty) {
                    itemFormulaInfo.setKeyNumber(rs.getString("keyNumber"));
                }
                itemFormulaInfo.setDataElement(rs.getInt("dataElement"));
                itemFormulaInfo.setValueType(rs.getInt("valueType"));
                itemFormulaInfo.setSheetId(rs.getString("sheetId"));
                itemFormulaInfo.setRow(rs.getInt("cellRow"));
                itemFormulaInfo.setCol(rs.getInt("cellCol"));
                Map extendedProperty = formula1.getExtendedProperty();
                extendedProperty.put("itemFormulaInfo", itemFormulaInfo);
            }
        });
        Object report = this.parameterContext.getAttribute("cslReportInfo");
        if (report instanceof CslReportInfo && ((CslReportInfo)report).getExtendedProperty("FROM_AUTOITEM") != null) {
            List sortStates = this.itemFormulaInfosortRegister.getSortStates();
            List formulas = null;
            for (IBatchSQLSortState sortState : sortStates) {
                formulas = sortState.getFormulaList();
                Iterator iterator = formulas.iterator();
                while (iterator.hasNext()) {
                    ItemFormula formula;
                    ItemFormula itemFormula = formula = (ItemFormula)((Object)iterator.next());
                    Formula formula1 = itemFormula.formula;
                    ItemFormulaInfo itemFormulaInfo = new ItemFormulaInfo();
                    itemFormulaInfo.setTemplateId(null);
                    itemFormulaInfo.setReportId(null);
                    itemFormulaInfo.setItemNumber(itemFormula.itemNumber);
                    itemFormulaInfo.setDataElement(itemFormula.dataElement);
                    itemFormulaInfo.setValueType(itemFormula.valueType);
                    itemFormulaInfo.setSheetId(null);
                    itemFormulaInfo.setRow(-1);
                    itemFormulaInfo.setCol(-1);
                    Map extendedProperty = formula1.getExtendedProperty();
                    extendedProperty.put("itemFormulaInfo", itemFormulaInfo);
                }
            }
        }
        try {
            this.batchHelper.batchCalculateBigDecimalBySorter((IBatchSQLSorterProcessor)new ItemFormulaInfoSQLProcessor(this.parameterContext), (IBatchSQLSorterRegister)this.itemFormulaInfosortRegister, (ICombineHandler)combineHandler);
            DItemLocationBatchQuery ditemLocationBatchQuery = new DItemLocationBatchQuery(this.batchHelper.getServerContext(), this.batchHelper, this.parameterContext);
            this.registerDItemLocationFormula(ditemLocationBatchQuery);
            ditemLocationBatchQuery.executeDItemLocationBatchQuery();
        }
        finally {
            if (!DebugLogger.isDebug) {
                String tableName = (String)this.parameterContext.getAttribute("tempTblName");
                TempTableJdbcTemplate service = (TempTableJdbcTemplate)this.parameterContext.getAttribute("tableJdbcTemplate");
                service.releaseTempTable(tableName);
            }
        }
    }

    private void registerDItemLocationFormula(DItemLocationBatchQuery ditemLocationBatchQuery) {
        for (IBatchSQLSortState sortState : this.itemFormulaInfosortRegister.getSortStates()) {
            for (ItemFormula itemFormula : sortState.getFormulaList()) {
                ditemLocationBatchQuery.registerFormula(itemFormula);
            }
        }
    }

    private void initSortRegister() {
        this.itemFormulaInfosortRegister = new BatchSQLSorterRegister(new HashMap());
        this.itemFormulaInfosortRegister.setSortState((IBatchSQLSortState)new ItemFormulaInfoSortState());
    }
}

