/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.articulation.report;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.OperateSymbolEnum;
import com.kingdee.eas.fi.gr.cslrpt.articulation.ArticulationCheckResult;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.ItemDiffArticulationInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.report.IMessageDisplay;
import com.kingdee.eas.fi.gr.cslrpt.articulation.report.MessageDisplayUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.ParameterContext;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ItemDiffCheckReportMsg
implements IMessageDisplay {
    private Map itemFormulaPointMap = new HashMap(8);
    CslReportInfo rptInfo;
    Book book = null;

    @Override
    public String getReportMessage(ParameterContext parameterContext) {
        ArticulationCheckResult articulationCheckResult = (ArticulationCheckResult)parameterContext.getAttribute("reportCheckFormulaResult");
        Locale locale = parameterContext.getLocale();
        Context ctx = parameterContext.getContext();
        return this.getReportMessage(articulationCheckResult, locale, ctx);
    }

    public String getReportMessage(ArticulationCheckResult articulationCheckResult, Locale locale, Context ctx) {
        this.rptInfo = articulationCheckResult.getReportInfo();
        this.book = null;
        StringBuffer resultRpt = new StringBuffer();
        Map orgTreeArticulationMap = articulationCheckResult.getOrgTreeArticulationMap();
        StringBuffer articulationMessage = new StringBuffer();
        for (Map.Entry entry : orgTreeArticulationMap.entrySet()) {
            ItemDiffArticulationInfo articulationInfo;
            OrgTreeInfo orgTreeInfo;
            String orgTreeArticulationMessage;
            List checkFormulaList = (List)entry.getValue();
            if (checkFormulaList.isEmpty() || StringUtils.isEmpty((String)(orgTreeArticulationMessage = this.getArticulationMessage(checkFormulaList, orgTreeInfo = (articulationInfo = (ItemDiffArticulationInfo)checkFormulaList.iterator().next()).getOrgTreeInfo(), locale, ctx)))) continue;
            String temp = this.getString("CHECK_MESSAGE_13", locale);
            articulationMessage.append(temp).append(orgTreeInfo.getName()).append("<br>");
            articulationMessage.append(orgTreeArticulationMessage);
        }
        if (!StringUtils.isEmpty((String)articulationMessage.toString())) {
            String headMessage = this.getReportHeadMessage(this.rptInfo, locale, ctx);
            resultRpt.append(headMessage).append(articulationMessage);
        }
        this.itemFormulaPointMap.clear();
        return resultRpt.toString();
    }

    private String getReportHeadMessage(CslReportInfo rptInfo, Locale locale, Context ctx) {
        StringBuffer resultRpt = new StringBuffer();
        String tempStr = null;
        this.joinCheckTypeAndDate(locale, resultRpt, ctx);
        resultRpt.append("====================================================================<br>");
        this.joinReportType(rptInfo, locale, resultRpt);
        this.joinReportName(rptInfo, locale, resultRpt);
        tempStr = this.getString("CHECK_MESSAGE_46", locale);
        if (rptInfo.getCompany() != null && rptInfo.getSourceType() != RptSrcTypeEnum.MULTIDYNAMICSUMREPORT && RptSrcTypeEnum.CONSOLIDATION != rptInfo.getSourceType() && RptSrcTypeEnum.SUM != rptInfo.getSourceType() && RptSrcTypeEnum.DYNAMICCSLREPORT != rptInfo.getSourceType()) {
            resultRpt.append(tempStr).append(rptInfo.getCompany().getName()).append("<br>");
        } else {
            resultRpt.append(tempStr).append(rptInfo.getOrgUnit().getName()).append("<br>");
        }
        return resultRpt.toString();
    }

    protected void joinReportName(CslReportInfo rptInfo, Locale locale, StringBuffer resultRpt) {
        String tempStr = this.getString("CHECK_MESSAGE_11", locale);
        resultRpt.append(tempStr).append(rptInfo.getName()).append("<br>");
    }

    protected void joinReportType(CslReportInfo rptInfo, Locale locale, StringBuffer resultRpt) {
        String tempStr = null;
        if (rptInfo.getSourceType().getValue() == 3) {
            tempStr = this.getString("CHECK_MESSAGE_8", locale);
        } else if (rptInfo.getSourceType().getValue() == 2) {
            tempStr = this.getString("CHECK_MESSAGE_9", locale);
        }
        tempStr = rptInfo.getSourceType().getValue() == 10 ? RptSrcTypeEnum.DYNAMICNORMALREPORT.getAlias() : (rptInfo.getSourceType().getValue() == 11 ? RptSrcTypeEnum.DYNAMICSUMREPORT.getAlias() : (rptInfo.getSourceType().getValue() == 12 ? RptSrcTypeEnum.DYNAMICCSLREPORT.getAlias() : (rptInfo.getSourceType().getValue() == 13 ? RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT.getAlias() : (rptInfo.getSourceType().getValue() == 14 ? RptSrcTypeEnum.MULTIDYNAMICSUMREPORT.getAlias() : this.getString("CHECK_MESSAGE_10", locale)))));
        resultRpt.append(tempStr).append("<br>");
    }

    protected void joinCheckTypeAndDate(Locale locale, StringBuffer resultRpt, Context ctx) {
        String tempStr = this.getString("CHECK_MESSAGE_7", locale);
        resultRpt.append(tempStr).append("<br>");
        tempStr = this.getString("CHECK_MESSAGE_42", locale);
        resultRpt.append(tempStr);
        SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd");
        DateFormat format = CslRptUtil.getNationalDateFormat(ctx);
        if (format != null) {
            resultRpt.append(format.format(new Date()).toString()).append("<br>");
        } else {
            resultRpt.append(format1.format(new Date()).toString()).append("<br>");
        }
    }

    private String getArticulationMessage(List checkFormulaList, OrgTreeInfo orgTreeInfo, Locale locale, Context ctx) {
        StringBuffer resultRpt = new StringBuffer();
        String tempStr = null;
        for (ItemDiffArticulationInfo articulationInfo1 : checkFormulaList) {
            boolean isRequestAnnotation;
            if (!articulationInfo1.isAvailable() || articulationInfo1.isPassArticulation()) continue;
            boolean isPercent = articulationInfo1.getItemDiffIndexInfo().getDiffIndexType().getValue() == 2;
            BigDecimal range = articulationInfo1.getRange();
            DecimalFormat f1 = new DecimalFormat("#,##0.00");
            NumberFormat f = CslRptUtil.getNationalDataFormat(ctx);
            String rangeStr = "0.00";
            if (range != null) {
                if (isPercent && range != null && range.compareTo(new BigDecimal("0")) != 0) {
                    range = range.multiply(new BigDecimal("100"));
                }
                rangeStr = f == null ? f1.format(range) : f.format(range);
            }
            tempStr = this.getString("CHECK_MESSAGE_15", locale);
            resultRpt.append("<br>").append(tempStr).append(articulationInfo1.getName());
            tempStr = this.getString("CHECK_MESSAGE_16", locale);
            resultRpt.append("<br>").append(tempStr).append(articulationInfo1.getNumber());
            tempStr = this.getString("CHECK_MESSAGE_27", locale);
            if (!articulationInfo1.getDetailFormulaMap().isEmpty() && this.book == null) {
                this.book = MessageDisplayUtil.getBook(this.rptInfo);
            }
            String srcLFormula = articulationInfo1.getItemDiffIndexInfo().getFormula().toUpperCase();
            String linkInfoL = MessageDisplayUtil.setItemFormulaInformation(srcLFormula, articulationInfo1.getDetailFormulaMap(), this.rptInfo, this.book, this.itemFormulaPointMap);
            resultRpt.append("<br>").append(tempStr).append(linkInfoL);
            Object value = articulationInfo1.getValue();
            if (value instanceof Throwable) {
                resultRpt.append("=").append(((Throwable)value).getMessage()).append("<br>");
            } else {
                resultRpt.append("=").append(value).append("<br>");
            }
            tempStr = this.getString("CHECK_MESSAGE_29", locale);
            BigDecimal diffStandValue = articulationInfo1.getDiffStandValue();
            resultRpt.append(tempStr + diffStandValue);
            if (isPercent) {
                resultRpt.append("%");
            }
            tempStr = this.getString("CHECK_MESSAGE_30", locale);
            resultRpt.append("<br>" + tempStr);
            OperateSymbolEnum operateSymbol = articulationInfo1.getItemDiffIndexInfo().getOperateSymbol();
            resultRpt.append(MessageDisplayUtil.getOperateSymbolStr(operateSymbol, locale));
            tempStr = this.getString("CHECK_MESSAGE_31", locale);
            resultRpt.append(tempStr + "<br>");
            tempStr = this.getString("CHECK_MESSAGE_44", locale);
            resultRpt.append(tempStr + rangeStr);
            if (isPercent) {
                resultRpt.append("%");
            }
            resultRpt.append("<br>");
            String prompt = articulationInfo1.getItemDiffIndexInfo().getPrompt();
            if (!StringUtils.isEmpty((String)prompt)) {
                tempStr = this.getString("CHECK_MESSAGE_32", locale);
                resultRpt.append(tempStr + prompt.replaceAll("<", "&lt;").replaceAll(">", "&gt;") + "<br>");
            }
            if (!(isRequestAnnotation = articulationInfo1.getItemDiffIndexInfo().isIsRequestLabel())) {
                tempStr = this.getString("CHECK_MESSAGE_33", locale);
                resultRpt.append(tempStr + "(***)\n\n").append("<br>");
                tempStr = this.getString("CHECK_MESSAGE_34", locale);
                resultRpt.append(tempStr + orgTreeInfo.getName());
                tempStr = this.getString("CHECK_MESSAGE_28", locale);
                resultRpt.append(tempStr + "(***)\n\n").append("<br><br>");
                continue;
            }
            String postil = MessageDisplayUtil.getItemFormulaCellPostil(articulationInfo1.getDetailFormulaMap(), locale);
            if (!StringUtils.isEmpty((String)postil)) {
                tempStr = this.getString("CHECK_MESSAGE_35", locale);
                resultRpt.append(tempStr + "\n");
                resultRpt.append(postil).append("(***)\n\n").append("<br>");
                continue;
            }
            tempStr = this.getString("CHECK_MESSAGE_36", locale);
            resultRpt.append(tempStr + "(***)").append("<br>");
            tempStr = this.getString("CHECK_MESSAGE_37", locale);
            resultRpt.append(tempStr + orgTreeInfo.getName());
            tempStr = this.getString("CHECK_MESSAGE_51", locale);
            resultRpt.append(tempStr + "(***)\n\n").append("<br><br>");
        }
        return resultRpt.toString();
    }

    private String getString(String resName, Locale locale) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CheckFormula", (String)resName, (Locale)locale);
    }
}

