/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.assist;

import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.MultiOperationExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.ParenthesisExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Area3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.AreaExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.BoolExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.EmptyArgExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.IntExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.NameExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.NumberExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Ref3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.ReferenceExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.ptg.AddPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.Area3DPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.AreaPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.BoolPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.ConcatPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.DividePtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.EmptyArgPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.EqualPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.FuncVarPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.GreaterEqualPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.GreaterThanPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.IntPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.LessEqualPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.LessThanPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.MultiplyPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.NamePtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.NotEqualPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.NumberPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.OperationPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.ParenthesisPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.PercentPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.PowerPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.Ref3DPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.ReferencePtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.StringPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.SubtractPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.UnaryMinusPtg;
import com.kingdee.eas.fi.rpt.excelformula.ptg.UnaryPlusPtg;
import java.util.List;
import java.util.Stack;

public class ExcelFormulaParserExt {
    private final List tokens;

    public ExcelFormulaParserExt(List tokens) {
        this.tokens = tokens;
    }

    public Expression parse() throws Exception {
        if (this.tokens == null || 0 == this.tokens.size()) {
            return null;
        }
        Stack<Object> stack = new Stack<Object>();
        int numPtgs = this.tokens.size();
        for (int i = 0; i < numPtgs; ++i) {
            AreaPtg p;
            IntExpr e;
            Object object = this.tokens.get(i);
            if (object instanceof OperationPtg) {
                Expression expr;
                if (object instanceof AddPtg) {
                    this.buildBinaryOp(stack, 7);
                    continue;
                }
                if (object instanceof SubtractPtg) {
                    this.buildBinaryOp(stack, 8);
                    continue;
                }
                if (object instanceof MultiplyPtg) {
                    this.buildBinaryOp(stack, 5);
                    continue;
                }
                if (object instanceof DividePtg) {
                    this.buildBinaryOp(stack, 6);
                    continue;
                }
                if (object instanceof PowerPtg) {
                    this.buildBinaryOp(stack, 4);
                    continue;
                }
                if (object instanceof LessEqualPtg) {
                    this.buildBinaryOp(stack, 13);
                    continue;
                }
                if (object instanceof EqualPtg) {
                    this.buildBinaryOp(stack, 10);
                    continue;
                }
                if (object instanceof LessThanPtg) {
                    this.buildBinaryOp(stack, 14);
                    continue;
                }
                if (object instanceof NotEqualPtg) {
                    this.buildBinaryOp(stack, 15);
                    continue;
                }
                if (object instanceof GreaterEqualPtg) {
                    this.buildBinaryOp(stack, 11);
                    continue;
                }
                if (object instanceof GreaterThanPtg) {
                    this.buildBinaryOp(stack, 12);
                    continue;
                }
                if (object instanceof ConcatPtg) {
                    this.buildBinaryOp(stack, 9);
                    continue;
                }
                if (object instanceof FuncVarPtg) {
                    FunctionExpr bop = new FunctionExpr(((FuncVarPtg)object).getName());
                    int numOperands = ((FuncVarPtg)object).getNumberOfOperands();
                    for (int j = 0; j < numOperands; ++j) {
                        bop.parameters.add(0, stack.pop());
                    }
                    stack.push(bop);
                    continue;
                }
                if (object instanceof UnaryMinusPtg || object instanceof UnaryPlusPtg || object instanceof PercentPtg) {
                    expr = (Expression)stack.pop();
                    int type = 3;
                    if (object instanceof UnaryPlusPtg) {
                        type = 1;
                    } else if (object instanceof UnaryMinusPtg) {
                        type = 2;
                    } else if (object instanceof PercentPtg) {
                        type = 3;
                    }
                    UnaryOperationExpr e2 = new UnaryOperationExpr(type);
                    e2.operand = expr;
                    stack.push(e2);
                    continue;
                }
                if (!(object instanceof ParenthesisPtg)) continue;
                expr = (Expression)stack.pop();
                ParenthesisExpr parenthesis = new ParenthesisExpr(expr);
                stack.push((Object)parenthesis);
                continue;
            }
            if (object instanceof IntPtg) {
                e = new IntExpr();
                e.value = ((IntPtg)object).getValue();
                stack.push(e);
                continue;
            }
            if (object instanceof NumberPtg) {
                e = new NumberExpr(((NumberPtg)object).getValue());
                stack.push(e);
                continue;
            }
            if (object instanceof StringPtg) {
                e = new StringExpr(((StringPtg)object).getValue());
                stack.push(e);
                continue;
            }
            if (object instanceof BoolPtg) {
                e = new BoolExpr(((BoolPtg)object).getValue());
                stack.push(e);
                continue;
            }
            if (object instanceof AreaPtg) {
                p = (AreaPtg)object;
                AreaExpr exp = new AreaExpr((int)p.getFirstRow(), (int)p.getFirstColumn(), (int)p.getLastRow(), (int)p.getLastColumn());
                exp.setFirstColRel(p.isFirstColRelative());
                exp.setLastColRel(p.isLastColRelative());
                exp.setFirstRowRel(p.isFirstRowRelative());
                exp.setLastRowRel(p.isLastRowRelative());
                stack.push(exp);
                continue;
            }
            if (object instanceof ReferencePtg) {
                p = (ReferencePtg)object;
                ReferenceExpr exp = new ReferenceExpr();
                exp.col = p.getColumn();
                exp.row = p.getRow();
                exp.setColRel(p.isColRelative());
                exp.setRowRel(p.isRowRelative());
                stack.push(exp);
                continue;
            }
            if (object instanceof Area3DPtg) {
                p = (Area3DPtg)object;
                Area3DExpr exp = new Area3DExpr();
                exp.sheetName = p.getSheetName();
                AreaExpr area = new AreaExpr((int)p.getFirstRow(), (int)p.getFirstColumn(), (int)p.getLastRow(), (int)p.getLastColumn());
                area.setFirstColRel(p.isFirstColRelative());
                area.setLastColRel(p.isLastColRelative());
                area.setFirstRowRel(p.isFirstRowRelative());
                area.setLastRowRel(p.isLastRowRelative());
                exp.area = area;
                stack.push(exp);
                continue;
            }
            if (object instanceof Ref3DPtg) {
                p = (Ref3DPtg)object;
                Ref3DExpr expr = new Ref3DExpr();
                expr.sheetName = p.getSheetName();
                ReferenceExpr ref = new ReferenceExpr();
                ref.row = p.getRow();
                ref.col = p.getColumn();
                ref.setColRel(p.isColRelative());
                ref.setRowRel(p.isRowRelative());
                expr.ref = ref;
                stack.push(expr);
                continue;
            }
            if (object instanceof NamePtg) {
                stack.push(new NameExpr(((NamePtg)object).getText()));
                continue;
            }
            if (!(object instanceof EmptyArgPtg)) continue;
            stack.push(new EmptyArgExpr());
        }
        return (Expression)stack.pop();
    }

    public void buildBinaryOp(Stack stack, int type) {
        Expression right = (Expression)stack.pop();
        Expression left = (Expression)stack.pop();
        if (left instanceof MultiOperationExpr) {
            MultiOperationExpr leftMulti = (MultiOperationExpr)left;
            leftMulti.push(type, right);
            stack.push(leftMulti);
            return;
        }
        if (left instanceof BinaryOperationExpr) {
            BinaryOperationExpr leftBOE = (BinaryOperationExpr)left;
            MultiOperationExpr multi = new MultiOperationExpr();
            multi.first(leftBOE.left);
            multi.push(leftBOE.operationType, leftBOE.right);
            if (right instanceof BinaryOperationExpr) {
                BinaryOperationExpr rightBOE = (BinaryOperationExpr)right;
                multi.push(type, rightBOE.left);
                multi.push(rightBOE.operationType, rightBOE.right);
            } else {
                multi.push(type, right);
            }
            stack.push(multi);
            return;
        }
        if (right instanceof BinaryOperationExpr) {
            BinaryOperationExpr rightBOE = (BinaryOperationExpr)right;
            MultiOperationExpr multi = new MultiOperationExpr();
            multi.first(left);
            multi.push(type, rightBOE.left);
            multi.push(rightBOE.operationType, rightBOE.right);
            stack.push(multi);
            return;
        }
        if (right instanceof MultiOperationExpr) {
            MultiOperationExpr rightMulti = (MultiOperationExpr)right;
            MultiOperationExpr newMulti = new MultiOperationExpr(left, type, rightMulti);
            stack.push(newMulti);
            return;
        }
        BinaryOperationExpr bop = new BinaryOperationExpr(type);
        bop.right = right;
        bop.left = left;
        stack.push(bop);
    }
}

