/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.CircleBookCell;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.ICircleBookCellHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.IBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.IFindBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.DynaBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.EliminationBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.FindDynaBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.FindEliminationBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.FindNormalBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.IReportEntity;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.NormalBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FindBasePoint {
    private static final ILog log = LogFactory.getLog("AUTOITEM", FindBasePoint.class);
    private static final IFindBasePoint NORMAL_BASEPOINT = new FindNormalBasePoint();
    private static final IFindBasePoint ELIMINATION_BASEPOINT = new FindEliminationBasePoint();
    private static final IFindBasePoint DYNA_BASEPOINT = new FindDynaBasePoint();
    protected IReportEntity template;
    protected Set<Class<?>> scanBasePointTypes = new HashSet(3);

    public FindBasePoint(IReportEntity template) {
        this.template = template;
        this.scanBasePointTypes.add(NormalBasePoint.class);
        this.scanBasePointTypes.add(EliminationBasePoint.class);
        this.scanBasePointTypes.add(DynaBasePoint.class);
    }

    public List<IBasePoint> scan() {
        Book book = null;
        try {
            book = this.template.getBook();
            if (book == null) {
                return new ArrayList<IBasePoint>(0);
            }
        }
        catch (Exception e) {
            log.error("", ILog.EMPTY_PARAMS, e);
            return new ArrayList<IBasePoint>(0);
        }
        final ArrayList<IBasePoint> basePoints = new ArrayList<IBasePoint>(8);
        new CircleBookCell().circle(book, new ICircleBookCellHandler(){

            @Override
            public int cell(Book book, Sheet sheet, Cell cell) {
                IBasePoint basePoint;
                if (FindBasePoint.this.scanBasePointTypes.contains(NormalBasePoint.class) && NORMAL_BASEPOINT.isBelongBasePoint(FindBasePoint.this.template, cell)) {
                    if (!NORMAL_BASEPOINT.isBelongSheet(FindBasePoint.this.template, cell) && FindBasePoint.this.scanBasePointTypes.size() == 1) {
                        return 1;
                    }
                    if (NORMAL_BASEPOINT.isBelongBasePoint(FindBasePoint.this.template, cell) && (basePoint = NORMAL_BASEPOINT.parse(FindBasePoint.this.template, cell)) != null) {
                        basePoints.add(basePoint);
                        return 1;
                    }
                }
                if (FindBasePoint.this.scanBasePointTypes.contains(EliminationBasePoint.class)) {
                    if (!ELIMINATION_BASEPOINT.isBelongSheet(FindBasePoint.this.template, cell) && FindBasePoint.this.scanBasePointTypes.size() == 1) {
                        return 1;
                    }
                    if (ELIMINATION_BASEPOINT.isBelongBasePoint(FindBasePoint.this.template, cell) && (basePoint = ELIMINATION_BASEPOINT.parse(FindBasePoint.this.template, cell)) != null) {
                        basePoints.add(basePoint);
                        return 1;
                    }
                }
                if (FindBasePoint.this.scanBasePointTypes.contains(DynaBasePoint.class) && DYNA_BASEPOINT.isBelongBasePoint(FindBasePoint.this.template, cell) && (basePoint = DYNA_BASEPOINT.parse(FindBasePoint.this.template, cell)) != null) {
                    basePoints.add(basePoint);
                    return 2;
                }
                return 0;
            }
        });
        return basePoints;
    }

    public List<IBasePoint> scan(Sheet sheet) {
        Book book = sheet.getBook();
        if (book == null) {
            return new ArrayList<IBasePoint>(0);
        }
        final ArrayList<IBasePoint> basePoints = new ArrayList<IBasePoint>(8);
        new CircleBookCell().circle(sheet, new int[]{0, 0}, new int[]{sheet.getMaxRowIndex(), sheet.getMaxColIndex()}, new ICircleBookCellHandler(){

            @Override
            public int cell(Book book, Sheet sheet, Cell cell) {
                IBasePoint basePoint;
                if (FindBasePoint.this.scanBasePointTypes.contains(NormalBasePoint.class) && NORMAL_BASEPOINT.isBelongBasePoint(FindBasePoint.this.template, cell)) {
                    if (!NORMAL_BASEPOINT.isBelongSheet(FindBasePoint.this.template, cell) && FindBasePoint.this.scanBasePointTypes.size() == 1) {
                        return 1;
                    }
                    if (NORMAL_BASEPOINT.isBelongBasePoint(FindBasePoint.this.template, cell) && (basePoint = NORMAL_BASEPOINT.parse(FindBasePoint.this.template, cell)) != null) {
                        basePoints.add(basePoint);
                        return 1;
                    }
                } else if (FindBasePoint.this.scanBasePointTypes.contains(EliminationBasePoint.class)) {
                    if (!ELIMINATION_BASEPOINT.isBelongSheet(FindBasePoint.this.template, cell) && FindBasePoint.this.scanBasePointTypes.size() == 1) {
                        return 1;
                    }
                    if (ELIMINATION_BASEPOINT.isBelongBasePoint(FindBasePoint.this.template, cell) && (basePoint = ELIMINATION_BASEPOINT.parse(FindBasePoint.this.template, cell)) != null) {
                        basePoints.add(basePoint);
                        return 1;
                    }
                }
                if (FindBasePoint.this.scanBasePointTypes.contains(DynaBasePoint.class) && DYNA_BASEPOINT.isBelongBasePoint(FindBasePoint.this.template, cell) && (basePoint = DYNA_BASEPOINT.parse(FindBasePoint.this.template, cell)) != null) {
                    basePoints.add(basePoint);
                    return 2;
                }
                return 0;
            }
        });
        return basePoints;
    }

    public void limitScanBasePointTypes(Class<?>[] types) {
        this.scanBasePointTypes = new HashSet(Arrays.asList(types));
    }
}

