/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.CheckCalcResult;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.FormulaCalcUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.ItemFormulaSaveUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.ParameterResults;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.AutoItemLog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QueryDataElement;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.AdaptItem;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.DynaGradeInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.AutoItemItemFormula;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FindItemFormulaSaveUnit {
    protected DBHandler dao;

    public FindItemFormulaSaveUnit(DBHandler dao) {
        this.dao = dao;
    }

    public Set<ItemFormulaSaveUnit> exec(FormulaCalcContextInfo formulaContextDefine, Uuid currentCalcFlag, Set<FormulaCalcUnit> calcUnits, String executeTaskId, AutoItemLog reportLog, ParameterResults paramResultsForKnown) throws BOSException, EASBizException {
        Map<String, Object> paramResults = paramResultsForKnown.getResults();
        HashSet<ItemFormulaSaveUnit> itemUnits = new HashSet<ItemFormulaSaveUnit>(calcUnits.size());
        ItemFormulaSaveUnit saveUnit = null;
        FormulaCalcContextInfo sourceType = formulaContextDefine;
        AdaptItem adaptItem = ActionFactory.get(AdaptItem.class);
        Map<String, Integer> dataElementStr2Number = new QueryDataElement(this.dao).exec();
        CheckCalcResult checkCalcResult = new CheckCalcResult(reportLog);
        for (FormulaCalcUnit calcUnit : calcUnits) {
            calcUnit.findResult(paramResults);
            if (calcUnit.isExceptionResult()) continue;
            if (!checkCalcResult.exec(calcUnit, true)) {
                calcUnit.setExceptionResult(true);
                continue;
            }
            if (!(calcUnit.getResult() instanceof BigDecimal) || BigDecimal.ZERO.compareTo((BigDecimal)calcUnit.getResult()) == 0) {
                // empty if block
            }
            AutoItemItemFormula item = new AutoItemItemFormula(calcUnit.getItemFormula(), dataElementStr2Number);
            adaptItem.exec(item, formulaContextDefine);
            saveUnit = new ItemFormulaSaveUnit(item, calcUnit.getResult(), calcUnit.getCalcContext().getCompany(), calcUnit.getCalcContext().getCurrency(), calcUnit.getCalcContext().getPeriodType());
            saveUnit.setSourceType(sourceType);
            if (calcUnit.getItemFormula().getExtendProperty(DynaGradeInfo.class) != null) {
                saveUnit.getItemInfo().setDynaGradeInfo((DynaGradeInfo)calcUnit.getItemFormula().getExtendProperty(DynaGradeInfo.class));
            }
            itemUnits.add(saveUnit);
        }
        return itemUnits;
    }
}

