/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz;

import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeCollection;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.IBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.IFindFormulaScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.FindDynaArfiFillClassificScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.FindDynaArficFillNormalScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.FindDynaBaseFillScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.FindEliminationScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.FindNormalScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import java.util.ArrayList;
import java.util.List;

public class FormulaSchemeParserLink {
    private static final ILog log = LogFactory.getLog("AUTOITEM", FormulaSchemeParserLink.class);
    protected List<IFindFormulaScheme> parsers = new ArrayList<IFindFormulaScheme>();
    private DBHandler dao;

    public FormulaSchemeParserLink(DBHandler dao) {
        this.dao = dao;
        this.initParser();
    }

    protected void initParser() {
        this.parsers.add(new FindNormalScheme(this.dao));
        this.parsers.add(new FindEliminationScheme(this.dao));
        this.parsers.add(new FindDynaBaseFillScheme(this.dao));
        this.parsers.add(new FindDynaArficFillNormalScheme(this.dao));
        this.parsers.add(new FindDynaArfiFillClassificScheme(this.dao));
    }

    public FormulaSchemeCollection parse(IBasePoint basePoint) {
        for (IFindFormulaScheme parser : this.parsers) {
            if (!parser.isMeet(basePoint)) continue;
            log.info("find a parser ,formula area({0}) meet parser({1})", new Object[]{basePoint, parser});
            return parser.parse(basePoint);
        }
        log.info("fail to parse ,formula area({0}) not meet any parsers({1})", new Object[]{basePoint, this.parsers});
        return new FormulaSchemeCollection();
    }
}

