/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.DynFormulaDefineCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.IFormulaScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class RemoveSameExtendFormulaScheme {
    private static final ILog log = LogFactory.getLog("AUTOITEM", RemoveSameExtendFormulaScheme.class);
    private DBHandler dao;

    public RemoveSameExtendFormulaScheme(DBHandler dao) {
        this.dao = dao;
    }

    public Set<String> exec(TemplateInfo template) throws BOSException, EASBizException {
        HashSet<String> ids = new HashSet<String>(1);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("template.groupTemplate");
        view.getSelector().add("itemKey");
        view.getSelector().add("itemNumber");
        view.getSelector().add("company.id");
        view.getSelector().add("dynFormulaDefine.id");
        view.getSelector().add("dynFormulaDefine.assistNum");
        view.getSelector().add("dynFormulaDefine.isLevelSum");
        view.getSelector().add("dynFormulaDefine.isLevelManualSum");
        view.getSelector().add("dynFormulaDefine.levelOrderNum");
        view.getSelector().add("dynFormulaDefine.levelName");
        view.getSelector().add("itemOffYear");
        view.getSelector().add("itemOffPeriod");
        view.getSelector().add("itemValueType");
        view.getSelector().add("itemDataType");
        view.getSelector().add("itemDynaItem");
        view.getSelector().add("isExtendValueFormula");
        view.getSelector().add("extendValueFormula.id");
        view.getSelector().add("extendValueFormula.partIndex");
        view.getSelector().add("extendValueFormula.valueFormulaPart");
        view.setFilter(new FilterInfo());
        view.getFilter().appendFilterItem("template.number", (Object)template.getNumber());
        view.getFilter().appendFilterItem("template.group", (Object)template.getGroup());
        view.getFilter().appendFilterItem("isExtendValueFormula", (Object)Boolean.TRUE);
        IFormulaScheme schemeDao = this.dao.get(IFormulaScheme.class);
        FormulaSchemeCollection schemes = schemeDao.getFormulaSchemeCollection(view);
        HashMap<String, FormulaSchemeInfo> cache = new HashMap<String, FormulaSchemeInfo>(schemes.size());
        String key = null;
        FormulaSchemeInfo previous = null;
        FormulaSchemeInfo current = null;
        for (int i = 0; i < schemes.size(); ++i) {
            current = schemes.get(i);
            key = this.generalKeyForSameItemAndValueFormula(current);
            previous = (FormulaSchemeInfo)cache.get(key);
            if (previous == null) {
                cache.put(key, current);
                continue;
            }
            if (previous.getTemplate().getGroupTemplate() == null && current.getTemplate().getGroupTemplate() != null) {
                ids.add(current.getId().toString());
                continue;
            }
            if (previous.getTemplate().getGroupTemplate() == null || current.getTemplate().getGroupTemplate() != null) continue;
            ids.add(previous.getId().toString());
            cache.put(key, current);
        }
        if (ids.isEmpty()) {
            return ids;
        }
        FilterInfo deleteFilter = new FilterInfo();
        deleteFilter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        schemeDao.delete(deleteFilter);
        return ids;
    }

    protected String generalKeyForSameItemAndValueFormula(FormulaSchemeInfo scheme) {
        StringBuffer key = new StringBuffer();
        key.append(scheme.getItemFormula());
        key.append('|');
        key.append(scheme.getValueFormula());
        key.append('|');
        DynFormulaDefineCollection defines = scheme.getDynFormulaDefine();
        for (int i = 0; i < defines.size(); ++i) {
            key.append(defines.get(i).key());
            key.append('|');
        }
        return key.toString();
    }
}

