/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.ICalcContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.SheetParam;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CalcContext
implements ICalcContext {
    public static final String CURRENCY_ID = "Currency.ID";
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", CalcContext.class);
    private static final long serialVersionUID = -9027995210400790241L;
    private Map<String, Object> contextParams = new HashMap<String, Object>();
    private ItemContext itemContext;
    private RptSrcTypeEnum sourceType;
    private Date startDate;
    private Date endDate;
    private OrgType orgType;
    private Set<SheetParam> sheetParams;
    private boolean initFinish = false;

    public CalcContext(OrgUnitInfo company, ReportBaseInfo report, CurrencyInfo currency, Set<SheetParam> sheetParams) {
        this(new ItemContext(company, currency, report.getPeriodType(), report.getYear(), report.getPeriod()), report.getSourceType(), report.getStartDate(), report.getEndDate(), sheetParams, report.getOrgType());
    }

    public CalcContext(ItemContext itemContext, RptSrcTypeEnum sourceType, Date startDate, Date endDate, Set<SheetParam> sheetParams, OrgType orgType) {
        this.sheetParams = sheetParams;
        this.itemContext = itemContext;
        this.sourceType = sourceType;
        this.startDate = startDate;
        this.endDate = endDate;
        this.orgType = orgType;
        this.initFinish = this.initProperties();
    }

    private boolean initProperties() {
        if (this.itemContext == null || this.startDate == null || this.endDate == null) {
            LOG.info("ReportProperties's itemContext={0} or startDate={1} or endDate={2} is null!", new Object[]{this.itemContext == null, this.startDate == null, this.endDate == null});
            return false;
        }
        OrgUnitInfo companyPara = this.itemContext.getCompany();
        CurrencyInfo currencyPara = this.itemContext.getCurrency();
        RptPeriodTypeEnum periodType = this.itemContext.getPeriodType();
        int year = this.itemContext.getYear();
        int period = this.itemContext.getPeriod();
        if (companyPara == null || currencyPara == null) {
            LOG.info("ReportProperties's companyPara ={0} or currencyPara={1} is null!", new Object[]{companyPara == null, currencyPara == null});
            return false;
        }
        this.contextParams.put("Company.Number", companyPara.getNumber());
        if (companyPara.getId() != null) {
            this.contextParams.put("Company.ID", companyPara.getId().toString());
        }
        if (periodType != null) {
            this.contextParams.put("PeriodType", periodType.getValue());
        }
        if (this.sourceType != null) {
            this.contextParams.put("Report.SourceType", this.sourceType.getValue());
        }
        this.contextParams.put("Report.Year", new Integer(year));
        this.contextParams.put("Report.Period", new Integer(period));
        this.contextParams.put("Currency.Number", currencyPara.getNumber());
        if (currencyPara.getId() != null) {
            this.contextParams.put(CURRENCY_ID, currencyPara.getId().toString());
        }
        this.contextParams.put("SupportAdjustPeriodData", new Integer(0));
        this.contextParams.put("Report_StartDate", this.startDate);
        this.contextParams.put("Report_EndDate", this.endDate);
        this.contextParams.put("orgType", this.orgType);
        return true;
    }

    public Object getReportProperty(String name) {
        if (!this.contextParams.containsKey(name)) {
            LOG.info("ReportProperty:{0} not be found!", new Object[]{name});
            return null;
        }
        return this.contextParams.get(name);
    }

    public void initReportProperties(IObjectValue vo, Context ctx) {
        throw new RuntimeException("eas not implement this method!");
    }

    @Override
    public Set<SheetParam> getSheetParams() {
        return this.sheetParams;
    }

    public boolean isInitFinish() {
        return this.initFinish;
    }
}

