/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.CheckCalcResult;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.FormulaCalcUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.ICalculatable;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.ParameterDao;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.ParameterType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.SheetParam;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FormulaParameter
extends Parameter {
    private static final long serialVersionUID = 7769982334112685042L;
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", FormulaParameter.class);
    protected String paramKey;
    protected String formulaName;
    protected ParameterDao parameterDao;
    protected ParameterType type;
    protected String formula;
    protected SheetParam sheetParam;
    private Collection<FormulaCalcUnit> formulaCalcUnits = new HashSet<FormulaCalcUnit>(0);
    private CheckCalcResult checkCalcResult;

    public FormulaParameter(Object[] args, SheetParam sheetParam, String paramKey, ParameterType type, String formula, String formulaName) {
        super((Object[])FormulaParameter.variant(args), sheetParam.getSheetName());
        this.paramKey = paramKey;
        this.type = type;
        this.formula = formula;
        this.formulaName = formulaName;
        this.sheetParam = sheetParam;
    }

    public Object[] getArgs() {
        Object[] args = (Variant[])super.getArgs();
        Object argObj = null;
        int size = args.length;
        for (int i = 0; i < size; ++i) {
            argObj = args[i].getValue();
            if (argObj instanceof FormulaParameter && ((FormulaParameter)((Object)argObj)).getValue() != null) {
                args[i].setObject(((FormulaParameter)((Object)argObj)).getValue());
                continue;
            }
            if (!(argObj instanceof ICalculatable)) continue;
            if (((ICalculatable)argObj).getResult() == null) {
                ((ICalculatable)argObj).setResult(new HashMap<String, Object>(0));
            }
            if (((ICalculatable)argObj).getResult() == null) continue;
            args[i].setObject(((ICalculatable)argObj).getResult());
        }
        return args;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static Variant[] variant(Object[] args) {
        if (args instanceof Variant[]) {
            return (Variant[])args;
        }
        Variant[] vars = new Variant[args.length];
        int size = args.length;
        for (int i = 0; i < size; ++i) {
            vars[i] = new Variant(args[i]);
        }
        return vars;
    }

    public void setParameterDao(ParameterDao parameterDao) {
        this.parameterDao = parameterDao;
    }

    public void directSetValue(Object result) {
        LOG.info("execute directly setValue(param:{0},result:{1})!", new Object[]{this, result});
        super.setValue(result);
        for (FormulaCalcUnit formulaCalcUnit : this.formulaCalcUnits) {
            try {
                if (this.checkCalcResult != null && formulaCalcUnit != null) {
                    if (result instanceof Variant) {
                        this.checkCalcResult.exec(((Variant)result).getValue(), formulaCalcUnit, true);
                        continue;
                    }
                    this.checkCalcResult.exec(result, formulaCalcUnit, true);
                    continue;
                }
                LOG.debug("no checkCalcResult action to run", new Object[]{this});
            }
            catch (BOSException e) {
                LOG.info("FormulaParameter's({0}) setValue occure error!", new Object[]{this});
                LOG.error("", e);
                try {
                    this.checkCalcResult.recordLog(formulaCalcUnit, e.getMessage());
                    formulaCalcUnit.setExceptionResult(true);
                }
                catch (EASBizException e1) {
                    LOG.error("", e);
                }
                catch (BOSException e1) {
                    LOG.error("", e);
                }
            }
            catch (EASBizException e) {
                LOG.info("FormulaParameter's({0}) setValue occure error!", new Object[]{this});
                LOG.error("", e);
                try {
                    this.checkCalcResult.recordLog(formulaCalcUnit, e.getMessage());
                    formulaCalcUnit.setExceptionResult(true);
                }
                catch (EASBizException e1) {
                    LOG.error("", e);
                }
                catch (BOSException e1) {
                    LOG.error("", e);
                }
            }
        }
    }

    public void setValue(Object result) {
        this.directSetValue(result);
    }

    public Object getResult(Map<String, Object> paramResults) {
        if (!paramResults.containsKey(this.paramKey)) {
            LOG.info("formula({0})'s calculate result is error.", new Object[]{this});
            return null;
        }
        return paramResults.get(this.paramKey);
    }

    public String getFormulaName() {
        return this.formulaName;
    }

    public ParameterType getType() {
        return this.type;
    }

    public void setFormulaName(String formulaName) {
        this.formulaName = formulaName;
    }

    public String getFormula() {
        return this.formula;
    }

    public String getParamKey() {
        return this.paramKey;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public SheetParam getSheetParam() {
        return this.sheetParam;
    }

    public String toString() {
        return this.getFormula() + "=" + this.getValue();
    }

    public Set<FormulaParameter> getNestedParameter() {
        HashSet<FormulaParameter> nestedParams = new HashSet<FormulaParameter>();
        Variant[] args = (Variant[])super.getArgs();
        Object argObj = null;
        int size = args.length;
        for (int i = 0; i < size; ++i) {
            argObj = args[i].getValue();
            if (!(argObj instanceof FormulaParameter) || ((FormulaParameter)((Object)argObj)).getValue() == null) continue;
            nestedParams.add((FormulaParameter)((Object)argObj));
        }
        return nestedParams;
    }

    public void setParamKey(String paramKey) {
        this.paramKey = paramKey;
    }

    public void setType(ParameterType type) {
        this.type = type;
    }

    public Object getRealValue() {
        Object value = this.getValue();
        if (value instanceof Variant) {
            return ((Variant)value).getValue();
        }
        return value;
    }

    public Collection<FormulaCalcUnit> getFormulaCalcUnits() {
        return this.formulaCalcUnits;
    }

    public void setFormulaCalcUnits(Collection<FormulaCalcUnit> formulaCalcUnits) {
        this.formulaCalcUnits = formulaCalcUnits;
    }

    public CheckCalcResult getCheckCalcResult() {
        return this.checkCalcResult;
    }

    public void setCheckCalcResult(CheckCalcResult checkCalcResult) {
        this.checkCalcResult = checkCalcResult;
    }
}

