/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.FormulaParameter;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.ICalculatable;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.IParameterable;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.ParameterDao;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.ParameterType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.SingleFormula;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GetNestedFormulaValue {
    protected ParameterDao parameterDao;
    protected Set<IParameterable> haveNestedFormulaParams = new HashSet<IParameterable>();

    public GetNestedFormulaValue(ParameterDao parameterDao) {
        this.parameterDao = parameterDao;
    }

    public void exec(ParameterType type) throws BOSException {
        if (this.haveNestedFormulaParams.isEmpty()) {
            return;
        }
        HashSet<FormulaParameter> nestedFormulas = new HashSet<FormulaParameter>();
        HashSet<FormulaParameter> combineFormulas = new HashSet<FormulaParameter>(5);
        for (IParameterable iParameterable : this.haveNestedFormulaParams) {
            nestedFormulas.addAll(iParameterable.getParameters());
            if (iParameterable.getParameter() == null) continue;
            nestedFormulas.remove((Object)iParameterable.getParameter());
            combineFormulas.add(iParameterable.getParameter());
        }
        if (nestedFormulas.isEmpty()) {
            return;
        }
        HashSet<String> formulaConditions = new HashSet<String>(nestedFormulas.size());
        for (FormulaParameter nestedFormula : nestedFormulas) {
            formulaConditions.add(nestedFormula.getFormula());
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("formula", formulaConditions, CompareType.INCLUDE));
        if (type != null && type.getContextKey() != null) {
            filterInfo.appendFilterItem("FcontextKey", (Object)type.getContextKey().serialString());
        }
        Map<String, Object> paramResults = this.parameterDao.getParameterValues(filterInfo);
        Object result = null;
        for (IParameterable param : this.haveNestedFormulaParams) {
            Variant[] args;
            if (param instanceof ICalculatable) {
                ((ICalculatable)((Object)param)).setResult(paramResults);
            }
            if (param.getParameter() == null) continue;
            for (Variant arg : args = (Variant[])param.getParameter().getArgs()) {
                if (!(arg.getValue() instanceof ICalculatable) || (result = ((ICalculatable)arg.getValue()).getResult()) == null) continue;
                arg.setObject(result);
            }
        }
    }

    public void add(SingleFormula param) {
        List<Object> args = param.getParams();
        for (Object arg : args) {
            if (!(arg instanceof IParameterable)) continue;
            this.haveNestedFormulaParams.add(param);
            return;
        }
    }

    public Set<IParameterable> getNestedFormula() {
        return this.haveNestedFormulaParams;
    }

    public void clear() {
        this.haveNestedFormulaParams.clear();
        this.haveNestedFormulaParams = new HashSet<IParameterable>();
    }
}

