/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.ctx;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextCompanyCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextTemplateCollection;
import com.kingdee.eas.fi.gr.cslrpt.IFormulaCalcContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.ctx.QueryPermissionCompany;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.CheckValidException;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.CombineCheckValidException;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import java.util.ArrayList;
import java.util.List;

public class CheckValidFormulaCalcContext {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", CheckValidFormulaCalcContext.class);
    protected DBHandler dao;

    public CheckValidFormulaCalcContext(DBHandler dao) {
        this.dao = dao;
    }

    public boolean exec(FormulaCalcContextInfo formulaCalcContext) throws CheckValidException, BOSException, EASBizException {
        ArrayList<CheckValidException> exceptions = new ArrayList<CheckValidException>();
        boolean numberIsEmpty = this.checkNumEmp(formulaCalcContext, exceptions);
        this.checkNameEmp(formulaCalcContext, exceptions);
        this.checkDescription(formulaCalcContext, exceptions);
        this.checkTempEmp(formulaCalcContext, exceptions);
        this.checkCompanyEmp(formulaCalcContext, exceptions);
        this.isNumberDup(formulaCalcContext, exceptions, numberIsEmpty);
        this.checkHasOrgCalcPerm(formulaCalcContext, exceptions);
        if (!exceptions.isEmpty()) {
            throw new CombineCheckValidException(exceptions);
        }
        return false;
    }

    private void checkHasOrgCalcPerm(FormulaCalcContextInfo formulaCalcContext, List<CheckValidException> exceptions) throws BOSException {
        FormulaCalcContextCompanyCollection companys = formulaCalcContext.getCompanys();
        ArrayList<OrgUnitInfo> checkCompanys = new ArrayList<OrgUnitInfo>(companys.size());
        int size = companys.size();
        for (int i = 0; i < size; ++i) {
            if (companys.get(i) == null || companys.get(i).getCompany() == null || companys.get(i).getCompany().getId() == null || companys.get(i) == null || companys.get(i).getCompany() == null || companys.get(i).getCompany().getId() == null) continue;
            checkCompanys.add((OrgUnitInfo)companys.get(i).getCompany());
        }
        try {
            if (!checkCompanys.isEmpty()) {
                new QueryPermissionCompany(this.dao).check(this.getCurrentUserId(), formulaCalcContext.getOrgType(), checkCompanys);
            }
        }
        catch (CheckValidException e) {
            LOG.debug("", e);
            exceptions.add(e);
        }
    }

    private void checkCompanyEmp(FormulaCalcContextInfo formulaCalcContext, List<CheckValidException> exceptions) {
        if (formulaCalcContext.getCompanys().isEmpty()) {
            exceptions.add(new CheckValidException("FormulaCalcContextInfo.companys.empty", (Object)null));
        } else {
            FormulaCalcContextCompanyCollection companys = formulaCalcContext.getCompanys();
            int size = companys.size();
            for (int i = 0; i < size; ++i) {
                if (companys.get(i) != null && companys.get(i).getCompany() != null && companys.get(i).getCompany().getId() != null) continue;
                exceptions.add(new CheckValidException("FormulaCalcContextInfo.companys.id.null", companys.get(i)));
            }
        }
    }

    private void checkTempEmp(FormulaCalcContextInfo formulaCalcContext, List<CheckValidException> exceptions) {
        if (formulaCalcContext.getTemplates().isEmpty()) {
            exceptions.add(new CheckValidException("FormulaCalcContextInfo.templates.empty", (Object)null));
        } else {
            FormulaCalcContextTemplateCollection templates = formulaCalcContext.getTemplates();
            int size = templates.size();
            for (int i = 0; i < size; ++i) {
                if (templates.get(i) != null && templates.get(i).getTemplate() != null && templates.get(i).getTemplate().getId() != null) continue;
                exceptions.add(new CheckValidException("FormulaCalcContextInfo.templates.id.null", templates.get(i) == null || templates.get(i).getTemplate() == null || templates.get(i).getTemplate().getName() == null ? null : templates.get(i).getTemplate().getName()));
            }
        }
    }

    private void checkNameEmp(FormulaCalcContextInfo formulaCalcContext, List<CheckValidException> exceptions) {
        String name = formulaCalcContext.getName();
        if (StringUtil.isEmpty((String)name)) {
            exceptions.add(new CheckValidException("FormulaCalcContextInfo.name.empty", (Object)null));
        } else if (name.length() > 255) {
            exceptions.add(new CheckValidException("FormulaCalcContextInfo.name.tooLong", (Object)null));
        }
    }

    private void checkDescription(FormulaCalcContextInfo formulaCalcContext, List<CheckValidException> exceptions) {
        String description = formulaCalcContext.getDescription();
        if (!StringUtil.isEmpty((String)description) && description.length() > 255) {
            exceptions.add(new CheckValidException("FormulaCalcContextInfo.description.tooLong", (Object)null));
        }
    }

    private boolean checkNumEmp(FormulaCalcContextInfo formulaCalcContext, List<CheckValidException> exceptions) {
        boolean numberIsEmpty = false;
        String number = formulaCalcContext.getNumber();
        if (StringUtil.isEmpty((String)number)) {
            exceptions.add(new CheckValidException("FormulaCalcContextInfo.number.empty", (Object)null));
            numberIsEmpty = true;
        } else if (number.length() > 80) {
            exceptions.add(new CheckValidException("FormulaCalcContextInfo.number.tooLong", (Object)null));
            numberIsEmpty = true;
        }
        return numberIsEmpty;
    }

    private void isNumberDup(FormulaCalcContextInfo formulaCalcContext, List<CheckValidException> exceptions, boolean numberIsEmpty) throws BOSException {
        FilterInfo filter = new FilterInfo();
        if (!numberIsEmpty) {
            filter.appendFilterItem("number", (Object)formulaCalcContext.getNumber());
            if (formulaCalcContext.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)formulaCalcContext.getId().toString(), CompareType.NOTEQUALS));
                filter.setMaskString(" #0 and #1");
            } else {
                filter.setMaskString(" #0 ");
            }
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add("periodType");
            view.getSelector().add("orgType");
            view.getSelector().add("number");
            view.setFilter(filter);
            FormulaCalcContextCollection calcCtxes = this.dao.get(IFormulaCalcContext.class).getFormulaCalcContextCollection(view);
            if (!calcCtxes.isEmpty()) {
                int size = calcCtxes.size();
                for (int i = 0; i < size; ++i) {
                    if (!formulaCalcContext.getNumber().equals(calcCtxes.get(i).getNumber())) continue;
                    exceptions.add(new CheckValidException("FormulaCalcContextInfo.existed.number", formulaCalcContext.getNumber()));
                    break;
                }
            }
        }
    }

    protected String getCurrentUserId() {
        if (this.dao.getContext() == null) {
            return SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        }
        return this.dao.getContext().getCaller().toString();
    }
}

