/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log;

import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.AbstractFormulaCalcLogInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogStatus;
import com.kingdee.eas.fi.gr.cslrpt.TemplateProcess;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.cslrpt.util.ResourceDebugUtil;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class FormulaCalcSimpleReport
implements Serializable {
    private static final long serialVersionUID = 6739146014179259888L;
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", FormulaCalcSimpleReport.class);
    private FormulaCalcLogCollection logs;
    private int failCompany;
    private int failTemplate;
    private boolean simpleReport = false;
    private List<String> templateOrder;

    public FormulaCalcSimpleReport(FormulaCalcLogCollection logs) {
        this.logs = logs;
    }

    public FormulaCalcSimpleReport(FormulaCalcLogCollection logsForPara, int failCompany, int failTemplate, List<String> templateOrder) {
        this.logs = logsForPara;
        this.failCompany = failCompany;
        this.failTemplate = failTemplate;
        this.simpleReport = true;
        this.templateOrder = templateOrder;
        if (logsForPara == null) {
            this.logs = new FormulaCalcLogCollection();
        }
        LOG.info("failC:{0},failT:{1},Logs count:{2},Logs:{3}", new Object[]{failCompany, failTemplate, this.logs.size(), this.logs});
    }

    public String simpleFormat() {
        if (this.logs.isEmpty() || FormulaCalcLogStatus.READY.equals((Object)this.logs.get(0).getStatus())) {
            return MessageFormat.format(ResourceDebugUtil.res("what.is.status"), FormulaCalcLogStatus.READY.getAlias());
        }
        AbstractFormulaCalcLogInfo headLog = null;
        HashSet<String> failCompanyIds = new HashSet<String>();
        HashSet<String> failTemplateIds = new HashSet<String>();
        HashSet<Integer> totalStatus = new HashSet<Integer>();
        totalStatus.add(0);
        totalStatus.add(1);
        totalStatus.add(4);
        int size = this.logs.size();
        for (int i = 0; i < size; ++i) {
            if (totalStatus.contains(this.logs.get(i).getStatus().getValue())) {
                headLog = this.logs.get(i);
                if (!this.simpleReport) continue;
                break;
            }
            if (this.simpleReport) break;
            if (!FormulaCalcLogStatus.FAILURE.equals((Object)this.logs.get(i).getStatus())) continue;
            failCompanyIds.add(this.logs.get(i).getCompany().getId().toString());
            failTemplateIds.add(this.logs.get(i).getTemplate().getId().toString());
        }
        if (!this.simpleReport) {
            this.failCompany = failCompanyIds.size();
            this.failTemplate = failTemplateIds.size();
        }
        if (headLog == null) {
            return null;
        }
        FormulaCalcLogStatus logStatus = headLog.getStatus();
        Timestamp startTime = headLog.getCreateTime();
        String displayStartTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(startTime);
        if (FormulaCalcLogStatus.FINISH.equals((Object)logStatus)) {
            double time = (double)(headLog.getLastUpdateTime().getTime() - headLog.getCreateTime().getTime()) * 0.001;
            if (this.failCompany + this.failTemplate == 0) {
                return MessageFormat.format(ResourceDebugUtil.res("what.is.status.and.detail.with.format"), new Object[]{logStatus, displayStartTime, time});
            }
            return MessageFormat.format(ResourceDebugUtil.res("what.is.status.and.detail.when.failing.with.format"), new Object[]{logStatus, this.failCompany, this.failTemplate, displayStartTime, time});
        }
        return MessageFormat.format(ResourceDebugUtil.res("what.is.status.and.detail.when.processing.with.format"), new Object[]{displayStartTime, logStatus, ""});
    }

    public List<FormulaCalcLogInfo> detailFormat(final boolean isFromAutoItem) {
        if (this.logs.isEmpty() || FormulaCalcLogStatus.READY.equals((Object)this.logs.get(0).getStatus())) {
            return new ArrayList<FormulaCalcLogInfo>();
        }
        HashSet<Integer> totalStatus = new HashSet<Integer>();
        totalStatus.add(0);
        totalStatus.add(1);
        if (this.logs.size() != 1 || this.logs.get(0).getStatus().getValue() != 4) {
            totalStatus.add(4);
        }
        FormulaCalcLogInfo headLog = null;
        FormulaCalcLogInfo insertTemplateHeadLog = null;
        HashSet<String> templateNumbers = new HashSet<String>();
        ArrayList<FormulaCalcLogInfo> reportLogs = new ArrayList<FormulaCalcLogInfo>();
        TemplateProcess templateProcess = null;
        HashMap<String, FormulaCalcLogInfo> parentLog = new HashMap<String, FormulaCalcLogInfo>();
        if (this.logs.size() == 1 && this.logs.get(0).getStatus().getValue() == 4) {
            insertTemplateHeadLog = (FormulaCalcLogInfo)this.logs.get(0).clone();
            FullOrgUnitInfo orgForRpt = new FullOrgUnitInfo();
            orgForRpt.setName("");
            insertTemplateHeadLog.setCompany(orgForRpt);
            TemplateInfo tepForRpt = new TemplateInfo();
            tepForRpt.setName("");
            insertTemplateHeadLog.setTemplate(tepForRpt);
            reportLogs.add(insertTemplateHeadLog);
            return reportLogs;
        }
        int size = this.logs.size();
        for (int i = 0; i < size; ++i) {
            if (totalStatus.contains(this.logs.get(i).getStatus().getValue())) {
                headLog = this.logs.get(i);
                templateProcess = headLog.getTemplatesProcess();
                continue;
            }
            if (!templateNumbers.contains(this.logs.get(i).getTemplate().getNumber())) {
                insertTemplateHeadLog = (FormulaCalcLogInfo)this.logs.get(i).clone();
                insertTemplateHeadLog.setCompany(null);
                insertTemplateHeadLog.setDescription(null);
                insertTemplateHeadLog.setInt("processing", 0);
                reportLogs.add(insertTemplateHeadLog);
                templateNumbers.add(this.logs.get(i).getTemplate().getNumber());
                parentLog.put(this.logs.get(i).getTemplate().getNumber(), insertTemplateHeadLog);
            } else {
                insertTemplateHeadLog = (FormulaCalcLogInfo)parentLog.get(this.logs.get(i).getTemplate().getNumber());
            }
            reportLogs.add(this.logs.get(i));
            this.setTemplateWholeStatus(insertTemplateHeadLog, this.logs.get(i).getStatus());
        }
        Collections.sort(reportLogs, (Comparator)new Comparator<FormulaCalcLogInfo>(){

            @Override
            public int compare(FormulaCalcLogInfo o1, FormulaCalcLogInfo o2) {
                if (isFromAutoItem) {
                    if (o1.getTemplate().getNumber().equals(o2.getTemplate().getNumber())) {
                        if (o1.getCompany() == null) {
                            return -1;
                        }
                        if (o2.getCompany() == null) {
                            return 1;
                        }
                        return o1.getCompany().getNumber().compareTo(o2.getCompany().getNumber());
                    }
                    return FormulaCalcSimpleReport.this.templateOrder.indexOf(o1.getTemplate().getNumber()) > FormulaCalcSimpleReport.this.templateOrder.indexOf(o2.getTemplate().getNumber()) ? 1 : -1;
                }
                if (o1.getCompany() == null) {
                    return -1;
                }
                if (o2.getCompany() == null) {
                    return 1;
                }
                if (o1.getCompany().getNumber().equals(o2.getCompany().getNumber())) {
                    if (o1.getTemplate() == null) {
                        return -1;
                    }
                    if (o2.getTemplate() == null) {
                        return 1;
                    }
                    return FormulaCalcSimpleReport.this.templateOrder.indexOf(o1.getTemplate().getNumber()) > FormulaCalcSimpleReport.this.templateOrder.indexOf(o2.getTemplate().getNumber()) ? 1 : -1;
                }
                return o1.getCompany().getNumber().compareTo(o2.getCompany().getNumber());
            }
        });
        return reportLogs;
    }

    private void setTemplateWholeStatus(FormulaCalcLogInfo headLog, FormulaCalcLogStatus logStatus) {
        if (!headLog.containsKey("failureNum")) {
            headLog.put("failureNum", 0);
        }
        if (!headLog.containsKey("successNum")) {
            headLog.put("successNum", 0);
        }
        if (FormulaCalcLogStatus.FAILURE.equals((Object)logStatus)) {
            headLog.put("failureNum", (Integer)headLog.get("failureNum") + 1);
        } else if (FormulaCalcLogStatus.SUCCESS.equals((Object)logStatus)) {
            headLog.put("successNum", (Integer)headLog.get("successNum") + 1);
        }
        if (logStatus.equals((Object)headLog.getStatus())) {
            return;
        }
        if (headLog.getStatus() == null) {
            headLog.setStatus(logStatus);
            return;
        }
        headLog.setStatus(FormulaCalcLogStatus.PARTFAILURE);
    }

    public int totalProcessPercent() {
        if (this.logs.isEmpty() || FormulaCalcLogStatus.READY.equals((Object)this.logs.get(0).getStatus())) {
            return 0;
        }
        HashSet<Integer> totalStatus = new HashSet<Integer>();
        totalStatus.add(0);
        totalStatus.add(1);
        totalStatus.add(4);
        int size = this.logs.size();
        for (int i = 0; i < size; ++i) {
            if (!totalStatus.contains(this.logs.get(i).getStatus().getValue())) continue;
            int precent = this.logs.get(i).getTemplatesProcess().totalProcessPrecent();
            if (precent == 100 && 4 != this.logs.get(i).getStatus().getValue()) {
                return 99;
            }
            return precent;
        }
        return 0;
    }
}

