/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log;

import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import java.util.Map;

public class StatusDescription {
    public static String format = "{currentCalcFlag},{levelPartSize}/{preLevelSize}/{levelSize},{calcUnitCountBeforeThis}";
    public static String oldFormat = "{currentCalcFlag}";
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", StatusDescription.class);
    private String currentCalcFlag;
    private int levelPartSize;
    private int preLevelSize;
    private int levelSize;
    private int calcUnitCountBeforeThis;

    public StatusDescription(String desc) {
        this.parse(desc);
    }

    private void parse(String desc) {
        Map<String, String> values = StringUtil.parse(format, desc);
        if (values.isEmpty()) {
            values = StringUtil.parse(oldFormat, desc);
        }
        if (values.isEmpty()) {
            LOG.error("", new Exception("no matched string for format!"));
            return;
        }
        this.currentCalcFlag = values.get("currentCalcFlag");
        if (!values.containsKey("levelPartSize")) {
            return;
        }
        this.levelPartSize = Integer.parseInt(values.get("levelPartSize"));
        this.preLevelSize = Integer.parseInt(values.get("preLevelSize"));
        this.levelSize = Integer.parseInt(values.get("levelSize"));
        this.calcUnitCountBeforeThis = Integer.parseInt(values.get("calcUnitCountBeforeThis"));
    }

    public String getCurrentCalcFlag() {
        return this.currentCalcFlag;
    }

    public int getLevelPartSize() {
        return this.levelPartSize;
    }

    public int getPreLevelSize() {
        return this.preLevelSize;
    }

    public int getLevelSize() {
        return this.levelSize;
    }

    public int getCalcUnitCountBeforeThis() {
        return this.calcUnitCountBeforeThis;
    }
}

