/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogStatus;
import com.kingdee.eas.fi.gr.cslrpt.IFormulaCalcLog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.IBatchLogTask;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SuccessLogTask
implements IBatchLogTask<SuccessLogTask> {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", SuccessLogTask.class);
    private FormulaCalcContextInfo calcContext;
    private String executeTaskId;
    private TemplateInfo template;
    private OrgUnitInfo company;
    private String description;
    private String itemKey;
    private IFormulaCalcLog formulaCalcLogDao;
    FormulaCalcLogInfo successLogInfo = new FormulaCalcLogInfo();
    private List<SuccessLogTask> batchTasks = new ArrayList<SuccessLogTask>(10);

    @Override
    public void run() {
        this.successLogInfo.setExecuteTaskId(this.executeTaskId);
        this.successLogInfo.setContext(this.calcContext);
        this.successLogInfo.setTemplate(this.template);
        if (this.company != null) {
            this.successLogInfo.setCompany(this.company.castToFullOrgUnitInfo());
        } else {
            this.successLogInfo.setCompany(null);
        }
        this.successLogInfo.setStatus(FormulaCalcLogStatus.SUCCESS);
        if (this.description == null || this.description.length() < 200) {
            this.successLogInfo.setDescription(this.description);
        } else {
            LOG.error("too long description:{0}", new Object[]{this.description});
            this.successLogInfo.setDescription(this.description.substring(0, 200));
        }
        if (this.itemKey == null || this.itemKey.length() < 80) {
            this.successLogInfo.setItemKey(this.itemKey);
        } else {
            LOG.error("too long description:{0}", new Object[]{this.description});
            this.successLogInfo.setItemKey(this.itemKey.substring(0, 80));
        }
    }

    @Override
    public void batchRun() {
        CoreBaseCollection infos = new CoreBaseCollection();
        HashMap<String, FormulaCalcLogInfo> excludeDup = new HashMap<String, FormulaCalcLogInfo>();
        String key = null;
        FormulaCalcLogInfo info = null;
        for (SuccessLogTask log : this.batchTasks) {
            log.run();
            info = log.getSuccessLogInfo();
            key = info.getContext().getId().toString() + "," + info.getTemplate().getNumber() + "," + info.getCompany().getId().toString() + "," + info.getItemKey() + "," + info.getStatus().getValue();
            excludeDup.put(key, info);
        }
        for (FormulaCalcLogInfo infoWithoutDup : excludeDup.values()) {
            infos.add((CoreBaseInfo)infoWithoutDup);
        }
        try {
            this.formulaCalcLogDao.addnewBatchData(infos);
        }
        catch (EASBizException e) {
            LOG.error("", e);
        }
        catch (BOSException e) {
            LOG.error("", e);
        }
    }

    public FormulaCalcLogInfo getSuccessLogInfo() {
        return this.successLogInfo;
    }

    public void setParams(String executeTaskId, FormulaCalcContextInfo calcContext, TemplateInfo template, OrgUnitInfo company, String description, String itemKey, IFormulaCalcLog formulaCalcLogDao) {
        this.executeTaskId = executeTaskId;
        this.calcContext = calcContext;
        this.template = template;
        this.company = company;
        this.description = description;
        this.itemKey = itemKey;
        this.formulaCalcLogDao = formulaCalcLogDao;
    }

    @Override
    public void addBatchTask(SuccessLogTask task) {
        this.batchTasks.add(task);
    }
}

