/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.DynFormulaDefineInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.CreateFormulaScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.IBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.DynaBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.IImportOtherHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.IInfoHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.NormalInfoHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class DynaBaseFillInfoHandler
implements IInfoHandler<FormulaSchemeInfo>,
IImportOtherHandler<FormulaSchemeInfo> {
    private static final ILog log = LogFactory.getLog("AUTOITEM", DynaBaseFillInfoHandler.class);
    final Collection<FormulaSchemeInfo> schemes = new ArrayList<FormulaSchemeInfo>();
    private DBHandler dao;
    private IBasePoint basePoint;

    public DynaBaseFillInfoHandler(DBHandler dao, IBasePoint basePoint) {
        this.dao = dao;
        this.basePoint = basePoint;
    }

    @Override
    public Collection<FormulaSchemeInfo> infos() {
        return this.schemes;
    }

    @Override
    public boolean checkItemFormula(ItemFormula itemFormula) {
        return itemFormula != null && itemFormula.getFormula() != null;
    }

    @Override
    public boolean checkValueFormula(String valueItemFormula) {
        return !StringUtils.isEmpty((String)valueItemFormula);
    }

    @Override
    public void put(ItemFormula itemFormula, String valueFormula, Cell valueFormulaCell, Map<?, ?> others) {
        DynaBasePoint dynaBasePoint = (DynaBasePoint)this.basePoint;
        DynaParameters dynaParam = dynaBasePoint.getDynaParam();
        FormulaSchemeInfo scheme = this.create(valueFormulaCell, itemFormula, dynaParam);
        if (scheme == null) {
            return;
        }
        if (scheme.getValueFormula() != null && scheme.getValueFormula().indexOf("@") == -1) {
            return;
        }
        log.info("find a scheme:{0}", new Object[]{scheme});
        scheme.setEnvParam(this.basePoint.getEnvParam());
        this.schemes.add(scheme);
    }

    private FormulaSchemeInfo create(Cell valueFormulaCell, ItemFormula itemFormula, DynaParameters dynaParam) {
        FormulaSchemeInfo scheme;
        try {
            scheme = new CreateFormulaScheme(this.dao).by(valueFormulaCell, itemFormula);
            if (scheme == null) {
                return null;
            }
        }
        catch (EASBizException e) {
            log.error("", e);
            return null;
        }
        catch (BOSException e) {
            log.error("", e);
            return null;
        }
        DynFormulaDefineInfo dynDefineInfo = new DynFormulaDefineInfo();
        dynDefineInfo.setFormulaScheme(scheme);
        dynDefineInfo.setAssistNum(dynaParam.getAssistantType().getProperityName());
        dynDefineInfo.setAssistName(dynaParam.getAssistantType().getProperityAlias());
        dynDefineInfo.setIsLevelManualSum(false);
        dynDefineInfo.setIsLevelSum(dynaParam.isGrade());
        scheme.getDynFormulaDefine().add(dynDefineInfo);
        scheme.setDynaAsstType(dynaParam.getAssistantType().getProperityName());
        return scheme;
    }

    @Override
    public IInfoHandler<FormulaSchemeInfo> other(String key) {
        if ("normal".equals(key)) {
            return new NormalInfoHandler(this.dao, this.basePoint);
        }
        return null;
    }
}

